/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.unit;

import com.jrockit.mc.common.unit.BinaryPrefix;
import com.jrockit.mc.common.unit.BinaryScaleFactor;
import com.jrockit.mc.common.unit.DecimalPrefix;
import com.jrockit.mc.common.unit.DecimalScaleFactor;
import com.jrockit.mc.common.unit.DisplayUnit;
import com.jrockit.mc.common.unit.IPrefix;
import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.ImpreciseScaleFactor;
import com.jrockit.mc.common.unit.KindOfQuantity;
import com.jrockit.mc.common.unit.LinearQuantity;
import com.jrockit.mc.common.unit.LinearUnit;
import com.jrockit.mc.common.unit.LongScaleFactor;
import com.jrockit.mc.common.unit.QuantityConversionException;
import com.jrockit.mc.common.unit.ScaleFactor;
import com.jrockit.mc.common.unit.UnitLookup;
import com.jrockit.mc.common.util.FormatThreadLocal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LinearKindOfQuantity
extends KindOfQuantity<LinearQuantity> {
    private static final FormatThreadLocal<NumberFormat> NUMBER_FORMAT_INTERACTIVE_HOLDER;
    private static final FormatThreadLocal<NumberFormat> NUMBER_FORMAT_DISPLAY_HOLDER;
    protected final LinearUnit atomUnit;
    protected final String atomUnitName;
    private LinearUnit legacyUnit;
    protected final Collection<LinearUnit> commonUnits = new TreeSet<LinearUnit>();
    protected final Collection<LinearUnit> allUnits = new TreeSet<LinearUnit>();
    protected final Map<String, LinearUnit> interactiveSymbolToUnitMap = new HashMap<String, LinearUnit>();
    protected IUnit.UnitSelector<LinearQuantity, LinearUnit> unitSelector;
    protected final Map<Object, LinearUnit> unitCache = new HashMap<Object, LinearUnit>();
    private static final Pattern NUMBER_UNIT_PATTERN;

    static {
        NumberFormat formatter = NumberFormat.getNumberInstance();
        formatter.setMaximumFractionDigits(340);
        NUMBER_FORMAT_DISPLAY_HOLDER = new FormatThreadLocal<NumberFormat>(formatter);
        if (formatter instanceof DecimalFormat) {
            DecimalFormatSymbols symbols = ((DecimalFormat)formatter).getDecimalFormatSymbols();
            if (symbols.getGroupingSeparator() == '\u00a0') {
                symbols.setGroupingSeparator(' ');
            }
            ((DecimalFormat)formatter).setDecimalFormatSymbols(symbols);
        }
        NUMBER_FORMAT_INTERACTIVE_HOLDER = new FormatThreadLocal<NumberFormat>(formatter);
        NUMBER_UNIT_PATTERN = Pattern.compile("^(-?\\d+)(\\.?\\d*(?:E-?\\d+)?)\\s*([a-zA-Z%]*)$");
    }

    public static NumberFormat getNumberFormat(boolean interactive) {
        return interactive ? (NumberFormat)NUMBER_FORMAT_INTERACTIVE_HOLDER.get() : (NumberFormat)NUMBER_FORMAT_DISPLAY_HOLDER.get();
    }

    public LinearKindOfQuantity(String id, String atomUnitId) {
        this(id, DecimalPrefix.NONE, atomUnitId, EnumSet.of(DecimalPrefix.NONE));
    }

    public <P extends Enum<P>> LinearKindOfQuantity(String id, String atomUnitId, P minPrefix, P maxPrefix) {
        this(id, minPrefix, atomUnitId, (Collection<P>)EnumSet.range(minPrefix, maxPrefix));
    }

    public <P extends IPrefix<P>> LinearKindOfQuantity(String id, P legacyPrefix, String atomUnitId, Collection<P> prefixes) {
        this(id, legacyPrefix, atomUnitId, prefixes, prefixes);
    }

    public <P extends IPrefix<P>> LinearKindOfQuantity(String id, P legacyPrefix, String atomUnitId, Collection<P> commonPrefixes, Collection<P> allPrefixes) {
        super(id);
        String unitSymbol = this.resolveLocalizedSymbol(DecimalPrefix.NONE, atomUnitId, atomUnitId);
        this.atomUnitName = this.resolveLocalizedName(DecimalPrefix.NONE, atomUnitId, null);
        String appendableUnitSymbol = unitSymbol.length() == 0 ? "" : "\u00a0" + unitSymbol;
        this.atomUnit = this.atomUnitName != null ? new LinearUnit(this, atomUnitId, DecimalScaleFactor.get(0), unitSymbol, "1" + appendableUnitSymbol + " (= 1\u00a0" + this.atomUnitName + ')', this.atomUnitName) : new LinearUnit(this, atomUnitId, DecimalScaleFactor.get(0), unitSymbol, "1" + appendableUnitSymbol, new String[0]);
        this.legacyUnit = this.getUnit((IPrefix<?>)legacyPrefix);
        for (IPrefix prefix : allPrefixes) {
            LinearUnit unit = this.getUnit(prefix);
            this.addUnit(unit, commonPrefixes.contains(prefix));
        }
        this.unitSelector = legacyPrefix.createUnitSelector(this, allPrefixes);
    }

    protected void setDefaultSelector(IUnit.UnitSelector<LinearQuantity, LinearUnit> unitSelector) {
        this.unitSelector = unitSelector;
    }

    protected void setLegacyImplicitUnit(LinearUnit newLegacyUnit) {
        if (this.legacyUnit.compareTo(newLegacyUnit) == 0) {
            this.legacyUnit = newLegacyUnit;
        }
    }

    @Deprecated
    public LinearUnit getLegacyImplicitUnit() {
        return this.legacyUnit;
    }

    public LinearUnit getDefaultUnit() {
        return this.atomUnit;
    }

    protected String resolveLocalizedName(IPrefix<?> prefix) {
        return this.resolveLocalizedName(prefix, this.atomUnit.getIdentifier(), this.atomUnitName);
    }

    protected String resolveLocalizedSymbol(IPrefix<?> prefix) {
        return this.resolveLocalizedSymbol(prefix, this.atomUnit.getIdentifier(), this.atomUnit.getLocalizedSymbol());
    }

    public LinearUnit getUnit(IPrefix<?> prefix) {
        LinearUnit unit = this.getCachedUnit(prefix);
        if (unit == null) {
            if (prefix.scaleFactor().isUnity()) {
                this.unitCache.put(prefix, this.atomUnit);
                return this.atomUnit;
            }
            String id = String.valueOf(prefix.identifier()) + this.atomUnit.getIdentifier();
            String symbol = this.resolveLocalizedSymbol(prefix);
            String name = this.resolveLocalizedName(prefix);
            StringBuilder descBuf = new StringBuilder("1\u00a0");
            descBuf.append(symbol);
            if (name != null) {
                descBuf.append(" (= 1\u00a0");
                descBuf.append(name);
                descBuf.append(" = ");
            } else {
                descBuf.append(" (= ");
            }
            descBuf.append((CharSequence)prefix.asExponentialStringBuilder(false));
            descBuf.append(this.atomUnit.getAppendableSuffix(false));
            if (prefix instanceof BinaryPrefix) {
                BinaryPrefix binPrefix = (BinaryPrefix)prefix;
                DecimalPrefix prefixSI = binPrefix.prefixSI;
                String altSymbol = this.resolveLocalizedSymbol(prefixSI);
                String altName = this.resolveLocalizedName(prefixSI);
                descBuf.append(" \u2248 1\u00a0");
                descBuf.append(altSymbol);
                if (altName != null) {
                    descBuf.append(" = 1\u00a0");
                    descBuf.append(altName);
                }
                descBuf.append(" = ");
                descBuf.append((CharSequence)prefixSI.asExponentialStringBuilder(false));
                descBuf.append(this.atomUnit.getAppendableSuffix(false));
                descBuf.append(')');
                unit = altName != null ? new LinearUnit(this, id, prefix.scaleFactor(), symbol, descBuf.toString(), name, altSymbol, altName) : new LinearUnit(this, id, prefix.scaleFactor(), symbol, descBuf.toString(), name, altSymbol);
            } else if (prefix.altSymbol() != null) {
                String altSymbol = String.valueOf(prefix.altSymbol()) + this.atomUnit.getLocalizedSymbol();
                descBuf.append(')');
                unit = new LinearUnit(this, id, prefix.scaleFactor(), symbol, descBuf.toString(), name, altSymbol);
            } else {
                descBuf.append(')');
                unit = new LinearUnit(this, id, prefix.scaleFactor(), symbol, descBuf.toString(), name);
            }
            this.unitCache.put(prefix, unit);
        }
        return unit;
    }

    public LinearUnit getUnit(String id) {
        return (LinearUnit)super.getUnit(id);
    }

    public LinearUnit getCachedUnit(Object key) {
        return this.unitCache.get(key);
    }

    protected ScaleFactor getBestScaleFactorFor(long value) {
        int log2 = BinaryPrefix.getFloorLog2(value);
        if ((long)(1 << log2) == value) {
            return BinaryScaleFactor.get(log2);
        }
        DecimalScaleFactor factor = DecimalScaleFactor.getSciFloorFactor(value);
        long mult = (long)factor.getMultiplier();
        if (mult == value) {
            return factor;
        }
        return new LongScaleFactor(value);
    }

    public LinearUnit makeUnit(String id, LinearQuantity quantity) {
        return this.makeUnit(id, id, quantity, null, false);
    }

    public LinearUnit makeUnit(String id, LinearQuantity quantity, String localizedName) {
        return this.makeUnit(id, id, quantity, localizedName, false);
    }

    public LinearUnit makeCustomUnit(LinearQuantity quantity) {
        if (quantity instanceof LinearQuantity.LongStored && quantity.longValue() == 1L) {
            return quantity.getUnit();
        }
        String id = quantity.persistableString();
        String symbol = "\u00d7" + quantity.localizedFormat(false, false);
        return this.makeUnit(id, symbol, quantity, null, true);
    }

    public LinearUnit makeUnit(String id, String localizedSymbol, LinearQuantity quantity, String localizedName, boolean custom) {
        LinearUnit oldUnit;
        String[] altNames;
        ScaleFactor factorToAtom;
        ScaleFactor factorToDefinition;
        String relStr;
        String symbol = this.resolveLocalizedSymbol(DecimalPrefix.NONE, id, localizedSymbol);
        String name = this.resolveLocalizedName(DecimalPrefix.NONE, id, localizedName);
        boolean isFactor = symbol.startsWith("\u00d7");
        StringBuilder descBuf = new StringBuilder();
        if (!isFactor) {
            if (symbol.length() == 0) {
                descBuf.append('1');
            } else {
                descBuf.append("1\u00a0");
                descBuf.append(symbol);
            }
            if (name != null) {
                descBuf.append(" (= 1\u00a0");
                descBuf.append(name);
                descBuf.append(" = ");
            } else {
                descBuf.append(" (= ");
            }
        }
        if (quantity instanceof LinearQuantity.LongStored) {
            descBuf.append(quantity.localizedFormat(false, false));
            relStr = " = ";
            factorToDefinition = this.getBestScaleFactorFor(quantity.longValue());
            factorToAtom = quantity.getUnit().valueFactorTo(this.atomUnit).chain(factorToDefinition);
        } else {
            descBuf.append(AutoFormatter.formatInUnit(quantity, quantity.getUnit(), 3));
            relStr = " \u2248 ";
            factorToDefinition = new ImpreciseScaleFactor(quantity.doubleValue());
            factorToAtom = new ImpreciseScaleFactor(quantity.doubleValueIn(this.atomUnit));
        }
        if (!this.atomUnit.equals(quantity.getUnit())) {
            descBuf.append(relStr);
            descBuf.append(AutoFormatter.formatInUnit(quantity, this.atomUnit, 3));
        }
        if (!isFactor) {
            descBuf.append(')');
        }
        if (isFactor) {
            String qStr = quantity.interactiveFormat();
            String suffix = quantity.getUnit().getAppendableSuffix(true);
            if (suffix.startsWith(" ")) {
                String trimmed = qStr.replace(suffix, quantity.getUnit().getLocalizedSymbol());
                String[] names = new String[]{"\u00d7" + qStr, "x" + qStr, "\u00d7" + trimmed, "x" + trimmed};
                altNames = names;
            } else {
                String[] names = new String[]{"\u00d7" + qStr, "x" + qStr};
                altNames = names;
            }
        } else if (name != null) {
            String[] names = new String[]{name};
            altNames = names;
        } else {
            altNames = new String[]{};
        }
        LinearUnit unit = custom ? new LinearUnit.Custom(this, id, factorToDefinition, quantity.getUnit(), symbol, descBuf.toString(), altNames) : new LinearUnit(this, id, factorToAtom, symbol, descBuf.toString(), altNames);
        if (id != null && (oldUnit = this.unitCache.put(id, unit)) != null) {
            UnitLookup.getLogger().log(Level.FINE, "Replaced cached unit " + oldUnit + " with " + unit);
        }
        return unit;
    }

    public String toString() {
        return this.getIdentifier();
    }

    public LinearUnit getPreferredUnit(LinearQuantity quantity, double minNumericalValue, double maxNumericalValue) {
        return this.unitSelector.getPreferredUnit(quantity, minNumericalValue, maxNumericalValue);
    }

    @Override
    public LinearQuantity parsePersisted(String persistedQuantity) throws QuantityConversionException {
        Matcher m = NUMBER_UNIT_PATTERN.matcher(persistedQuantity.trim());
        if (m.matches()) {
            LinearUnit unit = this.getUnit(m.group(3));
            if (unit != null) {
                try {
                    if (m.group(2).length() == 0) {
                        return unit.quantity(Long.parseLong(m.group(1)));
                    }
                    return unit.quantity(Double.parseDouble(String.valueOf(m.group(1)) + m.group(2)));
                }
                catch (RuntimeException runtimeException) {}
            } else {
                if (m.group(3).length() == 0) {
                    throw QuantityConversionException.noUnit(persistedQuantity, this.getDefaultUnit().quantity(1234.0));
                }
                throw QuantityConversionException.unknownUnit(persistedQuantity, this.getDefaultUnit().quantity(1234.0));
            }
        }
        throw QuantityConversionException.unparsable(persistedQuantity, this.getDefaultUnit().quantity(1234.0));
    }

    @Override
    public Collection<LinearUnit> getAllUnits() {
        return this.allUnits;
    }

    @Override
    public Collection<LinearUnit> getCommonUnits() {
        return this.commonUnits;
    }

    @Override
    protected void addUnit(IUnit<LinearQuantity> unit) {
        this.addUnit((LinearUnit)unit, true);
    }

    protected void addUnit(LinearUnit unit, boolean common) {
        super.addUnit(unit);
        this.allUnits.add(unit);
        if (common) {
            this.commonUnits.add(unit);
        }
        this.interactiveSymbolToUnitMap.put(unit.getIdentifier(), unit);
        this.interactiveSymbolToUnitMap.put(unit.getLocalizedSymbol().replace('\u00a0', ' '), unit);
    }

    @Override
    public LinearQuantity parseInteractive(String interactiveQuantity) throws QuantityConversionException {
        return this.parseInteractive(interactiveQuantity, null);
    }

    public LinearQuantity parseInteractive(String interactiveQuantity, Map<String, ? extends LinearUnit> symbolToUnitMap) throws QuantityConversionException {
        ParsePosition pos;
        interactiveQuantity = interactiveQuantity.replace('\u00a0', ' ');
        NumberFormat formatter = (NumberFormat)NUMBER_FORMAT_INTERACTIVE_HOLDER.get();
        Number num = formatter.parse(interactiveQuantity, pos = new ParsePosition(0));
        if (num != null) {
            String rest = interactiveQuantity.substring(pos.getIndex()).trim();
            LinearUnit unit = this.interactiveSymbolToUnitMap.get(rest);
            if (unit == null && symbolToUnitMap != null) {
                unit = symbolToUnitMap.get(rest);
            }
            if (unit == null) {
                if (rest.length() == 0) {
                    throw QuantityConversionException.noUnit(interactiveQuantity, this.getDefaultUnit().quantity(num));
                }
                if (rest.contains(" ") && !rest.startsWith("\u00d7")) {
                    throw QuantityConversionException.unparsable(rest, this.getDefaultUnit().quantity(num));
                }
                throw QuantityConversionException.unknownUnit(rest, this.getDefaultUnit().quantity(num));
            }
            return unit.quantity(num);
        }
        throw QuantityConversionException.unparsable(interactiveQuantity, this.getDefaultUnit().quantity(1234.0));
    }

    public static class AutoFormatter
    extends DisplayUnit<LinearQuantity> {
        protected final double minNumericalValue;
        protected final double maxNumericalValue;
        protected final int nominalValueDigits;

        protected AutoFormatter(LinearKindOfQuantity kindOfQuantity, String name) {
            this(kindOfQuantity, "auto", name, 1.0, 1000.0, 3);
        }

        protected AutoFormatter(LinearKindOfQuantity kindOfQuantity, String name, double minNumericalValue, double maxNumericalValue) {
            this(kindOfQuantity, "auto", name, minNumericalValue, maxNumericalValue, 3);
        }

        protected AutoFormatter(LinearKindOfQuantity kindOfQuantity, String id, String name, double minNumericalValue, double maxNumericalValue, int nominalValueDigits) {
            super(kindOfQuantity, id, name);
            this.minNumericalValue = minNumericalValue;
            this.maxNumericalValue = maxNumericalValue;
            this.nominalValueDigits = nominalValueDigits;
        }

        public LinearKindOfQuantity getContentType() {
            return (LinearKindOfQuantity)super.getContentType();
        }

        @Override
        public String format(LinearQuantity quantity) {
            LinearUnit preferredUnit = this.getContentType().getPreferredUnit(quantity, this.minNumericalValue, this.maxNumericalValue);
            return AutoFormatter.formatInUnit(quantity, preferredUnit, this.nominalValueDigits);
        }

        public static String formatInUnit(LinearQuantity quantity, LinearUnit customUnit, int nominalValueDigits) {
            return AutoFormatter.formatWithUnit(quantity.doubleValueIn(customUnit), customUnit, nominalValueDigits);
        }

        protected static String formatWithUnit(double numValue, LinearUnit customUnit, int nominalValueDigits) {
            NumberFormat formatter = NumberFormat.getNumberInstance();
            int intDigits = DecimalPrefix.getFloorLog10(numValue) + 1;
            formatter.setMaximumFractionDigits(nominalValueDigits - intDigits);
            return String.valueOf(formatter.format(numValue)) + customUnit.getAppendableSuffix(false);
        }
    }

    public static class DualUnitFormatter
    extends DisplayUnit<LinearQuantity> {
        private static final double PRECISION_LIMIT = 9.094947017729282E-13;
        private final IUnit.UnitSelector<LinearQuantity, LinearUnit> unitSelector;

        protected DualUnitFormatter(LinearKindOfQuantity kindOfQuantity, String id, String name) {
            this(kindOfQuantity, id, name, null);
        }

        protected DualUnitFormatter(LinearKindOfQuantity kindOfQuantity, String id, String name, IUnit.UnitSelector<LinearQuantity, LinearUnit> unitSelector) {
            super(kindOfQuantity, id, name);
            this.unitSelector = unitSelector;
        }

        private IUnit.UnitSelector<LinearQuantity, LinearUnit> getSelector() {
            return this.unitSelector != null ? this.unitSelector : ((LinearKindOfQuantity)this.getContentType()).unitSelector;
        }

        @Override
        public String format(LinearQuantity quantity) {
            double valueInBigs;
            IUnit.UnitSelector<LinearQuantity, LinearUnit> selector = this.getSelector();
            LinearUnit bigUnit = selector.getPreferredUnit(quantity, 1.0, 1000.0);
            if (bigUnit.getIdentifier() == null) {
                return AutoFormatter.formatInUnit(quantity, bigUnit, 3);
            }
            double bigs = (valueInBigs = quantity.doubleValueIn(bigUnit)) < 0.0 ? Math.ceil(valueInBigs) : Math.floor(valueInBigs);
            double absRest = Math.abs(valueInBigs - bigs);
            if (absRest < 9.094947017729282E-13 || absRest > 0.9999999999990905) {
                return AutoFormatter.formatWithUnit(valueInBigs, bigUnit, 3);
            }
            LinearQuantity restQuantity = bigUnit.quantity(absRest);
            LinearUnit smallUnit = selector.getPreferredUnit(restQuantity, 1.0, 1000.0);
            if (smallUnit.getIdentifier() == null || smallUnit.equals(bigUnit)) {
                return AutoFormatter.formatWithUnit(valueInBigs, bigUnit, 3);
            }
            double smalls = Math.round(restQuantity.doubleValueIn(smallUnit));
            if (smallUnit.valueFactorTo(bigUnit).targetValue(smalls) >= 1.0) {
                return AutoFormatter.formatWithUnit(bigs + Math.signum(bigs), bigUnit, 3);
            }
            return String.valueOf(AutoFormatter.formatWithUnit(bigs, bigUnit, 3)) + '\u00a0' + AutoFormatter.formatWithUnit(smalls, smallUnit, 3);
        }
    }
}

