/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.unit;

import com.jrockit.mc.common.unit.DecimalScaleFactor;
import com.jrockit.mc.common.unit.DecimalUnitSelector;
import com.jrockit.mc.common.unit.IPrefix;
import com.jrockit.mc.common.unit.IUnit;
import com.jrockit.mc.common.unit.LinearKindOfQuantity;
import com.jrockit.mc.common.unit.LinearQuantity;
import com.jrockit.mc.common.unit.LinearUnit;
import com.jrockit.mc.common.util.Messages;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public final class DecimalPrefix
extends Enum<DecimalPrefix>
implements IPrefix<DecimalPrefix> {
    public static final /* enum */ DecimalPrefix YOCTO = new DecimalPrefix(-24, 'y');
    public static final /* enum */ DecimalPrefix ZEPTO = new DecimalPrefix(-21, 'z');
    public static final /* enum */ DecimalPrefix ATTO = new DecimalPrefix(-18, 'a');
    public static final /* enum */ DecimalPrefix FEMTO = new DecimalPrefix(-15, 'f');
    public static final /* enum */ DecimalPrefix PICO = new DecimalPrefix(-12, 'p');
    public static final /* enum */ DecimalPrefix NANO = new DecimalPrefix(-9, 'n');
    public static final /* enum */ DecimalPrefix MICRO = new DecimalPrefix(-6, "\u03bc", "u");
    public static final /* enum */ DecimalPrefix MILLI = new DecimalPrefix(-3, 'm');
    public static final /* enum */ DecimalPrefix CENTI = new DecimalPrefix(-2, 'c');
    public static final /* enum */ DecimalPrefix DECI = new DecimalPrefix(-1, 'd');
    public static final /* enum */ DecimalPrefix NONE = new DecimalPrefix(0, "");
    public static final /* enum */ DecimalPrefix DECA = new DecimalPrefix(1, "da");
    public static final /* enum */ DecimalPrefix HECTO = new DecimalPrefix(2, 'h');
    public static final /* enum */ DecimalPrefix KILO = new DecimalPrefix(3, 'k');
    public static final /* enum */ DecimalPrefix MEGA = new DecimalPrefix(6, 'M');
    public static final /* enum */ DecimalPrefix GIGA = new DecimalPrefix(9, 'G');
    public static final /* enum */ DecimalPrefix TERA = new DecimalPrefix(12, 'T');
    public static final /* enum */ DecimalPrefix PETA = new DecimalPrefix(15, 'P');
    public static final /* enum */ DecimalPrefix EXA = new DecimalPrefix(18, 'E');
    public static final /* enum */ DecimalPrefix ZETTA = new DecimalPrefix(21, 'Z');
    public static final /* enum */ DecimalPrefix YOTTA = new DecimalPrefix(24, 'Y');
    private static final DecimalPrefix[] THOUSANDS;
    private static final Map<String, DecimalPrefix> PREFIX_BY_SYMBOL;
    private final int powerOfTen;
    private final DecimalScaleFactor scaleFactor;
    private final double doubleMult;
    private final String symbol;
    private final String altSymbol;
    private final String englishName;
    private transient String localizedName;
    private static final /* synthetic */ DecimalPrefix[] ENUM$VALUES;

    static {
        ENUM$VALUES = new DecimalPrefix[]{YOCTO, ZEPTO, ATTO, FEMTO, PICO, NANO, MICRO, MILLI, CENTI, DECI, NONE, DECA, HECTO, KILO, MEGA, GIGA, TERA, PETA, EXA, ZETTA, YOTTA};
        THOUSANDS = new DecimalPrefix[]{YOCTO, ZEPTO, ATTO, FEMTO, PICO, NANO, MICRO, MILLI, NONE, KILO, MEGA, GIGA, TERA, EXA, PETA, ZETTA, YOTTA};
        HashMap<String, DecimalPrefix> symbolMap = new HashMap<String, DecimalPrefix>();
        DecimalPrefix[] decimalPrefixArray = DecimalPrefix.values();
        int n = decimalPrefixArray.length;
        int n2 = 0;
        while (n2 < n) {
            DecimalPrefix prefix = decimalPrefixArray[n2];
            DecimalPrefix old = symbolMap.put(prefix.symbol, prefix);
            assert (old == null);
            if (prefix.altSymbol != null) {
                old = symbolMap.put(prefix.altSymbol, prefix);
                assert (old == null);
            }
            ++n2;
        }
        PREFIX_BY_SYMBOL = symbolMap;
    }

    private DecimalPrefix(int powerOf10, char prefixChar) {
        this(powerOf10, "" + prefixChar, null);
    }

    private DecimalPrefix(int powerOf10, String prefix) {
        this(powerOf10, prefix, null);
    }

    private DecimalPrefix(int powerOf10, String prefix, String altPrefix) {
        this.powerOfTen = powerOf10;
        this.symbol = prefix;
        this.altSymbol = altPrefix;
        this.englishName = this.name().toLowerCase(Locale.ENGLISH);
        this.localizedName = prefix.length() == 0 ? "" : Messages.getString("Prefix_" + this.identifier() + "_name", this.englishName);
        this.scaleFactor = DecimalScaleFactor.get(powerOf10);
        this.doubleMult = StrictMath.pow(10.0, powerOf10);
    }

    public static DecimalPrefix getPrefix(String symbol) {
        return PREFIX_BY_SYMBOL.get(symbol);
    }

    public static int getFloorLog10(double value) {
        return value == 0.0 ? 0 : (int)Math.floor(Math.log10(Math.abs(value)));
    }

    public static int getFloorLog1000(double value) {
        return value == 0.0 ? 0 : (int)Math.floor(Math.log10(Math.abs(value)) / 3.0);
    }

    public static DecimalPrefix getEngFloorPrefix(double value) {
        int idx = Math.max(0, DecimalPrefix.getFloorLog1000(value) - DecimalPrefix.YOCTO.powerOfTen / 3);
        return THOUSANDS[Math.min(idx, THOUSANDS.length - 1)];
    }

    public int powerOf10() {
        return this.powerOfTen;
    }

    @Override
    public DecimalScaleFactor scaleFactor() {
        return this.scaleFactor;
    }

    public DecimalScaleFactor valueFactorTo(DecimalPrefix targetPrefix) {
        return DecimalScaleFactor.get(this.powerOfTen - targetPrefix.powerOfTen);
    }

    public double doubleMult() {
        return this.doubleMult;
    }

    @Override
    public final String symbol() {
        return this.symbol;
    }

    @Override
    public final String altSymbol() {
        return this.altSymbol;
    }

    @Override
    public final String identifier() {
        return this.altSymbol != null ? this.altSymbol : this.symbol;
    }

    @Override
    public String localizedName() {
        return this.localizedName;
    }

    @Override
    public StringBuilder asExponentialStringBuilder(boolean multiplicationSign) {
        return this.scaleFactor.asExponentialStringBuilder(multiplicationSign);
    }

    public String toString() {
        return this.englishName;
    }

    @Override
    public IUnit.UnitSelector<LinearQuantity, LinearUnit> createUnitSelector(LinearKindOfQuantity kindOfQuantity, Iterable<DecimalPrefix> prefixes) {
        return new DecimalUnitSelector(kindOfQuantity, prefixes);
    }

    public static DecimalPrefix[] values() {
        DecimalPrefix[] decimalPrefixArray = ENUM$VALUES;
        int n = decimalPrefixArray.length;
        DecimalPrefix[] decimalPrefixArray2 = new DecimalPrefix[n];
        System.arraycopy(ENUM$VALUES, 0, decimalPrefixArray2, 0, n);
        return decimalPrefixArray2;
    }

    public static DecimalPrefix valueOf(String string) {
        return Enum.valueOf(DecimalPrefix.class, string);
    }
}

