/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.common.internal;

import com.jrockit.mc.common.IMCMethod;
import com.jrockit.mc.common.internal.MethodToolkit;

public class FormatToolkit {
    public static final char LP = '(';
    public static final char RP = ')';
    public static final char LB = '[';
    public static final char RB = ']';
    public static final char CLASS_SUFFIX = ';';
    public static final char CLASS_PREFIX = 'L';
    public static final char PACKAGE_SEPARATOR = '.';
    public static final String COMMA_SEPARATOR = ", ";
    public static final String ARRAY = "[]";

    public static String getHumanReadable(IMCMethod method, boolean showReturnValue, boolean showReturnValuePackage, boolean showClassName, boolean showClassPackageName, boolean showArguments, boolean showArgumentsPackage) {
        String ret = "";
        try {
            if (showReturnValue) {
                ret = String.valueOf(ret) + FormatToolkit.getReturnType(method.getFormalDescriptor(), showReturnValuePackage) + ' ';
            }
            if (showClassName) {
                ret = String.valueOf(ret) + (showClassPackageName ? MethodToolkit.formatQualifiedName(method.getPackageName(), method.getClassName()) : method.getClassName()) + ".";
            }
            ret = String.valueOf(ret) + method.getMethodName();
            String arguments = FormatToolkit.getParameters(method.getFormalDescriptor(), showArgumentsPackage);
            ret = !"()".equals(arguments) && !showArguments ? String.valueOf(ret) + "(...)" : String.valueOf(ret) + arguments;
        }
        catch (Exception e) {
            return null;
        }
        return ret;
    }

    public static String getReturnType(String descriptor, boolean qualified) throws Exception {
        StringBuffer output = new StringBuffer();
        FormatToolkit.parseToken(output, descriptor.substring(descriptor.indexOf(41) + 1), 0, qualified);
        return output.toString();
    }

    public static String getParameters(String descriptor, boolean qualified) throws Exception {
        String input = descriptor.substring(descriptor.indexOf(40) + 1, descriptor.lastIndexOf(41));
        StringBuffer output = new StringBuffer(Character.toString('('));
        int next = -1;
        int current = 0;
        while (current < input.length()) {
            next = FormatToolkit.parseToken(output, input, current, qualified);
            if (next == current) break;
            if (next < input.length()) {
                output.append(COMMA_SEPARATOR);
            }
            current = next;
        }
        return output.append(')').toString();
    }

    private static int parseToken(StringBuffer output, String input, int position, boolean qualified) throws Exception {
        if (input.charAt(position) == '[') {
            return FormatToolkit.readArray(output, input, position, qualified);
        }
        if (input.charAt(position) == 'L') {
            return FormatToolkit.readComponentType(output, input, position, qualified);
        }
        return FormatToolkit.readPrimitive(output, input, position, qualified);
    }

    private static int readArray(StringBuffer output, String input, int position, boolean qualified) throws Exception {
        return FormatToolkit.write(output, ARRAY, FormatToolkit.parseToken(output, input, position + 1, qualified));
    }

    private static int readPrimitive(StringBuffer output, String input, int position, boolean qualified) throws Exception {
        return FormatToolkit.write(output, FormatToolkit.getPrimitiveType(input.charAt(position)), position + 1);
    }

    private static int write(StringBuffer output, String string, int next_position) {
        output.append(string);
        return next_position;
    }

    private static int readComponentType(StringBuffer output, String input, int position, boolean qualified) {
        int endIndex = input.indexOf(59, position);
        return FormatToolkit.write(output, FormatToolkit.getClass(input.substring(position + 1, endIndex).replace('/', '.'), qualified), endIndex + 1);
    }

    private static String getClass(String clazz, boolean qualified) {
        return qualified ? clazz : clazz.substring(clazz.lastIndexOf(46) + 1);
    }

    private static String getPrimitiveType(char ch) {
        if (ch == 'Z') {
            return Boolean.TYPE.toString();
        }
        if (ch == 'B') {
            return Byte.TYPE.toString();
        }
        if (ch == 'S') {
            return Short.TYPE.toString();
        }
        if (ch == 'I') {
            return Integer.TYPE.toString();
        }
        if (ch == 'C') {
            return Character.TYPE.toString();
        }
        if (ch == 'J') {
            return Long.TYPE.toString();
        }
        if (ch == 'F') {
            return Float.TYPE.toString();
        }
        if (ch == 'D') {
            return Double.TYPE.toString();
        }
        if (ch == 'V') {
            return Void.TYPE.toString();
        }
        return null;
    }
}

