/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.KeyboardFocusManager;
import java.awt.event.ComponentListener;
import java.awt.event.HierarchyListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditor;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.EventObject;
import java.util.Map;
import java.util.WeakHashMap;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;
import org.netbeans.modules.openide.explorer.PropertyPanelBridge;
import org.netbeans.modules.openide.explorer.TTVEnvBridge;
import org.netbeans.swing.etable.ETable;
import org.netbeans.swing.outline.Outline;
import org.openide.explorer.propertysheet.ExPropertyModel;
import org.openide.explorer.propertysheet.PropertyPanel;
import org.openide.explorer.view.NodeTableModel;
import org.openide.explorer.view.OutlineView;
import org.openide.explorer.view.PropertiesRowModel;
import org.openide.explorer.view.Visualizer;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

abstract class SheetCell
extends AbstractCellEditor
implements TableModelListener,
PropertyChangeListener,
TableCellEditor,
TableCellRenderer {
    private Boolean flat;
    private Node node;
    private Node.Property prop;
    private TableCellRenderer headerRenderer = new JTableHeader().getDefaultRenderer();
    private TableCellRenderer defaultTableRenderer = new DefaultTableCellRenderer();
    private NullPanel nullPanel;
    private Map panelCache = new WeakHashMap();
    private FocusedPropertyPanel renderer = null;
    protected PropertyPanel editor = null;
    private static Color noFocusSelectionBackground = null;
    private static Color noFocusSelectionForeground = null;

    public SheetCell() {
        this.setFlat(false);
    }

    public void setFlat(boolean bl) {
        Color color = Color.lightGray;
        if (UIManager.getColor("controlDkShadow") != null) {
            color = UIManager.getColor("controlDkShadow");
        }
        Color color2 = Color.black;
        if (UIManager.getColor("controlLtHighlight") != null) {
            color2 = UIManager.getColor("controlLtHighlight");
        }
        Color color3 = Color.blue;
        if (UIManager.getColor("Button.focus") != null) {
            color3 = UIManager.getColor("Button.focus");
        }
        this.flat = bl ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object getCellEditorValue() {
        return null;
    }

    public abstract Node nodeForRow(int var1);

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this.prop = (Node.Property)object;
        this.node = this.nodeForRow(n);
        this.node.addPropertyChangeListener((PropertyChangeListener)this);
        PropertyPanel propertyPanel = this.getEditor(this.prop, this.node);
        propertyPanel.setBackground(jTable.getSelectionBackground());
        propertyPanel.setForeground(jTable.getSelectionForeground());
        propertyPanel.setBorder(BorderFactory.createMatteBorder(0, 1, 0, 0, jTable.getSelectionBackground()));
        return propertyPanel;
    }

    @Override
    public boolean shouldSelectCell(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean isCellEditable(EventObject eventObject) {
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        if (this.prop != null) {
            this.detachEditor();
        }
        return super.stopCellEditing();
    }

    @Override
    public void cancelCellEditing() {
        if (this.prop != null) {
            this.detachEditor();
        }
        super.cancelCellEditing();
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        this.cancelCellEditing();
    }

    protected void detachEditor() {
        this.node.removePropertyChangeListener((PropertyChangeListener)this);
        this.node = null;
        this.prop = null;
    }

    private FocusedPropertyPanel getRenderer(Node.Property property, Node node) {
        TTVEnvBridge tTVEnvBridge = TTVEnvBridge.getInstance(this);
        tTVEnvBridge.setCurrentBeans(new Node[]{node});
        if (this.renderer == null) {
            this.renderer = new FocusedPropertyPanel(property, 9);
            this.renderer.putClientProperty("beanBridgeIdentifier", this);
        }
        this.renderer.setProperty(property);
        this.renderer.putClientProperty("flat", Boolean.TRUE);
        return this.renderer;
    }

    public abstract String getShortDescription(int var1);

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (n == -1) {
            Component component = this.headerRenderer.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (component instanceof JComponent) {
                String string = n2 > 0 ? this.getShortDescription(n2) : jTable.getColumnName(0);
                ((JComponent)component).setToolTipText(string);
            }
            return component;
        }
        Node.Property property = (Node.Property)object;
        Node node = this.nodeForRow(n);
        Component component = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        boolean bl3 = bl2 || jTable == component || jTable.isAncestorOf(component) || component instanceof Container && ((Container)component).isAncestorOf(jTable);
        Component component2 = this.defaultTableRenderer.getTableCellRendererComponent(jTable, object, bl, bl3, n, n2);
        Color color = this.getRealColor(component2.getBackground());
        Color color2 = component2.getForeground();
        if (property != null) {
            Object object2;
            FocusedPropertyPanel focusedPropertyPanel = this.getRenderer(property, node);
            focusedPropertyPanel.setFocused(bl2);
            Object object3 = jTable.getClientProperty("ComputingTooltip");
            if (Boolean.TRUE.equals(object3)) {
                object2 = null;
                PropertyEditor propertyEditor = property.getPropertyEditor();
                Object object4 = jTable.getClientProperty("PropertyToolTipShortDescription");
                if (Boolean.TRUE.equals(object4) && property.getShortDescription() != null) {
                    object2 = property.getShortDescription();
                } else if (propertyEditor != null) {
                    try {
                        propertyEditor.setValue(property.getValue());
                        object2 = propertyEditor.getAsText();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (object2 == null) {
                    Object object5 = null;
                    try {
                        object5 = property.getValue();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (object5 != null) {
                        object2 = object5.toString();
                    }
                }
                if (object2 != null && ((String)object2).trim().length() > 0) {
                    focusedPropertyPanel.setToolTipText(((String)object2).trim());
                } else {
                    focusedPropertyPanel.setToolTipText(null);
                }
            }
            focusedPropertyPanel.setOpaque(true);
            if (bl && !bl3) {
                focusedPropertyPanel.setBackground(SheetCell.getNoFocusSelectionBackground());
                focusedPropertyPanel.setForeground(SheetCell.getNoFocusSelectionForeground());
            } else {
                focusedPropertyPanel.setBackground(color);
                focusedPropertyPanel.setForeground(color2);
            }
            if (jTable instanceof ETable) {
                object2 = (ETable)jTable;
                object2.setCellBackground((Component)focusedPropertyPanel, bl, n, n2);
            }
            return focusedPropertyPanel;
        }
        if (this.nullPanel == null) {
            this.nullPanel = new NullPanel(node);
            this.nullPanel.setOpaque(true);
        } else {
            this.nullPanel.setNode(node);
        }
        if (bl && !bl3) {
            this.nullPanel.setBackground(SheetCell.getNoFocusSelectionBackground());
            this.nullPanel.setForeground(SheetCell.getNoFocusSelectionForeground());
        } else {
            this.nullPanel.setBackground(color);
            this.nullPanel.setForeground(color2);
        }
        if (jTable instanceof ETable) {
            ETable eTable = (ETable)jTable;
            eTable.setCellBackground((Component)this.nullPanel, bl, n, n2);
        }
        this.nullPanel.setFocused(bl2);
        return this.nullPanel;
    }

    private Color getRealColor(Color color) {
        if (color instanceof UIResource) {
            float[] fArray = color.getComponents(null);
            int n = fArray.length - 1;
            float[] fArray2 = new float[n];
            System.arraycopy(fArray, 0, fArray2, 0, n);
            color = new Color(color.getColorSpace(), fArray2, fArray[n]);
        }
        return color;
    }

    private PropertyPanel getEditor(Node.Property property, Node node) {
        int n = 8;
        TTVEnvBridge tTVEnvBridge = TTVEnvBridge.getInstance(this);
        tTVEnvBridge.setCurrentBeans(new Node[]{node});
        if (this.editor == null) {
            this.editor = new PropertyPanel(property, n);
            this.editor.putClientProperty("flat", Boolean.TRUE);
            this.editor.putClientProperty("beanBridgeIdentifier", this);
            this.editor.setProperty(property);
            return this.editor;
        }
        this.editor.setProperty(property);
        return this.editor;
    }

    private PropertyPanel obtainPanel(Node node, Node.Property property) {
        return this.getEditor(property, node);
    }

    private static String getString(String string) {
        return NbBundle.getMessage(SheetCell.class, (String)string);
    }

    static Color getNoFocusSelectionBackground() {
        if (noFocusSelectionBackground == null && (noFocusSelectionBackground = UIManager.getColor("nb.explorer.noFocusSelectionBackground")) == null) {
            noFocusSelectionBackground = UIManager.getColor("controlShadow");
            if (noFocusSelectionBackground == null) {
                noFocusSelectionBackground = Color.lightGray;
            }
            noFocusSelectionBackground = SheetCell.betterBrighter(noFocusSelectionBackground);
        }
        return noFocusSelectionBackground;
    }

    private static Color betterBrighter(Color color) {
        Color color2 = color.brighter();
        if (Color.WHITE.equals(color2)) {
            color2 = new Color((255 + color.getRed()) / 2, (255 + color.getGreen()) / 2, (255 + color.getBlue()) / 2);
        }
        return color2;
    }

    static Color getNoFocusSelectionForeground() {
        if (noFocusSelectionForeground == null && (noFocusSelectionForeground = UIManager.getColor("nb.explorer.noFocusSelectionForeground")) == null && (noFocusSelectionForeground = UIManager.getColor("textText")) == null) {
            noFocusSelectionForeground = Color.BLACK;
        }
        return noFocusSelectionForeground;
    }

    public static class OutlineSheetCell
    extends SheetCell {
        private Outline outline;

        public OutlineSheetCell(Outline outline) {
            this.outline = outline;
        }

        @Override
        public Node nodeForRow(int n) {
            int n2 = this.outline.convertRowIndexToModel(n);
            TreePath treePath = this.outline.getLayoutCache().getPathForRow(n2);
            return Visualizer.findNode(treePath.getLastPathComponent());
        }

        @Override
        public String getShortDescription(int n) {
            return this.outline.getOutlineModel().getColumnName(n);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.stopCellEditingNoCommit();
            if (SwingUtilities.isEventDispatchThread()) {
                this.outline.tableChanged(new TableModelEvent(this.outline.getModel(), 0, this.outline.getRowCount()));
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        OutlineSheetCell.this.outline.tableChanged(new TableModelEvent(OutlineSheetCell.this.outline.getModel(), 0, OutlineSheetCell.this.outline.getRowCount()));
                    }
                });
            }
        }

        @Override
        public boolean stopCellEditing() {
            PropertyPanelBridge.commit(this.editor);
            return this.stopCellEditingNoCommit();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean stopCellEditingNoCommit() {
            PropertiesRowModel propertiesRowModel = null;
            if (this.outline instanceof OutlineView.OutlineViewOutline) {
                OutlineView.OutlineViewOutline outlineViewOutline = (OutlineView.OutlineViewOutline)this.outline;
                propertiesRowModel = outlineViewOutline.getRowModel();
            }
            if (propertiesRowModel != null) {
                propertiesRowModel.setIgnoreSetValue(true);
            }
            try {
                boolean bl = super.stopCellEditing();
                return bl;
            }
            finally {
                if (propertiesRowModel != null) {
                    propertiesRowModel.setIgnoreSetValue(false);
                }
            }
        }

        @Override
        protected void detachEditor() {
            super.detachEditor();
            TableModel tableModel = this.outline.getModel();
            tableModel.removeTableModelListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            TableModel tableModel = this.outline.getModel();
            tableModel.addTableModelListener(this);
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
    }

    static class TableSheetCell
    extends SheetCell {
        private NodeTableModel tableModel;
        private ETable table;

        public TableSheetCell(NodeTableModel nodeTableModel, ETable eTable) {
            this.tableModel = nodeTableModel;
            this.table = eTable;
        }

        @Override
        public Node nodeForRow(int n) {
            int n2 = this.table.convertRowIndexToModel(n);
            return this.tableModel.nodeForRow(n2);
        }

        @Override
        public String getShortDescription(int n) {
            return this.tableModel.propertyForColumn(n).getShortDescription();
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.tableModel.fireTableDataChanged();
        }

        @Override
        protected void detachEditor() {
            super.detachEditor();
            this.tableModel.removeTableModelListener(this);
        }

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.tableModel.addTableModelListener(this);
            return super.getTableCellEditorComponent(jTable, object, bl, n, n2);
        }
    }

    static class FocusedPropertyPanel
    extends PropertyPanel {
        boolean focused;

        public FocusedPropertyPanel(Node.Property property, int n) {
            super(property, n);
            this.setDoubleBuffered(true);
        }

        public void setFocused(boolean bl) {
            this.focused = bl;
        }

        @Override
        public void addComponentListener(ComponentListener componentListener) {
        }

        @Override
        public void addHierarchyListener(HierarchyListener hierarchyListener) {
        }

        @Override
        public void repaint(long l, int n, int n2, int n3, int n4) {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void firePropertyChange(String string, Object object, Object object2) {
            if ("flat".equals(string)) {
                super.firePropertyChange(string, object, object2);
            }
        }

        @Override
        public boolean isShowing() {
            return true;
        }

        @Override
        public void update(Graphics graphics) {
        }

        @Override
        public void paint(Graphics graphics) {
            Color color = this.getBackground();
            Color color2 = graphics.getColor();
            graphics.setColor(color);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
            graphics.setColor(color2);
            super.paint(graphics);
            if (this.focused) {
                Color color3 = UIManager.getColor("Tree.selectionBorderColor");
                if (color3 == null) {
                    color3 = this.getForeground().equals(Color.BLACK) ? this.getBackground().darker() : this.getForeground().darker();
                }
                graphics.setColor(color3);
                graphics.drawRect(1, 1, this.getWidth() - 3, this.getHeight() - 3);
            }
            graphics.setColor(color2);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleFocusedPropertyPanel();
            }
            return this.accessibleContext;
        }

        private class AccessibleFocusedPropertyPanel
        extends JComponent.AccessibleJComponent {
            AccessibleFocusedPropertyPanel() {
                super(FocusedPropertyPanel.this);
            }

            @Override
            public AccessibleRole getAccessibleRole() {
                return AccessibleRole.PANEL;
            }

            @Override
            public String getAccessibleName() {
                FeatureDescriptor featureDescriptor = ((ExPropertyModel)FocusedPropertyPanel.this.getModel()).getFeatureDescriptor();
                PropertyEditor propertyEditor = FocusedPropertyPanel.this.getPropertyEditor();
                return MessageFormat.format(SheetCell.getString("ACS_PropertyPanelRenderer"), featureDescriptor.getDisplayName(), propertyEditor == null ? SheetCell.getString("CTL_No_value") : propertyEditor.getAsText());
            }

            @Override
            public String getAccessibleDescription() {
                FeatureDescriptor featureDescriptor = ((ExPropertyModel)FocusedPropertyPanel.this.getModel()).getFeatureDescriptor();
                Node node = (Node)((ExPropertyModel)FocusedPropertyPanel.this.getModel()).getBeans()[0];
                Class clazz = FocusedPropertyPanel.this.getModel().getPropertyType();
                return MessageFormat.format(SheetCell.getString("ACSD_PropertyPanelRenderer"), featureDescriptor.getShortDescription(), clazz == null ? SheetCell.getString("CTL_No_type") : clazz.getName(), node.getDisplayName());
            }
        }
    }

    private static class NullPanel
    extends JPanel {
        private WeakReference<Node> weakNode;
        private boolean focused = false;

        NullPanel(Node node) {
            this.weakNode = new WeakReference<Node>(node);
        }

        void setNode(Node node) {
            this.weakNode = new WeakReference<Node>(node);
        }

        @Override
        public AccessibleContext getAccessibleContext() {
            if (this.accessibleContext == null) {
                this.accessibleContext = new AccessibleNullPanel();
            }
            return this.accessibleContext;
        }

        public void setFocused(boolean bl) {
            this.focused = bl;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            if (this.focused) {
                Color color = UIManager.getColor("Tree.selectionBorderColor");
                if (color == null) {
                    color = this.getForeground().equals(Color.BLACK) ? this.getBackground().darker() : this.getForeground().darker();
                }
                graphics.setColor(color);
                graphics.drawRect(1, 1, this.getWidth() - 3, this.getHeight() - 3);
                graphics.setColor(color);
            }
        }

        @Override
        public void addComponentListener(ComponentListener componentListener) {
        }

        @Override
        public void addHierarchyListener(HierarchyListener hierarchyListener) {
        }

        @Override
        public void repaint() {
        }

        @Override
        public void repaint(int n, int n2, int n3, int n4) {
        }

        @Override
        public void invalidate() {
        }

        @Override
        public void revalidate() {
        }

        @Override
        public void validate() {
        }

        @Override
        public void firePropertyChange(String string, Object object, Object object2) {
        }

        private class AccessibleNullPanel
        extends JPanel.AccessibleJPanel {
            AccessibleNullPanel() {
                super(NullPanel.this);
            }

            @Override
            public String getAccessibleName() {
                String string = super.getAccessibleName();
                if (string == null) {
                    string = SheetCell.getString("ACS_NullPanel");
                }
                return string;
            }

            @Override
            public String getAccessibleDescription() {
                Node node;
                String string = super.getAccessibleDescription();
                if (string == null && (node = (Node)NullPanel.this.weakNode.get()) != null) {
                    string = MessageFormat.format(SheetCell.getString("ACSD_NullPanel"), node.getDisplayName());
                }
                return string;
            }
        }
    }
}

