﻿using System;
using System.Diagnostics;
using System.IO;
using System.Runtime.InteropServices;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows;
using System.Windows.Documents;
using System.Windows.Media;
using System.Collections.Generic;
using System.Reflection;

//TODO: テストコード追加

namespace JoinNotes
{
    abstract internal class Util
    {
        public static FlowDocument CloneDocument(FlowDocument document)
        {
            var copy = new FlowDocument();
            var sourceRange = new TextRange(document.ContentStart, document.ContentEnd);
            var targetRange = new TextRange(copy.ContentStart, copy.ContentEnd);

            using (var stream = new MemoryStream())
            {
                sourceRange.Save(stream, DataFormats.XamlPackage);
                targetRange.Load(stream, DataFormats.XamlPackage);
                //FIXME: ドキュメントファイルロック時の例外に対処
            }

            return copy;
        }

        public static IEnumerable<Type> GetExecutingTypes(bool getResourceModules = false)
        {
            var ret = new List<Type> { };
            foreach (var module in System.Reflection.Assembly.GetExecutingAssembly().GetLoadedModules(getResourceModules))
                ret.AddRange(module.GetTypes());

            return ret;
        }

        //FIXME: Process.GetProcesses(), Process.MainModule.FileNameを使った方法にする。
        #region † http://tomoemon.hateblo.jp/entry/20080430/p2
        // 外部プロセスのメイン・ウィンドウを起動するためのWin32 API
        [DllImport("user32.dll")]
        private static extern bool SetForegroundWindow(IntPtr hWnd);

        [DllImport("user32.dll")]
        private static extern bool ShowWindowAsync(IntPtr hWnd, int nCmdShow);

        [DllImport("user32.dll")]
        private static extern bool IsIconic(IntPtr hWnd);

        [DllImport("user32.dll")]
        private static extern uint GetWindowThreadProcessId(IntPtr hWnd, ref uint procId);

        [DllImport("user32", EntryPoint = "EnumWindows")]
        private static extern int EnumWindows(EnumerateWindowsCallback lpEnumFunc, int lParam);

        [return: MarshalAs(UnmanagedType.Bool)]
        [DllImport("user32.dll", SetLastError = true)]
        public static extern bool PostMessage(HandleRef hWnd, uint Msg, IntPtr wParam, IntPtr lParam);

        [DllImport("user32.dll", CharSet = CharSet.Auto, SetLastError = true)]
        public static extern int GetWindowText(IntPtr hWnd, StringBuilder lpString, int nMaxCount);

        private static Process target_proc = null;
        private static IntPtr target_hwnd = IntPtr.Zero;

        private delegate int EnumerateWindowsCallback(IntPtr hWnd, int lParam);
        public static int EnumerateWindows(IntPtr hWnd, int lParam)
        {
            uint procId = 0;
            uint result = GetWindowThreadProcessId(hWnd, ref procId);

            var proc = Process.GetProcessById((int)procId);
            Debug.WriteLine(new { proc.Id, proc.MainWindowHandle, proc.MainWindowTitle }, "EnumerateWindows");

            var procWindowTitle = new StringBuilder(1024);
            GetWindowText(hWnd, procWindowTitle, procWindowTitle.Capacity);

            if (procId == target_proc.Id && procWindowTitle.ToString() == Application.NotifyContainerTitle)
            //if (proc.MainWindowTitle == Application.mainWindow.Title)
            //if (procId == target_proc.Id)
            {
                // 同じIDで複数のウィンドウが見つかる場合がある
                // とりあえず最初のウィンドウが見つかった時点で終了する
                target_hwnd = hWnd;
                return 0;
            }

            // 列挙を継続するには0以外を返す必要がある
            return 1;
        }

        // 外部プロセスのウィンドウを最前面に表示する
        public static void WakeupWindow(Process target)
        {
            target_proc = target;
            EnumWindows(new EnumerateWindowsCallback(EnumerateWindows), 0);
            if (target_hwnd == IntPtr.Zero)
            {
                Debug.Fail("window not found");
                return;
            }

            var ret = PostMessage(new HandleRef(Application.mainWindow, target_hwnd), Application.WM_APP_ACTIVATEAPP, IntPtr.Zero, IntPtr.Zero);
            Debug.Assert(ret);
            //MessageBox.Show("PostMessage Handle: 0x" + target_hwnd.ToString("X") + ", Message: 0x" + Menu.WM_APP_ACTIVATEAPP.ToString("X"));
        }
        #endregion

        //public static Hyperlink FindHyperlinkFrom(TextElement from)
        //{
        //    if (from == null)
        //        return null;
        //    //FIXME: TextPointer.Parent -> TextPointer.GetAdjacentElement
        //    else if (from.Parent is Hyperlink)
        //        return (Hyperlink)from.Parent;
        //    else
        //        return FindHyperlinkFrom((TextElement)from.Parent);
        //}

        public static string ValidateFilename(string filename)
        {
            return Regex.Replace(filename, "[" + Regex.Escape(string.Join("", Path.GetInvalidFileNameChars())) + "]", "-", RegexOptions.Singleline);
        }

        //public static  IEnumerable<DependencyObject> GetVisualTreeChildrenByType(DependencyObject reference, Type type)
        //{
        //    var ret = new List<DependencyObject> { };

        //    var count = VisualTreeHelper.GetChildrenCount(reference);
        //    for (var childIndex = 0; childIndex < count; childIndex++)
        //    {
        //        var child = VisualTreeHelper.GetChild(reference, childIndex);
        //        if (child.GetType() == type)
        //            ret.Add(child);
        //        ret.AddRange(GetVisualTreeChildrenByType(child, type));
        //    }

        //    return ret;
        //}

        //public static  IEnumerable<DependencyObject> GetLogicalTreeChildrenByType(DependencyObject reference, Type type)
        //{
        //    var ret = new List<DependencyObject> { };

        //    var children = LogicalTreeHelper.GetChildren(reference);
        //    foreach (var child in children)
        //    {
        //        if (child is DependencyObject)
        //        {
        //            if (child.GetType() == type)
        //                ret.Add((DependencyObject)child);
        //            ret.AddRange(GetLogicalTreeChildrenByType((DependencyObject)child, type));
        //        }
        //    }

        //    return ret;
        //}

        public static string GetFileNameWithoutDocumentExtension(string path)
        {
            return Path.GetFileName(path).Replace(".join.rtf", "");
        }

        public static int GetIndexByTextPointer(TextPointer pointer, TextRange at)
        {
            Debug.Assert(pointer.IsInSameDocument(at.Start));

            // 変換元がTextPointerなので、at.Text[idx]のidxとして使える範囲より大きな値になることがある
            return Util.TextOf(at.Start, pointer).Length;
        }

        public static string TextOf(TextPointer rangeStart, TextPointer rangeEnd)
        {
            var useParagraphToLineBreakHack = false;
            return TextOf(rangeStart, rangeEnd, ref useParagraphToLineBreakHack);
        }

        /// <summary>
        /// TextRange.Textを使わずにテキスト化。
        /// </summary>
        /// <param name="useParagraphToLineBreakHack">Paragraphを改行文字に置き換えるかどうかを示す内部状態</param>
        public static string TextOf(TextPointer rangeStart, TextPointer rangeEnd, ref bool useParagraphToLineBreakHack)
        {
            // TextRangeは与えられたTextPointerを修正するので使えない。

            if (rangeStart == null || rangeEnd == null)
                return "";

            rangeStart = rangeStart.GetInsertionPosition(LogicalDirection.Forward); //HACK:
            //rangeStart = rangeStart.GetNextInsertionPosition(LogicalDirection.Forward) ?? rangeStart.GetInsertionPosition(LogicalDirection.Forward); //HACK:

            {
                var start = rangeStart.GetOffsetToPosition(rangeStart);
                var end = rangeStart.GetOffsetToPosition(rangeEnd);
                //Debug.WriteLine(new { start, end }, "TextOf.arg");
            }

            //FIXME: 改行を含める。LineBreakと、Paragraph(ElementEnd)-Paragraph(ElementStart)の連続を。
            var text = new StringBuilder();
            //// range.Endでの処理は含めない。End以降を扱ってしまうので。
            //for (var pointer = range.Start; pointer != null && pointer.CompareTo(range.End) < 0; pointer = pointer.GetNextContextPosition(LogicalDirection.Forward))
            for (var pointer = rangeStart; pointer != null && pointer.CompareTo(rangeEnd) <= 0; pointer = pointer.GetNextContextPosition(LogicalDirection.Forward))
            {
                {
                    var parent = pointer.Parent;
                    var backward = pointer.GetAdjacentElement(LogicalDirection.Backward);
                    var forward = pointer.GetAdjacentElement(LogicalDirection.Forward);
                    //Debug.WriteLine(new { parent, backward, forward }, "TextOf.-");
                }

                if (pointer.GetPointerContext(LogicalDirection.Forward) == TextPointerContext.Text)
                {
                    useParagraphToLineBreakHack = false;
                    var textInRun = pointer.GetTextInRun(LogicalDirection.Forward);
                    var textRunLength = pointer.GetTextRunLength(LogicalDirection.Forward);
                    if (rangeEnd.CompareTo(pointer.GetPositionAtOffset(textRunLength)) < 0)
                    {
                        text.Append(textInRun.Substring(0, pointer.GetOffsetToPosition(rangeEnd)));
                        break;
                    }
                    else
                    {
                        text.Append(textInRun);
                    }
                }
                else if (pointer.GetAdjacentElement(LogicalDirection.Backward) is LineBreak
                    && pointer.GetAdjacentElement(LogicalDirection.Forward) is LineBreak
                    && ReferenceEquals(pointer.GetAdjacentElement(LogicalDirection.Backward), pointer.GetAdjacentElement(LogicalDirection.Forward)))
                {
                    //Debug.WriteLine(new { pointer.Parent }, "TextOf.1");
                    // <LineBreak />
                    useParagraphToLineBreakHack = false;
                    text.AppendLine();
                }
                // useParagraphToLineBreakHackとは条件文を独立させておいたほうがいい。
                else if (pointer.GetPointerContext(LogicalDirection.Backward) == TextPointerContext.ElementEnd
                    && pointer.GetAdjacentElement(LogicalDirection.Backward) is Paragraph
                    && pointer.GetPointerContext(LogicalDirection.Forward) == TextPointerContext.ElementStart
                    && pointer.GetAdjacentElement(LogicalDirection.Forward) is Paragraph
                    && !ReferenceEquals(pointer.GetAdjacentElement(LogicalDirection.Backward), pointer.GetAdjacentElement(LogicalDirection.Forward)))
                {
                    //Debug.WriteLine(new { pointer.Parent }, "TextOf.2");
                    useParagraphToLineBreakHack = false;
                    text.AppendLine();
                }
                //HACK: 前回の（このメソッドの）呼び出しが</Paragraph>で終わっていれば<Paragraph>だけでも改行文字を出力する。
                else if (pointer.GetPointerContext(LogicalDirection.Forward) == TextPointerContext.ElementStart
                    && pointer.GetAdjacentElement(LogicalDirection.Forward) is Paragraph)
                {
                    //Debug.WriteLine(new { pointer.Parent }, "TextOf.3");
                    useParagraphToLineBreakHack = true;
                }
            }

            return text.ToString();
        }

        [Conditional("DEBUG")]
        public static void __t_TextOf()
        {
            {
                var actual = TextOf(null, null);
                var except = "";
                Debug.Assert(actual.Equals(except));
            }
            {
                var actual = TextOf(null, new FlowDocument().ContentStart);
                var except = "";
                Debug.Assert(actual.Equals(except));
            }
            {
                var actual = TextOf(new FlowDocument().ContentStart, null);
                var except = "";
                Debug.Assert(actual.Equals(except));
            }
            {
                var doc = new FlowDocument();
                var actual = TextOf(doc.ContentStart, doc.ContentEnd);
                var except = "";
                Debug.Assert(actual.Equals(except));
            }
            {
                var doc = new FlowDocument(new Paragraph());
                var actual = TextOf(doc.ContentStart, doc.ContentEnd);
                var except = "";
                Debug.Assert(actual.Equals(except));
            }
            {
                var doc = new FlowDocument(new Paragraph(new Run("")));
                var actual = TextOf(doc.ContentStart, doc.ContentEnd);
                var except = "";
                Debug.Assert(actual.Equals(except));
            }
            // --------------------------------------------------
            {
                var doc = new FlowDocument(new Paragraph(new Run("123")));
                var actual = TextOf(doc.ContentStart, doc.ContentEnd);
                var except = "123";
                Debug.Assert(actual.Equals(except));
            }
            {
                var doc = new FlowDocument(new Paragraph(new Run("\n")));
                var actual = TextOf(doc.ContentStart, doc.ContentEnd);
                var except = "\n";
                Debug.Assert(actual.Equals(except));
            }
            {
                var doc = new FlowDocument(new Paragraph(new Run("\r\n")));
                var actual = TextOf(doc.ContentStart, doc.ContentEnd);
                var except = "\r\n";
                Debug.Assert(actual.Equals(except));
            }
            {
                var doc = new FlowDocument(new Paragraph(new Run("\r\r\n\n\r\r")));
                var actual = TextOf(doc.ContentStart, doc.ContentEnd);
                var except = "\r\r\n\n\r\r";
                Debug.Assert(actual.Equals(except));
            }
            // --------------------------------------------------
            {
                // LineBreak
                var doc = new FlowDocument(new Paragraph(new LineBreak()));
                var actual = TextOf(doc.ContentStart, doc.ContentEnd);
                var except = "\r\n";
                Debug.Assert(actual.Equals(except));
            }
            {
                // LineBreak
                var p = new Paragraph();
                p.Inlines.AddRange(new Inline[] { new LineBreak(), new Run("--"), new LineBreak(), });
                var doc = new FlowDocument(p);

                var actual = TextOf(doc.ContentStart, doc.ContentEnd);
                var except = "\r\n--\r\n";
                Debug.Assert(actual.Equals(except));
            }
            {
                // LineBreak
                var p = new Paragraph();
                p.Inlines.AddRange(new[] { new LineBreak(), new LineBreak(), new LineBreak(), });
                var doc = new FlowDocument(p);

                var actual = TextOf(doc.ContentStart, doc.ContentEnd);
                var except = "\r\n\r\n\r\n";
                Debug.Assert(actual.Equals(except));
            }
            // --------------------------------------------------
            {
                // Paragraph -> Paragraph
                var doc = new FlowDocument();
                doc.Blocks.AddRange(new[] { new Paragraph(new Run("1")), new Paragraph(new Run("22")), });

                var actual = TextOf(doc.ContentStart, doc.ContentEnd);
                var except = "1\r\n22";
                Debug.Assert(actual.Equals(except));
            }
            {
                // Paragraph -> Paragraph
                var doc = new FlowDocument();
                doc.Blocks.AddRange(new[] { new Paragraph(new Run("1")), new Paragraph(new Run("22")), new Paragraph(new Run("333")), });

                var actual = TextOf(doc.ContentStart, doc.ContentEnd);
                var except = "1\r\n22\r\n333";
                Debug.Assert(actual.Equals(except));
            }
            // --------------------------------------------------
            {
                var doc = new FlowDocument(new Paragraph(new Run("あ・い・うー")));
                var actual = TextOf(doc.ContentStart, doc.ContentEnd);
                var except = "あ・い・うー";
                Debug.Assert(actual.Equals(except));
            }
            {
                var doc = new FlowDocument(new Paragraph(new Run("1２三ヽ(#ﾟДﾟ)ﾉ┌┛(ノ´Д｀)ノ❤")));
                var actual = TextOf(doc.ContentStart, doc.ContentEnd);
                var except = "1２三ヽ(#ﾟДﾟ)ﾉ┌┛(ノ´Д｀)ノ❤";
                Debug.Assert(actual.Equals(except));
            }
            // --------------------------------------------------
            {
                var doc = new FlowDocument(new Paragraph(new Run("a")));
                var actual = TextOf(doc.ContentStart, doc.ContentEnd);
                var except = "b";
                Debug.Assert(!actual.Equals(except));
            }
            {
                var doc = new FlowDocument(new Paragraph(new Run("\n")));
                var actual = TextOf(doc.ContentStart, doc.ContentEnd);
                var except = "";
                Debug.Assert(!actual.Equals(except));
            }
        }

        public static TextRange ContentRangeOf(FlowDocument document)
        {
            return (document == null) ? null : new TextRange(document.ContentStart, document.ContentEnd);
        }

        public static TextRange ContentRangeOf(TextElement element)
        {
            return (element == null) ? null : new TextRange(element.ContentStart, element.ContentEnd);
        }

        public static TextRange ElementRangeOf(TextElement element)
        {
            return (element == null) ? null : new TextRange(element.ElementStart, element.ElementEnd);
        }

        public static System.Windows.Forms.Keys InputModifierKeyToFormsKey(System.Windows.Input.ModifierKeys inputKey)
        {
            System.Windows.Forms.Keys ret = System.Windows.Forms.Keys.None;

            if (inputKey != System.Windows.Input.ModifierKeys.None)
            {
                //HACK: なぜかSystem.Windows.Input.ModifierKeysとSystem.Windows.Forms.Keysの対応が違うので、ここで変更。
                if (inputKey.HasFlag(System.Windows.Input.ModifierKeys.Alt)) ret |= System.Windows.Forms.Keys.Shift; // ModifierKeys.Alt -> Keys.Shift
                if (inputKey.HasFlag(System.Windows.Input.ModifierKeys.Control)) ret |= System.Windows.Forms.Keys.Control;
                if (inputKey.HasFlag(System.Windows.Input.ModifierKeys.Shift)) ret |= System.Windows.Forms.Keys.Alt;  // ModifierKeys.Shift -> Keys.Alt
                if (inputKey.HasFlag(System.Windows.Input.ModifierKeys.Windows))
                {
                    ret |= System.Windows.Forms.Keys.LWin;
                    ret |= System.Windows.Forms.Keys.RWin;
                }
            }

            Debug.WriteLine(inputKey.ToString() + " -> " + ret.ToString(), "InputModifierKeyToFormsKey");

            return ret;
        }

        public static System.Windows.Forms.Keys InputKeyToFormsKey(System.Windows.Input.Key inputKey)
        {
            System.Windows.Forms.Keys ret = System.Windows.Forms.Keys.None;

            try
            {
                // System.Windows.Input.Key http://msdn.microsoft.com/ja-jp/library/vstudio/system.windows.input.hotKey.aspx
                // System.Windows.Forms.Keys http://msdn.microsoft.com/ja-jp/library/vstudio/system.windows.forms.keys.aspx
                ret = (System.Windows.Forms.Keys)Enum.Parse(typeof(System.Windows.Forms.Keys), inputKey.ToString());
            }
            catch (ArgumentException ex)
            {
                Debug.WriteLine(ex.Message, ex.Source);
            }

            if (inputKey.ToString() != ret.ToString()) Debug.WriteLine(inputKey.ToString() + " -> " + ret.ToString(), "InputKeyToFormsKey");

            Debug.WriteLine(inputKey.ToString() + " -> " + ret.ToString(), "InputKeyToFormsKey");

            return ret;
        }

        //public static  bool Contain(TextRange range, TextPointer pointer)
        //{
        //    return range.Start.CompareTo(pointer) <= 0 && pointer.CompareTo(range.End) <= 0;
        //}

        /// <param name="indexInDocument">（左側にある文字数で指定。例えばatに3文字しか含まれていなくても3を指定していい。）</param>
        /// <param name="at"></param>
        /// <param name="sideOfBound"></param>
        /// <returns></returns>
        public static TextPointer GetTextPointerByIndex(int indexInDocument, TextPointer at, LogicalDirection sideOfBound)
        {
            TextPointer ret = null;
            var lengthCount = 0;

            Debug.WriteLine("GetTextPointerByIndex");

            for (var pointer = at; pointer != null; pointer = pointer.GetNextContextPosition(LogicalDirection.Forward))
            {
                int length;

                var forwardContext = pointer.GetPointerContext(LogicalDirection.Forward);
                var forwardElement = pointer.GetAdjacentElement(LogicalDirection.Forward);
                var backwardContext = pointer.GetPointerContext(LogicalDirection.Backward);
                var backwardElement = pointer.GetAdjacentElement(LogicalDirection.Backward);
                var parentElement = pointer.Parent;

                if (forwardContext == TextPointerContext.Text)
                {
                    Debug.Assert(backwardContext == TextPointerContext.ElementStart);
                    Debug.Assert(backwardElement is Run);
                    Debug.Assert(forwardElement == null);
                    Debug.WriteLine(new { backwardElement.GetType().Name }, "Text");

                    var run = (Run)pointer.Parent;
                    length = run.Text.Length;
                }
                else if (backwardElement is LineBreak && forwardElement is LineBreak
                    && ReferenceEquals(backwardElement, forwardElement))
                {
                    Debug.WriteLine("LineBreak -> \\r\\n");
                    length = "\r\n".Length;
                }
                else if (
                    !ReferenceEquals(backwardElement, forwardElement)
                    && backwardElement is Paragraph && backwardContext == TextPointerContext.ElementEnd
                    && forwardElement is Paragraph && forwardContext == TextPointerContext.ElementStart)
                {
                    Debug.WriteLine("</P><P> -> \\r\\n");
                    length = "\r\n".Length;
                }
                else
                {
                    Debug.WriteLine(new { lengthCount, forwardContext, forwardElement, backwardContext, backwardElement, parentElement });
                    length = 0;
                }

                if (sideOfBound == LogicalDirection.Backward)
                {
                    if (lengthCount + length < indexInDocument)
                    {
                        // nop
                    }
                    else if (lengthCount + length == indexInDocument)
                    {
                        ret = pointer.GetPositionAtOffset(length);
                        break;
                    }
                    else if (lengthCount + length > indexInDocument)
                    {
                        // この時点のpointerはlengthCountの位置（に対応するTextPointer）
                        // |----indexInDocument----|---diff----|
                        // |----lengthCount----|----length-----|
                        Debug.Assert(lengthCount < indexInDocument && lengthCount + length > indexInDocument);
                        var diff = (lengthCount + length) - indexInDocument;
                        Debug.Assert(lengthCount + (length - diff) == indexInDocument);
                        ret = pointer.GetPositionAtOffset(length - diff);
                        break;
                    }
                }
                else
                {
                    Debug.Assert(sideOfBound == LogicalDirection.Forward);

                    if (lengthCount + length < indexInDocument)
                    {
                        // nop
                    }
                    else if (lengthCount + length == indexInDocument)
                    {
                        // nop
                    }
                    else if (lengthCount + length > indexInDocument)
                    {
                        // この時点のpointerはlengthCountの位置（に対応するTextPointer）
                        // |----indexInDocument----|---diff----|
                        // |----lengthCount----|----length-----|
                        Debug.Assert(lengthCount <= indexInDocument && lengthCount + length > indexInDocument);
                        var diff = (lengthCount + length) - indexInDocument;
                        Debug.Assert(lengthCount + (length - diff) == indexInDocument);
                        ret = pointer.GetPositionAtOffset(length - diff);
                        break;
                    }
                }

                lengthCount += length;
            }
            return ret;
        }

        [Conditional("DEBUG")]
        public static void __t_GetTextPointerByIndex_Forward()
        {
            {
                var doc = new FlowDocument(new Paragraph(new Run("012\r\n3\r\n4\r\n\r\n5\r\r\n\n\r\r6\r7\n89")));
                var actual0 = GetTextPointerByIndex(0, doc.ContentStart, LogicalDirection.Forward).GetTextInRun(LogicalDirection.Forward)[0];
                var actual1 = GetTextPointerByIndex(1, doc.ContentStart, LogicalDirection.Forward).GetTextInRun(LogicalDirection.Forward)[0];
                var actual2 = GetTextPointerByIndex(2, doc.ContentStart, LogicalDirection.Forward).GetTextInRun(LogicalDirection.Forward)[0];
                var actual3 = GetTextPointerByIndex(5, doc.ContentStart, LogicalDirection.Forward).GetTextInRun(LogicalDirection.Forward)[0];
                var actual4 = GetTextPointerByIndex(8, doc.ContentStart, LogicalDirection.Forward).GetTextInRun(LogicalDirection.Forward)[0];
                var actual5 = GetTextPointerByIndex(13, doc.ContentStart, LogicalDirection.Forward).GetTextInRun(LogicalDirection.Forward)[0];
                var actual6 = GetTextPointerByIndex(20, doc.ContentStart, LogicalDirection.Forward).GetTextInRun(LogicalDirection.Forward)[0];
                var actual7 = GetTextPointerByIndex(22, doc.ContentStart, LogicalDirection.Forward).GetTextInRun(LogicalDirection.Forward)[0];
                var actual8 = GetTextPointerByIndex(24, doc.ContentStart, LogicalDirection.Forward).GetTextInRun(LogicalDirection.Forward)[0];
                var actual9 = GetTextPointerByIndex(25, doc.ContentStart, LogicalDirection.Forward).GetTextInRun(LogicalDirection.Forward)[0];
                Debug.Assert(actual0 == '0');
                Debug.Assert(actual1 == '1');
                Debug.Assert(actual2 == '2');
                Debug.Assert(actual3 == '3');
                Debug.Assert(actual4 == '4');
                Debug.Assert(actual5 == '5');
                Debug.Assert(actual6 == '6');
                Debug.Assert(actual7 == '7');
                Debug.Assert(actual8 == '8');
                Debug.Assert(actual9 == '9');
            }
            {
                // LineBreak
                var p = new Paragraph();
                p.Inlines.AddRange(new Inline[] { new LineBreak(), new Run("A"), new LineBreak(), new LineBreak(), new Run("B"), });
                var doc = new FlowDocument(p);
                var actualA = GetTextPointerByIndex(2, doc.ContentStart, LogicalDirection.Forward).GetTextInRun(LogicalDirection.Forward)[0];
                var actualB = GetTextPointerByIndex(7, doc.ContentStart, LogicalDirection.Forward).GetTextInRun(LogicalDirection.Forward)[0];
                Debug.Assert(actualA == 'A');
                Debug.Assert(actualB == 'B');
            }
            {
                // Paragraphs sequence
            }
        }

        [Conditional("DEBUG")]
        public static void __t_GetTextPointerByIndex_Backward()
        {
            {
                var doc = new FlowDocument(new Paragraph(new Run("012\r\n3\r\n4\r\n\r\n5\r\r\n\n\r\r6\r7\n89")));
                // sideOfBound == LogicalDirection.Backward で '0' を得るのは不可能。
                //var actual0 = GetTextPointerByIndex(0, doc.ContentStart, LogicalDirection.Backward).GetTextInRun(LogicalDirection.Forward)[0];
                var actual1 = GetTextPointerByIndex(1, doc.ContentStart, LogicalDirection.Backward).GetTextInRun(LogicalDirection.Forward)[0];
                var actual2 = GetTextPointerByIndex(2, doc.ContentStart, LogicalDirection.Backward).GetTextInRun(LogicalDirection.Forward)[0];
                var actual3 = GetTextPointerByIndex(5, doc.ContentStart, LogicalDirection.Backward).GetTextInRun(LogicalDirection.Forward)[0];
                var actual4 = GetTextPointerByIndex(8, doc.ContentStart, LogicalDirection.Backward).GetTextInRun(LogicalDirection.Forward)[0];
                var actual5 = GetTextPointerByIndex(13, doc.ContentStart, LogicalDirection.Backward).GetTextInRun(LogicalDirection.Forward)[0];
                var actual6 = GetTextPointerByIndex(20, doc.ContentStart, LogicalDirection.Backward).GetTextInRun(LogicalDirection.Forward)[0];
                var actual7 = GetTextPointerByIndex(22, doc.ContentStart, LogicalDirection.Backward).GetTextInRun(LogicalDirection.Forward)[0];
                var actual8 = GetTextPointerByIndex(24, doc.ContentStart, LogicalDirection.Backward).GetTextInRun(LogicalDirection.Forward)[0];
                var actual9 = GetTextPointerByIndex(25, doc.ContentStart, LogicalDirection.Backward).GetTextInRun(LogicalDirection.Forward)[0];
                //Debug.Assert(actual0 == '0');
                Debug.Assert(actual1 == '1');
                Debug.Assert(actual2 == '2');
                Debug.Assert(actual3 == '3');
                Debug.Assert(actual4 == '4');
                Debug.Assert(actual5 == '5');
                Debug.Assert(actual6 == '6');
                Debug.Assert(actual7 == '7');
                Debug.Assert(actual8 == '8');
                Debug.Assert(actual9 == '9');
            }
            {
                // LineBreak
                var p = new Paragraph();
                p.Inlines.AddRange(new Inline[] { new LineBreak(), new Run("A"), new LineBreak(), new LineBreak(), new Run("B"), });
                var doc = new FlowDocument(p);
                var actualA = GetTextPointerByIndex(2, doc.ContentStart, LogicalDirection.Backward).GetTextInRun(LogicalDirection.Forward)[0];
                var actualB = GetTextPointerByIndex(7, doc.ContentStart, LogicalDirection.Backward).GetTextInRun(LogicalDirection.Forward)[0];
                Debug.Assert(actualA == 'A');
                Debug.Assert(actualB == 'B');
            }
            {
                // Paragraphs sequence
            }
        }

        //TODO: 検証
        public static Size Ppi(Visual visual)
        {
            //†: http://social.msdn.microsoft.com/Forums/vstudio/en-US/61e93dca-e24c-4953-9719-22ce3f705353/finding-dpi-using-wpf
            var source = PresentationSource.FromVisual(visual);
            Debug.Assert(source is PresentationSource);
            var m = source.CompositionTarget.TransformToDevice;
            return new Size(m.M11 * 96.0, m.M22 * 96.0);
        }

        public static void p(string category)
        {
            Debug.WriteLine(category);
        }
        public static void p(object value)
        {
            Debug.WriteLine(value);
        }
        public static void p(object value, string category)
        {
            Debug.WriteLine(value, category);
        }

        public static void p(Exception ex)
        {
            Debug.WriteLine(ex.Message, ex.Source);
        }
    }
}
