﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;
using System.Windows.Documents;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;
using System.Windows.Shapes;
using System.Diagnostics;
using System.Printing;
using System.Windows.Markup;


namespace JoinNotes
{
    /// <summary>
    /// Print.xaml の相互作用ロジック
    /// </summary>
    public partial class Print : Window
    {
        PrintTicket Ticket;
        PrintQueue Queue;
        bool IsReady = false;
        Dictionary<Uri, FlowDocument> UriToDocument = new Dictionary<Uri, FlowDocument> { };
        //List<Sheet> Forms = new List<Sheet> { };

        public Print(IEnumerable<Uri> documentUris)
            : this()
        {
            LoadDocuments(documentUris);
        }

        void LoadDocuments(IEnumerable<Uri> documentUris)
        {
            foreach (var uri in documentUris)
                this.UriToDocument.Add(uri, Editor.CreateNew(uri).RichTextBox.Document);
        }

        public Print()
        {
            InitializeComponent();
            this.Initialized += new EventHandler(Print_Initialized);
            this.Loaded += new RoutedEventHandler(Print_Loaded);
            this.Closed += new EventHandler(Print_Closed);

            //FIXME: 永続化と復帰
            this.PagesPerSheet_Horizontal.Value = 2;
            this.PagesPerSheet_Vertical.Value = 3;
            this.IsRenderFrames.IsChecked = true;
        }

        void Print_Closed(object sender, EventArgs e)
        {
            //TODO: 妥当性の確認
            this.UriToDocument.Clear();
            //this.Forms.Clear();

            GC.Collect(0, GCCollectionMode.Default);
        }

        PrintDialog Dialog = new PrintDialog();

        void Print_Loaded(object sender, RoutedEventArgs e)
        {
            var r = this.Dialog.ShowDialog();
            if (r.HasValue && r.Value)
            {
                this.Queue = this.Dialog.PrintQueue;
                this.Ticket = this.Dialog.PrintTicket;
                //this.Ticket = this.Queue.UserPrintTicket;
                Debug.WriteLine(new { UserPrintTicket_PageResolution = this.Queue.UserPrintTicket.PageResolution, PrintTicket_PageResolution = this.Dialog.PrintTicket.PageResolution }, "");
                this.IsReady = true;
                Render();
            }
        }

        void Print_Initialized(object sender, EventArgs e)
        {
        }

        private void cancel_Click(object sender, RoutedEventArgs e)
        {
            this.Close();
        }

        private void print_Click(object sender, RoutedEventArgs e)
        {
            PrintDocument();
            this.Close();
        }

        void PrintDocument()
        {
            var fixedDocument = new FixedDocument();
            var description = AboutBox1.AssemblyProduct;

            //UNDONE: 1x1でOutOfMemory
            var dpiX = (double)this.Ticket.PageResolution.X;
            var dpiY = (double)this.Ticket.PageResolution.Y;
            foreach (var image in CreateSheetImages(dpiX, dpiY))
            //var ppi = Util.Ppi(this);
            //foreach (var image in CreateSheetImages())
            {
                var page = new FixedPage();
                //var image = image.layout; // formはPageなので、WindowかFrameにしか入れられない。ここではformの内部だけを移す。
                //image.Content = null;

                //description += "; " + image.Description;

                page.Children.Add(image);
                //page.HorizontalAlignment = HorizontalAlignment.Stretch;
                //page.VerticalAlignment = VerticalAlignment.Stretch;

                ////HACK:
                //page.Width = this.Ticket.PageMediaSize.Width.Value;
                //page.Height = this.Ticket.PageMediaSize.Height.Value;

                ////FIXME:remove
                //page.Height = 600;

                var content = new PageContent();
                //content.Child = page;
                ((IAddChild)content).AddChild(page);

                //content.HorizontalAlignment = System.Windows.HorizontalAlignment.Stretch;
                //content.VerticalAlignment = System.Windows.VerticalAlignment.Stretch;

                //content.Height = page.Height;

                //Debug.Assert(image.HorizontalAlignment == System.Windows.HorizontalAlignment.Stretch);
                //Debug.Assert(image.VerticalAlignment == System.Windows.VerticalAlignment.Stretch);
                //HACK: layout.VerticalAlignment が Stretch かつ layout の親を変えたので、サイズを再設定する必要がある。
                //FIXME: 再設定不要な構造に
                //var height = image.ActualHeight;
                //image.VerticalAlignment = System.Windows.VerticalAlignment.Top;
                //image.Height = height;
                //Debug.Assert(!double.IsNaN(image.Height));
                //image.UpdateLayout();

                //page.UpdateLayout();
                //content.UpdateLayout();

                ////HACK:
                //layout.HorizontalAlignment = System.Windows.HorizontalAlignment.Left;
                //layout.VerticalAlignment = System.Windows.VerticalAlignment.Top;
                //var panel = ((Panel)layout.Children[0]);
                //panel.HorizontalAlignment = System.Windows.HorizontalAlignment.Left;
                //panel.VerticalAlignment = System.Windows.VerticalAlignment.Top;
                //layout.Width *= 2;
                //layout.Height /= 2;
                //panel.Width *= 2;
                //panel.Height /= 2;
                //layout.UpdateLayout();

                fixedDocument.Pages.Add(content);
            }

            {
                Debug.Assert(this.Ticket.PageMediaSize.Width.HasValue && this.Ticket.PageMediaSize.Height.HasValue);

                var paginator = fixedDocument.DocumentPaginator;
                paginator.PageSize = new Size(
                    //this.Ticket.PageMediaSize.Width.Value * (dpi / (double)ppi),
                    //this.Ticket.PageMediaSize.Height.Value * (dpi / (double)ppi));
                    this.Ticket.PageMediaSize.Width.Value,
                    this.Ticket.PageMediaSize.Height.Value);
                paginator.ComputePageCount();

                Debug.Assert(paginator.IsPageCountValid);
                this.Dialog.PrintDocument(paginator, description);
            }
        }

        void Render()
        {
            this.panel.Children.Clear();

            //FIXME: プレビューサイズが用紙サイズに合っていない。特に用紙の縦横向きを変えたとき。

            //TODO: this.Queue.Comment設定

            //var dpiX = (double)this.Ticket.PageResolution.X;
            //var dpiY = (double)this.Ticket.PageResolution.Y;
            //foreach (var image in CreateSheetImages(dpiX, dpiY))
            var ppi = Util.Ppi(this);
            foreach (var image in CreateSheetImages(ppi.Width, ppi.Height))
            {
                //var layout = image.layout; // formはPageなので、WindowかFrameにしか入れられない。ここではformの内部だけを移す。
                //image.Content = null;

                this.panel.Children.Add(image);
            }

            //this.panel.UpdateLayout();
            //this.UpdateLayout();
        }

        private IEnumerable<Image> CreateSheetImages(double dpiX, double dpiY)
        {
            var sheetImages = new List<Image> { };

            var ppi = Util.Ppi(this);

            Debug.WriteLine(new { dpiX, dpiY, ppi }, "! DPI");

            foreach (var uri in this.UriToDocument.Keys)
            {
                var document = Util.CloneDocument(this.UriToDocument[uri]);
                Debug.Assert(!document.IsSealed);

                {
                    document.BeginInit();
                    Debug.Assert(!document.IsSealed);
                    document.OverridesDefaultStyle = true;
                    var style = new Style();
                    style.Setters.Add(new Setter(FlowDocument.ForegroundProperty, Brushes.Black));
                    document.Style = style;
                    //FIXME: 設定:印刷用フォントにする
                    document.FontFamily = new FontFamily("Meiryo");

                    for (var pointer = document.ContentStart; pointer != null && pointer.CompareTo(document.ContentEnd) <= 0; pointer = pointer.GetNextContextPosition(LogicalDirection.Forward))
                    {
                        //HACK: なぜかRunに設定しないと文字色が有効にならない。
                        if (pointer.GetPointerContext(LogicalDirection.Forward) == TextPointerContext.Text)
                        {
                            var run = (Run)pointer.GetAdjacentElement(LogicalDirection.Backward);   //HACK: なぜかBackwardでなければ取得できない。
                            run.Foreground = Brushes.Black;
                        }
                    }


                    //FIXME: 最適化
                    document.Background = Brushes.White;
                    document.TextAlignment = TextAlignment.Left;
                    //document.ColumnWidth = this.Ticket.PageMediaSize.Width.Value / (double)this.PagesPerSheet_Horizontal.Value.Value;
                    //document.PageWidth = this.Ticket.PageMediaSize.Width.Value / (double)this.PagesPerSheet_Horizontal.Value.Value;
                    //document.PageHeight = this.Ticket.PageMediaSize.Height.Value / (double)this.PagesPerSheet_Vertical.Value.Value;
                    document.IsColumnWidthFlexible = true; // falseでもいい
                    document.EndInit();
                }

                //var ppi = Util.Ppi(this);
                //var ppiToDpiRateX = dpiX / (double)ppi.Width;
                //var ppiToDpiRateY = dpiY / (double)ppi.Height;

                var pageMediaSize = new Size(this.Ticket.PageMediaSize.Width.Value, this.Ticket.PageMediaSize.Height.Value);
                //var pageMediaSize = new Size(this.Ticket.PageMediaSize.Width.Value * ppiToDpiRateX, this.Ticket.PageMediaSize.Height.Value * ppiToDpiRateY);

                Debug.WriteLine(new { pageMediaSize_Height = pageMediaSize.Height, PagesPerSheet_Vertical = this.PagesPerSheet_Vertical.Value.Value }, "! ");

                var paginator = ((IDocumentPaginatorSource)document).DocumentPaginator;
                paginator.PageSize = new Size(
                    pageMediaSize.Width / (double)this.PagesPerSheet_Horizontal.Value.Value,
                    //pageMediaSize.Height / (double)this.PagesPerSheet_Vertical.Value.Value - (0.01 * dpiY)); //FIXME: 0.01dpi ではなく1文字分の高さにしたい。
                    pageMediaSize.Height / (double)this.PagesPerSheet_Vertical.Value.Value); //FIXME: 0.01dpi ではなく1文字分の高さにしたい。
                paginator.ComputePageCount();

                Debug.WriteLine(new { paginator.PageSize }, "! paginator.PageSize");

                Sheet sheet = null;
                var addSheetToSheetImages = new Action(() =>
                {
                    //var size = new Size() { Width = this.Ticket.PageMediaSize.Width.Value * (dpiX / (double)ppi), Height = this.Ticket.PageMediaSize.Height.Value * (dpiY / (double)ppi) };

                    //var orientation = this.Ticket.PageOrientation;
                    //if (orientation.HasValue && (orientation.Value == PageOrientation.Landscape || orientation.Value == PageOrientation.ReverseLandscape))
                    //    size = new Size() { Width = size.Height, Height = size.Width };

                    //sheet.Margin = new Thickness(imageSize.Width / (double)100); // 余白を与えるならMarginで。

                    //sheet.Measure(imageSize);
                    ////sheet.Arrange(new Rect(new Point(), sheet.DesiredSize));
                    sheet.Measure(pageMediaSize);
                    sheet.Arrange(new Rect(new Point(), pageMediaSize));

                    //sheet.layout.Measure(pageMediaSize);
                    //sheet.layout.Arrange(new Rect(new Point(), pageMediaSize));
                    //sheet.panel.Measure(pageMediaSize);
                    //sheet.panel.Arrange(new Rect(new Point(), pageMediaSize));

                    //sheet.UpdateLayout();

                    Debug.Write("");

                    //
                    //sheet.Width = sheet.MaxWidth = this.Ticket.PageMediaSize.Width.Value;
                    //sheet.Height = sheet.MaxHeight = this.Ticket.PageMediaSize.Height.Value;
                    ////FIXME: UpdateLayoutを必要なだけに
                    //sheet.UpdateLayout();

                    ////FIXME: reomve
                    //this.t.Content = sheet;

                    //UNDONE: 横1枠になるよう設定しても2枠になる。

                    Debug.Assert(PagesPerSheet_Horizontal.Value.HasValue && PagesPerSheet_Vertical.Value.HasValue);
                    Debug.Assert(Math.Abs(pageMediaSize.Width - paginator.PageSize.Width * PagesPerSheet_Horizontal.Value.Value) < 1 && Math.Abs(pageMediaSize.Height - paginator.PageSize.Height * PagesPerSheet_Vertical.Value.Value) < 1);

                    //var window = new Window() { Content = sheet };
                    //window.Show();
                    //window.Measure(pageMediaSize);
                    //window.Arrange(new Rect(new Point(), pageMediaSize));
                    //window.UpdateLayout();
                    //Debug.WriteLine(new { window.RenderSize, window.ActualHeight }, "! window");

                    Debug.WriteLine(new { pageMediaSize }, "! ");
                    Debug.WriteLine(new { sheet.RenderSize, sheet.ActualWidth, sheet.ActualHeight }, "! sheet");
                    Debug.WriteLine(new { sheet.panel.RenderSize, sheet.panel.ActualWidth, sheet.panel.ActualHeight }, "! panel");
                    Debug.WriteLine(new { ((Image)((Border)sheet.panel.Children[0]).Child).RenderSize.Height, ((Image)((Border)sheet.panel.Children[0]).Child).ActualHeight }, "! pageImage2 (== paginator.PageSize)");
                    Debug.WriteLine(new { ((RenderTargetBitmap)((Image)((Border)sheet.panel.Children[0]).Child).Source).Height, ((RenderTargetBitmap)((Image)((Border)sheet.panel.Children[0]).Child).Source).PixelHeight }, "! pageBitmap2 (== paginator.PageSize)");

                    ////var sheetBitmap = new RenderTargetBitmap((int)sheet.ActualWidth, (int)sheet.ActualHeight, dpiX, dpiY, PixelFormats.Default);
                    //var sheetBitmap = new RenderTargetBitmap((int)pageMediaSize.Width, (int)(pageMediaSize.Height), dpiX, dpiY, PixelFormats.Default);
                    //sheetBitmap.Render(window);
                    //
                    //Debug.WriteLine(new { sheetBitmap.PixelHeight }, "! sheetBitmap");

                    var sheetBitmap = new RenderTargetBitmap((int)(sheet.RenderSize.Width * (dpiX / ppi.Width)), (int)(sheet.RenderSize.Height * (dpiY / ppi.Height)), dpiX, dpiY, PixelFormats.Default);

                    sheetBitmap.Render(sheet);

                    Debug.WriteLine(new { sheetBitmap.PixelHeight }, "! sheetBitmap");

                    var sheetImage = new Image()
                    {
                        Source = sheetBitmap,
                        Stretch = Stretch.Uniform, // Uniform: for preview resizing.
                        StretchDirection = StretchDirection.DownOnly, // DownOnly: for preview resizing.
                        //Stretch = Stretch.None,
                        //MaxWidth = sheetBitmap.Width,
                        //MaxHeight = sheetBitmap.Height,
                        //HorizontalAlignment = System.Windows.HorizontalAlignment.Stretch,
                        //VerticalAlignment = System.Windows.VerticalAlignment.Stretch,
                        //SnapsToDevicePixels = true,
                    };

                    //sheetImage.Measure(new Size(sheetBitmap.PixelWidth * ppiToDpiRateX, sheetBitmap.PixelHeight * ppiToDpiRateY));
                    //sheetImage.Arrange(new Rect(0, 0, sheetBitmap.PixelWidth * ppiToDpiRateX, sheetBitmap.PixelHeight * ppiToDpiRateY));

                    sheetImages.Add(sheetImage);

                    ////FIXME: remove
                    //foreach (var uiElement in sheet.panel.Children)
                    //{
                    //    var image = (Image)((Border)uiElement).Child;
                    //    //image.Measure(pageMediaSize);
                    //    //image.Arrange(new Rect(new Point(), pageMediaSize));
                    //
                    //    //Debug.Assert(image.ActualHeight * PagesPerSheet_Vertical.Value.Value <= sheet.ActualHeight
                    //    //    && sheet.ActualHeight < image.ActualHeight * (PagesPerSheet_Vertical.Value.Value + 1),
                    //    //    (image.ActualHeight * PagesPerSheet_Vertical.Value.Value).ToString() + ", " + sheet.ActualHeight.ToString());
                    //}

                    ////FIXME: remove
                    //var w = new Window1();
                    //w.layout.Child = sheetImage;
                    //w.Show();

                    ////FIXME: remove
                    //sheetImages.Add((Image)((Border)sheet.panel.Children[0]).Child);
                    //((Border)sheet.panel.Children[0]).Child = null;

                });

                for (var pageIndex = 0; pageIndex <= paginator.PageCount - 1; ++pageIndex)
                {
                    if (pageIndex % (this.PagesPerSheet_Horizontal.Value.Value * this.PagesPerSheet_Vertical.Value.Value) == 0)
                    {
                        if (sheet != null)
                            addSheetToSheetImages();

                        sheet = new Sheet();
                    }

                    Debug.Assert(sheet != null);

                    //FIXME: scope
                    {
                        var page = paginator.GetPage(pageIndex);

                        var pageBitmap = new RenderTargetBitmap((int)(page.Size.Width * (dpiX / ppi.Width)), (int)(page.Size.Height * (dpiY / ppi.Height)), dpiX, dpiY, PixelFormats.Default);
                        pageBitmap.Render(page.Visual);

                        Debug.WriteLine(new { pageBitmap.Height, pageBitmap.PixelHeight }, "! pageBitmap");

                        var pageImage = new Image()
                        {
                            Source = pageBitmap,
                            //Stretch = Stretch.Uniform,
                            //StretchDirection = StretchDirection.DownOnly,
                            Stretch = Stretch.None,
                            //Width = pageBitmap.PixelWidth,
                            //Height = pageBitmap.PixelHeight,
                            //MaxWidth = paginator.PageSize.Width,
                            //MaxHeight = paginator.PageSize.Height,
                            //HorizontalAlignment = System.Windows.HorizontalAlignment.Stretch,
                            //VerticalAlignment = System.Windows.VerticalAlignment.Stretch,
                            //SnapsToDevicePixels = true,
                        };

                        //pageImage.Measure(new Size(pageBitmap.Width * ppiToDpiRateX, pageBitmap.Height * ppiToDpiRateY));
                        //pageImage.Arrange(new Rect(0, 0, pageBitmap.Width * ppiToDpiRateX, pageBitmap.Height * ppiToDpiRateY));

                        //pageImage.HorizontalAlignment = System.Windows.HorizontalAlignment.Center;
                        //pageImage.VerticalAlignment = System.Windows.VerticalAlignment.Center;
                        //pageImage.Width = paginator.PageSize.Width;
                        //pageImage.Height = paginator.PageSize.Height;

                        //pageImage.Measure(new Size(pageBitmap.PixelWidth, pageBitmap.PixelHeight));
                        //pageImage.Arrange(new Rect(0, 0, pageBitmap.PixelWidth, pageBitmap.PixelHeight));

                        //pageImage.Measure(new Size(paginator.PageSize.Width, paginator.PageSize.Height));
                        //pageImage.Arrange(new Rect(0, 0, paginator.PageSize.Width, paginator.PageSize.Height));

                        //pageImage.Measure(new Size(paginator.PageSize.Width * 2, paginator.PageSize.Height * 2));
                        //pageImage.Arrange(new Rect(0, 0, paginator.PageSize.Width * 2, paginator.PageSize.Height * 2));

                        Debug.WriteLine(new { pageImage.RenderSize, pageImage.ActualHeight }, "! pageImage1");

                        var pageBorder = new Border()
                        {
                            Child = pageImage,
                            BorderBrush = (this.IsRenderFrames.IsChecked.HasValue && this.IsRenderFrames.IsChecked.Value)
                                ? Brushes.Silver : Brushes.Transparent,
                            BorderThickness = new Thickness(),
                            //BorderThickness = new Thickness(0.005 * (dpiX + dpiY) / 2D),
                            //Width = pageBitmap.PixelWidth,
                            //Height = pageBitmap.PixelHeight,
                            //MaxWidth = paginator.PageSize.Width,
                            //MaxHeight = paginator.PageSize.Height,
                            //HorizontalAlignment = System.Windows.HorizontalAlignment.Stretch,
                            //VerticalAlignment = System.Windows.VerticalAlignment.Stretch,
                            //SnapsToDevicePixels = true,
                        };

                        Debug.WriteLine(new { pageBorder.RenderSize, pageImage.ActualHeight }, "! pageBorder");

                        sheet.panel.Children.Add(pageBorder);
                        sheet.panel.UpdateLayout();
                    }
                    //TODO: IsRenderLabels_Changedの反映

                    //TODO: set sheet.Description

                    //FIXME: 用紙あたりのマージンが有効になっていない。
                }

                if (sheet.panel.Children.Count >= 1)
                    addSheetToSheetImages();
            }

            return sheetImages;
        }

        private void PagesPerSheet_Horizontal_ValueChanged(object sender, RoutedPropertyChangedEventArgs<object> e)
        {
            if (this.IsReady)
                Render();
        }

        private void PagesPerSheet_Vertical_ValueChanged(object sender, RoutedPropertyChangedEventArgs<object> e)
        {
            if (this.IsReady)
                Render();
        }

        private void IsRenderLabels_Changed(object sender, RoutedEventArgs e)
        {
            if (this.IsReady)
                Render();
        }

        private void IsRenderFrames_Changed(object sender, RoutedEventArgs e)
        {
            if (this.IsReady)
                Render();
        }

    }
}
