static	char	sccsid[]="%Z% %M% %I% %E% %U%";
#include "akbcommon.h"

#undef DEBUGINPUT
#define DEBUGINPUT

static int   giMAX_TOINDIRF_SIZE = MAX_TOINDIRF_SIZE;
static int   giMAX_INDIRF_COUNT  = MAX_INDIRF_COUNT;
static char *gcpSPOOL = NULL;
static char  gcOPE_INDIRF[8] = {'D','E','L','E','T','E','\0'};

/****************************************/
/*										*/
/****************************************/
static char *_set_spool(p)
char *p;
{
	if (p) {
		if (gcpSPOOL) Free(gcpSPOOL);
		gcpSPOOL = Strdup(p);
	}
	else if (!gcpSPOOL) gcpSPOOL = Strdup(INDIRF_SPOOL);

	return gcpSPOOL;
}

/****************************************/
/*										*/
/****************************************/
static int _get_com_property(buf,len)
char *buf;
int  len;
{
	int ret=0;

	sprintf(buf,"MAX_INDIRF %d %d %s %s",
		giMAX_TOINDIRF_SIZE,giMAX_INDIRF_COUNT,_set_spool(NULL),gcOPE_INDIRF);
	return ret;
}

/****************************************/
/*										*/
/****************************************/
static int _set_com_property(n,argv)
int  n;
char *argv[];
{
	int val,ret,i;

/*	_set_spool(NULL);	*/
	if (!argv) return -1;
	ret = 0;
	for (i=0;i<n;i++) {

DEBUGOUTL2(AKB_LOG_GROUP|200,"_set_com_property: i=%d argv=[%s]",i,argv[i]);

		if (!*argv[i]) continue;
		else if (i == 2) {
			_set_spool(argv[2]);

DEBUGOUTL1(AKB_LOG_GROUP|200,"_set_com_property: gcpSPOOL=[%s]",gcpSPOOL);

		}
		else if (i == 3) {
			strnzcpy(gcOPE_INDIRF,argv[3],sizeof(gcOPE_INDIRF)-1);

DEBUGOUTL1(AKB_LOG_GROUP|200,"_set_com_property: gcOPE_INDIRF=[%s]",gcOPE_INDIRF);

		}
		else if (*argv[i] == '.') continue;
		else if (!(ret = akxcgcvn(argv[i],strlen(argv[i]),&val))) {
			if (i == 0) {
				if (val < 4096) ret = -2;
				else giMAX_TOINDIRF_SIZE = val;

DEBUGOUTL2(AKB_LOG_GROUP|200,"_set_com_property: giMAX_TOINDIRF_SIZE=%d ret=%d",
giMAX_TOINDIRF_SIZE,ret);

			}
			else if (i == 1) {
				if (val <= 0) ret = -3;
				else giMAX_INDIRF_COUNT = val;

DEBUGOUTL2(AKB_LOG_GROUP|200,"_set_com_property: giMAX_INDIRF_COUNT=%d ret=%d",
giMAX_INDIRF_COUNT,ret);

			}
		}
		if (ret) break;
	}
	return ret;
}

/****************************************/
/*										*/
/****************************************/
int akb_get_inf_max_indirf(buf,len)
char *buf;
int  len;
{
	int ret;
	char *argv[4],parm[256];

DEBUGOUTL1(AKB_LOG_GROUP|200,"akb_get_inf_max_indirf: buf=0x%08x",buf);

	if (buf) {
		ret = akxtgetargv(buf,argv,4,parm,sizeof(parm));
		if (!stricmp(argv[0],"GET")) return _get_com_property(buf,len);
	}
	else {
		ret = akb_gs_akb_stpl(D_SECTION_AKB_SYSTEM,"MAX_INDIRF",argv,4);
		ret = 0;
	}

DEBUGOUTL1(AKB_LOG_GROUP|200,"akb_get_inf_max_indirf: n=%d",ret);

	if (ret > 1) {
		ret = _set_com_property(ret-1,&argv[1]);
	}
	_set_spool(NULL);
	if (ret < 0) ERROROUT1("akb_get_inf_max_indirf: ret=%d",ret);
	return ret;
}

/******************************************************************************
  ֐
        int    akbreadline()

  

  ԋpl
		0		ǂݍݏI
		1		ǂݍ݌p

  Tv
       Ps̒255byteȏ̏ꍇȏ͓̕ǂ݂Ƃ΂B
        ŏ255bytebufɊi[B
******************************************************************************/
int akbreadline(buf ,size , fp)
char	*buf;
int		size;
FILE	*fp;
{
	return akxa_read_line(buf ,size , fp);
}

char *akb_packet_new(iLen)
int iLen;
{
	char *p;
	int  n;

	if (iLen >= 0) {
		if (p = Malloc(n=(sizeof(tdtCOMM_PACK_HEAD)+iLen))) {
			memset(p,0,n);
		}
	}
	else p = NULL;
	return p;
}

#ifdef WITH_VER_B
void
akb_crt_err_packetB(pPacket,iErrorCode)
pCOMM_PACK_HEADB	pPacket;		/* 쐬G[pPbg */
int iErrorCode;
{
	/* G[pPbg̍쐬 */
	akb_exchg_indicate(pPacket);

	/* hcO̕ɃG[tOݒ肷 */
	if (pPacket->phb_sind.inb_pkid) {
		pPacket->phb_dind.inb_pkid = htonl(iErrorCode);
	} else {
		pPacket->phb_sind.inb_pkid = htonl(iErrorCode);
	}
}
#endif

/******************************************************************************
  ֐
        void    akb_crt_err_packet()

  

  ԋpl

  Tv
		G[pPbg̍쐬B
******************************************************************************/
void
akb_crt_err_packet(pPacket,iErrorCode)
pCOMM_PACK_HEAD	pPacket;		/* 쐬G[pPbg */
int iErrorCode;
{
	tdtINDICATEA     temp;
	short sErrorCode;
	pCOMM_PACK_HEADA pHA;

#ifdef WITH_VER_B
	if (pPacket->cph_prt.prt_ver == 'B') {
		akb_crt_err_packet(pPacket,iErrorCode);
		return;
	}
#endif
	/* G[pPbg̍쐬 */
	sErrorCode = iErrorCode;
	akb_exchg_indicate(pPacket);
	if (pPacket->cph_prt.prt_ver == 'A') {
		pHA = (pCOMM_PACK_HEADA)pPacket;
		/* hcO̕ɃG[tOݒ肷 */
		if (pHA->pha_sinf.ina_thrd)
			pHA->pha_dinf.ina_pano = htons(sErrorCode);
		else
			pHA->pha_sinf.ina_pano = htons(sErrorCode);
	}
	else {
		/* hcO̕ɃG[tOݒ肷 */
		if (pPacket->cph_sinf.ind_thrd)
			pPacket->cph_dinf.ind_pano = htons(sErrorCode);
		else
			pPacket->cph_sinf.ind_pano = htons(sErrorCode);
	}
}

/******************************************************************************
  ֐
        int    akb_is_packet()

  

  ԋpl

  Tv
		pPbgʂ𔻒fB
******************************************************************************/
int
akb_is_packet(pH)
pCOMM_PACK_HEAD pH;
{
	tdtCOMM_PACK_HEAD Head,*pHead;
	char ver;
	int cmd_pack,akb_error,akb_opt,ret;

	ver = pH->cph_prt.prt_ver;
#ifdef WITH_VER_B
	if (ver == 'B') return akb_is_packet(pH);
#endif
	pHead = pH;
	if (ver == 'A') {
		akb_get_head_from_a(&Head,pH);
		pHead = &Head;
	}
	if (pHead->cph_sinf.ind_thrd) {	/* MpPbg*/
		akb_error = pHead->cph_dinf.ind_pano;
		akb_opt = pHead->cph_dinf.ind_disp;
		cmd_pack = 1;
	}
	else {	/* ԐMpPbg*/
		akb_error = pHead->cph_sinf.ind_pano;
		akb_opt = pHead->cph_sinf.ind_disp;
		cmd_pack = 0;
	}
	ret = 0;
	/* G[pPbgۂ̌ */
	if (akb_error) ret |= D_PACKET_IS_ERROR;	/* G[pPbg*/
	if (akb_opt & AKB_AKO_NOREPLY) ret |= D_PACKET_IS_NOREPLY;
	if (akb_opt & AKB_AKO_ROUTED)  ret |= D_PACKET_IS_ROUTED;
	/* MpPbgۂ̌ */
	if (cmd_pack) {
		/* MpPbg */
		ret |= D_PACKET_IS_SEND;
	} else {
		/* ԐMpPbg */
		if (pHead->cph_dinf.ind_hoid==D_HID_BROADCAST ||
		    pHead->cph_dinf.ind_prid>AKB_PID_MAX)
			ret |= D_PACKET_IS_BROADCAST;
		ret |= D_PACKET_IS_RESEND;
	}
	return ret;
}

#ifdef WITH_VER_B
int akb_is_packetB(pHead)
pCOMM_PACK_HEADB pHead;
{
	/* G[pPbgۂ̌ */
	if (pHead->phb_sind.inb_pkid != 0 && pHead->phb_dind.inb_pkid != 0)
	{
		/* G[pPbg */
		return (D_PACKET_IS_ERROR);
	}else
	{
		/* ʏpPbg */
		/* MpPbgۂ̌ */
		if (pHead->phb_sind.inb_pkid != 0
					&& pHead->phb_dind.inb_pkid == 0)
		{
			/* MpPbg */
			return (D_PACKET_IS_SEND);
		}else
		{
			/* ԐMpPbg */
			return (D_PACKET_IS_RESEND);
		}
	}
}
#endif


static int lFcount=0;

int akb_sck_to_indir_f(applid,pHead,iSd,ppPacket)
char *applid,**ppPacket;
pCOMM_PACK_HEAD	pHead;
int iSd;
{
/*
printf("akb_sck_to_indir_f: called\n");
*/
	return akb_to_indir_f(applid,pHead,iSd,NULL,ppPacket);
}

int akb_mem_to_indir_f(applid,pHead,pMem,ppPacket)
char *applid,**ppPacket,*pMem;
pCOMM_PACK_HEAD	pHead;
{
/*
printf("akb_mem_to_indir_f: called\n");
*/
	return akb_to_indir_f(applid,pHead,0,pMem,ppPacket);
}

int akb_to_indir_f(applid,pHead,iSd,pMem,ppPacket)
char *applid,**ppPacket,*pMem;
pCOMM_PACK_HEAD	pHead;
int iSd;
{
	tdtINDIRECT_INFO *pIndirF;
	FILE *fp;
	char *fname,buf[4096],*pPacket,*cpPath,ver,*wrk;
	int lLen,wlen,rlen;
	int irc,iHSize;
	pCOMM_PACK_HEAD	pPaHead;
	pCOMM_PACK_HEADA	pPHA;
	static char *cpDir=NULL;

	if (iSd==0 && pMem==NULL) return -1;
	if (pHead->cph_prt.prt_send & 0x80) return 0;
	ver = pHead->cph_prt.prt_ver;
	if (ver == 'A') {
		pPHA = (pCOMM_PACK_HEADA)pHead;
		lLen = ntohl(pPHA->pha_plen);
		iHSize = sizeof(tdtCOMM_PACK_HEADA);
	}
	else {
		lLen = ntohl(pHead->cph_plen);
		iHSize = sizeof(tdtCOMM_PACK_HEAD);
	}
	if (lLen <= giMAX_TOINDIRF_SIZE) return 0;
	fname = buf;
#if 0	/* 2001.12.12 Koba */
	sprintf(buf,"%s.%d",applid,lFcount++);
	wrk = buf + strlen(buf) + 1;
	if (akb_gs_akbname(BLK_AKBSYSTEM,"SPOOL",wrk) > 0) {
		if (!(fname = akxt_add_dir2(wrk,buf,&cpDir))) fname = buf;
	}
#else
#if 1	/* 2005.2.14 Koba */
	sprintf(fname,"%s/%s.%d",gcpSPOOL,applid,lFcount++);
#else
	sprintf(fname,"spool/%s.%d",applid,lFcount++);
#endif
#endif
	if (lFcount >= giMAX_INDIRF_COUNT) lFcount = 0;	/* add 2000.7.31 Koba */
	if (!(cpPath = akb_akb_home_add(fname))) {
		return -3;
	}
/*
printf("akb_to_indir_f:lLen=%d,file=[%s]\n",lLen,fname);
*/
	if (!(fp=fopen(cpPath,"wb"))) {
		ERROROUT1("akb_to_indir_f:file[%s] open error!!",cpPath);
		return -2;
	}
	if (iSd>0) {
		while (lLen>0) {
			if ((wlen=lLen) > sizeof(buf)) wlen = sizeof(buf);
			rlen = akb_sk_read(iSd,buf,wlen);
			if (rlen<0) {
				fclose(fp);
				return rlen;
			}
			if ((irc = fwrite(buf,1,rlen,fp))!=rlen) {
				fclose(fp);
				return -1;
			}
			lLen -= rlen;
		}
	}
	else {
		if((irc = fwrite(pMem,1,lLen,fp))!=lLen) {
			fclose(fp);
			return -1;
		}
	}
	fclose(fp);

	if (!(pPacket = Malloc(iHSize+sizeof(tdtINDIRECT_INFO)+
	                       strlen(fname)))) return -1;
	pPaHead = (pCOMM_PACK_HEAD)pPacket;
	memcpy(pPaHead,pHead,iHSize);
	pPaHead->cph_prt.prt_send |= 0x81;	/* mod 2000.9.13 Koba */
	lLen = sizeof(tdtINDIRECT_INFO)+strlen(fname);
	if (ver == 'A') {
		pPHA = (pCOMM_PACK_HEADA)pPaHead;
		pPHA->pha_plen = htonl(lLen);
	}
	else pPaHead->cph_plen = htonl(lLen);
	pIndirF = (tdtINDIRECT_INFO *)(pPaHead + 1);
	pIndirF->ini_did   = 'F';
/*
	pIndirF->ini_spos = pPaHead->cph_plen - 4;
*/
	pIndirF->ini_spos = lLen - 4;
	pIndirF->ini_resv[0] = pHead->cph_prt.prt_send;
	pIndirF->ini_dpos = 0;
	pIndirF->ini_dlen = pHead->cph_plen;
	memcpy(pIndirF+1,fname,strlen(fname));
	*ppPacket = pPacket;
/*
printf("akb_to_indir_f:lPacLen=%d\n",lLen);
*/
	return iHSize + lLen;
}

int akb_from_indir_f(pcInHead,pcInBody,ppPacket)
char *pcInHead,*pcInBody,**ppPacket;
{
    tdtINDIRECT_INFO *pIndirF;
	FILE *fp;
	char fname[32],*pPacket,*cpPath,ver;
	int lLen;
	int irc,iHSize;
	pCOMM_PACK_HEAD	pInHead, pHead;
	pCOMM_PACK_HEADA	pPHA;

	pInHead = (pCOMM_PACK_HEAD)pcInHead;
	if (!(pInHead->cph_prt.prt_send & 0x80)) return 0;
	pIndirF = (tdtINDIRECT_INFO *)pcInBody;
	if (pIndirF->ini_did != 'F') return -1;
	lLen = ntohl(pIndirF->ini_dlen);

	memcpy(fname,pIndirF+1,pIndirF->ini_spos - 8);
	fname[pIndirF->ini_spos - 8] = '\0';
	if (!(cpPath = akb_akb_home_add(fname))) {
		return -3;
	}
/*
printf("akb_from_indir_f:file=[%s],lLen=%d\n",fname,lLen);
*/
	if (!(fp=fopen(cpPath,"rb"))) {
		ERROROUT1("akb_from_indir_f:file[%s] open error!!",cpPath);
		return -1;
	}

	ver = pInHead->cph_prt.prt_ver;
	if (ver == 'A') {
		pPHA = (pCOMM_PACK_HEADA)pInHead;
		iHSize = sizeof(tdtCOMM_PACK_HEADA);
	}
	else {
		iHSize = sizeof(tdtCOMM_PACK_HEAD);
	}
	if (!(pPacket = Malloc(iHSize+lLen+1))) {
		fclose(fp);
		return -1;
	}

	if (irc = fseek(fp,ntohl(pIndirF->ini_dpos),0)) {
		fclose(fp);
		return -1;
	}
	irc = fread(pPacket+iHSize,1,lLen,fp);
	fclose(fp);
	if (irc != lLen) return -1;

	if (toupper(gcOPE_INDIRF[0]) != 'S') unlink(cpPath);

	memcpy(pPacket,pcInHead,iHSize);
	pHead = (pCOMM_PACK_HEAD)pPacket;
	pHead->cph_prt.prt_send = pIndirF->ini_resv[0];
	if (ver == 'A') {
		pPHA = (pCOMM_PACK_HEADA)pHead;
		pPHA->pha_plen = htonl(lLen);
	}
	else pHead->cph_plen = htonl(lLen);
	*ppPacket = pPacket;
	return iHSize + lLen;
}

int akbi_from_indir_f(pNew)
pSD_PACKET_TABLE pNew;
{
	int  irc,iHSize;
	char *packet,*pPacket;
	pCOMM_PACK_HEAD 	pHead;

	packet = pNew->sp_content;
	pHead = (pCOMM_PACK_HEAD)packet;
	AKBGETHSIZE(pHead,iHSize)
	irc = akb_from_indir_f(packet,packet+iHSize,&pPacket);
	if (irc>0) {
		Free(pNew->sp_content);
		pNew->sp_len = irc;
		pNew->sp_content = pPacket;
	}
	return irc;
}

pSD_PACKET_TABLE akb_make_xpacket(pNew)
pSD_PACKET_TABLE pNew;
{
	int  irc,iHSize;
	char *pPacket;
	pCOMM_PACK_HEAD 	pHead;
	pCOMM_PACK_HEADA	pHA;

#if 1
	irc = akbi_from_indir_f(pNew);
	if (irc < 0) return NULL;
#else
	pHead = (pCOMM_PACK_HEAD)pNew->sp_content;
	if (pHead->cph_prt.prt_ver == 'A') {
		pHA = (pCOMM_PACK_HEADA)pHead;
		iHSize = sizeof(tdtCOMM_PACK_HEADA);
	}
	else iHSize = sizeof(tdtCOMM_PACK_HEAD);

	irc = akb_from_indir_f(pNew->sp_content,pNew->sp_content+iHSize,&pPacket);
	if (irc<0) {
	/*************************
		Free(pNew->sp_content);
		Free(pNew);
	**************************/
		return (pSD_PACKET_TABLE)NULL;
	}
	else if (irc>0) {
		Free(pNew->sp_content);
		pNew->sp_len = irc;
		pNew->sp_content = pPacket;
	}
#endif
	return akbs_make_xpacket(pNew);
}

int akbi_make_indir_f(pNew,applid)
pRC_PACKET_TABLE pNew;
char *applid;
{
	int len,iHSize,iRc,iTbl;
	char *cpW,*packet;
	pCOMM_PACK_HEAD   pHead;

	packet = pNew->sp_content;
	pHead = (pCOMM_PACK_HEAD)packet;
	AKBGETHSIZE(pHead,iHSize)
	len = akb_mem_to_indir_f(applid,packet,packet+iHSize,&cpW);
	if (len>0) {
		Free(packet);
		pNew->sp_len = len;
		pNew->sp_content = cpW;
	}
	return len;
}

pSD_PACKET_TABLE akb_xto_fpacket(pNew,cpProc)
pSD_PACKET_TABLE pNew;
char *cpProc;
{
	int  irc,iHSize;
	char *pPacket;
	pCOMM_PACK_HEAD 	pHead;
	pCOMM_PACK_HEADA	pHA;

	if (!(pNew=akbs_xto_fpacket(pNew))) return NULL;
#if 1
	irc = akbi_make_indir_f(pNew,cpProc);
	if (irc < 0) return NULL;
#else
	pHead = (pCOMM_PACK_HEAD)pNew->sp_content;
	if (pHead->cph_prt.prt_ver == 'A') {
		pHA = (pCOMM_PACK_HEADA)pHead;
		iHSize = sizeof(tdtCOMM_PACK_HEADA);
	}
	else iHSize = sizeof(tdtCOMM_PACK_HEAD);

	irc = akb_mem_to_indir_f(cpProc,pNew->sp_content,pNew->sp_content+iHSize,&pPacket);
	if (irc>0) {
		Free(pNew->sp_content);
		pNew->sp_len = irc;
		pNew->sp_content = pPacket;
	}
/*
	else if (irc<0) {
		Free(pNew->sp_content);
		Free(pNew);
		return (pSD_PACKET_TABLE)NULL;
	}
*/
#endif
	return pNew;
}

int akb_is_right_head(pHd)
tdtCOMM_PACK_HEAD *pHd;
{
	tdtCOMM_PACK_HEAD   *pH, Head, *pHead;
	tdtCOMM_PACK_HEADA  *pHA;
	short sCmd;
	uchar uc,ver;
	char  buf1[50],buf2[20],*p,*pp;
	int   i;

	pH  = (tdtCOMM_PACK_HEAD  *)pHd;
	pHA = (tdtCOMM_PACK_HEADA *)pHd;
	ver = pH->cph_prt.prt_ver;
	sCmd = ntohs(pH->cph_prt.prt_cmnd);
	uc = pH->cph_prt.prt_send;	/* mod 2000.11.13 Koba */
	ver = pH->cph_prt.prt_ver;
	if ((ver == 'A' || ver == 'C' || ver == 'B') && (
#if 0	/* 2000.9.13 Koba */
	     pH->cph_prt.prt_send<=0x01
#else
#if 1	/* 2000.12.1 Koba */ /* 0->1 2000.12.6 Koba */
	     !(uc & ~(AKB_PFM_INDIRECT | AKB_PFM_CDTYPE | AKB_PFM_NEED_REPLY |
	              AKB_PFM_SYSINDIR | AKB_PFM_PRIORITY))
#else
	     !(uc & ~(AKB_PFM_INDIRECT | AKB_PFM_SYSINDIR))
#endif
#endif
	     && ((ver!='A' && sCmd>=1 && sCmd<=255) ||
	         (ver=='A' && sCmd==5)))) {
		pHead = pH;
		if (ver == 'A') {
			akb_get_head_from_a(&Head,pH);
			pHead = &Head;
		}
		if ((ver == 'A' || ver == 'C') &&
		    ((pHead->cph_sinf.ind_thrd && pHead->cph_dinf.ind_thrd) ||
		     (!pHead->cph_sinf.ind_thrd && !pHead->cph_dinf.ind_thrd)))
			return D_ERR_PACKET;
	}
	else {
		p = (char *)pHd;
		pp = buf1;
		for (i=0;i<16;i++) {
			sprintf(pp,"%02x ",(int)*p & 0xff);
			pp += 3;
			buf2[i] = akxctoank(*p++);
		}
		buf2[16] = *(pp-1) = '\0';
		ERROROUT2("akb_is_right_head: Bad Header (%s)[%s]",buf1,buf2);
	/*
		ERROROUT1("akb_is_right_head: Bad Header ID ver = %02x",ver);
		if (DEBUGOUTCHECK(AKB_LOG_GROUP|252)) akxaxdump("Header",pH,32);
	*/
		return D_ERR_PACKET;
	}
	return 0;
}

int akb_set_rb_pack_err_cd(iCh,pPacket,pRbCtl,iErrorCode)
int				iCh;			/* G[pPbg𑗕t\Pbg */
pCOMM_PACK_HEAD	pPacket;		/* tG[pPbg̑f */
tdtRB_CTL  *pRbCtl;
int  iErrorCode;
{
	pSD_PACKET_TABLE  pNew ;
	int iRc;
	pCOMM_PACK_HEADA	pPA;

	if (iCh < 0) return (-1);

	/* ΏۂƂȂpPbgG[pPbgۂ`FbN */
	iRc = akb_is_packet(pPacket);
	if (iRc & (D_PACKET_IS_ERROR | D_PACKET_IS_NOREPLY | D_PACKET_IS_BROADCAST)) {
		/* G[pPbgȂ̂ŏł */
		ERROROUT3("akb_set_rb_pack_err_cd:drop packet(%d) iCh=%d iErrorCode=%d",iRc,iCh,iErrorCode);
		return(iRc);
	}

	/* G[pPbg̍쐬 */
	akb_crt_err_packet(pPacket,iErrorCode);

	/* G[pPbg̑M */
	pNew = akb_packet_tbl_new(0);
	if ( pNew == NULL ) {
       	return(D_ERR_MEM_ALLOC);
	}
	pNew->sp_content = (char *)pPacket;
	if (pPacket->cph_prt.prt_ver == 'A') {
		pPA = (pCOMM_PACK_HEADA)pPacket;
		pNew->sp_len = sizeof(tdtCOMM_PACK_HEADA) + ntohl(pPA->pha_plen);
	}
	else pNew->sp_len = sizeof(tdtCOMM_PACK_HEAD) + ntohl(pPacket->cph_plen);
	pNew->sp_ch      = iCh ;
	pNew->sp_offset   = 0;	/* add 1998.3.3 Koba */
	if (!akxs_rb_set_n(pRbCtl,pNew)) {
		Free(pNew);
		return -1;
	}
/*
printf("akb_set_rb_pack_err_cd: pNew=%08x iCh=%d iLen=%d offset=%d pContent=%08x\n",
pNew,pNew->sp_ch,pNew->sp_len,pNew->sp_offset,pNew->sp_content);
*/
	/* I */
	return 0;
}

int akb_set_rb_err_packet(iCh,pPacket,pRbCtl)
int				iCh;			/* G[pPbg𑗕t`l */
pCOMM_PACK_HEAD	pPacket;		/* tG[pPbg̑f */
tdtRB_CTL  *pRbCtl;
{
	return akb_set_rb_pack_err_cd(iCh,pPacket,pRbCtl,-9999);
}

int akb_get_term_base(pid)
int *pid;
{
	char *argv[4];
	int n, i;

	pid[0] = D_PRID_TERM_BASE;
	pid[1] = D_PRID_TERM_MAX;
	n = akb_gs_akb_stpl("TERMINFO","PROCID",argv,3);
	if (n < 0) return n;
	if (n >= 2) {
		i = atoi(argv[1]);
		if (i<=0 || i>=D_PRID_MAX) i = D_PRID_TERM_BASE;
		pid[0] = i;
		if (pid[0]>=pid[1]) pid[1] = pid[0] + 1;
	}
	if (n >= 3) {
		i = atoi(argv[2]);
		if (i>pid[0] &&  i<=D_PRID_MAX) pid[1] = i;
	}
/*
printf("akb_get_term_base:n=%d base=%d max=%d\n",n,pid[0],pid[1]);
*/
	return 0;
}

char *akbmalloc( size, file, line )
int     size;
char    *file;
int     line;
{
	return akxm_malloc( size, file, line );
}

int akb_get_head_from_a(PH,PHA)
INT4 PH[];
INT4 PHA[];
{
	if (!PH || !PHA) return -1;
	PH[0] = PHA[0];
	PH[1] = PHA[4];
	PH[2] = PHA[6];
	PH[3] = PHA[7];
	PH[4] = PHA[11];
	PH[5] = PHA[13];
	PH[6] = PHA[14];
	PH[7] = PHA[15];
	return 0;
}

int akb_set_head_to_a(PH,PHA)
INT4 PH[];
INT4 PHA[];
{
	if (!PH || !PHA) return -1;
	memset(PHA,0,64);
	PHA[0]  = PH[0];
	PHA[3]  = -1;		/* IPV4 mapped IPV6 */
	PHA[4]  = PH[1];
	PHA[6]  = PH[2];
	PHA[7]  = PH[3];
	PHA[10] = -1;		/* IPV4 mapped IPV6 */
	PHA[11] = PH[4];
	PHA[13] = PH[5];
	PHA[14] = PH[6];
	PHA[15] = PH[7];
	return 0;
}

pSD_PACKET_TABLE akb_packet_tbl_new(len)
int len;
{
	pSD_PACKET_TABLE pNew;

	if (pNew=(pSD_PACKET_TABLE)Malloc(sizeof(tdtRCSD_PACKET_TABLE))) {
		memset(pNew,0,sizeof(tdtRCSD_PACKET_TABLE));
		if (len > 0) {
			pNew->sp_len = len;
			if (!(pNew->sp_content = Malloc(len))) {
				Free(pNew);
				pNew = NULL;
			}
		}
	}
	return pNew;
}

int akb_packet_tbl_free(pNew)
pSD_PACKET_TABLE pNew;
{
	char *p;

	if (pNew) {
		if ((p=pNew->sp_content)) Free(p);
		Free(pNew);
	}
	else return -1;

	return 0;
}

int akb_exchg_indicate(pPacket)
pCOMM_PACK_HEAD pPacket;
{
	tdtINDICATEA     temp;
	pCOMM_PACK_HEADA pHA;
	pCOMM_PACK_HEAD  pH;

	if (pPacket->cph_prt.prt_ver == 'A') {
		pHA = (pCOMM_PACK_HEADA)pPacket;
		memcpy(&temp,&pHA->pha_sinf, sizeof(tdtINDICATEA) );
		memcpy(&pHA->pha_sinf, &pHA->pha_dinf, sizeof(tdtINDICATEA));
		memcpy(&pHA->pha_dinf, &temp, sizeof(tdtINDICATEA));
	}
	else {
		memcpy(&temp,&pPacket->cph_sinf, sizeof(tdtINDICATE) );
		memcpy(&pPacket->cph_sinf, &pPacket->cph_dinf, sizeof(tdtINDICATE));
		memcpy(&pPacket->cph_dinf, &temp, sizeof(tdtINDICATE));
	}

	return 0;
}

int akb_is_set_priority(pNew)
pSD_PACKET_TABLE pNew;
{
	pCOMM_PACK_HEAD  pHead;

	if (pNew) {
		pHead = (pCOMM_PACK_HEAD)pNew->sp_content;
		if (pHead->cph_prt.prt_send & AKB_PFM_PRIORITY) return 1;
	}
	return 0;
}

int akb_set_rb_priority(pNew, pRbWCtl, pRbPriCtl)
pSD_PACKET_TABLE pNew;
tdtRB_CTL  *pRbWCtl, *pRbPriCtl;
{
	char *p;

	if (!pNew) return -1;

	if (akb_is_set_priority(pNew))
		p = akxs_rb_set_n(pRbPriCtl,pNew);
	else
		p = akxs_rb_set_n(pRbWCtl,pNew);

	if (p) return 0;
	else return -1;
}

int akb_set_akb_opt_or(pPacket,opt)
pCOMM_PACK_HEAD	pPacket;
int opt;
{
	pCOMM_PACK_HEADA pHA;
	int opt_old;

#ifdef WITH_VER_B
	if (pPacket->cph_prt.prt_ver == 'B') {
		return -1;
	}
#endif
	if (pPacket->cph_prt.prt_ver == 'A') {
		pHA = (pCOMM_PACK_HEADA)pPacket;
		/* hcO̕ɐݒ肷 */
		if (pHA->pha_sinf.ina_thrd) {
			opt_old = pHA->pha_dinf.ina_disp;
			pHA->pha_dinf.ina_disp |= opt;
		}
		else {
			opt_old = pHA->pha_sinf.ina_disp;
			pHA->pha_sinf.ina_disp |= opt;
		}
	}
	else {
		/* hcO̕ɐݒ肷 */
		if (pPacket->cph_sinf.ind_thrd) {
			opt_old = pPacket->cph_dinf.ind_disp;
			pPacket->cph_dinf.ind_disp |= opt;
		}
		else {
			opt_old = pPacket->cph_sinf.ind_disp;
			pPacket->cph_sinf.ind_disp |= opt;
		}
	}
	return opt_old;
}
