/*static    char    sccsid[]="%Z% %M% %I% %D% %T%";*/
/*************************************************
 *
 *  akasys3.c
 *
 *        coded by A.Kobayashi 2002/3/27
 *
 *************************************************/
#include "akacommon.h"

extern tdtMSG_CTL         tMsgCtl;
extern tdtCLASS_CTLHead   tClassHead;
extern tdtINSTANCE       tInst;
extern tdtSTATISTICS     tStatistics;
extern int (*_pHPToEntry)();

#if 0
void aka_set_shut_packet();
void aka_wait_packet_free();
static int check_del_wait_packet();

static char *nullstring = "";

/********************************************************/
/*                                                      */
/********************************************************/
static int get_src_ch(pHead)
pCOMM_PACK_HEAD  pHead;
{
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
tdtCLASS_CTL *aka_srch_class2(iClassId,opt)
int iClassId,opt;
{
	tdtCLASS_CTL *tpClass,*tp_b=NULL;
	int opt1;

	if (iClassId < 2) iClassId = 2;
	opt1 = opt & 0x01;
	tpClass = tClassHead.class;
	while (tpClass) {
DEBUGOUTL2(AKA_LOG_GROUP|255,
"aka_srch_class2:in = %d, reg = %d",iClassId,tpClass->class_id);
		if (tpClass->class_id == iClassId) {
			if (opt1 && tp_b) {
				tp_b->class_next = tpClass->class_next;
				tpClass->class_next = tClassHead.class;
				tClassHead.class = tpClass;
			}
			break;
		}
		tp_b = tpClass;
		tpClass = tpClass->class_next;
	}
	return tpClass;
}

/********************************************************/
/*                                                      */
/********************************************************/
tdtCLASS_CTL *aka_srch_class(iClassId)
int iClassId;
{
	return aka_srch_class2(iClassId,0);
}

/********************************************************/
/*                                                      */
/********************************************************/
static int max_thread_check(tpClass,tpClassHead)
tdtCLASS_CTL     *tpClass;
tdtCLASS_CTLHead *tpClassHead;
{
	int i,iThread=0;

	if (tpClassHead) {
		if (tpClassHead->max_thread_total>0 &&
		    tpClassHead->used_thread_total>=tpClassHead->max_thread_total) {
			return 0;
		}
	}
	if (tpClass->used_count < tpClass->max_thread) {
		for (i=0;i<tpClass->max_thread;i++) {
			if (!tpClass->instance[i].used) {
				iThread = i + 1;
				break;
			}
		}
	}
	return iThread;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int set_recv_msg_com(pPacket,tpInst)
char        *pPacket;
tdtINSTANCE *tpInst;
{
	AKAMSGCOM *tpRcMsg;
	char **cppFilev;
	int iRc;

	tpRcMsg = tpInst->recv_msg_com;
	cppFilev = (char **)((char *)tpRcMsg + sizeof(AKAMSGCOM));

	iRc = akb_set_recv_msg(pPacket,tpRcMsg,cppFilev,&tpInst->to_free);
	if (iRc < 0) {
		return iRc;
	}

	if (!tpRcMsg->msg_pmsg) tpRcMsg->msg_pmsg = nullstring; /* add 2000.12.20 Koba */
	if (tpRcMsg->msg_mlen > 0)	/* add 2000.7.14 Koba */
		*(tpRcMsg->msg_pmsg+tpRcMsg->msg_mlen) = '\0';
	return 0;
}


/********************************************************/
/*                                                      */
/********************************************************/
static int exec_func(iKind,tpClass,iThread,cpPacket)
int iKind; /* 1/0 = Command/Reply */	/* add 2000.11.9 Koba */
tdtCLASS_CTL *tpClass;
int iThread;
char *cpPacket;
{
	int iRc,iHSize;
	pRcPacketTable  pRc;
	pCOMM_PACK_HEAD   pHead;
	tdtINSTANCE    *tpInst;
	char           *p,cver;
	tdtMSG_COM      *tpRcMsg;
	tdtCOMM_PACK_HEADA *pHA;
	ushort          usClassId;

	tpInst = &tpClass->instance[iThread-1];
	if (tpInst->to_free) {
		Free(tpInst->to_free);
		tpInst->to_free = NULL;
	}
	if (iRc=set_recv_msg_com(cpPacket,tpInst)) {
		ERROROUT1("exec_func:Recv msg invalid format ret=%d. Can't exec.",iRc);
		return iRc;
	}
	/* move from DispatchMsg 2000.11.9 Koba */
	if (iKind) {
		pHead = (pCOMM_PACK_HEAD)cpPacket;
		AKBGETHSIZE(pHead,iHSize)
		tpInst->used = 1;
		memcpy(tpInst->pack_head,cpPacket,iHSize);
		tpClass->used_count++;
		tClassHead.used_thread_total++;
	}

	pHead = tpInst->pack_head;
	tpRcMsg = tpInst->recv_msg_com;
	cver = pHead->cph_prt.prt_ver;
	if (cver == 'C') tpRcMsg->msg_resv = pHead->cph_sinf.ind_disp;
	else if (cver == 'A') {
		pHA = (tdtCOMM_PACK_HEADA *)pHead;
		tpRcMsg->msg_resv = pHA->pha_sinf.ina_disp;
	}
	else tpRcMsg->msg_resv = 1;

	aka_statistics_count(2,0);
	iRc = tpClass->func_name(iThread<<16|tpClass->class_id,
	                         tpInst->instance_data,
	                         tpInst->recv_msg_com);
	if (iRc) {
		if (!tpInst->wait_next) {
			ERROROUTRC("Wait ReturnłvpPbgȂBiRc=",iRc);
			iRc = 0;
		}
	}
	else {
		aka_wait_packet_free(tpInst->wait_next);
		if (tpInst->to_free) {
			Free(tpInst->to_free);
			tpInst->to_free = NULL;
		}
		tpInst->wait_next = NULL;
		tpInst->used = 0;
		tpClass->used_count--;
		tClassHead.used_thread_total--;

		/* WaitL[s\NX̃pPbgReadL[Ɉڂ */
		akxs_que_move(tMsgCtl.que_rwctl,QUE_MOVE_TOPP);
		while (akxs_que_peek(tMsgCtl.que_rwctl,QUE_MOVE_PEEK_NEXT,&pRc)>0) {
			pHead = (pCOMM_PACK_HEAD)(pRc->sp_content);
			cver = pHead->cph_prt.prt_ver;
			if (cver == 'A') {
				pHA = (tdtCOMM_PACK_HEADA *)pHead;
				usClassId = pHA->pha_dinf.ina_clid;
			}
			else usClassId = pHead->cph_dinf.ind_clid;
			if (tpClass=aka_srch_class(ntohs(usClassId))) {
				if (tpClass->used_count < tpClass->max_thread) {
					akxs_que_get(tMsgCtl.que_rwctl,QUE_GET_CUR,&pRc);
					akxs_rb_set_t(tMsgCtl.rb_rctl,pRc);
					break;
				}
			}
			else {
				akxs_que_get(tMsgCtl.que_rwctl,QUE_GET_CUR,&pRc);
				return -18504501;
			}
		}
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int used_instance()
{
	tdtCLASS_CTL *tpClass;
	tdtINSTANCE *tpIns;
	int i,count=0;

	tpClass = tClassHead.class;
	while (tpClass) {
		if (!(tpClass->option & AKA_RCO_NOWAITSHUT)) {
			tpIns = tpClass->instance;
			for (i=0;i<tpClass->max_thread;i++)
				if (tpIns[i].used) count++;
		}
		tpClass = tpClass->class_next;
	}
/*
printf("used_instance:count=%d\n",count);
*/
	return count;
}

/********************************************************/
/*                                                      */
/********************************************************/
#define AKA_NEXT_WAIT_TIME	60000

static int wait_msg_time_out()
{
	struct timeval ttime;
	time_t ltime;
	tdtCLASS_CTL *tpClass;
	tdtINSTANCE *tpIns;
	int i,count=0;
	pCOMM_PACK_HEAD   pHead;
	pCOMM_PACK_HEADA  pHA;
	tdtWAIT_PACKET *tpWait;
	int iWaitTime,iMinWait,iSubTime;
	int iRetCode,iHSize;
	char cver;

	/* ݎ̎肾 */
	if ((ltime = aka_getm_sec(&ttime))<0) return -1;
DEBUGOUTL2(AKA_LOG_GROUP|255,
"wait_msg_time_out:ttime=%d:%d",ttime.tv_sec,ttime.tv_usec);
	iMinWait = -1;
	tpClass = tClassHead.class;
	while (tpClass) {
	  tpIns = tpClass->instance;
	  for (i=0;i<tpClass->max_thread;i++) {
		if (tpIns[i].used && (tpWait=tpIns[i].wait_next)) {
		  while (tpWait) {
#if 1	/* 2001.8.6 Koba */
			iSubTime = akxe_timer_sub(NULL,&tpWait->time_out,&ttime);
DEBUGOUTL5(AKA_LOG_GROUP|255,
"wait_msg_time_out:ttime=%d:%d TimeOut=%d:%d iSubTime=%d",
ttime.tv_sec,ttime.tv_usec,tpWait->time_out.tv_sec,tpWait->time_out.tv_usec,iSubTime);
			if (iSubTime <= 0) {
#else
			if (!timercmp(&tpWait->time_out,&ttime,>)) {
#endif
				pHead = (pCOMM_PACK_HEAD)tpWait->wait_packet;
				cver = pHead->cph_prt.prt_ver;
				if (cver == 'A') iHSize = sizeof(tdtCOMM_PACK_HEADA);
				else iHSize = sizeof(tdtCOMM_PACK_HEAD);
				if (pHead=(pCOMM_PACK_HEAD)Malloc(iHSize)) {
					memcpy(pHead,tpWait->wait_packet,iHSize);
					if (cver == 'A') {
						pHA = (tdtCOMM_PACK_HEADA *)pHead;
						pHA->pha_plen = 0;
					}
					else pHead->cph_plen = 0;
					iRetCode = PACKET_TIMEOUT_ERROR;
					if (tpWait->status & AKA_WMSG_NULL_CLASS) iRetCode = 0;
					if (tpWait->status & AKA_WMSG_WAKEUP)
						iRetCode = tpWait->ret_code;
					if (akb_set_rb_pack_err_cd(get_src_ch(tpWait->wait_packet),
					    tpWait->wait_packet,tMsgCtl.rb_rctl,iRetCode)<0) {
						akxe_timer_addmsec(&tpWait->time_out,&tpWait->time_out,
							AKA_NEXT_WAIT_TIME);
						Free(tpWait->wait_packet);
					}
					else {
						if (!(tpWait->status &
						      (AKA_WMSG_NULL_CLASS | AKA_WMSG_WAKEUP)))
							ERROROUT("vpPbg^CAEg");
						count++;
					/*
						tpWait->iTimeOut += tMsgCtl.send_msg_time_out;
					*/
						akxe_timer_addmsec(&tpWait->time_out,&tpWait->time_out,
							AKA_NEXT_WAIT_TIME);
						tpWait->status |= AKA_WMSG_TIMEOUT;
					}
					/* akb_set_rb_pack_err_cdŃZbgpPbg͕ԋppPbg
					   ƂăfBXpb`AWaitPacket邩ǂ
					   `FbN邽FreełȂ */
					tpWait->wait_packet = (char *)pHead;
				}
				else {
					akxe_timer_addmsec(&tpWait->time_out,&tpWait->time_out,
						AKA_NEXT_WAIT_TIME);
				}
			}
			else {
				if (iSubTime >= AKA_NEXT_WAIT_TIME/2)
					tpWait->status &= ~AKA_WMSG_TIMEOUT;
			/*
				iSubTime = akxe_timer_sub(NULL,&tpWait->time_out,&ttime);
			*/
DEBUGOUTL3(AKA_LOG_GROUP|255,
"wait_msg_time_out:iSubTime=%d iMinWait=%d Status=%08x",
iSubTime,iMinWait,tpWait->status);
				if (iMinWait<0 || iSubTime<iMinWait) iMinWait = iSubTime;
			}
			tpWait = tpWait->wait_next;
		  }
		}
	  }
	  tpClass = tpClass->class_next;
	}
DEBUGOUTL2(AKA_LOG_GROUP|255,
"wait_msg_time_out:tMsgCtl.iSendMsgMinWait=%d iMinWait=%d",tMsgCtl.send_msg_min_wait,iMinWait);
	tMsgCtl.send_msg_min_wait = iMinWait;

	return count;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int check_del_wait_packet(tpIns, pHead)
tdtINSTANCE   *tpIns;
pCOMM_PACK_HEAD  pHead;
{
	pCOMM_PACK_HEAD  pHWait;
	pCOMM_PACK_HEADA pHWaitA;
    tdtWAIT_PACKET *tpWait,*tpNext;
	short sPacketNo_n,sPackNo;
	int iMR_wait,iMR;

#ifdef DEBUG_X
akxaxdump("RecvPacket",pHead,32);
#endif
	sPacketNo_n = pHead->cph_dinf.ind_pano;
	iMR = pHead->cph_sinf.ind_disp & AKA_AKO_MULTI_REPLY;
	tpWait = NULL;
	tpNext = tpIns->wait_next;
	while (tpNext) {
		if (pHWait =(pCOMM_PACK_HEAD)tpNext->wait_packet) {
			if (pHWait->cph_prt.prt_ver == 'A') {
				pHWaitA = (pCOMM_PACK_HEADA)pHWait;
				sPackNo = pHWaitA->pha_sinf.ina_pano;
				iMR_wait = pHWaitA->pha_dinf.ina_disp & AKA_AKO_MULTI_REPLY;
			}
			else {
				sPackNo = pHWait->cph_sinf.ind_pano;
				iMR_wait = pHWait->cph_dinf.ind_disp & AKA_AKO_MULTI_REPLY;
			}
			if (sPackNo == sPacketNo_n) {
#ifdef DEBUG
printf("check_del_wait_packet:tpWait=%08x tpNext=%08x\n",tpWait,tpNext);
printf("check_del_wait_packet:iMR_wait=%02x iMR=%02x\n",iMR_wait,iMR);
#endif
				if (!(iMR_wait & iMR)) {
					if (tpWait) tpWait->wait_next = tpNext->wait_next;
					else        tpIns->wait_next  = tpNext->wait_next;
					Free(pHWait);
					Free(tpNext);
				}
				return 1;
			}
		}
		tpWait = tpNext;
		tpNext = tpWait->wait_next;
	}
	return 0;
}
#endif
/********************************************************/
/*                                                      */
/********************************************************/
int aka_dispatch(pNew)
pRC_PACKET_TABLE  pNew;
{
	tdtCOMM_PACK_HEAD   *pHead,tHead;
	pCOMM_PACK_HEADB   pHeadB;
	int iCh, iThread, iRc=0, i;
	short sCmd;
	char *cpPacket, cver, *cpToFree, *cpInst;
	long wrk[sizeof(tdtCOMM_PACK_HEAD)/4+4],len;
	tdtCLASS_CTL *tpClass;
	tdtINSTANCE *tpIns;
	int iClassId, iKind;
	tdtWAIT_PACKET *tpWait;

	cpPacket = pNew->sp_content;
	pHead = (pCOMM_PACK_HEAD)cpPacket;
	sCmd  = ntohs(pHead->cph_prt.prt_cmnd);
DEBUGOUTL3(AKA_LOG_GROUP|250,
"aka_dispatch: cmnd=%d thread=%d classid=%d",sCmd,pHead->cph_sinf.ind_thrd,
ntohs(pHead->cph_dinf.ind_clid));
	if (sCmd != AKB_CMD_SEND) {
		memcpy(wrk,pHead,sizeof(tdtCOMM_PACK_HEAD));
		len = ntohl(pHead->cph_plen);
		i = sizeof(tdtCOMM_PACK_HEAD)/4;
		if (len > 0) {
			if (len > 8) len = 8;
			memcpy(&wrk[i+1],cpPacket+sizeof(tdtCOMM_PACK_HEAD),len);
		}
		wrk[i] = htons(sCmd)<<16;
		len += 4;
		cpPacket = (char *)wrk;
		pHead = (pCOMM_PACK_HEAD)cpPacket;
		pHead->cph_plen = htonl(len);
		sCmd = AKB_CMD_SEND;
		pHead->cph_prt.prt_cmnd = htons(sCmd);
	}
	iRc = 0;
	iClassId = ntohs(pHead->cph_dinf.ind_clid);
	if (iClassId < 1) iClassId = 1;
	pHeadB = (pCOMM_PACK_HEADB)pHead;
	cver = pHead->cph_prt.prt_ver;
	tInst.pack_head = pHead;
	if ((cver=='C' && pHead->cph_dinf.ind_thrd == 0) ||
	    (cver=='B' && pHeadB->phb_dind.inb_pkid == 0)) {
		/* MpPbg */
		iKind = 1;
		if (pHead->cph_dinf.ind_pano != 0) {
			if (iRc) {
				ERROROUT("*** aka_dispatch:Dropped Error Packet ");
				if (pNew->sp_content) Free(pNew->sp_content);
				Free(pNew);
				return -1;
			}
		}
		if (tpClass=aka_srch_class2(iClassId,1)) {
			if (!(iThread=max_thread_check(tpClass,&tClassHead))) {
				akxs_que_put(tMsgCtl.que_rwctl,QUE_PUT,pNew);
				return 0;
			}
		}
		else {
			ERROROUT1("S:o^NXhc = %d",iClassId);
			iRc = D_ERR_UNKNOWN_CLASS;
		}
	}
	else {
		/* ԐMpPbg */
		iKind = 0;
		iThread  = pHead->cph_dinf.ind_thrd;
		if (tpClass=aka_srch_class2(iClassId,1)) {
			if (tpClass->option & AKA_RCO_NOREPLY) {
				iRc = D_ERR_RCO_NOREPLY;
			}
			else {
				tpIns = &tpClass->instance[iThread-1];
				if (tpWait=tpIns->wait_next) {
					if (!check_del_wait_packet(tpIns,pHead,0)){
						ERROROUT("vpPbg̔ԍȂ");
						iThread = 0;
					}
				}
				else {
					ERROROUT("vpPbgȂ");
					iThread = 0;
				}
			}
		}
		else {
			ERROROUT1("R:o^NXhc = %d",iClassId);
			iRc = D_ERR_UNKNOWN_CLASS;
		}
	}

	if (!iRc) {
		if (tpClass && iThread) {
			iRc = exec_func(iKind,tpClass,iThread,cpPacket);
		}
	}
	else {
		iCh = _pHPToEntry(ntohl(pHead->cph_sinf.ind_hoid),
		                  ntohs(pHead->cph_sinf.ind_prid));
		if (iCh >= 0) {
			if (akb_set_rb_pack_err_cd(iCh,pNew->sp_content,tMsgCtl.rb_wctl,iRc)) {
				ERROROUT("*** aka_dispatch:Dropped Packet -- repry error");
			}
			else {
				akb_trace_out(2,pNew->sp_content);
				pNew->sp_content = NULL;
			}
		}
		else ERROROUT("*** aka_dispatch:Dropped Packet -- Src no entry");
	}

	if (pNew->sp_content) Free(pNew->sp_content);
	Free(pNew);
	return 0;
}
#if 0
/********************************************************/
/*  ԐM҂bZ[W^CAEgɂ              */
/********************************************************/
int aka_wake_up_msg(lInstanceHandle,iRetCode)
long lInstanceHandle;
int  iRetCode;
{
	int    i,is,ie,count=0;
	int    iThread,iClassId;
	int    iMinWait;
	time_t ltime;
	struct timeval ttime;
	tdtCLASS_CTL   *tpClass;
	tdtINSTANCE   *tpIns;
	tdtWAIT_PACKET *tpWait;

	if (tMsgCtl.sd<0) return -18505501;

	/* NXƃXbhm̎o */
	iThread  = (lInstanceHandle>>16) & 0xff;
	iClassId = lInstanceHandle & 0xffff;


	/* ݎ̎肾 */
	if ((ltime = aka_getm_sec(&ttime))<0) return -18505502;
DEBUGOUTL2(AKA_LOG_GROUP|255,
"aka_wake_up_msg:ttime=%d:%d",ttime.tv_sec,ttime.tv_usec);
	tpClass = tClassHead.class;
	iMinWait = -1;
	while (tpClass) {
		if (iClassId==0 || iClassId==tpClass->class_id) {
			tpIns = tpClass->instance;
			if (iThread == 0) {
				is = 0;
				ie = tpClass->max_thread;
			}
			else {
				ie = iThread;
				is = ie - 1;
			}
			for (i=is;i<ie;i++) {
				if (tpIns[i].used && (tpWait=tpIns[i].wait_next)) {
					while (tpWait) {
DEBUGOUTL3(AKA_LOG_GROUP|255,"aka_wake_up_msg:TimeOut=%d:%d Status=%08x",
tpWait->time_out.tv_sec,tpWait->time_out.tv_usec,tpWait->status);
						if (!(tpWait->status & AKA_WMSG_TIMEOUT)) {
							akxe_timer_set(&tpWait->time_out,&ttime);
							tpWait->status |= AKA_WMSG_WAKEUP;
							tpWait->ret_code = iRetCode;
							iMinWait = 0;
							count++;
						}
						tpWait = tpWait->wait_next;
					}
				}
			}
		}
		tpClass = tpClass->class_next;
	}
	if (iMinWait >= 0) tMsgCtl.send_msg_min_wait = iMinWait;

	return count;
}
#endif
