// 
// Copyright (c) 2003-2010, MIST Project, Nagoya University
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
// 
// 2. Redistributions in binary form must reproduce the above copyright notice,
// this list of conditions and the following disclaimer in the documentation
// and/or other materials provided with the distribution.
// 
// 3. Neither the name of the Nagoya University nor the names of its contributors
// may be used to endorse or promote products derived from this software
// without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
// IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
// THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 

/// @file mist/io/png.h
//!
//! @brief PNG摜ǂݏ邽߂̃Cu
//!
//! {CúChttp://www.libpng.org/pub/png/ , http://www.libpng.org/ ŊJsĂ libpng 𗘗pĂ
//! GR[hƃfR[h͖{CuAPIpĎĂ邽߁CʓrCupӂKv
//!
#ifndef __INCLUDE_MIST_PNG__
#define __INCLUDE_MIST_PNG__


#ifndef __INCLUDE_MIST_H__
#include "../mist.h"
#endif

// J[摜̐ݒǂݍ
#ifndef __INCLUDE_MIST_COLOR_H__
#include "../config/color.h"
#endif

#ifndef __INCLUDE_MIST_LIMITS__
#include "../limits.h"
#endif


#include <string>

#include <png.h>

// ȉ̃R[h libpng ɕt̃TvR[hC KATO  http://www5.cds.ne.jp/~kato/png/ ɂ
// fڂĂ\[XQlɍ쐬CMISTŗpł悤ɓƎ̊g{̂łD


// mistOԂ̎n܂
_MIST_BEGIN


namespace __png_controller__
{
	template < class T, class Allocator >
	struct png_controller
	{
		typedef _pixel_converter_< T > pixel_converter;
		typedef typename pixel_converter::color_type color_type;
		typedef typename array2< T, Allocator >::size_type size_type;

		static bool read( array2< T, Allocator > &image, const std::string &filename )
		{
			FILE			*fp;
			png_structp		png_ptr;
			png_infop		info_ptr;
			png_uint_32		width, height;
			int				bit_depth, color_type, interlace_type;

			fp = fopen( filename.c_str( ), "rb" );	// ǂݍPNG摜t@CJ
			if( !fp ) return( false );

			// PNG̉摜ǂݍލۂɁCKvƂȂe\̂
			png_ptr = png_create_read_struct( PNG_LIBPNG_VER_STRING, NULL, NULL, NULL );
			info_ptr = png_create_info_struct( png_ptr );	// png_infop \̂
			png_init_io( png_ptr, fp );						// png_structp Ƀt@C|C^ݒ肷
			png_read_info( png_ptr, info_ptr );				// PNGt@C̃wb_ǂݍ
			png_get_IHDR( png_ptr, info_ptr, &width, &height, &bit_depth, &color_type, &interlace_type, NULL, NULL);	// IHDR`N擾

			if( bit_depth < 8 )
			{
				png_set_packing( png_ptr );
			}

			// J[pbgRGBɕϊ
			if( color_type == PNG_COLOR_TYPE_PALETTE )
			{
				png_set_palette_to_rgb( png_ptr );
			}

			// 8rbg̃O[XP[8rbgɕϊ
			if( color_type == PNG_COLOR_TYPE_GRAY && bit_depth < 8 )
			{
				png_set_expand_gray_1_2_4_to_8( png_ptr );
			}

			// At@`lL
			if( png_get_valid( png_ptr, info_ptr, PNG_INFO_tRNS ) )
			{
				png_set_tRNS_to_alpha( png_ptr );
			}

			png_read_update_info( png_ptr, info_ptr );

			// IHDR`Nēx擾
			png_get_IHDR( png_ptr, info_ptr, &width, &height, &bit_depth, &color_type, &interlace_type, NULL, NULL);

			image.resize( width, height );

			bool ret = true;

			if( interlace_type == 0 )
			{
				// PNG̉摜𑀍삷邽߂̈ꎞzpӂ
				png_bytep png_buff = ( png_bytep )malloc( png_get_rowbytes( png_ptr, info_ptr ) );

				for( size_type j = 0 ; j < ( size_type )height ; j++ )
				{
					// 摜f[^ǂݍ
					png_read_rows( png_ptr, &png_buff, NULL, 1 );

					// o͐̃|C^
					typename array2< T, Allocator >::pointer op = &image( 0, j );

					// PNG Ɋi[Ă摜̌`ɉăf[^ǂݍ
					switch( color_type )
					{
					case PNG_COLOR_TYPE_GRAY:
						for( size_type i = 0 ; i < ( size_type )width ; i++ )
						{
							op[ i ] = pixel_converter::convert_to( png_buff[ i ], png_buff[ i ], png_buff[ i ] );
						}
						break;

					case PNG_COLOR_TYPE_RGB:
						for( size_type i = 0 ; i < ( size_type )width ; i++ )
						{
							op[ i ] = pixel_converter::convert_to( png_buff[ i * 3 + 0 ], png_buff[ i * 3 + 1 ], png_buff[ i * 3 + 2 ] );
						}
						break;

					case PNG_COLOR_TYPE_RGBA:
						for( size_type i = 0 ; i < ( size_type )width ; i++ )
						{
							op[ i ] = pixel_converter::convert_to( png_buff[ i * 4 + 0 ], png_buff[ i * 4 + 1 ], png_buff[ i * 4 + 2 ], png_buff[ i * 4 + 3 ] );
						}
						break;

					case PNG_COLOR_TYPE_GA:
						for( size_type i = 0 ; i < ( size_type )width ; i++ )
						{
							op[ i ] = pixel_converter::convert_to( png_buff[ i * 2 ], png_buff[ i * 2 ], png_buff[ i * 2 ], png_buff[ i * 2 + 1 ] );
						}
						break;

					case PNG_COLOR_TYPE_PALETTE:
						for( size_type i = 0 ; i < ( size_type )width ; i++ )
						{
							png_color &p = info_ptr->palette[ png_buff[ i ] ];
							op[ i ] = pixel_converter::convert_to( p.red, p.green, p.blue );
						}
						break;

					default:
						ret = false;
						break;
					}
				}

				// ꎞ摜pɊmۂJ
				free( png_buff );
			}
			else
			{
				// PNG̉摜𑀍삷邽߂̈ꎞzpӂ
				png_bytepp png_buff;
				png_buff = ( png_bytepp )malloc( height * sizeof( png_bytep ) );
				for( size_type i = 0 ; i < ( size_type )height ; i++ )
				{
					png_uint_32 nbytes = png_get_rowbytes( png_ptr, info_ptr );
					png_buff[ i ] = ( png_bytep )malloc( nbytes );
				}

				// 摜f[^ǂݍ
				png_read_image( png_ptr, png_buff );

				// PNG Ɋi[Ă摜̌`ɉăf[^ǂݍ
				switch( color_type )
				{
				case PNG_COLOR_TYPE_GRAY:
					for( size_type j = 0 ; j < ( size_type )height ; j++ )
					{
						for( size_type i = 0 ; i < ( size_type )width ; i++ )
						{
							image( i, j ) = pixel_converter::convert_to( png_buff[ j ][ i ], png_buff[ j ][ i ], png_buff[ j ][ i ] );
						}
					}
					break;

				case PNG_COLOR_TYPE_RGB:
					for( size_type j = 0 ; j < ( size_type )height ; j++ )
					{
						for( size_type i = 0 ; i < ( size_type )width ; i++ )
						{
							image( i, j ) = pixel_converter::convert_to( png_buff[ j ][ i * 3 + 0 ], png_buff[ j ][ i * 3 + 1 ], png_buff[ j ][ i * 3 + 2 ] );
						}
					}
					break;

				case PNG_COLOR_TYPE_RGBA:
					for( size_type j = 0 ; j < ( size_type )height ; j++ )
					{
						for( size_type i = 0 ; i < ( size_type )width ; i++ )
						{
							image( i, j ) = pixel_converter::convert_to( png_buff[ j ][ i * 4 + 0 ], png_buff[ j ][ i * 4 + 1 ], png_buff[ j ][ i * 4 + 2 ], png_buff[ j ][ i * 4 + 3 ] );
						}
					}
					break;

				case PNG_COLOR_TYPE_GA:
					for( size_type j = 0 ; j < ( size_type )height ; j++ )
					{
						for( size_type i = 0 ; i < ( size_type )width ; i++ )
						{
							image( i, j ) = pixel_converter::convert_to( png_buff[ j ][ i * 2 ], png_buff[ j ][ i * 2 ], png_buff[ j ][ i * 2 ], png_buff[ j ][ i * 2 + 1 ] );
						}
					}
					break;

				case PNG_COLOR_TYPE_PALETTE:
					for( size_type j = 0 ; j < ( size_type )height ; j++ )
					{
						for( size_type i = 0 ; i < ( size_type )width ; i++ )
						{
							png_color &p = info_ptr->palette[ png_buff[ j ][ i ] ];
							image( i, j ) = pixel_converter::convert_to( p.red, p.green, p.blue );
						}
					}
					break;

				default:
					ret = false;
					break;
				}

				// ꎞ摜pɊmۂJ
				for( size_type i = 0 ; i < ( size_type )height ; i++ )
				{
					free( png_buff[ i ] );
				}
				free( png_buff );
			}

			// PNG ̑pɎgp\̂̃
			png_destroy_read_struct( &png_ptr, &info_ptr, NULL );

			// PNG ̃t@C
			fclose( fp );

			return( ret );
		}

		static bool write( const array2< T, Allocator > &image, const std::string &filename, int compression_level__ )
		{
			int compression_level = compression_level__ > 9 ? 9 : compression_level__;

			if( image.width( ) == 0 )
			{
				std::cerr << "Image width is zero!" << std::endl;
				return( false );
			}
			else if( image.height( ) == 0 )
			{
				std::cerr << "Image height is zero!" << std::endl;
				return( false );
			}
			
			FILE *fp;
			png_structp	png_ptr;
			png_infop	info_ptr;
			size_type	width  = image.width( );
			size_type	height = image.height( );

			if( ( fp = fopen( filename.c_str( ), "wb" ) ) == NULL ) return(false);

			png_ptr = png_create_write_struct( PNG_LIBPNG_VER_STRING, NULL, NULL, NULL );
			if( png_ptr == NULL )
			{
				fclose( fp );
				return( false );
			}

			info_ptr = png_create_info_struct( png_ptr );
			if( info_ptr == NULL )
			{
				png_destroy_write_struct( &png_ptr, (png_infopp)NULL );
				fclose( fp );
				return( false );
			}
			if( setjmp( png_ptr->jmpbuf ) )
			{
				png_destroy_write_struct( &png_ptr, &info_ptr );
				fclose( fp );
				return( false );
			}

			if( compression_level > 9 ) compression_level = 9;

			png_init_io( png_ptr, fp );
			//png_set_write_status_fn(png_ptr, write_row_callback);
			png_set_filter( png_ptr, 0, PNG_ALL_FILTERS );
			if( compression_level < 0 )
			{
				png_set_compression_level( png_ptr, Z_BEST_COMPRESSION );
			}
			else
			{
				png_set_compression_level( png_ptr, compression_level );
			}

			int png_color_type = pixel_converter::color_num == 4 ? PNG_COLOR_TYPE_RGBA : PNG_COLOR_TYPE_RGB;
			png_set_IHDR( png_ptr, info_ptr, static_cast< png_uint_32 >( width ), static_cast< png_uint_32 >( height ), 8, png_color_type, PNG_INTERLACE_NONE, PNG_COMPRESSION_TYPE_DEFAULT, PNG_FILTER_TYPE_DEFAULT );
			png_set_gAMA( png_ptr, info_ptr, 1.0 );

			{
				time_t		gmt;
				png_time	mod_time;
				png_text	text_ptr[5];

				time( &gmt );
				png_convert_from_time_t( &mod_time, gmt );
				png_set_tIME( png_ptr, info_ptr, &mod_time );

				static char text[][64] = {
					"Title",
					"MIST PNG Library",
					"Author",
					"",
					"Description",
					"Created by using MIST library",
					"Creation Time",
					"Software",
					"MIST PNG converter",
				};

				text_ptr[ 0 ].key  = text[ 0 ];
				text_ptr[ 0 ].text = text[ 1 ];
				text_ptr[ 0 ].compression = PNG_TEXT_COMPRESSION_NONE;
				text_ptr[ 1 ].key  = text[ 2 ];
				text_ptr[ 1 ].text = text[ 3 ];
				text_ptr[ 1 ].compression = PNG_TEXT_COMPRESSION_NONE;
				text_ptr[ 2 ].key  = text[ 4 ];
				text_ptr[ 2 ].text = text[ 5 ];
				text_ptr[ 2 ].compression = PNG_TEXT_COMPRESSION_NONE;
				text_ptr[ 3 ].key  = text[ 6 ];
				text_ptr[ 3 ].text = png_convert_to_rfc1123( png_ptr, &mod_time );
				text_ptr[ 3 ].compression = PNG_TEXT_COMPRESSION_NONE;
				text_ptr[ 4 ].key  = text[ 7 ];
				text_ptr[ 4 ].text = text[ 8 ];
				text_ptr[ 4 ].compression = PNG_TEXT_COMPRESSION_NONE;
				png_set_text( png_ptr, info_ptr, text_ptr, 5 );
			}

			png_write_info( png_ptr, info_ptr );

			if( pixel_converter::color_num == 4 )
			{
				png_bytep png_buff = new png_byte[ width * 4 ];
				for( size_type j = 0 ; j < height ; j++ )
				{
					typename array2< T, Allocator >::const_pointer ip = &image( 0, j );
					for( size_type i = 0 ; i < width ; i++ )
					{
						color_type c = limits_0_255( pixel_converter::convert_from( ip[ i ] ) );
						png_buff[ i * 4 + 0 ] = static_cast< png_byte >( c.r );
						png_buff[ i * 4 + 1 ] = static_cast< png_byte >( c.g );
						png_buff[ i * 4 + 2 ] = static_cast< png_byte >( c.b );
						png_buff[ i * 4 + 3 ] = static_cast< png_byte >( c.a );
					}

					png_write_rows( png_ptr, &png_buff, 1 );
				}

				delete [] png_buff;
			}
			else
			{
				png_bytep png_buff = new png_byte[ width * 4 ];
				for( size_type j = 0 ; j < height ; j++ )
				{
					typename array2< T, Allocator >::const_pointer ip = &image( 0, j );
					for( size_type i = 0 ; i < width ; i++ )
					{
						color_type c = limits_0_255( pixel_converter::convert_from( ip[ i ] ) );
						png_buff[ i * 3 + 0 ] = static_cast< png_byte >( c.r );
						png_buff[ i * 3 + 1 ] = static_cast< png_byte >( c.g );
						png_buff[ i * 3 + 2 ] = static_cast< png_byte >( c.b );
					}

					png_write_rows( png_ptr, &png_buff, 1 );
				}

				delete [] png_buff;
			}

			png_write_end( png_ptr, info_ptr );
			png_destroy_write_struct( &png_ptr, &info_ptr );
			fclose( fp );

			return( true );
		}
	};
}


//! @addtogroup image_group 摜o
//!  @{

//! @addtogroup image_png_group PNG 摜o
//!
//! PNGt@CǂݍŁCMISTRei֊i[D
//! ܂CMISTReiPNGt@Cւ̏oT|[gD
//! ʓr http://libpng.org 񋟂t[PNGCuKvłD
//!
//! @code ̃wb_CN[h
//! #include <mist/io/png.h>
//! @endcode
//!
//!  @{


/// @brief PNG摜MISTReiɓǂݍ
//! 
//! RGBRGBAJ[e[ugpSĂPNG摜ǂݍނƂ\ł
//! 
//! @param[out] image    c 摜ǂݍސMISTRei
//! @param[in]  filename c ̓t@C
//!
//! @retval true  c 摜̓ǂݍ݂ɐ
//! @retval false c 摜̓ǂݍ݂Ɏs
//! 
template < class T, class Allocator >
bool read_png( array2< T, Allocator > &image, const std::string &filename )
{
	return( __png_controller__::png_controller< T, Allocator >::read( image, filename ) );
}


/// @brief PNG摜MISTReiɓǂݍ
//! 
//! RGBRGBAJ[e[ugpSĂPNG摜ǂݍނƂ\ł
//! 
//! @param[out] image    c 摜ǂݍސMISTRei
//! @param[in]  filename c ̓t@C
//!
//! @retval true  c 摜̓ǂݍ݂ɐ
//! @retval false c 摜̓ǂݍ݂Ɏs
//! 
template < class T, class Allocator >
bool read_png( array2< T, Allocator > &image, const std::wstring &filename )
{
	return( read_png( image, wstr2str( filename ) ) );
}


/// @brief MISTReỉ摜PNG`Ńt@Cɏo͂
//! 
//! @attention kx0`9܂łCɕ̒lw肷ƁCK؂ȈkxIɑIiftHgj
//! 
//! @param[in] image    c o͉摜ێMISTRei
//! @param[in] filename c o̓t@C
//! @param[in] compression_level c PNG摜o͂ۂ̈kx
//!
//! @retval true  c 摜݂̏ɐ
//! @retval false c 摜݂̏Ɏs
//! 
template < class T, class Allocator >
bool write_png( const array2< T, Allocator > &image, const std::string &filename, int compression_level = 6 )
{
	return( __png_controller__::png_controller< T, Allocator >::write( image, filename, compression_level ) );
}


/// @brief MISTReỉ摜PNG`Ńt@Cɏo͂
//! 
//! @attention kx0`9܂łCɕ̒lw肷ƁCK؂ȈkxIɑIiftHgj
//! 
//! @param[in] image    c o͉摜ێMISTRei
//! @param[in] filename c o̓t@C
//! @param[in] compression_level c PNG摜o͂ۂ̈kx
//!
//! @retval true  c 摜݂̏ɐ
//! @retval false c 摜݂̏Ɏs
//! 
template < class T, class Allocator >
bool write_png( const array2< T, Allocator > &image, const std::wstring &filename, int compression_level = 6 )
{
	return( write_png( image, wstr2str( filename ), compression_level ) );
}


/// @}
//  PNG 摜o̓O[v̏I

/// @}
//  摜o̓O[v̏I


// mistOԂ̏I
_MIST_END


#endif // __INCLUDE_MIST_PNG__
