// 
// Copyright (c) 2003-2010, MIST Project, Nagoya University
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
// 
// 2. Redistributions in binary form must reproduce the above copyright notice,
// this list of conditions and the following disclaimer in the documentation
// and/or other materials provided with the distribution.
// 
// 3. Neither the name of the Nagoya University nor the names of its contributors
// may be used to endorse or promote products derived from this software
// without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
// IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
// THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 

/// @file mist/config/mist_conf.h
//!
//! @brief MIST̐ݒt@C
//!

#ifndef __INCLUDE_MIST_CONF_H__
#define __INCLUDE_MIST_CONF_H__

#include <iostream>
#include <cstdlib>
#include <string>


// MISTOԂ`邽߂̃}N
#ifndef _MIST_BEGIN
/// @namespace mist
//!
//! MISTvWFNg̖OԁD
//! ׂĂ̊֐ENX mist OԂɊ܂܂D
//! 
#define _MIST_BEGIN		namespace mist{		///< @brief MISTOԂ̎n܂
#endif

#ifndef _MIST_END
#define _MIST_END		}					///< @brief MISTOԂ̏I
#endif



// mistOԂ̎n܂
_MIST_BEGIN



// Microsoft Visual C++ ̃o[W`FbN
#if defined( _MSC_VER )
	#if _MSC_VER <= 1200
		// Visual C++6.0
		#define __MIST_MSVC__		6
	#elif _MSC_VER < 1400
		// Visual Studio .NET 2002 - 2003o[W
		#define __MIST_MSVC__		7
	#else
		// Visual Studio 2005 o[W
		#define __MIST_MSVC__		8
	#endif
#endif


#if defined( __MIST_MSVC__ ) && __MIST_MSVC__ >= 8
	// ZLeB̗RŁAsprintf  fopen Ȃǂ̊֐ĂяoxƂȂւ̑Ώ
	// ł̐ݒ́AMISTCN[h邷ׂẴt@Cɉe܂
	//
	// ̂ꂩI

	// sȂ̂ŁÂƂx𖳎
	#pragma warning( disable : 4996 )

	//#undef _CRT_SECURE_CPP_OVERLOAD_SECURE_NAMES
	//#define _CRT_SECURE_CPP_OVERLOAD_SECURE_NAMES		0
	////#define _CRT_SECURE_NO_DEPRECATE					1	// ZLeBアÂ֐𗘗p
	//#undef _CRT_SECURE_CPP_OVERLOAD_STANDARD_NAMES
	//#define _CRT_SECURE_CPP_OVERLOAD_STANDARD_NAMES		1	// ZLeBꂽ֐𗘗pisɎԂKvƂȂ\j
#endif

// Microsoft Windows ǂ`FbN
#if defined( WIN64 ) || defined( _WIN64 )
	// 64bit Windows
	#define __MIST_WINDOWS__	2
#elif defined( WIN32 ) || defined( _WIN32 )
	// 32bit Windows
	#define __MIST_WINDOWS__	1
#endif

#if defined( _WIN64 ) || defined( __x86_64__ ) || defined( __AMD64__ )
	// 64bit OS
	#define __MIST64__	64
#else
	// 32bit OS
	#define __MIST32__	32
#endif



// Microsoft Visual C++ 6.0 ł́Cstatic const 𖢃T|[ĝ߁Cenum őp
#if defined( __MIST_MSVC__ ) && __MIST_MSVC__ <= 6
	#define _MIST_CONST( type, name, value ) enum{ name = value }
#else
	#define _MIST_CONST( type, name, value ) static const type name = value
#endif


// \̂̃ACg킹邽߂̃}N
#if defined(__MIST_MSVC__) || defined(__INTEL_COMPILER)
	#define _MIST_PACKED
#else
	#define _MIST_PACKED __attribute__( ( packed ) )
#endif



// MISTwb_ŗpݒ
#define _MIST_ALLOCATE_TEST_			0

//#ifdef __MIST_MSVC__
//	#define _MIST_ALLOCATOR_MEMORY_TRIM_	0		///< VCWSTLł̓T|[gĂȂ̂ŃItɂ
//#else
//	#define _MIST_ALLOCATOR_MEMORY_TRIM_	1		///< VCȊOSTLł̓T|[gĂ̂ŃIɂ
//#endif

#define _MIST_ALLOCATOR_MEMORY_TRIM_	0			///< łɊmۂĂ郁̈̐؂l߂sAP[^T|[gꍇ̓Iɂ

#define _MIST_UNUSED_( arg )	( void )( arg )		///< gp̕ϐɊւx\Ȃ邽߂̃}N

#if defined( __MIST_MSVC__ ) && __MIST_MSVC__ <= 6


// mistOԂ̏I
_MIST_END

	#include <cmath>

	// VC6ł́ASTDOԂABS֐ĂȂC
	#define STD_CMATH_FUNC1( name, func, value ) inline value name ( value v ){ return( ::func( v ) ); }
	#define STD_CMATH_FUNC2( name, func, value ) inline value name ( value v1, value v2 ){ return( ::func( v1, v2 ) ); }
	namespace std
	{
		STD_CMATH_FUNC1(   abs,    abs, int )
		STD_CMATH_FUNC1(   abs,   labs, long )
		STD_CMATH_FUNC1(   abs,   fabs, double )
		STD_CMATH_FUNC1(  sqrt,   sqrt, double )
		STD_CMATH_FUNC1(   sin,    sin, double )
		STD_CMATH_FUNC1(   cos,    cos, double )
		STD_CMATH_FUNC1(   log,    log, double )
		STD_CMATH_FUNC1( log10,  log10, double )
		STD_CMATH_FUNC1(   exp,    exp, double )
		STD_CMATH_FUNC2(   pow,    pow, double )
	}
	#undef STD_CMATH_FUNC1
	#undef STD_CMATH_FUNC2

// mistOԂ̎n܂
_MIST_BEGIN

#endif


//! @addtogroup config_group MISTSʂŗpݒ
//!
//! @code ̃wb_Q
//! #include <mist/config/mist_conf.h>
//! @endcode
//!
//! @{


#ifndef _MIST_USER_CONFIG_

#if !defined( NDEBUG ) || defined( DEBUG )

	// fobOp̐ݒSăIɂ
	#define _CHECK_ACCESS_VIOLATION_		1	///< zvfւ̃ANZXᔽ`FbN邩ǂ
	#define _CHECK_ARRAY_OPERATION_			1	///< 1z̉Z̐`FbN邩ǂ
	#define _CHECK_ARRAY1_OPERATION_		1	///< 1摜̉Z̐`FbN邩ǂ
	#define _CHECK_ARRAY2_OPERATION_		1	///< 2摜̉Z̐`FbN邩ǂ
	#define _CHECK_ARRAY3_OPERATION_		1	///< 3摜̉Z̐`FbN邩ǂ

	#define _CHECK_MATRIX_OPERATION_		1	///< s񉉎Z̐`FbN邩ǂ

#else

	// fobOp̐ݒSăItɂ
	#define _CHECK_ACCESS_VIOLATION_		0	///< zvfւ̃ANZXᔽ`FbN邩ǂ
	#define _CHECK_ARRAY_OPERATION_			0	///< 1z̉Z̐`FbN邩ǂ
	#define _CHECK_ARRAY1_OPERATION_		0	///< 1摜̉Z̐`FbN邩ǂ
	#define _CHECK_ARRAY2_OPERATION_		0	///< 2摜̉Z̐`FbN邩ǂ
	#define _CHECK_ARRAY3_OPERATION_		0	///< 3摜̉Z̐`FbN邩ǂ

	#define _CHECK_MATRIX_OPERATION_		0	/// <s񉉎Z̐`FbN邩ǂ

#endif


#define __CHECK_HARD_CASE__					0	///< CONDOR ASYɂāCTrust Region ۂ Hard Case ̃`FbN邩ǂD`FbNق肵œK\ɂȂꍇ܂D

#define _ARRAY_BIND_OPERATION_SUPPORT_		1	///< MIST array  Reim̎lZLɂ邩ǂ
#define _ARRAY1_BIND_OPERATION_SUPPORT_		1	///< MIST array1 Reim̎lZLɂ邩ǂ
#define _ARRAY2_BIND_OPERATION_SUPPORT_		1	///< MIST array2 Reim̎lZLɂ邩ǂ
#define _ARRAY3_BIND_OPERATION_SUPPORT_		1	///< MIST array3 Reim̎lZLɂ邩ǂ


#define _MIST_THREAD_SUPPORT_				1	///< MIST̊eASYł̃XbhT|[g邩ǂDT|[gꍇ́CLINUXn̏ꍇ pthread CuKv

#define _MIST_VECTOR_SUPPORT_				0	///< MISTVECTORLɂDMATRIXƂ̊|ZT|[gDSTLvectorƃNXԂ邽߁COԂ𐳂C|[gKvD

#define _LZW_COMPRESSION_SUPPORT_		false	///< TIFF̏o͂ŁCLZWkLɂIvVftHgɂ邩ǂ

#define _COMPRESSED_CSV_SUPPORT_			0	///< ZLIBkꂽCSVt@C̓ǂݍ݂T|[g邩ǂ


// s񉉎Z̃IvV
#define _USE_INTEL_MATH_KERNEL_LIBRARY_		0	///< Ce񋟂Ă Math Kernel Library 𗘗pꍇ 1 ɂ
#define _DESCENDING_ORDER_EIGEN_VALUE_		0	///< ŗLlEŗLxNgvZɁC~ɕׂ鎞 1Cɕׂ鎞 0 ɂ
#define _USE_BALANCING_MATRIX_EIGEN_		1	///< s̑ΊpsƂŌvZxグi኱ڂɐHj
#define _USE_DIVIDE_AND_CONQUER_SVD_		1	///< @pȓْl𗘗pi኱ڂɐHj

#endif


/// @}
//  MISTSʂŗpݒ̏I


/// @brief ͂ꂽ2̃IuWFNǵiœʒuɂjǂ𔻒肷
//!
//! @param[in] o1 c IuWFNg1
//! @param[in] o2 c IuWFNg2
//!
//! @return true  c ͂ꂽ2̃IuWFNǵCœʒuɑ݂Ă
//! @return false c ͂ꂽ2̃IuWFNǵCʂ̃ɑ݂Ă
//!
template < class Object1, class Object2 >
inline bool is_same_object( const Object1 &o1, const Object2 &o2 )
{
	return( reinterpret_cast< const void * >( &o1 ) == reinterpret_cast< const void * >( &o2 ) );
}

/// @brief UNICODE}`oCgɕϊ
//!
//! @param[in] src c UNICODE
//!
//! @return }`oCg
//!
inline const std::string wstr2str( const std::wstring &src )
{
	static bool is_initialized = false;
	if( !is_initialized )
	{
		is_initialized = true;
		setlocale( LC_CTYPE, "" );
	}

	size_t nbytes = wcstombs( NULL, src.c_str( ), 0 );
	char *buff = new char[ nbytes + 1 ];
	wcstombs( buff, src.c_str( ), nbytes + 1 );
	std::string dst( buff );
	delete [] buff;
	return( dst );
}



//! @addtogroup callback_group MISTSʂŗpłR[obN֐
//!
//! @code ̃wb_Q
//! #include <mist/config.h>
//! @endcode
//!
//! @{


/// @brief MIST̃ASYSʂŗp_~[R[obNt@N^
//!
//! MIST̃ASY񋟂R[obN0`100̊Ԃ̐ԂCASYIۂ100傫lԂ
//! ܂CR[obNt@N^̖߂l false ̏ꍇMIST̃ASY͏𒆒fłꍇ͒fCɐԂ܂D
//! ̍ۂɁCȑʂ͎邩͈Ӗ̂ȂʂƂȂ\܂
//!
struct __mist_dmy_callback__
{
	/// @brief MIST̃ASY̐is󋵂C0`100p[ZgŎ󂯎CȂ֐D
	//!
	//! @param[in] percent c ASY̐is
	//!
	//! @return true  c ASY̎sp
	//! @return false c [U[̃LZɂCASY̎s𒆎~
	//!
	bool operator()( long double /* percent */ ) const { return( true ); }
};


/// @brief w肵R[obN̖߂l [0,100] w肵Ԃɕϊ
//!
//! MIST̃ASY񋟂R[obN0`100̊Ԃ̐ԂCASYIۂ100傫lԂ
//! ܂CR[obNt@N^̖߂l false ̏ꍇMIST̃ASY͏𒆒fłꍇ͒fCɐԂ܂D
//! ̍ۂɁCȑʂ͎邩͈Ӗ̂ȂʂƂȂ\܂
//!
template < class Functor >
struct __mist_convert_callback__
{
	Functor f_;
	double lower_;
	double upper_;

	/// @brief MIST̃ASY̐is󋵂C0`100p[ZgŎ󂯎Cw肵Ԃɕϊ֐D
	//!
	//! @param[in] percent c ASY̐is
	//!
	//! @return true  c ASY̎sp
	//! @return false c [U[̃LZɂCASY̎s𒆎~
	//!
	bool operator()( long double percent )
	{
		percent = lower_ + percent / 100.0 * ( upper_ - lower_ );
		return( f_( percent ) );
	}

	__mist_convert_callback__( ) : lower_( 0.0 ), upper_( 100.0 ){ }
	__mist_convert_callback__( Functor f, double l = 0.0, double u = 100.0 ) : f_( f ), lower_( l ), upper_( u ){ }
};


/// @brief MIST̃ASYSʂŗp\ȁCWo͌^R[obNt@N^
//!
//! @code is󋵂̕\
//! busy... 99%
//! @endcode
//!
struct __mist_console_callback__
{
private:
	int __percent__;

public:
	/// @brief Wo͌^R[obNt@N^̃ftHgRXgN^D
	__mist_console_callback__( ) : __percent__( -1 )
	{
	}

	/// @brief MIST̃ASY̐is󋵂C0`100p[ZgŎ󂯎CWo͂֏o͂D
	//!
	//! @param[in] percent c ASY̐is
	//!
	//! @return true  c ASY̎sp
	//! @return false c [U[̃LZɂCASY̎s𒆎~
	//!
	bool operator()( long double percent )
	{
		int ppp = static_cast< int >( percent );
		if( __percent__ != ppp )
		{
			__percent__ = ppp;

			int k3 = static_cast< int >( percent / 100.0 );
			percent -= k3 * 100.0;
			int k2 = static_cast< int >( percent / 10.0 );
			percent -= k2 * 10.0;
			int k1 = static_cast< int >( percent );

			std::cerr << "busy... ";
			if( k3 == 0 )
			{
				std::cerr << " ";
				if( k2 == 0 )
				{
					std::cerr << " " << k1;
				}
				else
				{
					std::cerr << k2 << k1;
				}
			}
			else
			{
				std::cerr << 1 << k2 << k1;
			}
			if( percent > 100.0 )
			{
				std::cerr << "%" << std::endl;
			}
			else
			{
				std::cerr << "%\r";
			}
		}
		return( true );
	}
};




/// @brief MIST̃ASYSʂŗp\ȁCis󋵕\^_~[R[obNt@N^
//!
//! is󋵂̃o[́CRXgN^ĂяoꂽۂɁCR\[ɕ\
//!
//! @code is󋵂̕\
//! 0%   10   20   30   40   50   60   70   80   90   100%
//! |----|----|----|----|----|----|----|----|----|----|
//! *********************************
//! @endcode
//!
struct __mist_progress_callback__
{
	__mist_progress_callback__( )
	{
		std::cerr << "0%   10   20   30   40   50   60   70   80   90   100%" << std::endl;
		std::cerr << "|----|----|----|----|----|----|----|----|----|----|" << std::endl;
	}

	/// @brief MIST̃ASY̐is󋵂C0`100p[ZgŎ󂯎CWo͂֏o͂D
	//!
	//! @param[in] percent c ASY̐is
	//!
	//! @return true  c ASY̎sp
	//! @return false c [U[̃LZɂCASY̎s𒆎~
	//!
	bool operator()( long double percent ) const
	{
		if( percent > 100.0 )
		{
			std::cerr << "***************************************************" << std::endl;
		}
		else
		{
			int i, p = static_cast< int >( percent / 2.0 );

			for( i = 0 ; i < p ; i++ )
			{
				std::cerr << "*";
			}
			for( ; i < 51 ; i++ )
			{
				std::cerr << " ";
			}

			std::cerr << "\r";
		}

		return( true );
	}
};



/// @}
//  MISTSʂŗpłR[obN֐



#if _CHECK_ACCESS_VIOLATION_

	/// @brief DEBUGMISTrhۂɁC1ANZXł͈̔͊OANZX`FbNCG[̍ۂɌĂ΂֐D
	//!
	//! @param[in] index c MISTReiɑ΂ANZXvʒu
	//!
	inline void mist_debug_assertion( ptrdiff_t index )
	{
		::std::cerr << "Access Violation at ( " << static_cast< int >( index ) << " )" << ::std::endl;
	}


	/// @brief DEBUGMISTrhۂɁC2ANZXł͈̔͊OANZX`FbNCG[̍ۂɌĂ΂֐D
	//!
	//! @param[in] index1 c MISTReiɑ΂Xł̃ANZXvʒu
	//! @param[in] index2 c MISTReiɑ΂Ył̃ANZXvʒu
	//!
	inline void mist_debug_assertion( ptrdiff_t index1, ptrdiff_t index2 )
	{
		::std::cerr << "Access Violation at ( " << static_cast< int >( index1 ) << ", " << static_cast< int >( index2 ) << " )" << ::std::endl;
	}


	/// @brief DEBUGMISTrhۂɁC3ANZXł͈̔͊OANZX`FbNCG[̍ۂɌĂ΂֐D
	//!
	//! @param[in] index1 c MISTReiɑ΂Xł̃ANZXvʒu
	//! @param[in] index2 c MISTReiɑ΂Ył̃ANZXvʒu
	//! @param[in] index3 c MISTReiɑ΂Zł̃ANZXvʒu
	//!
	inline void mist_debug_assertion( ptrdiff_t index1, ptrdiff_t index2, ptrdiff_t index3 )
	{
		::std::cerr << "Access Violation at ( " << static_cast< int >( index1 ) << ", " << static_cast< int >( index2 ) << ", " << static_cast< int >( index3 ) << " )" << ::std::endl;
	}


	#define _CHECK_ACCESS_VIOLATION1U_( index ) \
		if( index >= size( ) )\
		{\
			static value_type dmy;\
			mist_debug_assertion( index );\
			return( dmy );\
		}

	#define _CHECK_ACCESS_VIOLATION1S_( index ) \
		if( index < 0 || index >= size( ) )\
		{\
			static value_type dmy;\
			mist_debug_assertion( index );\
			return( dmy );\
		}

	#define _CHECK_ACCESS_VIOLATION2U_( index1, index2 ) \
		if( index1 >= size1( ) || index2 >= size2( ) )\
		{\
			static value_type dmy;\
			mist_debug_assertion( index1, index2 );\
			return( dmy );\
		}

	#define _CHECK_ACCESS_VIOLATION2S_( index1, index2 ) \
		if( index1 < 0 || index1 >= size1( ) || index2 < 0 || index2 >= size2( ) )\
		{\
			static value_type dmy;\
			mist_debug_assertion( index1, index2 );\
			return( dmy );\
		}

	#define _CHECK_ACCESS_VIOLATION3U_( index1, index2, index3 ) \
		if( index1 >= size1( ) || index2 >= size2( ) || index3 >= size3( ) )\
		{\
			static value_type dmy;\
			mist_debug_assertion( index1, index2, index3 );\
			return( dmy );\
		}

	#define _CHECK_ACCESS_VIOLATION3S_( index1, index2, index3 ) \
		if( index1 < 0 || index1 >= size1( ) || index2 < 0 || index2 >= size2( ) || index3 < 0 || index3 >= size3( ) )\
		{\
			static value_type dmy;\
			mist_debug_assertion( index1, index2, index3 );\
			return( dmy );\
		}

#else

	#define _CHECK_ACCESS_VIOLATION1U_( index ) 
	#define _CHECK_ACCESS_VIOLATION1S_( index ) 
	#define _CHECK_ACCESS_VIOLATION2U_( index1, index2 )
	#define _CHECK_ACCESS_VIOLATION2S_( index1, index2 )
	#define _CHECK_ACCESS_VIOLATION3U_( index1, index2, index3 )
	#define _CHECK_ACCESS_VIOLATION3S_( index1, index2, index3 )

#endif



/*** Doxygen p̃Cy[W ***********************************************************************************************/
/*! @mainpage MIST ( Media Integration Standard Toolkit )
*
*
* @section config MIST̊{ݒ
*
* - @ref config_group			"{ݒ"
* - @ref callback_group			"MISTSʂŗpłR[obN֐
*
* @section class MISTŒ񋟂{Rei
*
* - @ref mist::array			"array"          : STLɏŘAƂȂ1złCE摜̑SẴf[^̊NX
* - @ref mist::array1			"array1"         : ߂1z
* - @ref mist::array2			"array2"         : 2摜߂̉摜NX
* - @ref mist::array3			"array3"         : 3摜߂̉摜NX
* - @ref mist::bitmap			"bitmap"         : rbg}bv摜߂̃NX
* - @ref mist::marray			"marray"         : 1E2E3摜̉Ƀ}[W摜NX
* - @ref mist::buffered_array	"buffered_array" : 摜̈ӂ2̎wƂȂ摜NX
* - @ref mist::matrix			"matrix"         : Cӂ̍s߂̃NXiExpression template 𗘗pȉZ\j
* - @ref vector_group			"xNgZ\ƂNX"
*   - @ref mist::vector2		"vector2"        : 2xNgNX
*   - @ref mist::vector3		"vector3"        : 3xNgNX
*   - @ref mist::vector			"vector"         : NxNgNX
*
*
* @section element MISTŒ񋟂{f[^^
* - @ref mist::binary						"oCif"
* - @ref color_group						"FԂNX"
*   - @ref mist::rgb						"J[f"
*   - @ref mist::bgr						"Windowsp̃rbg}bvŗpJ[f"
*   - @ref mist::rgba						"J[fiAt@tj"
* - @ref mist::stereo						"XeI"
* - @ref mist::quaternion					"NH[^jIilj"
* - @ref set_group							"W"
* - @ref facet_group						"|S֘A"
*   - @ref mist::facet						"|SNX"
*   - @ref mist::facet_list					"|S̏WNX"
*   - @ref mist::surface_simplification		"|S̍팸"
*
*
* @section algorithm MISTŒ񋟂ASY
*
*
* @subsection implement	⏕
* - @ref limits_group						"^ɑ΂"
* - @ref pointer_group						"IɃǗs|C^"
* - @ref mist::timer						"Ԍv"
* - @ref environment_group					"vZ@"
* - @ref operator_group						"Zq̎⏕"
* - @ref thread_group						"}`Xbh"
*   - @ref mist::thread_pool				"Xbhv["
*   - @ref mist::singleton					"VOg"
* - @ref free_form_group					"RȐEȖ"
*   - @ref bspline_group					"BXvCȐ"
*   - @ref spline_group						"3XvCȐ"
* - @ref mist::crc							"CRC"
* - @ref hash_group							"nbV֐"
*   - @ref mist::md2						"MD2"
*   - @ref mist::md4						"MD4"
*   - @ref mist::md5						"MD5"
*   - @ref mist::sha1						"SHA-1"
*   - @ref mist::sha256						"SHA-256"
*   - @ref mist::sha384						"SHA-384"
*   - @ref mist::sha512						"SHA-512"
*
*
* @subsection numeric xNgEs񉉎Z
* - @ref numeric_group "s񉉎Z"
*   - @ref mist::trace						"g[X"
*   - @ref mist::det						"s"
*   - @ref mist::inverse					"ts"
*   - @ref mist::solve						"A"
*   - @ref mist::qr_factorization			"QR "
*   - @ref mist::lu_factorization			"LU "
*   - @ref mist::eigen						"ŗLlEŗLxNg"
*   - @ref mist::svd						"ْl"
*
*
* @subsection common ʂ̏
* - @ref fourier_group							"t[Gϊ"
*   - @ref fft_group							"t[Gϊ (FFT)"
*   - @ref dct_group							"URTCϊ(DCT)"
*   - @ref dst_group							"UTCϊ (DST) "
* - @ref a										"EF[ubgϊ"
* - @ref statistics_group						"v"
*   - @ref mist::statistics::average			"ϒlvZ"
*   - @ref mist::statistics::variance			"UvZ"
*   - @ref mist::statistics::generate_histogram	"qXgO쐬"
*   - @ref mixture_group						"Kz̐"
* - @ref random_group							"["
*   - @ref mist::uniform::random				"l"
*   - @ref mist::gauss::random					"K"
* - @ref a										"Ot`(2)"
* - 摜{IuWFNg̕`
*   - @ref image_draw_group						"OpenGLp2摜`"
*   - @ref image_drawing_group					"E~̕`"
* - @ref minimization_group						"֐̍ŏ"
* - @ref registration_group						"WXg[V"
*   - @ref mist::non_rigid						"񍄑̃WXg[V"
* - @ref visualization_group					""
*   - @ref volumerendering_group				"{[_O"
*   - @ref mist::marching_cubes					"Zxʕ\"
* - Lu[V
*   - @ref calibration_group					"JLu[V"
* - @ref machine_learning_group					"@BwK"
*   - @ref mist::machine_learning::adaboost		"Multiclass AdaBoost"
* - @ref hht_group								"oI[hуqxgϊ"
*   - @ref mist::hilbert						"qxgϊ"
*   - @ref mist::emd							"oI[h"
*
*
* @subsection image ɉ摜ɑ΂ēKp鏈
*
*
* @subsubsection image-io o͌n
* - @ref image_group						"Cӂ̉摜f[^̓ǂݍ݁Eo"
*   - @ref image_raw_group					"RAWf[^̓ǂݍ݁Eo"
*   - @ref image_bmp_group					"BMPf[^̓ǂݍ݁Eo"
*   - @ref image_pnm_group					"PNMf[^̓ǂݍ݁Eo"
*   - @ref image_jpeg_group					"JPEGf[^̓ǂݍ݁Eo"
*   - @ref image_png_group					"PNGf[^̓ǂݍ݁Eo"
*   - @ref image_gif_group					"GIFf[^̓ǂݍ"
*   - @ref image_tiff_group					"TIFFf[^̓ǂݍ݁Eo"
*   - @ref image_tga_group					"TGAf[^̓ǂݍ݁Eo"
*   - @ref dicom_group						"DICOMf[^̓ǂݍ݁Eo"
*
*
* @subsubsection image-filter tB^n
* - @ref linear_group								"`tB^"
* - @ref median_group								"fBAtB^"
* - @ref region_growing_group						"̈g@"
* - @ref interpolate_group							"摜"
*   - @ref mist::nearest							"ŋߖT^"
*   - @ref mist::mean								"ϒl^"
*   - @ref mist::linear								"`"
*   - @ref mist::cubic								"3ԁisinc֐3ߎ𗘗pԁj"
*   - @ref mist::BSpline							"3BXvC"
*   - @ref mist::sinc								"sinc֐ԁiSfݍނ̂ŌvZRXgj"
* - @ref edge_group									"GbWo"
*   - @ref mist::canny								"CannyGbWo"
* - @ref corner_group								"R[i[o"
*   - @ref mist::harris								"HarrisR[i[o"
* - J[摜ɑ΂鏈
*   - @ref interlace_group							"C^[X"
* - @ref threshold_group							"臒lI"
* - @ref morphology_group							"tHW[Z"
* - 2l摜ɑ΂鏈
*   - @ref labeling_group							"xO"
*   - @ref decomposition_group						"}`"
*   - @ref boundary_group							"Efo"
*   - @ref mode_group								"ŕpltB^"
*   - @ref thinning_group							"א"
*   - @ref skeleton_group							"XPgo"
*   - @ref distance_group									"ϊ"
*     - @ref voronoi_distance_group							"{mC"
*     - @ref euclidean_distance_group						"[Nbh2拗ϊ"
*     - @ref mist::euclidean::inverse_distance_transform	"[Nbh2tϊ"
*     - @ref mist::manhattan::distance_transform			"}nb^iVeB[ubNjϊ"
*     - @ref mist::chessboard::distance_transform			"`FX{[hϊ"
*   - @ref fusion_group										"}`Z"
*     - @ref fusion_mdt_group								"}nb^iL1mCVeB[ubNj"
*
*
* @subsection audio ɉɑ΂ēKp鏈
*
*
* @subsubsection audio-io o͌n
* - @ref audio_group						"f[^̓ǂݍ݁Eo"
*   - @ref audio_wav_group					"WAVf[^̓ǂݍ݁Eo"
*
*
* @subsubsection audio-filter tB^n
* - @ref a									"TvO[gύX"
* - @ref a									"Đ"
*
*
****************************************************************************************************************************/





// mistOԂ̏I
_MIST_END


#endif
