// 
// Copyright (c) 2003-2010, MIST Project, Nagoya University
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
// 
// 2. Redistributions in binary form must reproduce the above copyright notice,
// this list of conditions and the following disclaimer in the documentation
// and/or other materials provided with the distribution.
// 
// 3. Neither the name of the Nagoya University nor the names of its contributors
// may be used to endorse or promote products derived from this software
// without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
// IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
// THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 

/// @file mist/config/mist_alloc.h
//!
//! @brief MISTReiŗpAP[^сC샋[`
//!

#ifndef __INCLUDE_MIST_ALLOC_H__
#define __INCLUDE_MIST_ALLOC_H__

#include <cstring>
#include <memory>

#ifndef __INCLUDE_MIST_CONF_H__
#include "mist_conf.h"
#endif

#ifndef __INCLUDE_MIST_TYPE_TRAIT_H__
#include "type_trait.h"
#endif


// mistOԂ̎n܂
_MIST_BEGIN



/// @brief [U[`^p̃֐Q
template < bool b >
struct mist_memory_operator
{
	/// @brief num ̃IuWFNgmۂCftHg̒lŏ
	//! 
	//! gݍ݌^̃f[^̏ꍇ 0 ŏ
	//! 
	//! @param[in] allocator c gpAP[^
	//! @param[in] num       c mۂIuWFNg
	//! 
	//! @return mۂ̈̐擪AhX
	//! 
	template < class Allocator >
	static typename Allocator::pointer allocate_objects1( Allocator &allocator, typename Allocator::size_type num )
	{
#if _MIST_ALLOCATE_TEST_ != 0
		::std::cerr << "Normal Allocator" << ::std::endl;
#endif
		typename Allocator::pointer ptr = allocator.allocate( num, 0 );
		typename Allocator::value_type obj;
		for( typename Allocator::size_type i = 0 ; i < num ; i++ ) allocator.construct( &( ptr[i] ), obj );
		return( ptr );
	}


	/// @brief num ̃IuWFNgmۂC̒lŏ
	//! 
	//! gݍ݌^̃f[^̏ꍇ͒lď
	//! 
	//! @param[in] allocator c gpAP[^
	//! @param[in] num       c mۂIuWFNg
	//! @param[in] obj       c Rs[RXgN^ɓnl
	//! 
	//! @return mۂ̈̐擪AhX
	//! 
	template < class Allocator >
	static typename Allocator::pointer allocate_objects2( Allocator &allocator, typename Allocator::size_type num, typename Allocator::const_reference obj )
	{
#if _MIST_ALLOCATE_TEST_ != 0
		::std::cerr << "Normal Allocator" << ::std::endl;
#endif
		typename Allocator::pointer ptr = allocator.allocate( num, 0 );
		for( typename Allocator::size_type i = 0 ; i < num ; i++ ) allocator.construct( &( ptr[i] ), obj );
		return( ptr );
	}


	/// @brief |C^ s  e ͈̔͂̃f[^ŏ
	//! 
	//! gݍ݌^̃f[^̏ꍇ͒lď
	//! 
	//! @param[in] allocator c gpAP[^
	//! @param[in] s         c Jn|C^
	//! @param[in] e         c I|C^
	//! 
	//! @return mۂ̈̐擪AhX
	//! 
	template < class Allocator >
	static typename Allocator::pointer allocate_objects3( Allocator &allocator, typename Allocator::const_pointer s, typename Allocator::const_pointer e )
	{
#if _MIST_ALLOCATE_TEST_ != 0
		::std::cerr << "Normal Allocator" << ::std::endl;
#endif
		typename Allocator::pointer ptr = allocator.allocate( e - s, 0 );
		for( typename Allocator::pointer p = ptr ; s != e ; p++, s++ ) allocator.construct( p, *s );
		return( ptr );
	}


	/// @brief ptr  num ̃IuWFNgJfXgN^Ăяo
	//! 
	//! gݍ݌^̏ꍇ̓fXgN^͌ĂяoȂ
	//! 
	//! @param[in] allocator c gpAP[^
	//! @param[in] ptr       c J郁̈̐擪AhX
	//! @param[in] num       c JIuWFNg
	//! 
	template < class Allocator >
	static void deallocate_objects( Allocator &allocator, typename Allocator::pointer ptr, typename Allocator::size_type num )
	{
#if _MIST_ALLOCATE_TEST_ != 0
		::std::cerr << "Normal Deallocator" << ::std::endl;
#endif
		for( typename Allocator::size_type i = 0 ; i < num ; i++ ) allocator.destroy( &( ptr[i] ) );
		allocator.deallocate( ptr, num );
	}


	/// @brief |C^ s  e ܂ł̊Ԃ̃f[^ x ɃRs[
	//! 
	//! gݍ݌^̏ꍇ memcpy 𗘗p
	//! 
	//! @param[in] allocator c gpAP[^
	//! @param[in] s         c Rs[̐擪AhX
	//! @param[in] e         c Rs[̖AhX
	//! @param[in] x         c Rs[̐擪AhX
	//! 
	//! @return Rs[̖AhX
	//! 
	template < class Allocator >
	static typename Allocator::pointer copy_objects1( Allocator & /* allocator */, typename Allocator::const_pointer s, typename Allocator::const_pointer e, typename Allocator::pointer x )
	{
#if _MIST_ALLOCATE_TEST_ != 0
		::std::cerr << "Normal Copy Function" << ::std::endl;
#endif
		while( s != e )
		{
			*x = *s;
			++x;
			++s;
		}
		return( x );
	}


	/// @brief |C^ ptr  num ̃f[^ to ɃRs[
	//! 
	//! gݍ݌^̏ꍇ memcpy 𗘗p
	//! 
	//! @param[in] allocator c gpAP[^
	//! @param[in] ptr       c Rs[̐擪AhX
	//! @param[in] num       c Rs[IuWFNg
	//! @param[in] to        c Rs[̐擪AhX
	//! 
	//! @return Rs[̖AhX
	//! 
	template < class Allocator >
	static typename Allocator::pointer copy_objects2( Allocator & /* allocator */, typename Allocator::const_pointer ptr, typename Allocator::size_type num, typename Allocator::pointer to )
	{
#if _MIST_ALLOCATE_TEST_ != 0
		::std::cerr << "Normal Copy Function" << ::std::endl;
#endif
		for( typename Allocator::size_type i = 0 ; i < num ; i++ ) to[i] = ptr[i];
		return( to + num );
	}


	/// @brief |C^ ptr  num ̃f[^obj
	//! 
	//! char ^̏ꍇ memset 𗘗p
	//! 
	//! @param[in] allocator c gpAP[^
	//! @param[in] ptr       c 擪AhX
	//! @param[in] num       c IuWFNg
	//! @param[in] obj       c IuWFNg
	//! 
	template < class Allocator >
	static void fill_objects1( Allocator & /* allocator */, typename Allocator::pointer ptr, typename Allocator::size_type num, typename Allocator::const_reference obj )
	{
#if _MIST_ALLOCATE_TEST_ != 0
		::std::cerr << "Normal Clean Function" << ::std::endl;
#endif
		for( typename Allocator::size_type i = 0 ; i < num ; i++ ) ptr[i] = obj;
	}


	/// @brief |C^ ptr  num ̃f[^ɏl
	//! 
	//! gݍ݌^̏ꍇ memset 𗘗p
	//! 
	//! @param[in] allocator c gpAP[^
	//! @param[in] ptr       c 擪AhX
	//! @param[in] num       c IuWFNg
	//! 
	template < class Allocator >
	static void fill_objects2( Allocator & /* allocator */, typename Allocator::pointer ptr, typename Allocator::size_type num )
	{
#if _MIST_ALLOCATE_TEST_ != 0
		::std::cerr << "Normal Clean Function" << ::std::endl;
#endif
		typename Allocator::value_type obj;
		for( typename Allocator::size_type i = 0 ; i < num ; i++ ) ptr[i] = obj;
	}
};




/// @brief gݍ݌^p̃֐Q
template <>
struct mist_memory_operator< true >
{
	/// @brief num ̃IuWFNgmۂCftHg̒lŏ
	//! 
	//! gݍ݌^̃f[^̏ꍇ 0 ŏ
	//! 
	//! @param[in] allocator c gpAP[^
	//! @param[in] num       c mۂIuWFNg
	//! 
	//! @return mۂ̈̐擪AhX
	//! 
	template < class Allocator >
	static typename Allocator::pointer allocate_objects1( Allocator &allocator, typename Allocator::size_type num )
	{
#if _MIST_ALLOCATE_TEST_ != 0
		::std::cerr << "Memset Allocator" << ::std::endl;
#endif
		typename Allocator::pointer ptr = allocator.allocate( num, 0 );
		::memset( ptr, 0, num * sizeof( typename Allocator::value_type ) );
		return( ptr );
	}


	/// @brief num ̃IuWFNgmۂC̒lŏ
	//! 
	//! gݍ݌^̃f[^̏ꍇ͒lď
	//! 
	//! @param[in] allocator c gpAP[^
	//! @param[in] num       c mۂIuWFNg
	//! @param[in] obj       c Rs[RXgN^ɓnl
	//! 
	//! @return mۂ̈̐擪AhX
	//! 
	template < class Allocator >
	static typename Allocator::pointer allocate_objects2( Allocator &allocator, typename Allocator::size_type num, typename Allocator::const_reference obj )
	{
#if _MIST_ALLOCATE_TEST_ != 0
		::std::cerr << "Specialized Allocator" << ::std::endl;
#endif
		typename Allocator::pointer ptr = allocator.allocate( num, 0 );
		for( typename Allocator::size_type i = 0 ; i < num ; i++ ) ptr[i] = obj;
		return( ptr );
	}


	/// @brief |C^ s  e ͈̔͂̃f[^ŏ
	//! 
	//! gݍ݌^̃f[^̏ꍇ͒lď
	//! 
	//! @param[in] allocator c gpAP[^
	//! @param[in] s         c Jn|C^
	//! @param[in] e         c I|C^
	//! 
	//! @return mۂ̈̐擪AhX
	//! 
	template < class Allocator >
	static typename Allocator::pointer allocate_objects3( Allocator &allocator, typename Allocator::const_pointer s, typename Allocator::const_pointer e )
	{
#if _MIST_ALLOCATE_TEST_ != 0
		::std::cerr << "Memcpy Allocator" << ::std::endl;
#endif
		typename Allocator::pointer ptr = allocator.allocate( e - s, 0 );
		memcpy( ptr, s, ( e - s ) * sizeof( typename Allocator::value_type ) );
		return( ptr );
	}


	/// @brief ptr  num ̃IuWFNgJfXgN^Ăяo
	//! 
	//! gݍ݌^̏ꍇ̓fXgN^͌ĂяoȂ
	//! 
	//! @param[in] allocator c gpAP[^
	//! @param[in] ptr       c J郁̈̐擪AhX
	//! @param[in] num       c JIuWFNg
	//! 
	template < class Allocator >
	static void deallocate_objects( Allocator &allocator, typename Allocator::pointer ptr, typename Allocator::size_type num )
	{
#if _MIST_ALLOCATE_TEST_ != 0
		::std::cerr << "Specialized Deallocator" << ::std::endl;
#endif
		allocator.deallocate( ptr, num );
	}


	/// @brief |C^ s  e ܂ł̊Ԃ̃f[^ x ɃRs[
	//! 
	//! memcpy 𗘗păoCgPʂŃf[^Rs[
	//! 
	//! @param[in] allocator c gpAP[^
	//! @param[in] s         c Rs[̐擪AhX
	//! @param[in] e         c Rs[̖AhX
	//! @param[in] x         c Rs[̐擪AhX
	//! 
	//! @return Rs[̖AhX
	//! 
	template < class Allocator >
	static typename Allocator::pointer copy_objects1( Allocator & /* allocator */, typename Allocator::const_pointer s, typename Allocator::const_pointer e, typename Allocator::pointer x )
	{
#if _MIST_ALLOCATE_TEST_ != 0
		::std::cerr << "Memcpy Copy Function" << ::std::endl;
#endif
		memcpy( x, s, ( e - s ) * sizeof( typename Allocator::value_type ) );
		return( x + ( e - s ) );
	}


	/// @brief |C^ ptr  num ̃f[^ to ɃRs[
	//! 
	//! memcpy 𗘗păoCgPʂŃf[^Rs[
	//! 
	//! @param[in] allocator c gpAP[^
	//! @param[in] ptr       c Rs[̐擪AhX
	//! @param[in] num       c Rs[IuWFNg
	//! @param[in] to        c Rs[̐擪AhX
	//! 
	//! @return Rs[̖AhX
	//! 
	template < class Allocator >
	static typename Allocator::pointer copy_objects2( Allocator & /* allocator */, typename Allocator::const_pointer ptr, typename Allocator::size_type num, typename Allocator::pointer to )
	{
#if _MIST_ALLOCATE_TEST_ != 0
		::std::cerr << "Memcpy Copy Function" << ::std::endl;
#endif
		memcpy( to, ptr, num * sizeof( typename Allocator::value_type ) );
		return( to + num );
	}


	/// @brief |C^ ptr  num ̃f[^obj
	//! 
	//! char ^̏ꍇ memset 𗘗p
	//! 
	//! @param[in] allocator c gpAP[^
	//! @param[in] ptr       c 擪AhX
	//! @param[in] num       c IuWFNg
	//! @param[in] obj       c IuWFNg
	//! 
	template < class Allocator >
	static void fill_objects1( Allocator & /* allocator */, typename Allocator::pointer ptr, typename Allocator::size_type num, typename Allocator::const_reference obj )
	{
#if _MIST_ALLOCATE_TEST_ != 0
		::std::cerr << "Memcpy Clean Function" << ::std::endl;
#endif
		memset( ptr, obj, num * sizeof( typename Allocator::value_type ) );
	}


	/// @brief |C^ ptr  num ̃f[^ɏl
	//! 
	//! memset 𗘗pāCSvf0ɏ
	//! 
	//! @param[in] allocator c gpAP[^
	//! @param[in] ptr       c 擪AhX
	//! @param[in] num       c IuWFNg
	//! 
	template < class Allocator >
	static void fill_objects2( Allocator & /* allocator */, typename Allocator::pointer ptr, typename Allocator::size_type num )
	{
#if _MIST_ALLOCATE_TEST_ != 0
		::std::cerr << "Memcpy Clean Function" << ::std::endl;
#endif
		memset( ptr, 0, num * sizeof( typename Allocator::value_type ) );
	}
};



/// @brief MISTSTL̃AP[^ʓIɗp邽߂̎dg
//! 
//! f[^̌^ɂāCʂ}Ă
//! 
//! @param T         c f[^^
//! @param Allocator c AP[^^Cv
//! 
template < class T, class Allocator >
class mist_allocator : public Allocator
{
public:
	typedef Allocator base;											///< @brief MISTReipAP[^^
	typedef typename Allocator::reference reference;				///< @brief MIST̃ReiɊi[f[^^̎QƁDmist::array< data > ̏ꍇCdata & ƂȂ
	typedef typename Allocator::const_reference const_reference;	///< @brief MIST̃ReiɊi[f[^^ const QƁDmist::array< data > ̏ꍇCconst data & ƂȂ
	typedef typename Allocator::value_type value_type;				///< @brief MIST̃ReiɊi[f[^^Dmist::array< data >  data Ɠ
	typedef typename Allocator::size_type size_type;				///< @brief Ȃ̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ size_t ^Ɠ
	typedef typename Allocator::difference_type difference_type;	///< @brief t̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ ptrdiff_t ^Ɠ
	typedef typename Allocator::pointer pointer;					///< @brief MIST̃ReiɊi[f[^^̃|C^[^Dmist::array< data > ̏ꍇCdata * ƂȂ
	typedef typename Allocator::const_pointer const_pointer;		///< @brief MIST̃ReiɊi[f[^^ const |C^[^Dmist::array< data > ̏ꍇCconst data * ƂȂ

protected:
	pointer   shared_pointer;		// p\ȃւ̃|C^iOƃLꍇ̂ݗpj 
	size_type shared_memory;		// p\ȃʁiOƃLꍇ̂ݗpj 


public:
	/// @brief num ̃IuWFNg̃mۂsigݍ݌^ǂœ̎𕪊j
	pointer allocate_objects( size_type num )
	{
		if( num == 0 || num > max_size( ) )
		{
			return( NULL );
		}
		else if( !is_memory_shared( ) )
		{
			// Ń蓖Ăꍇ
			return( mist_memory_operator< is_builtin< T >::value >::allocate_objects1( *this, num ) );
		}
		else
		{
			// O蓖Ẵ𗘗pꍇ
			return( shared_pointer );
		}
	}

	/// @brief num ̃IuWFNg̃mۂ obj pďsigݍ݌^ǂœ̎𕪊j
	pointer allocate_objects( size_type num, const_reference obj )
	{
		if( num == 0 || num > max_size( ) )
		{
			return( NULL );
		}
		else if( !is_memory_shared( ) )
		{
			// Ń蓖Ăꍇ
			return( mist_memory_operator< is_builtin< T >::value >::allocate_objects2( *this, num, obj ) );
		}
		else
		{
			// O蓖Ẵ𗘗pꍇ
			mist_memory_operator< type_and< is_char< T >::value, is_builtin< T >::value >::value >::fill_objects1( *this, shared_pointer, num, obj );
			return( shared_pointer );
		}
	}

	/// @brief num ̃IuWFNgmۂC|C^ň͂܂ꂽԂ̃f[^ŏ(gݍ݌^̃f[^̏ꍇ memcpy 𗘗p)
	pointer allocate_objects( const_pointer s, const_pointer e )
	{
		if( s >= e || e - s > max_size( ) )
		{
			return( NULL );
		}
		else if( !is_memory_shared( ) )
		{
			// Ń蓖Ăꍇ
			return( mist_memory_operator< is_builtin< T >::value >::allocate_objects3( *this, s, e ) );
		}
		else
		{
			// O蓖Ẵ𗘗pꍇ
			mist_memory_operator< type_and< is_char< T >::value, is_builtin< T >::value >::value >::copy_objects2( *this, s, e - s, shared_pointer );
			return( shared_pointer );
		}
	}

	/// @brief num ̃IuWFNg̃JCfXgN^Ăяoigݍ݌^̏ꍇ̓fXgN^͌Ă΂Ȃj
	void deallocate_objects( pointer ptr, size_type num )
	{
		if( !is_memory_shared( ) )
		{
			// Ń蓖Ăꍇ
			if( num <= 0 ) return;
			mist_memory_operator< is_builtin< T >::value >::deallocate_objects( *this, ptr, num );
		}
	}

	/// @brief |C^ s  e ܂ł̊Ԃ̃f[^ x ɃRs[
	pointer copy_objects( const_pointer s, const_pointer e, pointer x ) const
	{
		if( s >= e ) return( x );
		return( mist_memory_operator< is_builtin< T >::value >::copy_objects1( *this, s, e, x ) );
	}

	/// @brief |C^ ptr  num ̃f[^ to ɃRs[
	pointer copy_objects( const_pointer ptr, size_type num, pointer to ) const
	{
		if( num <= 0 ) return( to );
		return( mist_memory_operator< is_builtin< T >::value >::copy_objects2( *this, ptr, num, to ) );
	}

	/// @brief |C^ ptr  num ̃f[^obj
	void fill_objects( pointer ptr, size_type num, const_reference obj ) const
	{
		if( num <= 0 ) return;
		mist_memory_operator< type_and< is_char< T >::value, is_builtin< T >::value >::value >::fill_objects1( *this, ptr, num, obj );
	}

	/// @brief |C^ ptr  num ̃f[^ɏl
	void fill_objects( pointer ptr, size_type num ) const
	{
		if( num <= 0 ) return;
		mist_memory_operator< is_builtin< T >::value >::fill_objects2( *this, ptr, num );
	}

	/// @brief ptr n܂ num ݂IuWFNg dest_num ܂ŏk߁CSĂ̗vfftHg̒lŏ
	//! 
	//! @attention MSVC̏ꍇ́C̈̃g삪삵Ȃ߁C̍Ċmۂs
	//! 
	pointer trim_objects( pointer ptr, size_type num, size_type dest_num )
	{
		if( num < dest_num ) return( ptr );			// J悤ƂĂz̗vf́Cg̔zTCYTCYO
		//if( num < 0 ) return( NULL );				// g̔zTCY0菬O
		if( num == dest_num ) return( ptr );		// gɂύX̕KvȂ
		if( num == 0 ) return( NULL );

		if( !is_memory_shared( ) )
		{
			// Ń蓖Ăꍇ
#if _MIST_ALLOCATOR_MEMORY_TRIM_ != 0
			deallocate_objects( ptr + dest_num, num - dest_num );
			fill_objects( ptr, dest_num );
#else
			deallocate_objects( ptr, num );
			ptr = allocate_objects( dest_num );
#endif
		}
		return( dest_num == 0 ? NULL : ptr );
	}

	/// @brief ptr n܂ num ݂IuWFNg dest_num ܂ŏk߁CSĂ̗vfl obj ŏ
	//! 
	//! @attention MSVC̏ꍇ́C̈̃g삪삵Ȃ߁C̍Ċmۂs
	//! 
	pointer trim_objects( pointer ptr, size_type num, size_type dest_num, const_reference obj )
	{
		if( num < dest_num ) return( ptr );			// J悤ƂĂz̗vf́Cg̔zTCYTCYO
		if( num < 0 ) return( NULL );				// g̔zTCY0菬O
		if( num == dest_num ) return( ptr );		// gɂύX̕KvȂ
		if( num == 0 ) return( NULL );

		if( !is_memory_shared( ) )
		{
			// Ń蓖Ăꍇ
#if _MIST_ALLOCATOR_MEMORY_TRIM_ != 0
			deallocate_objects( ptr + dest_num, num - dest_num );
			fill_objects( ptr, dest_num, obj );
#else
			deallocate_objects( ptr, num );
			ptr = allocate_objects( dest_num, obj );
#endif
		}
		return( dest_num == 0 ? NULL : ptr );
	}

	/// @brief gpĂAP[^mۉ\ȃ̍őlԂ
	size_type max_size( ) const
	{
		return( shared_memory == 0 ? base::max_size( ) : shared_memory );
	}

	/// @brief OŊ蓖Ăꂽ̈gpĂ邩ǂ
	bool is_memory_shared( ) const
	{
		return( shared_memory != 0 );
	}

	/// @brief ̃AP[^
	const Allocator &operator=( const Allocator &alloc )
	{
		if( &alloc != this )
		{
			// O𗘗pĂ邩ǂ͎󂯌pȂ
			base::operator=( alloc );
		}
		return( *this );
	}

	/// @brief ̃AP[^
	const mist_allocator &operator=( const mist_allocator &alloc )
	{
		if( &alloc != this )
		{
			// O𗘗pĂ邩ǂ͎󂯌pȂ
			base::operator=( alloc );
		}
		return( *this );
	}


	/// @brief ftHgRXgN^
	mist_allocator( ) : base( ), shared_pointer( NULL ), shared_memory( 0 ){}


	/// @brief ftHgRXgN^
	//! 
	//! @attention OŊ蓖Ă̈𗘗pꍇ
	//! 
	/// @param[in] ptr       c O̐擪̃|C^
	/// @param[in] mem_shared c OɊ蓖Ă
	//! 
	mist_allocator( pointer ptr, size_type mem_shared ) : base( ),  shared_pointer( mem_shared == 0 ? NULL : ptr ), shared_memory( ptr == NULL ? 0 : mem_shared ){}


	/// @brief ̃AP[^pď
	mist_allocator( const Allocator &alloc ) : base( alloc ), shared_pointer( NULL ), shared_memory( 0 ){}


	/// @brief ̃AP[^pď
	mist_allocator( const mist_allocator &alloc ) : base( alloc ), shared_pointer( NULL ), shared_memory( 0 ){}
};



// mistOԂ̏I
_MIST_END

#endif // __INCLUDE_MIST_ALLOC_H__
