// 
// Copyright (c) 2003-2010, MIST Project, Nagoya University
// All rights reserved.
// 
// Redistribution and use in source and binary forms, with or without modification,
// are permitted provided that the following conditions are met:
// 
// 1. Redistributions of source code must retain the above copyright notice,
// this list of conditions and the following disclaimer.
// 
// 2. Redistributions in binary form must reproduce the above copyright notice,
// this list of conditions and the following disclaimer in the documentation
// and/or other materials provided with the distribution.
// 
// 3. Neither the name of the Nagoya University nor the names of its contributors
// may be used to endorse or promote products derived from this software
// without specific prior written permission.
// 
// THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
// CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
// DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
// IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF
// THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
// 

/// @file mist/config/iterator.h
//!
//! @brief MISTRei𑀍삷邽߂̃Ce[^
//!

#ifndef __INCLUDE_MIST_ITERATOR_H__
#define __INCLUDE_MIST_ITERATOR_H__


#include <iterator>

#ifndef __INCLUDE_MIST_CONF_H__
#include "mist_conf.h"
#endif

// mistOԂ̎n܂
_MIST_BEGIN



/// @brief mistReiŗp1p_ANZXCe[^
//! 
//! arrayCarray1Carray2CmatrixCvector p̏_ANZXCe[^
//! 
//! @param T         c ͌^
//! @param Distance  c Ce[^Ԃ̍\^iftHg ptrdiff_tj
//! @param Pointer   c Ce[^̗vfւ̃|C^^iftHg T*j
//! @param Reference c Ce[^̗vfւ̎Qƌ^iftHg T&j
//! 
template< class T, class Distance = ptrdiff_t, class Pointer = T*, class Reference = T& >
#if defined( __MIST_MSVC__ ) && __MIST_MSVC__ <= 6
class mist_iterator1 : public std::iterator< std::random_access_iterator_tag, T, Distance >
#else
class mist_iterator1 : public std::iterator< std::random_access_iterator_tag, T, Distance, Pointer, Reference >
#endif
{
public:
	typedef T value_type;					///< @brief f[^^
	typedef Pointer pointer;				///< @brief f[^^̃|C^[^Ddata ̏ꍇCdata * ƂȂ
	typedef Reference reference;			///< @brief f[^^̎QƁDdata ̏ꍇCdata & ƂȂ
	typedef size_t size_type;				///< @brief Ȃ̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ size_t ^Ɠ
	typedef Distance difference_type;		///< @brief t̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ ptrdiff_t ^Ɠ
	typedef Reference const_reference;		///< @brief f[^^ const QƁDdata ̏ꍇCconst data & ƂȂ

private:
	pointer data_;					///< @brief ݂̗vfw|C^
	size_type diff_pointer_;		///< @brief vfԂ̃|C^̍

public:
	/// @brief ftHgRXgN^
	mist_iterator1( pointer p = NULL, size_type diff = 1 ) : data_( p ), diff_pointer_( diff ){ }

	/// @brief ̃Ce[^pď
	template< class TT, class DD, class PP, class RR >
	mist_iterator1( const mist_iterator1< TT, DD, PP, RR > &ite ) : data_( ite.data( ) ), diff_pointer_( ite.diff( ) ){ }


	/// @brief ̃Ce[^
	template< class TT, class DD, class PP, class RR >
	const mist_iterator1& operator =( const mist_iterator1< TT, DD, PP, RR > &ite )
	{
		data_ = ite.data( );
		diff_pointer_ = ite.diff( );
		return( *this );
	}


	/// @brief vf̎Q
	reference operator *(){ return( *data_ ); }

	/// @brief vf const Q
	const_reference operator *() const { return( *data_ ); }

	/// @brief vf̃AhXZq
	pointer operator->( ){ return( &**this ); }

	/// @brief vf const AhXZq
	const pointer operator->( ) const { return( &**this ); }

	/// @brief dist Ŏw肵ʒu̗vf̎Q
	reference operator []( difference_type dist ){ return( data_[ dist * diff_pointer_ ] ); }

	/// @brief dist Ŏw肵ʒu̗vf const Q
	const_reference operator []( difference_type dist ) const { return( data_[ dist * diff_pointer_ ] ); }

	///< @brief ݂̗vfw|C^
	pointer data( )
	{
		return( data_ );
	}

	///< @brief ݂̗vfw|C^
	const pointer data( ) const
	{
		return( data_ );
	}

	///< @brief vfԂ̃|C^̍
	size_type diff( ) const
	{
		return( diff_pointer_ );
	}

	/// @brief Ou^̃CNgZq
	mist_iterator1& operator ++( )
	{
		*this += 1;
		return( *this );
	}

	/// @brief u^̃CNgZq
	const mist_iterator1 operator ++( int )
	{
		mist_iterator1 old_val( *this );
		*this += 1;
		return( old_val );
	}

	/// @brief Ou^̃fNgZq
	mist_iterator1& operator --( )
	{
		*this -= 1;
		return( *this );
	}

	/// @brief u^̃fNgZq
	const mist_iterator1 operator --( int )
	{
		mist_iterator1 old_val( *this );
		*this -= 1;
		return( old_val );
	}


	/// @brief dist  + ɗꂽʒu̗vfɈړ
	const mist_iterator1& operator +=( difference_type dist )
	{
		data_ += dist * diff_pointer_;
		return( *this );
	}

	/// @brief dist  - ɗꂽʒu̗vfɈړ
	const mist_iterator1& operator -=( difference_type dist )
	{
		data_ -= dist * diff_pointer_;
		return( *this );
	}


	/// @brief vfԂ̃|C^̍vZ
	template< class TT, class DD, class PP, class RR >
	const difference_type operator -( const mist_iterator1< TT, DD, PP, RR > &ite ) const
	{
		return( ( data_ - ite.data( ) ) / diff_pointer_ );
	}


	/// @brief ̃Ce[^vfĂ邩ǂ
	template< class TT, class DD, class PP, class RR >
	bool operator ==( const mist_iterator1< TT, DD, PP, RR > &ite ) const { return( data_ == ite.data( ) ); }

	/// @brief ̃Ce[^vfĂȂǂ
	template< class TT, class DD, class PP, class RR >
	bool operator !=( const mist_iterator1< TT, DD, PP, RR > &ite ) const { return( !( *this == ite )  ); }

	/// @brief ̃Ce[^ < ̊֌W𒲂ׂ
	template< class TT, class DD, class PP, class RR >
	bool operator < ( const mist_iterator1< TT, DD, PP, RR > &ite ) const { return( data_ <  ite.data( ) ); }

	/// @brief ̃Ce[^ <= ̊֌W𒲂ׂ
	template< class TT, class DD, class PP, class RR >
	bool operator <=( const mist_iterator1< TT, DD, PP, RR > &ite ) const { return( data_ <= ite.data( ) ); }

	/// @brief ̃Ce[^ > ̊֌W𒲂ׂ
	template< class TT, class DD, class PP, class RR >
	bool operator > ( const mist_iterator1< TT, DD, PP, RR > &ite ) const { return( data_ >  ite.data( ) ); }

	/// @brief ̃Ce[^ >= ̊֌W𒲂ׂ
	template< class TT, class DD, class PP, class RR >
	bool operator >=( const mist_iterator1< TT, DD, PP, RR > &ite ) const { return( data_ >= ite.data( ) ); }
};


/// @brief dist  + ɃCe[^i߂Ce[^Ԃ
template< class T, class Distance, class Pointer, class Reference >
inline const mist_iterator1< T, Distance, Pointer, Reference > operator +( const mist_iterator1< T, Distance, Pointer, Reference > &ite, typename mist_iterator1< T, Distance, Pointer, Reference >::difference_type dist )
{
	return( mist_iterator1< T, Distance, Pointer, Reference >( ite ) += dist );
}

/// @brief dist  + ɃCe[^i߂Ce[^Ԃ
template< class T, class Distance, class Pointer, class Reference >
inline const mist_iterator1< T, Distance, Pointer, Reference > operator +( typename mist_iterator1< T, Distance, Pointer, Reference >::difference_type dist, const mist_iterator1< T, Distance, Pointer, Reference > &ite )
{
	return( mist_iterator1< T, Distance, Pointer, Reference >( ite ) += dist );
}

/// @brief dist  - ɃCe[^i߂Ce[^Ԃ
template< class T, class Distance, class Pointer, class Reference >
inline const mist_iterator1< T, Distance, Pointer, Reference > operator -( const mist_iterator1< T, Distance, Pointer, Reference > &ite, typename mist_iterator1< T, Distance, Pointer, Reference >::difference_type dist )
{
	return( mist_iterator1< T, Distance, Pointer, Reference >( ite ) -= dist );
}



/// @brief mistReiŗp2p_ANZXCe[^
//! 
//! array3 p̏_ANZXCe[^
//! 
//! @param T         c ͌^
//! @param Distance  c Ce[^Ԃ̍\^iftHg ptrdiff_tj
//! @param Pointer   c Ce[^̗vfւ̃|C^^iftHg T*j
//! @param Reference c Ce[^̗vfւ̎Qƌ^iftHg T&j
//! 
template< class T, class Distance = ptrdiff_t, class Pointer = T*, class Reference = T& >
#if defined( __MIST_MSVC__ ) && __MIST_MSVC__ <= 6
class mist_iterator2 : public std::iterator< std::random_access_iterator_tag, T, Distance >
#else
class mist_iterator2 : public std::iterator< std::random_access_iterator_tag, T, Distance, Pointer, Reference >
#endif
{
public:
	typedef T value_type;					///< @brief f[^^Dbool Ɠ
	typedef Pointer pointer;				///< @brief f[^^̃|C^[^Ddata ̏ꍇCdata * ƂȂ
	typedef Reference reference;			///< @brief f[^^̎QƁDdata ̏ꍇCdata & ƂȂ
	typedef size_t size_type;				///< @brief Ȃ̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ size_t ^Ɠ
	typedef Distance difference_type;		///< @brief t̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ ptrdiff_t ^Ɠ
	typedef Reference const_reference;		///< @brief f[^^ const QƁDdata ̏ꍇCconst data & ƂȂ

private:
	pointer data_;				///< @brief ݂̃Ce[^[wĂ̈̐擪ʒu
	difference_type index_;		///< @brief ݂̃Ce[^[wĂCfbNX
	difference_type width_;		///< @brief 1s̃f[^
	difference_type step_;		///< @brief CNg̃XLbv

public:
	/// @brief ftHgRXgN^
	mist_iterator2( pointer p = NULL, difference_type index = 0, difference_type width = 1, difference_type step = 1 )
												: data_( p ), index_( index ), width_( width ), step_( step )
	{
	}

	/// @brief ̃Ce[^pď
	template< class TT, class DD, class PP, class RR >
	mist_iterator2( const mist_iterator2< TT, DD, PP, RR > &ite ) : data_( ite.data( ) ), index_( ite.index( ) ), width_( ite.width( ) ), step_( ite.step( ) )
	{
	}


	/// @brief ̃Ce[^
	template< class TT, class DD, class PP, class RR >
	const mist_iterator2& operator =( const mist_iterator2< TT, DD, PP, RR > &ite )
	{
		if( &ite != this )
		{
			data_  = ite.data( );
			index_ = ite.index( );
			width_ = ite.width( );
			step_  = ite.step( );
		}
		return( *this );
	}

	///< @brief ݂̃Ce[^[wĂ̈̐擪ʒu
	pointer data( )
	{
		return( data_ );
	}

	///< @brief ݂̃Ce[^[wĂ̈̐擪ʒu
	const pointer data( ) const
	{
		return( data_ );
	}

	///< @brief ݂̃Ce[^[wĂCfbNX
	difference_type index( ) const
	{
		return( index_ );
	}

	///< @brief 1s̃f[^
	difference_type width( ) const
	{
		return( width_ );
	}

	///< @brief CNg̃XLbv
	difference_type step( ) const
	{
		return( step_ );
	}

	/// @brief vf̎Q
	reference operator *( )
	{
		difference_type step = index_ / width_;
		difference_type rest = index_ - step * width_;
		return( *( data_ + rest + step * step_ ) );
	}

	/// @brief vf const Q
	const_reference operator *( ) const
	{
		difference_type step = index_ / width_;
		difference_type rest = index_ - step * width_;
		return( *( data_ + rest + step * step_ ) );
	}

	/// @brief vf̃AhXZq
	pointer operator->( ){ return( &**this ); }

	/// @brief vf const AhXZq
	const pointer operator->( ) const { return( &**this ); }

	/// @brief dist Ŏw肵ʒu̗vf̎Q
	reference operator []( difference_type dist ){ return( *( *this += dist ) ); }

	/// @brief dist Ŏw肵ʒu̗vf const Q
	const_reference operator []( difference_type dist ) const { return( *( *this += dist ) ); }


	/// @brief Ou^̃CNgZq
	mist_iterator2& operator ++( )
	{
		*this += 1;
		return( *this );
	}

	/// @brief u^̃CNgZq
	const mist_iterator2 operator ++( int )
	{
		mist_iterator2 old_val( *this );
		*this += 1;
		return( old_val );
	}

	/// @brief Ou^̃fNgZq
	mist_iterator2& operator --( )
	{
		*this -= 1;
		return( *this );
	}

	/// @brief u^̃fNgZq
	const mist_iterator2 operator --( int )
	{
		mist_iterator2 old_val( *this );
		*this -= 1;
		return( old_val );
	}

	/// @brief dist  + ɗꂽʒu̗vfɈړ
	const mist_iterator2& operator +=( difference_type dist )
	{
		index_ += dist;
		return( *this );
	}

	/// @brief dist  - ɗꂽʒu̗vfɈړ
	const mist_iterator2& operator -=( difference_type dist )
	{
		index_ -= dist;
		return( *this );
	}


	/// @brief vfԂ̃|C^̍vZ
	template< class TT, class DD, class PP, class RR >
	const difference_type operator -( const mist_iterator2< TT, DD, PP, RR > &ite ) const
	{
		return( index_ - ite.index( ) );
	}

	/// @brief ̃Ce[^vfĂ邩ǂ
	template< class TT, class DD, class PP, class RR >
	bool operator ==( const mist_iterator2< TT, DD, PP, RR > &ite ) const { return( *this - ite == 0 ); }

	/// @brief ̃Ce[^vfĂȂǂ
	template< class TT, class DD, class PP, class RR >
	bool operator !=( const mist_iterator2< TT, DD, PP, RR > &ite ) const { return( !( *this == ite ) ); }

	/// @brief ̃Ce[^ < ̊֌W𒲂ׂ
	template< class TT, class DD, class PP, class RR >
	bool operator < ( const mist_iterator2< TT, DD, PP, RR > &ite ) const { return( *this - ite < 0 ); }

	/// @brief ̃Ce[^ <= ̊֌W𒲂ׂ
	template< class TT, class DD, class PP, class RR >
	bool operator <=( const mist_iterator2< TT, DD, PP, RR > &ite ) const { return( !( *this > ite ) ); }

	/// @brief ̃Ce[^ > ̊֌W𒲂ׂ
	template< class TT, class DD, class PP, class RR >
	bool operator > ( const mist_iterator2< TT, DD, PP, RR > &ite ) const { return( ite < *this ); }

	/// @brief ̃Ce[^ >= ̊֌W𒲂ׂ
	template< class TT, class DD, class PP, class RR >
	bool operator >=( const mist_iterator2< TT, DD, PP, RR > &ite ) const { return( !( *this < ite ) ); }
};



/// @brief dist  + ɃCe[^i߂Ce[^Ԃ
template< class T, class Distance, class Pointer, class Reference >
inline const mist_iterator2< T, Distance, Pointer, Reference > operator +( const mist_iterator2< T, Distance, Pointer, Reference > &ite, typename mist_iterator2< T, Distance, Pointer, Reference >::difference_type dist )
{
	return( mist_iterator2< T, Distance, Pointer, Reference >( ite ) += dist );
}

/// @brief dist  + ɃCe[^i߂Ce[^Ԃ
template< class T, class Distance, class Pointer, class Reference >
inline const mist_iterator2< T, Distance, Pointer, Reference > operator +( typename mist_iterator2< T, Distance, Pointer, Reference >::difference_type dist, const mist_iterator2< T, Distance, Pointer, Reference > &ite )
{
	return( mist_iterator2< T, Distance, Pointer, Reference >( ite ) += dist );
}

/// @brief dist  - ɃCe[^i߂Ce[^Ԃ
template< class T, class Distance, class Pointer, class Reference >
inline const mist_iterator2< T, Distance, Pointer, Reference > operator -( const mist_iterator2< T, Distance, Pointer, Reference > &ite, typename mist_iterator2< T, Distance, Pointer, Reference >::difference_type dist )
{
	return( mist_iterator2< T, Distance, Pointer, Reference >( ite ) -= dist );
}



/// @brief Ce[^t_ANZXCe[^𐶐
//! 
//! SĂMISTReiŗpt_ANZXCe[^
//! 
//! @param _Ite c {ƂȂ鏇_ANZXCe[^
//! 
template< class T >
class mist_reverse_iterator :
#if defined( __MIST_MSVC__ ) && __MIST_MSVC__ <= 6
	public std::iterator<
		typename T::iterator_category,
		typename T::value_type,
		typename T::difference_type
	>
#else
	public std::iterator<
		typename T::iterator_category,
		typename T::value_type,
		typename T::difference_type,
		typename T::pointer,
		typename T::reference
	>
#endif
{
private:
	typedef T iterator_type;

public:
 	typedef typename T::size_type size_type;					///< @brief Ȃ̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ size_t ^Ɠ
 	typedef typename T::difference_type difference_type;		///< @brief t̐\^DRei̗vfCevfw肷ƂȂǂɗpCIɂ ptrdiff_t ^Ɠ
	typedef typename T::value_type value_type;					///< @brief ///< @brief f[^^Dbool Ɠ
	typedef typename T::pointer pointer;						///< @brief f[^^̃|C^[^Ddata ̏ꍇCdata * ƂȂ
	typedef typename T::reference reference;					///< @brief f[^^̎QƁDdata ̏ꍇCdata & ƂȂ
	typedef typename T::const_reference const_reference;		///< @brief f[^^ const QƁDdata ̏ꍇCconst data & ƂȂ

protected:
	iterator_type current_iterator_;		///< @brief _ANZXCe[^

public:
	/// @brief ftHgRXgN^
	mist_reverse_iterator( ){ }

	/// @brief _ANZXCe[^pď
	mist_reverse_iterator( const iterator_type &ite ) : current_iterator_( ite ){ }

	/// @brief t_ANZXCe[^pď
	mist_reverse_iterator( const mist_reverse_iterator &ite ) : current_iterator_( ite.current_iterator_ ){ }


	/// @brief _ANZXCe[^
	const mist_reverse_iterator& operator =( const iterator_type &ite )
	{
		current_iterator_ = ite;
		return( *this );
	}

	/// @brief t_ANZXCe[^
	const mist_reverse_iterator& operator =( const mist_reverse_iterator &ite )
	{
		current_iterator_ = ite.current_iterator_;
		return( *this );
	}


	/// @brief vf̎Q
	reference operator *()
	{
		iterator_type _tmp = current_iterator_;
		return( *( --_tmp ) );
	}

	/// @brief vf const Q
	const_reference operator *() const
	{
		iterator_type _tmp = current_iterator_;
		return( *( --_tmp ) );
	}

	/// @brief vf̃AhXZq
	pointer operator->( ){ return( &**this ); }

	/// @brief vf const AhXZq
	const pointer operator->( ) const { return( &**this ); }

	/// @brief dist Ŏw肵ʒu̗vf̎Q
	reference operator []( difference_type dist ){ return( *( *this + dist ) ); }

	/// @brief dist Ŏw肵ʒu̗vf const Q
	const_reference operator []( difference_type dist ) const { return( *( *this + dist ) ); }


	/// @brief Ou^̃CNgZq
	mist_reverse_iterator& operator ++( )
	{
		--current_iterator_;
		return( *this );
	}

	/// @brief u^̃CNgZq
	const mist_reverse_iterator operator ++( int )
	{
		mist_reverse_iterator old_val( *this );
		current_iterator_--;
		return( old_val );
	}

	/// @brief Ou^̃fNgZq
	mist_reverse_iterator& operator --( )
	{
		++current_iterator_;
		return( *this );
	}

	/// @brief u^̃fNgZq
	const mist_reverse_iterator operator --( int )
	{
		mist_reverse_iterator old_val( *this );
		current_iterator_++;
		return( old_val );
	}

	/// @brief dist  + ɗꂽʒu̗vfɈړ
	const mist_reverse_iterator& operator +=( difference_type dist )
	{
		current_iterator_ -= dist;
		return( *this );
	}

	/// @brief dist  - ɗꂽʒu̗vfɈړ
	const mist_reverse_iterator& operator -=( difference_type dist )
	{
		current_iterator_ += dist;
		return( *this );
	}

	/// @brief vfԂ̃|C^̍vZ
	const difference_type operator -( const mist_reverse_iterator &ite ) const
	{
		return( ite.current_iterator_ - current_iterator_ );
	}



	/// @brief ̃Ce[^vfĂ邩ǂ
	bool operator ==( const mist_reverse_iterator &ite ) const { return( current_iterator_ == ite.current_iterator_ ); }

	/// @brief ̃Ce[^vfĂȂǂ
	bool operator !=( const mist_reverse_iterator &ite ) const { return( !( *this == ite ) ); }

	/// @brief ̃Ce[^ < ̊֌W𒲂ׂ
	bool operator < ( const mist_reverse_iterator &ite ) const { return( ite.current_iterator_ < current_iterator_  ); }

	/// @brief ̃Ce[^ <= ̊֌W𒲂ׂ
	bool operator <=( const mist_reverse_iterator &ite ) const { return( !( *this > ite ) ); }

	/// @brief ̃Ce[^ > ̊֌W𒲂ׂ
	bool operator > ( const mist_reverse_iterator &ite ) const { return( ite < *this ); }

	/// @brief ̃Ce[^ >= ̊֌W𒲂ׂ
	bool operator >=( const mist_reverse_iterator &ite ) const { return( !( *this < ite ) ); }
};


/// @brief dist  + ɃCe[^i߂Ce[^Ԃ
template< class T >
inline const mist_reverse_iterator< T > operator +( const mist_reverse_iterator< T > &ite1, const mist_reverse_iterator< T > ite2 )
{
	return( mist_reverse_iterator< T >( ite1 ) += ite2 );
}

/// @brief dist  + ɃCe[^i߂Ce[^Ԃ
template< class T >
inline const mist_reverse_iterator< T > operator +( const mist_reverse_iterator< T > &ite, typename T::difference_type dist )
{
	return( mist_reverse_iterator< T >( ite ) += dist );
}

/// @brief dist  - ɃCe[^i߂Ce[^Ԃ
template< class T >
inline const mist_reverse_iterator< T > operator +( typename T::difference_type dist, const mist_reverse_iterator< T > &ite )
{
	return( mist_reverse_iterator< T >( ite ) += dist );
}


//template< class T >
//inline const typename mist_reverse_iterator< T >::difference_type operator -( const mist_reverse_iterator< T > &ite1, const mist_reverse_iterator< T > ite2 )
//{
//	return( ite1 - ite2 );
//}


/// @brief dist  - ɃCe[^i߂Ce[^Ԃ
template< class T >
inline const mist_reverse_iterator< T > operator -( const mist_reverse_iterator< T > &ite, typename T::difference_type dist )
{
	return( mist_reverse_iterator< T >( ite ) -= dist );
}

// mistOԂ̏I
_MIST_END


#endif // __INCLUDE_MIST_ITERATOR_H__
