//
define option 17 1;
define double e_d;
/*================================================================*/
/*       main function                                            */
/*================================================================*/
proc main;
	dim final_x, h, ee as double;
	/*--- set initial condition and cal range ---*/
echo 'time=' t1=gettime(0);
	xx=0.0;
	yy=0.0;
	ee=0.0001;
	ee2=ee/32.0;
	e_d=0.0;

	final_x=20.0;

	h=(final_x - xx)*0.1;
	h2=h/2.0;

	putline(xx,', ',yy,', ',e_d,', ',h);
	while (xx <= final_x) do
		loop 4 do;
			y = rkm(h,func1,xx,yy);
			if (e_d < ee) then
				yy = y;
				xx += h;
				if (e_d < ee2) then
					h += h;
				end if;
				break;
			else
				h *= 0.5;
			end if;
		end do;
		putline(xx,', ',yy,', ',e_d,', ',h);
	end do;
echo 'time=' t2=gettime(0) t2-t1;
	return 0;
end proc;

/*================================================================*/
/*       define function                                          */
/*================================================================*/
function func1(x, y);
	double dydx;

	dydx=sin(x)*cos(x)-y*cos(x);
//echo x y dydx;
	return dydx;
end func;

function rkm(h, f, xi, yi);
	h2=h*0.5;
	h3=h/3.0;
	k0=h*f(xi,yi)/3.0;
	k05=k0*0.5;
	k1=h*f(xi+h3,yi+k0)/3.0;
	k2=h*f(xi+h3,yi+k05+k1*0.5)/3.0;
	k3=h*f(xi+h2,yi+0.375*k0+1.125*k2)/3.0;
	k4=h*f(xi+h,yi+k0+k05-4.5*k2+6.0*k3)/3.0;
	yi=yi+k05+k3+k3+k4*0.5;
	e_d=abs(k0*0.2-0.9*k2+0.8*k3-0.1*k4);
	return yi;
end func;
