static char sccsid[]="%Z% %M% %I% %E% %U%";
/********************************************************************/
/*																	*/
/*		coal  :  COmmon platform Application Language				*/
/*																	*/
/*				By Akito Kobayashi 2010.05.28						*/
/*																	*/
/********************************************************************/

#include "colmn.h"
#define COLMNMAIN	"COAL"
#define DBMNMAIN	"DbMnMain"
#define MSG_TIME_OUT	600	/* sec */
#define INSDSIZE	sizeof(CLPRTBL *)+sizeof(GlobalCt *)+sizeof(AKAMSGCOM)

#define	False	0
#define	True	1

#define	COPYRIGHT	"Coal Project 2010-2022"

extern char version[];
extern char make_date[];

extern int giProgram[];	/* [0] =0:coal, =1:ColMnMain */
						/* [1] = iCmd */
extern int giOptions[];
extern char cmp_sep2[];

extern int iGlSd;
extern int giHOST_ID_SIZE;

extern CLCOMMON CLcommon;
extern CLPRTBL  CLprocTable;
extern GlobalCt GlobTable,*pGlobTable;
extern XHASHB   *xhp_main_def;

extern int col_mn_analz();
extern int cl_shut_class();
extern int coal_start_class();
extern int coal_command_class();
static int _start();

static int  giLF;
static char *cpProcName;
static char memctl[32];

static int  iProcId, iCmd, no_extension, level, iUsage, iExit, arg_type;
static char *service, *cpInitScript, *extension, *reply;
static int  debug_opt[4],max_thread,no_free_exec,no_free_level,set_ini[10];
static MCAT ini_mcat={'M','C',256,0,0,0,NULL,0};

static int _to_num(p,pival)
char *p;
int  *pival;
{
	int ret;

	if (ret=akxcgcvn(p,strlen(p),pival)) {
		iUsage = 2;
		fprintf(stderr,"\n_to_num: invalid number ret=%d\n",ret);
	}
	return ret;
}

static int _cpi2c(d,s,n)
char *d;
int  *s,n;
{
	while (n-- > 0) *d++ = *s++;
	return n;
}

static char *_getverdate(buf,buflen)
char *buf;
int  buflen;
{
	char *pVD[2],*p;
	int  iVDL[2],len;

	aka_get_ver_date(pVD,iVDL);
	buflen -= 2;
	len = memnzcpy(p=buf,pVD[0],iVDL[0],buflen);
	p += len++;
	memcpy(p++," ",2);
	buflen -= len;
	memnzcpy(p,pVD[1],iVDL[1],buflen);
	return buf;
}

static void _print_log_parm(c)
char c;
{
	static int logno_ary[3]={D_LOG_NO_ERROR,D_LOG_NO_PRINT,D_LOG_NO_DEBUG};
	int  n,i,iXLIB;
	long iParm[10];
	char *fn,parm[256],cc;

	if (akxqupper(c)) iXLIB = 1;
	else iXLIB = 0;

	cc = akxcupper(c);
	if (cc=='E')      n = D_LOG_NO_ERROR;
	else if (cc=='P') n = D_LOG_NO_PRINT;
	else if (cc=='D') n = D_LOG_NO_DEBUG;
	else n = -1;

	fn = "No     flg grplevel sz_max fl_max option filename  no check grppriority";
	ERRDBGOUTL5(0,fn,0,0,0,0,0);
	for (i=0;i<3;i++) {
		if (n<0 || i==n) {
			iParm[0] = i;
			if (iXLIB)
				akx_log_set_parm2(1,NULL,10,iParm);
			else
				akb_log_set_parm2(1,NULL,10,iParm);
			if (!(fn=(char *)iParm[6])) fn = AKX_NULL_PRINT;
			sprintf(parm,"%2d %07x %08x %6d %6d %06x",
			        i,iParm[1],iParm[2],iParm[3],iParm[4],iParm[5]);
			ERRDBGOUTL5(0,"%s %-9s %2d %5d %08x",parm,fn,iParm[7],iParm[8],iParm[9]);
		}
	}
	fprintf(stderr,"\n");
}

static void _usage(pn)
char *pn;
{
	static char *h[]=
	{"usage: %s [-h|-?|-v|-c] [--{e|p|d|l|E|P|D|L}[LOG_PARM]] [-d[ ]DEBUG_OPTIONS]\n"
	,"            [-s] [-CMD_NO] [-S[ ]proc_no] [-P[ ]port_no] [-i[ ]init_script]"
	,"            [-X|-x[ ]extension] [-o[ ]EXEC_OPTION] [-t[ ]max_thread]"
	,"            [-m[level][,[J|E|Other]]] [-r[out_file]] [-D[ ]define]"
	,"            script_name [parm-1 parm-2 ...]"
	,"  where\n    CMD_NO := 0x02:detach, 0x04:listen, 0x08:new channel"
	""
	,NULL
	};
	static char *h_c[]=
	{"    LOG_PARM := FLAG,LEVEL,SIZE_MAX,FILE_MAX,OPTION,FILE,PRIORITY"
	""
	,NULL
	};
	char **ph,*p;

	if (!giLF) fprintf(stderr,"\n");
	ph = h;
	fprintf(stderr,*ph++,pn);
	while (p = *ph++) fprintf(stderr,"%s\n",p);
	ph = h_c;
	while (p = *ph++) fprintf(stderr,"%s\n",p);
	giLF = 1;
}

static void _set_global_opt(set_flg,ex_options)
int set_flg[],ex_options[];
{
	int i,*option,*gOpt,*flg,iADD_DEL,*ex_opt,opt;

	option = pGlobTable->options;
	gOpt = giOptions;
	ex_opt = ex_options;
	flg = set_flg;
	for (i=1;i<=MAX_OPTIONS;i++) {
		if (iADD_DEL=*flg) {
		/*	*option = *gOpt;	*/
			opt = cl_opt_add_del(*option,iADD_DEL,*ex_opt);
/*
printf("_set_global_opt: i=%d iADD_DEL=%d opt=%08x\n",i,iADD_DEL,opt);
*/
			*gOpt = *option = opt;
			cl_mod_option(i,1);
		}
		option++;
		gOpt++;
		ex_opt++;
		flg++;
	}
}

static void _set_dbgopt_argv(argv,n,debug_opt,max,msg,set_flg)
char *argv[],*msg;
int  debug_opt[];
int  n,max;
int  set_flg[];
{
	char *p,*pp,*pNS,c;
	int i,v,len,pos,v1,ii,nn,m,iADD_DEL;

	mem_set_int(set_flg,0,max);
	pNS = NULL;
	akxcecvn(&pNS,NULL,0,NULL);	/* new */
	for (i=0;i<n;i++) {
		if (set_flg) set_flg[i] = 0;
		len = strlen(p=argv[i]);
		if (len>0 && akxnskipin(p,len,". \t")<len) {
			pos = instrchar(p,'.');
			m   = instrchar(p,'=');
			if (pos>0 && m>0 && m>pos) ;
			else if (pos>0 && !m) {
				iADD_DEL = 1;
				if ((c=*p)=='+' || c=='-') {
					p++;
					len--;
					if (c == '+') iADD_DEL = 2;
					else iADD_DEL = -1;
				}
				akxccvdotn(p,len,&v);
				debug_opt[i] = v;
				PRINTOUT3("set %s[%2d] = 0x%08x",msg,i,v);
				if (set_flg) set_flg[i] = iADD_DEL;
			}
			else if ((pos=akxcgcvn(p,len,&v)) >= 0) {
				ii = i;
				if (pos > 0) {
					p += pos-1;
					if (*p == '=') {
						p++;
						iADD_DEL = 1;
						if ((c=*p)=='+' || c=='-') {
							p++;
							len--;
							if (c == '+') iADD_DEL = 2;
							else iADD_DEL = -1;
						}
						ii = -1;
						if (v>=1 && v<=max) {
							if (instrchar(p,'.') > 0) {
								if (akxccvdotn(p,len-pos,&v1) >= 0) {
									ii = v - 1;
									v = v1;
								}
							}
#if 1	/* 2021.4.10 */
							else if (akxcecvn(&pNS,p,len-pos,&v1) >= 0) {
#else
							else if (akxcgcvn(p,len-pos,&v1) >= 0) {
#endif
								ii = v - 1;
								v = v1;
							}
						}
					}
				}
				if (ii >= 0) {
					debug_opt[ii] = v;
					PRINTOUT3("set %s[%2d] = 0x%08x",msg,ii,v);
					if (set_flg) set_flg[ii] = iADD_DEL;
				}
			}
		}
	}
}

static void _set_dbgopt(buf,debug_opt,max,msg,set_flg)
char *buf,*msg;
int  debug_opt[];
int  max,set_flg[];
{
	char *argv[30],parm[256],*p;
	int n;

	n = akxtgetargv2(buf,argv,max,parm,sizeof(parm),4);	/* , */

	_set_dbgopt_argv(argv,n,debug_opt,max,msg,set_flg);
}

static int _set_log_parm(p)
char *p;
{
	int ret;
	char c;

	if (akxqupper(c=*p))
		ret = akx_log_set_command_parm(c,p+1);
	else
		ret = akb_log_set_command_parm(c,p+1);

	if (ret < 0) {
		if (ret == -1) {
			ERROROUT("internal error!!");
			exit(2);
		}
		return 2;
	}
	_print_log_parm(c);
	return 0;
}

static void _get_vc(p,copy_right)
char *p,*copy_right;
{
	int  i;
	char c;

	i = 0;
	c = *p;
	if (c == 'v') i |= 1;
	if (c == 'c') i |= 2;
	if (*(p+1) == 'v') i |= 1;
	if (*(p+1) == 'c') i |= 2;
	if (!giLF) fprintf(stderr,"\n");
	if (i & 1) fprintf(stderr," %s\n",_getverdate(LOGBUF(0),LOGBUFLEN(0)));
	if (i & 2) fprintf(stderr," (c) Copyright %s\n",copy_right);
	fprintf(stderr,"\n");
	giLF = 1;
}

static void _log_set_up(level,cpProcName)
int level;
char *cpProcName;
{
	LOGLEVEL(D_LOG_NO_ERROR,level);
	LOGLEVEL(D_LOG_NO_PRINT,level);
	LOGLEVEL(D_LOG_NO_DEBUG,level);
	LOGFLG(D_LOG_NO_PRINT,D_LOG_FLG_STDOUT);
	akb_log_set_up_name(cpProcName);
	LOGBUF(256);
}

static void _log_clear_no(no)
int no;
{
	int iParm[10];

	if (akb_log_flg(no,D_LOG_FLG_CHECK) & D_LOG_FLG_LOG_CLEAR) {
		akb_log_out_level_main(no,0x1ff,"",0,"",0,0,0,0,0);
		akb_log_clear(no,0);
		iParm[0] = no;
		akb_log_set_parm2(1,NULL,10,iParm);
		PRINTOUT2("log no=%d file=[%s]  cleared.",no,iParm[6]);
	}
}

static void _log_clear()
{
	_log_clear_no(D_LOG_NO_ERROR);
	_log_clear_no(D_LOG_NO_PRINT);
	_log_clear_no(D_LOG_NO_DEBUG);
}

static void _stat_memory()
{
	long parm[12];

	akxm_stat_memory(12,parm);
	if (parm[8]) {
		PRINTOUT4("Memory: ctl=[%s], AFHASH=%d, AFDUMP=%d, NFDUMP=%d",
		          parm[4],parm[11],parm[9],parm[10]);
		PRINTOUT3("        maxreg=%d, af=[%s], nf=[%s]",
		          parm[5],parm[6],parm[7]);
	}
}

static void _set_msg_level(buf)
char *buf;
{
	char *argv[2],parm[16],*p,c;
	int n,i,t,len,level,rc;

	n = akxtgetargv2(buf,argv,2,parm,sizeof(parm),4);	/* , */
	if (n <= 0) {
		level = 1;
		LOGLEVEL(D_LOG_NO_PRINT,level);
		LOGLEVEL(D_LOG_NO_DEBUG,level);
	}
	for (i=0;i<n;i++) {
		len = strlen(p=argv[i]);
		if (len > 0) {
			rc = akxcgcvn(p,len,&t);
			if (i==0 && !rc) {
				level = t;
				LOGLEVEL(D_LOG_NO_PRINT,level);
				LOGLEVEL(D_LOG_NO_DEBUG,level);
			}
			else if (i==1) {
				if (!rc) {
					if (t<0 || t>2) t = 0;
				}
				else {
					if ((c=toupper(*p)) == 'J') t = 0;
					else if (c == 'E') t = 1;
					else t = 2;
				}
				giOptions[13] = t;
			}
		}
	}
}

static int _set_define(parm)
char *parm;
{
	int i,parmlen,keylen;
	char c,c1,*p,*val;
	SSP_S ssp;

DEBUGOUTL1(1,"_set_define: parm=[%s]",parm);

	if (!xhp_main_def) {
		xhp_main_def = akxs_xhash_new2(0,10,7,0);
	}
	parmlen = strlen(parm);
	ssp.sp = 0;
	keylen = akxtgwns(parm,parmlen,&ssp,cmp_sep2,0x21);
	if (keylen<=0 || ssp.attr[0]!=1) return -1;
	p = ssp.wd;
	if (ssp.sp < parmlen) {
		if ((c=parm[ssp.sp])=='(') {
			p = strmem(p,keylen);
			val = parm + ssp.sp;
			i = akxs_in_mem_opt(val,parmlen-ssp.sp,"=",1,0);
			if (i > 0) {
				if (--i <= 0) return -1;
				val[i] = ' ';
			}
		}
		else if (c == '=') {
			parm[ssp.sp] = '\0';
			val = parm + ssp.sp + 1;
		}
		else return -1;
	}
	else val = "";
	val = stradd(val," ");

PRDBGOUTL2(1,"_set_define: key=[%s] val=[%s]",p,val);
	return akxs_xhash2(xhp_main_def,'S',p,val);
}

static int _set_opt(pargc,pargv,key)
int  *pargc;
char **pargv[],*key;
{
	int  argc,i,set_flg[MAX_OPTIONS],ex_options[MAX_OPTIONS];
	char **argv,*p,c;

	argc = *pargc;
	argv = *pargv;
	while (argc > 0) {
		p = argv[0];
		if ((c=*p) == '-') {
			p++;
			if ((c=*p) == '-') {
				p++;
				iUsage = _set_log_parm(p);
			}
			else if (c == 'm') {
				_set_msg_level(p+1);
			}
			else if (c == 's') {
				level = 0;
				LOGLEVEL(D_LOG_NO_PRINT,level);
				LOGLEVEL(D_LOG_NO_DEBUG,level);
			}
			else if (!giProgram[0] && c>='0' && c<='9') {
				if (_to_num(p,&iCmd)) break;
				if (iCmd < 0) iCmd = -iCmd;
				if (iCmd & (0x02 | 0x08)) iCmd |= 0x04;
				giProgram[1] = iCmd;
				iCmd = -iCmd;
				iExit = 0;
			}
			else if (c == 'X') {
				no_extension = 1;
			}
			else if (strchr(key,c)) {
				if (*(p+1)) p++;
				else if (--argc > 0) {
					argv++;
					p = argv[0];
					if (*p=='-' || argc==1) {
						iUsage = 2;
						break;
					}
				}
				else {
					iUsage = 2;
					break;
				}
				if (c == 'P') service = p;
				else if (c == 'S') {
					if (_to_num(p,&i)) break;
					if (i >= 0 && i <= AKB_PID_MAX) iProcId = i;
				}
				else if (c == 'd') {
					_set_dbgopt(p,debug_opt,sizeof(debug_opt)/sizeof(int),"debug_opt",NULL);
				}
				else if (c == 'o') {
#if 1	/* 2022.6.29 */
					_set_dbgopt(p,ex_options,MAX_OPTIONS,"ex_options",set_flg);
					_set_global_opt(set_flg,ex_options);
#else
					_set_dbgopt(p,giOptions,MAX_OPTIONS,"giOptions",set_flg);
					_set_global_opt(set_flg);
#endif
				/*
					if (giOptions[0]) cl_mod_option(1,1);
					if (giOptions[8]) cl_mod_option(9,1);
					if (giOptions[2]) cl_mod_option(3,1);
					if (giOptions[20]) cl_mod_option(21,1);
				*/
				}
				else if (c == 'x') {
					if (*p == '.') extension = NULL;
					else extension = p;
				}
				else if (c == 'i') {
					cpInitScript = p;
				}
				else if (c == 't') {
					if (_to_num(p,&max_thread)) break;
					if (max_thread<=0 || max_thread>252) max_thread = 1;
				}
				else if (c == 'D') {
					if (_set_define(p) < 0) {
						iUsage = 2;
						break;
					}
				}
			}
			else if (c == 'v' || c == 'c') {
				_get_vc(p,COPYRIGHT);
			}
			else if (c == 'r') {
				reply = p + 1;
			}
			else {
				iUsage = 2;
				break;
			}
		}
		else {
			iExit = 0;
			break;
		}
		argc--;
		argv++;
	}
	*pargc = argc;
	*pargv = argv;
	return 0;
}

void _set_log_flg_cd_opt(log_no,kind)
int log_no,kind;
{
	int flag,opt;

	if (log_no >= 0) {
		opt = (cl_get_option(21,0) & D_CODE_OUTPUT_MASK);
		opt <<= 16;
		if (cl_get_option(9,0) & 0x08) opt |= D_LOG_FLG_USE_CODE_CONV;
		if (!kind) kind = 0x03;
		if (kind & 0x01) {
			flag = XLOGFLG(log_no,-1) & ~D_LOG_FLG_CD_OPT;
			XLOGFLG(log_no,flag | opt);
		}
		if (kind & 0x02) {
			flag = LOGFLG(log_no,-1) & ~D_LOG_FLG_CD_OPT;
			LOGFLG(log_no,flag | opt);
/*
printf("_set_log_flg_cd_opt: log_no=%d log_flag=%08x\n",log_no,LOGFLG(log_no,-1));
*/
		}
	}
	else {
		_set_log_flg_cd_opt(X_LOG_NO_ERROR,kind);
		_set_log_flg_cd_opt(X_LOG_NO_PRINT,kind);
		_set_log_flg_cd_opt(X_LOG_NO_DEBUG,kind);
	}
}

int main(argc,argv)
int  argc;
char *argv[];
{
	int	ret,flg;

	arg_type = CD_TYPE_SJIS;
#ifdef CYGWIN_U8	/* 2020.5.5 */
	akxt_set_code_type(CD_TYPE_UTF8);
#endif
	if ((ret = akxt_get_lang_type("LANG",0,NULL,0)) >= 0) {
		arg_type = ret;
#ifndef CYGWIN_U8	/* 2021.4.21 */
		akxt_set_code_type((uchar)ret);
#endif
	}
/*
printf("main: arg_type=%d\n",arg_type);
*/
	cpProcName = akxt_get_last_name("\\/",argv[0]);
	strnzcpy(memctl,cpProcName,sizeof(memctl)-5);
	strcat(memctl,".ctl");
	reply = NULL;
	giProgram[0] = 0;
	coal_main(argc, argv);
	akb_gs_akb_stplix(0,0,0,0,0,AKX_GSSTPLX_CACHE_INVALID);
	if ((ret=Nofree(0)) >= 0) {
		PRDBGOUTL1(1,"**** end nofree no=%d ****",ret);
	}
	akb_log_free();
	exit(0);
}

int coal_main(argc, argv)
int  argc;
char *argv[];
{
	long parm[12];
	int  ret,i;
	char *p,c;

	Meminit(memctl);
	aka_set_ver_date(version,make_date);
	level = 0;
	_log_set_up(level,cpProcName);
	LOGLEVEL(D_LOG_NO_ERROR,1);

	memset(debug_opt,0,sizeof(debug_opt));
	cpInitScript = NULL;
	giProgram[1] = iCmd = 0;
	iProcId = D_PRID_COL;
	service = NULL;
	extension = SCR_EXTENSION;
	if (p = getenv(DEF_SCREXTENSION)) {
		if (*p == '.') extension = NULL;
		else extension = p;
	}
	iExit = 1;
	giLF = no_extension = 0;
	max_thread = 1;
	giOptions[13] = -1;
	no_free_exec = no_free_level = 1;
#if 1	/* 2021.3.3 */
	/* vZX̏ */
	if (col_mn_init()) {
		ERROROUT(FORMAT(1));	/* vZX̏s */
		exit(1);
	}
	if (cl_getenvf()) exit(2);
#endif
	argc--;
	argv++;
	if (argc <= 0) iUsage = 1;
	else iUsage = 0;

	_set_opt(&argc,&argv,"PSdxoitD");
	if (iExit || (!(iCmd & 0x0e) && argc<=0)) {
		if (iUsage) _usage(cpProcName);
		exit(1);
	}
	_log_clear();
	_stat_memory();

#if 0	/* 2021.3.3 */
	/* vZX̏ */
	if (col_mn_init()) {
		ERROROUT(FORMAT(1));	/* vZX̏s */
		exit(1);
	}
#endif

#if 0	/* 2021.3.3 */
	memcpy(pGlobTable->options,giOptions,sizeof(int)*MAX_OPTIONS);
	cl_mod_option(9,0);
#endif
	_set_log_flg_cd_opt(-1,0);
#if 0	/* 2021.3.3 */
	if (cl_getenvf()) exit(2);
	memcpy(pGlobTable->options,giOptions,sizeof(int)*MAX_OPTIONS);
	cl_mod_option(9,0);
#endif
	cl_getenvf_print();
	if (cl_get_host_id()) exit( 3 );

	CLcommon.Quot[3] = arg_type;
	CLcommon.ScrPathp   = getenv(DEF_SCRPATH);
	CLcommon.CmdScriptp = getenv(DEF_CMDSCRIPT);
	if (!(CLcommon.pHomeDir = getenv(DEF_HOME))) CLcommon.pHomeDir = "";
	CLcommon.cDataCode = akxt_get_code_type();
	if (htons(1) == 1) CLcommon.ucByteOrder = 0;
	else               CLcommon.ucByteOrder = 1;
	_cpi2c(CLcommon.dbgopt,debug_opt,
	       X_MIN(sizeof(CLcommon.dbgopt)/sizeof(char),sizeof(debug_opt)/sizeof(int)));

	strnzcpy(pGlobTable->Hid,CLcommon.dcHostId,sizeof(pGlobTable->Hid)-1);
	CLcommon.ProcessId = iProcId;
	CLcommon.pExtension = extension;
	if (no_extension) CLcommon.pExtension = NULL;
	ret = aka_initialize();
	if (ret) ERROROUT1("aka_initialize ret=%d",ret);
	else {
		aka_set_nofree(no_free_exec,no_free_level);
		if (ret = aka_register_class(col_mn_analz,D_CLASS_COL,INSDSIZE,max_thread,
					AKA_RCO_NODISPLAY,"execute script",cpInitScript))
			ERROROUT1("aka_register_class(col_mn_analz) ret=%d",ret);
		else {
			PRINTOUT("**** Start ****");
			_start(argc,argv);
			/* Iv܂Ń[v */
			while ((ret = aka_get_msg(-1))>=0) {
				if (ret = aka_dispatch_msg()) break;
			}
			PRINTOUT1("aka_get_msg/dispatch ret=%d",ret);
		}
	}
	aka_terminate();

	/* I */
	ret = col_mn_term();
	return 0;
}

int cl_getenvf()
{
	char buf[D_RECORD_BUFSIZE],*argv[MAX_OPTIONS+1],c,wrk[D_RECORD_BUFSIZE],*p;
	int n,t,rc,iRc,i,buf_len,set_flg[MAX_OPTIONS],ex_options[MAX_OPTIONS];

	iRc = akb_gs_akb_stpl(cpProcName,"OPTIONS",argv,MAX_OPTIONS+1);
/*
printf("cl_getenvf: iRc=%d cpProcName=[%s]\n",iRc,cpProcName);
*/
	if (iRc > 1) {
		buf[0] = '\0';
		buf_len = sizeof(buf);
		p = buf;
		rc = iRc - 1;
		_set_dbgopt_argv(&argv[1],rc,ex_options,MAX_OPTIONS,"ex_options",set_flg);
		_set_global_opt(set_flg,ex_options);
	/*
		memcpy(pGlobTable->options,giOptions,sizeof(int)*MAX_OPTIONS);
		if (giOptions[0]) cl_mod_option(1,1);
		if (giOptions[8]) cl_mod_option(9,1);
		if (giOptions[2]) cl_mod_option(3,1);
		if (giOptions[20]) cl_mod_option(21,1);
	*/
		for (i=0;i<MAX_OPTIONS;i++) {
			sprintf(wrk," %x",giOptions[i]);
			n = strlen(wrk);
			memnzcpy(p,wrk,n,buf_len);
			buf_len -= n;
			p += n;
		}
		akxtmcats(&ini_mcat,"cl_getenvf: options=");
		akxtmcats(&ini_mcat,buf);
		akxtmcats(&ini_mcat,"\n");
	/*	PRINTOUT1("cl_getenvf: options=%s",buf);	*/
	}

	t = LRU_SCR_MAX;
	n = akb_gs_akb_name(cpProcName,"LRU_SCR_MAX",buf);
	if (n > 0) {
		if ((n=atoi(buf)) > 0) {
			if ((t=n) < LRU_SCR_MIN) t = LRU_SCR_MIN;
		}
	}
	sprintf(buf,"cl_getenvf: lru_scr_max=%d\n",t);
	akxtmcats(&ini_mcat,buf);
/*	PRINTOUT1("cl_getenvf: lru_scr_max=%d",t);	*/
	rc = cl_lru_scr_init(t);
	if (rc) return rc;

	if (giOptions[13] < 0) {
		t = 0;
		n = akb_gs_akb_name(cpProcName,"MSGLANG",buf);
		if (n > 0) {
			if ((c=toupper(*buf)) == 'J') t = 0;
			else if (c == 'E') t = 1;
			else t = 2;
		}
		pGlobTable->options[13] = giOptions[13] = t;
	}

	/* DB_SERVER  DbProcId  DbSQLClass  [DbServer] */
	CLcommon.usDbProcId  = D_PRID_DB;
	CLcommon.usDbClassId = D_CLASS_DB;
	CLcommon.iDbProcNum  = 1;

if (giProgram[0]) {
	iRc = akb_gs_akb_stpl(cpProcName,"DB_SERVER",argv,4);
	if (iRc >= 3) {
DEBUGOUTL3(10,"cl_getenvf: db server proc=[%s],class=[%s],host=[%s]",
argv[1],argv[2],argv[3]);
		if ((CLcommon.usDbProcId=atoi(argv[1])) <= 0) {
			ERROROUT1("init:Invalid DbProcId=[%s]",argv[1]);
			return -2;
		}
		if ((CLcommon.usDbClassId=atoi(argv[2])) <= 0) {
			ERROROUT1("cl_getenvf: Invalid DbClass=[%s]",argv[2]);
			return -3;
		}
	}
	else {
		ERROROUT("cl_getenvf: undefined DB_SERVER entry. use default.");
	}

	n = akb_gs_akb_name(cpProcName,"MULTI_DB",buf);
	if (n > 0) {
		if ((n=atoi(buf)) > 1) CLcommon.iDbProcNum = n;
	}
	sprintf(buf,"cl_getenvf: DbProcId=%d DbProcNum=%d\n",
	          CLcommon.usDbProcId,CLcommon.iDbProcNum);
	akxtmcats(&ini_mcat,buf);
/*	PRINTOUT2("cl_getenvf: DbProcId=%d DbProcNum=%d",
	          CLcommon.usDbProcId,CLcommon.iDbProcNum);	*/
}
	n = akb_gs_akb_name(cpProcName,"UTF8_CONV",buf);
	if (n > 0) {
		rc = akxc_set_utf8_file(buf);
		sprintf(wrk,"cl_getenvf: UTF8_CONV=[%s] rc=%d\n",buf,rc);
		akxtmcats(&ini_mcat,wrk);
	/*	PRINTOUT2("cl_getenvf: UTF8_CONV=[%s] rc=%d",buf,rc);	*/
	}

	iRc = akb_gs_akb_stpl(cpProcName,"NOFREE",argv,3);	/* "NOFREE"argv[0]ɓ */
	if (iRc >= 2) {
		if (iRc >= 3) {
			p = argv[2];
			if (akxcgcvn(p,strlen(p),&n) >= 0) no_free_level = n;
		}
		no_free_exec = atoi(argv[1]);
		sprintf(buf,"cl_getenvf: no_free_exec=%d no_free_level=%d\n",no_free_exec,no_free_level);
		akxtmcats(&ini_mcat,buf);
	/*	PRINTOUT2("cl_getenvf: no_free_exec=%d no_free_level=%d",no_free_exec,no_free_level);	*/
	}
	return 0;
}

int cl_getenvf_print()
{
	char *p,*pp;

	if (ini_mcat.mc_ipos > 0) {
		p = ini_mcat.mc_bufp;
		while (*p) {
			pp = strchr(p,'\n');
			if (pp) *pp = '\0';
			PRINTOUT1("%s",p);
			if (pp) p = pp + 1;
			else break;
		}
		ini_mcat.mc_ipos = 0;
	}
	return 0;
}

/***************************************/
/*  zXghcAhoAhX̎肾 */
/***************************************/
int cl_get_host_id ()
{
	int  irc;
	char *argv[3],*pHostId1;
	char *pHostId2;

	/* zXghc̎o */
	if ((irc=akb_gs_akb_stpl(cpProcName,"HOST_ID_SIZE",argv,1)) < 2) {
		giHOST_ID_SIZE = HOST_ID_SIZE;
	}
	else {
		if ((giHOST_ID_SIZE=atoi(argv[1])) <= 0) {
			ERROROUT(FORMAT(3));	/* zXghcsłB */
			return -1;
		}
	}
	PRINTOUT1(FORMAT(10),giHOST_ID_SIZE);

	/* zXghcAcazXghc̎o */
	if ((irc=akb_gs_akb_stpl(cpProcName,"MYDCHOST",argv,3)) < 2) {
		CLcommon.dcHostId = "";
		CLcommon.dbHostId = "";
		return 0;
	}
	else {
		pHostId1 = argv[1];
		if ( irc == 3 )
			pHostId2 = argv[2];
		else	/* zXghĉݎo */
			pHostId2 = pHostId1;

		CLcommon.dcHostId = Strdup(pHostId1);
		CLcommon.dbHostId = Strdup(pHostId2);
		PRINTOUT2(FORMAT(5),pHostId1,pHostId2);	/* zXgID:%s  DBzXgID:%s */
	}
	return NORMAL;
}

int coal_make_pkt_form(argc, argv, data, buflen)
int  argc;
char **argv;
long data[];
int  buflen;
{
	tdtInfoParm  InfoParm;
	TrmToSrv   *tpTrmToSrv ;
	int i, len, lw, ret,dtype,opt_in;
	char *p;
	qUserInf *pUserInf;

	if (buflen < sizeof(TrmToSrv)) return 0;
	p = (char *)data;
	tpTrmToSrv = (TrmToSrv *)p;
	pUserInf = (qUserInf *)tpTrmToSrv->userid;
	memset(tpTrmToSrv ,0, sizeof(TrmToSrv));
	memcpy(pUserInf->user_cd,"CMNDLINE",sizeof(pUserInf->user_cd));
	len = sizeof(TrmToSrv);
	p += len;
	InfoParm.pi_attr = DEF_ZOK_CHAR;
	InfoParm.pi_code = arg_type;	/* akxt_get_code_type();*/
	if (dtype = (cl_get_option(21,0)>>8) & 0x0f) {
		if (opt_in = (cl_get_option(21,0)>>16) & 0x0f) dtype = opt_in;
		InfoParm.pi_code = dtype;
/*
printf("coal_make_pkt_form: dtype=%d\n",dtype);
*/
	}
	for (i = 0 ; i < argc ; i++) {
		InfoParm.pi_dlen = strlen(argv[i]);
		InfoParm.pi_data = argv[i];
		lw = InfoParm.pi_dlen <= 255 ? 2 : 6;
		if (len+InfoParm.pi_dlen+lw > buflen) break;
		lw = cm_set_pkt_form(&InfoParm ,p);
		len += lw;
		p   += lw;
	}
DEBUGOUTL3(10,"coal_make_pkt_form: len=%d argc=%d i=%d",len,argc,i);
	tpTrmToSrv->parmnum = htonl(i);
	return len;
}

#ifdef SUNOS5
static int _start(int argc, char **argv)
#else
static int _start(argc, argv)
int  argc;
char **argv;
#endif
{
	AKAMSGCOM  tMsgCom;
	int len, ret;
	long data[1024];

	if (argc <= 0) return 0;
	len = coal_make_pkt_form(argc,argv,data,sizeof(data));

	memset((char *)&tMsgCom,0,sizeof(AKAMSGCOM));
	tMsgCom.msg_disp = 1;
	tMsgCom.msg_mlen = len;
	tMsgCom.msg_pmsg = (char *)data;
	if ((ret = aka_post_msg(0,&tMsgCom)) < 0)
		ERROROUT1("_start: aka_post_msg ret=%d",ret);
	return ret;
}

int cl_main_set_opt(pargc,pargv)
int  *pargc;
char **pargv[];
{
	iExit = iUsage = 0;
	_set_opt(pargc,pargv,"dxo");
	if (iUsage) _usage(cpProcName);

	_cpi2c(CLcommon.dbgopt,debug_opt,
	       X_MIN(sizeof(CLcommon.dbgopt)/sizeof(char),sizeof(debug_opt)/sizeof(int)));

	if (no_extension) CLcommon.pExtension = NULL;
	else CLcommon.pExtension = extension;

	return iExit+iUsage;
}
