static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/********************************************************************/
/* <clfuncmath.c>                                                     */
/*      func_math                                           */
/*                              by Koba       (2007/12/22 Ver 0.1) */
/********************************************************************/

#include "colmn.h"        /* ֐vg^Cv錾 */

extern CLCOMMON  CLcommon;
extern CLPRTBL   *pCLprocTable;
extern GlobalCt  *pGlobTable;
extern int giOptions[];

/****************************************/
/*										*/
/****************************************/
int func_math2(pInfoParmW,pOperator,nparm,ppParm,ope)
tdtInfoParm *pInfoParmW;
char *pOperator;
tdtInfoParm *ppParm[];
int nparm,ope;
{
	int rc,atr1,iAttr[3],format_no,iDBL,ret;
	long Val1z[NMPA_LONG],*Val1;
	double dVal;
	MPA maz,*ma;

	rc = 0;
	iDBL = cl_get_option(2,0) & 0x04;
	if (!iDBL && (ope==D_FUC_SQRT || ope==D_FUC_CBRT ||
	              ope==D_FUC_LOG || ope==D_FUC_LOG10)) {
		Val1 = cl_get_tmpMPA(Val1z);
		if ((rc=cl_get_parm_mpa(ppParm[0],Val1,"Parm1",iAttr)) < 0) return rc;
		else if (rc > 0) return ECL_SCRIPT_ERROR;

		ma = (MPA *)cl_get_tmpMPA(&maz);
		format_no = 0;
		atr1 = iAttr[0];
		if (atr1 == DEF_ZOK_DECI) {
			switch (ope) {
			case D_FUC_SQRT:
				rc = m_sqrt(ma,(MPA *)Val1);
				format_no = 402;	/* %s łB */
				break;
			case D_FUC_CBRT:
				rc = m_cbrt(ma,(MPA *)Val1);
				break;
			case D_FUC_LOG:
				rc = m_ln(ma,(MPA *)Val1);
				format_no = 403;	/* %s słB */
				break;
			case D_FUC_LOG10:
				rc = m_log10(ma,(MPA *)Val1);
				format_no = 403;	/* %s słB */
				break;
			default:
				rc = -1;
			}
			if (rc) {
				ret = rc % 10;
				if (ret==-2 && format_no>0)
					ERROROUT1(FORMAT(format_no),pOperator);
				else if (rc > 0) rc = ECL_SCRIPT_ERROR;
			/*	else rc = ECL_SCRIPT_ERROR;	*/
			}
			else cl_set_parm_mpa(pInfoParmW,ma);
		}
	}
	else atr1 = 0;
	if (!rc && atr1!=DEF_ZOK_DECI) {
		rc = func_math(&dVal,pOperator,nparm,ppParm,ope);
		if (!rc) cl_set_parm_double(pInfoParmW,dVal);
	}
	return rc;
}

/****************************************/
/*										*/
/****************************************/
int func_math(pWork,pOperator,nparm,ppParm,ope)
char *pWork;
char *pOperator;
tdtInfoParm *ppParm[];
int nparm,ope;
{
	int ret,rc,atr1,atr2,Val2[2];
	long Val1z[NMPA_LONG],*Val1;
	double dValue1,dValue2,dVal;
/*
printf("func_math: pOperator=%s nparm=%d ope=%d\n",pOperator,nparm,ope);
*/
	ret = 0;
	dVal = 0.0;
	if (ope == D_FUC_RAND1) {
		if (nparm > 0) ERROROUT1(FORMAT(401),pOperator);	/* %s 𖳎܂B */
		dVal = drand48();
	}
	else if (ope == D_FUC_SRAND1) {
		Val1 = cl_get_tmpMPA(Val1z);
		if ((rc = cl_get_parm_long(ppParm[0],Val1,"Parm1"))  < 0) ret = rc;
		else if (rc > 0) ret = ECL_SCRIPT_ERROR;
		else srand48(Val1[0]);
	}
	else {
		if ((rc=cl_get_parm_double(ppParm[0],&dValue1,"Parm1")) < 0) return rc;
		else if (rc > 0) return ECL_SCRIPT_ERROR;
		dValue2 = 0.0;
		if (nparm >= 2) {
			if ((rc=cl_get_parm_double(ppParm[1],&dValue2,"Parm2")) < 0) return rc;
			else if (rc > 0) return ECL_SCRIPT_ERROR;
		}
		switch (ope) {
			case D_FUC_SQRT:
				if (dValue1 >= 0.0) dVal = sqrt(dValue1);
				else {
					ERROROUT1(FORMAT(402),pOperator);	/* %s łB */
					ret = ECL_SCRIPT_ERROR;
				}
				break;
			case D_FUC_SIN:
				dVal = sin(dValue1);
				break;
			case D_FUC_COS:
				dVal = cos(dValue1);
				break;
			case D_FUC_TAN:
				dVal = tan(dValue1);
				break;
			case D_FUC_ASIN:
			case D_FUC_ACOS:
				if (dValue1<-1.0 || dValue1>1.0) {
					ERROROUT1(FORMAT(403),pOperator);	/* %s słB */
					ret = ECL_SCRIPT_ERROR;
				}
				else {
					if (ope == D_FUC_ASIN) dVal = asin(dValue1);
					else dVal = acos(dValue1);
				}
				break;
			case D_FUC_ATAN:
				dVal = atan(dValue1);
				break;
			case D_FUC_ATAN2:
				if (nparm < 2) {
					ERROROUT1(FORMAT(405),pOperator);	/* %s xWl܂B */
					ret = ECL_SCRIPT_ERROR;
				}
				if (X_ABS(dValue2) < MINREGDBL) {
					ERROROUT1(FORMAT(403),pOperator);	/* %s słB */
					ret = ECL_SCRIPT_ERROR;
				}
				else dVal = atan2(dValue1,dValue2);
				break;
			case D_FUC_LOG:
			case D_FUC_LOG10:
				if (dValue1 < MINREGDBL) {
					ERROROUT1(FORMAT(403),pOperator);	/* %s słB */
					ret = ECL_SCRIPT_ERROR;
				}
				else {
					if (ope == D_FUC_LOG) dVal = log(dValue1);
					else dVal = log10(dValue1);
				}
				break;
			case D_FUC_EXP:
				dVal = exp(dValue1);
				break;
			case D_FUC_POWER:
				if (nparm < 2) {
					ERROROUT1(FORMAT(404),pOperator);	/* %s wl܂B */
					ret = ECL_SCRIPT_ERROR;
				}
				else dVal = pow(dValue1,dValue2);
				break;
			case D_FUC_CBRT:
				dVal = cbrt(dValue1);
				break;
			case D_FUC_SINH:
				dVal = sinh(dValue1);
				break;
			case D_FUC_COSH:
				dVal = cosh(dValue1);
				break;
			case D_FUC_TANH:
				dVal = tanh(dValue1);
				break;
			case D_FUC_ATANH:
				dVal = atanh(dValue1);
				break;
			case D_FUC_CEIL:
				dVal = ceil(dValue1);
				break;
			case D_FUC_FLOOR:
				dVal = floor(dValue1);
				break;
			case D_FUC_RINT:
				dVal = rint(dValue1);
				break;
			default:
				ERROROUT1("func_math: function=[%s] not defined!!",pOperator);
				ret = ECL_SCRIPT_ERROR;
		}
	}
	memcpy(pWork,&dVal,sizeof(double));
	if (errno) {
		pGlobTable->error = ECL_SCRIPT_ERROR;
		pGlobTable->err_no = errno;
		ERROROUT3("func_math: function=[%s] errno=%d %s",pOperator,errno,strerror(errno));
		if (cl_get_option(2,0) & 0x200) {
			pGlobTable->exception = MATH_COMP_ERROR_EXCEPTION;
			ret = ECL_SCRIPT_ERROR;
		}
	}
	return ret;
}
