static	char	sccsid[]="%Z% %M% %I% %E% %U%";
/*************************************************
 *
 *  akbrwque.c
 *
 *        coded by A.Kobayashi 2004/2/28
 *
 *************************************************/
#include "akbcommon.h"

static char  gApplName[16];
static char *gpApplName=NULL;
static int giChaRbFlg=0;
static int giChaRbFlgTimer=0;
static tdtTIMER_CTL_HEAD *gpTCChaRb=NULL;
static int giTimerIdChaRb=0;
static struct timeval tTimeOutChaRb;

/********************************************************/
/*                                                      */
/********************************************************/
int akb_cha_rb_regist_timer(pTC,iTimerId)
tdtTIMER_CTL_HEAD *pTC;
int  iTimerId;
{
	gpTCChaRb = pTC;
	giTimerIdChaRb = iTimerId;
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_cha_rb_timer(iTimerId, cpTimerName, cpParm, tptime)
int iTimerId;
char *cpTimerName;
char *cpParm;
struct timeval *tptime;
{
	int t;

printf("akbChaRbFlg_timer: TimerId=%d\n",iTimerId);
	if (akxe_timer_sub(NULL,&tTimeOutChaRb,tptime) < 3000) {
		akb_set_cha_rb_flg(0);
		akxe_stop_timer(gpTCChaRb,1,&giTimerIdChaRb);
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_set_cha_rb_flg_timer(flg)
int flg;
{
	struct timeval tt;
	int i;

	if (gpTCChaRb && giTimerIdChaRb>0) {
		i = giChaRbFlgTimer;
		giChaRbFlgTimer = flg;
		if (i && !flg) {
			akxe_get_msec_l(gpTCChaRb,&tt);
			akxe_timer_add_msec(&tTimeOutChaRb,&tt,60000);
			akxe_start_timer(gpTCChaRb,1,&giTimerIdChaRb);
printf("akb_set_cha_rb_flg_timer: StartTimer: giChaRbFlgTimer=%d flg=%d\n",i,flg);
		}
		else {
			if (!i && flg) {
				akxe_stop_timer(gpTCChaRb,1,&giTimerIdChaRb);
printf("akb_set_cha_rb_flg_timer: StopTimer: giChaRbFlgTimer=%d flg=%d\n",i,flg);
			}
			i = akb_set_cha_rb_flg(flg);
		}
	}
	else i = akb_set_cha_rb_flg(flg);

	return i;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_set_cha_rb_flg(flg)
int flg;
{
	int i;

if ((!giChaRbFlg && flg) || (giChaRbFlg && !flg))
printf("akb_set_cha_rb_flg: giChaRbFlg=%d flg=%d\n",giChaRbFlg,flg);

	i = giChaRbFlg;
	giChaRbFlg = flg;
	return i;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_get_cha_rb_flg()
{
/*
printf("akb_get_cha_rb_flg: giChaRbFlg=%d\n",giChaRbFlg);
*/
	return giChaRbFlg;
}

/********************************************************/
/*                                                      */
/********************************************************/
tdtRW_QUE *akb_rwque_new(iQueMax,iOpt)
int iQueMax,iOpt;
{
	tdtRW_QUE *p;
	int n;

	if (iQueMax > 0) {
		if (p=(tdtRW_QUE *)Malloc(n=sizeof(tdtRW_QUE)*iQueMax)) {
			memset(p,0,n);
			if (iOpt & 0x01) akb_rwque_init(p,0);
		}
	}
	else p=NULL;
	return p;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_rwque_init(p,iOpt)
tdtRW_QUE *p;
int iOpt;
{
	if (!p) return -1;
	if (iOpt & 0x01) memset(p,0,sizeof(tdtRW_QUE));
	p->rwq_mode   = ' ';
	p->rwq_sd       = -1;
	p->rwq_wtime = -1;
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_init_que(iQueMax,QueTbl)
int iQueMax;
tdtRW_QUE QueTbl[];
{
	int i;
	tdtRW_QUE *pQT;

	if (!(pQT=QueTbl)) return -1;
	memset(QueTbl,0,sizeof(tdtRW_QUE)*iQueMax);
	for (i=0;i<iQueMax;i++,pQT++) {
		akb_rwque_init(pQT,0);
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_free_que(iQueMax,QueTbl)
int iQueMax;
tdtRW_QUE QueTbl[];
{
	int i;
	tdtRW_QUE *pQT;
	char *p;

	if (!(pQT=QueTbl)) return -1;
	for (i=0;i<iQueMax;i++,pQT++) {
		if (p=pQT->rwq_buf) Free(p);
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int  akb_read_que(iCh, pReadQue, pRbRCtl)
int     iCh;
tdtRW_QUE  *pReadQue;
tdtRB_CTL  *pRbRCtl;
{
	return akb_read_que_w(iCh, pReadQue, pRbRCtl, NULL);
}

/********************************************************/
/*                                                      */
/********************************************************/
int  akb_read_que_w(iCh, pReadQue, pRbRCtl, pRbWCtl)
int     iCh;
tdtRW_QUE  *pReadQue;
tdtRB_CTL  *pRbRCtl, *pRbWCtl;
{
	pRC_PACKET_TABLE  pNew=NULL;
	tdtCOMM_PACK_HEAD   HeadFlame,*pHead;
	char *pData,*p;
	int  iLenData, iLenHead;
	int  iOffset,iLen,iRc,i,iOpt2;
	tdtRB_CTL  *pRbCtl;

	if (pReadQue->rwq_torwlen == 0) {
		pReadQue->rwq_mode   = 'H';
		pReadQue->rwq_offset    = 0;
		pReadQue->rwq_tcount = 0;
		pReadQue->rwq_torwlen  = sizeof(tdtCOMM_PACK_HEAD);
		pReadQue->rwq_rwlen    = 0;
		if (!(pReadQue->rwq_buf=Malloc(sizeof(tdtCOMM_PACK_HEADA))))
			return D_ERR_MEM_ALLOC;
		/* pPbgʃwb_̓ǂݍ */
DEBUGOUTL1(AKB_LOG_GROUP|254,"akb_read_que_w: Ch=%d Header read start.",iCh);
	}
	if (pReadQue->rwq_tcount == 255) {
		if (pReadQue->rwq_rwlen>0) akb_log_statistics_count(0,pReadQue->rwq_rwlen);
	/*	iLenData = iLen = 0;	*/
		pReadQue->rwq_torwlen = 0;
DEBUGOUTL1(AKB_LOG_GROUP|254,"akb_read_que_w: Ch=%d timeout error.",iCh);
		return D_ERR_TIMEOUT;
	}
	else {
		iLen    = pReadQue->rwq_torwlen - pReadQue->rwq_rwlen;
		iOffset = pReadQue->rwq_offset + pReadQue->rwq_rwlen;
		iLenData = sk_nolp_read(pReadQue->rwq_sd ,pReadQue->rwq_buf+iOffset, iLen);
DEBUGOUTL3(AKB_LOG_GROUP|254,
"akb_read_que_w: sk_nolp_read iSd=%d iLen=%d iLenData=%d",pReadQue->rwq_sd,iLen,iLenData);
		if (iLenData <= 0 || iLenData > iLen) {
			if (pReadQue->rwq_rwlen>0) akb_log_statistics_count(0,pReadQue->rwq_rwlen);
			if (iLen <= 0) ERROROUT("akb_read_que: System error iLen=0");
		/*
			if (pReadQue->rwq_mode == 'H' || pReadQue->rwq_mode == 'A') {
		*/
				Free(pReadQue->rwq_buf);
				pReadQue->rwq_buf = NULL;
		/*
			}
			else
				akbSaveHeadAndData(pReadQue->rwq_buf);
		*/
			pReadQue->rwq_torwlen = 0;
			return -1;
		}
		pReadQue->rwq_rwlen += iLenData;
#ifndef NO_RWQTIMEOUT
		akb_set_que_out_time(pReadQue,NULL);
#endif
	}
	if (iLenData == iLen) {
		if (pReadQue->rwq_mode == 'H' || pReadQue->rwq_mode == 'A') {
			iRc = akb_head_check2(iCh,pReadQue,0);
DEBUGOUTL2(AKB_LOG_GROUP|254,"akb_read_que_w: Ch=%d akb_head_check2 iRc=%d",iCh,iRc);
		/*	if (iRc == 0) return iRc;	*/
			if (iRc > 0) return 0;	/* 2003.3.24 Koba */
			else if (iRc < 0) {
				pReadQue->rwq_torwlen = 0;
				if (iRc == D_ERR_MEM_ALLOC) goto Err;
				if (pReadQue->rwq_buf) {		/* add 2001.7.31 Koba */
					Free(pReadQue->rwq_buf);		/* add 1997.10.02 Koba */
					pReadQue->rwq_buf = NULL;	/* add 1997.10.02 Koba */
				}
				akb_log_statistics_count(0,pReadQue->rwq_rwlen);
				return iRc;
			}
		}
/*
printf("[akb_read_que_w] Packet read end.(Sd=%d) Packet len = %d\n",
iSd,pReadQue->rwq_offset+pReadQue->rwq_torwlen);
*/
		/* pPbgǗe[u֐ݒ */
		pNew = akb_packet_tbl_new(0);
		if ( pNew == NULL ) {
		/*
			akbSaveHeadAndData(pReadQue->rwq_buf);
		*/
			pReadQue->rwq_torwlen = 0;
			iRc = D_ERR_MEM_ALLOC;
			goto Err;
		}
		pNew->sp_content = pReadQue->rwq_buf ;
		pNew->sp_len     = pReadQue->rwq_offset + pReadQue->rwq_torwlen;
		pNew->sp_ch      = iCh;
		pNew->sp_srcch   = iCh + 1;
/*
akxaxdump("akb_read_que_w:pNew",pNew->sp_content,pNew->sp_len);
*/
		pReadQue->rwq_mode  = ' ';
		pReadQue->rwq_torwlen = 0;
		pReadQue->rwq_buf = NULL;	/* add 1997.8.19 Koba */

		iOpt2 = pReadQue->rwq_option;
DEBUGOUTL2(AKB_LOG_GROUP|250,"akb_read_que_w: Ch=%d iOpt2=%08x",iCh,iOpt2);
		if (iOpt2) {
			if (iOpt2 & AKB_RQUE_OPT_XTOF)  iRc = akbi_xto_fpacket(pNew);
			if (iOpt2 & AKB_RQUE_OPT_INDIR) iRc = akbi_from_indir_f(pNew);
			if (iRc < 0) {
				iRc = D_ERR_FORM_CHANGE;
				goto Err;
			}
		}
		if (!akxs_rb_set_n(pRbRCtl,pNew)) {
		/*
			akbSaveHeadAndData(pNew->sp_content);
			Free(pNew);
		*/
			iRc = D_ERR_MEM_ALLOC;
			goto Err;
		}
		akb_log_statistics_count(0,pReadQue->rwq_rwlen);
#if 1
		if (iOpt2 & AKB_RWQUE_OPT_NEED_REPLY) {
			akb_need_reply(pNew,pRbRCtl,pRbWCtl);
		}
#endif
	}
/*
	else {
printf("[akb_read_que_w] Packet read suspended.fd = %d\n",iSd);
	}
*/
	return 0 ;

  Err:
	if (iOpt2 & AKB_RQUE_OPT_ERR_BUFF) {
		akb_log_statistics_count(0,pReadQue->rwq_rwlen);
		if (pNew) {
			pReadQue->rwq_buf = pNew->sp_content;
			pReadQue->rwq_rwlen = pNew->sp_len;
		}
	}
	else if (iOpt2 & AKB_RQUE_OPT_ERR_DROP) {
		akb_log_statistics_count(0,pReadQue->rwq_rwlen);
		if (iRc == D_ERR_FORM_CHANGE) p = "ERR_FORM_CHANGE";
		else p = "ERR_MEM_ALLOC";
		ERROROUT1("*** akb_read_que_w:Dropped Packet -- %s",p);
		if (pNew) Free(pNew->sp_content);
		else if (pReadQue->rwq_buf) {
			Free(pReadQue->rwq_buf);
			pReadQue->rwq_buf = NULL;
		}
	}
	else {
		if (!(pRbCtl=pRbWCtl)) pRbCtl = pRbRCtl;
		if (pNew) p = pNew->sp_content;
		else {
			p = pReadQue->rwq_buf;
			pReadQue->rwq_buf = NULL;
		}
		if (akb_set_rb_pack_err_cd(iCh,p,pRbCtl,iRc)) {
			ERROROUT("*** akb_read_que_w:Drop Packet -- akb_set_rb_pack_err_cd error");
			Free(p);
		}
		else if (pRbCtl == pRbWCtl) akb_trace_out(1,p);
	}
	if (pNew) Free(pNew);
	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_head_check(iCh,pReadQue)
int      iCh;
tdtRW_QUE  *pReadQue ;
{
	tdtCOMM_PACK_HEAD   *pH;
	tdtCOMM_PACK_HEADA  *pHA;
	uchar ver;
	int lLen;
	int iRc;

	pH = (tdtCOMM_PACK_HEAD *)pReadQue->rwq_buf;
	pHA = (tdtCOMM_PACK_HEADA *)pH;
	ver = pH->cph_prt.prt_ver;
	if ((pReadQue->rwq_mode=='H' && ver!='A') ||
	    (pReadQue->rwq_mode=='A' && ver=='A')) {
		if (pReadQue->rwq_rwlen < pReadQue->rwq_torwlen) return D_ERR_PACKET;
		if (iRc = akb_is_right_head(pH)) return iRc;
		if (ver == 'A') pHA->pha_dinf.ina_disp &= ~AKB_AKO_CHANNEL;
		else pH->cph_dinf.ind_disp &= ~AKB_AKO_CHANNEL;
	}
DEBUGOUTL2(AKB_LOG_GROUP|254,"akb_head_check: Mode=%c ver=%c",
pReadQue->rwq_mode,ver);
	/* 1 --> 0 2003.3.24 Koba */
	if (pReadQue->rwq_mode == 'H' && ver != 'A' && pH->cph_plen == 0) return 0;
	else if (pReadQue->rwq_mode == 'A' && pHA->pha_plen == 0) return 0;

	if (pReadQue->rwq_mode == 'H' && ver == 'A') {
		pReadQue->rwq_mode = 'A';
		lLen = sizeof(tdtCOMM_PACK_HEADA) - sizeof(tdtCOMM_PACK_HEAD);
		pReadQue->rwq_torwlen += lLen;
DEBUGOUTL1(AKB_LOG_GROUP|254,"akb_head_check: lToRWLen=%d",pReadQue->rwq_torwlen);
	}
	else {
		pReadQue->rwq_mode   = 'D';
	/*	pReadQue->ucOffset    = pReadQue->lToRWLen;	*/
		pReadQue->rwq_tcount = 0;
		if (ver == 'A') lLen = ntohl(pHA->pha_plen);
		else lLen = ntohl(pH->cph_plen);
		pReadQue->rwq_torwlen += lLen;
DEBUGOUTL2(AKB_LOG_GROUP|254,"akb_head_check: lLen=%d lToRWLen=%d",
lLen,pReadQue->rwq_torwlen);
	/*	pReadQue->lRWLen    = 0;	*/
		/* pPbg̈̊m */
		pReadQue->rwq_buf=Malloc(pReadQue->rwq_offset+pReadQue->rwq_torwlen+1);
		if (!(pReadQue->rwq_buf)) {
			if (ver == 'A') pHA->pha_plen = 0;
			else pH->cph_plen = 0;
#if 0
			akbSaveHeadAndData(pH);
#else
			pReadQue->rwq_buf = (char *)pH;
#endif
			/* f[^̓ǂݎ̂ */
			akb_sk_dmy_read(pReadQue->rwq_sd,pReadQue->rwq_torwlen);
			return D_ERR_MEM_ALLOC;
		}
/*		memcpy(pReadQue->cpBuff,pH,sizeof(qCommPackHead));	*/
		memcpy(pReadQue->rwq_buf,pH,pReadQue->rwq_rwlen);
		Free(pH);
	}
/*	return 0;	*/
	return lLen;	/* 2003.3.24 Koba */
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_head_check2(iCh,pReadQue,not_recovery)
int      iCh,not_recovery;
tdtRW_QUE  *pReadQue ;
{
	int iRc,i;
	char *p,c;

	iRc = akb_head_check(iCh,pReadQue);
DEBUGOUTL1(AKB_LOG_GROUP|254,"akb_head_check2: iRc=%d",iRc);
	if (iRc < 0) {
		if (!not_recovery) {
			if (iRc == D_ERR_PACKET) {	/* add 2001.7.31 Koba */
				p = pReadQue->rwq_buf;
				for (i=1;i<pReadQue->rwq_torwlen;i++) {
					p++;
					if ((c=*p) == 'A' || c == 'C' || c == 'B') {
						pReadQue->rwq_rwlen -= i;
						memcpy(pReadQue->rwq_buf,p,pReadQue->rwq_rwlen);
					/*	return 0;	*/
						return i;	/* 2003.3.24 Koba */
					}
				}
			/*	iRc = 0;	*/	/* add 2000.12.4 Koba */
				iRc = i - 1;	/* 2003.3.24 Koba */
				/* add 2002.3.12  Koba */
				pReadQue->rwq_torwlen = 0;
				if (pReadQue->rwq_buf) {
					Free(pReadQue->rwq_buf);
					pReadQue->rwq_buf = NULL;
				}
			}
		}
	}
	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_write_que(pWriteQue)
tdtRW_QUE *pWriteQue;
{
	int iLenData,iOffset,iLen;

	if (pWriteQue->rwq_torwlen == 0) return 0;
	else if (pWriteQue->rwq_tcount == 255) {
		pWriteQue->rwq_mode   = ' ';
		return D_ERR_TIMEOUT;
	}
	iLen    = pWriteQue->rwq_torwlen - pWriteQue->rwq_rwlen;
	iOffset = pWriteQue->rwq_rwlen;
/*
iLenData=0;
DEBUGINPUT("akb_write_que:lToRWLen=",pWriteQue->rwq_torwlen,&iLenData);
if (!iLenData)
*/
	iLenData = sk_nolp_write(pWriteQue->rwq_sd ,pWriteQue->rwq_buf+iOffset, iLen);
/*
DEBUGINPUT("akb_write_que:iLenData=",iLenData,&iLenData);
*/
	if (iLenData < 0 || iLenData > iLen) {
		pWriteQue->rwq_mode   = ' ';
		return -1;
	}
#ifndef NO_RWQTIMEOUT
	akb_set_que_out_time(pWriteQue,NULL);
#endif
	pWriteQue->rwq_rwlen += iLenData;
	if (iLenData == iLen) {
/*
printf("[akb_write_que] Packet write end.(Sd=%d) Packet len = %d\n",
pWriteQue->rwq_sd,pWriteQue->rwq_rwlen);
*/
		pWriteQue->rwq_mode   = ' ';
		pWriteQue->rwq_torwlen = 0;
		Free(pWriteQue->rwq_buf);
		pWriteQue->rwq_buf = NULL;
		pWriteQue->rwq_tcount = 0;
#if 1
		if (pWriteQue->rwq_option & AKB_RWQUE_OPT_WAIT_REPLY) {
			pWriteQue->rwq_torwlen = -1;
		}
#endif
    	return 0 ;
	}
/*
	else {
printf("[akb_write_que] Packet write suspended.fd = %d\n",pWriteQue->rwq_sd);
	}
*/
    return 1 ;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_wqset_err_reply(name,pSdNext,pRbWWCtl,pRbRCtl,iRetCode)
char *name;
int iRetCode;
pSD_PACKET_TABLE pSdNext;
tdtRB_CTL *pRbWWCtl,*pRbRCtl;
{
	tdtRB_CTL *pRbCtl;
	int iQTbl,ret;

	if ((iQTbl = pSdNext->sp_srcch) > 0) {
		iQTbl--;
		pRbCtl = pRbWWCtl;
	}
	else {
		iQTbl = 0;
		pRbCtl = pRbRCtl;
	}
	if (pRbCtl) {
		if (ret=akb_set_rb_pack_err_cd(iQTbl,pSdNext->sp_content,pRbCtl,iRetCode)) {
			ERROROUT2("*** %s: Dropped Packet -- akb_set_rb_pack_err_cd ret=%d",
			          name,ret);
			Free(pSdNext->sp_content);
		}
		else if (pRbCtl == pRbWWCtl)
			akb_trace_out(1,pSdNext->sp_content);
	}
	else Free(pSdNext->sp_content);
	Free(pSdNext);
	return 0;;
}

/********************************************************/
/*                                                      */
/********************************************************/
tdtRW_QUE *akb_wqset_getp_q(iNotPA,WriteQue,iQTbl)
int    iNotPA,iQTbl;
tdtRW_QUE *WriteQue[];
{
	tdtRW_QUE *pWriteQue;

	if (iNotPA)
		pWriteQue = &((tdtRW_QUE *)WriteQue)[iQTbl];
	else
		pWriteQue = WriteQue[iQTbl];

	return pWriteQue;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_wqset_make_xf(pWriteQue,pSdNext)
tdtRW_QUE *pWriteQue;
pSD_PACKET_TABLE pSdNext;
{
	int iRc,iOpt;

	iRc = 0;
	if (iOpt=pWriteQue->rwq_option) {
		if (iOpt & AKB_WQUE_OPT_MAKE_XPACK) {
			iRc = akbi_make_xpacket(pSdNext,
				iOpt & (AKB_WQUE_OPT_SAME_HOST | AKB_WQUE_OPT_CHK_REPLY));
		}
		if (iOpt & AKB_WQUE_OPT_MAKE_INDIR) {
			if (!gpApplName) {
				sprintf(gApplName,"WQ%d",getpid());
				gpApplName = gApplName;
			}
			iRc = akbi_make_indir_f(pSdNext,gpApplName);
		}
	}
	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_wqset_r2(iNotPA,WriteQue,iQueMax,pRbWCtl,pRbWWCtl,pRbRCtl)
int    iNotPA,iQueMax;
tdtRW_QUE *WriteQue[];
tdtRB_CTL *pRbWCtl,*pRbWWCtl,*pRbRCtl;
{
	pSD_PACKET_TABLE   pSdNext, pNew;
	tdtRW_QUE *pWriteQue;
	int iQTbl, iRc, iOpt;
	char *pData;
	struct timeval tt;
	pCOMM_PACK_HEAD  pHead;

DEBUGOUTL2(AKB_LOG_GROUP|254,"akb_wqset_r2: Called iNotPA=%d iQueMax=%d",
iNotPA,iQueMax);

#ifndef NO_RWQTIMEOUT
	akxe_get_msec(NULL,&tt);
#endif
	while (pSdNext=(pSD_PACKET_TABLE)akxs_rb_get_n(pRbWCtl)) {
		iQTbl = pSdNext->sp_ch;

DEBUGOUTL1(AKB_LOG_GROUP|250,"akb_wqset_r2: Ch=%d",iQTbl);

		if (iQTbl<0 || (iQueMax>=0 && iQTbl>=iQueMax)) {
			ERROROUT1("akbWQueSetR2: invalid iCh=%d",pSdNext->sp_ch);
			Free(pSdNext->sp_content);
			Free(pSdNext);
			continue;
		}
		if (!(pWriteQue = akb_wqset_getp_q(iNotPA,WriteQue,iQTbl))) {
			ERROROUT("akbWQueSetR2: pWriteQue is NULL");
			continue;
		}

DEBUGOUTL3(AKB_LOG_GROUP|254,"akb_wqset_r2: iSd=%d lToRWLen=%d iOption=%08x",
pWriteQue->rwq_sd,pWriteQue->rwq_torwlen,pWriteQue->rwq_option);

		if (pWriteQue->rwq_sd < 0) {	/* add 2000.8.8 Koba */
			ERROROUT1("akbWQueSetR2: socket closed iCh=%d",pSdNext->sp_ch);
			akb_wqset_err_reply("akb_wqset_r2",pSdNext,pRbWWCtl,pRbRCtl,
			                 D_ERR_SOCKET_CLOSED);
			if (pWriteQue->rwq_torwlen > 0) {
				pWriteQue->rwq_torwlen = 0;
				if (pWriteQue->rwq_buf) Free(pWriteQue->rwq_buf);
				pWriteQue->rwq_buf = NULL;
			}
			continue;
		}
		if (pWriteQue->rwq_torwlen == 0) {
			iRc = akb_wqset_make_xf(pWriteQue,pSdNext);
			if (iRc < 0) {
				akb_wqset_err_reply("akb_wqset_r2",pSdNext,pRbWCtl,pRbRCtl,
				                 D_ERR_FORM_CHANGE);
				continue;
			}
			akb_set_write_que(pWriteQue,pSdNext);
#ifndef NO_RWQTIMEOUT
			akb_set_que_out_time(pWriteQue,&tt);
#endif
			Free(pSdNext);
		}
		else {
			akxs_rb_set_n(pRbWWCtl,pSdNext);
		}
	}
#if 1	/* 2005.6.13 Koba */
	akxs_rb_exchg(pRbWCtl,pRbWWCtl,0);
#else
	while (pSdNext=(pSD_PACKET_TABLE)akxs_rb_get_n(pRbWWCtl)) {
		akxs_rb_set_n(pRbWCtl,pSdNext);
	}
#endif
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_wqset_r(WriteQue,pRbWCtl,pRbWWCtl,pRbRCtl)
tdtRW_QUE WriteQue[];
tdtRB_CTL *pRbWCtl,*pRbWWCtl,*pRbRCtl;
{
	return akb_wqset_r2(1,WriteQue,-1,pRbWCtl,pRbWWCtl,pRbRCtl);
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_wqset(WriteQue,pRbWCtl,pRbWWCtl)
tdtRW_QUE WriteQue[];
tdtRB_CTL *pRbWCtl,*pRbWWCtl;
{
	return akb_wqset_r(WriteQue,pRbWCtl,pRbWWCtl,NULL);
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_wqset_par(WriteQue,pRbWCtl,pRbWWCtl,pRbRCtl)
tdtRW_QUE *WriteQue[];
tdtRB_CTL *pRbWCtl,*pRbWWCtl,*pRbRCtl;
{
	return akb_wqset_r2(0,WriteQue,-1,pRbWCtl,pRbWWCtl,pRbRCtl);
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_qscheck_paopt(iQueMax,QueTbl,iOption)
int iQueMax;
tdtRW_QUE *QueTbl[];
int iOption;
{
	int i,opt,count;
	tdtRW_QUE **ppQT,*pQT;

	if (!(ppQT=QueTbl)) return -1;
	opt = iOption; /* & 0x10; */	/* count */
	count = 0;
	for (i=0;i<iQueMax;i++,ppQT++) {
		if (pQT = *ppQT) {
			if (pQT->rwq_torwlen > 0) {
				if (opt) {
					count++;

DEBUGOUTL3(AKB_LOG_GROUP|250,"akb_qscheck_paopt: i=%d lToRWLen=%d count=%d",
i,pQT->rwq_torwlen,count);

				}
				else {

DEBUGOUTL2(AKB_LOG_GROUP|250,"akb_qscheck_paopt: i=%d lToRWLen=%d, return 1",
i,pQT->rwq_torwlen);

					return 1;
				}
			}
		}
	}
	return count;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_qscheck_pa(iQueMax,QueTbl)
int iQueMax;
tdtRW_QUE *QueTbl[];
{
	return akb_qscheck_paopt(iQueMax,QueTbl,0);
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_qscount_pa(iQueMax,QueTbl)
int iQueMax;
tdtRW_QUE *QueTbl[];
{
	return akb_qscheck_paopt(iQueMax,QueTbl,0x10);
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_qscheck_opt(iQueMax,QueTbl,iOption)
int iQueMax;
tdtRW_QUE QueTbl[];
int iOption;
{
	int i,opt,count;
	tdtRW_QUE *pQT;

	if (!(pQT=QueTbl)) return -1;
	opt = iOption; /* & 0x10; */	/* count */
	count = 0;
	for (i=0;i<iQueMax;i++,pQT++) {
		if (pQT->rwq_torwlen > 0) {
			if (opt) {
				count++;

DEBUGOUTL3(AKB_LOG_GROUP|250,"akb_qscheck_opt: i=%d lToRWLen=%d count=%d",
i,pQT->rwq_torwlen,count);

			}
			else {

DEBUGOUTL2(AKB_LOG_GROUP|250,"akb_qscheck_opt: i=%d lToRWLen=%d, return 1",
i,pQT->rwq_torwlen);

				return 1;
			}
		}
	}
	return count;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_qscheck(iQueMax,QueTbl)
int iQueMax;
tdtRW_QUE QueTbl[];
{
	return akb_qscheck_opt(iQueMax,QueTbl,0);
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_qscount(iQueMax,QueTbl)
int iQueMax;
tdtRW_QUE QueTbl[];
{
	return akb_qscheck_opt(iQueMax,QueTbl,0x10);
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_clear_rwque(pQueTbl,iSd)
tdtRW_QUE *pQueTbl;
int     iSd;
{
	int n,i;

	if (!pQueTbl) return -1;
	if (pQueTbl->rwq_buf) Free(pQueTbl->rwq_buf);
	n = pQueTbl->rwq_wtime;
	i = pQueTbl->rwq_option;
	memset(pQueTbl,0,sizeof(tdtRW_QUE));
	pQueTbl->rwq_mode   = ' ';
	pQueTbl->rwq_sd       = iSd;
	pQueTbl->rwq_wtime = n;
	pQueTbl->rwq_option   = i;
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_set_write_que(pWriteQue,pSdNext)
tdtRW_QUE         *pWriteQue;
pSD_PACKET_TABLE  pSdNext;
{
	if (!pWriteQue || !pSdNext) return -1;

	pWriteQue->rwq_mode  = 'H';
	pWriteQue->rwq_offset = 0;
	pWriteQue->rwq_tof     = 0;
	pWriteQue->rwq_torwlen = pSdNext->sp_len;
	pWriteQue->rwq_rwlen   = pSdNext->sp_offset;
	pWriteQue->rwq_buf   = pSdNext->sp_content;

DEBUGOUTL3(AKB_LOG_GROUP|255,
"akb_set_write_que: iSd=%d ToL=%d RWL=%d",
pWriteQue->rwq_sd,pWriteQue->rwq_torwlen,pWriteQue->rwq_rwlen);

	pSdNext->sp_content = NULL;
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_set_que_out_time(pQ,tp)
tdtRW_QUE *pQ;
struct timeval *tp;
{
	int w_sec,t_sec;

	if (!pQ) return -1;
	if ((w_sec=pQ->rwq_wtime) >= 0) {
		if (tp) pQ->rwq_otime = tp->tv_sec + w_sec;
		else {
			if ((t_sec=akxe_get_msec(NULL,NULL)) >= 0) {
				pQ->rwq_otime = t_sec + w_sec;
			}
		}
	}
	return pQ->rwq_otime;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_set_rwque_pa(QueTbl,iQueMax,pQue)
tdtRW_QUE *QueTbl[],*pQue;
int iQueMax;
{
	int i;
	tdtRW_QUE **ppQT,*pQT;

	if (!(ppQT=QueTbl) || !(pQT=pQue)) return -1;
	for (i=0;i<iQueMax;i++,ppQT++,pQT++) {
		*ppQT = pQT;
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_need_reply(pRcv,pRbRCtl,pRbWCtl)
pRC_PACKET_TABLE  pRcv;
tdtRB_CTL  *pRbRCtl, *pRbWCtl;
{
	pRC_PACKET_TABLE  pNew;
	tdtCOMM_PACK_HEAD   *pHead, *pH;
	int *pData;
	int iLen;
	tdtRB_CTL  *pRbCtl;
	short sCommand;

	pHead = (pCOMM_PACK_HEAD)pRcv->sp_content;
	sCommand = ntohs(pHead->cph_prt.prt_cmnd);

DEBUGOUTL1(AKB_LOG_GROUP|255,"akb_need_reply: sCommand=%d",sCommand);
	if (sCommand != AKB_CMD_SEND ||
	    !(pHead->cph_prt.prt_send & AKB_PFM_NEED_REPLY)) return 0;

DEBUGOUTL2(AKB_LOG_GROUP|250,
"akb_need_reply: sCommand=%d iCh=%d",sCommand,pRcv->sp_ch);

	if (!(pNew=akb_packet_tbl_new(sizeof(tdtCOMM_PACK_HEAD)))) return -1;
	pNew->sp_ch    = pRcv->sp_ch;
	pNew->sp_srcch = pRcv->sp_srcch;
	pH = (pCOMM_PACK_HEAD)pNew->sp_content;
	if (pHead->cph_prt.prt_ver == 'A') akb_get_head_from_a(pH,pHead);
	else memcpy(pH,pHead,sizeof(tdtCOMM_PACK_HEAD));
	akb_exchg_indicate(pH);
	pH->cph_prt.prt_cmnd = htons(AKB_CMD_NEED_REPLY);
	pH->cph_prt.prt_send &= ~AKB_PFM_NEED_REPLY;
#if 1
	pH->cph_dinf.ind_hoid    = 0;
	pH->cph_dinf.ind_clid  = 0;
	pH->cph_sinf.ind_hoid     = 0;
	pH->cph_sinf.ind_clid   = 0;
	if (pNew->sp_ch > 0)
		pH->cph_sinf.ind_prid = htons(1);
	else
		pH->cph_dinf.ind_prid = htons(1);
#endif
	pH->cph_plen = 0;
	if (!(pRbCtl=pRbWCtl)) pRbCtl = pRbRCtl;
	else akb_trace_out(1,pNew->sp_content);
	akxs_rb_set_n(pRbCtl,pNew);

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_set_need_reply(pQ)
tdtRW_QUE *pQ;
{
	tdtCOMM_PACK_HEAD   *pH;
	short sCommand;

	pH = (tdtCOMM_PACK_HEAD *)pQ->rwq_buf;
	sCommand = ntohs(pH->cph_prt.prt_cmnd);

	if ((pQ->rwq_option & AKB_RWQUE_OPT_NEED_REPLY)
	 && sCommand==AKB_CMD_SEND
	 && (pH->cph_prt.prt_send & AKB_PFM_NEED_REPLY)) {
		pQ->rwq_option |= AKB_RWQUE_OPT_WAIT_REPLY;
DEBUGOUTL2(AKB_LOG_GROUP|250,
"akb_set_need_reply: cSendPrtcl=%02x sCommand=%d set WAIT_REPLY",
pH->cph_prt.prt_send,sCommand);
	}
	else
		pQ->rwq_option &= ~AKB_RWQUE_OPT_WAIT_REPLY;
	
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
static int _re_set_need_reply(iNotPA,pNew,WriteQue)
int iNotPA;
tdtRW_QUE *WriteQue[];
pRC_PACKET_TABLE pNew;
{
	tdtRW_QUE *pQ;
	int iTbl;

	if (!pNew || !WriteQue) return -1;

	iTbl = pNew->sp_srcch - 1;
	if (iTbl > 0) {
		if (!(pQ = akb_wqset_getp_q(iNotPA,WriteQue,iTbl))) {
			ERROROUT("_re_set_need_reply: pWriteQue is NULL");
			return -2;
		}
DEBUGOUTL2(AKB_LOG_GROUP|250,
"akb_re_set_need_reply: iTbl=%d lToRWLen=%d",iTbl,pQ->rwq_torwlen);
		if (pQ->rwq_torwlen < 0) pQ->rwq_torwlen = 0;
	}
	else {
DEBUGOUTL1(AKB_LOG_GROUP|250,"akb_re_set_need_reply: iTbl=%d",iTbl);
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_re_set_need_reply(pNew,WriteQue)
tdtRW_QUE         *WriteQue;
pRC_PACKET_TABLE pNew;
{
	return _re_set_need_reply(1,pNew,WriteQue);
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_re_set_need_reply_pa(pNew,WriteQuePA)
tdtRW_QUE         *WriteQuePA[];
pRC_PACKET_TABLE pNew;
{
	return _re_set_need_reply(0,pNew,WriteQuePA);
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_set_cha_rb(iQueMax,pRbWCtl,RbWCtlPA,RbPriCtlPA)
int    iQueMax;
tdtRB_CTL *pRbWCtl, *RbWCtlPA[], *RbPriCtlPA[];
{
	pSD_PACKET_TABLE pSdNext;
	int iQTbl;
	tdtRB_CTL *pRb;

DEBUGOUTL1(AKB_LOG_GROUP|254,"akbSetRChaRb: Called iQueMax=%d",iQueMax);

	while (pSdNext=(pSD_PACKET_TABLE)akxs_rb_get_n(pRbWCtl)) {
		iQTbl = pSdNext->sp_ch;

DEBUGOUTL1(AKB_LOG_GROUP|250,"akbSetRChaRb: Ch=%d",iQTbl);

		if (iQTbl<0 || (iQueMax>=0 && iQTbl>=iQueMax)) {
			ERROROUT1("akb_set_cha_rb: invalid iCh=%d",pSdNext->sp_ch);
			Free(pSdNext->sp_content);
			Free(pSdNext);
			continue;
		}
		if (akb_is_set_priority(pSdNext)) {
			if (!(pRb=RbPriCtlPA[iQTbl])) {
				pRb = akxs_rb_new(0,0);
				RbPriCtlPA[iQTbl] = pRb;
			}
		}
		else {
			if (!(pRb=RbWCtlPA[iQTbl])) {
				pRb = akxs_rb_new(0,0);
				RbWCtlPA[iQTbl] = pRb;
			}
		}
		akxs_rb_set_n(pRb,pSdNext);
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_wqset_rcha_rbi(ptt,pWriteQue,pRbWCtl,pRbRCtl,pRbWCtlPA,pRbPriCtlPA)
struct timeval *ptt;
tdtRW_QUE *pWriteQue;
tdtRB_CTL *pRbWCtl,*pRbRCtl;
tdtRB_CTL *pRbWCtlPA, *pRbPriCtlPA;
{
	pSD_PACKET_TABLE pSdNext;
	int iRc;

DEBUGOUTL3(AKB_LOG_GROUP|254,"akb_wqset_rcha_rbi: iSd=%d lToRWLen=%d iOption=%08x",
pWriteQue->rwq_sd,pWriteQue->rwq_torwlen,pWriteQue->rwq_option);

	if (pWriteQue->rwq_torwlen == 0) {
		if (!(pSdNext=(pSD_PACKET_TABLE)akxs_rb_get_n(pRbPriCtlPA))) {
			if (!(pSdNext=(pSD_PACKET_TABLE)akxs_rb_get_n(pRbWCtlPA))) {
				pWriteQue->rwq_option &= ~AKB_WQUE_OPT_CHA_RB_OBJ;
				return -1;
			}
		}
		if (pWriteQue->rwq_sd < 0) {	/* add 2000.8.8 Koba */
			ERROROUT1("akbWQueSetR2ChaRb: socket closed iCh=%d",pSdNext->sp_ch);
			akb_wqset_err_reply("akb_wqset_r2",pSdNext,pRbWCtl,pRbRCtl,
			                 D_ERR_SOCKET_CLOSED);
			return 1;
		}
		iRc = akb_wqset_make_xf(pWriteQue,pSdNext);
		if (iRc < 0) {
			akb_wqset_err_reply("akb_wqset_r2",pSdNext,pRbWCtl,pRbRCtl,
			                 D_ERR_FORM_CHANGE);
			return 1;
		}
		akb_set_write_que(pWriteQue,pSdNext);
#ifndef NO_RWQTIMEOUT
		akb_set_que_out_time(pWriteQue,ptt);
#endif
		Free(pSdNext);
		return 1;
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_wqset_rcha_rb(iUChain,offset,WriteQue,
                    pRbWCtl,pRbRCtl,RbWCtlPA,RbPriCtlPA)
int    iUChain[],offset;
tdtRW_QUE *WriteQue[];
tdtRB_CTL *pRbWCtl,*pRbRCtl;
tdtRB_CTL *RbWCtlPA[], *RbPriCtlPA[];
{
	tdtRW_QUE *pWriteQue;
	int i,ix,iMax,iQTbl,iRc,iRbWUsed,next,iChaRbFlg;
	struct timeval tt;

#ifndef NO_RWQTIMEOUT
	akxe_get_msec(NULL,&tt);
#endif
	i = iRbWUsed = iChaRbFlg = 0;
	iMax = next = -1;
	if (!iUChain) {
		ix = 0;
		iMax = offset;
		offset = 0;
	}
	else if (iUChain[0] >= 0) {
		ix = 1;
		next = iUChain[0];
	}
	else {
		ix = -1;
		iMax = iUChain[1];
	}

DEBUGOUTL4(AKB_LOG_GROUP|254,
"akb_wqset_rcha_rb: ix=%d iMax=%d offset=%d next=%d\n",ix,iMax,offset,next);

	for (;;) {
		if (ix > 0) {
			if (!next) break;
			iQTbl = next + offset;
			next = iUChain[next];
		}
		else {
			if (i >= iMax) break;
			iQTbl = i + offset;
			i++;
		}
DEBUGOUT2("akb_wqset_rcha_rb: next=%d iQTbl=%d",next,iQTbl);
		if (!(pWriteQue = WriteQue[iQTbl])) {
			ERROROUT("akbWQueSetRChaRb: pWriteQue is NULL");
		}
		else if (pWriteQue->rwq_option & AKB_WQUE_OPT_CHA_RB_OBJ) {
			akb_wqset_rcha_rbi(&tt,pWriteQue,pRbWCtl,pRbRCtl,
			                RbWCtlPA[iQTbl],RbPriCtlPA[iQTbl]);
			if (akxs_rb_get(RbPriCtlPA[iQTbl]) || akxs_rb_get(RbWCtlPA[iQTbl]))
				iRbWUsed++;
			else {
				pWriteQue->rwq_option &= ~AKB_WQUE_OPT_CHA_RB_OBJ;
			}
			iChaRbFlg |= pWriteQue->rwq_option & AKB_WQUE_OPT_CHA_RB_OBJ;
/*
printf("akb_wqset_rcha_rb: iQTbl=%d iRc=%d iRbWUsed=%d iChaRbFlg=%d iOption=%08x\n",iQTbl,iRc,iRbWUsed,iChaRbFlg,pWriteQue->rwq_option);
*/
		}
	}
	akb_set_rb_wused(iRbWUsed);
	akb_set_cha_rb_flg_timer(iRbWUsed+iChaRbFlg);
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_wqch_rb_set_r(WriteQue,pRbWCtl,pRbWWCtl,pRbRCtl,RbWCtlPA,RbPriCtlPA)
tdtRW_QUE *WriteQue[];
tdtRB_CTL *pRbWCtl,*pRbWWCtl,*pRbRCtl;
tdtRB_CTL *RbWCtlPA[], *RbPriCtlPA[];
{
	pSD_PACKET_TABLE   pSdNext, pNew;
	tdtRW_QUE *pWriteQue;
	int iQTbl, iRc;
	tdtRB_CTL *pRb;
	struct timeval tt;
	int iNWSelect,iChaRbFlg;

	iRc = iChaRbFlg = 0;
#ifndef NO_RWQTIMEOUT
	akxe_get_msec(NULL,&tt);
#endif
	iNWSelect = akb_get_nwselect();
	while (pSdNext=(pSD_PACKET_TABLE)akxs_rb_get_n(pRbWCtl)) {
		iQTbl = pSdNext->sp_ch;
		if (iQTbl<0) {
			ERROROUT1("akb_wqch_rb_set: invalid iCh=%d",iQTbl);
			Free(pSdNext->sp_content);
			Free(pSdNext);
			continue;
		}
		pWriteQue = WriteQue[iQTbl];
		if (pWriteQue->rwq_sd < 0) {	/* add 2000.8.8 Koba */
			ERROROUT1("akb_wqch_rb_set: socket closed iCh=%d",iQTbl);
			akb_wqset_err_reply("akb_wqch_rb_set",pSdNext,pRbWWCtl,pRbRCtl,
			                 D_ERR_SOCKET_CLOSED);
			if (pWriteQue->rwq_torwlen > 0) {
				pWriteQue->rwq_torwlen = 0;
				if (pWriteQue->rwq_buf) Free(pWriteQue->rwq_buf);
				pWriteQue->rwq_buf = NULL;
			}
			continue;
		}
		if ((pWriteQue->rwq_option & AKB_WQUE_OPT_CHA_RB_OBJ)/* || iNWSelect*/) {
			if (akb_is_set_priority(pSdNext)) {
				if (!(pRb=RbPriCtlPA[iQTbl])) {
					pRb = akxs_rb_new(0,0);
					RbPriCtlPA[iQTbl] = pRb;
				}
			}
			else {
				if (!(pRb=RbWCtlPA[iQTbl])) {
					pRb = akxs_rb_new(0,0);
					RbWCtlPA[iQTbl] = pRb;
				}
			}
			akxs_rb_set_n(pRb,pSdNext);
			akb_set_cha_rb_flg(1);
		}
		else {
			if (pWriteQue->rwq_torwlen == 0) {
				iRc = akb_wqset_make_xf(pWriteQue,pSdNext);
				if (iRc < 0) {
					akb_wqset_err_reply("akb_wqch_rb_set",pSdNext,pRbWWCtl,pRbRCtl,
					                 D_ERR_FORM_CHANGE);
					continue;
				}
				akb_set_write_que(pWriteQue,pSdNext);
#ifndef NO_RWQTIMEOUT
				akb_set_que_out_time(pWriteQue,&tt);
#endif
				Free(pSdNext);
				iRc = 1;
			}
			else {
/*
printf("akb_wqch_rb_set: write que used i=%d wait=%d p=%08x opt=%08x\n",
iQTbl,pWriteQue->rwq_tof,pWriteQue,pWriteQue->rwq_option);
*/
				if (!(pWriteQue->rwq_option & AKB_WQUE_OPT_NOT_CHA_RB)) {
					if (++(pWriteQue->rwq_tof) >= AKB_WQUE_MAX_WAIT) {
						pWriteQue->rwq_option |= AKB_WQUE_OPT_CHA_RB_OBJ;
					/*	akb_set_cha_rb_flg(++iChaRbFlg);	*/

printf("akb_wqch_rb_set: set AKB_WQUE_OPT_CHA_RB_OBJ i=%d wait=%d iChaRbFlg=%d\n",
iQTbl,pWriteQue->rwq_tof,iChaRbFlg);

						pWriteQue->rwq_tof = 0;
					}
				}
/*
printf("akb_wqch_rb_set: iQTbl=%d wait=%d iChaRbFlg=%d\n",
iQTbl,pWriteQue->rwq_tof,iChaRbFlg);
*/
				akxs_rb_set_n(pRbWWCtl,pSdNext);
			}
		}
	}
	if (akxs_rb_get(pRbWWCtl)) akxs_rb_exchg(pRbWCtl,pRbWWCtl,0);
/*
if (iChaRbFlg) printf("akb_wqch_rb_set: iChaRbFlg=%d\n",iChaRbFlg);
*/
	return iRc;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_wqset_rext(iUChain,offset,WriteQue,pRbWCtl,pRbWWCtl,pRbRCtl,
                  RbWCtlPA,RbPriCtlPA)
int    iUChain[],offset;
tdtRW_QUE *WriteQue[];
tdtRB_CTL *pRbWCtl,*pRbWWCtl,*pRbRCtl;
tdtRB_CTL *RbWCtlPA[], *RbPriCtlPA[];
{
	akb_wqch_rb_set_r(WriteQue,pRbWCtl,pRbWWCtl,pRbRCtl,RbWCtlPA,RbPriCtlPA);
	if (akb_get_cha_rb_flg())
		akb_wqset_rcha_rb(iUChain,offset,WriteQue,pRbWCtl,pRbRCtl,
	                    RbWCtlPA,RbPriCtlPA);
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_wqch_rb_set(WriteQue,pRbWCtl,pRbWWCtl,RbWCtlPA,RbPriCtlPA)
tdtRW_QUE *WriteQue[];
tdtRB_CTL *pRbWCtl,*pRbWWCtl;
tdtRB_CTL *RbWCtlPA[], *RbPriCtlPA[];
{
	return akb_wqch_rb_set_r(WriteQue,pRbWCtl,pRbWWCtl,NULL,RbWCtlPA,RbPriCtlPA);
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_ch_rb_packet_free(pRb)
tdtRB_CTL *pRb;
{
	tdtRCSD_PACKET_TABLE *pNew;

	if (!pRb) return -1;

	while (pNew=(pSD_PACKET_TABLE)akxs_rb_get_n(pRb)) akb_packet_tbl_free(pNew);
	
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_ch_rb_free(RbWCtlPA,iMax,iTbl,iOpt)
tdtRB_CTL *RbWCtlPA[];
int    iMax,iTbl,iOpt;
{
	tdtRB_CTL *pRbW;

	if (!RbWCtlPA) return -1;
	else if (iTbl < 0) return -2;
	else if (iMax>0 && iTbl>=iMax) return -3;

	if (pRbW=RbWCtlPA[iTbl]) {
		akb_ch_rb_packet_free(pRbW);
		if (iOpt & 0x01) {
			akxs_rb_free(pRbW);
			RbWCtlPA[iTbl] = NULL;
		}
	}

	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_wqch_rb_free(RbWCtlPA,RbPriCtlPA,iMax,iTbl,iOpt)
tdtRB_CTL *RbWCtlPA[], *RbPriCtlPA[];
int    iMax,iTbl,iOpt;
{
	int ret;

	if (!(ret=akb_ch_rb_free(RbWCtlPA,iMax,iTbl,iOpt)))
		ret = akb_ch_rb_free(RbPriCtlPA,iMax,iTbl,iOpt);
	return ret;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_wqch_rb_saved_check(WriteQue,RbWCtlPA,RbPriCtlPA,iMax,iTbl)
tdtRW_QUE *WriteQue[];
tdtRB_CTL *RbWCtlPA[], *RbPriCtlPA[];
int    iMax,iTbl;
{
	if (!RbWCtlPA || !RbPriCtlPA) return -1;
	else if (iTbl < 0) return -2;
	else if (iMax>0 && iTbl>=iMax) return -3;

	if (akxs_rb_get(RbPriCtlPA[iTbl]) || akxs_rb_get(RbWCtlPA[iTbl])) {
		WriteQue[iTbl]->rwq_option |= AKB_WQUE_OPT_CHA_RB_OBJ;
		akb_set_rb_wused(1);
		akb_set_cha_rb_flg_timer(1);
	}
	return 0;
}
