static	char	sccsid[]="%Z% %M% %I% %D% %T%";
/*********************************************************/
/*								*/
/*	name service						*/
/*								*/
/*		coded   by A.Kobayashi	1992.02.21		*/
/*		updated by A.Kobayashi	1992.07.06		*/
/*		updated by A.Kobayashi	1996.01.25		*/
/*		updated by A.Kobayashi	1996.06.07		*/
/*								*/
/*********************************************************/

#include	"akbcommon.h"

int akb_gs_akb_name2(cpBlock,cpName,cpArg,size)
char *cpBlock,*cpName,*cpArg;
int  size;
{
	char *argv[2];
	int n;

	if (!cpArg || size<=0) return -1;
	n = akb_gs_akb_stpl(cpBlock,cpName,argv,2);
	if (n != 2) {
		*cpArg = '\0';
		if (n >=0) n = -1;
		return n;
	}
	strnzcpy(cpArg,argv[1],size-1);
	return strlen(cpArg);
}

int akb_gs_akb_name(cpBlock,cpName,cpArg)
char *cpBlock,*cpName,*cpArg;
{
	return akb_gs_akb_name2(cpBlock,cpName,cpArg,D_RECORD_BUFSIZE);
}

int akbgetakbservname(cpProcName,service)
char *cpProcName,*service;
{
	int n;

	n = akb_gs_akb_name(BLK_SERVICE,cpProcName,service);
	if (n <= 0) {
		PRINTOUTL2(250,"akbgetakbservname : not found %s in %s",cpProcName,akb_akb_inf(0));
		*service = 0;
		return -1;
	}
	return (n);
}

char *akb_akb_home(iReSet)
int iReSet;
{
	static int iAkbHome=1;
	static char *cpHome=NULL;
	char *p;

	if (iAkbHome || iReSet) {
		iAkbHome = 0;
		if (cpHome) Free(cpHome);
		if (p = getenv(AKB_HOME)) {
			cpHome = Strdup(p);
		}
		else cpHome = p;
#ifdef DEBUG
printf("akb_akb_home:%s\n",cpHome);
#endif
	}
	return cpHome;
}

char *akb_akb_home_add(cpFile)
char *cpFile;
{
	static char *cpPath=NULL;
	char *p;

	p = akxt_add_dir2(akb_akb_home(0),cpFile,&cpPath);
	if (!p) p = cpFile;
	return p;
}

#define OLD_GSAKBNAPL_MAXARGV
#define D_GSAKBNAPL_MAXARGV	128	/* 32 */
#define D_GSAKBNAPL_INTERVAL	30
typedef struct {
#ifndef FIXED_CHECH_LEN
	int  len;
#endif
	int  Nn;
	int  Nm;	/* add 2001.6.15 Koba */
	char buf[D_RECORD_BUFSIZE];
} qNaplCtl;

int akb_gs_akb_stpl(cpBlock,cpName,argv,maxargv)
char *cpBlock,*cpName,**argv;
int  maxargv;
{
	return akb_gs_akb_stpli(cpBlock,1,cpName,argv,maxargv);
}

int akb_gs_akb_stpli(cpBlock,colm,cpName,argv,maxargv)
char *cpBlock,*cpName,**argv;
int  maxargv,colm;
{
	return akb_gs_akb_stplix(cpBlock,colm,cpName,argv,maxargv,3);
}

static int _set_argv(pNt,argv)
qNaplCtl *pNt;
char **argv;
{
	int i,n,m;
	char *p;

	n = pNt->Nn;
	m = pNt->Nm;
	p = pNt->buf;
	for (i=0;i<m;i++) {
		argv[i] = p;
		p += strlen(p);
		if (i < n) p++;
	}
/*
printf("_set_argv: n=%d, m=%d, qNt.len=%d\n",n,m,pNt->ha_keylen);
for (i=0;i<m;i++) printf("get: i=%d, argv=[%s]\n",i,argv[i]);
*/
	return n;
}

int akb_gs_akb_stplix(cpBlock,colm,cpName,argv,maxargv,opt)
char *cpBlock,*cpName,**argv;
int  maxargv,colm,opt;
{
	int n, ret, i, len, m, optw;
	char key[D_RECORD_BUFSIZE],*cpPath,*p;
	static tdtCACHE_CTL_HEAD *pCH=NULL;
	tdtCACHE_CTL qCt;
	qNaplCtl *pNt;
	static qNaplCtl qNt;

	if (opt & AKX_GSSTPLX_CACHE_INVALID) {
		ret = akxa_gs_fopen_free();
		if (pCH) {
			ret = akxs_cache_free(pCH);
			pCH = NULL;
		}
		return ret;
	}
	if (cpPath=akb_akb_home_add(akb_akb_inf(0))) {
		ret = 0;
		if (maxargv <= D_GSAKBNAPL_MAXARGV) {
			if (!pCH) {
				pCH = akxs_cache_new(20);
				if (pCH) pCH->ch_interval = D_GSAKBNAPL_INTERVAL;
			}
			if (pCH) ret = 1;
		}
		if (ret) {
			pCH->ch_opt |= 0x04;
#ifdef FIXED_CHECH_LEN
			pCH->ch_cshlen = sizeof(qNaplCtl);
#else
			pCH->ch_cshlen = -1;
#endif
			sprintf(key,"%s.%d.%s.%d",cpBlock,colm,cpName,maxargv);
			ret = akxs_cache_chk(pCH,key,&qCt);
/*
printf("akb_gs_akb_stplix: CacheChk key=[%s] ret=%d\n",key,ret);
*/
			if (ret) {
				optw = opt;
				if (ret > 0) optw |= AKX_GSFOPEN_CACHE_INVALID;
				m = maxargv;	/* add 2001.6.15 Koba */
				n = akxa_gs_stplix(cpPath,cpBlock,colm,cpName,argv,maxargv,
				                qNt.buf,sizeof(qNt.buf),optw);
#if 1	/* 2000.12.18 Koba rsǎΉ */
				if (n == 0) {
					n = akxa_gs_stplix(cpPath,cpBlock,colm,cpName,argv,maxargv,
					                qNt.buf,sizeof(qNt.buf),opt);
				}
#endif
/*
printf("akb_gs_akb_stplix: %s %s in %s, n=%d\n",cpBlock,cpName,cpPath,n);
*/
				if (n >= 0) {
					qNt.Nn = n;
					qNt.Nm = m;
					qCt.ca_data = (char *)&qNt;
#ifndef FIXED_CHECH_LEN
					qNt.len = sizeof(int)*2;
/*
printf("akb_gs_akb_stpl:set: n=%d, name=[%s]\n",n,cpName);
*/
					for (i=0;i<m;i++) { /* n --> m */
						qNt.len += strlen(argv[i]) + 1;
/*
printf("set: i=%d, qNt.len=%d, argv=[%s]\n",i,qNt.len,argv[i]);
*/
					}
/*
printf("akb_gs_akb_stplix:set: qNt.len=%d\n",qNt.len);
*/
#endif
					if (ret == -22) {	/* Key o^*/
						qCt.ca_key  = key;
						qCt.ca_cmp1 = cpPath;
						i = akxs_cache_set(pCH,&qCt);
/*
printf("akb_gs_akb_stplix:set1: ret=%d i=%d\n",ret,i);
*/
					}
					else if (ret > 0) {		/* LbV*/
						i = akxs_cache_set(pCH,&qCt);
/*
printf("akb_gs_akb_stplix:set2: ret=%d i=%d\n",ret,i);
*/
						if (i<0) akxs_cache_del(pCH,key);
/*
printf("akb_gs_akb_stplix:set3: ret=%d i=%d\n",ret,i);
*/
					}
				/*
					else return ret;
					if (i < 0) return i;
				*/
/*
printf("akb_gs_akb_stplix: CacheSet n=%d,i=%d key=[%s]\n",pCH->ch_imax,i,key);
*/
					if (i > 0) {
						ret = akxs_cache_get(pCH,i,&qCt);
						if (!ret) {
							_set_argv(qCt.ca_data,argv);
						}
					}
				}
			}
			else {
				n = _set_argv(qCt.ca_data,argv);
			}
		}
		else
			n = akxa_gs_stplix(cpPath,cpBlock,colm,cpName,argv,maxargv,
			                qNt.buf,sizeof(qNt.buf),opt);
	}
	else n = -2;
/*
printf("akb_gs_akb_stplix:Exit n=%d\n",n);
*/
	return n;
}

/************************************************************/
/*                                                          */
/************************************************************/
char *akb_get_proc_name(iPid,cpProcName)
int  iPid;
char *cpProcName;
{
	static char *argv[2];
	int iRc;
	char buf[12];

	sprintf(buf,"%d",iPid);
	iRc = akb_gs_akb_stpli(BLK_PROCESS,2,buf,argv,2);
/*
printf("akb_get_proc_name:iRc=%d\n",iRc);
*/
	if (iRc > 0) {
		if (cpProcName) strcpy(cpProcName,argv[0]);
		else cpProcName = argv[0];
	}
	else {
		if (cpProcName) strcpy(cpProcName,buf);
		else cpProcName = NULL;
	}
/*
printf("akb_get_proc_name:cpProcName=0x%08x\n",cpProcName);
if (cpProcName) printf("akb_get_proc_name:cpProcName=%s\n",cpProcName);
*/
	return cpProcName;
}

/************************************************************/
/*                                                          */
/************************************************************/
char *akb_akb_inf(iReSet)
int iReSet;
{
	static int icpIni=1;
	static char *cpIni=NULL;
	char *p;

	if (icpIni || iReSet) {
		icpIni = 0;
		if (!(p=getenv(AKB_INI))) p = AKBINI;
		if (cpIni) Free(cpIni);
		cpIni = Strdup(p);
#ifdef DEBUG
printf("akb_akb_inf:%s\n",cpIni);
#endif
	}
	return cpIni;
}

/************************************************************/
/*                                                          */
/************************************************************/
int akb_get_proc_id(cpProcName)
char *cpProcName;
{
	int iRc,iVal;
	char c,*argv[2];

	if (!cpProcName) return -1;

	if ((c=*cpProcName)>='0' && c<='9') {
		if (iRc=akxcgcvn(cpProcName,strlen(cpProcName),&iVal)) return -1;
		if (iVal<=0 || iVal>USHRT_MAX) return -1;
		return iVal;
	}
	iRc = akb_gs_akb_stpl(BLK_PROCESS,cpProcName,argv,2);
	if (iRc >= 2) {
		iRc = atoi(argv[1]);
	}
	else if (iRc >= 0) {
		iRc = -1;
	}
	return iRc;
}

/************************************************************/
/*                                                          */
/************************************************************/
int akb_get_proc_name2(iPid,cpProcName)
int  iPid;
char *cpProcName;
{
	int iRc;
	char *argv[2],buf[12];

	if (cpProcName) *cpProcName = '\0';
	sprintf(buf,"%d",iPid);
	iRc = akb_gs_akb_stpli(BLK_PROCESS,2,buf,argv,2);
	if (iRc > 0) {
		if (cpProcName) strcpy(cpProcName,argv[0]);
		iRc = strlen(argv[0]);
	}
	return iRc;
}

/************************************************************/
/*                                                          */
/************************************************************/
int akb_get_proc_name3(iPid,cpDefalt,cppProcName)
int  iPid;
char *cpDefalt,**cppProcName;
{
	int len;
	char *p,*cpName;

	if (!cppProcName) return -1;
	p = akb_get_proc_name(iPid,NULL);
/*
printf("akb_get_proc_name3:iPid=%d cpProcName=0x%08x\n",iPid,p);
if (p) printf("akb_get_proc_name3:cpProcName=%s\n",p);
*/
	if (!p) {
		if (cpDefalt) p = cpDefalt;
		else return 0;
	}
	len = strlen(p) + 1;
	cpName = *cppProcName;
	if (cpName) {
		cpName = Realloc(cpName,len);
	}
	else {
		cpName = Malloc(len);
	}
	if (!cpName) return -2;
	strcpy(cpName,p);
	*cppProcName = cpName;
	return len;
}

/************************************************************/
/*                                                          */
/************************************************************/
int akb_get_apsys_id(cpAPSysName,parm)
char *cpAPSysName;
INT4 parm[];
{
	int n,iRc,ret;
	char *argv[3];

	if (!cpAPSysName || !parm) return -1;

	parm[0] = parm[1] = 0;
	iRc = akb_gs_akb_stpl(BLK_HOSTCONNECT,cpAPSysName,argv,3);
	if (iRc >= 3) {
		parm[1] = akb_get_port_no(argv[2]);
	}
	if (iRc >= 2) {
		ret = akb_get_host_addr(argv[1],&parm[0]);
		if (ret < 0) iRc = ret;
	}
	if (iRc > 0) iRc--;
	return iRc;
}

/************************************************************/
/*                                                          */
/************************************************************/
int akb_gs_akb_stpl_func(namv,sep,order,argv,maxargv,pFunc,user_area)
char **namv,sep,**argv,*order,*user_area;
int  maxargv;
int (*pFunc)();
{
	char *cpBlock,*name1,*name2;
	char work[128],*key,c1,c2,*section,*na1,*na2,*p;
	int  n_order,len1,len2,n,i;

	cpBlock = namv[0];
	name1   = namv[1];
	name2   = namv[2];
	if (!name1) name1 = "";
	if (!name2) name2 = "";
/*
printf("akb_gs_akb_stpl_func: section=[%s] name1=[%s] name2=[%s]\n",cpBlock,name1,name2);
*/
	if (name1 && name2 && *name1 && *name2) {
		if (!order) return -1;
		if ((len1=strlen(name1))+(len2=strlen(name2))+2 >= sizeof(work))
			return -2;
		n_order = (strlen(order)+1)/2;
		for (i=0;i<n_order;i++) {
			c1 = *order++;
			c2 = *order++;
			section = cpBlock;
			switch (c1) {
			case '1':
				key = name1;
				na1 = name1;
				na2 = NULL;
				break;
			case '2':
				memcpy(work,name1,len1);
				p = work + len1;
				if (sep) {
					*p++ = sep;
				}
				memcpy(p,name2,len2+1);
				key = work;
				na1 = name1;
				na2 = name2;
				break;
			case '3':
				memcpy(work,name2,len2);
				p = work + len2;
				if (sep) {
					*p++ = sep;
				}
				memcpy(p,name1,len1+1);
				key = work;
				na1 = name2;
				na2 = name1;
				break;
			case '4':
				if (strcmp(cpBlock,name1)) {
					section = name1;
					key = name2;
					na1 = name2;
					na2 = NULL;
				}
				else c1 = '\0';
				break;
			default:
				c1 = '\0';
			}
			if (c1) {
/*
printf("akb_gs_akb_stpl_func:c1=%c c2=%c section=[%s] key=[%s] na1=[%s] na2=[%s]\n",
c1,c2,section,key,na1,na2);
*/
				if ((n=akb_gs_akb_stpli(section,1,key,argv,maxargv)) > 0) {
					if (pFunc) {
						n = pFunc(c1,section,na1,na2,argv,n,user_area);
						if (n<0 || c2=='-' || (c2=='?' && n==0)) break;
					}
					else if (c2 != '+') break;
				}
				else if (n < 0) break;
			}
		}
		return n;
	}
	else if (name1 && *name1) key = name1;
	else if (name2 && *name2) key = name2;
	else return -1;
/*
printf("akb_gs_akb_stpl_func: section=[%s] key=[%s]\n",cpBlock,key);
*/
	n = akb_gs_akb_stpli(cpBlock,1,key,argv,maxargv);
	if (n>0 && pFunc) pFunc('0',cpBlock,key,NULL,argv,n,user_area);
/*
printf("akb_gs_akb_stpl_func:Exit n=%d\n",n);
*/
	return n;
}

#if 0
int akbXXakbnapl(opt,namev,maxnamev,sep,argv,maxargv)
char **namev,*sep,**argv;
int  opt,maxnamev,maxargv;
{
	char buf[256],*p,c,sepc;
	int  i,iRc;

	sepc = '\0';
	if (opt == 0) {
		strcpy(buf,namev[1]);
		p = buf;
		for (i=2;i<maxnamev;i++) {
			p += strlen(p);
			if (c = *sep) {
				sepc = c;
				sep++;
			}
			if (sepc && sepc!=' ') *p++ = sepc;
			strcpy(p,namev[i]);
		}
	}
	return iRc;
}
#endif
/************************************************************/
/*      Old Source                                          */
/************************************************************/
#if 0
typedef struct {
#ifndef FIXED_CHECH_LEN
	int len;
#endif
	int  Nn;
	int  Nm;	/* add 2001.6.15 Koba */
	char *Nargv[D_GSAKBNAPL_MAXARGV];
	char wrk[D_RECORD_BUFSIZE];
	char buf[D_RECORD_BUFSIZE];
} qNaplCtl;

int akb_gs_akb_stplix(cpBlock,colm,cpName,argv,maxargv,opt)
char *cpBlock,*cpName,**argv;
int  maxargv,colm,opt;
{
	int n, ret, i, len, m;
	char key[D_RECORD_BUFSIZE],*cpPath,*p;
	static qCacheCtlHead *pCH=NULL;
	tdtCACHE_CTL qCt;
	qNaplCtl *pNt;
	static qNaplCtl qNt;

	if (cpPath=akb_akb_home_add(akb_akb_inf(0))) {
#if 1	/* 2000.12.8 Koba */
		ret = 0;
		if (maxargv <= D_GSAKBNAPL_MAXARGV) {
			if (!pCH) {
				pCH = akxs_cache_new(20);
				if (pCH) pCH->ch_interval = D_GSAKBNAPL_INTERVAL;
			}
			if (pCH) ret = 1;
		}
		if (ret) {
#else
		if (pCH) {
#endif
			pCH->ch_opt |= 0x04;
#ifdef FIXED_CHECH_LEN
			pCH->ch_cshlen = sizeof(qNaplCtl);
#else
			pCH->ch_cshlen = -1;
#endif
#ifdef OLD_GSAKBNAPL_MAXARGV	/* 2000.12.8 Koba */
			sprintf(key,"%s.%d.%s.%d",cpBlock,colm,cpName,maxargv);
#else
			sprintf(key,"%s.%d.%s",cpBlock,colm,cpName);
#endif
			ret = akxs_cache_chk(pCH,key,&qCt);
#ifdef DEBUG
printf("akb_gs_akb_stplix: CacheChk key=[%s] ret=%d\n",key,ret);
#endif
			if (ret) {
#ifdef OLD_GSAKBNAPL_MAXARGV	/* 2000.12.8 Koba */
				if (maxargv>sizeof(qNt.Nargv)/sizeof(char *))
					maxargv = sizeof(qNt.Nargv)/sizeof(char *);
				m = maxargv;	/* add 2001.6.15 Koba */
				n = akxa_gs_stplix(cpPath,cpBlock,colm,cpName,argv,maxargv,
				                qNt.buf,sizeof(qNt.buf),opt);
#else
				n = akxa_gs_stplix(cpPath,cpBlock,colm,cpName,
				                qNt.Nargv,D_GSAKBNAPL_MAXARGV,
				                qNt.buf,sizeof(qNt.buf),opt);
#endif
#if 1	/* 2000.12.18 Koba rsǎΉ */
				if (n == 0) {
#ifdef OLD_GSAKBNAPL_MAXARGV	/* 2000.12.8 Koba */
					n = akxa_gs_stplix(cpPath,cpBlock,colm,cpName,argv,maxargv,
					                qNt.buf,sizeof(qNt.buf),opt);
#else
					n = akxa_gs_stplix(cpPath,cpBlock,colm,cpName,
					                qNt.Nargv,D_GSAKBNAPL_MAXARGV,
					                qNt.buf,sizeof(qNt.buf),opt);
#endif
				}
#endif
/*
printf("akb_gs_akb_stplix: %s %s in %s, n=%d\n",cpBlock,cpName,cpPath,n);
*/
				if (n < 0) return n;
				else {
					qNt.Nn = n;
					qNt.Nm = m;
#ifdef OLD_GSAKBNAPL_MAXARGV	/* 2000.12.8 Koba */
					memcpy(qNt.Nargv,argv,sizeof(char *)*m); /* n --> m */
#endif
					qCt.ca_data = (char *)&qNt;
#ifndef FIXED_CHECH_LEN
					qNt.len = 0;
/*
printf("akb_gs_akb_stpl:set: n=%d, name=[%s]\n",n,cpName);
*/
					for (i=0;i<m;i++) { /* n --> m */
#ifdef OLD_GSAKBNAPL_MAXARGV	/* 2000.12.8 Koba */
						qNt.len += strlen(argv[i]) + 1;
#else
						qNt.len += strlen(qNt.Nargv[i]) + 1;
#endif
/*
printf("set: i=%d, qNt.len=%d, argv=[%s]\n",i,qNt.len,argv[i]);
*/
					}
					memcpy(&qNt.Nargv[m],qNt.buf,qNt.len); /* n --> m */
					qNt.len += sizeof(int)*2 + sizeof(char *)*m; /* n --> m */
/*
printf("akb_gs_akb_stplix:set: qNt.len=%d\n",qNt.len);
*/
#endif
					if (ret == -22) {	/* Key o^*/
						qCt.ca_key  = key;
						qCt.ca_cmp1 = cpPath;
						i = akxs_cache_set(pCH,&qCt);
					}
					else if (ret > 0) {		/* LbV*/
						i = akxs_cache_set(pCH,&qCt);
						if (i<0) akxs_cache_del(pCH,key);
					}
					else return ret;
					if (i < 0) return i;
#ifdef DEBUG
printf("akb_gs_akb_stplix: CacheSet n=%d,i=%d key=[%s]\n",pCH->ch_imax,i,key);
#endif
				}
			}
			else {
			/* Nargv̓éAqNt.buf̒wĂ̂qNtɖ߂Ȃ
			   eoȂ*/
			/*
				pNt = (qNaplCtl *)qCt.ca_data;
				n = pNt->Nn;
				memcpy(argv,pNt->Nargv,sizeof(char *)*n);
			*/
#ifdef FIXED_CHECH_LEN
				memcpy((char *)&qNt,qCt.ca_data,sizeof(qNaplCtl));
#else
				memcpy((char *)&qNt.len,qCt.ca_data,sizeof(int));
				memcpy(&qNt.Nn,qCt.ca_data+sizeof(int),qNt.len);
				qNt.len -= (sizeof(int)*2 + sizeof(char *)*qNt.Nm);
				memcpy(qNt.buf,&qNt.Nargv[qNt.Nm],qNt.len);
/*
printf("akb_gs_akb_stplix:get: n=%d, m=%d, qNt.len=%d\n",qNt.Nn,qNt.Nm,qNt.len);
for (i=0;i<qNt.Nm;i++) printf("get: i=%d, argv=[%s]\n",i,qNt.Nargv[i]);
*/
#endif
				n = qNt.Nn;
				m = qNt.Nm;
#ifdef OLD_GSAKBNAPL_MAXARGV	/* 2000.12.8 Koba */
				memcpy(argv,qNt.Nargv,sizeof(char *)*m); /* n --> m */
#endif
			}
#ifndef OLD_GSAKBNAPL_MAXARGV	/* 2000.12.8 Koba */
			if (n > maxargv) n = maxargv;
			memcpy(argv,qNt.Nargv,sizeof(char *)*n);
			if (n < maxargv) {
				if (n>0) {
					p = argv[n-1];
					p += strlen(p) + 1;
				}
				else p = qNt.buf;
				for (i=n;i<maxargv;i++) {
					argv[i] = p;
				}
			}
#endif
		}
		else
			n = akxa_gs_stplix(cpPath,cpBlock,colm,cpName,argv,maxargv,
			                qNt.buf,sizeof(qNt.buf),opt);
	}
	else n = -2;
#ifdef DEBUG
printf("akb_gs_akb_stplix: %s %s in %s, n=%d\n",cpBlock,cpName,cpPath,n);
#endif
	return n;
}
#endif
