static char sccsid[]="%Z% %M% %I% %E% %U%";
/*****************************************************/
/*                                                   */
/*       Database Interface Program for FILE         */
/*                                                   */
/*           coded by A.Kobayashi  2010.05.20        */
/*                                                   */
/*===================================================*/
/*         int   fil_init_engine()                   */
/*         int   fil_compile(bndp,sql,nobj,obj)      */
/*  static int   cmp_gtwd(sql,ssp)                   */
/*  static int   cmp_mkix(attr)                      */
/*  static int   cmp_name(bndp,name)                 */
/*         int   fil_ex_obj(rec,obj,iob)             */
/*         int   cmp_vchg(rst,rec)                   */
/*  static char *cmp_schg(rst,rec,w)                 */
/*         int   fil_to_dbcode(s,len,d)               */
/*  static int   strlike(ap,bp)                      */
/*  static int   mkmask(tpmaskctl0,uspat,lb)         */
/*  static int   undcmp(ap,la,ptn,lptn)              */
/*         char *fil_realloc(p,old_len,new_len)      */
/*         int   fil_ex_tree(is,tree,rec)            */
/*         int   fil_comp_judge(iKind,j)             */
/*  static int   _check_date(bndp,obj,da)            */
/*****************************************************/
#include "somn.h"
/*
#define DEBUG_EX
*/
#define OPTION 7
static char *cmp_schg();
/*
static char *hk[]={"?","<>","><",">=","=>","<=","=<","!=","^=",NULL};
*/
static char *hk[]={"<>","><",">=","=>","<=","=<","==","==","!=","^=","&&","||",NULL};
static short act[9][9]={
	{99,-1,-1, 3, 3, 3, 3, 3,-1},	/*       */
	{ 2, 2,-1, 2, 2,-1, 2, 2,-1},	/*  (    */
	{-1, 4,-1, 3, 3, 3, 3, 3,-1},	/*  )    */
	{ 2, 2,-1, 3, 2, 2, 2, 2,-1},	/*  *,/  */
	{ 2, 2,-1, 3, 3, 2, 2, 2,-1},	/*  +-   */
	{ 2, 2,-1, 3, 3,-1, 2, 2,-1},	/*  =<> like */
	{ 2, 2,-1, 3, 3, 3, 3, 2,-1},	/*  &    */
	{ 2, 2,-1, 3, 3, 3, 3, 3,-1},	/*  |    */
	{ 1, 1,-1, 1, 1, 1, 1, 1,-1}	/*       */
};

static short jdg[7][3]={
	{1,0,1},	/*  !=  */
	{0,1,1},	/*  >=  */
	{1,1,0},	/*  <=  */
	{0,1,0},	/*  =   */
	{0,0,1},	/*  >   */
	{1,0,0}, 	/*  <   */
	{0,1,0}		/* like */
};

static int ida;
static char *da[FIL_MAX_DA];
static int ids, dstk[100];

static int   cmp_gtwd();
static int   cmp_mkix();
static int   cmp_name();
static char *cmp_schg();
static int   strlike();
static int   mkmask();
static int   undcmp();
static int _check_date();

int fil_init_engine()
{
	memset(da,0,FIL_MAX_DA*4);
	return 0;
}

int fil_compile(bndp,sql,nobj,obj)
SQLDA_FIL *bndp;
char *sql;
int nobj,obj[];
{
	SSP_S ssp;
	int i,sp,attr,attr0,stack[100],i1,i2,ac,iob;
	char w[256];
	int date_flg,data_cnt,ret;
/*
printf("compile: sql=[%s]\n",sql);
*/
	for (i=0;i<bndp->F;i++) bndp->Z[i] = 0;
	stack[0]=0;
	sp=1;
	attr=0;
	iob=0;
	ida=0;
	data_cnt=date_flg=0;
	ssp.sp=0;
	ssp.wd=w;
	for(;;) {
		attr0=attr;
		for(;;) {
			attr=cmp_gtwd(sql,&ssp);
/*
printf("compile:gtwd attr=%d, wd=[%s]\n",attr,ssp.wd);
*/
			if (attr==99) {
				attr=0;
			}
			else if (attr==98) return ERROR_SYNTAX;
			else if (attr==500) {
				if (ida >= FIL_MAX_DA) return ERROR_MAX_DA;
				if (da[ida]) {
					if (!(da[ida]=Realloc(da[ida],strlen(ssp.wd)+1)))
						return ERROR_MALLOC;
				}
				else {
					if (!(da[ida]=Malloc(strlen(ssp.wd)+1)))
						return ERROR_MALLOC;
				}
				strcpy(da[ida],ssp.wd);
				attr += ++ida;
			}
			else if (attr==100) {
				attr=cmp_name(bndp,ssp.wd);
				if (attr<0) return attr;
				attr += 100;
#if 1	/* 1999.7.13 Koba */
				if (attr <= 200) {
					if (bndp->T[attr-101] == TYPE_FIL_DATE) date_flg=1;
/*
printf("compile:attr=%d, T=%d\n",attr,bndp->T[attr-101]);
*/
				}
#endif
			}
			else if (attr==7 || attr==8 || attr==9) {
				if (attr0<=1 || (attr0>=11 && attr0<=30)) {
					if (attr==7) continue;
					else attr= -attr;
				}
			}
			break;
		}
		i2=cmp_mkix(attr);
		for(;;) {
			if (sp<1) return ERROR_SYNTAX;
			i1=cmp_mkix(stack[sp-1]);
			ac=act[i2][i1];
/*
printf("compile:act i1=%d, i2=%d, ac=%d\n",i1,i2,ac);
*/
			if (ac<0) return ERROR_SYNTAX;
			else if (ac == 99) {
				if (iob >= nobj) return ERROR_MAX_OBJ;
				obj[iob++]=ac;
				return iob;
			}
			else if (ac == 1) {
				if (iob+1 >= nobj) return ERROR_MAX_OBJ;
				obj[iob++]=31;
				obj[iob++]=attr;
				data_cnt++;
			}
			else if (ac == 2) {
				stack[sp++]=attr;
			}
			else if (ac == 3) {
				if (iob >= nobj) return ERROR_MAX_OBJ;
				if (sp<1) return ERROR_SYNTAX;
				obj[iob++]=stack[--sp];
/*
printf("compile:data_cnt=%d\n",data_cnt);
*/
#if 1	/* 1999.7.15 Koba */
				if (data_cnt >= 2) {
					if ((ret=_check_date(bndp,obj+iob-5,da)) < 0)
						return ERROR_DATE_FORMAT;
				}
#endif
				date_flg=0;
				data_cnt=0;
				continue;
			}
			else if (ac == 4) {
					sp--;
			}
			else {
				return ERROR_SYNTAX;
			}
			break;
		}
	}
}

static int cmp_gtwd(sql,ssp)
char *sql;
SSP_S *ssp;
{
	static char sep[]={" \t'+-*/&|=^!<>(),;"};
	int len,atr,i;
	char wk[3],c,*p;

	atr=0;
	len = axtgwse(sql,ssp,sep,OPTION);
/*
printf("cmp_gtwd: ssp->wd=[%s]\n",ssp->wd);
*/
	if (len>0 || ssp->attr[0]>0) {
/*
	if (len >= 0) {
*/
		if ((atr=ssp->attr[0]) < 10) {
			if (atr==1) {
				atr=100;
				if ((c=ssp->wd[0])>='0' && (c<='9')) atr=500;
				else if (!stricmp(ssp->wd,"null")) {
					ssp->wd[0]='\0';
					atr=500;
				}
				else if (!stricmp(ssp->wd,"like")) atr=17;
				else if (!stricmp(ssp->wd,"and")) atr=21;
				else if (!stricmp(ssp->wd,"or")) atr=22;
				else if (!stricmp(ssp->wd,"not")) atr=9;
				else if (!stricmp(ssp->wd,"is")) atr=14;
				else if (!stricmp(ssp->wd,"order") ||
				         !stricmp(ssp->wd,"group") ||
				         !stricmp(ssp->wd,"having")) atr=99;
			}
			else atr=500;
		}
		else if ((c=ssp->wd[0])==';') atr=99;
		else if (c==',') atr=98;
		else if (c=='(') atr=1;
		else if (c==')') atr=2;
	/*	else if (c=='^') atr=3;	*/
		else if (c=='*') atr=4;
		else if (c=='/') atr=5;
		else if (c=='%') atr=6;
		else if (c=='+') atr=7;
		else if (c=='-') atr=8;
		else {
			wk[0]=c;
			wk[1]=sql[ssp->sp];
			wk[2]='\0';
#if 0
			for(i=1,p=hk[i];p=hk[i];i++) {
				if (!strcmp(wk,p)) {
					atr=((i+1)/2)+10;
					if (atr==14) atr=11;
					ssp->sp++;
					return atr;
				}
			}
#else
/*
printf("cmp_gtwd: wk=[%s]\n",wk);
*/
			for(i=0,p=hk[i];p=hk[i];i++) {
				if (!strcmp(wk,p)) {
					if (i < 10) {
						atr=(i/2)+11;
						if (atr==15) atr=11;
					}
					else atr=i+11;
					ssp->sp++;
					strcpy(ssp->wd,wk);
					return atr;
				}
			}
#endif
			if (c=='=') atr=14;
			else if (c=='>') atr=15;
			else if (c=='<') atr=16;
			else if (c=='&') atr=19;
			else if (c=='|') atr=20;
			else if (c=='!') atr=9;
			else if (c=='^') atr=3;
			else atr=500;
		}
	}
	return atr;
}

static int cmp_mkix(attr)
int attr;
{
	int atx,ix;

	if ((atx=attr)<0) atx = -atx;

	if (atx<=3) ix=atx;
	else if (atx<=5) ix=3;
	else if (atx<=10) ix=4;
	else if (atx<=20) ix=5;
	else if (atx<=22) ix=atx-15;
	else ix=8;

	return ix;
}

static int cmp_name(bndp,name)
SQLDA_FIL *bndp;
char *name;
{
	int i;

	for (i=0;i<bndp->F;i++) {
		if (!(stricmp(name,bndp->S[i]))) {
/*
printf("cmp_name: i=%d found name [%s]\n",i,name);
*/
			bndp->Z[i] = 1;
			if (bndp->T[i]==TYPE_FIL_INTEGER) i += 100;
			return (i+1);
		}
	}
/*
printf("cmp_name:not found name [%s]\n",name);
*/
	ERROROUTS("cmp_name:not found name [%s]",name);
	return ERROR_NOT_COLNAME;
}

int fil_ex_obj(rec,obj,iob)
char **rec;
int iob,obj[];
{
	int irs, rstk[100];
	int ib,mc,rdt,v,a,b,t,j;
	char *ap,*bp,w1[13],w2[13];

	ib=irs=ids=0;
	if (iob<1) return 1;
	while (ib<=iob) {
		mc = obj[ib++];
#ifdef DEBUG_EX
printf("cmp_ex:ib+1=%d,mc=%d\n",ib,mc);
#endif
		if (mc==99) {
			v = 1;
#ifdef DEBUG_EX
printf("cmp_ex:mc=%d,irs=%d\n",mc,irs);
#endif
			if (irs>1) return -1;
			else if (irs==1) {
#ifdef DEBUG_EX
printf("cmp_ex:mc=%d,rstk[%d]=%d\n",mc,irs-1,rstk[irs-1]);
#endif
#if 1	/* 96.4.15 Koba */
				if (rstk[irs-1] != 9001) return -1;
#endif
				if (v=cmp_vchg(rstk[--irs],rec)) v=1;
			}
			return v;
		}
		if (mc==31) {
			rstk[irs++]=obj[ib++];
#ifdef DEBUG_EX
printf("cmp_ex:mc=%d,rstk[%d]=%d\n",mc,irs-1,rstk[irs-1]);
#endif
		}
		else if (mc==32) {
			continue;
		}
		else if (mc==-8 || mc==-9) {
			if (irs<1) return -1;
			a = cmp_vchg(rstk[--irs],rec);
			if (mc == -8) a = -a;
			else a = !a;
			dstk[ids++] = a;
			rdt = 9001;
			rstk[irs++]=rdt;
#ifdef DEBUG_EX
printf("cmp_ex:mc=%d,rstk[%d]=%d,dstk[%d]=%d\n",mc,irs-1,rstk[irs-1],ids-1,dstk[ids-1]);
#endif
		}
		else if (mc>=1 && mc<=30) {
			if (mc<11 || mc==19 || mc==20) {
				if (irs<2) return -1;
				b=cmp_vchg(rstk[--irs],rec);
				a=cmp_vchg(rstk[--irs],rec);
#ifdef DEBUG_EX
printf("cmp_ex:a=%d, b=%d\n",a,b);
#endif
				switch (mc) {
					case 3:	v=a^b;break;
					case 4:	v=a*b;break;
					case 5:	if (b) v=a/b;
				        else   v=a;;
						break;
					case 6:	if (b) v=a%b;
					        else   v=a;
							break;
					case 7:	v=a+b;break;
					case 8:	v=a-b;break;
					case 19:v=a&b;break;
					case 20:v=a|b;break;
				}
			}
			else if (mc<21) {
				if (irs<2) return -1;
				if (rstk[irs-1]<=200 || rstk[irs-2]<=200) t=1;
				else t=2;
				if (t==1) {
					bp=cmp_schg(rstk[--irs],rec,w1);
					ap=cmp_schg(rstk[--irs],rec,w2);
#ifdef DEBUG_EX
printf("cmp_ex:ap=[%s], bp=[%s]\n",ap,bp);
#endif
					if(mc==17) {
						if ((a=strlike(ap,bp))<0) return -1;
					}
					else a=strcmp(ap,bp);
					if(a>0) j=2;
					else if (a<0) j=0;
					else j=1;
				}
				else {
					b=cmp_vchg(rstk[--irs],rec);
					a=cmp_vchg(rstk[--irs],rec);
#ifdef DEBUG_EX
printf("cmp_ex:a=%d, b=%d\n",a,b);
#endif
					if (a>b) j=2;
					else if (a<b) j=0;
					else j=1;
				}
				v = jdg[mc-11][j];
			}
			else if (mc<31) {
				if (irs<2) return -1;
				b=cmp_vchg(rstk[--irs],rec);
				a=cmp_vchg(rstk[--irs],rec);
#ifdef DEBUG_EX
printf("cmp_ex:a=%d, b=%d\n",a,b);
#endif
				v = 0;
				if (mc==21) {
				/*	v=a & b;	*/
					if (a && b) v = 1;
				}
				else {
				/*	v=a | b;	*/
					if (a || b) v = 1;
				}
			}
			else return -1;
			rdt = 9001;
			rstk[irs++]=rdt;
			dstk[ids++]=v;
#ifdef DEBUG_EX
printf("cmp_ex:mc=%d,rstk[%d]=%d,dstk[%d]=%d\n",mc,irs-1,rstk[irs-1],ids-1,dstk[ids-1]);
#endif
		}
		else break;
	}
	return -99;
}

int cmp_vchg(rst,rec)
int rst;
char **rec;
{
	int v;

	if (rst<=100) {
		ERROROUT1("cmp_vchg: rst=%d",rst);
		v=0;
	}
	else if (rst<=200) v=atoi(rec[rst-101]);
	else if (rst<=500) v=atoi(rec[rst-201]);
	else if (rst<=9000) v=atoi(da[rst-501]);
	else if (rst<=10000) v=dstk[--ids];
	else v = rst - 10000;
	return v;
}

static char *cmp_schg(rst,rec,w)
int rst;
char **rec;
char *w;
{
	char *s;
	int v;

	if (rst<=100) {
		ERROROUT1("cmp_schg: rst=%d",rst);
		*w='\0';
		s=w;
	}
	else if (rst<=200) s=rec[rst-101];
	else if (rst<=500) s=rec[rst-201];
	else if (rst<=9000) s=da[rst-501];
	else {
		if (rst<=10000) v=dstk[--ids];
		else v = rst - 10000;
		sprintf(w,"%d",v);
		s = w;
	}
	return s;
}

typedef struct {
	unsigned char stp;
	unsigned char len;
	unsigned char mpn;
	unsigned char und;
} tdMask;

typedef struct {
	short nptn;
	short slptn;
	unsigned short *uspPat;
	tdMask *tpmask;
} tdMaskCtl;

static int iNLike=0,iNextLike=0;
static tdMaskCtl tmaskctl[10];
static unsigned short *usap=NULL;

#define DB_OFFS	0x5f00
#define DB_UNDL	0x5f5f
#define DB_PARS 0x5f25

int fil_to_dbcode(s,len,d)
unsigned char *s;
int len;
unsigned short *d;
{
	int l=0;

	while (len-- > 0) {
		if (akxqiskanji(s)) {
			memcpy((char *)d,s,2);
			s++;
			len--;
		}
		else {
			if (*s) *d = *s | DB_OFFS;
			else *d = 0;
		}
		s++;
		d++;
		l++;
	}
	return l;
}

static int strlike(ap,bp)
char *ap,*bp;
{
	tdMaskCtl tmaskctl0;
	tdMask mask[20],*pmask;
	int i,n,la,lb,ltpn,la0,ipos;
	unsigned char stp0,mpn0,und0,lpn0;
	unsigned short *ap0,*ptn,*api;
	unsigned short uspat[256];
/*
printf("strlike:a=[%s] b=[%s]\n",ap,bp);
*/
	if (!strcmp(bp,"%")) return 0;
	la = strlen(ap);
	usap = (unsigned short *)fil_realloc(usap,0,(la+1)*2);
	if (!usap) return -1;
	la = fil_to_dbcode(ap,la+1,usap) - 1;
	lb = strlen(bp);
	lb = fil_to_dbcode(bp,lb+1,uspat) - 1;
/*
printf("strlike:ld=%d uspat=[%s]\n",lb,(char *)uspat);
*/
	for (i=0;i<iNLike;i++) {
		ptn = tmaskctl[i].uspPat;
/*
printf("strlike:i=%d ptn=[%s]\n",i,ptn);
*/
		if (ptn && tmaskctl[i].tpmask) {
			if (!strcmp((char *)uspat,(char *)ptn)) break;
		}
	}
	if (i>=iNLike) {
		tmaskctl0.nptn   = 20;
		tmaskctl0.tpmask = mask;
		i = mkmask(&tmaskctl0,uspat,lb);
		if (i<0) i = iNLike;
	}
	if (i<iNLike) {
		n     = tmaskctl[i].nptn;
		pmask = tmaskctl[i].tpmask;
		ltpn  = tmaskctl[i].slptn;
	}
	else {
		n     = tmaskctl0.nptn;
		pmask = tmaskctl0.tpmask;
		ltpn  = tmaskctl0.slptn;
	}
	api = usap;
	ipos = 0;
	for (i=0;i<n;i++) {
		lpn0 = pmask[i].len;
		if (pmask[i].mpn != 0 && lpn0 == pmask[i].und) continue;
		la0 = la - ltpn + lpn0 - ipos;
		ap0 = api;
		ptn = uspat + pmask[i].stp;
		switch (pmask[i].mpn) {
			case 0:
					if (lpn0 != la0) return 1;
					break;
			case 1:
					la0 = lpn0;
					break;
			case 2:
					ap0 += (la0 - lpn0);
					la0 = lpn0;
					break;
			case 3:
					break;
			default:
					return -1;
		}
		ipos = undcmp(ap0,la0,ptn,lpn0);
/*
printf("strlike:i=%d la0=%d ap0=[%s]\n",i,la0,ap0);
printf("        ipos=%d lpn0=%d ptn=[%s]\n",ipos,lpn0,ptn);
*/
		if (ipos<0) return 1;
		api += (ipos + lpn0);
	}
	return 0;
}

static int mkmask(tpmaskctl0,uspat,lb)
tdMaskCtl *tpmaskctl0;
unsigned short *uspat;
int lb;
{
	tdMask *mask,*pmask,*pmask_n;
	int maxmask;
	int i,n,ltpn,kpt;
	unsigned char stp0,mpn0,und0,lpn0;
	unsigned short *ptn,*ptn_n;

	mask = tpmaskctl0->tpmask;
	n = 0;
	ltpn = 0;
	stp0 = 0;
	mpn0 = 1;
	und0 = 0;
	for (i=0;i<lb;i++) {
		if (uspat[i]==DB_UNDL) und0++;
		else if (uspat[i]==DB_PARS) {
			lpn0 = i - stp0;
			ltpn += lpn0;
			mask[n].stp = stp0;
			mask[n].len = lpn0;
			mask[n].mpn = mpn0;
			mask[n].und = und0;
/*
printf("strlike:n=%d stp=%d len=%d mpn=%d und=%d\n",n,stp0,lpn0,mpn0,und0);
*/
			stp0 = i + 1;
			mpn0 = 3;
			und0 = 0;
			i++;
			n++;
		}
	}
	mask[n].stp = stp0;
	lpn0 = lb - stp0;
	ltpn += lpn0;
	mask[n].len = lpn0;
	mask[n].mpn = mpn0 - 1;
	mask[n].und = und0;
/*
printf("strlike:n=%d stp=%d len=%d mpn=%d und=%d\n",n,stp0,lpn0,mask[n].mpn,und0);
*/
	n++;
	tpmaskctl0->nptn   = n;
	tpmaskctl0->slptn  = ltpn;
	if (iNLike<10) {
		i = iNLike++;
		ptn   = NULL;
		pmask = NULL;
	}
	else {
		i = iNextLike++;
		if (iNextLike>=10) iNextLike = 0;
		ptn   = tmaskctl[i].uspPat;
		pmask = tmaskctl[i].tpmask;
	}
/*
printf("strlike:iNLike=%d iNextLike=%d\n",iNLike,iNextLike);
*/
	if (!(ptn_n=(unsigned short *)fil_realloc(ptn,0,(lb+1)*2))) {
		if (ptn) Free(ptn);
		tmaskctl[i].uspPat  = NULL;
		return -1;
	}
	if (!(pmask_n=(tdMask *)fil_realloc((char *)pmask,0,n*sizeof(tdMask)))) {
		if (pmask) Free(pmask);
		tmaskctl[i].tpmask = NULL;
		return -1;
	}
	strcpy((char *)ptn_n,(char *)uspat);
	memcpy(pmask_n,mask,n*sizeof(tdMask));
	tmaskctl[i].nptn   = n;
	tmaskctl[i].slptn  = ltpn;
	tmaskctl[i].uspPat = ptn_n;
	tmaskctl[i].tpmask = pmask_n;
	return i;
}

static int undcmp(ap,la,ptn,lptn)
unsigned short *ap,*ptn;
int la,lptn;
{
	unsigned short *pap,*pptn;
	int n,i,j;

	if (!lptn) return 0;
	n = la - lptn + 1;
	if (n <= 0) return -1;
	for (i=0;i<n;i++) {
		pap = ap;
		pptn = ptn;
		for (j=0;j<lptn;j++) {
			if ((*pptn != DB_UNDL) && (*pap != *pptn)) break;
			pap++;
			pptn++;
		}
		if (j>=lptn) return i;
		ap++;
	}
	return -1;
}

char *fil_realloc(p,old_len,new_len)
void *p;
int old_len,new_len;
{
	char *np;

	if (old_len<0 || new_len<=0) return NULL;
	if (!p) {
		if (np=Malloc(new_len)) {
			memset(np,0,new_len);	/* add 1997.6.30 Koba */
		}
	}
	else {
		if (old_len>new_len) return (char *)p;
		if (np=Malloc(new_len)) {
			memcpy(np,p,old_len);
			memset(np+old_len,0,new_len-old_len);	/* add 1997.6.30 Koba */
			Free(p);
		}
	}
	return np;
}

int fil_ex_tree(is,tree,rec)
int is;
WHERE_TREE *tree;
char **rec;
{
	int mc,i1,i2;
	int a1,a2;
	int a,b,j,v,t;
	char *ap,*bp,w1[13],w2[13];

	mc = tree[is].mcode;
	i1 = tree[is].t1;
	i2 = tree[is].t2;
#ifdef DEBUG_EX_TREE
printf("ex_tree:is=%d,mc=%d,i1=%d,i2=%d\n",is,mc,i1,i2);
#endif
	if (!i1) {
		a1 = 0;
	}
	else if (tree[i1].mcode) {
		a1 = 0;
	}
	else {
		a = tree[i1].t1;
		a1 = 1;
	}

	if (!i2) {
		a2 = 0;
	}
	else if (tree[i2].mcode) {
		a2 = 0;
	}
	else {
		b = tree[i2].t1;
		a2 = 1;
	}
	if (mc == 22) {	/* or */
#ifdef DEBUG_EX_TREE
printf("ex_tree:is=%2d,i1=%d,d1=%d,a1=%d\n",is,i1,a,a1);
printf("ex_tree:      i2=%d,d2=%d,a2=%d\n",i2,b,a2);
#endif
		if (a1) {
			if (cmp_vchg(a,rec)) return 1;
		}
		if (a2) {
			if (cmp_vchg(b,rec)) return 1;
		}
		if (!a1 && i1) {
			if (fil_ex_tree(i1,tree,rec)) return 1;
		}
		if (!a2 && i2) {
			if (fil_ex_tree(i2,tree,rec)) return 1;
		}
		return 0;
	}
	if (!a1 && i1) a = fil_ex_tree(i1,tree,rec);
	if (!a2 && i2) b = fil_ex_tree(i2,tree,rec);
#ifdef DEBUG_EX_TREE
printf("ex_tree:is=%2d,i1=%d,d1=%d,a1=%d\n",is,i1,a,a1);
printf("ex_tree:      i2=%d,d2=%d,a2=%d\n",i2,b,a2);
#endif
	if (mc<11) {
		if (a1) a=cmp_vchg(a,rec);
		if (a2) b=cmp_vchg(b,rec);
#ifdef DEBUG_EX_TREE
printf("ex_tree:a=%d, b=%d\n",a,b);
#endif
		switch (mc) {
		case 4:	v=a*b;break;
		case 5:	if (b) v=a/b;
		        else   v=a;;
				break;
		case 6:	v=a+b;break;
		case 7:	v=a-b;break;
		case -7:v= -b;break;
		}
	}
	else if (mc<21) {
		if ((a1 && a<=200) || (a2 && b<=200)) t=1;
		else t=2;
		if (t==1) {
			if (a1) ap=cmp_schg(a,rec,w1);
			else {
				sprintf(w1,"%d",a);
				ap = w1;
			}
			if (a2) bp=cmp_schg(b,rec,w2);
			else {
				sprintf(w2,"%d",b);
				bp = w2;
			}
#ifdef DEBUG_EX_TREE
printf("ex_tree:ap=[%s], bp=[%s]\n",ap,bp);
#endif
			if(mc==17) {
				if ((a=strlike(ap,bp))<0) return -1;
			}
			else a=strcmp(ap,bp);
			if(a>0) j=2;
			else if (a<0) j=0;
			else j=1;
		}
		else {
			if (a1) a=cmp_vchg(a,rec);
			if (a2) b=cmp_vchg(b,rec);
#ifdef DEBUG_EX_TREE
printf("ex_tree:a=%d, b=%d\n",a,b);
#endif
			if (a>b) j=2;
			else if (a<b) j=0;
			else j=1;
		}
		v = jdg[mc-11][j];
	}
	else if (mc<31) {
		if (a1) a=cmp_vchg(a,rec);
		if (a2) b=cmp_vchg(b,rec);
#ifdef DEBUG_EX_TREE
printf("ex_tree:a=%d, b=%d\n",a,b);
#endif
		v = 0;
		if (mc==21) {
		/*	v=a & b;	*/
			if (a && b) v = 1;
		}
		else {
		/*	v=a | b;	*/
			if (a || b) v = 1;
		}
	}
	else v = -1;
#ifdef DEBUG_EX_TREE
printf("ex_tree:v=%d\n",v);
#endif
	return v;
}

int fil_comp_judge(iKind,j)
int iKind,j;
{
	if (iKind<1 || iKind>7) iKind = 4;
	return jdg[iKind-1][j];
}

static int _check_date(bndp,obj,da)
SQLDA_FIL *bndp;
int   *obj;
char  **da;
{
	int ret=0,attr,date_is=0;
	char *s,wk[20];
/*
printf("_check_date:attr=%d\n",obj[4]);
*/
	if (obj[4] == 17) return 0;	/* like */	/* add 1999.11.2 Koba */
	
	attr = obj[1];
	if (attr < 200) {
		if (bndp->T[attr-101] == TYPE_FIL_DATE) date_is=3;
	}
	attr = obj[3];
	if (attr < 200) {
		if (bndp->T[attr-101] == TYPE_FIL_DATE) {
			if (date_is) return 0;
			date_is=1;
		}
	}
/*
printf("_check_date:date_is=%d\n",date_is);
*/
	if (date_is) {
		attr = obj[date_is];
		if (attr>=501 && attr<=9000) {
			*wk = '\0';
			s = da[attr-501];
			if (ret = fil_chk_date(s,wk)) return ret;
			if (strlen(s) < strlen(wk)) {
				if (!(s=Realloc(s,strlen(wk)+1))) return ERROR_MALLOC;
			}
			strcpy(s,wk);
			da[attr-501] = s;
/*
printf("_check_date:wk=[%s]\n",s);
*/
		}
	}
	return 0;
}

/******************************
main()
{
	SQLDA_FIL bind,select;
	char where[256],*s[3],*v[3];
	int i,ret,obj[100],iob;
	short t[3];

	bind.F=3;
	bind.T=t;
	bind.T[0]=1;
	bind.T[1]=2;
	bind.T[2]=2;
	bind.S=s;
	bind.S[0]="aaa";
	bind.S[1]="ccc";
	bind.S[2]="bbb";
	select.V=v;
	select.V[0]="XYZ";
	select.V[1]="100";
	select.V[2]="-200";
	select.T=t;
	select.T[0]=1;
	select.T[1]=2;
	select.T[2]=2;

	for(;;) {
		printf("Enter->");
		gets(where);
		iob=fil_compile(&bind,where,100,obj);
		printf("iob=%d\n",iob);
		for(i=0;i<iob;i++)
			printf("i=%3d obj=%10d\n",i,obj[i]);
		for(i=0;i<ida;i++)
			printf("i=%3d da =%s\n",i,da[i]);
		ret = fil_ex_obj(&select,obj,iob);
		printf("ret=%d\n",ret);
	}
}
***********************************************/
