static char sccsid[]="%Z% %M% %I% %E% %U%";
/*****************************************************/
/*                                                   */
/*       Database Interface Program for FILE         */
/*                                                   */
/*           coded by A.Kobayashi  96.05.28          */
/*                                                   */
/*===================================================*/
/*  int fil_cursor_open(cp)                          */
/*  int fil_fetch(cp)                                */
/* static int fil_fetch_rec_index(n,rec,lrec,tpix,irec)    */
/* static int fil_fetch_rec(fp,buf,buflen,n,rec,tpix,irec) */
/* static int fil_fetch_set(cp)                      */
/* static int fil_summary(cp)                        */
/* static int fil_summary_set(cp)                    */
/*  int fil_cursor_close(cp)                         */
/*  int fil_read_all(file,pv)                        */
/* static int fil_fetch_rec_index2(n,rec,lrec,M,tpix,irec) */
/* static int fil_fetch_rec_ctl(cp,bndp,tpix,irec,buf,buflen) */
/*****************************************************/
#include "somn.h"

extern SQLCA_FIL sqlca_fil;

static int fil_fetch_rec_index();
static int fil_fetch_rec();
static int fil_fetch_set();
static int fil_summary();
static int fil_summary_set();
static int fil_fetch_rec_index2();
static int fil_fetch_rec_ctl();

int fil_cursor_open(cp)
CURSOR *cp;
{
	SQLDA_FIL *bndp, *selp;
	int i,ix,type,l,ix1,ix2,j,k,ix3,ix4;
	int   *obj,nob,iop;

	sqlca_fil.sqlcode = 0;
/*
printf("fil_cursor_open:tblnam=[%s]\n",cp->tblnam);
*/
#ifdef FP_NULL
	if (!(cp->fp = fopen(cp->tblnam,"r"))) {
/*********
		sqlca_fil.sqlcode = ERROR_OPEN;
**********/
		return 0;
	}
#else
	l = strlen(cp->tblnam);
	if (l>4 && !strcmp(cp->tblnam+l-4,".mem")) cp->fp = NULL;
	else cp->fp = fopen(cp->tblnam,"r");
#endif
	bndp = cp->bind;
	selp = cp->select;
	if (!(cp->rec = (char **)Malloc(sizeof(char *)*bndp->F))) {
		sqlca_fil.sqlcode = ERROR_MALLOC;
		return ERROR_MALLOC;
	}
#if 0
	l = 0;
	for (i=0;i<bndp->F;i++) l += (bndp->L[i]+1);
	if (!(cp->rec[0] = Malloc(l))) {
		sqlca_fil.sqlcode = ERROR_MALLOC;
		return ERROR_MALLOC;
	}
	for (i=1;i<bndp->F;i++) {
		cp->rec[i] = cp->rec[i-1] + bndp->L[i-1]+1;
	}
#else
	if (!(cp->rec[0] = Malloc(bndp->L[0]+1))) {
		sqlca_fil.sqlcode = ERROR_MALLOC;
		return ERROR_MALLOC;
	}
#endif
	strcpy(cp->rec[0],"0");

	/* rowid݂̂̂Ƃ̍œK */
	/***********************************
		obj[0]
			...
		obj[nob-1] <-- ܂ŎsIuWFNg

		obj[nob  ] = ichk
		obj[nob+1] = x1   --> min
		obj[nob+2] = x2   --> max
		obj[nob+3] = iop
		obj[nob+4] = ix   --> ͒l

		obj[nob+5] = x1
		obj[nob+6] = x2
		obj[nob+7] = iop
		obj[nob+8] = ix   --> ͒l
	***********************************/

	if (cp->ixflg & IXFLG_IX_ROWID) {
		nob  = cp->nobj;
		obj  = cp->obj;
		obj[nob] = 0;
		k = nob + 1;
		for (j=3;j<nob;j+=5) {
			iop = obj[j+1];
			ix = cmp_vchg(obj[j],cp->rec);
			if (iop==FIL_WDATTR_GE || iop==FIL_WDATTR_GT) {
				ix1 = ix;
				ix2 = 0x7fffffff;
				if (iop==FIL_WDATTR_GT) ix1++;
			}
			else if (iop==FIL_WDATTR_LE || iop==FIL_WDATTR_LT) {
				ix1 = 1;
				ix2 = ix;
				if (iop==FIL_WDATTR_LT) ix2--;
			}
			else if (iop==FIL_WDATTR_EQ) {
				ix1 = ix2 = ix;
			}
			else {	/* != */
				ix1 = 1;
				ix2 = 0x7fffffff;
			}
/*
printf("fil_cursor_open:ix1=%d ix2=%d op=%d\n",ix1,ix2,iop);
*/
			obj[k++]=ix1;
			obj[k++]=ix2;
			obj[k++]=iop;
			obj[k++]=ix;
		}
		if (nob == 12) {
			k = nob + 1;
			ix1 = obj[k];
			ix2 = obj[k+1];
			ix3 = obj[k+4];
			ix4 = obj[k+5];
			if (ix1 < ix3) obj[k] = ix3;
			else obj[k] = ix1;
			if (ix2 < ix4) obj[k+1] = ix2;
			else obj[k+1] = ix4;
		}
		else {
			obj[k++]=0;
			obj[k++]=0;
			obj[k++]=0;
			obj[k++]=0;
		}
		if (obj[nob+2] < 0x7fffffff) obj[nob] = 1;
		sprintf(cp->rec[0],"%d",obj[nob+1]-1);
/*
printf("fil_cursor_open:ix1=%d ix2=%d chk=%d\n",obj[nob+1],obj[nob+2],obj[nob]);
*/
	}
/*
printf("fil_cursor_open:rec[0]=[%s]\n",cp->rec[0]);
*/
	sqlca_fil.sqlerrd[2] = 0;
	sqlca_fil.sqlerrd[3] = 0;

	fil_openindex(cp);

	cp->sumrec = NULL;	/* add 2000.11.27 Koba */
	if (cp->isflg) {
		if (!(cp->sumrec = (char **)Malloc(sizeof(char *)*selp->F))) {
			sqlca_fil.sqlcode = ERROR_MALLOC;
			return ERROR_MALLOC;
		}
		for (i=0;i<selp->F;i++) {
/*
printf("fil_cursor_open:i=%d M=%d\n",i,selp->M[i]);
*/
			if ((ix=selp->M[i])>0) {
				type = bndp->T[ix-1];
				l    = bndp->L[ix-1];
			}
			else {
				type = TYPE_FIL_CHAR;
				l    = selp->L[i];
			}
			if (!(cp->sumrec[i] = Malloc(l+1))) {
				sqlca_fil.sqlcode = ERROR_MALLOC;
				return ERROR_MALLOC;
			}
			switch (selp->C[i]) {
				case 1:	/* max */
					if (type == TYPE_FIL_INTEGER) {
						memset(cp->sumrec[i],0,4);
						*(cp->sumrec[i]) = 0x80;
					}
					else *(cp->sumrec[i]) = '\0';
					break;
				case 2:	/* min */
					if (type == TYPE_FIL_INTEGER) {
						memset(cp->sumrec[i],0xff,4);
						*(cp->sumrec[i]) = 0x7f;
					}
					else {
						memset(cp->sumrec[i],0xff,l);
						*(cp->sumrec[i]+l) = '\0';
					}
					break;
				case 3:	/* sum */
					if (type == TYPE_FIL_INTEGER)
						memset(cp->sumrec[i],0,4);
					break;
				case 4:	/* count */
					memset(cp->sumrec[i],0,4);
			}
		}
	}
	return 0;
}

int fil_fetch(cp)
CURSOR *cp;
{
	int ret,i,ihcnt,rowid_count_only,j,iccnt;
	SQLDA_FIL *bndp, *selp;
	char buf[4096];
	TABLECACHE *tptc;
	INDEX *tpix;
	int nob,*obj,iop1,iop2,ix1,ix2,ichk,ixmx,ixmn;

	bndp = cp->bind;
	selp = cp->select;

	if (tptc = cp->tptc) tpix = tptc->tpIndex;
	else tpix = NULL;

	if (!tpix) cp->ixflg = 0;	/* add 1999.11.10 Koba */

	rowid_count_only = 1;
	for (i=0;i<selp->F;i++) {
/*
printf("fil_fetch:i=%d M=%d C=%d\n",i,selp->M[i],selp->C[i]);
*/
		if (selp->M[i]!=1 && selp->C[i]!=4) {
			rowid_count_only = 0;
			break;
		}
	}
/*
printf("fil_fetch:isflg=%d nobj=%d tpix=%08x\n",cp->isflg,cp->nobj,tpix);
*/
	if (cp->isflg) {
		if (sqlca_fil.sqlerrd[2]) {
			sqlca_fil.sqlcode = 100;
			return 0;
		}
/*
		if (!cp->nobj && tpix) {
*/
		if ((!cp->nobj || (cp->ixflg & IXFLG_IX_ROWID)) && tpix) {
			if (rowid_count_only) {
/*
printf("fil_fetch:use index only for summary\n");
*/
				if (!cp->icflg && tpix->iUsed == 0) {
					sqlca_fil.sqlcode = 100;
					return 0;
				}
				if (cp->ixflg & IXFLG_IX_ROWID) {
					nob  = cp->nobj;
					obj  = cp->obj;
					ichk = obj[nob];
					ixmn = obj[nob+1];
					ixmx = obj[nob+2];
					iop1 = obj[nob+3];
					ix1  = obj[nob+4];
					iop2 = obj[nob+7];
					ix2  = obj[nob+8];
					if (ixmn < 1) ixmn = 1;
					if (tpix->iUsed < ixmx) ixmx = tpix->iUsed;
					iccnt = ixmx - ixmn + 1;
					if (iop1==FIL_WDATTR_NE) {
						if (ix1 <= ixmn || ix1 >= ixmx) iop1 = 0;
						if (ix1 == ixmn) {
							iccnt--;
							ixmn++;
						}
						if (ix1 == ixmx) {
							iccnt--;
							ixmx--;
						}
					}
					if (iop2==FIL_WDATTR_NE) {
						if (ix2 <= ixmn || ix2 >= ixmx) iop2 = 0;
						if (ix2 == ixmn) {
							iccnt--;
							ixmn++;
						}
						if (ix2 == ixmx) {
							iccnt--;
							ixmx--;
						}
					}
					if (iccnt < 1) {
						sqlca_fil.sqlcode = 100;
						return 0;
					}
					ihcnt = (ixmn+ixmx)*iccnt/2;
					if (iop1==FIL_WDATTR_NE) {
						iccnt--;
						ihcnt -= ix1;
					}
					if (iop2==FIL_WDATTR_NE) {
						iccnt--;
						ihcnt -= ix2;
					}
				}
				else {
					iop1 = 0;
					ixmn  = 1;
					iop2 = 0;
					iccnt = ixmx = tpix->iUsed;
					ihcnt = (ixmn+ixmx)*iccnt/2;
				}
/*
printf("fil_fetch:ixmn=%d ixmx=%d iccnt=%d ihcnt=%d\n",ixmn,ixmx,iccnt,ihcnt);
*/
				for (i=0;i<selp->F;i++) {
					switch (selp->C[i]) {
						case 1:	/* max */
							ret = ixmx;
							break;
						case 4:	/* count */
							ret = iccnt;
							break;
						case 2:	/* min */
							ret = ixmn;
							break;
						case 3:	/* sum */
							ret = ihcnt;
					}
/*
printf("fil_fetch:i=%d summary=%d\n",i,ret);
*/
					memcpy(cp->sumrec[i],(char *)&ret,4);
				}
				sqlca_fil.sqlcode = fil_summary_set(cp);
				sqlca_fil.sqlerrd[2]++;
				return 0;
			}
		}
	}

	ihcnt = 0;
	if ((cp->ixflg & IXFLG_IX_WHERE) && tpix) {
/*
printf("fil_fetch:use index F=%d M[0]=%d\n",selp->F,selp->M[0]);
*/
		/* rowid݂̂̂Ƃ̍œK */
		if (cp->ixflg & IXFLG_IX_ROWID) {
			nob  = cp->nobj;
			obj  = cp->obj;
			ichk = obj[nob];
			ixmx = obj[nob+2];
			iop1 = obj[nob+3];
			ix1  = obj[nob+4];
			iop2 = obj[nob+7];
			ix2  = obj[nob+8];
/*
printf("fil_fetch: ichk=%d ixmx=%d iop1=%d ix1=%d iop2=%d ix2=%d\n",
ichk,ixmx,iop1,ix1,iop2,ix2);
*/
		}
		for(;;) {
			i=atoi(cp->rec[0])+1;
/*
printf("fil_fetch: ixmx=%d i=%d\n",ixmx,i);
*/
			if (cp->ixflg & IXFLG_IX_ROWID) {
				if (ichk && i > ixmx) {
/*
printf("fil_fetch: ixmx=%d i=%d end\n",ixmx,i);
*/
					sqlca_fil.sqlcode = 100;
					break;
				}
			}
			if (i>tpix->iUsed) {
				sqlca_fil.sqlcode = 100;
				break;
			}
#ifdef NO_INDEX
			sprintf(cp->rec[0],"%d",i);
#else
			if (sqlca_fil.sqlcode =
				fil_fetch_rec_index2(bndp->F,cp->rec,bndp->L,bndp->M,
				                     tpix,i)) break;
#endif
			if (cp->ixflg & IXFLG_IX_ROWID) {
				if ((iop1==FIL_WDATTR_NE && i==ix1) ||
				    (iop2==FIL_WDATTR_NE && i==ix2)) ret = 0;
				else ret = 1;
/*
printf("fil_fetch: judge ret=%d\n",ret);
*/
			}
			else {
				ret=fil_ex_obj(cp->rec,cp->obj,cp->nobj);
			}
			if (ret) {
				if (ret<0) {
					sqlca_fil.sqlcode = ERROR_EXEC_OBJ;
					break;
				}
				else {
					if (!rowid_count_only) {
						sqlca_fil.sqlerrd[3]++;
						if (sqlca_fil.sqlcode =
						    fil_fetch_rec_ctl(cp,bndp,tpix,i,buf,sizeof(buf))
						    ) break;
					}
					ihcnt++;
					fil_fetch_set(cp);
					if (cp->isflg) {
						if (cp->icflg != selp->F) fil_summary(cp);
					}
					else {
						break;
					}
				}
			}
		}
	}
	else if ((cp->ixflg & IXFLG_IX_NEST) && tpix) {
/*
printf("fil_fetch:use tree\n");
*/
		for(;;) {
			i=atoi(cp->rec[0])+1;
			if (i>tpix->iUsed) {
				sqlca_fil.sqlcode = 100;
				break;
			}
#ifdef NO_INDEX
			sprintf(cp->rec[0],"%d",i);
#else
			if (sqlca_fil.sqlcode =
				fil_fetch_rec_index2(bndp->F,cp->rec,bndp->L,bndp->M,
				                     tpix,i)) break;
#endif
			ret = 1;
			for (j=0;j<cp->nnest;j++) {
/*
printf("fil_fetch:use tree index:j=%d flg=%d\n",j,cp->nest_flg[j]);
*/
				if (!cp->nest_flg[j]) {	/* only rowid */
					ret = fil_ex_tree(cp->nest[j],cp->tree,cp->rec);
					if (ret<=0) break;
				}
			}
			if (ret==0) continue;
			else if (ret<0) {
				sqlca_fil.sqlcode = ERROR_EXEC_OBJ;
				break;
			}
			sqlca_fil.sqlerrd[3]++;
			if (sqlca_fil.sqlcode=
				fil_fetch_rec_ctl(cp,bndp,tpix,i,buf,sizeof(buf))) break;
			for (j=0;j<cp->nnest;j++) {
/*
printf("fil_fetch:use tree rec:j=%d flg=%d\n",j,cp->nest_flg[j]);
*/
				if (cp->nest_flg[j]) {
					ret = fil_ex_tree(cp->nest[j],cp->tree,cp->rec);
					if (ret<=0) break;
				}
			}
			if (ret==0) continue;
			else if (ret<0) {
				sqlca_fil.sqlcode = ERROR_EXEC_OBJ;
				break;
			}
			ihcnt++;
			fil_fetch_set(cp);
			if (cp->isflg) {
				if (cp->icflg != selp->F) fil_summary(cp);
			}
			else {
				break;
			}
		}
	}
	else {
/*
printf("fil_fetch:read file F=%d M[0]=%d\n",selp->F,selp->M[0]);
printf("fil_fetch:fp=%08x tpix=%08x\n",cp->fp,tpix);
*/
		if (cp->fp) {
			tpix = NULL;
		}
		for(;;) {
			if (cp->fp) {
				sqlca_fil.sqlerrd[3]++;
			}
			if (sqlca_fil.sqlcode=
				fil_fetch_rec_ctl(cp,bndp,tpix,0,buf,sizeof(buf))) break;
			if (ret=fil_ex_obj(cp->rec,cp->obj,cp->nobj)) {
				if (ret<0) {
					sqlca_fil.sqlcode = ERROR_EXEC_OBJ;
					break;
				}
				else {
					ihcnt++;
					fil_fetch_set(cp);
					if (cp->isflg) {
						if (cp->icflg != selp->F) fil_summary(cp);
					}
					else {
						break;
					}
				}
			}
		}
	}
	if (cp->isflg) {
/*
		if ((ihcnt && sqlca_fil.sqlcode==100) || selp->C[0]==4) {
			sqlca_fil.sqlcode = 0;
			if (selp->C[0]==4) memcpy(cp->sumrec[0],&ihcnt,4);
		}
*/
		if (ihcnt && sqlca_fil.sqlcode==100) sqlca_fil.sqlcode = 0;
		for (i=0;i<selp->F;i++) {
			if (selp->C[i]==4) {
				sqlca_fil.sqlcode = 0;
				memcpy(cp->sumrec[i],&ihcnt,4);
			}
		}
		if (!sqlca_fil.sqlcode) sqlca_fil.sqlcode = fil_summary_set(cp);
	}
	if (!sqlca_fil.sqlcode) {
		sqlca_fil.sqlerrd[2]++;
	}
	return 0;
}

static int fil_fetch_rec_index(n,rec,lrec,tpix,irec)
char **rec;
int n,irec,*lrec;
INDEX *tpix;
{
	int i;
	char *p;

	if (irec < 1) {
		irec=atoi(rec[0])+1;
		sprintf(rec[0],"%d",irec);
	}
/*
printf("fil_fetch_rec_index:irec=%d iUsed=%d\n",irec,tpix->iUsed);
*/
	if (irec > tpix->iUsed) return 100;
	p = tpix->cppData[irec-1];
	if (!p) return 100;

	for (i=1;i<n;i++) {
		rec[i] = p;
		p += (lrec[i] + 1);
	}
	return 0;
}

static int fil_fetch_rec(fp,buf,buflen,n,rec,lrec,tpix,irec,inflg)
FILE *fp;
char *buf,**rec;
int n,buflen,irec,*lrec,inflg;
INDEX *tpix;
{
/*
	static char sep[]=" \t,";
*/
	static char sep[]=",";
	SSP_S ssp;
	int opt,i,len,r_len;
	char *s, *d, c;
/*
printf("fil_fetch_rec:fp=%08x buf=%08x buflen=%d n=%d rec=%08x\ntpix=%08x irec=%d\n",fp,buf,buflen,n,rec,tpix,irec);
*/
	if (!fp) return 100;

	if (tpix) {
/*
printf("fil_fetch_rec:i=%d,fseek\n",irec);
*/
		fseek(fp,tpix->lpPos[irec-1],SEEK_SET);
	}
	else {
		i=atoi(rec[0])+1;
		sprintf(rec[0],"%d",i);
/*
printf("fil_fetch_rec:i=%d\n",i);
*/
	}
	if (inflg & (FIL_FORM_FIXED | FIL_FORM_FREE)) {	/* fixed  or free */
		len = 2;
		for (i=1;i<n;i++) {
			len += lrec[i];
		}
		if (len + n > buflen) return -1;
		s = buf + buflen - len;
	/*	if (!fgets(s,len,fp)) {	*/
		if ((r_len=akxa_read_line_opt(s,len,fp,0x03)) < 0) {
			return 100;
		}
		if (r_len < len) memset(s+r_len,0,len-r_len);
		d = buf;
		for (i=1;i<n;i++) {
			len = lrec[i];
			strmemcpy(d,s,len);
			rec[i] = d;
			d += len + 1;
			s += len;
		}
	}
	else if (inflg & FIL_FORM_SSV) {	/* ssv */
	/*	if (!fgets(buf,buflen,fp)) {	*/
		if (!akxa_read_line(buf,buflen,fp)) {
			return 100;
		}
		opt = 0x27;
		ssp.sp = 0;
		i = 1;
		if ((c=buf[ssp.sp])==' ' || c=='\t') {
			ssp.sp++;
			rec[i] = buf;
			*rec[i] = '\0';
			i++;
		}
		for (;i<n;i++) {
			len = axtgwse(buf,&ssp," \t",opt);
			rec[i] = ssp.wd;
			if (len <= 0) {
				*rec[i] = '\0';
			}
			else {
				if ((c=buf[ssp.sp])==' ' || c=='\t') ssp.sp++;
				if (len>lrec[i]) len=lrec[i];
				*(rec[i]+len) = '\0';
			}
		}
	}
	else {	/* csv */
	/*	if (!fgets(buf,buflen,fp)) {	*/
		if (!akxa_read_line(buf,buflen,fp)) {
			return 100;
		}
		opt = 0x27;
		ssp.sp = 0;
		for (i=1;i<n;i++) {
			len = axtgwse(buf,&ssp,sep,opt);
/*
printf("fil_fetch_rec:i=%d len=%d sp=%d\n",i,len,ssp.sp);
*/
			rec[i] = ssp.wd;
			if (!len || (*ssp.wd == ',')) {
				*rec[i] = '\0';
				continue;
			}
			if (len>lrec[i]) len=lrec[i];
			/* ssp.sṕAJ}̈ʒuɂ邱Ƃ̂ŁAǂݔ΂
			    */
			axtgwse(buf,&ssp,sep,opt);
			*(rec[i]+len) = '\0';
/*
printf("fil_fetch_rec:i=%d rec=[%s] lrec=%d\n",i,rec[i],lrec[i]);
*/
		}
	}
	return 0;
}

static int fil_fetch_set(cp)
CURSOR *cp;
{
	SQLDA_FIL *selp,*bndp;
	int i,ix;
	char w[256];
/*
printf("fil_fetch_set: called\n");
*/
	selp = cp->select;
	bndp = cp->bind;
	for (i=0;i<selp->F;i++) {
		if (selp->V[i]) *(selp->V[i]) = '\0';
		if ((ix=selp->M[i])>0) {
			ix--;
			if (cp->rec[ix]) {
				if (bndp->T[ix] & 0x80) {
					if (strlen(cp->rec[ix]) > 0) {
						strcpy(w,cp->tblnam);
						strcat(w,".");
						strcat(w,bndp->S[ix]);
						strcat(w,"/");
						strcat(w,cp->rec[ix]);
						strcpy(selp->V[i],w);
					}
				}
				else {
					strmemcpy(selp->V[i],cp->rec[ix],selp->L[i]);
				}
			}
		}
		else strcpy(selp->V[i],selp->S[i]);
	}
	return 0;
}

static int fil_summary(cp)
CURSOR *cp;
{
	SQLDA_FIL *selp,*bndp;
	int i,ix,type,l;
	long lsum,ldat;
	char *selpV;
/*
printf("fil_summary: called\n");
*/
	selp = cp->select;
	bndp = cp->bind;
	for (i=0;i<selp->F;i++) {
		if (selp->C[i]==4) continue;
		selpV = selp->V[i];
		if ((ix=selp->M[i])>0) {
			type = bndp->T[ix-1];
			l    = bndp->L[ix-1];
		}
		else {
			type = TYPE_FIL_CHAR;
			l    = selp->L[i];
		}
		if (type == TYPE_FIL_INTEGER || selp->C[i]==4) {
			memcpy((char *)&lsum,cp->sumrec[i],4);
			ldat = atoi(selpV);
		}
		switch (selp->C[i]) {
			case 1:	/* max */
				if (type == TYPE_FIL_INTEGER) {
					if (ldat > lsum) lsum = ldat;
				}
				else {
					if (strcmp(selpV,cp->sumrec[i])>0)
						strmemcpy(cp->sumrec[i],selpV,l);
				}
				break;
			case 2:	/* min */
				if (type == TYPE_FIL_INTEGER) {
					if (ldat < lsum) lsum = ldat;
				}
				else {
					if (strcmp(selpV,cp->sumrec[i])<0)
						strmemcpy(cp->sumrec[i],selpV,l);
				}
				break;
			case 3:	/* sum */
				if (type == TYPE_FIL_INTEGER) lsum += ldat;
				break;
			case 4:	/* count */
				lsum++;
				break;
		}
		if (type == TYPE_FIL_INTEGER || selp->C[i]==4) {
			memcpy(cp->sumrec[i],(char *)&lsum,4);
		}
	}
	return 0;
}

static int fil_summary_set(cp)
CURSOR *cp;
{
	SQLDA_FIL *selp,*bndp;
	int i,ix,type;
	long lsum;
	char *selpV;

	selp = cp->select;
	bndp = cp->bind;
	for (i=0;i<selp->F;i++) {
		if ((ix=selp->M[i])>0) type = bndp->T[ix-1];
		else type = TYPE_FIL_CHAR;
/*
printf("fil_summary_set: i=%d C=%d T=%d\n",i,selp->C[i],type);
*/
		selpV = selp->V[i];
		if (selp->C[i] == 4 || type == TYPE_FIL_INTEGER) {
			memcpy((char *)&lsum,cp->sumrec[i],4);
			sprintf(selpV,"%d",lsum);
		}
		else strmemcpy(selpV,cp->sumrec[i],selp->L[i]);
	}
	return 0;
}

int fil_cursor_close(cp)
CURSOR *cp;
{
	SQLDA_FIL *bndp, *selp;
	int i;

	if (cp->fp) fclose(cp->fp);
	cp->fp = NULL;
	sqlca_fil.sqlcode = 0;
	bndp = cp->bind;
	if (cp->rec) {	/* update 2000.11.27 Koba */
		if (cp->rec[0]) Free(cp->rec[0]);
		Free(cp->rec);
	}
	cp->rec = NULL;
	if (cp->isflg) {
		selp = cp->select;
		if (cp->sumrec) {	/* update 2000.11.27 Koba */
			for (i=0;i<selp->F;i++) if (cp->sumrec[i]) Free(cp->sumrec[i]);
			Free(cp->sumrec);
			cp->sumrec = NULL;
		}
	}
#ifdef NOTICE_TUPLE
printf("fil_cursor_close: file read count = %d\n",sqlca_fil.sqlerrd[3]);
#endif
	return 0;
}

int fil_read_all(file,pv)
char *file,**pv;
{
	char *p,*pp,buf[4096];
	FILE *fp;
	int len,file_len;
/*
printf("fil_read_all:file = [%s]\n",file);
*/
	*pv = NULL;
	if (!(fp=fopen(file,"r"))) {
		return ERROR_OPEN;
	}
	if (!(p=Malloc(sizeof(buf)))) return ERROR_MALLOC;
	pp = p;
	file_len = 0;
	while ((len=fread(pp,1,sizeof(buf),fp))>0) {
/*
printf("fil_read_all:read len = %d\n",len);
*/
		pp       += len;
		file_len += len;
		if (!(p=Realloc(p,file_len+sizeof(buf)))) {
			fclose(fp);
			return ERROR_MALLOC;
		}
	}
	fclose(fp);
	if (len<0) return ERROR_READ;
	*pv = p;
	return file_len;
}

static int fil_fetch_rec_index2(n,rec,lrec,M,tpix,irec)
char **rec;
int n,irec,*lrec;
short *M;
INDEX *tpix;
{
	int i;
	char *p;

/*
printf("fil_fetch_rec_index2:irec=%d\n",irec);
*/
	sprintf(rec[0],"%d",irec);

	p = tpix->cppData[irec-1];
	if (!p) return 100;

	for (i=1;i<n;i++) {
		if (M[i]) {
			rec[i] = p;
/*
printf("fil_fetch_rec_index2:i=%d rec=[%s]\n",i,p);
*/
			p += (lrec[i] + 1);
		}
	}
	return 0;
}

static int fil_fetch_rec_ctl(cp,bndp,tpix,irec,buf,buflen)
CURSOR *cp;
SQLDA_FIL *bndp;
INDEX *tpix;
int irec,buflen;
char *buf;
{
	int irc=0;

#ifdef FILE_ONLY
	if (!cp->fp) irc = 100;
#else
	if (!cp->fp) {
		if (tpix)
			irc = fil_fetch_rec_index(bndp->F,cp->rec,bndp->L,tpix,irec);
		else irc = 100;
	}
#endif

	else if (!(cp->ixflg & IXFLG_IX_SELECT)) {
		irc = fil_fetch_rec(cp->fp,buf,buflen,bndp->F,cp->rec,bndp->L,
		                    tpix,irec,cp->inflg);
	}

	return irc;
}
