static    char    sccsid[]="%Z% %M% %I% %E% %U%";
/*************************************************/
/*  Program name                                 */
/*       int        cl_mk_lk_proc_ct             */
/* --------------------------------------------- */
/*  (I/O)                                        */
/*       In         Leaf  *leaf                  */
/*                                               */
/*       Out        0   :Normal                  */
/*                 -1   :AbNormal                */
/* --------------------------------------------- */
/*  Function :                                   */
/*  nꂽvV[We[uP[W */
/* --------------------------------------------- */
/*************************************************/
/* */
#include "colmn.h"          /* 萔` */

extern CLPRTBL CLprocTable,*pCLprocTable;

ProcCT *cl_mk_lk_proc_ct()
{
	ScrPrCT *Dummy;
	ProcCT  *ProRoot;

	if (pCLprocTable->PrCTp == NULL) {
		return NULL;
	}
	else {
		if (!(ProRoot=cl_mk_pr_make())) return NULL;
		if (cl_mk_pr_push(ProRoot)) return NULL;
		cl_tmp_const_ct_set(ProRoot->pTmpConstCt);
		pCLprocTable->CurProc = ProRoot;
		Dummy = cl_search_src_ct();
		Dummy->CurProc = ProRoot;

		ProRoot->ProcGid = ++pCLprocTable->gid;
		akxs_xhasl(pCLprocTable->pha_gid,'S',ProRoot->ProcGid,0);
	}

	return ProRoot;
}

/*************************************************/
/*  Program name                                 */
/*       leaf      *cl_mk_pr_make                */
/* --------------------------------------------- */
/*  Function :                                   */
/* --------------------------------------------- */
/*************************************************/
/* */
ProcCT *cl_mk_pr_make()
{
	ProcCT  *Dummy;
	int len,*pSize;

	Dummy = (ProcCT *)Malloc(sizeof(ProcCT));
	if (Dummy == NULL) return NULL;

	memset(Dummy,0,sizeof(ProcCT));
	Dummy->pRetStack = akxs_rb_new(0,0);
	Dummy->pTmpConstCt = cl_const_ct_new();

	return Dummy;
}

/*************************************************/
/*  Program name                                 */
/*       int        cl_mk_pr_push                */
/* --------------------------------------------- */
/*  Function :                                   */
/*************************************************/
int cl_mk_pr_push(ProRoot)
ProcCT  *ProRoot;
{
	ScrPrCT  *Dummy;
	ProcCT   *Temp;

	if (ProRoot==NULL) return(-1);
	Dummy = pCLprocTable->PrCTp;
	for(;;) {
		if (Dummy->nextScCT == (ScrPrCT *)NULL) {
			Temp = Dummy->ProCT;
			if (Temp == (ProcCT *)NULL) {
				Dummy->ProCT = ProRoot;
				break;
			}
			else {
				for(;;) {
					if (Temp->nextPCT == (ProcCT *)NULL) {
						ProRoot->prePCT = Temp;
						Temp->nextPCT = ProRoot;
						break;
					}
					Temp = Temp->nextPCT;
				}
				break;
			}
		}
		Dummy = Dummy->nextScCT;
	}

	return 0;
}

/*************************************************/
/*  Program name                                 */
/*       int        cl_mk_pr_var_set             */
/* --------------------------------------------- */
/*  Function :                                   */
/*************************************************/
int cl_mk_pr_var_set(proc)
ProcCT  *proc;
{
	int *pSize,len;
	tdtInfoParm ***pDummy ;

	if (!proc->pha_vnam) {
		proc->pha_vnam = akxs_xhash_new(0,MAX_LVR_IY,0);

		pSize = (int *)Malloc(cl_var_size_len(0)*2);
		if (!pSize) goto Err;

		len = sizeof(tdtInfoParm **)*((MAX_LVR_IX+1)+(MAX_PAS_IX+1));
		pDummy = (tdtInfoParm ***)Malloc(len);
		if (!pDummy) goto Err;

		memset(pDummy,0,len);
		proc->pTBL_vnam    = pDummy;
		proc->pTBL_pasento = proc->pTBL_vnam + MAX_LVR_IX+1;
/*
DEBUGOUT2("cl_mk_pr_var_set: proc->pTBL_vnam=%08x proc->pTBL_pasento=%08x",
proc->pTBL_vnam,proc->pTBL_pasento);
*/
		proc->pTBL_vnam[0] = (tdtInfoParm **)pSize;
		pSize = cl_var_set_size(pSize,MAX_LVR_IX,MAX_LVR_IY,"LVN");

		proc->pTBL_pasento[0] = (tdtInfoParm **)pSize;
		cl_var_set_size(pSize,MAX_PAS_IX,MAX_PAS_IY,"LPA");
	}
	return 0;
 Err:
	if (proc->pha_vnam) {
		akxs_xhash_free(proc->pha_vnam);
		proc->pha_vnam = NULL;
	}
	if (pSize) Free(pSize);
	return -1;
}

/*************************************************/
/*  Program name                                 */
/*       int       cl_mk_lk_class_method         */
/* --------------------------------------------- */
/*  Function :                                   */
/*************************************************/
#if 1	/* 2017.06.07 */
ProcCT *cl_mk_lk_class_method(ProRoot)
ProcCT *ProRoot;
{
#else
ProcCT *cl_mk_lk_class_method()
{
	ProcCT  *ProRoot;
#endif
	ScrPrCT *Dummy;

	if (pCLprocTable->PrCTp == NULL) {
		return NULL;
	}
	else {
#if 1	/* 2017.06.07 */
		if (!ProRoot) {
			if (!(ProRoot=(ProcCT *)Malloc(sizeof(ProcCT)))) return NULL;
			memset(ProRoot,0,sizeof(ProcCT));
		/*
			ProRoot->ProcGid = ++pCLprocTable->gid;
			akxs_xhasl(pCLprocTable->pha_gid,'S',ProRoot->ProcGid,0);
		*/
		}
		else ProRoot->nextPCT = NULL;
#else
		if (!(ProRoot=(ProcCT *)Malloc(sizeof(ProcCT)))) return NULL;
		memset(ProRoot,0,sizeof(ProcCT));
#endif
		if (cl_mk_pr_push(ProRoot)) return NULL;
		pCLprocTable->CurProc = ProRoot;
		Dummy = cl_search_src_ct();
		Dummy->CurProc = ProRoot;
#if 1	/* 2017.06.10 */
		ProRoot->ProcGid = ++pCLprocTable->gid;
		akxs_xhasl(pCLprocTable->pha_gid,'S',ProRoot->ProcGid,0);
#endif
	}

	return ProRoot;
}

/************************************************/
/*	Program name								*/
/*		tdtObjHead *cl_mk_add_obj0				*/
/* -------------------------------------------- */
/*	Function :									*/
/************************************************/
tdtObjHead *cl_mk_add_obj0(ObjH,add_obj0)
tdtObjHead *ObjH;
int add_obj0;
{
	int i,m,alsize;
	tdtInfoParm **ppObj0,*pObj0,**Obj0,*pInfo;
	tdtObjHead *Obj;

	if (add_obj0 <= 0) add_obj0 = MAX_CMD_OBJ0;
	if (Obj=ObjH) {
		alsize = Obj->alsz;
		ppObj0 = Obj->Obj0;
		pInfo = ppObj0[0];
	}
	else {
		if (!(Obj=(tdtObjHead *)Malloc(sizeof(tdtObjHead)))) return NULL;
		Obj->used = 0;
		alsize = 0;
		ppObj0 = NULL;
		pInfo = NULL;
	}
	Obj->alsz = m = alsize + add_obj0;

DEBUGOUTL5(158,"cl_mk_add_obj0: Obj=%08x alsize=%d add_obj0=%d m=%d used=%d",Obj,alsize,add_obj0,m,Obj->used);

	if (!(ppObj0=(tdtInfoParm **)MRealloc(ppObj0,sizeof(tdtInfoParm *)*m))) return NULL;
	if (!(pObj0 =(tdtInfoParm *)MRealloc(pInfo,sizeof(tdtInfoParm)*m))) {
		Free(ppObj0);
		return NULL;
	}
	memset(pObj0+alsize,0,sizeof(tdtInfoParm)*add_obj0);
	if (Obj->used > 0) {
		pInfo = pObj0;
		for (i=0;i<Obj->used;i++) {
			if (pInfo->pi_scale & D_DATA_LPOSDATA) {
				pInfo->pi_data = (char *)&pInfo->pi_pos;
DEBUGOUT_InfoParm(161,"cl_mk_add_obj0: i=%d",pInfo,i,0);
			}
			pInfo++;
		}
	}
	Obj->Obj0 = ppObj0;
	for (i=0;i<m;i++) {
		*ppObj0++ = pObj0++;
	}
	return Obj;
}

/************************************************/
/*	Program name								*/
/*		tdtObjHead *cl_mk_obj0					*/
/* -------------------------------------------- */
/*	Function :									*/
/************************************************/
tdtObjHead *cl_mk_obj0(used,max_obj0)
int used,max_obj0;
{
	tdtObjHead *Obj;

	if (used > max_obj0) max_obj0 = used;
	if (Obj = cl_mk_add_obj0(NULL,max_obj0)) {
	/*	Obj->used = used;	*/
	}
	return Obj;
}
