static	char	sccsid[]="%Z% %M% %I% %D% %T%";
#include "akbcommon.h"

#define AKB_VCH_DATASIZE	(4096-32)

static int akb_vwqseti(/* pVch,pSdNext,pWriteQue */);
static int akb_vwqto_wqi(/* pVch,pWriteQue */);
static int akb_vrqre_seti(/* pVch,pSdNext,pRbWWCtl */);
static int akb_vrqerr_chk(/* pVch,pSdNext */);
static int akb_vch_set_write_que(/* pWriteQue,pSdNext */);
static int _rel_buf_func();

tdtVCH_HEAD *akb_vch_head_new(iChNum,opt)
int iChNum,opt;
{
	tdtVCH_HEAD *pVchHead;

	if (!(pVchHead=(tdtVCH_HEAD *)Malloc(sizeof(tdtVCH_HEAD)))) return NULL;
	memset(pVchHead,0,sizeof(tdtVCH_HEAD));
	if (!(pVchHead->vh_ppvc=(tdtVCH **)Malloc(sizeof(tdtVCH *)*iChNum))) goto Err;
	memset(pVchHead->vh_ppvc,0,sizeof(tdtVCH *)*iChNum);
	pVchHead->vh_cnum = iChNum;
	return pVchHead;
 Err:
	akb_vch_head_free(pVchHead);
	return NULL;
}

int akb_vch_head_free(pVchHead)
tdtVCH_HEAD *pVchHead;
{
	int i;
	tdtVCH *pVch;

	if (!pVchHead) return -1;
	for (i=0;i<pVchHead->vh_cnum;i++) {
		if (pVch=pVchHead->vh_ppvc[i]) akb_vch_free(pVch);
	}
	Free(pVchHead);
}

tdtVCH *akb_vch_new(iVchNum,parm)
int iVchNum,parm[];
{
	tdtVCH *pVch;
	tdtRWQ_TIME_OUT *p;
	int len,i;

	if (!(pVch=(tdtVCH *)Malloc(sizeof(tdtVCH)))) return NULL;
	memset(pVch,0,sizeof(tdtVCH));
	if (!(pVch->vch_wbuf=(tdtRW_QUE *)Malloc(sizeof(tdtRW_QUE)*iVchNum))) goto Err;
	if (!(pVch->vch_rbuf=(tdtRW_QUE *)Malloc(sizeof(tdtRW_QUE)*iVchNum))) goto Err;
	if (!(pVch->vch_vctl=(tdtRB_CTL *)akxs_rb_new(0,0))) goto Err;
	pVch->vch_cnum = iVchNum;
/*
	akb_init_que(iVchNum,pVch->vch_wbuf);
	akb_init_que(iVchNum,pVch->vch_rbuf);
*/
	memset(pVch->vch_wbuf,0,sizeof(tdtRW_QUE)*iVchNum);
	memset(pVch->vch_rbuf,0,sizeof(tdtRW_QUE)*iVchNum);
#ifndef NO_RWQTIMEOUT
	p = akb_rwque_time_out_new(iVchNum,parm);
	if (pVch->vch_rwqt = p) {
		p->rwt_clsf = _rel_buf_func;
		p->rwt_rqto.qto_qmax = iVchNum;
	/*	p->WQT.pQue    = pVch->pVWriteBuf;	*/
		p->rwt_wqto.qto_qmax = iVchNum;
	/*	p->RQT.pQue    = pVch->pVReadBuf;	*/
		if (p->rwt_rqto.qto_ppqu=(tdtRW_QUE **)Malloc(len=sizeof(tdtRW_QUE *)*iVchNum)) {
			if (p->rwt_wqto.qto_ppqu=(tdtRW_QUE **)Malloc(len)) {
				akb_set_rwque_pa(p->rwt_rqto.qto_ppqu,iVchNum,pVch->vch_rbuf);
				for (i=0;i<p->rwt_rqto.qto_qmax;i++)
					p->rwt_rqto.qto_ppqu[i]->rwq_wtime = p->rwt_rqto.qto_wait;
				akb_set_rwque_pa(p->rwt_wqto.qto_ppqu,iVchNum,pVch->vch_wbuf);
				for (i=0;i<p->rwt_wqto.qto_qmax;i++)
					p->rwt_wqto.qto_ppqu[i]->rwq_wtime = p->rwt_wqto.qto_wait;
			}
			else {
				Free(p->rwt_rqto.qto_ppqu);
				p->rwt_rqto.qto_ppqu = NULL;
			}
		}
		if (!p->rwt_rqto.qto_ppqu || !p->rwt_wqto.qto_ppqu) {
			Free(p);
			pVch->vch_rwqt = NULL;
		}
	}
#endif
	return pVch;
 Err:
	akb_vch_free(pVch);
	return NULL;
}

int akb_vch_free(pVch)
tdtVCH *pVch;
{
	if (!pVch) return -1;
	if (pVch->vch_wbuf) {
		akb_free_que(pVch->vch_cnum,pVch->vch_wbuf);
		Free(pVch->vch_wbuf);
	}
	if (pVch->vch_rbuf) {
		akb_free_que(pVch->vch_cnum,pVch->vch_rbuf);
		Free(pVch->vch_rbuf);
	}
	if (pVch->vch_vctl) akxs_rb_all_free(pVch->vch_vctl);
	Free(pVch);
	return 0;
}

int akb_vch_set_parm(pVchHead)
tdtVCH_HEAD *pVchHead;
{
	int n,i,wt,wc;
	char *argv[5];

	n = akb_gs_akb_stpl(D_SECTION_AKB_SYSTEM,D_KEYNAME_VCH,argv,4);
	if (n >= 2) {
		if ((i = atoi(argv[1])) < 0) i = 0;
		pVchHead->vh_nmax = i;
	}
	wt = -1;
	if (n >= 3) {
		wt = atoi(argv[2]);
	}
	if (n >= 4) {
		pVchHead->vh_intv = atoi(argv[3]);
	}
	if (wt > 0) {
		if ((i=pVchHead->vh_intv) <= 0) i = 60;
		pVchHead->vh_wait = wt;
		pVchHead->vh_intv = i;
	}
	return n;
}

int akb_vch_wqset_func(pVchHead,pFunc)
tdtVCH_HEAD *pVchHead;
int (*pFunc)();
{
	tdtRB_CTL *pRbWCtl,*pRbWWCtl;
	tdtVCH *pVch;
	pSD_PACKET_TABLE   pSdNext, pNew;
	tdtRW_QUE *pWriteQue;
	int iQTbl, iRc, i, iOpt;
	char *pData,procname[16];

	if (!pVchHead) return -1;

	pRbWCtl  = pVchHead->vh_wctl;
	pRbWWCtl = pVchHead->vh_wwtl;
	if (pVchHead->vh_nmax <= 0)
		return akb_wqset(pVchHead->vh_wque,pRbWCtl,pRbWWCtl);

	while (pSdNext=(pSD_PACKET_TABLE)akxs_rb_get_n(pRbWCtl)) {

DEBUGOUTL5(AKB_LOG_GROUP,
"akbVchWQueSet: pSdNext=%08x iCh=%d iLen=%d offset=%d pContent=%08x",
pSdNext,pSdNext->sp_ch,pSdNext->sp_len,pSdNext->sp_offset,pSdNext->sp_content);

		iQTbl = pSdNext->sp_ch;

DEBUGOUTL1(AKB_LOG_GROUP,"akbVchWQueSet: iQTbl=%d.",iQTbl);

		if (iQTbl<0) {
			ERROROUT1("akbWQueSet: invalid iCh=%d",pSdNext->sp_ch);
			Free(pSdNext->sp_content);
			Free(pSdNext);
			continue;
		}
		pVch = pVchHead->vh_ppvc[iQTbl];
		pWriteQue = &pVchHead->vh_wque[iQTbl];
		if (pWriteQue->rwq_sd < 0) {
			ERROROUT1("akbVchWQueSet: socket closed iCh=%d",pSdNext->sp_ch);
			Free(pSdNext->sp_content);
			Free(pSdNext);
			akb_clear_rwque(pWriteQue,-1);
			if (pVch) {
				akb_vch_free(pVch);
				pVchHead->vh_ppvc[iQTbl] = NULL;
			}
		}
		else {
#ifdef WRITE_QUE_FORM_FUNC
			if (pFunc) {
				if (pFunc(pSdNext) < 0) continue;
			}
#else
			if (iOpt=pWriteQue->rwq_option) {
				iRc = 0;
				if (pWriteQue->rwq_option & AKB_WQUE_OPT_MAKE_XPACK) {
					iRc = akbi_make_xpacket(pSdNext,
						pWriteQue->rwq_option & AKB_WQUE_OPT_SAME_HOST);
				}
				if (pWriteQue->rwq_option & AKB_WQUE_OPT_MAKE_INDIR) {
					sprintf(procname,"WQ%d",getpid());
					iRc = akbi_make_indir_f(pSdNext,procname);
				}
				if (iRc < 0) {
#ifdef NO_SRC_CH
					if (pFunc) {
						if ((iQTbl = pFunc(pSdNext->sp_content)) > 0) {
#else
						if ((iQTbl = pSdNext->sp_srcch) > 0) {
#endif
							if (akb_set_rb_pack_err_cd(iQTbl,pSdNext->sp_content,
							                   pRbWWCtl,D_ERR_FORM_CHANGE)) {
								ERROROUT("*** akb_vch_wqset_func:Dropped Packet -- akb_set_rb_pack_err_cd error");
								Free(pSdNext->sp_content);
							}
						}
#ifdef NO_SRC_CH
						else Free(pSdNext->sp_content);
					}
#endif
					else {
						ERROROUT("*** akb_wqsetFunc:Dropped Packet -- pFunc is NULL");
						Free(pSdNext->sp_content);
					}
					Free(pSdNext);
					continue;
				}
			}
#endif
			if (pVch) {
				iRc = akb_vwqseti(pVch,pSdNext,pWriteQue);
			 	if (!iRc) pVchHead->vh_wspd++;
			}
			else {
				if (pWriteQue->rwq_torwlen == 0) {
					akb_vch_set_write_que(pWriteQue,pSdNext);
					Free(pSdNext);
					iRc = 0;
				}
				else {

DEBUGOUTL1(AKB_LOG_GROUP,"akbVchWQueSet: write que used i=%d.",iQTbl);

					iRc = 1;
				}
			}
			if (iRc > 0) akxs_rb_set_n(pRbWWCtl,pSdNext);
		}
	}

#if 1	/* 2005.6.13 Koba */
	akxs_rb_exchg(pRbWCtl,pRbWWCtl,0);
#else
	while (pSdNext=(pSD_PACKET_TABLE)akxs_rb_get_n(pRbWWCtl)) {
		akxs_rb_set_n(pRbWCtl,pSdNext);
	}
#endif

DEBUGOUTL1(AKB_LOG_GROUP,
"akbVchWQueSet: sVchWSuspend=%d.",pVchHead->vh_wspd);

	if (pVchHead->vh_wspd > 0) {
		for (i=0;i<pVchHead->vh_cnum;i++) {
			pVch = pVchHead->vh_ppvc[i];
			if (pVch) {
				pWriteQue = &pVchHead->vh_wque[i];
				akb_vwqto_wqi(pVch,pWriteQue);
			}
		}
	}

	return 0;
}

int akb_vch_wqset(pVchHead)
tdtVCH_HEAD *pVchHead;
{
	return akb_vch_wqset_func(pVchHead,NULL);
}

static int akb_vwqseti(pVch,pSdNext,pWriteQue)
tdtVCH *pVch;
pSD_PACKET_TABLE   pSdNext;
tdtRW_QUE *pWriteQue;
{
	int i,iRc=0,aki,same,ivnum;
	tdtRW_QUE *pVWriteBuf;
	tdtCOMM_PACK_HEAD *pHs,*pHd;
	ushort usProc;

	if (!pVch || !pSdNext || !pWriteQue) return -1;

	pHs = (tdtCOMM_PACK_HEAD *)pSdNext->sp_content;
	usProc = pHs->cph_sinf.ind_prid;
	same = 0;
	aki = -1;
	ivnum = pVch->vch_cnum;
	for (i=0;i<ivnum;i++) {
		pVWriteBuf = &pVch->vch_wbuf[i];
		if (pVWriteBuf->rwq_torwlen == 0) aki = i;
		else {
			pHd = (tdtCOMM_PACK_HEAD *)pVWriteBuf->rwq_buf;
			if (usProc == pHd->cph_sinf.ind_prid) same = i + 1;
		}
	}

DEBUGOUTL2(AKB_LOG_GROUP,
"akb_vwqseti:aki=%d same=%d",aki,same);

	if (aki>=0 && !same) {
		pVWriteBuf = &pVch->vch_wbuf[aki];
		akb_vch_set_write_que(pVWriteBuf,pSdNext);
		pVWriteBuf->rwq_sd = 0;	/* V[PXNo */
		pVWriteBuf->rwq_tof = time(NULL);	/*  */
		Free(pSdNext);
	}
	else iRc = 1;

	return iRc;
}

static int akb_vwqto_wqi(pVch,pWriteQue)
tdtVCH *pVch;
tdtRW_QUE *pWriteQue;
{
	int i,iRc=0,len,ivnum;
	tdtRW_QUE *pVWriteBuf;
	tdtCOMM_PACK_HEAD *pHs,*pHd,*head;
	tdtRCSD_PACKET_TABLE qNew,*pSdNext;
	short sWrk;

	if (!pVch || !pWriteQue) return -1;

	if (pWriteQue->rwq_torwlen == 0) {
		if (pSdNext=(pSD_PACKET_TABLE)akxs_rb_get_n(pVch->vch_vctl)) {
			akb_vch_set_write_que(pWriteQue,pSdNext);
			Free(pSdNext);
			return 0;
		}
		ivnum = pVch->vch_cnum;
		while (ivnum-- > 0) {

DEBUGOUTL2(AKB_LOG_GROUP,
"akb_vwqto_wqi:ivnum=%d iCrePos=%d",ivnum,pVch->vch_cpos);

			i = pVch->vch_cpos;
			if (++pVch->vch_cpos >= pVch->vch_cnum) pVch->vch_cpos = 0;
			pVWriteBuf = &pVch->vch_wbuf[i];
			if (pVWriteBuf->rwq_torwlen > 0) {
				len = pVWriteBuf->rwq_torwlen - pVWriteBuf->rwq_rwlen;
				if (len <= 0) continue;
				else if (len > AKB_VCH_DATASIZE) len = AKB_VCH_DATASIZE;
				pVWriteBuf->rwq_sd++;	/* V[PXNo */
				pHd = (tdtCOMM_PACK_HEAD *)pVWriteBuf->rwq_buf;

DEBUGOUTL2(AKB_LOG_GROUP,
"akb_vwqto_wqi:seqno=%d len=%d",pVWriteBuf->rwq_sd,len);

				memset(&qNew,0,sizeof(tdtRCSD_PACKET_TABLE));
				qNew.sp_content = Malloc(sizeof(tdtCOMM_PACK_HEAD)+len);
				/* Create Vch Header */
				head = (tdtCOMM_PACK_HEAD *)qNew.sp_content;
				head->cph_prt.prt_ver        = 'C';
				head->cph_prt.prt_send  = 0;
				sWrk = AKB_CMD_VCHSEND;
				head->cph_prt.prt_cmnd    = htons(sWrk);
				head->cph_dinf.ind_hoid     = htonl(pVWriteBuf->rwq_sd);
													/* V[PXNo   */
				head->cph_dinf.ind_clid   = 0;
				head->cph_dinf.ind_prid = 0;
				head->cph_dinf.ind_thrd    = 0;		/* ]Xbhm   */
				head->cph_dinf.ind_disp    = 0;		/* `jaIvV     */
				head->cph_dinf.ind_pano   = 0;		/* `jaG[R[h   */
				head->cph_sinf.ind_hoid      = htonl(pVWriteBuf->rwq_torwlen);
				head->cph_sinf.ind_clid    = 0;
				sWrk = i;
				head->cph_sinf.ind_prid  = htons(sWrk);/* Vch              */
				head->cph_sinf.ind_thrd     = 1;		/* ]Xbhm   */
				head->cph_sinf.ind_disp     = 1;		/* hc             */
				sWrk = pVWriteBuf->rwq_tof;
				head->cph_sinf.ind_pano    = htons(sWrk);/* pPbgʔ     */
				head->cph_plen = htonl(len);		/* pPbg           */
				memcpy(qNew.sp_content+sizeof(tdtCOMM_PACK_HEAD),
				       pVWriteBuf->rwq_buf+pVWriteBuf->rwq_rwlen,len);
				qNew.sp_len = sizeof(tdtCOMM_PACK_HEAD)+len;
				akb_vch_set_write_que(pWriteQue,&qNew);
				pVWriteBuf->rwq_rwlen += len;
				if (pVWriteBuf->rwq_rwlen == pVWriteBuf->rwq_torwlen) {

DEBUGOUTL(AKB_LOG_GROUP,"akb_vwqto_wqi:end");

					head->cph_sinf.ind_disp = 255;
				}
#ifndef NO_RWQTIMEOUT
				else akb_set_que_out_time(pVWriteBuf,NULL);
#endif
				iRc = 1;
				break;
			}
		}
	}
	return iRc;
}

static int akb_vch_set_write_que(pWriteQue,pSdNext)
tdtRW_QUE         *pWriteQue;
pSD_PACKET_TABLE  pSdNext;
{
#ifndef NO_RWQTIMEOUT
	akb_set_que_out_time(pWriteQue,NULL);
#endif
	return akb_set_write_que(pWriteQue,pSdNext);
}

int akb_vch_qscheck(pVchHead,iRW)
tdtVCH_HEAD *pVchHead;
int iRW;	/* 0/1=Read/Write */
{
	int i,iRc=0;
	tdtVCH *pVch;

	if (!pVchHead) return -1;
	
	if (iRW) {
		if (akb_qscheck(pVchHead->vh_cnum,pVchHead->vh_wque) > 0) iRc = 1;
		pVchHead->vh_wspd = 0;
		if (pVchHead->vh_nmax > 0) {
			for (i=0;i<pVchHead->vh_cnum;i++) {
				if (pVch=pVchHead->vh_ppvc[i]) {
					if (akb_vch_qscheckSub(pVch->vch_cnum,pVch->vch_wbuf)>0
					    || akxs_rb_get(pVch->vch_vctl)
					    ) pVchHead->vh_wspd++;

DEBUGOUTL3(AKB_LOG_GROUP,
"akb_vch_qscheck: i=%d QSCheck=%d Rbget=%d",i,
akb_vch_qscheckSub(pVch->vch_cnum,pVch->vch_wbuf),akxs_rb_get(pVch->vch_vctl));

				}
			}
			iRc += pVchHead->vh_wspd;
		}

DEBUGOUTL2(AKB_LOG_GROUP,
"akb_vch_qscheck: sVchWSuspend=%d iRc=%d",pVchHead->vh_wspd,iRc);

	}
	return iRc;
}

int akb_vch_rqre_set(pVchHead)
tdtVCH_HEAD *pVchHead;
{
tdtRB_CTL *pRbRCtl,*pRbWWCtl;
	tdtVCH *pVch;
	pSD_PACKET_TABLE   pSdNext, pNew;
	tdtRW_QUE *pReadQue,*pVWriteBuf;
	int iQTbl, iRc, i, iOpt2;
	char *pData;

	if (!pVchHead) return -1;
	if (pVchHead->vh_nmax <= 0) return 0;

	pRbRCtl  = pVchHead->vh_rctl;
	pRbWWCtl = pVchHead->vh_wwtl;
	while (pSdNext=(pSD_PACKET_TABLE)akxs_rb_get_n(pRbRCtl)) {
		akb_trace_out(0,pSdNext->sp_content);
		iQTbl = pSdNext->sp_ch;
		if (iQTbl<0) {
			ERROROUT1("akbWQueSet: invalid iCh=%d",pSdNext->sp_ch);
			Free(pSdNext->sp_content);
			Free(pSdNext);
			continue;
		}
		pVch = pVchHead->vh_ppvc[iQTbl];
		pReadQue = &pVchHead->vh_rque[iQTbl];
		if (pReadQue->rwq_sd < 0) {
			ERROROUT1("akbVchRQueReSet: socket closed iCh=%d",pSdNext->sp_ch);
			Free(pSdNext->sp_content);
			Free(pSdNext);
			akb_clear_rwque(pReadQue,-1);
			if (pVch) {
				akb_vch_free(pVch);
				pVchHead->vh_ppvc[iQTbl] = NULL;
			}
		}
		else {
			if (pVch) {
				if (!(iRc = akb_vrqerr_chk(pVch,pSdNext))) {
					iRc = akb_vrqre_seti(pVch,pSdNext/*,pRbWWCtl*/);
					if (!iRc) {
						iOpt2 = pReadQue->rwq_option;
DEBUGOUTL2(AKB_LOG_GROUP|240,"akb_vch_rqre_set: Ch=%d iOpt2=%08x",iQTbl,iOpt2);
						if (iOpt2) {
							if (iOpt2 & AKB_RQUE_OPT_XTOF) {
								iRc = akbi_xto_fpacket(pSdNext);
							}
							if (iOpt2 & AKB_RQUE_OPT_INDIR) {
								iRc = akbi_from_indir_f(pSdNext);
							}
							if (iRc < 0) {
#if 1
								if (akb_set_rb_pack_err_cd(iQTbl,pSdNext->sp_content,
								                      pRbRCtl,D_ERR_FORM_CHANGE)) {
									ERROROUT("*** akb_vch_rqre_set:Dropped Packet -- akb_set_rb_pack_err_cd error");
									Free(pSdNext->sp_content);
								}
#else
								ERROROUT("*** akb_vch_rqre_set:Dropped Packet -- ERR_FORM_CHANGE");
								Free(pSdNext->sp_content);
#endif
								Free(pSdNext);
								return D_ERR_FORM_CHANGE;
							}
						}
						akxs_rb_set_n(pRbWWCtl,pSdNext);
					}
				}
				else if (iRc > 0) {
					pVWriteBuf = &pVch->vch_wbuf[iRc-1];
					if (pVWriteBuf->rwq_torwlen > 0) {
						if (akb_set_rb_pack_err_cd(iQTbl,pVWriteBuf->rwq_buf,
						                      pRbWWCtl,D_ERR_ERRPACKET))
							Free(pVWriteBuf->rwq_buf);
						else pVWriteBuf->rwq_buf = NULL;
						akb_clear_rwque(pVWriteBuf,0);
					}
				}
			}
			else {
				akxs_rb_set_n(pRbWWCtl,pSdNext);
			}
		}
	}

	while (pSdNext=(pSD_PACKET_TABLE)akxs_rb_get_n(pRbWWCtl)) {
		akxs_rb_set_n(pRbRCtl,pSdNext);
	}
	return 0;
}

static int akb_vrqre_seti(pVch,pSdNext/*,pRbWWCtl*/)
tdtVCH *pVch;
pSD_PACKET_TABLE   pSdNext;
/*tdtRB_CTL *pRbWWCtl;*/
{
	int i,iRc=0,len,seqno;
	tdtRW_QUE *pVReadBuf;
	tdtCOMM_PACK_HEAD *pHs,*pHd,*head;
	short sWrk;
	uchar disp;

	if (!pVch || !pSdNext/* || !pRbWWCtl*/) return -1;

	pVReadBuf = NULL;
	head = (tdtCOMM_PACK_HEAD *)pSdNext->sp_content;
	if ((sWrk=ntohs(head->cph_prt.prt_cmnd)) != AKB_CMD_VCHSEND) {
		ERROROUT1("akb_vrqre_seti:Command(%d) error!!",sWrk);
		goto Err;
	}
	len   = ntohl(head->cph_plen);				/* pPbg           */
	i     = ntohs(head->cph_sinf.ind_prid);	/* Vch                  */
	seqno = ntohl(head->cph_dinf.ind_hoid);
	disp  = head->cph_sinf.ind_disp;

DEBUGOUTL4(AKB_LOG_GROUP,
"akb_vrqre_seti: len=%d i=%d seqno=%d disp=%d",len,i,seqno,disp);

	pVReadBuf = &pVch->vch_rbuf[i];
	if (seqno == 1) {
		if (pVReadBuf->rwq_torwlen > 0) {
			ERROROUT2("pVReadBuf[%d] SeqNo=%d parge!!",i,pVReadBuf->rwq_sd);
			akb_clear_rwque(pVReadBuf,0);
		}
		pVReadBuf->rwq_torwlen = ntohl(head->cph_sinf.ind_hoid);
		pVReadBuf->rwq_buf = Malloc(pVReadBuf->rwq_torwlen);
	}
	if (seqno != ++pVReadBuf->rwq_sd) {
		ERROROUT2("pVReadBuf[%d] SeqNo=%d error!!",i,pVReadBuf->rwq_sd);
		goto Err;
	}
	if (pVReadBuf->rwq_rwlen+len > pVReadBuf->rwq_torwlen) {
		ERROROUT3("pVReadBuf[%d] SeqNo=%d len=%d buffer over!!",
		          i,pVReadBuf->rwq_sd,pVReadBuf->rwq_rwlen+len);
		goto Err;
	}
	memcpy(pVReadBuf->rwq_buf+pVReadBuf->rwq_rwlen,
	       pSdNext->sp_content+sizeof(tdtCOMM_PACK_HEAD),len);
	pVReadBuf->rwq_rwlen += len;

DEBUGOUTL2(AKB_LOG_GROUP,
"akb_vrqre_seti: seqno=%d lRWLen=%d",seqno,pVReadBuf->rwq_rwlen);

	if (disp == 255) {
		if (pVReadBuf->rwq_rwlen == pVReadBuf->rwq_torwlen) {
			pSdNext->sp_len     = pVReadBuf->rwq_torwlen;
			pSdNext->sp_offset   = 0;
			pSdNext->sp_content = pVReadBuf->rwq_buf;
		/*	akxs_rb_set_n(pRbWWCtl,pSdNext);	*/
			pVReadBuf->rwq_buf = NULL;
		}
		else {
			ERROROUT3("pVReadBuf[%d] SeqNo=%d len=%d error!!",
			          i,pVReadBuf->rwq_sd,pVReadBuf->rwq_rwlen);
			goto Err;
		}
		akb_clear_rwque(pVReadBuf,0);
		/* Reply OK */
		head->cph_plen = 0;
		if (akb_set_rb_pack_err_cd(1,head,pVch->vch_vctl,0)) Free(head);
		iRc = 0;
	}
	else {
		Free(pSdNext->sp_content);
		Free(pSdNext);
		iRc = 1;
#ifndef NO_RWQTIMEOUT
		akb_set_que_out_time(pVReadBuf,NULL);
#endif
	}
	return iRc;
 Err:
	if (pVReadBuf) akb_clear_rwque(pVReadBuf,0);
	/* Reply Error */
	head->cph_plen = 0;
	if (akb_set_rb_pack_err_cd(1,pSdNext->sp_content,pVch->vch_vctl,D_ERR_ERRPACKET))
		Free(pSdNext->sp_content);
	Free(pSdNext);
	return -1;
}

/************************************
	iRc = -1 : upPbgłȂ
	    =  0 : MupPbg
	    >= 1 : ԐMupPbg(ERROR)
	    <=-2 : ԐMupPbg(OK)
**************************************/
static int akb_vrqerr_chk(pVch,pSdNext)
tdtVCH *pVch;
pSD_PACKET_TABLE   pSdNext;
{
	tdtRW_QUE *pVReadBuf,*pVWriteBuf;
	int i,iRc=0,len,seqno;
	tdtCOMM_PACK_HEAD *pHead;
	short sWrk,sErr;
	uchar disp;
	char  cPno;

	if (!pVch || !pSdNext) return -1;

	pHead = (tdtCOMM_PACK_HEAD *)pSdNext->sp_content;
	if ((sWrk=ntohs(pHead->cph_prt.prt_cmnd)) != AKB_CMD_VCHSEND) {
		ERROROUT1("akb_vrqerr_chk:Command(%d) error!!",sWrk);
		goto Err;
	}
	if (pHead->cph_sinf.ind_thrd) return 0;

	len   = ntohl(pHead->cph_plen);				/* pPbg           */
	i     = ntohs(pHead->cph_dinf.ind_prid);	/* Vch                  */
	seqno = ntohl(pHead->cph_sinf.ind_hoid);
	disp  = pHead->cph_dinf.ind_disp;
	sErr  = ntohs(pHead->cph_sinf.ind_pano);
	cPno  = ntohs(pHead->cph_dinf.ind_pano);
DEBUGOUTL5(AKB_LOG_GROUP,
"akb_vrqerr_chk: len=%d i=%d seqno=%d disp=%d error=%d",
len,i,seqno,disp,sErr);
	pVWriteBuf = &pVch->vch_wbuf[i];
DEBUGOUTL2(AKB_LOG_GROUP,
"akb_vrqerr_chk: cToF=%x cPno=%x",pVWriteBuf->rwq_tof,cPno);

	if (pHead->cph_sinf.ind_pano) {
		iRc = i + 1;
	}
	else {
		pVWriteBuf = &pVch->vch_wbuf[i];
		if (pVWriteBuf->rwq_torwlen > 0) akb_clear_rwque(pVWriteBuf,0);
		iRc = -i - 2;
	}
	Free(pSdNext->sp_content);
	Free(pSdNext);
	return iRc;
 Err:
	if (akb_set_rb_pack_err_cd(1,pSdNext->sp_content,pVch->vch_vctl,D_ERR_ERRPACKET))
		Free(pSdNext->sp_content);
	Free(pSdNext);
	return -1;
}

int akb_vch_rwque_time_out_timer(iTimerId, cpTimerName, cpParm, tptime)
int iTimerId;
char *cpTimerName;
char *cpParm;
struct timeval *tptime;
{
	tdtVCH_HEAD *pVchHead = (tdtVCH_HEAD *)cpParm;
	tdtVCH     *pVch;
	int i,iWaitTime,iRc;

DEBUGOUTL4(AKB_LOG_GROUP|250,
"akb_vch_rwque_time_out_timer:called TimerId=%d Name=[%s] Parm=%08x time=%d",
iTimerId,cpTimerName,cpParm,tptime->tv_sec);

	iWaitTime = 0;
	if (pVchHead->vh_nmax > 0) {
		for (i=0;i<pVchHead->vh_cnum;i++) {
			if (pVch=pVchHead->vh_ppvc[i]) {
				cpParm = (char *)pVch->vch_rwqt;
				iRc = akb_rwqttimer(iTimerId,cpTimerName,cpParm,tptime);
				if (iRc < 0) return iRc;
				else if (iRc>0 && (!iWaitTime || iRc<iWaitTime))
					iWaitTime = iRc;
			}
		}
	}
	return iWaitTime;
}

int akb_vch_update_flg(pVchHead)
tdtVCH_HEAD *pVchHead;
{
	if (!pVchHead) return 0;
	if (pVchHead->vh_nmax <= 0) return 0;

	pVchHead->vh_flag[1] = pVchHead->vh_flag[0];
	pVchHead->vh_flag[0] = 0;
	if (pVchHead->vh_rspd) pVchHead->vh_flag[0]  = 0x01;
	if (pVchHead->vh_wspd) pVchHead->vh_flag[0] |= 0x02;
	
	return pVchHead->vh_flag[0] ^ pVchHead->vh_flag[1];
}

static int _rel_buf_func(p,pQT,iRW,iTbl)
tdtRWQ_TIME_OUT *p;
tdtQUE_TIME_OUT *pQT;
int iRW,iTbl;
{
	int i;

	return 0;
}

int akb_vch_qscheckSub(iQueMax,QueTbl)
int iQueMax;
tdtRW_QUE QueTbl[];
{
	tdtRW_QUE *pQ;

	if (!QueTbl) return -1;
	while(iQueMax-- > 0) {
		pQ = &QueTbl[iQueMax];
		if (pQ->rwq_torwlen>0 && pQ->rwq_rwlen<pQ->rwq_torwlen) {

DEBUGOUTL3(AKB_LOG_GROUP,
"akb_vch_qscheckSub: i=%d lToRWLen=%d lRWLen=%d",iQueMax,pQ->rwq_torwlen,pQ->rwq_rwlen);

			return 1;
		}
	}
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_vch_wqsetRChaRb(pVchHead)
tdtVCH_HEAD *pVchHead;
{
	static char *p = "akb_vch_wqsetRChaRb";
	int i,ix,iMax,iQTbl,iRc,iRbWUsed,next,*iUChain,offset;
	tdtVCH *pVch;
	tdtRW_QUE *pWriteQue;
	tdtRB_CTL *pRbWCtl,*pRbRCtl;
	tdtRB_CTL **RbWCtlPA, **RbPriCtlPA;
	tdtRB_CTL *pRbWCtlPA, *pRbPriCtlPA;
	tdtRB_CTL *pRbWWCtl,*pRbPWCtl;
	pSD_PACKET_TABLE   pSdNext;

	if (!pVchHead) return -1;

	pRbRCtl  = pVchHead->vh_rctl;
	pRbWCtl  = pVchHead->vh_wctl;
	pRbWWCtl = pVchHead->vh_wwtl;
	if (pVchHead->vh_nmax <= 0)
		return akb_wqset_r(pVchHead->vh_wque,pRbWCtl,pRbWWCtl,pRbRCtl);

	RbWCtlPA = pVchHead->vh_rwpa;
	RbPriCtlPA = pVchHead->vh_rppa;
	pRbPWCtl = pVchHead->vh_rpwc;
	iUChain = pVchHead->vh_htuc;
	offset = pVchHead->vh_offt;
	i = iRbWUsed = 0;
	iMax = next = -1;
	if (!iUChain) {
		ix = 0;
		iMax = offset;
		offset = 0;
	}
	else if (iUChain[0] >= 0) {
		ix = 1;
		next = iUChain[0];
	}
	else {
		ix = -1;
		iMax = iUChain[1];
	}
printf("%s: ix=%d iMax=%d offset=%d next=%d\n",p,ix,iMax,offset,next);
	for (;;) {
		if (ix > 0) {
			if (!next) break;
			iQTbl = next - offset;
			next = iUChain[next];
		}
		else {
			if (i >= iMax) break;
			iQTbl = i + offset;
			i++;
		}
DEBUGOUT3("%s: next=%d iQTbl=%d",p,next,iQTbl);

		pRbPriCtlPA = RbPriCtlPA[iQTbl];
		pRbWCtlPA = RbWCtlPA[iQTbl];
		pVch = pVchHead->vh_ppvc[iQTbl];
		pWriteQue = &pVchHead->vh_wque[iQTbl];
		if (pWriteQue->rwq_sd < 0) {
			for (;;) {
				if (!(pSdNext=(pSD_PACKET_TABLE)akxs_rb_get_n(pRbPriCtlPA))) {
					if (!(pSdNext=(pSD_PACKET_TABLE)akxs_rb_get_n(pRbWCtlPA)))
						break;
				}
				ERROROUT2("%s: socket closed iCh=%d",p,pSdNext->sp_ch);
				akb_wqset_err_reply(p,pSdNext,pRbWWCtl,pRbRCtl,D_ERR_SOCKET_CLOSED);
			}
			akb_clear_rwque(pWriteQue,-1);
			if (pVch) {
				akb_vch_free(pVch);
				pVchHead->vh_ppvc[iQTbl] = NULL;
			}
		}
		else {
			akb_vch_wqsetRChaRbi(pVch,pWriteQue,pRbWCtl,pRbRCtl,
				               pRbWCtlPA,pRbPriCtlPA,pRbWWCtl,pRbPWCtl);
			if (akxs_rb_get(pRbPriCtlPA) || akxs_rb_get(pRbWCtlPA)) iRbWUsed++;
		}
	}
	akb_set_rb_wused(iRbWUsed);
	return 0;
}

/********************************************************/
/*                                                      */
/********************************************************/
int akb_vch_wqsetRChaRbi(pVch,pWriteQue,pRbWCtl,pRbRCtl,
                       pRbWCtlPA,pRbPriCtlPA,pRbWWCtl,pRbPWCtl)
tdtVCH *pVch;
tdtRW_QUE *pWriteQue;
tdtRB_CTL *pRbWCtl,*pRbRCtl;
tdtRB_CTL *pRbWCtlPA, *pRbPriCtlPA;
tdtRB_CTL *pRbWWCtl,*pRbPWCtl;
{
	static char *p="akb_vch_wqsetRChaRbi";
	pSD_PACKET_TABLE   pSdNext;
	tdtRB_CTL *pRbWrkCtl;
	int iQTbl, iRc, i, iOpt;
	char procname[16];
	int iVchWSuspend=0;

	for (;;) {
		pRbWrkCtl = pRbPWCtl;
		if (!(pSdNext=(pSD_PACKET_TABLE)akxs_rb_get_n(pRbPriCtlPA))) {
			pRbWrkCtl = pRbWWCtl;
			if (!(pSdNext=(pSD_PACKET_TABLE)akxs_rb_get_n(pRbWCtlPA)))
				break;
		}

DEBUGOUTL5(AKB_LOG_GROUP,
"akb_vch_wqsetRChaRbi: pSdNext=%08x iCh=%d iLen=%d offset=%d pContent=%08x",
pSdNext,pSdNext->sp_ch,pSdNext->sp_len,pSdNext->sp_offset,pSdNext->sp_content);

		iRc = akb_wqset_make_xf(pWriteQue,pSdNext);
		if (iRc < 0) {
			akb_wqset_err_reply(p,pSdNext,pRbWWCtl,pRbRCtl,D_ERR_FORM_CHANGE);
			continue;
		}
		if (pVch) {
			iRc = akb_vwqseti(pVch,pSdNext,pWriteQue);
		 	if (!iRc) iVchWSuspend++;
		}
		else {
			if (pWriteQue->rwq_torwlen == 0) {
				akb_vch_set_write_que(pWriteQue,pSdNext);
				Free(pSdNext);
				iRc = 0;
			}
			else {

DEBUGOUTL2(AKB_LOG_GROUP,"%s: write que used i=%d.",p,iQTbl);
					iRc = 1;
			}
		}
		if (iRc > 0) akxs_rb_set_n(pRbWrkCtl,pSdNext);
	}

	akxs_rb_exchg(pRbWCtlPA,pRbWWCtl,0);
	akxs_rb_exchg(pRbPriCtlPA,pRbPWCtl,0);

DEBUGOUTL2(AKB_LOG_GROUP,"%s: iVchWSuspend=%d.",p,iVchWSuspend);

	if (iVchWSuspend > 0) {
		if (pVch) {
			akb_vwqto_wqi(pVch,pWriteQue);
		}
	}

	return 0;
}
