static char sccsid[]="%Z% %M% %I% %E% %U%";
/********************************************************************/
/*																	*/
/*		coal  :  COmmon platform Application Language				*/
/*																	*/
/*				By Akito Kobayashi 2010.05.28						*/
/*																	*/
/********************************************************************/

#include "colmn.h"
#define COLMNMAIN	"COAL"
#define DBMNMAIN	"DbMnMain"
#define MSG_TIME_OUT	600	/* sec */
#define INSDSIZE	sizeof(CLPRTBL *)+sizeof(GlobalCt *)+sizeof(AKAMSGCOM)

#define	False	0
#define	True	1

#define	COPYRIGHT	"Coal Project 2010-2020"

extern tdtMSG_CTL tMsgCtl;

extern char version[];
extern char make_date[];

extern int giProgram[];	/* [0] =0:coal, =1:ColMnMain */
						/* [1] = iCmd */
extern int giOptions[];
extern char cmp_sep2[];

extern int iGlSd;
extern int giHOST_ID_SIZE;

extern CLCOMMON CLcommon;
extern CLPRTBL  CLprocTable;
extern GlobalCt GlobTable,*pGlobTable;
extern XHASHB   *xhp_main_def;

extern int col_mn_analz();
extern int cl_shut_class();
extern int coal_start_class();
extern int coal_command_class();
static int _start();

static int  giLF;
static char *cpProcName;
static char memctl[32];

#if 1
static int  iProcId, iCmd, no_extension, level, iUsage, iExit;
static char *service, *cpInitScript, *extension, *reply;
static int  debug_opt[4],max_thread;
#endif

static int _to_num(p,pival)
char *p;
int  *pival;
{
	int ret;

	if (ret=akxcgcvn(p,strlen(p),pival)) {
		iUsage = 2;
		fprintf(stderr,"\n_to_num: invalid number ret=%d\n",ret);
	}
	return ret;
}

static int _cpi2c(d,s,n)
char *d;
int  *s,n;
{
	while (n-- > 0) *d++ = *s++;
	return n;
}

static char *_getverdate(buf,buflen)
char *buf;
int  buflen;
{
	char *pVD[2],*p;
	int  iVDL[2],len;

	aka_get_ver_date(pVD,iVDL);
	buflen -= 2;
	len = memnzcpy(p=buf,pVD[0],iVDL[0],buflen);
	p += len++;
	memcpy(p++," ",2);
	buflen -= len;
	memnzcpy(p,pVD[1],iVDL[1],buflen);
	return buf;
}

static void _print_log_parm(c)
char c;
{
	static int logno_ary[3]={D_LOG_NO_ERROR,D_LOG_NO_PRINT,D_LOG_NO_DEBUG};
	int  n,i,iXLIB;
	long iParm[10];
	char *fn,parm[256],cc;

	if (akxqupper(c)) iXLIB = 1;
	else iXLIB = 0;

	cc = akxcupper(c);
	if (cc=='E')      n = D_LOG_NO_ERROR;
	else if (cc=='P') n = D_LOG_NO_PRINT;
	else if (cc=='D') n = D_LOG_NO_DEBUG;
	else n = -1;

#if 1
	fn = "No  flg grplevel size_max file_max option filename  no check grppriority";
#if 1	/* 2020.3.20 */
	ERRDBGOUTL5(0,fn,0,0,0,0,0);
#else
	fprintf(stderr,"%c%s%c",'\n',fn,'\n');
	DEBUGOUTL(0,fn);
#endif
#else
	fprintf(stderr,"\nNo  flg grplevel size_max file_max option filename  no check grppriority\n");
#endif
	for (i=0;i<3;i++) {
		if (n<0 || i==n) {
			iParm[0] = i;
			if (iXLIB)
				akx_log_set_parm2(1,NULL,10,iParm);
			else
				akb_log_set_parm2(1,NULL,10,iParm);
			if (!(fn=(char *)iParm[6])) fn = AKX_NULL_PRINT;
#if 1
			sprintf(parm,"%2d %04x %08x %8d %8d %06x",
			        i,iParm[1],iParm[2],iParm[3],iParm[4],iParm[5]);
#if 1	/* 2020.3.20 */
			ERRDBGOUTL5(0,"%s %-9s %2d %5d %08x",parm,fn,iParm[7],iParm[8],iParm[9]);
#else
			fprintf(stderr,"%s %-9s %2d %5d %08x\n",parm,fn,iParm[7],iParm[8],iParm[9]);
			DEBUGOUTL5(0,"%s %-9s %2d %5d %08x",parm,fn,iParm[7],iParm[8],iParm[9]);
#endif
#else
			fprintf(stderr,"%2d %04x %08x %8d %8d %06x %-9s %2d %5d %08x\n",
			        i,iParm[1],iParm[2],iParm[3],iParm[4],iParm[5],fn,
			        iParm[7],iParm[8],iParm[9]);
#endif
		}
	}
	fprintf(stderr,"\n");
}

static void _usage(pn)
char *pn;
{
	static char *h[]=
	{"usage: %s [-h|-?|-v|-c] [--{e|p|d|l|E|P|D|L}[LOG_PARM]] [-d[ ]DEBUG_OPTIONS]\n"
	,"            [-s] [-CMD_NO] [-S[ ]proc_no] [-P[ ]port_no] [-i[ ]init_script]"
	,"            [-X|-x[ ]extension] [-o[]EXEC_OPTION] [-t[]max_thread]"
	,"            [-m[level][,[J|E|Other]]] [-r[out_file]] [-D[ ]define]"
	,"            script_name [parm-1 parm-2 ...]"
	,"  where\n    CMD_NO := 0x02:detach, 0x04:listen, 0x08:new channel"
	""
	,NULL
	};
	static char *h_col[]=
	{"usage: %s {SocketId|0} ProcId [ProcName]\n"
	,"            [-h|-?|-v|-c] [--{e|p|d|l|E|P|D|L}[LOG_PARM]] [-d[ ]DEBUG_OPTIONS]"
	,"            [-s] [-X|-x[ ]extension] [-o[]EXEC_OPTION]"
	,"            [-m[level][,[J|E|Other]]]"
	,"  where\n"
	""
	,NULL
	};
	static char *h_c[]=
	{"    LOG_PARM := FLAG,LEVEL,SIZE_MAX,FILE_MAX,OPTION,FILE,PRIORITY"
	""
	,NULL
	};
	char **ph,*p;

	if (!giLF) fprintf(stderr,"\n");
	if (giProgram[0]) ph = h_col;
	else ph = h;
	fprintf(stderr,*ph++,pn);
	while (p = *ph++) fprintf(stderr,"%s\n",p);
	ph = h_c;
	while (p = *ph++) fprintf(stderr,"%s\n",p);
	giLF = 1;
}

static void _set_dbgopt_argv(argv,n,debug_opt,max,msg)
char *argv[],*msg;
int  debug_opt[];
int  n,max;
{
	char *p;
	int i,v,len,pos,v1,ii,nn,m;

	for (i=0;i<n;i++) {
		len = strlen(p=argv[i]);
#if 1	/* 2020.11.19 */
		if (len>0 && akxnskipin(p,len,". \t")<len) {
			pos = instrchar(p,'.');
			m   = instrchar(p,'=');
			if (pos>0 && m>0 && m>pos) ;
			else if (pos>0 && !m) {
				akxccvdotn(p,len,&v);
				debug_opt[i] = v;
				PRINTOUT3("set %s[%2d] = 0x%08x",msg,i,v);
			}
			else
#else
		if (len > 0) {
#endif
#if 1	/* 2019.7.6 */
			if ((pos=akxcgcvn(p,len,&v)) >= 0) {
				ii = i;
				if (pos > 0) {
					p += pos-1;
					if (*p == '=') {
						ii = -1;
						if (v>=1 && v<=max) {
#if 1	/* 2020.11.19 */
							if (instrchar(p+1,'.') > 0) {
								if (akxccvdotn(p+1,len-pos,&v1) >= 0) {
									ii = v - 1;
									v = v1;
								}
							}
							else
#endif
							if (akxcgcvn(p+1,len-pos,&v1) >= 0) {
								ii = v - 1;
								v = v1;
							}
						}
					}
				}
				if (ii >= 0) {
					debug_opt[ii] = v;
					PRINTOUT3("set %s[%2d] = 0x%08x",msg,ii,v);
				}
			}
#else
			if (akxcgcvn(p,len,&v) >= 0) {
				debug_opt[i] = v;
/*
printf("_set_dbgopt: i=%d val=%d\n",i,v);
*/
			}
#endif
		}
	}
}

static void _set_dbgopt(buf,debug_opt,max,msg)
char *buf,*msg;
int  debug_opt[];
int  max;
{
	char *argv[30],parm[256],*p;
	int n;

	n = akxtgetargv2(buf,argv,max,parm,sizeof(parm),4);	/* , */

	_set_dbgopt_argv(argv,n,debug_opt,max,msg);
}

static int _set_log_parm(p)
char *p;
{
	int ret;
	char c;

	if (akxqupper(c=*p))
		ret = akx_log_set_command_parm(c,p+1);
	else
		ret = akb_log_set_command_parm(c,p+1);

	if (ret < 0) {
		if (ret == -1) {
			ERROROUT("internal error!!");
			exit(2);
		}
		return 2;
	}
	_print_log_parm(c);
	return 0;
}

static void _get_vc(p,copy_right)
char *p,*copy_right;
{
	int  i;
	char c;

	i = 0;
	c = *p;
	if (c == 'v') i |= 1;
	if (c == 'c') i |= 2;
	if (*(p+1) == 'v') i |= 1;
	if (*(p+1) == 'c') i |= 2;
	if (!giLF) fprintf(stderr,"\n");
	if (i & 1) fprintf(stderr," %s\n",_getverdate(LOGBUF(0),LOGBUFLEN(0)));
	if (i & 2) fprintf(stderr," (c) Copyright %s\n",copy_right);
	fprintf(stderr,"\n");
	giLF = 1;
}

static void _log_set_up(level,cpProcName)
int level;
char *cpProcName;
{
	LOGLEVEL(D_LOG_NO_ERROR,level);
	LOGLEVEL(D_LOG_NO_PRINT,level);
	LOGLEVEL(D_LOG_NO_DEBUG,level);
	LOGFLG(D_LOG_NO_PRINT,D_LOG_FLG_STDOUT);
	akb_log_set_up_name(cpProcName);
	LOGBUF(256);
}

static void _log_clear_no(no)
int no;
{
	int iParm[10];

	if (akb_log_flg(no,D_LOG_FLG_CHECK) & D_LOG_FLG_LOG_CLEAR) {
		akb_log_out_level_main(no,0x1ff,"",0,"",0,0,0,0,0);
		akb_log_clear(no,0);
		iParm[0] = no;
		akb_log_set_parm2(1,NULL,10,iParm);
		PRINTOUT2("log no=%d file=[%s]  cleared.",no,iParm[6]);
	}
}

static void _log_clear()
{
	_log_clear_no(D_LOG_NO_ERROR);
	_log_clear_no(D_LOG_NO_PRINT);
	_log_clear_no(D_LOG_NO_DEBUG);
}

static void _stat_memory()
{
	long parm[12];

	akxm_stat_memory(12,parm);
	if (parm[8]) {
		PRINTOUT4("Memory: ctl=[%s], AFHASH=%d, AFDUMP=%d, NFDUMP=%d",
		          parm[4],parm[11],parm[9],parm[10]);
		PRINTOUT3("        maxreg=%d, af=[%s], nf=[%s]",
		          parm[5],parm[6],parm[7]);
	}
}

static void _set_msg_level(buf)
char *buf;
{
	char *argv[2],parm[16],*p,c;
	int n,i,t,len,level,rc;

	n = akxtgetargv2(buf,argv,2,parm,sizeof(parm),4);	/* , */
	if (n <= 0) {
		level = 1;
		LOGLEVEL(D_LOG_NO_PRINT,level);
		LOGLEVEL(D_LOG_NO_DEBUG,level);
	}
	for (i=0;i<n;i++) {
		len = strlen(p=argv[i]);
		if (len > 0) {
			rc = akxcgcvn(p,len,&t);
			if (i==0 && !rc) {
				level = t;
				LOGLEVEL(D_LOG_NO_PRINT,level);
				LOGLEVEL(D_LOG_NO_DEBUG,level);
			}
			else if (i==1) {
				if (!rc) {
					if (t<0 || t>2) t = 0;
				}
				else {
					if ((c=toupper(*p)) == 'J') t = 0;
					else if (c == 'E') t = 1;
					else t = 2;
				}
				giOptions[13] = t;
			}
		}
	}
}

static int _set_define(parm)
char *parm;
{
	int i,parmlen,keylen;
	char c,c1,*p,*val;
	SSP_S ssp;

DEBUGOUTL1(1,"_set_define: parm=[%s]",parm);

	if (!xhp_main_def) {
		xhp_main_def = akxs_xhash_new2(0,10,7,0);
	}
	parmlen = strlen(parm);
	ssp.sp = 0;
	keylen = akxtgwns(parm,parmlen,&ssp,cmp_sep2,0x21);
	if (keylen<=0 || ssp.attr[0]!=1) return -1;
	p = ssp.wd;
	if (ssp.sp < parmlen) {
		if ((c=parm[ssp.sp])=='(') {
			p = strmem(p,keylen);
			val = parm + ssp.sp;
			i = akxs_in_mem_opt(val,parmlen-ssp.sp,"=",1,0);
			if (i > 0) {
				if (--i <= 0) return -1;
				val[i] = ' ';
			}
		}
		else if (c == '=') {
			parm[ssp.sp] = '\0';
			val = parm + ssp.sp + 1;
		}
		else return -1;
	}
	else val = "";
	val = stradd(val," ");

/*DEBUGOUTL2(1,"_set_define: key=[%s] val=[%s]",p,val);
PRINTOUT2("_set_define: key=[%s] val=[%s]",p,val);*/
PRDBGOUTL2(1,"_set_define: key=[%s] val=[%s]",p,val);

	return akxs_xhash2(xhp_main_def,'S',p,val);
}

static int _set_opt(pargc,pargv,key)
int  *pargc;
char **pargv[],*key;
{
	int  argc,i;
	char **argv,*p,c;

	argc = *pargc;
	argv = *pargv;
	while (argc > 0) {
		p = argv[0];
		if ((c=*p) == '-') {
			p++;
			if ((c=*p) == '-') {
				p++;
				iUsage = _set_log_parm(p);
			}
			else if (c == 'm') {
				_set_msg_level(p+1);
			}
			else if (c == 's') {
				level = 0;
			/*	LOGLEVEL(D_LOG_NO_ERROR,level);	*/
				LOGLEVEL(D_LOG_NO_PRINT,level);
				LOGLEVEL(D_LOG_NO_DEBUG,level);
			}
			else if (!giProgram[0] && c>='0' && c<='9') {
				if (_to_num(p,&iCmd)) break;
				if (iCmd < 0) iCmd = -iCmd;
				if (iCmd & (0x02 | 0x08)) iCmd |= 0x04;
				giProgram[1] = iCmd;
				iCmd = -iCmd;
				iExit = 0;
			}
			else if (c == 'X') {
				no_extension = 1;
			}
			else if (strchr(key,c)) {
				if (*(p+1)) p++;
				else if (--argc > 0) {
					argv++;
					p = argv[0];
					if (*p=='-' || argc==1) {
						iUsage = 2;
						break;
					}
				}
				else {
					iUsage = 2;
					break;
				}
				if (c == 'P') service = p;
				else if (c == 'S') {
					if (_to_num(p,&i)) break;
					if (i >= 0 && i <= AKB_PID_MAX) iProcId = i;
				}
				else if (c == 'd') {
					_set_dbgopt(p,debug_opt,sizeof(debug_opt)/sizeof(int),"debug_opt");
				}
				else if (c == 'o') {
					_set_dbgopt(p,giOptions,MAX_OPTIONS,"giOptions");
					if (giOptions[0]) cl_mod_option(1,1);
					if (giOptions[8]) cl_mod_option(9,1);
					if (giOptions[2]) cl_mod_option(3,1);
					if (giOptions[20]) cl_mod_option(21,1);
				}
				else if (c == 'x') {
					if (*p == '.') extension = NULL;
					else extension = p;
				}
				else if (c == 'i') {
					cpInitScript = p;
				}
				else if (c == 't') {
					if (_to_num(p,&max_thread)) break;
					if (max_thread<=0 || max_thread>252) max_thread = 1;
				}
				else if (c == 'D') {
					if (_set_define(p) < 0) {
						iUsage = 2;
						break;
					}
				}
			}
			else if (c == 'v' || c == 'c') {
				_get_vc(p,COPYRIGHT);
			}
			else if (c == 'r') {
				reply = p + 1;
			}
			else {
				iUsage = 2;
				break;
			}
		}
		else {
			iExit = 0;
			break;
		}
		argc--;
		argv++;
	}
	*pargc = argc;
	*pargv = argv;
	return 0;
}

void _set_log_flg_cd_opt(log_no,kind)
int log_no,kind;
{
	int flag,opt;

	opt = (cl_get_option(21,0) & D_CODE_OUTPUT_MASK);
	if (cl_get_option(9,0) & 0x08) opt |= CD_USE_CODE_CONV;
	opt <<= 16;
	if (log_no >= 0) {
		if (!kind) kind = 0x03;
		if (kind & 0x01) {
			flag = XLOGFLG(log_no,-1) & ~D_LOG_FLG_CD_OPT;
			XLOGFLG(log_no,flag | opt);
		}
		if (kind & 0x02) {
			flag = LOGFLG(log_no,-1) & ~D_LOG_FLG_CD_OPT;
			LOGFLG(log_no,flag | opt);
		}
	}
	else {
		_set_log_flg_cd_opt(X_LOG_NO_ERROR,kind);
		_set_log_flg_cd_opt(X_LOG_NO_PRINT,kind);
		_set_log_flg_cd_opt(X_LOG_NO_DEBUG,kind);
	}
}

int main(argc, argv)
int  argc;
char *argv[];
{
	int	ret, flg;

#ifdef CYGWIN_U8	/* 2020.5.5 */
	akxt_set_code_type(CD_TYPE_UTF8);
#else
	if ((ret = akxt_get_lang_type("LANG",0,NULL,0)) >= 0) akxt_set_code_type((uchar)ret);
#endif
	cpProcName = akxt_get_last_name("\\/",argv[0]);
	strnzcpy(memctl,cpProcName,sizeof(memctl)-5);
	strcat(memctl,".ctl");
	reply = NULL;

	if (inistr(argv[0],"Doc") > 0) flg = 0;
	else if (argc > 1) flg = cl_chk_digit(10,argv[1],strlen(argv[1]));
	else flg = 1;
	if (flg) {
		giProgram[0] = 0;
		coal_main(argc, argv);
	}
	else {
		giProgram[0] = 1;
		doc_main(argc, argv);
	}
	akb_gs_akb_stplix(0,0,0,0,0,AKX_GSSTPLX_CACHE_INVALID);
	if ((ret=Nofree(0)) >= 0) {
	/*	PRINTOUT1("**** end nofree no=%d ****",ret);
		DEBUGOUTL1(1,"**** end nofree no=%d ****",ret);	*/
		PRDBGOUTL1(1,"**** end nofree no=%d ****",ret);
	}
	akb_log_free();
	exit(0);
}

int coal_main(argc, argv)
int  argc;
char *argv[];
{
	long parm[12];
	int  ret,i;
	char *p,c;

	Meminit(memctl);
	aka_set_ver_date(version,make_date);
	level = 0;
	_log_set_up(level,cpProcName);
	LOGLEVEL(D_LOG_NO_ERROR,1);

	memset(debug_opt,0,sizeof(debug_opt));
	cpInitScript = NULL;
	giProgram[1] = iCmd = 0;
	iProcId = D_PRID_COL;
	service = NULL;
	extension = SCR_EXTENSION;
	if (p = getenv(DEF_SCREXTENSION)) {
		if (*p == '.') extension = NULL;
		else extension = p;
	}
	iExit = 1;
	giLF = no_extension = 0;
	max_thread = 1;
	giOptions[13] = -1;
	argc--;
	argv++;
	if (argc <= 0) iUsage = 1;
	else iUsage = 0;

	_set_opt(&argc,&argv,"PSdxoitD");

	if (iExit || (!(iCmd & 0x0e) && argc<=0)) {
		if (iUsage) _usage(cpProcName);
		exit(1);
	}
	_log_clear();
	_stat_memory();

#ifdef TIME
	akb_ptime('I',"coltime.dump");
	akb_ptime('S',"NULL");
	akb_ptime('E',"NULL");
#endif

	/* ^CAEgpnho^ */
	signal(SIGALRM, sock_time);
	siginterrupt(SIGALRM, 1);

	/* ^CAEgԐݒ */
	akaSetComTimeOut(cpProcName);
DEBUGOUT1("Time Out = %d Second/4KByte",akb_get_time_out());

	/* vZX̏ */
	if (col_mn_init()) {
		ERROROUT(FORMAT(1));	/* vZX̏s */
		exit(1);
	}

	_set_log_flg_cd_opt(-1,0);

	if (cl_getenvf()) exit(2);

	if (cl_get_host_id()) exit( 3 );
	akb_get_host_addr(NULL,&CLcommon.iOwnIPAddr);

#ifdef MSPACE	/* 2000.6.22 Koba */
	/* ʊi[Xy[X쐬 */
	ret = akxa_ms_create(akb_akb_home_add("MemSpace"));
	if (ret) {
		ERROROUT1(FORMAT(2),ret);
		exit(4);
	}
#endif

	CLcommon.ScrPathp   = getenv(DEF_SCRPATH);
	CLcommon.CmdScriptp = getenv(DEF_CMDSCRIPT);
	if (!(CLcommon.pHomeDir = getenv(DEF_HOME))) CLcommon.pHomeDir = "";
/*
printf("main: CLcommon.pHomeDir=[%s]\n",CLcommon.pHomeDir);
*/
	CLcommon.cDataCode = akxt_get_code_type();
	if (htons(1) == 1) CLcommon.ucByteOrder = 0;
	else               CLcommon.ucByteOrder = 1;
	_cpi2c(CLcommon.dbgopt,debug_opt,
	       X_MIN(sizeof(CLcommon.dbgopt)/sizeof(char),sizeof(debug_opt)/sizeof(int)));

	strnzcpy(pGlobTable->Hid,CLcommon.dcHostId,sizeof(pGlobTable->Hid)-1);
	CLcommon.ProcessId = iProcId;
	CLcommon.pExtension = extension;
	if (no_extension) CLcommon.pExtension = NULL;
/*
if (CLcommon.pExtension) printf("main: CLcommon.pExtension=[%s]\n",CLcommon.pExtension);
else  printf("main: CLcommon.pExtension=[(null)]\n");
*/
/*
printf("main: iCmd=%d iProcId=%d max_thread=%d\n",iCmd,iProcId,max_thread);
*/
	parm[0] = iCmd;
	parm[1] = iProcId;
	parm[2] = max_thread+3;
	parm[3] = AKA_MSO_EXEC_NOFREE;
	parm[4] = 0;
	parm[5] = 0;
	parm[6] = (long)service;
	ret = aka_initialize3(7,parm);
	if (ret) ERROROUT1("aka_initialize ret=%d",ret);
	else {
		aka_set_nofree(1,1);
		PRINTOUT2("coal_main: msg_time_out=%d(sec) max_thread=%d",
		          aka_set_msg_time_out(-1)/1000,max_thread);
		if (ret = aka_register_class3(col_mn_analz,D_CLASS_COL,INSDSIZE,max_thread,
					AKA_RCO_NODISPLAY,"execute script",cpInitScript))
			ERROROUT1("aka_register_class2(col_mn_analz) ret=%d",ret);
		else if (ret = aka_register_class2(coal_command_class,2,0,1,0,
					"Command line"))
			ERROROUT1("aka_register_class2(coal_command_class) ret=%d",ret);
		else if (ret = aka_register_class3(coal_start_class,3,0,1,AKA_RCO_NODISPLAY,
					"Start coal",reply))
			ERROROUT1("aka_register_class2(coal_start_class) ret=%d",ret);
		else if (ret = aka_register_class2(cl_shut_class,
		            AKA_CLASS_SHUT|AKA_CLASS_ADDFUNC2,16,2,0,"CL_SHUT"))
			ERROROUT1("aka_register_class(Shut) ret=%d",ret);
		else if (ret = aka_register_class2(cl_shut_class,
		            AKA_CLASS_FSHUT|AKA_CLASS_ADDFUNC2,0,0,-1,"CL_FSHUT"))
			ERROROUT1("aka_register_class(FShut) ret=%d",ret);
		else {
			PRINTOUT("**** Start ****");
		/*	if (!iCmd) */_start(argc,argv);
			/* Iv܂Ń[v */
			while ((ret = aka_get_msg(-1))>=0) {
				if (ret = aka_dispatch_msg()) break;
			}
			PRINTOUT1("aka_get_msg/dispatch ret=%d",ret);
		}
		aka_terminate();
	}

#ifdef MSPACE	/* 2000.6.22 Koba */
	/* ʊi[Xy[X폜 */
	akxa_ms_drop();
#endif

	/* I */
	ret = col_mn_term();
#ifdef TIME
akb_ptime('T',NULL);
#endif
	return 0;
}

/***************************************/
/*  zXghcAhoAhX̎肾 */
/***************************************/
int cl_get_host_id ()
{
	int		irc;
	char	*argv[3],*pHostId1;
	char	*pHostId2;

	/* zXghc̎o */
	if ((irc=akb_gs_akb_stpl(COLMNMAIN,"HOST_ID_SIZE",argv,1)) < 2) {
		giHOST_ID_SIZE = HOST_ID_SIZE;
	}
	else {
		if ((giHOST_ID_SIZE=atoi(argv[1])) <= 0) {
			ERROROUT(FORMAT(3));	/* zXghcsłB */
			return -1;
		}
	}
	PRINTOUT1(FORMAT(10),giHOST_ID_SIZE);

	/* zXghcAcazXghc̎o */
	if ((irc=akb_gs_akb_stpl(COLMNMAIN,"MYDCHOST",argv,3)) < 2) {
		if (giProgram[0]) {
			ERROROUT(FORMAT(4));
			return -1;
		}
		CLcommon.dcHostId = "";
		CLcommon.dbHostId = "";
		return 0;
	}
	else {
		pHostId1 = argv[1];
		if ( irc == 3 )
			pHostId2 = argv[2];
		else	/* zXghĉݎo */
			pHostId2 = pHostId1;

		CLcommon.dcHostId = Strdup(pHostId1);
		CLcommon.dbHostId = Strdup(pHostId2);
		PRINTOUT2(FORMAT(5),pHostId1,pHostId2);	/* zXgID:%s  DBzXgID:%s */

if (giProgram[0]) {
		/* zXghcAcazXghc`FbN */
		if ( strlen( pHostId1 ) != giHOST_ID_SIZE )
		{
			ERROROUT (FORMAT(6));
			return(-1);
		}
		if ( strlen( pHostId2 ) != giHOST_ID_SIZE )
		{
			ERROROUT (FORMAT(7));
			return(-1);
		}

		/* zXghchoAhXϊ */
		irc = cl_process_get_ipaddr( pHostId1, &CLcommon.iOwnIPAddr );
		if ( irc < 0 ) {
			ERROROUT(FORMAT(8));
			return(-1);
		}

		/* cazXghchoAhXϊ */
		irc = cl_process_get_ipaddr( pHostId2, &CLcommon.dbHostAddr );
		if ( irc < 0 ) {
			ERROROUT(FORMAT(9));
			return(-1);
		}
}
	}
	return NORMAL;
}

int cl_getenvf()
{
	char buf[D_RECORD_BUFSIZE],*argv[MAX_OPTIONS+1],c,wrk[20],*p;
	int n, t, rc, iRc, i, buf_len;

	t = MSG_TIME_OUT;

	n = akb_gs_akb_name(COLMNMAIN,"MSGTIMEOUT",buf);
	if (n > 0) {
		if ((n=atoi(buf)) > 0) {
			t = n;
			aka_set_msg_time_out(t*1000);
		}
	}
/*	Dm_Inf.msg_time_out = t;	*/
	PRINTOUT1("cl_getenvf: start_msg_time_out = %d (sec)",t);

	t = LRU_SCR_MAX;
	n = akb_gs_akb_name(COLMNMAIN,"LRU_SCR_MAX",buf);
	if (n > 0) {
		if ((n=atoi(buf)) > 0) t = n;
	}
	rc = cl_lru_scr_init(t);
	if (rc) return rc;

	iRc = akb_gs_akb_stpl(COLMNMAIN,"OPTIONS",argv,MAX_OPTIONS+1);
	if (iRc > 1) {
		buf[0] = '\0';
		buf_len = sizeof(buf) - 1;
		p = buf;
#if 1	/* 2020.10.20 */
		rc = iRc - 1;
		_set_dbgopt_argv(&argv[1],rc,giOptions,MAX_OPTIONS,"giOptions");
		if (giOptions[0]) cl_mod_option(1,1);
		if (giOptions[8]) cl_mod_option(9,1);
		if (giOptions[2]) cl_mod_option(3,1);
		if (giOptions[20]) cl_mod_option(21,1);
		for (i=0;i<MAX_OPTIONS;i++) {
			sprintf(wrk," %x",giOptions[i]);
			n = strlen(wrk);
			memnzcpy(p,wrk,n,buf_len);
			buf_len -= n;
			p += n;
		}
#else
		for (i=1;i<iRc;i++) {
			if (!akxcgcvn(argv[i],strlen(argv[i]),&t)) {
				if (t >= 0) {
					giOptions[i-1] = t;
					if (i <= 3) {
						cl_mod_option(i);
						t = giOptions[i-1];
					}
				}
			}
			if (buf_len > 0) {
				sprintf(wrk," %x",t);
				n = strlen(wrk);
				memnzcpy(p,wrk,n,buf_len);
				buf_len -= n;
				p += n;
			}
		}
#endif
		PRINTOUT1("cl_getenvf: options=%s",buf);
	}
	if (giOptions[13] < 0) {
		t = 0;
		n = akb_gs_akb_name(COLMNMAIN,"MSGLANG",buf);
		if (n > 0) {
			if ((c=toupper(*buf)) == 'J') t = 0;
			else if (c == 'E') t = 1;
			else t = 2;
		}
		giOptions[13] = t;
	}

	/* DB_SERVER  DbProcId  DbSQLClass  [DbServer] */
	CLcommon.usDbProcId  = D_PRID_DB;
	CLcommon.usDbClassId = D_CLASS_DB;
	CLcommon.iDbProcNum  = 1;

if (giProgram[0]) {
	iRc = akb_gs_akb_stpl(COLMNMAIN,"DB_SERVER",argv,4);
	if (iRc >= 3) {
DEBUGOUTL3(10,"cl_getenvf: db server proc=[%s],class=[%s],host=[%s]",
argv[1],argv[2],argv[3]);
		if ((CLcommon.usDbProcId=atoi(argv[1])) <= 0) {
			ERROROUT1("init:Invalid DbProcId=[%s]",argv[1]);
			return -2;
		}
		if ((CLcommon.usDbClassId=atoi(argv[2])) <= 0) {
			ERROROUT1("cl_getenvf: Invalid DbClass=[%s]",argv[2]);
			return -3;
		}
	}
	else {
		ERROROUT("cl_getenvf: undefined DB_SERVER entry. use default.");
	}
/*
	if (iRc >= 4) {
		iRc = akb_get_host_addr(argv[3],&CLcommon.dbHostAddr);
		if (iRc < 0) {
			return -4;
		}
	}
*/

	n = akb_gs_akb_name(COLMNMAIN,"MULTI_DB",buf);
	if (n > 0) {
		if ((n=atoi(buf)) > 1) CLcommon.iDbProcNum = n;
	}
	PRINTOUT2("cl_getenvf: DbProcId=%d DbProcNum=%d",
	          CLcommon.usDbProcId,CLcommon.iDbProcNum);
}
	n = akb_gs_akb_name(COLMNMAIN,"UTF8_CONV",buf);
	if (n > 0) {
#if 1
		rc = akxc_set_utf8_file(buf);
#else
		rc = akxc_set_sj_utf8(buf);
#endif
		PRINTOUT2("cl_getenvf: UTF8_CONV=[%s] rc=%d",buf,rc);
	}
	return 0;
}

int coal_make_pkt_form(argc, argv, data, buflen)
int  argc;
char **argv;
long data[];
int  buflen;
{
	tdtINFO_PARM  InfoParm;
	TrmToSrv   *tpTrmToSrv ;
	int i, len, lw, ret;
	char *p;
	tdtUserInf *pUserInf;
/*
printf("coal_make_pkt_form: argc=%d argv[0]=[%s]\n",argc,argv[0]);
*/
	if (buflen < sizeof(TrmToSrv)) return 0;
	p = (char *)data;
	tpTrmToSrv = (TrmToSrv *)p;
	pUserInf = (tdtUserInf *)tpTrmToSrv->userid;
	memset(tpTrmToSrv ,0, sizeof(TrmToSrv));
	memcpy(pUserInf->user_cd,"CMNDLINE",sizeof(pUserInf->user_cd));
/*	tpTrmToSrv->parmnum   = htonl(argc);	*/
	len = sizeof(TrmToSrv);
	p += len;
	InfoParm.pi_attr = DEF_ZOK_CHAR;
	InfoParm.pi_code = akxt_get_code_type();
	for (i = 0 ; i < argc ; i++) {
		InfoParm.pi_dlen = strlen(argv[i]);
		InfoParm.pi_data = argv[i];
		lw = InfoParm.pi_dlen <= 255 ? 2 : 6;
		if (len+InfoParm.pi_dlen+lw > buflen) break;
		lw = cm_set_pkt_form(&InfoParm ,p);
		len += lw;
		p   += lw;
	}
DEBUGOUTL3(10,"coal_make_pkt_form: len=%d argc=%d i=%d",len,argc,i);
	tpTrmToSrv->parmnum = htonl(i);
	return len;
}

#ifdef SUNOS5
static int _start(int argc, char **argv)
#else
static int _start(argc, argv)
int  argc;
char **argv;
#endif
{
	AKAMSGCOM  tMsgCom;
	int len, ret;
	long data[1024];
/*
printf("_start: argc=%d argv[0]=[%s]\n",argc,argv[0]);
*/
	if (argc <= 0) return 0;
	len = coal_make_pkt_form(argc,argv,data,sizeof(data));

	memset((char *)&tMsgCom,0,sizeof(AKAMSGCOM));
	tMsgCom.msg_clid = 3;
	tMsgCom.msg_mlen = len;
	tMsgCom.msg_pmsg = (char *)data;
	if ((ret = aka_post_msg(0,&tMsgCom)) < 0)
		ERROROUT1("_start: aka_post_msg ret=%d",ret);
	return ret;
}

int doc_main(argc, argv)
int  argc;
char *argv[];
{
	int  ret, iSd;
	char *p, c;

	/****************************************************/
	/* vZXǗNꂽƂ́Aȉn */
	/*   argv[1]:ڑς݂̃\Pbgԍ (Sd)            */
	/*   argv[2]:vZXԍ           (ProcId)        */
	/*   argv[3]:vZX             (ProcName)      */
	/*   argv[4]:p[^             (Parm)          */
	/****************************************************/
	if (argc < 3) {
		_usage(cpProcName);
	/*	fprintf(stderr,"Usage: %s {SocketId|0} ProcId [ProcName]\n",cpProcName);	*/
		exit( 1 );
	}
	if (*argv[1]=='-' || *argv[2]=='-') {
		_usage(cpProcName);
		exit( 1 );
	}

#ifdef TIME
	akb_ptime('I',"coltime.dump");
	akb_ptime('S',"NULL");
	akb_ptime('E',"NULL");
#endif

	/* ^CAEgpnho^ */
	signal(SIGALRM, sock_time);
	siginterrupt(SIGALRM, 1);

	Meminit(memctl);
	aka_set_ver_date(version,make_date);
#if 1
	if (ret=akxcgcvn(argv[1],strlen(argv[1]),&iSd)) {
		fprintf(stderr,"col_mai: SocketId is invalid(ret=%d).\n",ret);
		exit( 1 );
	}
	if (ret=akxcgcvn(argv[2],strlen(argv[2]),&iProcId)) {
		fprintf(stderr,"col_mai: ProcId is invalid(ret=%d).\n",ret);
		exit( 1 );
	}
#else
	iSd     = atoi(argv[1]);
	iProcId = atoi(argv[2]);
#endif
	if (argc>=4 && *argv[3]!='-') {
		cpProcName = argv[3];
		argc--;
		argv++;
	}
	level = 1;
	_log_set_up(level,cpProcName);
	LOGLEVEL(D_LOG_NO_ERROR,1);

	memset(debug_opt,0,sizeof(debug_opt));
/*	extension = SCR_EXTENSION;	*/
	extension = NULL;
	if (p = getenv(DEF_SCREXTENSION)) {
		if (*p == '.') extension = NULL;
		else extension = p;
	}
	iExit = 0;
	giLF = 0;
	no_extension = 1;
	giOptions[13] = -1;
	argc -= 3;
	argv += 3;
	iUsage = 0;

	_set_opt(&argc,&argv,"dxo");

	if (iExit || iUsage) {
		if (iUsage) _usage(cpProcName);
		exit(1);
	}
	_log_clear();
	_stat_memory();

	if (iSd == 0) {
		iSd = akb_connect_prom(0,0);
		PRINTOUT1("akb_connect_prom ret=%d",iSd);
		if (iSd <= 0) exit(1);
	}
	else if (iSd < 0) exit(2);

DEBUGOUT2("Socket=%d, ProcId=%d",iSd,iProcId);

	/* ^CAEgԐݒ */
	akaSetComTimeOut(cpProcName);
DEBUGOUT1("Time Out = %d Second/4KByte",akb_get_time_out());

	/* vZX̏ */
	if (col_mn_init()) {
		ERROROUT(FORMAT(1));
		exit(1);
	}

	_set_log_flg_cd_opt(-1,0);

	if (cl_getenvf()) exit(2);

	/* get colument netID */
	ret = cl_get_host_id ();
	if ( ret != NORMAL ) exit( 3 );

#ifdef MSPACE	/* 2000.6.22 Koba */
	/* ʊi[Xy[X쐬 */
	ret = akxa_ms_create(akb_akb_home_add("MemSpace"));
	if (ret) {
		ERROROUT1(FORMAR(2),ret);
		exit(4);
	}
#endif

	CLcommon.ScrPathp   = getenv( DEF_SCRPATH );
	CLcommon.CmdScriptp = getenv( DEF_CMDSCRIPT );
	if (!(CLcommon.pHomeDir = getenv(DEF_HOME))) CLcommon.pHomeDir = "";
/* 1999.5.18 Koba
	CLcommon.cDataCode = CD_TYPE_MACHINE;
*/
	CLcommon.cDataCode = akxt_get_code_type();
	if (htons(1) == 1) CLcommon.ucByteOrder = 0;
	else               CLcommon.ucByteOrder = 1;
	_cpi2c(CLcommon.dbgopt,debug_opt,
	       X_MIN(sizeof(CLcommon.dbgopt)/sizeof(char),sizeof(debug_opt)/sizeof(int)));

	memcpy(pGlobTable->Hid,CLcommon.dcHostId,4);
	CLcommon.ProcessId = iProcId;
	CLcommon.pExtension = extension;
	if (no_extension) CLcommon.pExtension = NULL;

	/* N̒ʒmpPbg */
	ret = aka_regist(iSd,iProcId);
	if (ret) ERROROUTRC("aka_regist ret=",ret);
	else {
		ret = aka_initialize(iSd,iProcId,STACKMAX+3);
		if (ret) ERROROUTRC("aka_initialize ret=",ret);
		else {
			aka_set_nofree(1,1);
			PRINTOUT1("dmmain: msg_time_out = %d",aka_set_msg_time_out(-1));
			if (ret = aka_register_class2(col_mn_analz,D_CLASS_COL,INSDSIZE,STACKMAX,0,
						"execute script"))
				ERROROUT1("aka_register_class(dmClass) ret=%d",ret);
			else if (ret = aka_register_class2(coal_command_class,2,0,1,0,
						"Command line"))
				ERROROUT1("aka_register_class2(coal_command_class) ret=%d",ret);
			else {
				PRINTOUT("**** Start ****");
				/* Iv܂Ń[v */
				while ((ret = aka_get_msg(-1))>=0) {
					if (ret = aka_dispatch_msg()) break;
				}
				PRINTOUT1("aka_get_msg/Dispatch ret=%d",ret);
			}
			aka_terminate();
		}
		aka_cancel(iSd,iProcId);
	}
	aka_shut_down(iSd);

#ifdef MSPACE	/* 2000.6.22 Koba */ 
	/* ʊi[Xy[X폜 */
	akxa_ms_drop();
#endif 

	/* I */
	ret = col_mn_term();
#ifdef TIME
akb_ptime('T',NULL);
#endif
	return 0;
}

int cl_main_set_opt(pargc,pargv)
int  *pargc;
char **pargv[];
{
	iExit = iUsage = 0;
	_set_opt(pargc,pargv,"dxo");
	if (iUsage) _usage(cpProcName);

	_cpi2c(CLcommon.dbgopt,debug_opt,
	       X_MIN(sizeof(CLcommon.dbgopt)/sizeof(char),sizeof(debug_opt)/sizeof(int)));

	if (no_extension) CLcommon.pExtension = NULL;
	else CLcommon.pExtension = extension;

	return iExit+iUsage;
}

