static char sccsid[]="%Z% %M% %I% %E% %U%";
/**************************************/
/* ʃvbgz[~             */
/*                                    */
/*   updated by A.Kobayashi 2001/8/2  */
/**************************************/
#include    "akacommon.h"
#include	"akmmi.h"
#define     PSZ char *
/*  DEBUG   SWITCH  */
#define DEBUG	0
#define DBG     0
#define HOSTNAME    "ldhost"
#define TRMNNAME    "cpTrMain"
#define SERVICE     "Term_Port"
#define PORTNO      65535
#define PID         AKB_PID_MAX
#define PROGRAM     "SHUT V4.1"

static HEAD	Head_w;
static HEAD	Head_r;
static HEAD *pHead;
static char buf[4096];
static int timeset[3];
static ushort sPid;

static int _recv_msg();

static int _send_passwd(fd,buf,len)
int  fd,len;
char *buf;
{
	int ret;

	if ((ret=akb_sk_write(fd, buf, len)) != len) {
		if (ret == -2) {
			printf("[SHUT] write timeout\n");
		}
		else {
			printf("[SHUT] write error\n");
		}
	} else ret = _recv_msg(fd, buf);
	return ret;
}

static int sk_read( fd, buff, size )
int  fd;
char *buff;
int	size;
{
	return akb_sk_read(fd, buff, size);
}

static int _recv_msg(fd, buf)
int  fd;
char *buf;
{
	char   c, *p;
	short  cmnd, sRetCode;
	ushort usClassId;
	int    ret,len;
	short  sw;
	INT4   lw,lwk;

 ReRead:
	ret = sk_read(fd, (char *)&Head_r, sizeof(HEAD));
	if (ret != sizeof(HEAD)) {
		if (ret == -2) {
			printf("[SHUT] read timeout\n");
		}
		else {
			printf("[SHUT] Read error ret=%d errno=%d %s\n",
			       ret,errno,strerror(errno));
		}
		goto End;
	}
	if (Head_r.sled_s) { /* Command packet */
		if (Head_r.akberr) {
			ret = ntohs(Head_r.akberr);
			printf("\n*** command AKBerror=%d %s\n",ret,akb_str_error(ret));
		}
		cmnd = ntohs(Head_r.command);
		if (cmnd == AKB_CMD_SHUT || cmnd == AKB_CMD_FSHUT) {
			printf("\n*** SHUT/FSHUT command received.\n*** Exit.\n");
			ret = cmnd;
			if (sPid<=10000) {
				akb_exchg_indicate(&Head_r);
				aka_set_shut_packet(&Head_r);
				ret = 0;
			}
			goto End;
		}
		else {
			lw = ntohl(Head_r.len);
			if (lw>0) lw = sk_read(fd, buf, lw);
			goto ReRead;
		}
	}
	else {  /* Reply packet */
		if (Head_r.pckno) {
			ret = (short)ntohs(Head_r.pckno);
			printf("\n*** reply  akberror=%d %s\n",ret,akb_str_error(ret));
		}
		usClassId = ntohs(Head_r.class_s);
		lw = ntohl(Head_r.len);
		if (lw>0) {
			ret = sk_read( fd, buf, lw);
			if (!Head_r.pckno && ret >= 4) {
				lw = ret;
				buf[lw] = '\0';
				p = buf;
				ret = 0;
				if (usClassId <= 1) {
					if (!memcmp(buf,"***",3)) {
						;
					}
					else {
						memcpy(&lwk,buf,4);
						ret = ntohl(lwk);
						p = buf + 4;
					}
				}
				else if (usClassId == 2) {
					ret = atoi(buf+2);
				}
				else {
					if (!strstr(buf,"Ok.")) ret = -1;
				}
				if (ret) printf("[SHUT] ret = %d %s\n",ret,akb_str_error(ret));
				printf("%s\n",p);
			}
		}
	}
 End:
	return ret;
}

static void _usage(procname)
char *procname;
{
	printf("\nusage: %s [-h|/h] [host|.] [port|.] [target_proc_no] [-f|-s|-t|-Number]\n",procname);
	printf("\t\t[-{H|P|T|S|p} object] [-A|-C|-D]\n\tobject is\n\t -H : host name\n\t -P : port no\n\t -T : target process no\n\t -S : my process no\n\t -p : password\n\t-----\n\t-A : target all process\n\t-C : chatty\n\t-D : direct send to class\n\n");
}

int
main( argc, argv )
int  argc;
char *argv[];
{
	char myhost[256],server[256],*pretcod,service[32],*procname,password[65];
	INT4 Hid,dHid;
	ushort dPid;
	int    Fd;
	char   c, *p, cc;
	short  cmnd, sRetCode;
	ushort usProcId = 0;
	int    i,ret,port_no,len,loc,proc_no,chatty=0,direct=0;
	short  sw;
	INT4   lw;

	for (i=1;i<argc;i++) {
		if (!strcmp(argv[i],"-C")) {
			chatty = 1;
			break;
		}
	}

	if (chatty) printf("  %s\n  (c) Copyright AKB Project 2016\n\n",PROGRAM);

	akb_log_set_proc_name(procname=akxt_get_last_name("\\/",argv[0]));

	cmnd = AKB_CMD_SHUT;
	if (!strcmp(procname,"fshut")) cmnd = AKB_CMD_FSHUT;
	else if (!strcmp(procname,"regist")) cmnd = AKB_CMD_QUERY;
	else if (!strcmp(procname,"start")) cmnd = AKB_CMD_START;

	if ((cmnd==AKB_CMD_FSHUT || cmnd==AKB_CMD_SHUT || cmnd==AKB_CMD_START) &&
	    argc <= 1) {
		_usage(procname);
		exit(0);
	}

	akb_log_flg(0,1); /* not output error_log */
	akb_log_flg(1,chatty); /* not output print_log */

	if (gethostname(myhost,sizeof(myhost))) {
		perror("SHUT gethostname");
		exit(0);
	}
	strcpy(server,myhost);
	service[0] = '\0';
	password[0] = '\0';
	proc_no = -1;

	ret = loc = 0;
	while (--argc > 0) {
		argv++;
		p = argv[0];
		if (!strcmp(p,"-h") || !strcmp(p,"/h")) {
			_usage(procname);
			exit(0);
		}
		else if  ((cc=*p) == '-') {
			p++;
			if ((c = *p)=='f')
				cmnd = AKB_CMD_FSHUT;
			else if (c=='s')
				cmnd = AKB_CMD_SHUT;
			else if (c=='t')
				cmnd = AKB_CMD_START;
			else if (c=='p' || c=='H' || c=='P' || c=='T' || c=='S') {
				if (*(p+1)) p++;
				else if (--argc > 0) {
					argv++;
					p = argv[0];
					if (*p == '-') ret = -1;
				}
				else ret = -1;
				if (!ret) {
					if (c=='p') strnzcpy(password,p,sizeof(password)-1);
					else if (c=='S') sPid = atoi(p);
					else if (c=='H') strcpy(server,p);
					else if (c=='P') strcpy(service,p);
					else if (c=='T') proc_no = atoi(p);
				}
			}
			else if (c=='A') proc_no = 0;
			else if (c=='C') chatty = 1;
			else if (c=='D') direct = 1;
			else if (c>='0' && c<='9') {
				if ((cmnd = atoi(p))==0) {
					printf("SHUT : command = %d is bad.\n",cmnd);
					exit(1);
				}
			}
			else {
				printf("SHUT : invalid paremeter!!\n");
				exit(1);
			}
			if (ret < 0) {
				printf("SHUT : no more parameter.\n");
				exit(1);
			}
		}
		else {
			switch (++loc) {
				case 1:	/* host */
					if (cc != '.') strcpy(server,p);
					break;
				case 2:	/* port */
					if (cc != '.') strcpy(service,p);
					break;
				case 3:	/* process */
					proc_no = atoi(p);
					break;
			}
		}
	}
	if (!direct &&
	    (cmnd==AKB_CMD_FSHUT || cmnd==AKB_CMD_SHUT || cmnd==AKB_CMD_START) &&
	    proc_no < 0) {
		printf("SHUT : please specify target process no. to parameter\n");
		exit(0);
	}
	if (proc_no >= 0) usProcId = proc_no;

	/* 荞݃nh[̓o^ */
	signal(SIGALRM, akb_sock_time_out);
	siginterrupt(SIGALRM, 1);
	signal(SIGPIPE, akb_broken_pipe);
	siginterrupt(SIGPIPE, 1);
	timeset[0] =  60;   /* read */
	timeset[1] =   5;   /* write */
	timeset[2] =   3;   /* connect */
	akb_set_time_out_set(timeset,3);

	if (!*service) {
		if (akbgetakbservname(TRMNNAME,service) <= 0) {
			printf("SHUT : use default service [%s]\n",SERVICE);
			strcpy(service,SERVICE);
		}
		if ((port_no = akb_get_port_no(service)) <= 0) {
			printf("SHUT : getservbyname failed. use default(%d).\n",PORTNO);
			port_no = PORTNO;
			sprintf(service,"%d",port_no);
		}
	}
	if (chatty) printf( "SHUT : server = [%s], service = [%s]\n",server,service);

	Fd = akb_connect(server,service,0,0);
	if (Fd <= 0) {
		if (Fd >= -1) perror("SHUT connect");
		exit(0);
	}
	port_no = akb_get_connect_port();
	if (chatty) printf( "SHUT : Connect OK. port no = %d\n",port_no);

	sprintf(buf,"hostname:%s\nuser:%s\nprogram:%s\n",
	        myhost,getenv("USER"),PROGRAM);
	ret = aka_regist2(Fd,sPid,buf,strlen(buf));
	if (ret) {
		printf("\n*** regist error=%d %s EXIT.\n",ret,akb_str_error(ret));
		goto End;
	}
	dHid = Hid = aka_get_pr_host_id();
	sPid = aka_get_regist_pid();

	Head_w.ver     = 'C';
	Head_w.info    = 0;
	Head_w.command = htons(COMM_SEND);
	Head_w.host_d  = htonl(dHid);
	Head_w.class_d = htons(1);
	Head_w.prs_d   = htons(1);
	Head_w.sled_d  = 0;
	Head_w.akbopt  = 0;
	Head_w.akberr  = 0;
	Head_w.host_s  = htonl(Hid);
	Head_w.class_s = 0;
	Head_w.prs_s   = htons(sPid);
	Head_w.sled_s  = 1;
	Head_w.dispos  = 2;
	Head_w.pckno   = htons(1);

	p = buf + sizeof(HEAD);

	if (*password) {
		Head_w.class_d = htons(AKA_CLASS_PASSWORD);
		strcpy(p,password);
		len = strlen(p);
		Head_w.len = htonl(len);
		memcpy(buf,(char *)&Head_w,sizeof(HEAD));
		ret = _send_passwd(Fd,buf,len+sizeof(HEAD));
		if (ret < 0) goto Cancel;
	}

	Head_w.class_d = htons(1);
	if (cmnd == AKB_CMD_QUERY) {
		Head_w.prs_d = htons(3);
	}
	if (direct && (cmnd==AKB_CMD_FSHUT || cmnd==AKB_CMD_SHUT)) {
		len = 0;
		if (cmnd==AKB_CMD_FSHUT) sw = AKA_CLASS_FSHUT;
		else if (cmnd==AKB_CMD_SHUT) sw = AKA_CLASS_SHUT;
		Head_w.class_d = htons(sw);
	}
	else {
		sw = htons(cmnd);
		memcpy(p,(char *)&sw,sizeof(short));
		len = sizeof(short);
		sw = htons(usProcId);
		memcpy(p+len,(char *)&sw,sizeof(short));
		len += sizeof(short);
	}
	Head_w.len = htonl(len);
	memcpy(buf,(char *)&Head_w,sizeof(HEAD));

	len += sizeof(HEAD);
	if ((ret=akb_sk_write(Fd, buf, len)) != len) {
		if (ret == -2) {
			printf("[SHUT] write timeout\n");
		}
		else {
			printf("[SHUT] write error\n");
		}
		goto End;
	}
	ret = _recv_msg(Fd, buf);
	if (ret == AKB_CMD_SHUT || ret == AKB_CMD_FSHUT) goto End;
Cancel:
	aka_cancel(Fd,sPid);
End:
	shutdown(Fd,2);
	close(Fd);
}
