#!/bin/busybox sh
# Usage: 
#
#   on local(kobo) :
# tmpuu=`mktemp /tmp/eKB_XXXXXX`
# $0 | tee $tmpuu | sed '/^begin-base64 644/,$d'
# sed -n '/^begin-base64 644/,$p' $tmpuu | uudecode
# rm -f $tmpuu
#
#   on remote :
# tmpuu=`mktemp /tmp/eKB_XXXXXX`
# ssh kobo $0 | tee $tmpuu | sed '/^begin-base64 644/,$d'
# sed -n '/^begin-base64 644/,$p' $tmpuu | uudecode
# rm -f $tmpuu
#

easyKoboBackupVer=1

################
cd "${0%/*}"
bindir="$(readlink -f .)"
addVerCheck_sh="$bindir/addVerCheck.sh"
koboBackup_sh="$bindir/koboBackup.sh"
[ -x "$addVerCheck_sh" -a -x "$koboBackup_sh" ] || exit 1

wd=`mktemp -d /tmp/easyKoboBackup_XXXXXX`
uuid=`dbus-uuidgen`
## versions.lst
cat > $wd/versions.lst << EOVERLST
name: easyKoboBackup$easyKoboBackupVer
script:dst: /tmp/ekb_$uuid/koboBackup-oneShot.sh
script:pre: cat '$koboBackup_sh'
script:exe: /tmp/ekb_$uuid/koboBackup-oneShot.sh YES
firmware_version,hardware comment
*,* all versions
EOVERLST
##

cd $wd
$addVerCheck_sh 2>&1
[ -f KoboRoot.tgz ] || exit 3
uuencode -m KoboRoot.tgz KoboRoot.tgz
cd /tmp
rm -rf $wd
exit

