package org.apache.maven.archiva.dependency.graph;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.archiva.dependency.DependencyGraphFactory;
import org.apache.maven.archiva.model.DependencyScope;
import org.apache.maven.archiva.model.VersionedReference;

import java.util.ArrayList;
import java.util.List;

/**
 * WagonManagerDependencyGraphTest
 * 
 * DependencyGraphTest for testing <code>org.apache.maven.wagon:wagon-manager:2.0-SNAPSHOT</code>
 *
 * Generated by <code>archivadev:generate-dependency-tests</code> plugin
 * @version $Id: WagonManagerDependencyGraphTest.java 755277 2009-03-17 15:18:35Z brett $
 */
public class WagonManagerDependencyGraphTest
   extends AbstractDependencyGraphFactoryTestCase
{
   public void testResolvedDepsToNodes()
        throws GraphTaskException
   {
      MemoryRepositoryDependencyGraphBuilder graphBuilder = 
                     new MemoryRepositoryDependencyGraphBuilder();
      MemoryRepository repository = new WagonManagerMemoryRepository();
      graphBuilder.setMemoryRepository( repository );

      // Create the factory, and add the test resolver.
      DependencyGraphFactory factory = new DependencyGraphFactory();
      factory.setGraphBuilder( graphBuilder );
      factory.setDesiredScope( DependencyScope.TEST );

      // Get the model to resolve from
      VersionedReference rootRef = toVersionedReference( "org.apache.maven.wagon:wagon-manager:2.0-SNAPSHOT"); 

      // Perform the resolution.
      DependencyGraph graph = factory.getGraph( rootRef );

      // Test the results.
      assertNotNull( "Graph shouldn't be null.", graph );

      String expectedRootRef = "org.apache.maven.wagon:wagon-manager:2.0-SNAPSHOT";
      List<String> expectedNodes = new ArrayList<String>();

      // Check for all nodes, regardless of scope.
      expectedNodes.clear();
      expectedNodes.add( "classworlds:classworlds:1.1-alpha-2::jar" );
      expectedNodes.add( "com.jcraft:jsch:0.1.27::jar" );
      expectedNodes.add( "commons-httpclient:commons-httpclient:2.0.2::jar" );
      expectedNodes.add( "commons-lang:commons-lang:2.1::jar" );
      expectedNodes.add( "commons-logging:commons-logging:1.0.4::jar" );
      expectedNodes.add( "commons-net:commons-net:1.4.1::jar" );
      expectedNodes.add( "de.zeigermann.xml:xml-im-exporter:1.1::jar" );
      expectedNodes.add( "it.could:webdav:0.4::jar" );
      expectedNodes.add( "javax.servlet:servlet-api:2.3::jar" );
      expectedNodes.add( "jdom:jdom:1.0::jar" );
      expectedNodes.add( "jtidy:jtidy:4aug2000r7-dev::jar" );
      expectedNodes.add( "junit:junit:3.8.1::jar" );
      expectedNodes.add( "org.apache.maven.wagon:wagon-file:2.0-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.wagon:wagon-ftp:2.0-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.wagon:wagon-http-lightweight:2.0-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.wagon:wagon-http-shared:2.0-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.wagon:wagon-provider-api:2.0-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.wagon:wagon-ssh:2.0-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.wagon:wagon-ssh-common:2.0-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.wagon:wagon-ssh-external:2.0-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.wagon:wagon-webdav:2.0-SNAPSHOT::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-7::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-component-api:1.0-alpha-16::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-interactivity-api:1.0-alpha-6::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-utils:1.4.2-SNAPSHOT::jar" );
      expectedNodes.add( "org.codehaus.plexus.webdav:plexus-webdav-api:1.0-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus.webdav:plexus-webdav-simple:1.0-alpha-1::jar" );
      expectedNodes.add( "org.mortbay.jetty:jetty:6.0.2::jar" );
      expectedNodes.add( "org.mortbay.jetty:jetty-util:6.0.2::jar" );
      expectedNodes.add( "org.mortbay.jetty:servlet-api-2.5:6.0.2::jar" );
      expectedNodes.add( "oro:oro:2.0.8::jar" );
      expectedNodes.add( "slide:slide-webdavlib:2.1::jar" );

      assertGraph( graph, expectedRootRef, expectedNodes );
   }

}
