package org.apache.maven.archiva.dependency.graph;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */


/**
 * MavenProjectInfoReportsPluginDependencyGraphTest
 * 
 * DependencyGraphTest for testing <code>org.apache.maven.plugins:maven-project-info-reports-plugin:2.1-SNAPSHOT</code>
 *
 * Generated by <code>archivadev:generate-dependency-tests</code> plugin
 * @version $Id: MavenProjectInfoReportsPluginDependencyGraphTest.java 637540 2008-03-16 04:48:58Z joakime $
 */
public class MavenProjectInfoReportsPluginDependencyGraphTest
   extends AbstractDependencyGraphFactoryTestCase
{
   public void testResolvedDepsToNodes()
        throws GraphTaskException
   {
/* TODO: Can't test a snapshot dependency from the repository
      MemoryRepositoryDependencyGraphBuilder graphBuilder = 
                     new MemoryRepositoryDependencyGraphBuilder();
      MemoryRepository repository = new MavenProjectInfoReportsPluginMemoryRepository();
      graphBuilder.setMemoryRepository( repository );

      // Create the factory, and add the test resolver.
      DependencyGraphFactory factory = new DependencyGraphFactory();
      factory.setGraphBuilder( graphBuilder );
      factory.setDesiredScope( DependencyScope.TEST );

      // Get the model to resolve from
      VersionedReference rootRef = toVersionedReference( "org.apache.maven.plugins:maven-project-info-reports-plugin:2.1-SNAPSHOT"); 

      // Perform the resolution.
      DependencyGraph graph = factory.getGraph( rootRef );

      // Test the results.
      assertNotNull( "Graph shouldn't be null.", graph );

      String expectedRootRef = "org.apache.maven.plugins:maven-project-info-reports-plugin:2.1-SNAPSHOT";
      List expectedNodes = new ArrayList();

      // Check for all nodes, regardless of scope.
      expectedNodes.clear();
      expectedNodes.add( "classworlds:classworlds:1.1-alpha-2::jar" );
      expectedNodes.add( "com.jcraft:jsch:0.1.27::jar" );
      expectedNodes.add( "commons-beanutils:commons-beanutils:1.7.0::jar" );
      expectedNodes.add( "commons-cli:commons-cli:1.0::jar" );
      expectedNodes.add( "commons-collections:commons-collections:3.1::jar" );
      expectedNodes.add( "commons-digester:commons-digester:1.6::jar" );
      expectedNodes.add( "commons-logging:commons-logging:1.0.4::jar" );
      expectedNodes.add( "commons-validator:commons-validator:1.2.0::jar" );
      expectedNodes.add( "httpunit:httpunit:1.6::jar" );
      expectedNodes.add( "jakarta-regexp:jakarta-regexp:1.4::jar" );
      expectedNodes.add( "javax.servlet:servlet-api:2.3::jar" );
      expectedNodes.add( "jtidy:jtidy:4aug2000r7-dev::jar" );
      expectedNodes.add( "junit:junit:3.8.1::jar" );
      expectedNodes.add( "nekohtml:nekohtml:0.9.1::jar" );
      expectedNodes.add( "org.apache.bcel:bcel:5.2::jar" );
      expectedNodes.add( "org.apache.maven:maven-artifact:2.0.4::jar" );
      expectedNodes.add( "org.apache.maven:maven-artifact-manager:2.0.2::jar" );
      expectedNodes.add( "org.apache.maven:maven-core:2.0::jar" );
      expectedNodes.add( "org.apache.maven:maven-error-diagnostics:2.0::jar" );
      expectedNodes.add( "org.apache.maven:maven-model:2.0.4::jar" );
      expectedNodes.add( "org.apache.maven:maven-monitor:2.0::jar" );
      expectedNodes.add( "org.apache.maven:maven-plugin-api:2.0.4::jar" );
      expectedNodes.add( "org.apache.maven:maven-plugin-descriptor:2.0::jar" );
      expectedNodes.add( "org.apache.maven:maven-plugin-parameter-documenter:2.0::jar" );
      expectedNodes.add( "org.apache.maven:maven-plugin-registry:2.0::jar" );
      expectedNodes.add( "org.apache.maven:maven-profile:2.0::jar" );
      expectedNodes.add( "org.apache.maven:maven-project:2.0.4::jar" );
      expectedNodes.add( "org.apache.maven:maven-repository-metadata:2.0::jar" );
      expectedNodes.add( "org.apache.maven:maven-settings:2.0.4::jar" );
      expectedNodes.add( "org.apache.maven.doxia:doxia-core:1.0-alpha-8::jar" );
      expectedNodes.add( "org.apache.maven.doxia:doxia-decoration-model:1.0-alpha-8::jar" );
      expectedNodes.add( "org.apache.maven.doxia:doxia-sink-api:1.0-alpha-8::jar" );
      expectedNodes.add( "org.apache.maven.doxia:doxia-site-renderer:1.0-alpha-8::jar" );
      expectedNodes.add( "org.apache.maven.reporting:maven-reporting-api:2.0.4::jar" );
      expectedNodes.add( "org.apache.maven.reporting:maven-reporting-impl:2.0.4::jar" );
      expectedNodes.add( "org.apache.maven.scm:maven-scm-api:1.0-beta-4::jar" );
      expectedNodes.add( "org.apache.maven.scm:maven-scm-manager-plexus:1.0-beta-4::jar" );
      expectedNodes.add( "org.apache.maven.scm:maven-scm-provider-clearcase:1.0-beta-4::jar" );
      expectedNodes.add( "org.apache.maven.scm:maven-scm-provider-cvs-commons:1.0-beta-4::jar" );
      expectedNodes.add( "org.apache.maven.scm:maven-scm-provider-cvsexe:1.0-beta-4::jar" );
      expectedNodes.add( "org.apache.maven.scm:maven-scm-provider-perforce:1.0-beta-4::jar" );
      expectedNodes.add( "org.apache.maven.scm:maven-scm-provider-starteam:1.0-beta-4::jar" );
      expectedNodes.add( "org.apache.maven.scm:maven-scm-provider-svn-commons:1.0-beta-4::jar" );
      expectedNodes.add( "org.apache.maven.scm:maven-scm-provider-svnexe:1.0-beta-4::jar" );
      expectedNodes.add( "org.apache.maven.shared:maven-dependency-tree:1.0-alpha-2::jar" );
      expectedNodes.add( "org.apache.maven.shared:maven-plugin-testing-harness:1.0::jar" );
      expectedNodes.add( "org.apache.maven.shared:maven-shared-jar:1.0-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.wagon:wagon-file:1.0-beta-2::jar" );
      expectedNodes.add( "org.apache.maven.wagon:wagon-http-lightweight:1.0-beta-2::jar" );
      expectedNodes.add( "org.apache.maven.wagon:wagon-http-shared:1.0-beta-2::jar" );
      expectedNodes.add( "org.apache.maven.wagon:wagon-provider-api:1.0-beta-2::jar" );
      expectedNodes.add( "org.apache.maven.wagon:wagon-ssh:1.0-beta-2::jar" );
      expectedNodes.add( "org.apache.maven.wagon:wagon-ssh-common:1.0-beta-2::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-container-default:1.0-alpha-9::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-digest:1.0::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-i18n:1.0-beta-6::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-interactivity-api:1.0-alpha-4::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-utils:1.1::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-velocity:1.1.3::jar" );
      expectedNodes.add( "oro:oro:2.0.7::jar" );
      expectedNodes.add( "plexus:plexus-utils:1.0.2::jar" );
      expectedNodes.add( "regexp:regexp:1.3::jar" );
      expectedNodes.add( "rhino:js:1.5R4.1::jar" );
      expectedNodes.add( "velocity:velocity:1.4::jar" );
      expectedNodes.add( "velocity:velocity-dep:1.4::jar" );
      expectedNodes.add( "xerces:xercesImpl:2.6.2::jar" );
      expectedNodes.add( "xerces:xmlParserAPIs:2.2.1::jar" );
      expectedNodes.add( "xml-apis:xml-apis:1.0.b2::jar" );

      assertGraph( graph, expectedRootRef, expectedNodes );
*/
   }

}
