package org.apache.maven.archiva.dependency.graph;

/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import org.apache.maven.archiva.dependency.DependencyGraphFactory;
import org.apache.maven.archiva.model.DependencyScope;
import org.apache.maven.archiva.model.VersionedReference;

import java.util.ArrayList;
import java.util.List;

/**
 * ArchivaWebappDependencyGraphTest
 * 
 * DependencyGraphTest for testing <code>org.apache.maven.archiva:archiva-webapp:1.0-alpha-2-SNAPSHOT</code>
 *
 * Generated by <code>archivadev:generate-dependency-tests</code> plugin
 * @version $Id: ArchivaWebappDependencyGraphTest.java 755277 2009-03-17 15:18:35Z brett $
 */
public class ArchivaWebappDependencyGraphTest
   extends AbstractDependencyGraphFactoryTestCase
{
   public void testResolvedDepsToNodes()
        throws GraphTaskException
   {
      MemoryRepositoryDependencyGraphBuilder graphBuilder = 
                     new MemoryRepositoryDependencyGraphBuilder();
      MemoryRepository repository = new ArchivaWebappMemoryRepository();
      graphBuilder.setMemoryRepository( repository );

      // Create the factory, and add the test resolver.
      DependencyGraphFactory factory = new DependencyGraphFactory();
      factory.setGraphBuilder( graphBuilder );
      factory.setDesiredScope( DependencyScope.TEST );

      // Get the model to resolve from
      VersionedReference rootRef = toVersionedReference( "org.apache.maven.archiva:archiva-webapp:1.0-alpha-2-SNAPSHOT"); 

      // Perform the resolution.
      DependencyGraph graph = factory.getGraph( rootRef );

      // Test the results.
      assertNotNull( "Graph shouldn't be null.", graph );

      String expectedRootRef = "org.apache.maven.archiva:archiva-webapp:1.0-alpha-2-SNAPSHOT";
      List<String> expectedNodes = new ArrayList<String>();

      // Check for all nodes, regardless of scope.
      expectedNodes.clear();
      expectedNodes.add( "ant:ant-optional:1.5.1::jar" );
      expectedNodes.add( "backport-util-concurrent:backport-util-concurrent:3.0::jar" );
      expectedNodes.add( "classworlds:classworlds:1.1::jar" );
      expectedNodes.add( "commons-beanutils:commons-beanutils:1.7.0::jar" );
      expectedNodes.add( "commons-beanutils:commons-beanutils-bean-collections:1.7.0::jar" );
      expectedNodes.add( "commons-codec:commons-codec:1.3::jar" );
      expectedNodes.add( "commons-collections:commons-collections:3.2::jar" );
      expectedNodes.add( "commons-configuration:commons-configuration:1.3::jar" );
      expectedNodes.add( "commons-digester:commons-digester:1.6::jar" );
      expectedNodes.add( "commons-io:commons-io:1.2::jar" );
      expectedNodes.add( "commons-jxpath:commons-jxpath:1.2::jar" );
      expectedNodes.add( "commons-lang:commons-lang:2.2::jar" );
      expectedNodes.add( "commons-logging:commons-logging:1.0.4::jar" );
      expectedNodes.add( "commons-logging:commons-logging-api:1.0.4::jar" );
      expectedNodes.add( "dom4j:dom4j:1.6.1::jar" );
      expectedNodes.add( "freemarker:freemarker:2.3.4::jar" );
      expectedNodes.add( "geronimo-spec:geronimo-spec-jta:1.0.1B-rc2::jar" );
      expectedNodes.add( "it.could:webdav:0.4::jar" );
      expectedNodes.add( "javax.activation:activation:1.1::jar" );
      expectedNodes.add( "javax.jdo:jdo2-api:2.0::jar" );
      expectedNodes.add( "javax.mail:mail:1.4::jar" );
      expectedNodes.add( "javax.resource:connector:1.0::jar" );
      expectedNodes.add( "javax.servlet:jsp-api:2.0::jar" );
      expectedNodes.add( "javax.servlet:jstl:1.1.2::jar" );
      expectedNodes.add( "javax.servlet:servlet-api:2.4::jar" );
      expectedNodes.add( "javax.transaction:jta:1.0.1B::jar" );
      expectedNodes.add( "jaxen:jaxen:1.1::jar" );
      expectedNodes.add( "jdom:jdom:1.0::jar" );
      expectedNodes.add( "jpox:jpox:1.1.7::jar" );
      expectedNodes.add( "jtidy:jtidy:4aug2000r7-dev::jar" );
      expectedNodes.add( "junit:junit:3.8.1::jar" );
      expectedNodes.add( "log4j:log4j:1.2.8::jar" );
      expectedNodes.add( "net.java.dev.stax-utils:stax-utils:20060502::jar" );
      expectedNodes.add( "net.sf.ehcache:ehcache:1.2.4::jar" );
      expectedNodes.add( "ognl:ognl:2.6.7::jar" );
      expectedNodes.add( "opensymphony:oscore:2.2.4::jar" );
      expectedNodes.add( "opensymphony:sitemesh:2.2.1::jar" );
      expectedNodes.add( "opensymphony:webwork:2.2.4::jar" );
      expectedNodes.add( "opensymphony:xwork:1.2.1::jar" );
      expectedNodes.add( "org.apache.derby:derby:10.1.3.1::jar" );
      expectedNodes.add( "org.apache.lucene:lucene-core:2.0.0::jar" );
      expectedNodes.add( "org.apache.maven:maven-artifact:2.0.5::jar" );
      expectedNodes.add( "org.apache.maven:maven-artifact-manager:2.0.5::jar" );
      expectedNodes.add( "org.apache.maven:maven-model:2.0.5::jar" );
      expectedNodes.add( "org.apache.maven:maven-profile:2.0.5::jar" );
      expectedNodes.add( "org.apache.maven:maven-project:2.0.5::jar" );
      expectedNodes.add( "org.apache.maven:maven-repository-metadata:2.0.5::jar" );
      expectedNodes.add( "org.apache.maven:maven-settings:2.0.5::jar" );
      expectedNodes.add( "org.apache.maven.archiva:archiva-applet:1.0-alpha-2-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.archiva:archiva-artifact-reports:1.0-alpha-2-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.archiva:archiva-common:1.0-alpha-2-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.archiva:archiva-configuration:1.0-alpha-2-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.archiva:archiva-consumer-api:1.0-alpha-2-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.archiva:archiva-core-consumers:1.0-alpha-2-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.archiva:archiva-database:1.0-alpha-2-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.archiva:archiva-database-consumers:1.0-alpha-2-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.archiva:archiva-indexer:1.0-alpha-2-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.archiva:archiva-lucene-consumers:1.0-alpha-2-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.archiva:archiva-model:1.0-alpha-2-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.archiva:archiva-policies:1.0-alpha-2-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.archiva:archiva-proxy:1.0-alpha-2-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.archiva:archiva-report-manager:1.0-alpha-2-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.archiva:archiva-repository-layer:1.0-alpha-2-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.archiva:archiva-scheduled:1.0-alpha-2-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.archiva:archiva-security:1.0-alpha-2-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.archiva:archiva-signature-consumers:1.0-alpha-2-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.archiva:archiva-xml-tools:1.0-alpha-2-SNAPSHOT::jar" );
      expectedNodes.add( "org.apache.maven.shared:maven-app-configuration-model:1.0::jar" );
      expectedNodes.add( "org.apache.maven.shared:maven-app-configuration-web:1.0::jar" );
      expectedNodes.add( "org.apache.maven.wagon:wagon-file:1.0-beta-2::jar" );
      expectedNodes.add( "org.apache.maven.wagon:wagon-http-lightweight:1.0-beta-2::jar" );
      expectedNodes.add( "org.apache.maven.wagon:wagon-http-shared:1.0-beta-2::jar" );
      expectedNodes.add( "org.apache.maven.wagon:wagon-provider-api:1.0-beta-2::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-classworlds:1.2-alpha-7::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-component-api:1.0-alpha-22::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-container-default:1.0-alpha-22::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-digest:1.1::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-ehcache:1.0-alpha-2::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-expression-evaluator:1.0-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-jdo2:1.0-alpha-8::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-mail-sender-api:1.0-alpha-6::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-mail-sender-javamail:1.0-alpha-6::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-quartz:1.0-alpha-3::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-slf4j-logging:1.1-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-taskqueue:1.0-alpha-6::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-utils:1.4::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-velocity:1.1.2::jar" );
      expectedNodes.add( "org.codehaus.plexus:plexus-xwork-integration:1.0-alpha-6::jar" );
      expectedNodes.add( "org.codehaus.plexus.cache:plexus-cache-api:1.0-alpha-2::jar" );
      expectedNodes.add( "org.codehaus.plexus.cache:plexus-cache-ehcache:1.0-alpha-2::jar" );
      expectedNodes.add( "org.codehaus.plexus.redback:redback-authentication-api:1.0-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus.redback:redback-authentication-keys:1.0-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus.redback:redback-authentication-users:1.0-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus.redback:redback-authorization-api:1.0-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus.redback:redback-authorization-rbac:1.0-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus.redback:redback-common-jdo:1.0-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus.redback:redback-configuration:1.0-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus.redback:redback-keys-api:1.0-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus.redback:redback-keys-cached:1.0-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus.redback:redback-keys-jdo:1.0-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus.redback:redback-policy:1.0-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus.redback:redback-rbac-cached:1.0-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus.redback:redback-rbac-jdo:1.0-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus.redback:redback-rbac-model:1.0-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus.redback:redback-rbac-role-manager:1.0-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus.redback:redback-system:1.0-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus.redback:redback-taglib:1.0-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus.redback:redback-users-api:1.0-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus.redback:redback-users-cached:1.0-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus.redback:redback-users-jdo:1.0-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus.redback:redback-xwork-content:1.0-alpha-1::war" );
      expectedNodes.add( "org.codehaus.plexus.redback:redback-xwork-integration:1.0-alpha-1::jar" );
      expectedNodes.add( "org.codehaus.plexus.registry:plexus-registry-api:1.0-alpha-2::jar" );
      expectedNodes.add( "org.codehaus.plexus.registry:plexus-registry-commons:1.0-alpha-2::jar" );
      expectedNodes.add( "org.codehaus.plexus.webdav:plexus-webdav-api:1.0-alpha-2::jar" );
      expectedNodes.add( "org.codehaus.plexus.webdav:plexus-webdav-simple:1.0-alpha-2::jar" );
      expectedNodes.add( "org.codehaus.woodstox:wstx-asl:3.2.1::jar" );
      expectedNodes.add( "org.extremecomponents:extremecomponents:1.0.1::jar" );
      expectedNodes.add( "org.rifers:rife-continuations:0.0.2::jar" );
      expectedNodes.add( "org.slf4j:slf4j-api:1.2::jar" );
      expectedNodes.add( "org.slf4j:slf4j-log4j12:1.2::jar" );
      expectedNodes.add( "org.slf4j:slf4j-simple:1.2::jar" );
      expectedNodes.add( "quartz:quartz:1.4.5::jar" );
      expectedNodes.add( "stax:stax-api:1.0.1::jar" );
      expectedNodes.add( "taglibs:standard:1.1.2::jar" );
      expectedNodes.add( "velocity:velocity:1.4::jar" );
      expectedNodes.add( "velocity:velocity-dep:1.4::jar" );
      expectedNodes.add( "xerces:xercesImpl:2.6.2::jar" );
      expectedNodes.add( "xml-apis:xml-apis:1.3.03::jar" );

      assertGraph( graph, expectedRootRef, expectedNodes );
   }

}
