/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import javax.servlet.ServletException;

import jp.terasoluna.fw.exception.SystemException;
import junit.framework.TestCase;

/**
 * ExceptionUtil ubN{bNXeXgB<br>
 * <br>
 * (O)
 * @@@@Ȃ<br>
 * 
 * <br>
 */
public class ExceptionUtilTest extends TestCase {

    /**
     * Constructor for ExceptionUtilTest.
     * @param arg0
     */
    public ExceptionUtilTest(String arg0) {
        super(arg0);
    }

    /*
     * @see TestCase#setUp()
     */
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    /*
     * @see TestCase#tearDown()
     */
    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }
    /**
     * testGetStackTrace01()B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * ͒l :1̗OIuWFNg<br>
     * Ғl :X^bNg[X<br>
     *
     *  1̗OIuWFNgX^bNg[X擾ł邱ƁB<br>
     *
     */
    public void testGetStackTrace01() {
        //ݒ
        NullPointerException ne = new NullPointerException();

        //eXgs
        String result = ExceptionUtil.getStackTrace(ne);

        //SystemExceptionANullPointerException
        //X^bNg[X̑sڂ܂܂Ă邱ƁB
        assertTrue(result.indexOf("java.lang.NullPointerException") != -1);
    }

    /**
     * testGetStackTrace02()B<br>
     * 
     * inj<br>
     * ϓ_FA<br>
     * ͒l :OIuWFNgOIuWFNg<br>
     * Ғl :L̗O珇ɘAꂽX^bNg[X<br>
     *
     * OIuWFNgOIuWFNgɑ΂ĎsƁA
     * ̗O珇ɃX^bNg[XAĎ擾ł邱ƁB<br>
     *
     */
    public void testGetStackTrace02() {
        //ݒ
        SystemException se = new SystemException(new ServletException(new NullPointerException()));

        //eXgs
        String result = ExceptionUtil.getStackTrace(se);


        //SystemExceptionAServletExceptionANullPointerException
        //X^bNg[X̑sڂ܂܂Ă邱ƁB
        assertTrue(
            result.indexOf(
                "jp.terasoluna.fw.exception.SystemException")
                != -1);
        assertTrue(result.indexOf("\njavax.servlet.ServletException") != -1);
        assertTrue(result.indexOf("\njava.lang.NullPointerException") != -1);

        // SystemExceptionServletException̏ŁAo͂Ă邱
        assertTrue(
            result.indexOf(
                "jp.terasoluna.framework.exception.SystemException")
                < result.indexOf("\njavax.servlet.ServletException"));

        // ServletExceptionNullPointerException̏ŁAo͂Ă邱
        assertTrue(
            result.indexOf(
                "\njavax.servlet.ServletException")
                < result.indexOf("\njava.lang.NullPointerException"));
    }

    /**
     * testGetStackTrace03()B<br>
     * 
     * inj<br>
     * ϓ_FC<br>
     * ͒l :null<br>
     * Ғl :󕶎<br>
     *
     * null̎ÃX^bNg[Xԋp邱ƂmFB<br>
     *
     */
    public void testGetStackTrace03() {
        //eXgs
        String trace = ExceptionUtil.getStackTrace(null);

        //ʊmF
        assertEquals("", trace);
    }
}
