/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.message;

import java.io.Serializable;

/**
 * bZ[W\[XێNXB<br>
 * bZ[W\[Xɂ̓bZ[WR[hAR[hAR[hA
 * oAgR[hAbZ[W{̂i[B
 * 
 * @see jp.terasoluna.fw.message.DataSourceMessageSource
 * @see jp.terasoluna.fw.message.DBMessageQuery
 * @see jp.terasoluna.fw.message.DBMessageResourceDAO
 * @see jp.terasoluna.fw.message.DBMessageResourceDAOImpl
 * 
 */
public class DBMessage implements Serializable {

    /**
     * VAo[WIDB
     */
    private static final long serialVersionUID = 299442236623116335L;

    /**
     * bZ[WR[hB
     */
    protected String code = null;

    /**
     * bZ[W̌R[hB
     */
    protected String language = null;

    /**
     * bZ[W̍R[hB
     */
    protected String country = null;

    /**
     * bZ[W̃oAgR[hB
     */
    protected String variant = null;

    /**
     * bZ[W{́B
     */
    protected String message = null;

    /**
     * DBMessageɃbZ[WR[hAR[hAR[hAoAgR[hA
     * bZ[W{̂i[B
     * 
     * @param code bZ[WR[hB
     * @param language bZ[W̌R[hB
     * @param country bZ[W̍R[hB
     * @param variant bZ[W̃oAgR[hB
     * @param message bZ[W{́B
     */
    public DBMessage(String code, String language, String country,
            String variant, String message) {
        this.code = code;
        this.language = language;
        this.country = country;
        this.variant = variant;
        this.message = message;
    }

    /**
     * DBMessageIuWFNg烁bZ[WR[h擾B
     * 
     * @return bZ[WR[hB
     */
    public String getCode() {
        return code;
    }

    /**
     * DBMessageIuWFNg烁bZ[W̌R[h擾B
     * 
     * @return bZ[W̌R[hB
     */
    public String getLanguage() {
        return language;
    }

    /**
     * DBMessageIuWFNg烁bZ[W̍R[h擾B
     * 
     * @return bZ[W̍R[hB
     */
    public String getCountry() {
        return country;
    }

    /**
     * DBMessageIuWFNg烁bZ[W̃oAgR[h擾B
     * 
     * @return bZ[W̃oAgR[hB
     */
    public String getVariant() {
        return variant;
    }
    
    /**
     * DBMessageIuWFNg烁bZ[W{̂擾B
     * 
     * @return bZ[W{́B
     */
    public String getMessage() {
        return message;
    }
}
