/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.exception;


/**
 * t[[N甭ėpONXB
 *
 * <p>
 * ̑sȏꍇɃt[[N甭ONXB<br>
 * {NXɂ̓bZ[WL[ƃbZ[Wuݒ肷邱ƂłB
 * AAbZ[W擾Ayуv[Xz_̒u͕ʂ̃NXŎsA
 * ēx {@link #setMessage(String)} săbZ[Wݒ肷KvB
 * bZ[Wݒ肳ĂȂԂŁA{@link #getMessage()}
 * \bhpăbZ[W擾ƃbZ[WL[ԋpB
 * ]āAbZ[WusȂ悤ȏ󋵂Ŗ{NXgpꍇ́A
 * RXgN^errorCodeɁAbZ[WL[ł͂ȂG[R[h
 * G[bZ[W𒼐ڐݒ肷邱ƁB
 * </p>
 *
 */
public class SystemException extends RuntimeException {

    /**
     * VAo[WIDB
     */
    private static final long serialVersionUID = -3348737638719112576L;

    /**
     * G[R[hB
     */
    private String errorCode = null;

    /**
     * G[bZ[W̒uB
     */
    private String[] options = null;

    /**
     * G[bZ[WB
     */
    private String message = null;

    /**
     * RXgN^B
     *
     * @param cause ƂȂO
     */
    public SystemException(Throwable cause) {
        super(cause);
        this.errorCode = "";
    }

    /**
     * RXgN^B
     *
     * @param cause ƂȂO
     * @param errorCode G[R[h
     */
    public SystemException(Throwable cause,
                            String errorCode) {
        super(cause);
        this.errorCode = errorCode;
    }

    /**
     * RXgN^B
     *
     * @param cause ƂȂO
     * @param errorCode G[R[h
     * @param optionStrings bZ[W{n}u镶̔z
     */
    public SystemException(Throwable cause,
                            String errorCode,
                            String[] optionStrings) {
        super(cause);
        this.errorCode = errorCode;
        this.options = optionStrings;
    }

    /**
     * RXgN^B
     *
     * @param cause ƂȂO
     * @param errorCode G[R[h
     * @param s0 G[bZ[W{0}u镶
     */
    public SystemException(Throwable cause,
                            String errorCode,
                            String s0) {
        super(cause);
        this.errorCode = errorCode;
        this.options = new String[]{s0};
    }

    /**
     * RXgN^B
     *
     * @param cause ƂȂO
     * @param errorCode G[R[h
     * @param s0 G[bZ[W{0}u镶
     * @param s1 G[bZ[W{1}u镶
     */
    public SystemException(Throwable cause,
                            String errorCode,
                            String s0,
                            String s1) {
        super(cause);
        this.errorCode = errorCode;
        this.options = new String[]{s0, s1};
    }

    /**
     * RXgN^B
     *
     * @param cause ƂȂO
     * @param errorCode G[R[h
     * @param s0 G[bZ[W{0}u镶
     * @param s1 G[bZ[W{1}u镶
     * @param s2 G[bZ[W{2}u镶
     */
    public SystemException(Throwable cause,
                            String errorCode,
                            String s0,
                            String s1,
                            String s2) {
        super(cause);
        this.errorCode = errorCode;
        this.options = new String[]{s0, s1, s2};
    }

    /**
     * RXgN^B
     *
     * @param cause ƂȂO
     * @param errorCode G[R[h
     * @param s0 G[bZ[W{0}u镶
     * @param s1 G[bZ[W{1}u镶
     * @param s2 G[bZ[W{2}u镶
     * @param s3 G[bZ[W{3}u镶
     */
    public SystemException(Throwable cause,
                            String errorCode,
                            String s0,
                            String s1,
                            String s2,
                            String s3) {
        super(cause);
        this.errorCode = errorCode;
        this.options = new String[]{s0, s1, s2, s3};
    }

    /**
     * G[R[h擾B
     *
     * @return G[R[h
     */
    public String getErrorCode() {
        return this.errorCode;
    }

    /**
     * G[bZ[W̒u擾B
     *
     * @return G[bZ[Wu
     */
    public String[] getOptions() {
        return this.options;
    }

    /**
     * G[bZ[Wi[B
     *
     * @param message G[bZ[W
     */
    public void setMessage(String message) {
        this.message = message;
    }

    /**
     * G[bZ[WԋpB
     * O {@link #setMessage(String)} păbZ[Wݒ肳ĂȂ
     * ꍇ́ARXgN^errorCodeɎw肵ԋpB
     *
     * @return
     *     G[bZ[WA܂̓RXgN^errorCodeɎw肳ꂽ
     */
    @Override
    public String getMessage() {
        if (this.message == null) {
            return this.errorCode;
        }
        return this.message;
    }
}
