package jp.terasoluna.fw.batch.standard;

import jp.terasoluna.fw.batch.core.JobStatus;
import jp.terasoluna.fw.batch.core.ThrowableHandler;
import jp.terasoluna.fw.batch.openapi.JobContext;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/**
 * <code>ThrowableHandler</code> C^tF[X̕WNXB
 * 
 * <p>̃NXł́A<code>Throwable</code>̏Oɏo͂A
 * WuXe[^X 
 * <code>JobStatus.STATE.ENDING_ABNORMALLY</code>
 * ɍXVB</p>
 * 
 */
public class StandardThrowableHandler implements ThrowableHandler {

    /**
     * OCX^XB
     */
    private static final Log log = LogFactory.getLog(StandardThrowableHandler.class);

    /**
     * <code>Throwable</code>ɑ΂鏈sB
     * <p>
     * ̃NXł́A<code>Throwable</code>̏Oɏo͂A
     * WuXe[^X
     * <code>JobStatus.STATE.ENDING_ABNORMALLY</code> ɍXVB
     * </p>
     * 
     * <p>
     * <code>jobContext</code><code>null</code>ɂȂꍇB
     * </p>
     * 
     * @param jobContext
     *            WuReLXg
     * @param throwable
     *            Throwable
     * @param jobStatus
     *            WuXe[^X
     */
    public void handle(JobContext jobContext, Throwable throwable,
            JobStatus jobStatus) {
        writeErrorLog(jobStatus, throwable);
        jobStatus.setJobState(JobStatus.STATE.ENDING_ABNORMALLY);
    }

    /**
     * ThrowablẽG[Oo͂B
     * 
     * @param jobStatus WuXe[^X
     * @param throwable Throwable
     */
    protected void writeErrorLog(JobStatus jobStatus, Throwable throwable) {
        StringBuilder logStr = new StringBuilder();
        logStr.append("Critical Error!! JobID: ");
        logStr.append(jobStatus.getJobId());
        logStr.append(" ");
        logStr.append(throwable.getMessage());
        log.error(logStr.toString(), throwable);
    }

}
