/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.validation;

import java.math.BigDecimal;

import jp.terasoluna.utlib.PropertyTestCase;
import jp.terasoluna.utlib.UTUtil;

/**
 * {@link jp.terasoluna.fw.validation.ValidationUtil} NX̃ubN{bNXeXgB
 *
 * <p>
 * <h4>yNX̊Tvz</h4>
 * ؃WbÑ[eBeBNXB
 * <p>
 *
 * @see jp.terasoluna.fw.validation.ValidationUtil
 */
public class ValidationUtilTest02 extends PropertyTestCase {

    /**
     * ̃eXgP[Xsׂ
     * GUI AvP[VNB
     *
     * @param args java R}hɐݒ肳ꂽp[^
     */
    public static void main(String[] args) {
        junit.swingui.TestRunner.run(ValidationUtilTest02.class);
    }

    /**
     * sB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#setUpData()
     */
    @Override
    protected void setUpData() throws Exception {
        UTUtil.setPrivateField(ValidationUtil.class, "hankakuKanaList",
        "¯֬ܦް");
    UTUtil.setPrivateField(ValidationUtil.class, "zenkakuKanaList",
        "ACEGI@BDFHJLNPRKMOQSTVXZ\" +
        "UWY[]^`ceg_adfhijklmnqtwz" +
        "orux{psvy|}~" +
        "b[");
}

    /**
     * IsB
     *
     * @throws Exception ̃\bhŔO
     * @see jp.terasoluna.utlib.spring.PropertyTestCase#cleanUpData()
     */
    @Override
    protected void cleanUpData() throws Exception {
    }

    /**
     * RXgN^B
     *
     * @param name ̃eXgP[X̖OB
     */
    public ValidationUtilTest02(String name) {
        super(name);
    }

    /**
     * testMatchRegexp01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valuenull̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMatchRegexp01() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.matchRegexp(null, "^([0-9])*$"));
    }

    /**
     * testMatchRegexp02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:""<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * value󕶎̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMatchRegexp02() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.matchRegexp("", "^([0-9])*$"));
    }

    /**
     * testMatchRegexp03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"123"<br>
     *         () mask:"^([0-9])*$"<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valuemask̐K\ɊYꍇAtrue擾ł邱ƂmFB<br>
     * `FbNGenericValidator.matchRegexp(String, String)sȂ߁AeK\ɑ΂ڍׂȊmF͍sȂȂ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMatchRegexp03() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.matchRegexp("123", "^([0-9])*$"));
    }

    /**
     * testMatchRegexp04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"a12"<br>
     *         () mask:"^([0-9])*$"<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * valuemask̐K\ɊYȂꍇAtrue擾ł邱ƂmFB<br>
     * `FbNGenericValidator.matchRegexp(String, String)sȂ߁AeK\ɑ΂ڍׂȊmF͍sȂȂ
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testMatchRegexp04() throws Exception {
        // eXg{E
        assertFalse(ValidationUtil.matchRegexp("a12", "^([0-9])*$"));
    }

    /**
     * testIsAlphaNumericString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valuenull̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsAlphaNumericString01() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isAlphaNumericString(null));
    }

    /**
     * testIsAlphaNumericString02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:""<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * value󕶎̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsAlphaNumericString02() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isAlphaNumericString(""));
    }

    /**
     * testIsAlphaNumericString03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"0aA"<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valuepp݂̂ō\ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsAlphaNumericString03() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isAlphaNumericString("0aA"));
    }

    /**
     * testIsAlphaNumericString04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"Zg3%"<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * valueppȊO܂ޏꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsAlphaNumericString04() throws Exception {
        // eXg{E
        assertFalse(ValidationUtil.isAlphaNumericString("Zg3%"));
    }

    /**
     * testIsUpperAlphaNumericString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valuenull̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsUpperAlphaNumericString01() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isUpperAlphaNumericString(null));
    }

    /**
     * testIsUpperAlphaNumericString02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:""<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * value󕶎̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsUpperAlphaNumericString02() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isUpperAlphaNumericString(""));
    }

    /**
     * testIsUpperAlphaNumericString03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"A0"<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * value啶pp݂̂ō\ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsUpperAlphaNumericString03() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isUpperAlphaNumericString("A0"));
    }

    /**
     * testIsUpperAlphaNumericString04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"Aa0"<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * value啶ppȊO܂ޏꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsUpperAlphaNumericString04() throws Exception {
        // eXg{E
        assertFalse(ValidationUtil.isUpperAlphaNumericString("Aa0"));
    }

    /**
     * testIsNumericString01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valuenull̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsNumericString01() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isNumericString(null));
    }

    /**
     * testIsNumericString02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:""<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * value󕶎̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsNumericString02() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isNumericString(""));
    }

    /**
     * testIsNumericString03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"9876"<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valuê݂ō\ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsNumericString03() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isNumericString("9876"));
    }

    /**
     * testIsNumericString04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:"Aa0"<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * valueȊO܂ޏꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsNumericString04() throws Exception {
        // eXg{E
        assertFalse(ValidationUtil.isNumericString("Aa0"));
    }

    /**
     * testIsNumber01()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FC
     * <br><br>
     * ͒lF() value:null<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * valuenull̏ꍇAtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsNumber01() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isNumber(null, 3, false, 3, false));
    }

    /**
     * testIsNumber02()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:BigDecimal("123.45")<br>
     *         () integerLength:1<br>
     *         () isAccordedInteger:false<br>
     *         () scaleLength:3<br>
     *         () isAccordedScale:false<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * isAccordedIntegerfalseŁAintegerLength傫ꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsNumber02() throws Exception {
        // eXg{E
        assertFalse(ValidationUtil.isNumber(new BigDecimal("123.45"), 1, false,
                3, false));
    }

    /**
     * testIsNumber03()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:BigDecimal("123.45")<br>
     *         () integerLength:5<br>
     *         () isAccordedInteger:true<br>
     *         () scaleLength:3<br>
     *         () isAccordedScale:false<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * isAccordedIntegertrueŁAintegerLengthƓȂꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsNumber03() throws Exception {
        // eXg{E
        assertFalse(ValidationUtil.isNumber(new BigDecimal("123.45"), 5, true,
                3, false));
    }

    /**
     * testIsNumber04()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:BigDecimal("123.45")<br>
     *         () integerLength:5<br>
     *         () isAccordedInteger:false<br>
     *         () scaleLength:1<br>
     *         () isAccordedScale:false<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * ͏𖞂AAccordedScalefalseŁAscaleLength傫ꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsNumber04() throws Exception {
        // eXg{E
        assertFalse(ValidationUtil.isNumber(new BigDecimal("123.45"), 5, false,
                1, false));
    }

    /**
     * testIsNumber05()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:BigDecimal("123.45")<br>
     *         () integerLength:3<br>
     *         () isAccordedInteger:true<br>
     *         () scaleLength:3<br>
     *         () isAccordedScale:true<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * ͏𖞂AisAccordedScaletrueŁAscaleLengthƓȂꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsNumber05() throws Exception {
        // eXg{E
        assertFalse(ValidationUtil.isNumber(new BigDecimal("123.45"), 3, true,
                3, true));
    }

    /**
     * testIsNumber06()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:BigDecimal("123.45")<br>
     *         () integerLength:5<br>
     *         () isAccordedInteger:false<br>
     *         () scaleLength:3<br>
     *         () isAccordedScale:false<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * isAccordedIntegerEscaleLengthfalsȅꍇAEintegerLengthEscaleLength菬true擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsNumber06() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isNumber(new BigDecimal("123.45"), 5, false,
                3, false));
    }

    /**
     * testIsNumber07()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:BigDecimal("123.45")<br>
     *         () integerLength:3<br>
     *         () isAccordedInteger:true<br>
     *         () scaleLength:2<br>
     *         () isAccordedScale:true<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * isAccordedIntegerEscaleLengthtruȅꍇAEintegerLengthEscaleLengthƓtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsNumber07() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isNumber(new BigDecimal("123.45"), 3, true,
                2, true));
    }
    /**
     * testIsNumber08()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:BigDecimal("123.45")<br>
     *         () integerLength:3<br>
     *         () isAccordedInteger:false<br>
     *         () scaleLength:2<br>
     *         () isAccordedScale:false<br>
     *
     * <br>
     * ҒlF(߂l) boolean:true<br>
     *
     * <br>
     * isAccordedIntegerEscaleLengthfalsȅꍇAEintegerLengthEscaleLengthƓtrue擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsNumber08() throws Exception {
        // eXg{E
        assertTrue(ValidationUtil.isNumber(new BigDecimal("123.45"), 3, false,
                2, false));
    }

    /**
     * testIsNumber09()
     * <br><br>
     *
     * (n)
     * <br>
     * ϓ_FF
     * <br><br>
     * ͒lF() value:BigDecimal("123.00000")<br>
     *         () integerLength:3<br>
     *         () isAccordedInteger:false<br>
     *         () scaleLength:2<br>
     *         () isAccordedScale:false<br>
     *
     * <br>
     * ҒlF(߂l) boolean:false<br>
     *
     * <br>
     * ͏𖞂AAccordedScalefalseŁAscaleLength傫ꍇAfalse擾ł邱ƂmFB
     * <br>
     *
     * @throws Exception ̃\bhŔO
     */
    public void testIsNumber09() throws Exception {
        // eXg{E
        assertFalse(ValidationUtil.isNumber(new BigDecimal("123.00000"), 3,
                false, 2, false));
    }


}
