/*
 * Decompiled with CFR 0.152.
 */
package com.sun.net.ssl.internal.ssl;

import com.sun.net.ssl.X509TrustManager;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public final class X509TrustManagerImpl
implements X509TrustManager {
    public HashMap a = new HashMap();
    public X509Certificate[] b;

    public X509TrustManagerImpl(KeyStore keyStore) throws KeyStoreException {
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            Certificate[] certificateArray;
            String string = enumeration.nextElement();
            if (keyStore.isCertificateEntry(string)) {
                certificateArray = keyStore.getCertificate(string);
                if (!(certificateArray instanceof X509Certificate)) continue;
                this.a.put(certificateArray, certificateArray);
                continue;
            }
            if (!keyStore.isKeyEntry(string) || (certificateArray = keyStore.getCertificateChain(string)) == null || certificateArray.length <= 0 || !(certificateArray[0] instanceof X509Certificate)) continue;
            this.a.put(certificateArray[0], certificateArray[0]);
        }
        this.b = new X509Certificate[this.a.size()];
        this.a.values().toArray(this.b);
    }

    private void a(X509Certificate x509Certificate, Set set, int n2) throws Exception {
        int n3;
        if (set != null && !set.isEmpty() && set.contains(new String("2.5.29.19")) && (n3 = x509Certificate.getBasicConstraints()) != -1 && n2 > 0 && n2 - 1 > n3) {
            throw new Exception("Violated basic constraints");
        }
    }

    private void a(X509Certificate x509Certificate, int n2) throws Exception {
        Set<String> set = x509Certificate.getCriticalExtensionOIDs();
        if (set == null || set.size() == 0) {
            return;
        }
        this.a(set);
        this.a(x509Certificate, set, n2);
        if (n2 == 0) {
            this.a(x509Certificate, set);
        } else {
            this.b(x509Certificate, set);
        }
    }

    private void a(X509Certificate x509Certificate, Set set) throws Exception {
        boolean[] blArray;
        if (set != null && !set.isEmpty() && set.contains(new String("2.5.29.15")) && (blArray = x509Certificate.getKeyUsage()) != null && blArray.length > 0 && !blArray[0]) {
            throw new Exception("Wrong key usage");
        }
    }

    private void b(X509Certificate x509Certificate, Set set) throws Exception {
        boolean[] blArray;
        if (set != null && !set.isEmpty() && set.contains(new String("2.5.29.15")) && (blArray = x509Certificate.getKeyUsage()) != null && blArray.length > 5 && !blArray[5]) {
            throw new Exception("Wrong key usage");
        }
    }

    private void a(Set set) throws Exception {
        if (set.size() == 1) {
            if (set.contains(new String("2.5.29.19")) || set.contains(new String("2.5.29.15"))) {
                return;
            }
            throw new Exception("Contains unknown critical extensions");
        }
        if (set.size() == 2) {
            if (set.contains(new String("2.5.29.19")) && set.contains(new String("2.5.29.15"))) {
                return;
            }
            throw new Exception("Contains unknown critical extensions");
        }
    }

    public X509Certificate[] getAcceptedIssuers() {
        return (X509Certificate[])this.b.clone();
    }

    public X509Certificate a(Principal principal) {
        Iterator iterator = this.a.values().iterator();
        while (iterator.hasNext()) {
            X509Certificate x509Certificate = (X509Certificate)iterator.next();
            if (!x509Certificate.getSubjectDN().equals(principal)) continue;
            return x509Certificate;
        }
        return null;
    }

    public boolean isClientTrusted(X509Certificate[] x509CertificateArray) {
        return this.a(x509CertificateArray);
    }

    public boolean isServerTrusted(X509Certificate[] x509CertificateArray) {
        return this.a(x509CertificateArray);
    }

    private boolean a(X509Certificate[] x509CertificateArray) {
        Date date = new Date();
        int n2 = 0;
        while (n2 < x509CertificateArray.length) {
            X509Certificate x509Certificate;
            X509Certificate x509Certificate2 = x509CertificateArray[n2];
            try {
                x509CertificateArray[n2].checkValidity(date);
                if (x509Certificate2 != null) {
                    this.a(x509Certificate2, n2);
                }
            }
            catch (Exception exception) {
                return false;
            }
            if (this.a(x509CertificateArray[n2])) {
                return true;
            }
            Principal principal = x509CertificateArray[n2].getIssuerDN();
            if (n2 + 1 != x509CertificateArray.length ? !principal.equals((x509Certificate = x509CertificateArray[n2 + 1]).getSubjectDN()) : (x509Certificate = this.a(principal)) == null) {
                return false;
            }
            try {
                if (x509Certificate == null) {
                    return false;
                }
                x509CertificateArray[n2].verify(x509Certificate.getPublicKey());
            }
            catch (Exception exception) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private boolean a(X509Certificate x509Certificate) {
        return this.a.containsKey(x509Certificate);
    }
}

