/*
 *  Copyright (c) 2011 The WebRTC project authors. All Rights Reserved.
 *
 *  Use of this source code is governed by a BSD-style license
 *  that can be found in the LICENSE file in the root of the source
 *  tree. An additional intellectual property rights grant can be found
 *  in the file PATENTS.  All contributing project authors may
 *  be found in the AUTHORS file in the root of the source tree.
 */

/* coding tables for the KLT coefficients */

#include "lpc_tables.h"
#include "settings.h"

/* indices of KLT coefficients used */
const WebRtc_UWord16 WebRtcIsac_kQKltSelIndGain[12] = {
 0,  1,  2,  3,  4,  5,  6,  7,  8,  9,
 10,  11};

const WebRtc_UWord16 WebRtcIsac_kQKltSelIndShape[108] = {
 0,  1,  2,  3,  4,  5,  6,  7,  8,  9,
 10,  11,  12,  13,  14,  15,  16,  17,  18,  19,
 20,  21,  22,  23,  24,  25,  26,  27,  28,  29,
 30,  31,  32,  33,  34,  35,  36,  37,  38,  39,
 40,  41,  42,  43,  44,  45,  46,  47,  48,  49,
 50,  51,  52,  53,  54,  55,  56,  57,  58,  59,
 60,  61,  62,  63,  64,  65,  66,  67,  68,  69,
 70,  71,  72,  73,  74,  75,  76,  77,  78,  79,
 80,  81,  82,  83,  84,  85,  86,  87,  88,  89,
 90,  91,  92,  93,  94,  95,  96,  97,  98,  99,
 100,  101,  102,  103,  104,  105,  106,  107};

/* cdf array for model indicator */
const WebRtc_UWord16 WebRtcIsac_kQKltModelCdf[4] = {
 0,  15434,  37548,  65535};

/* pointer to cdf array for model indicator */
const WebRtc_UWord16 *WebRtcIsac_kQKltModelCdfPtr[1] = {WebRtcIsac_kQKltModelCdf};

/* initial cdf index for decoder of model indicator */
const WebRtc_UWord16 WebRtcIsac_kQKltModelInitIndex[1] = {1};

/* offset to go from rounded value to quantization index */
const short WebRtcIsac_kQKltQuantMinGain[12] = {
 3,  6,  4,  6,  6,  9,  5,  16,  11,  34, 32,  47};


const short WebRtcIsac_kQKltQuantMinShape[108] = {
 0,  0,  0,  0,  0,  0,  0,  0,  0,  1,
 1,  1,  1,  1,  2,  2,  2,  3,  0,  0,
 0,  0,  1,  0,  0,  0,  0,  1,  1,  1,
 1,  1,  1,  2,  2,  3,  0,  0,  0,  0,
 1,  0,  1,  1,  1,  1,  1,  1,  1,  2,
 2,  4,  3,  5,  0,  0,  0,  0,  1,  1,
 1,  1,  1,  1,  2,  1,  2,  2,  3,  4,
 4,  7,  0,  0,  1,  1,  1,  1,  1,  1,
 1,  2,  3,  2,  3,  4,  4,  5,  7,  13,
 0,  1,  1,  2,  3,  2,  2,  2,  4,  4,
 5,  6,  7,  11,  9,  13,  12,  26};

/* maximum quantization index */
const WebRtc_UWord16 WebRtcIsac_kQKltMaxIndGain[12] = {
 6,  12,  8,  14,  10,  19,  12,  31,  22,  56, 52,  138};

const WebRtc_UWord16 WebRtcIsac_kQKltMaxIndShape[108] = {
 0,  0,  0,  0,  0,  0,  0,  0,  0,  1,
 2,  2,  2,  2,  4,  4,  5,  6,  0,  0,
 0,  0,  1,  0,  0,  0,  0,  1,  2,  2,
 2,  2,  3,  4,  5,  7,  0,  0,  0,  0,
 2,  0,  2,  2,  2,  2,  3,  2,  2,  4,
 4,  6,  6,  9,  0,  0,  0,  0,  2,  2,
 2,  2,  2,  2,  3,  2,  4,  4,  7,  7,
 9,  13,  0,  0,  2,  2,  2,  2,  2,  2,
 3,  4,  5,  4,  6,  8,  8,  10,  16,  25,
 0,  2,  2,  4,  5,  4,  4,  4,  7,  8,
 9,  10,  13,  19,  17,  23,  25,  49};

/* index offset */
const WebRtc_UWord16 WebRtcIsac_kQKltOffsetGain[3][12] = {
{ 0,  7,  20,  29,  44,  55,  75,  88,  120,  143,
 200,  253},
{ 0,  7,  19,  27,  42,  53,  73,  86,  117,  140,
 197,  249},
{ 0,  7,  20,  28,  44,  55,  75,  89,  121,  145,
 202,  257}};

const WebRtc_UWord16 WebRtcIsac_kQKltOffsetShape[3][108] = {
{ 0,  1,  2,  3,  4,  5,  6,  7,  8,  9,
 11,  14,  17,  20,  23,  28,  33,  39,  46,  47,
 48,  49,  50,  52,  53,  54,  55,  56,  58,  61,
 64,  67,  70,  74,  79,  85,  93,  94,  95,  96,
 97,  100,  101,  104,  107,  110,  113,  117,  120,  123,
 128,  133,  140,  147,  157,  158,  159,  160,  161,  164,
 167,  170,  173,  176,  179,  183,  186,  191,  196,  204,
 212,  222,  236,  237,  238,  241,  244,  247,  250,  253,
 256,  260,  265,  271,  276,  283,  292,  301,  312,  329,
 355,  356,  359,  362,  367,  373,  378,  383,  388,  396,
 405,  415,  426,  440,  460,  478,  502,  528},
{ 0,  1,  2,  3,  4,  6,  7,  8,  9,  11,
 13,  16,  19,  22,  26,  29,  34,  39,  45,  46,
 47,  48,  49,  50,  51,  52,  53,  55,  57,  60,
 63,  66,  70,  73,  78,  84,  91,  92,  93,  94,
 95,  96,  97,  99,  102,  105,  108,  111,  114,  118,
 123,  128,  134,  141,  151,  152,  153,  154,  156,  159,
 162,  165,  168,  171,  174,  177,  181,  186,  194,  200,
 208,  218,  233,  234,  235,  236,  239,  242,  245,  248,
 251,  254,  258,  263,  270,  277,  288,  297,  308,  324,
 349,  351,  354,  357,  361,  366,  372,  378,  383,  390,
 398,  407,  420,  431,  450,  472,  496,  524},
{ 0,  1,  2,  3,  4,  5,  6,  7,  8,  11,
 14,  17,  20,  23,  26,  29,  34,  40,  47,  48,
 49,  50,  51,  52,  53,  54,  55,  58,  61,  64,
 67,  70,  73,  77,  82,  88,  96,  97,  98,  99,
 101,  102,  104,  107,  110,  113,  116,  119,  122,  125,
 129,  134,  141,  150,  160,  161,  162,  163,  166,  168,
 171,  174,  177,  180,  183,  186,  190,  195,  201,  208,
 216,  226,  243,  244,  245,  248,  251,  254,  257,  260,
 263,  268,  273,  278,  284,  291,  299,  310,  323,  340,
 366,  368,  371,  374,  379,  383,  389,  394,  399,  406,
 414,  422,  433,  445,  461,  480,  505,  533}};

/* initial cdf index for KLT coefficients */
const WebRtc_UWord16 WebRtcIsac_kQKltInitIndexGain[3][12] = {
{ 3,  6,  4,  7,  5,  10,  6,  16,  11,  28,
 26,  69},
{ 3,  6,  4,  7,  5,  10,  6,  15,  11,  28,
 26,  69},
{ 3,  6,  4,  8,  5,  10,  7,  16,  12,  28,
 27,  70}};

const WebRtc_UWord16 WebRtcIsac_kQKltInitIndexShape[3][108] = {
{ 0,  0,  0,  0,  0,  0,  0,  0,  0,  1,
 1,  1,  1,  1,  2,  2,  3,  3,  0,  0,
 0,  0,  1,  0,  0,  0,  0,  1,  1,  1,
 1,  1,  2,  2,  3,  4,  0,  0,  0,  0,
 1,  0,  1,  1,  1,  1,  2,  1,  1,  2,
 2,  3,  3,  5,  0,  0,  0,  0,  1,  1,
 1,  1,  1,  1,  2,  1,  2,  2,  4,  4,
 5,  7,  0,  0,  1,  1,  1,  1,  1,  1,
 2,  2,  3,  2,  3,  4,  4,  5,  8,  13,
 0,  1,  1,  2,  3,  2,  2,  2,  4,  4,
 5,  5,  7,  10,  9,  12,  13,  25},
{ 0,  0,  0,  0,  1,  0,  0,  0,  1,  1,
 1,  1,  1,  2,  1,  2,  2,  3,  0,  0,
 0,  0,  0,  0,  0,  0,  1,  1,  1,  1,
 1,  2,  1,  2,  3,  3,  0,  0,  0,  0,
 0,  0,  1,  1,  1,  1,  1,  1,  2,  2,
 2,  3,  3,  5,  0,  0,  0,  1,  1,  1,
 1,  1,  1,  1,  1,  2,  2,  4,  3,  4,
 5,  7,  0,  0,  0,  1,  1,  1,  1,  1,
 1,  2,  2,  3,  3,  5,  4,  5,  8,  12,
 1,  1,  1,  2,  2,  3,  3,  2,  3,  4,
 4,  6,  5,  9,  11,  12,  14,  25},
{ 0,  0,  0,  0,  0,  0,  0,  0,  1,  1,
 1,  1,  1,  1,  1,  2,  3,  3,  0,  0,
 0,  0,  0,  0,  0,  0,  1,  1,  1,  1,
 1,  1,  2,  2,  3,  4,  0,  0,  0,  1,
 0,  1,  1,  1,  1,  1,  1,  1,  1,  2,
 2,  3,  4,  5,  0,  0,  0,  1,  1,  1,
 1,  1,  1,  1,  1,  2,  2,  3,  3,  4,
 5,  8,  0,  0,  1,  1,  1,  1,  1,  1,
 2,  2,  2,  3,  3,  4,  5,  6,  8,  13,
 1,  1,  1,  2,  2,  3,  2,  2,  3,  4,
 4,  5,  6,  8,  9,  12,  14,  25}};

/* offsets for quantizer representation levels*/
const WebRtc_UWord16 WebRtcIsac_kQKltOfLevelsGain[3] = {
 0,  392,  779};

const WebRtc_UWord16 WebRtcIsac_kQKltOfLevelsShape[3] = {
 0,  578,  1152};

/* quantizer representation levels */
const double WebRtcIsac_kQKltLevelsGain[1176] = {
-2.78127126, -1.76745590, -0.77913790, -0.00437329,  0.79961206,  1.81775776,  2.81389782, -5.78753143, -4.88384084, -3.89320940,
-2.88133610, -1.92859977, -0.86347396,  0.02003888,  0.86140400,  1.89667156,  2.97134967,  3.98781964,  4.91727277,  5.82865898,
-4.11195874, -2.80898424, -1.87547977, -0.80943825, -0.00679084,  0.79573851,  1.83953397,  2.67586037,  3.76274082, -6.10933968,
-4.93034581, -3.89281296, -2.91530625, -1.89684163, -0.85319130, -0.02275767,  0.86862017,  1.91578276,  2.96107339,  3.96543056,
 4.91369908,  5.91058154,  6.83848343,  8.07136925, -5.87470395, -4.84703049, -3.84284597, -2.86168446, -1.89290192, -0.82798145,
-0.00080013,  0.82594974,  1.85754329,  2.88351798,  3.96172628, -8.85684885, -7.87387461, -6.97811862, -5.93256270, -4.94301439,
-3.95513701, -2.96041544, -1.94031192, -0.87961478, -0.00456201,  0.89911505,  1.91723376,  2.94011511,  3.93302540,  4.97990967,
 5.93133404,  7.02181199,  7.92407762,  8.80155440,  10.04665814, -4.82396678, -3.85612158, -2.89482244, -1.89558408, -0.90036978,
-0.00677823,  0.90607989,  1.90937981,  2.91175777,  3.91637730,  4.97565723,  5.84771228,  7.11145863, -16.07879840, -15.03776309,
-13.93905670, -12.95671800, -11.89171202, -10.95820934, -9.95923714, -8.94357334, -7.99068299, -6.97481009, -5.94826231, -4.96673988,
-3.97490466, -2.97846970, -1.95130435, -0.94215262, -0.01444043,  0.96770704,  1.95848598,  2.94107862,  3.95666119,  4.97253085,
 5.97191122,  6.93277360,  7.96608727,  8.87958779,  10.00264269,  10.86560820,  12.07449071,  13.04491775,  13.97507061,  14.91845261,
-10.85696295, -9.83365357, -9.01245635, -7.95915145, -6.95625003, -5.95362618, -4.93468444, -3.98760978, -2.95044407, -1.97041277,
-0.97701799, -0.00840234,  0.97834289,  1.98361415,  2.97802439,  3.96415871,  4.95369042,  5.94101770,  6.92756798,  7.94063998,
 8.85951828,  9.97077022,  11.00068503, -33.92030406, -32.81426422, -32.00000000, -31.13243639, -30.11886909, -29.06017570, -28.12598824,
-27.22045482, -25.81215858, -25.07849962, -23.93018013, -23.02097643, -21.89529725, -20.99091085, -19.98889048, -18.94327044, -17.96562071,
-16.96126218, -15.95054062, -14.98516200, -13.97101012, -13.02106500, -11.98438006, -11.03216748, -9.95930286, -8.97043946, -7.98085082,
-6.98360995, -5.98998802, -4.98668173, -4.00032906, -3.00420619, -1.98701132, -0.99324682, -0.00609324,  0.98297834,  1.99483076,
 3.00305044,  3.97142097,  4.97525759,  5.98612258,  6.97448236,  7.97575900,  9.01086211,  9.98665542,  11.00541438,  11.98078628,
 12.92352471,  14.06849675,  14.99949430,  15.94904834,  16.97440321,  18.04040916,  18.88987609,  20.05312391,  21.00000000,  21.79443341,
-31.98578825, -31.00000000, -29.89060567, -28.98555686, -27.97114102, -26.84935410, -26.02402230, -24.94195278, -23.92336849, -22.95552382,
-21.97932836, -20.96055470, -19.99649553, -19.03436122, -17.96706525, -17.01139515, -16.01363516, -14.99154248, -14.00298333, -12.99630613,
-11.99955519, -10.99000421, -10.00819092, -8.99763648, -7.98431793, -7.01769025, -5.99604690, -4.99980697, -3.99334671, -3.01748192,
-2.02051217, -1.00848371, -0.01942358,  1.00477757,  1.95477872,  2.98593031,  3.98779079,  4.96862849,  6.02694771,  6.93983733,
 7.89874717,  8.99615862,  10.02367921,  10.96293452,  11.84351528,  12.92207187,  13.85122329,  15.05146877,  15.99371264,  17.00000000,
 18.00000000,  19.00000000,  19.82763573, -47.00000000, -46.00000000, -44.87138498, -44.00000000, -43.00000000, -42.00000000, -41.00000000,
-39.88966612, -38.98913239, -37.80306486, -37.23584325, -35.94200288, -34.99881301, -34.11361858, -33.06507360, -32.13129135, -30.90891364,
-29.81511907, -28.99250380, -28.04535391, -26.99767800, -26.04418164, -24.95687851, -24.04865595, -23.03392645, -21.89366707, -20.93517364,
-19.99388660, -18.91620943, -18.03749683, -16.99532379, -15.98683813, -15.06421479, -13.99359211, -12.99714098, -11.97022520, -10.98500279,
-9.98834422, -8.95729330, -8.01232284, -7.00253661, -5.99681626, -5.01207817, -3.95914904, -3.01232178, -1.96615919, -0.97687670,
 0.01228030,  0.98412288,  2.01753544,  3.00580570,  3.97783510,  4.98846894,  6.01321400,  7.00867732,  8.00416375,  9.01771966,
 9.98637729,  10.98255180,  11.99194163,  13.01807333,  14.00999545,  15.00118556,  16.00089224,  17.00584148,  17.98251763,  18.99942091,
 19.96917690,  20.97839265,  21.98207297,  23.00171271,  23.99930737,  24.99746061,  26.00936304,  26.98240132,  28.01126868,  29.01395915,
 29.98153507,  31.01376711,  31.99876818,  33.00475317,  33.99753994,  34.99493913,  35.98933585,  36.95620160,  37.98428461,  38.99317544,
 40.01832073,  40.98048133,  41.95999283,  42.98232091,  43.96523612,  44.99574268,  45.99524194,  47.05464025,  48.03821548,  48.99354366,
 49.96400411,  50.98017973,  51.95184408,  52.96291806,  54.00194392,  54.96603783,  55.95623778,  57.03076595,  58.05889901,  58.99081551,
 59.97928121,  61.05071612,  62.03971580,  63.01286038,  64.01290338,  65.02074503,  65.99454594,  67.00399425,  67.96571257,  68.95305727,
 69.92030664,  70.95594862,  71.98088567,  73.04764124,  74.00285480,  75.02696330,  75.89837673,  76.93459997,  78.16266309,  78.83317543,
 80.00000000,  80.87251574,  82.09803524,  83.10671664,  84.00000000,  84.77023523,  86.00000000,  87.00000000,  87.92946897,  88.69159118,
 90.00000000,  90.90535270, -3.00000000, -2.00000000, -0.77592424, -0.00564307,  0.76727305,  2.00000000,  3.00000000, -6.00000000,
-5.00000000, -4.00000000, -2.92897924, -1.85623684, -0.72445303, -0.00119184,  0.72896652,  2.05710416,  3.17909894,  4.00000000,
 5.00000000, -3.00000000, -2.00000000, -0.67480586, -0.00028016,  0.66618169,  2.00000000,  3.00000000,  4.00000000, -7.00000000,
-6.00000000, -5.00000000, -3.78336783, -2.84811556, -2.04088844, -0.71114371,  0.03142493,  0.69662772,  1.91417930,  3.00000000,
 4.01411062,  5.00000000,  6.00000000,  7.00000000, -6.00000000, -5.00000000, -4.00000000, -3.00000000, -2.00000000, -0.63703469,
 0.00169604,  0.66294191,  1.83808563,  3.00000000,  4.00000000, -8.00000000, -7.00000000, -6.03082300, -5.00000000, -3.88061019,
-2.92670084, -1.99902336, -0.72898996, -0.02880170,  0.73769927,  1.95920233,  2.78356263,  4.08100921,  5.00000000,  6.00000000,
 6.78771437,  8.00000000,  9.00000000,  10.00000000,  11.00000000, -5.00000000, -4.00000000, -2.88150384, -1.89520024, -0.71479482,
 0.00962397,  0.72816030,  1.73583550,  3.00000000,  4.00000000,  5.00000000,  6.00000000,  7.00000000, -16.00000000, -15.00000000,
-13.80516401, -13.00000000, -12.00000000, -11.00000000, -10.02723144, -9.11825995, -8.05820112, -7.00000000, -6.17943541, -5.01837980,
-3.97546169, -2.92806857, -1.89778775, -0.81138893, -0.02246016,  0.80528415,  1.85705214,  2.96438524,  3.97540151,  4.79684246,
 6.00000000,  6.75549513,  8.12185828,  9.00000000,  10.00000000,  11.00000000,  12.00000000,  13.00000000,  14.00000000, -11.00000000,
-10.00000000, -9.00000000, -7.91603344, -6.77865892, -5.85765006, -4.93342332, -3.96679157, -2.84925552, -1.89230732, -0.85384229,
 0.00579591,  0.84863246,  1.89006713,  2.89483818,  3.87322971,  5.13228411,  6.00000000,  7.00000000,  8.00000000,  9.00000000,
 10.00000000,  11.00000000, -34.00000000, -33.00000000, -32.00000000, -31.00000000, -30.00000000, -29.00000000, -28.00000000, -27.00000000,
-26.00000000, -25.00000000, -24.00000000, -23.00000000, -22.00000000, -21.00000000, -20.19501953, -19.00000000, -18.00000000, -17.00000000,
-16.00000000, -14.89069633, -14.00000000, -13.00000000, -12.16260304, -11.15418282, -9.83543570, -8.85600407, -7.82712677, -7.05664308,
-5.97007352, -4.89268438, -3.93822771, -2.94975269, -1.92192127, -0.90702480,  0.03974847,  0.92488359,  1.93747579,  2.94500522,
 3.95181797,  4.95433087,  5.95141808,  7.00212920,  8.02964757,  9.03210585,  9.84644504,  10.82907720,  11.87622530,  12.96908371,
 14.00000000,  15.16963413,  15.94902025,  17.00000000,  18.00000000,  19.00000000,  20.00000000,  21.00000000,  22.00000000, -29.00000000,
-27.79780781, -27.00757888, -26.01571026, -24.89695568, -23.99946491, -22.98699614, -21.96678139, -20.99883532, -20.00851529, -18.94738054,
-17.98672566, -16.98684787, -15.96917397, -14.99856852, -13.98974852, -12.97786927, -11.96110939, -10.98877093, -9.99875257, -8.99001359,
-8.00799989, -6.99471760, -6.00034670, -4.99936372, -4.00581479, -3.00424577, -2.02047620, -0.99713266, -0.00366397,  1.00803955,
 1.98452687,  3.00748501,  4.02714611,  4.97661026,  5.99337271,  6.99754716,  8.00713602,  8.97184974,  9.98047901,  10.97685939,
 11.99533975,  12.96107876,  13.95061478,  15.00756776,  15.94078690,  16.88231059,  17.92069248,  18.78011047,  20.00000000,  21.00000000,
 22.00000000, -55.76988333, -54.96048193, -53.88411581, -52.94117980, -51.80983449, -50.90359699, -50.00000000, -48.99838741, -47.97685542,
-47.03288597, -45.97820919, -45.02418374, -43.90081897, -42.88832512, -41.98234549, -40.96745512, -39.98148729, -39.06792854, -37.96493755,
-36.98707870, -36.03416079, -35.01192444, -33.95785029, -32.99469087, -31.96633807, -31.01769053, -29.99727691, -28.99329690, -27.98873019,
-27.00344273, -25.97657141, -25.00511074, -23.96689479, -23.01566842, -22.01632643, -21.00076343, -19.97788007, -18.97248680, -17.96076284,
-16.97585453, -15.98345587, -15.01612745, -13.96862118, -12.96622055, -12.02196641, -11.02078103, -9.98445656, -9.00050060, -8.03442387,
-7.00363761, -5.97921358, -4.98886269, -4.00528221, -3.01672947, -1.98599795, -1.00668518, -0.02633490,  1.00794139,  2.00837138,
 2.99213287,  3.98710216,  4.99064334,  6.01416391,  7.01759708,  7.97878151,  8.99665730,  10.02656114,  11.01863887,  12.01207901,
 13.00958725,  13.99237829,  15.00954971,  16.00724653,  17.00606559,  17.99886292,  18.99611967,  19.98808171,  21.01871930,  21.97014763,
 22.99833843,  24.00316842,  24.99949142,  25.98539601,  27.02480733,  27.98075377,  28.98266019,  30.00611445,  30.99409128,  31.94523141,
 32.97688339,  33.98800206,  35.00177074,  35.98639997,  36.98939428,  37.95644255,  39.00114054,  39.99492439,  40.99338254,  41.97050844,
 43.03085663,  43.96757668,  44.97800970,  45.95953358,  46.98109551,  47.99368477,  49.00141209,  49.94459923,  50.93298108,  51.99894661,
 53.06463883,  53.99704669,  55.02037199,  55.98368047,  57.01930954,  58.03813852,  58.96232502,  60.01644186,  61.03254711,  62.01086576,
 62.87962247,  63.98378413,  65.02189831,  65.93003954,  66.92439900,  68.07051633,  68.95928756,  70.03315022,  71.05579859,  72.00000000,
 73.00000000,  74.00000000,  75.00000000,  75.93485291,  77.20950456,  78.00000000,  79.00000000,  79.91519960,  81.00000000, -3.00000000,
-2.00000000, -0.65174074, -0.00092112,  0.62967387,  2.00000000,  3.00000000, -6.00000000, -5.00000000, -4.00000000, -2.89861729,
-1.69999061, -0.72632201,  0.00219241,  0.72891750,  1.73257865,  3.00000000,  3.76561508,  5.00000000,  6.00000000, -3.00000000,
-2.00000000, -0.66227013,  0.00389373,  0.66163500,  2.00000000,  3.00000000,  4.00000000, -8.00000000, -7.00000000, -6.00000000,
-4.76421796, -4.04320264, -3.01415201, -1.84346485, -0.77185048,  0.00061977,  0.76274524,  1.84330156,  3.00000000,  4.00000000,
 5.00000000,  6.00000000,  7.00000000, -6.00000000, -5.00000000, -4.00000000, -3.00000000, -1.75749611, -0.72951347, -0.00104394,
 0.72040315,  1.72594036,  3.00000000,  4.00000000, -9.00000000, -8.00000000, -7.00000000, -5.90394062, -5.00000000, -3.75562807,
-2.89699407, -1.86696610, -0.79056636, -0.00330943,  0.79744554,  1.85149941,  2.91118681,  3.99520311,  4.96341987,  6.00000000,
 7.00000000,  8.00000000,  9.00000000,  10.00000000, -6.00000000, -4.80151529, -4.00000000, -2.87442856, -1.85285815, -0.77767592,
-0.02071301,  0.81752572,  1.82503940,  2.79602150,  3.92870203,  5.00000000,  6.00000000,  7.00000000, -17.00000000, -16.00000000,
-15.00000000, -14.00000000, -13.00000000, -12.00000000, -11.00000000, -9.80059874, -9.00000000, -8.00185204, -7.13087808, -5.92942149,
-4.77883243, -3.93417708, -2.88004618, -1.89952522, -0.86239337,  0.00332274,  0.86657548,  1.89479279,  2.89701813,  3.90987417,
 4.98910145,  6.07676766,  7.00000000,  8.00000000,  9.00000000,  10.00000000,  11.00000000,  12.00000000,  13.00000000,  14.00000000,
-12.00000000, -11.00000000, -9.89996262, -8.85894205, -7.87594823, -6.99685317, -5.94917589, -4.93914916, -3.93317670, -2.93174244,
-1.90737478, -0.90982242,  0.00803316,  0.90111563,  1.90362879,  2.90332432,  3.90654662,  4.94461954,  5.87963665,  6.91988113,
 7.79514004,  8.98805413,  10.00000000,  11.00000000, -35.00000000, -34.00000000, -33.00000000, -32.00000000, -31.00000000, -30.00000000,
-29.00000000, -28.00000000, -27.00000000, -26.00000000, -25.00000000, -24.00000000, -22.88310970, -22.00000000, -21.00000000, -20.00000000,
-19.00000000, -18.00000000, -17.00000000, -16.11854974, -15.00000000, -14.10507667, -13.04497040, -11.94846700, -10.97432494, -9.94514368,
-8.97311414, -7.94171496, -6.97232122, -5.98590548, -4.97455572, -3.95477903, -2.93935454, -1.95573532, -0.97120273, -0.02084826,
 0.95689153,  1.96679781,  2.97060165,  3.96660892,  4.96754331,  5.97996089,  6.93822411,  7.96618014,  8.95809791,  9.98891474,
 10.95713402,  11.85433084,  13.03831696,  13.84035295,  15.00729606,  15.98652872,  17.20557599,  18.00000000,  18.90794805,  20.00000000,
 21.00000000, -34.00000000, -33.00000000, -32.00000000, -31.00000000, -30.00000000, -28.97280602, -28.00000000, -27.16255057, -26.04078092,
-24.85442050, -24.15783484, -22.78614956, -21.95739865, -21.21844626, -20.03008104, -19.03888543, -17.90460490, -17.02064693, -15.84673652,
-14.87140709, -13.87996048, -12.94907251, -11.96795995, -11.00977925, -9.95103238, -8.96674655, -7.96351667, -6.96886200, -5.99335494,
-4.97515534, -3.98891694, -2.99581150, -1.98758360, -0.99249128, -0.00001403,  0.98807868,  1.99119869,  2.99019366,  3.98612953,
 5.00312941,  5.98833080,  6.99686651,  7.98373889,  8.97942222,  9.94202752,  10.99671622,  11.94306164,  12.98539825,  13.90728690,
 14.89907642,  15.94836675,  16.89611342,  17.84084949,  18.74910958,  20.00000000, -67.00000000, -66.00000000, -65.00000000, -64.00000000,
-63.02511977, -62.00000000, -61.06061493, -59.95964043, -59.12824439, -58.00000000, -57.00000000, -56.00000000, -54.87857996, -54.09689334,
-53.00000000, -52.21057366, -50.93867921, -50.03032952, -49.19283867, -47.89439051, -46.99505692, -46.04895543, -44.89687413, -43.78942208,
-42.99025156, -41.88436155, -40.99169704, -40.00320429, -38.90181498, -38.06029271, -37.05030818, -36.07554573, -35.03202233, -33.93117946,
-32.97736655, -31.98942819, -30.99546798, -30.01511004, -28.97296525, -28.02561164, -26.94386985, -25.99632704, -25.00461143, -24.01578192,
-22.99177609, -22.02261094, -20.97939001, -19.96176066, -19.00442980, -18.01529434, -17.00196902, -15.99794828, -14.98675055, -13.97517657,
-12.98676283, -11.99718760, -11.00167809, -9.98872268, -9.02138474, -8.00320338, -6.99542797, -6.00059136, -5.01311763, -4.00336943,
-3.00348281, -1.99365875, -0.98223019,  0.00126343,  0.99699237,  1.99381968,  3.00054436,  3.99898305,  5.00160508,  6.00310399,
 6.99885096,  8.02740039,  8.99515550,  9.98962151,  11.00642302,  11.98694516,  13.00018933,  13.97726018,  14.99186645,  16.00580131,
 16.97434224,  17.96982658,  19.00066438,  20.01228749,  21.00741822,  21.94988312,  23.00860212,  23.98801542,  24.97638417,  25.98003521,
 27.02336188,  27.99667029,  29.01014125,  30.02481912,  31.01415797,  31.97399854,  33.06214485,  33.99929330,  34.94095386,  35.96368372,
 36.96980925,  37.98389244,  39.01121235,  40.00715026,  41.06382894,  41.96618280,  43.01555590,  43.95430436,  45.01970038,  45.99967821,
 47.19847394,  48.04852502,  49.10609965,  50.04244122,  50.86051406,  51.92983796,  53.02781107,  54.06248545,  54.89942009,  56.08347165,
 57.06887956,  58.09671115,  59.07832400,  59.87005277,  61.14778499,  62.00000000,  63.00000000,  64.00000000,  65.00000000,  66.00000000,
 67.00000000,  68.00000000,  69.00000000,  70.00000000,  71.00000000,  72.00000000};

const double WebRtcIsac_kQKltLevelsShape[1735] = {
 0.00032397,  0.00008053, -0.00061202, -0.00012620,  0.00030437,  0.00054764, -0.00027902,  0.00069360,  0.00029449, -0.80219239,
 0.00091089, -0.74514927, -0.00094283,  0.64030631, -0.60509119,  0.00035575,  0.61851665, -0.62129957,  0.00375219,  0.60054900,
-0.61554359,  0.00054977,  0.63362016, -1.73118727, -0.65422341,  0.00524568,  0.66165298,  1.76785515, -1.83182018, -0.65997434,
-0.00011887,  0.67524299,  1.79933938, -1.76344480, -0.72547708, -0.00133017,  0.73104704,  1.75305377,  2.85164534, -2.80423916,
-1.71959639, -0.75419722, -0.00329945,  0.77196760,  1.72211069,  2.87339653,  0.00031089, -0.00015311,  0.00018201, -0.00035035,
-0.77357251,  0.00154647, -0.00047625, -0.00045299,  0.00086590,  0.00044762, -0.83383829,  0.00024787, -0.68526258, -0.00122472,
 0.64643255, -0.60904942, -0.00448987,  0.62309184, -0.59626442, -0.00574132,  0.62296546, -0.63222115,  0.00013441,  0.63609545,
-0.66911055, -0.00369971,  0.66346095,  2.07281301, -1.77184694, -0.67640425, -0.00010145,  0.64818392,  1.74948973, -1.69420224,
-0.71943894, -0.00004680,  0.75303493,  1.81075983,  2.80610041, -2.80005755, -1.79866753, -0.77409777, -0.00084220,  0.80141293,
 1.78291081,  2.73954236,  3.82994169,  0.00015140, -0.00012766, -0.00034241, -0.00119125, -0.76113497,  0.00069246,  0.76722027,
 0.00132862, -0.69107530,  0.00010656,  0.77061578, -0.78012970,  0.00095947,  0.77828502, -0.64787758,  0.00217168,  0.63050167,
-0.58601125,  0.00306596,  0.59466308, -0.58603410,  0.00059779,  0.64257970,  1.76512766, -0.61193600, -0.00259517,  0.59767574,
-0.61026273,  0.00315811,  0.61725479, -1.69169719, -0.65816029,  0.00067575,  0.65576890,  2.00000000, -1.72689193, -0.69780808,
-0.00040990,  0.70668487,  1.74198458, -3.79028154, -3.00000000, -1.73194459, -0.70179341, -0.00106695,  0.71302629,  1.76849782,
-2.89332364, -1.78585007, -0.78731491, -0.00132610,  0.79692976,  1.75247009,  2.97828682, -5.26238694, -3.69559829, -2.87286122,
-1.84908818, -0.84434577, -0.01167975,  0.84641753,  1.84087672,  2.87628156,  3.83556679, -0.00190204,  0.00092642,  0.00354385,
-0.00012982, -0.67742785,  0.00229509,  0.64935672, -0.58444751,  0.00470733,  0.57299534, -0.58456202, -0.00097715,  0.64593607,
-0.64060330, -0.00638534,  0.59680157, -0.59287537,  0.00490772,  0.58919707, -0.60306173, -0.00417464,  0.60562100, -1.75218757,
-0.63018569, -0.00225922,  0.63863300, -0.63949939, -0.00126421,  0.64268914, -1.75851182, -0.68318060,  0.00510418,  0.69049211,
 1.88178506, -1.71136148, -0.72710534, -0.00815559,  0.73412917,  1.79996711, -2.77111145, -1.73940498, -0.78212945,  0.01074476,
 0.77688916,  1.76873972,  2.87281379,  3.77554698, -3.75832725, -2.95463235, -1.80451491, -0.80017226,  0.00149902,  0.80729206,
 1.78265046,  2.89391793, -3.78236148, -2.83640598, -1.82532067, -0.88844327, -0.00620952,  0.88208030,  1.85757631,  2.81712391,
 3.88430176,  5.16179367, -7.00000000, -5.93805408, -4.87172597, -3.87524433, -2.89399744, -1.92359563, -0.92136341, -0.00172725,
 0.93087018,  1.90528280,  2.89809686,  3.88085708,  4.89147740,  5.89078692, -0.00239502,  0.00312564, -1.00000000,  0.00178325,
 1.00000000, -0.62198029,  0.00143254,  0.65344051, -0.59851220, -0.00676987,  0.61510140, -0.58894151,  0.00385055,  0.59794203,
-0.59808568, -0.00038214,  0.57625703, -0.63009713, -0.01107985,  0.61278758, -0.64206758, -0.00154369,  0.65480598,  1.80604162,
-1.80909286, -0.67810514,  0.00205762,  0.68571097,  1.79453891, -3.22682422, -1.73808453, -0.71870305, -0.00738594,  0.71486172,
 1.73005326, -1.66891897, -0.73689615, -0.00616203,  0.74262409,  1.73807899, -2.92417482, -1.73866741, -0.78133871,  0.00764425,
 0.80027264,  1.78668732,  2.74992588, -4.00000000, -2.75578740, -1.83697516, -0.83117035, -0.00355191,  0.83527172,  1.82814700,
 2.77377675,  3.80718693, -3.81667698, -2.83575471, -1.83372350, -0.86579471,  0.00547578,  0.87582281,  1.82858793,  2.87265007,
 3.91405377, -4.87521600, -3.78999094, -2.86437014, -1.86964365, -0.90618018,  0.00128243,  0.91497811,  1.87374952,  2.83199819,
 3.91519130,  4.76632822, -6.68713448, -6.01252467, -4.94587936, -3.88795368, -2.91299088, -1.92592211, -0.95504570, -0.00089980,
 0.94565200,  1.93239633,  2.91832808,  3.91363475,  4.88920034,  5.96471415,  6.83905252,  7.86195009,  8.81571018, -12.96141759,
-11.73039516, -10.96459719, -9.97382433, -9.04414433, -7.89460619, -6.96628608, -5.93236595, -4.93337924, -3.95479990, -2.96451499,
-1.96635876, -0.97271229, -0.00402238,  0.98343930,  1.98348291,  2.96641164,  3.95456471,  4.95517089,  5.98975714,  6.90322073,
 7.90468849,  8.85639467,  9.97255498,  10.79006309,  11.81988596,  0.04950500, -1.00000000, -0.01226628,  1.00000000, -0.59479469,
-0.10438305,  0.59822144, -2.00000000, -0.67109149, -0.09256692,  0.65171621,  2.00000000, -3.00000000, -1.68391999, -0.76681039,
-0.03354151,  0.71509146,  1.77615472, -2.00000000, -0.68661511, -0.02497881,  0.66478398,  2.00000000, -2.00000000, -0.67032784,
-0.00920582,  0.64892756,  2.00000000, -2.00000000, -0.68561894,  0.03641869,  0.73021611,  1.68293863, -4.00000000, -2.72024184,
-1.80096059, -0.81696185,  0.03604685,  0.79232033,  1.70070730,  3.00000000, -4.00000000, -2.71795670, -1.80482986, -0.86001162,
 0.03764903,  0.87723968,  1.79970771,  2.72685932,  3.67589143, -5.00000000, -4.00000000, -2.85492548, -1.78996365, -0.83250358,
-0.01376828,  0.84195506,  1.78161105,  2.76754458,  4.00000000, -6.00000000, -5.00000000, -3.82268811, -2.77563624, -1.82608163,
-0.86486114, -0.02671886,  0.86693165,  1.88422879,  2.86248347,  3.95632216, -7.00000000, -6.00000000, -5.00000000, -3.77533988,
-2.86391432, -1.87052039, -0.90513658,  0.06271236,  0.91083620,  1.85734756,  2.86031688,  3.82019418,  4.94420394,  6.00000000,
-11.00000000, -10.00000000, -9.00000000, -8.00000000, -6.91952415, -6.00000000, -4.92044374, -3.87845165, -2.87392362, -1.88413020,
-0.91915740,  0.00318517,  0.91602800,  1.89664838,  2.88925058,  3.84123856,  4.78988651,  5.94526812,  6.81953917,  8.00000000,
-9.00000000, -8.00000000, -7.03319143, -5.94530963, -4.86669720, -3.92438007, -2.88620396, -1.92848070, -0.94365985,  0.01671855,
 0.97349410,  1.93419878,  2.89740109,  3.89662823,  4.83235583,  5.88106535,  6.80328232,  8.00000000, -13.00000000, -12.00000000,
-11.00000000, -10.00000000, -9.00000000, -7.86033489, -6.83344055, -5.89844215, -4.90811454, -3.94841298, -2.95820490, -1.98627966,
-0.99161468, -0.02286136,  0.96055651,  1.95052433,  2.93969396,  3.94304346,  4.88522624,  5.87434241,  6.78309433,  7.87244101,
 9.00000000,  10.00000000, -12.09117356, -11.00000000, -10.00000000, -8.84766108, -7.86934236, -6.98544896, -5.94233429, -4.95583292,
-3.95575986, -2.97085529, -1.98955811, -0.99359873, -0.00485413,  0.98298870,  1.98093258,  2.96430203,  3.95540216,  4.96915010,
 5.96775124,  6.99236918,  7.96503302,  8.99864542,  9.85857723,  10.96541926,  11.91647197,  12.71060069, -26.00000000, -25.00000000,
-24.00585596, -23.11642573, -22.14271284, -20.89800711, -19.87815799, -19.05036354, -17.88555651, -16.86471209, -15.97711073, -14.94012359,
-14.02661226, -12.98243228, -11.97489256, -10.97402777, -9.96425624, -9.01085220, -7.97372506, -6.98795002, -5.97271328, -5.00191694,
-3.98055849, -2.98458048, -1.99470442, -0.99656768, -0.00825666,  1.00272004,  1.99922218,  2.99357669,  4.01407905,  5.01003897,
 5.98115528,  7.00018958,  8.00338125,  8.98981046,  9.98990318,  10.96341479,  11.96866930,  12.99175139,  13.94580443,  14.95745083,
 15.98992869,  16.97484646,  17.99630043,  18.93396897,  19.88347741,  20.96532482,  21.92191032,  23.22314702,  0.00006846,  0.00014352,
-0.00056203,  0.00027588, -0.00147678,  1.00000000,  0.00003823,  0.00001975, -0.00033710, -0.00096712,  1.00000000, -1.00000000,
 0.00067511, -1.00000000,  0.00342065,  1.00000000, -1.00000000,  0.00196254,  1.00000000, -1.00000000,  0.00201173,  1.00000000,
-2.00000000, -1.00000000, -0.00381686,  1.00000000, -1.00000000,  0.00178037,  1.00000000, -2.00000000, -1.00000000, -0.00320274,
 1.00000000,  2.00000000, -2.00000000, -1.00000000,  0.00426519,  1.00000000,  2.00000000, -3.00000000, -2.00000000, -1.00000000,
-0.00074072,  0.64654602,  2.00000000,  0.00031217,  0.00063348,  0.00020247,  0.00047891,  0.00122893, -0.00150669, -0.00148276,
 0.00016848,  0.00147085,  1.00000000, -0.00088160,  1.00000000, -1.00000000,  0.00381641,  1.00000000, -1.00000000,  0.00129816,
 1.00000000, -1.00000000,  0.00074903,  1.00000000, -2.00000000, -0.76230566, -0.00370764,  0.82467977, -0.78769346, -0.00492670,
 0.84532630, -2.00000000, -0.70943195, -0.01257613,  0.75905385,  2.00000000, -2.00000000, -0.62780445, -0.00408633,  0.60272506,
 2.00000000,  3.00000000, -3.00000000, -2.00000000, -0.61412985,  0.00102833,  0.61527589,  2.00000000,  3.00000000,  0.00012115,
-0.00080909,  0.00071061, -0.00227957,  0.00179794,  0.00103827, -1.00000000,  0.00444757, -1.00000000,  0.00604068,  1.00000000,
-1.00000000,  0.00427327,  1.00000000, -1.00000000,  0.00086662,  1.00000000, -1.00000000, -0.00837492,  1.00000000, -0.65715934,
-0.00645342,  0.64004630, -2.00000000, -0.64987682, -0.01449567,  0.69893373, -2.00000000, -0.63221961,  0.00421765,  0.62452105,
 2.00000000, -2.00000000, -0.60027006, -0.00110630,  0.62033821,  2.00000000, -2.00000000, -0.59823932,  0.00928313,  0.62188520,
 2.00000000,  3.00000000, -3.00000000, -2.00000000, -0.63230286, -0.00248555,  0.62632575,  2.00000000,  3.00000000, -5.00000000,
-4.00000000, -3.00000000, -2.00000000, -0.66521143,  0.00544305,  0.66930486,  2.00000000,  3.00000000,  4.00000000,  0.00077008,
 0.00061140, -0.00009317, -0.00049643,  1.00000000, -1.00000000, -0.00285084,  1.00000000, -1.00000000,  0.00601784,  1.00000000,
-1.00000000, -0.00091887,  0.75122772, -0.71579859, -0.00043545,  1.00000000, -0.85571363, -0.00227654,  0.63816873, -1.00000000,
-0.00393484,  0.76748004, -0.58223659, -0.01229777,  0.58080322, -0.61945902, -0.00232238,  0.62277938,  2.00000000, -2.00000000,
-0.60595489, -0.00535702,  0.60547736,  2.00000000, -4.00000000, -3.00000000, -2.00000000, -0.62368122,  0.01112097,  0.63997294,
 2.00000000,  3.00000000, -3.00000000, -2.00000000, -0.64318217,  0.00515139,  0.64781184,  2.00000000, -3.00000000, -1.78031579,
-0.67122588,  0.02153711,  0.67899877,  2.00000000,  3.00000000,  4.00000000, -4.00000000, -3.00000000, -1.80503233, -0.69835727,
-0.00270770,  0.70999554,  1.77332849,  3.00000000,  4.00000000,  5.00000000, -8.00000000, -7.00000000, -6.00000000, -5.00000000,
-4.00000000, -2.81600693, -1.72970368, -0.73779413, -0.01384841,  0.75694606,  1.80042618,  3.00000000,  4.00000000,  5.00000000,
 6.00000000, -0.00051787,  0.00059593, -0.00023319, -1.00000000,  0.00191861,  0.79547197, -0.75020995,  0.00217840,  0.69165833,
-1.00000000, -0.00304964,  0.67698951, -0.64516943, -0.00657667,  0.59260129, -0.62819301, -0.00456626,  0.59426260, -0.60909519,
 0.00256476,  0.61660408, -0.66560131, -0.00293463,  0.67477566,  2.00000000, -2.00000000, -0.62484067,  0.00505116,  0.63491494,
 2.00000000, -3.00000000, -2.00000000, -0.68427246,  0.00924353,  0.68755774,  2.00000000,  3.00000000, -3.00000000, -2.00000000,
-0.65390928,  0.01008025,  0.65849449,  2.00000000,  3.00000000, -5.00000000, -4.00000000, -3.00000000, -1.70848232, -0.72079538,
-0.00007674,  0.71556176,  1.76815351,  3.00000000,  4.00000000,  5.00000000, -4.00000000, -3.00000000, -1.82887466, -0.73529886,
 0.00033458,  0.73847588,  1.83009515,  3.00000000,  4.00000000, -5.00000000, -4.00000000, -2.83203553, -1.79500085, -0.77452749,
-0.00614320,  0.77416943,  1.82469471,  2.77034612,  4.00000000,  5.00000000, -7.00000000, -6.00000000, -5.00000000, -4.00000000,
-2.76574798, -1.84700836, -0.80822297,  0.00054165,  0.80901445,  1.85687331,  2.75680191,  3.81986695,  5.00000000,  6.00000000,
 7.00000000,  8.00000000, -13.00000000, -12.00000000, -11.00000000, -10.00000000, -9.00000000, -8.00000000, -7.00000000, -6.00000000,
-5.00000000, -3.88304817, -2.93396067, -1.86645989, -0.84825410,  0.00666207,  0.84853252,  1.88634684,  2.95282618,  3.89813287,
 4.89189079,  6.00000000,  7.00000000,  8.00000000,  9.00000000,  10.00000000,  11.00000000, -0.00344877,  1.00000000, -0.61413659,
-0.02115630,  0.59438887, -0.60873054,  0.00844993,  0.62510557, -2.00000000, -0.75002947,  0.00120913,  0.66616051, -2.00000000,
-0.72324691,  0.04760499,  0.70532533,  2.00000000, -3.00000000, -1.66577589, -0.78941380, -0.01909714,  0.74993685,  1.70945570,
-1.64422308, -0.70992006, -0.02795108,  0.76990363,  1.79682243,  2.96233315, -1.71686461, -0.76572785, -0.00041846,  0.78174132,
 1.66217596, -3.00000000, -1.77033369, -0.79475091,  0.03709740,  0.80097076,  1.83947400,  2.85879773, -4.00000000, -3.16528651,
-1.79564411, -0.90078981,  0.02403102,  0.86138856,  1.84207433,  2.74584048, -4.00000000, -2.91249347, -1.87804769, -0.87323549,
 0.08164382,  0.89037056,  1.82505263,  2.71336163,  4.00000000, -4.81262228, -3.87173565, -2.83424209, -1.87517938, -0.86199960,
 0.00268598,  0.89547657,  1.90713511,  2.85219071,  3.86417171,  4.80711781,  6.00000000,  7.00000000, -5.00000000, -3.82388480,
-2.82875808, -1.90350457, -0.90795818,  0.03047007,  0.93676836,  1.88844957,  2.83269711,  3.76109686,  5.00000000, -9.00000000,
-8.00000000, -6.88037957, -5.88776398, -4.91209139, -3.93902541, -2.90989221, -1.92281230, -0.98960535, -0.07440511,  0.94023957,
 1.91666262,  2.83340828,  3.83651295,  4.77839424,  6.12284019,  7.00000000,  8.00000000,  9.00000000, -12.00000000, -11.00000000,
-10.00000000, -9.00000000, -8.00000000, -6.68554513, -5.97994708, -4.98789075, -3.91383581, -2.92952795, -1.91727195, -0.93148075,
-0.00568870,  0.93515148,  1.94580068,  2.93838956,  3.92567644,  4.96573603,  5.95402763,  7.00000000,  8.00000000,  9.00000000,
-11.00000000, -9.90096030, -8.97868124, -7.93663988, -6.98806055, -5.95937864, -4.93473664, -3.95454756, -2.96518446, -1.97711766,
-0.98552111, -0.03317271,  0.95115775,  1.93785086,  2.96310779,  3.93322450,  5.01716212,  5.85909823,  6.89163669,  7.97492693,
 8.85698897,  9.79802946,  11.09373957,  12.00000000, -13.00000000, -12.00000000, -10.67579109, -9.95079100, -8.90576592, -7.93254656,
-6.96112672, -5.96015798, -4.95493809, -3.98556269, -2.98182856, -1.98150255, -0.96551153, -0.00399791,  0.98644875,  1.98043830,
 2.97969033,  3.97728257,  4.95173541,  5.95649050,  6.96447378,  7.95591513,  9.07680954,  9.92093070,  10.76496555,  11.97525735,
 13.00000000,  14.00000000, -25.00000000, -24.00000000, -23.00000000, -22.00072357, -21.00000000, -20.00000000, -19.00000000, -18.20003462,
-17.01648407, -15.78651996, -14.95660266, -13.99167850, -13.28722978, -11.85013840, -10.92025302, -9.87055810, -8.93841040, -7.95329867,
-6.97819441, -6.01593394, -5.00905213, -3.99905285, -2.99171810, -1.99062796, -1.00112466,  0.00140492,  1.00701091,  2.02327185,
 3.00194633,  3.99188294,  5.00313145,  6.00448038,  6.98904951,  7.98158293,  8.98212774,  10.00363404,  10.98641678,  11.98034311,
 12.95176779,  13.95383703,  14.99084578,  15.98600642,  16.99406826,  17.98134623,  19.01793961,  19.86072639,  20.88465474,  21.99287082,
 22.81916620,  23.77946383,  0.00000234,  0.00000298,  0.00000048,  0.00002408, -0.00000165, -0.00001831, -0.00005703, -0.00000184,
-1.00000000,  0.00001977,  1.00000000, -1.00000000,  0.00000010,  1.00000000, -1.00000000, -0.00001152,  1.00000000, -1.00000000,
 0.00000840,  1.00000000, -1.00000000,  0.00002353,  1.00000000, -0.75455603, -0.00001433,  1.00000000, -0.65859705, -0.00000703,
 0.62995860, -2.00000000, -0.72724652, -0.00033969,  0.61359174,  2.00000000, -2.00000000, -0.69510998, -0.00031410,  0.66467605,
 2.00000000,  3.00000000, -3.00000000, -2.00000000, -0.65738683,  0.00039019,  0.66554720,  1.91774106,  3.18089124,  0.00000070,
 0.00001152, -0.00000795, -0.00000058, -0.00003502, -0.00001508, -0.00004225, -0.00002165, -1.00000000,  0.00004391,  1.00000000,
-1.00000000,  0.00001784,  1.00000000, -1.00000000, -0.00003678,  1.00000000, -0.68878314, -0.00013166,  0.60880149, -0.75291978,
 0.00006493,  1.00000000, -0.76757316,  0.00003057,  0.67140524, -0.61602267, -0.00014495,  0.63625803,  2.00000000, -2.00000000,
-0.61253314, -0.00116483,  0.65071851,  2.00000000, -3.00000000, -1.71451667, -0.67799909, -0.00048294,  0.65846019,  2.00000000,
-3.02497593, -1.83515395, -0.70317981,  0.00519701,  0.67780009,  1.84218153,  2.88846262,  4.00000000,  0.00001124,  0.00000588,
-0.00000172,  0.00002835,  1.00000000,  0.00001012, -0.00008644,  1.00000000, -0.75115901,  0.00004347,  1.00000000, -1.00000000,
 0.00002800,  1.00000000, -1.00000000, -0.00006039,  1.00000000, -0.79763258, -0.00011907,  0.71713616, -0.76791870, -0.00007113,
 0.63583609, -0.62337806,  0.00012891,  0.62242094, -0.60837055,  0.00043216,  0.65515705, -0.63637782, -0.00019749,  0.60423967,
 2.00000000, -2.00000000, -0.65404827, -0.00089304,  0.64706660,  2.00000000, -1.86334076, -0.66410366,  0.00063219,  0.66968004,
 2.00000000,  3.00000000,  4.00000000, -4.00000000, -3.00000000, -1.79048834, -0.69451890,  0.00030677,  0.71009333,  1.70591343,
 3.00000000,  4.00000000, -4.00000000, -2.90176499, -1.78368781, -0.74425178,  0.00234068,  0.74847325,  1.78886822,  2.78478854,
 3.83608985,  4.95996151,  0.00002170,  0.00001281,  0.00002162, -1.00000000, -0.00007266,  1.00000000, -1.00000000, -0.00003250,
-0.64088804,  0.00015239,  1.00000000, -0.58450370, -0.00008410,  0.60567186, -1.00000000, -0.00010752,  1.00000000, -0.58922508,
-0.00017378,  0.60755779, -0.62797206, -0.00001016,  0.64432847, -0.58497934, -0.00001851,  0.59716791, -0.62642499, -0.00097386,
 0.63568558,  2.00000000, -2.00000000, -0.63236390, -0.00173361,  0.63142762,  1.75629192, -3.00000000, -2.00000000, -0.65596684,
 0.00209364,  0.65419742,  2.00000000, -3.00000000, -1.73856625, -0.67767521, -0.00119512,  0.68973603,  1.70985573,  3.00000000,
-3.00000000, -1.81820220, -0.73974134,  0.00695869,  0.72216179,  1.75624461,  3.00000000,  4.00000000, -5.00000000, -4.00000000,
-3.17718593, -1.76857567, -0.76822322,  0.00267400,  0.76414602,  1.84309221,  3.04940652,  4.00000000, -7.08189123, -6.00000000,
-5.22882249, -3.96477958, -2.79653492, -1.81923435, -0.80050253, -0.01086663,  0.82708565,  1.85804900,  2.89996354,  3.76028554,
 4.80518081,  5.81738096,  7.00000000,  8.00000000,  9.08816091, -0.00002979, -0.00000333, -1.00000000, -0.00011532,  1.00000000,
-0.70921122, -0.00005325,  0.68933188, -0.67581263, -0.00023107,  0.57868212, -0.58388312, -0.00020850,  0.60149012, -0.60912457,
 0.00001567,  0.60180554, -0.59130091, -0.00038863,  0.59908653, -2.00000000, -0.63697707,  0.00083913,  0.62040514,  2.00000000,
-2.00000000, -0.63216238, -0.00081100,  0.64411071,  2.00000000, -1.76856259, -0.65266989, -0.00243486,  0.66888899,  2.00000000,
-1.75427214, -0.71415385, -0.00226376,  0.71296778,  1.66182947,  3.00000000, -3.00000000, -1.72505821, -0.72920134, -0.00360424,
 0.73800767,  1.72848281,  3.00000000, -4.00000000, -2.95284408, -1.72025758, -0.76503859,  0.00418761,  0.75297139,  1.73959808,
 3.00000000, -5.00000000, -3.96232791, -2.74080544, -1.78897123, -0.80233505, -0.00002050,  0.79693417,  1.76182598,  2.78434458,
 3.85693287,  5.00000000, -6.00000000, -4.78439284, -3.83501790, -2.85203629, -1.84909573, -0.85382658, -0.00181019,  0.84735145,
 1.83676575,  2.83656843,  3.86722376,  4.79702431,  6.00000000, -9.00000000, -8.00000000, -7.00000000, -6.07957292, -4.84677515,
-3.85093972, -2.88683139, -1.84596391, -0.88058034, -0.00008692,  0.87554746,  1.86933183,  2.84729990,  3.89029797,  4.87311773,
 5.90844023,  7.00000000, -11.00000000, -9.97745420, -8.90015761, -7.94187517, -6.86987726, -5.84795335, -4.86693435, -3.90601819,
-2.91031804, -1.91620096, -0.90497055,  0.00659199,  0.90926869,  1.90980821,  2.91070850,  3.93685967,  4.85581177,  6.06727337,
 7.05801043,  8.00000000,  9.00000000,  10.00000000,  10.90825787,  12.00000000,  13.00000000,  14.00000000, -0.00008918,  1.00000000,
-0.54405938,  0.00120348,  0.55781920, -0.59227786, -0.00349602,  0.59777231, -1.63717598, -0.69048065,  0.00999281,  0.65770558,
 2.00000000, -2.00000000, -0.71013571,  0.00454518,  0.66991065, -3.00000000, -1.73004867, -0.73743921,  0.01162454,  0.69964842,
 1.83319587, -1.81225491, -0.76806000,  0.00164742,  0.76780397,  1.67168896, -1.64564794, -0.79903361, -0.01522880,  0.84277926,
 1.68873752, -3.00000000, -1.72063244, -0.83687428,  0.00246724,  0.84618697,  1.79464483,  2.77447025, -3.77118426, -2.75025539,
-1.82050448, -0.90373722, -0.00187780,  0.90102245,  1.85249394,  2.71364180, -2.71720889, -1.79466125, -0.89860801, -0.02725825,
 0.90877329,  1.90542096,  2.76847902,  3.71496428, -4.70257302, -3.90746659, -2.87078421, -1.88858709, -0.93608993, -0.02157425,
 0.95181182,  1.91155682,  2.83614575,  3.87820801,  4.72172277, -5.02764544, -3.80066801, -2.87484378, -1.90707477, -0.96326017,
-0.01060091,  0.96558851,  1.92191548,  2.86970759,  3.85655474,  4.83135970,  5.76387469, -9.00000000, -8.00000000, -6.75261776,
-5.86333393, -4.84846871, -3.91871758, -2.93827286, -1.93050320, -0.96359634, -0.00141931,  0.95926312,  1.92541870,  2.93009411,
 3.86699087,  4.82315929,  5.67815206, -8.76594345, -7.70350451, -6.91784020, -5.81539490, -4.92526872, -3.91513203, -2.92134949,
-1.95465646, -0.97638102, -0.00742564,  0.96948714,  1.96401112,  2.95256722,  3.93146353,  4.90991357,  5.88139022,  6.88640588,
 7.82610489,  9.00000000, -10.97611369, -9.80036760, -8.91109518, -7.92809404, -6.93865353, -5.91965899, -4.92957669, -3.95206224,
-2.97308718, -1.97778214, -0.98552568, -0.00063212,  0.98686014,  1.97511867,  2.97114218,  3.97854244,  4.96578513,  5.96457765,
 6.95180187,  7.95163483,  8.93760897,  9.87666900,  10.88024562,  11.96270158,  12.99519291, -15.00000000, -13.76826291, -12.97229116,
-12.00334834, -10.95980884, -9.98190891, -8.93798503, -7.95621309, -6.96109479, -5.96056649, -4.95843419, -3.97688640, -2.98989576,
-1.98533395, -0.99580972,  0.00694370,  0.99421120,  1.99033132,  2.98751217,  3.98549580,  4.96482394,  5.96623233,  6.93564626,
 7.93772467,  8.92015276,  9.88785129,  10.97606096,  11.79686057, -23.00000000, -22.00000000, -21.00000000, -20.00000000, -19.00000000,
-17.73310977, -16.83574096, -15.90889480, -15.00437366, -13.95007272, -12.99296117, -11.98334751, -10.96970820, -9.97775151, -8.98193840,
-7.98378966, -6.98887770, -5.99059477, -5.00228769, -3.99355850, -2.99947486, -1.99897483, -0.99375857,  0.00324880,  1.00215912,
 1.99277083,  3.00503747,  3.99390482,  4.98854283,  5.98753219,  6.98245347,  7.98089893,  8.95960522,  9.95663648,  11.00810285,
 12.01421617,  12.96208687,  13.99227766,  14.97230040,  15.95114804,  16.97347393,  17.97794884,  18.96777118,  19.94446034,  20.94799029,
 22.14740083,  22.84288347,  23.99212109,  25.00000000,  25.96562658};

/* cdf tables for quantizer indices */
const WebRtc_UWord16 WebRtcIsac_kQKltCdfGain[1212] = {
 0,  13,  301,  3730,  61784,  65167,  65489,  65535,  0,  17,
 142,  314,  929,  2466,  7678,  56450,  63463,  64740,  65204,  65426,
 65527,  65535,  0,  8,  100,  724,  6301,  60105,  65125,  65510,
 65531,  65535,  0,  13,  117,  368,  1068,  3010,  11928,  53603,
 61177,  63404,  64505,  65108,  65422,  65502,  65531,  65535,  0,  4,
 17,  96,  410,  1859,  12125,  54361,  64103,  65305,  65497,  65535,
 0,  4,  88,  230,  469,  950,  1746,  3228,  6092,  16592,
 44756,  56848,  61256,  63308,  64325,  64920,  65309,  65460,  65502,  65522,
 65535,  0,  88,  352,  1675,  6339,  20749,  46686,  59284,  63525,
 64949,  65359,  65502,  65527,  65535,  0,  13,  38,  63,  117,
 234,  381,  641,  929,  1407,  2043,  2809,  4032,  5753,  8792,
 14407,  24308,  38941,  48947,  55403,  59293,  61411,  62688,  63630,  64329,
 64840,  65188,  65376,  65472,  65506,  65527,  65531,  65535,  0,  8,
 29,  75,  222,  615,  1327,  2801,  5623,  9931,  16094,  24966,
 34419,  43458,  50676,  56186,  60055,  62500,  63936,  64765,  65225,  65435,
 65514,  65535,  0,  8,  13,  15,  17,  21,  33,  59,
 71,  92,  151,  243,  360,  456,  674,  934,  1223,  1583,
 1989,  2504,  3031,  3617,  4354,  5154,  6163,  7411,  8780,  10747,
 12874,  15591,  18974,  23027,  27436,  32020,  36948,  41830,  46205,  49797,
 53042,  56094,  58418,  60360,  61763,  62818,  63559,  64103,  64509,  64798,
 65045,  65162,  65288,  65363,  65447,  65506,  65522,  65531,  65533,  65535,
 0,  4,  6,  25,  38,  71,  138,  264,  519,  808,
 1227,  1825,  2516,  3408,  4279,  5560,  7092,  9197,  11420,  14108,
 16947,  20300,  23926,  27459,  31164,  34827,  38575,  42178,  45540,  48747,
 51444,  54090,  56426,  58460,  60080,  61595,  62734,  63668,  64275,  64673,
 64936,  65112,  65217,  65334,  65426,  65464,  65477,  65489,  65518,  65527,
 65529,  65531,  65533,  65535,  0,  2,  4,  8,  10,  12,
 14,  16,  21,  33,  50,  71,  84,  92,  105,  138,
 180,  255,  318,  377,  435,  473,  511,  590,  682,  758,
 913,  1097,  1256,  1449,  1671,  1884,  2169,  2445,  2772,  3157,
 3563,  3944,  4375,  4848,  5334,  5820,  6448,  7101,  7716,  8378,
 9102,  9956,  10752,  11648,  12707,  13670,  14758,  15910,  17187,  18472,
 19627,  20649,  21951,  23169,  24283,  25552,  26862,  28227,  29391,  30764,
 31882,  33213,  34432,  35600,  36910,  38116,  39464,  40729,  41872,  43144,
 44371,  45514,  46762,  47813,  48968,  50069,  51032,  51974,  52908,  53737,
 54603,  55445,  56282,  56990,  57572,  58191,  58840,  59410,  59887,  60264,
 60607,  60946,  61269,  61516,  61771,  61960,  62198,  62408,  62558,  62776,
 62985,  63207,  63408,  63546,  63739,  63906,  64070,  64237,  64371,  64551,
 64677,  64836,  64999,  65095,  65213,  65284,  65338,  65380,  65426,  65447,
 65472,  65485,  65487,  65489,  65502,  65510,  65512,  65514,  65516,  65518,
 65522,  65531,  65533,  65535,  0,  2,  4,  6,  65528,  65531,
 65533,  65535,  0,  2,  4,  6,  8,  10,  222,  65321,
 65513,  65528,  65531,  65533,  65535,  0,  2,  4,  50,  65476,
 65529,  65531,  65533,  65535,  0,  2,  4,  6,  8,  12,
 38,  544,  64936,  65509,  65523,  65525,  65529,  65531,  65533,  65535,
 0,  2,  4,  6,  8,  10,  1055,  64508,  65528,  65531,
 65533,  65535,  0,  2,  4,  6,  8,  10,  12,  123,
 3956,  62999,  65372,  65495,  65515,  65521,  65523,  65525,  65527,  65529,
 65531,  65533,  65535,  0,  2,  4,  12,  53,  4707,  59445,
 65467,  65525,  65527,  65529,  65531,  65533,  65535,  0,  2,  4,
 6,  8,  10,  12,  14,  16,  38,  40,  50,  67,
 96,  234,  929,  14345,  55750,  64866,  65389,  65462,  65514,  65517,
 65519,  65521,  65523,  65525,  65527,  65529,  65531,  65533,  65535,  0,
 2,  4,  6,  8,  10,  15,  35,  91,  377,  1946,
 13618,  52565,  63714,  65184,  65465,  65520,  65523,  65525,  65527,  65529,
 65531,  65533,  65535,  0,  2,  4,  6,  8,  10,  12,
 14,  16,  18,  20,  22,  24,  26,  28,  30,  32,
 34,  36,  38,  40,  42,  44,  46,  48,  50,  52,
 54,  82,  149,  362,  751,  1701,  4239,  12893,  38627,  55072,
 60875,  63071,  64158,  64702,  65096,  65283,  65412,  65473,  65494,  65505,
 65508,  65517,  65519,  65521,  65523,  65525,  65527,  65529,  65531,  65533,
 65535,  0,  2,  15,  23,  53,  143,  260,  418,  698,
 988,  1353,  1812,  2411,  3144,  4015,  5143,  6401,  7611,  8999,
 10653,  12512,  14636,  16865,  19404,  22154,  24798,  27521,  30326,  33102,
 35790,  38603,  41415,  43968,  46771,  49435,  52152,  54715,  57143,  59481,
 61178,  62507,  63603,  64489,  64997,  65257,  65427,  65473,  65503,  65520,
 65529,  65531,  65533,  65535,  0,  3,  6,  9,  26,  32,
 44,  46,  64,  94,  111,  164,  205,  254,  327,  409,
 506,  608,  733,  885,  1093,  1292,  1482,  1742,  1993,  2329,
 2615,  3029,  3374,  3798,  4257,  4870,  5405,  5992,  6618,  7225,
 7816,  8418,  9051,  9761,  10532,  11380,  12113,  13010,  13788,  14594,
 15455,  16361,  17182,  18088,  18997,  20046,  20951,  21968,  22947,  24124,
 25296,  26547,  27712,  28775,  29807,  30835,  31709,  32469,  33201,  34014,
 34876,  35773,  36696,  37620,  38558,  39547,  40406,  41277,  42367,  43290,
 44445,  45443,  46510,  47684,  48973,  50157,  51187,  52242,  53209,  54083,
 55006,  55871,  56618,  57293,  57965,  58556,  59222,  59722,  60180,  60554,
 60902,  61250,  61554,  61837,  62100,  62372,  62631,  62856,  63078,  63324,
 63557,  63768,  63961,  64089,  64235,  64352,  64501,  64633,  64770,  64887,
 65001,  65059,  65121,  65188,  65246,  65302,  65346,  65390,  65428,  65463,
 65477,  65506,  65515,  65517,  65519,  65521,  65523,  65525,  65527,  65529,
 65531,  65533,  65535,  0,  2,  4,  109,  65332,  65531,  65533,
 65535,  0,  2,  4,  6,  8,  25,  1817,  63874,  65511,
 65527,  65529,  65531,  65533,  65535,  0,  2,  4,  907,  65014,
 65529,  65531,  65533,  65535,  0,  2,  4,  6,  8,  10,
 12,  132,  2743,  62708,  65430,  65525,  65527,  65529,  65531,  65533,
 65535,  0,  2,  4,  6,  8,  35,  3743,  61666,  65485,
 65531,  65533,  65535,  0,  2,  4,  6,  8,  10,  23,
 109,  683,  6905,  58417,  64911,  65398,  65497,  65518,  65525,  65527,
 65529,  65531,  65533,  65535,  0,  2,  4,  6,  53,  510,
 10209,  55212,  64573,  65441,  65522,  65529,  65531,  65533,  65535,  0,
 2,  4,  6,  8,  10,  12,  14,  16,  18,  20,
 22,  32,  90,  266,  1037,  3349,  14468,  50488,  62394,  64685,
 65341,  65480,  65514,  65519,  65521,  65523,  65525,  65527,  65529,  65531,
 65533,  65535,  0,  2,  4,  6,  9,  16,  37,  106,
 296,  748,  1868,  5733,  18897,  45553,  60165,  63949,  64926,  65314,
 65441,  65508,  65524,  65529,  65531,  65533,  65535,  0,  2,  4,
 6,  8,  10,  12,  14,  16,  18,  20,  22,  24,
 26,  28,  30,  32,  34,  36,  38,  40,  42,  44,
 46,  48,  50,  83,  175,  344,  667,  1293,  2337,  4357,
 8033,  14988,  28600,  43244,  52011,  57042,  59980,  61779,  63065,  63869,
 64390,  64753,  64988,  65164,  65326,  65422,  65462,  65492,  65506,  65522,
 65524,  65526,  65531,  65533,  65535,  0,  2,  4,  6,  8,
 10,  12,  14,  16,  25,  39,  48,  55,  62,  65,
 85,  106,  139,  169,  194,  252,  323,  485,  688,  1074,
 1600,  2544,  3863,  5733,  8303,  11397,  15529,  20273,  25734,  31455,
 36853,  41891,  46410,  50306,  53702,  56503,  58673,  60479,  61880,  62989,
 63748,  64404,  64852,  65124,  65309,  65424,  65480,  65524,  65528,  65533,
 65535,  0,  2,  4,  6,  8,  10,  12,  14,  21,
 23,  25,  27,  29,  31,  39,  41,  43,  48,  60,
 72,  79,  106,  136,  166,  187,  224,  252,  323,  381,
 427,  478,  568,  660,  783,  912,  1046,  1175,  1365,  1567,
 1768,  2024,  2347,  2659,  3049,  3529,  4033,  4623,  5281,  5925,
 6726,  7526,  8417,  9468,  10783,  12141,  13571,  15222,  16916,  18659,
 20350,  22020,  23725,  25497,  27201,  29026,  30867,  32632,  34323,  36062,
 37829,  39466,  41144,  42654,  43981,  45343,  46579,  47759,  49013,  50171,
 51249,  52283,  53245,  54148,  54938,  55669,  56421,  57109,  57791,  58464,
 59092,  59674,  60105,  60653,  61083,  61407,  61757,  62095,  62388,  62649,
 62873,  63157,  63358,  63540,  63725,  63884,  64046,  64155,  64278,  64426,
 64548,  64654,  64806,  64906,  64994,  65077,  65137,  65215,  65277,  65324,
 65354,  65409,  65437,  65455,  65462,  65490,  65495,  65499,  65508,  65511,
 65513,  65515,  65517,  65519,  65521,  65523,  65525,  65527,  65529,  65531,
 65533,  65535};

const WebRtc_UWord16 WebRtcIsac_kQKltCdfShape[2059] = {
 0,  65535,  0,  65535,  0,  65535,  0,  65535,  0,  65535,
 0,  65535,  0,  65535,  0,  65535,  0,  65535,  0,  4,
 65535,  0,  8,  65514,  65535,  0,  29,  65481,  65535,  0,
 121,  65439,  65535,  0,  239,  65284,  65535,  0,  8,  779,
 64999,  65527,  65535,  0,  8,  888,  64693,  65522,  65535,  0,
 29,  2604,  62843,  65497,  65531,  65535,  0,  25,  176,  4576,
 61164,  65275,  65527,  65535,  0,  65535,  0,  65535,  0,  65535,
 0,  65535,  0,  4,  65535,  0,  65535,  0,  65535,  0,
 65535,  0,  65535,  0,  4,  65535,  0,  33,  65502,  65535,
 0,  54,  65481,  65535,  0,  251,  65309,  65535,  0,  611,
 65074,  65535,  0,  1273,  64292,  65527,  65535,  0,  4,  1809,
 63940,  65518,  65535,  0,  88,  4392,  60603,  65426,  65531,  65535,
 0,  25,  419,  7046,  57756,  64961,  65514,  65531,  65535,  0,
 65535,  0,  65535,  0,  65535,  0,  65535,  0,  4,  65531,
 65535,  0,  65535,  0,  8,  65531,  65535,  0,  4,  65527,
 65535,  0,  17,  65510,  65535,  0,  42,  65481,  65535,  0,
 197,  65342,  65531,  65535,  0,  385,  65154,  65535,  0,  1005,
 64522,  65535,  0,  8,  1985,  63469,  65533,  65535,  0,  38,
 3119,  61884,  65514,  65535,  0,  4,  6,  67,  4961,  60804,
 65472,  65535,  0,  17,  565,  9182,  56538,  65087,  65514,  65535,
 0,  8,  63,  327,  2118,  14490,  52774,  63839,  65376,  65522,
 65535,  0,  65535,  0,  65535,  0,  65535,  0,  65535,  0,
 17,  65522,  65535,  0,  59,  65489,  65535,  0,  50,  65522,
 65535,  0,  54,  65489,  65535,  0,  310,  65179,  65535,  0,
 615,  64836,  65535,  0,  4,  1503,  63965,  65535,  0,  2780,
 63383,  65535,  0,  21,  3919,  61051,  65527,  65535,  0,  84,
 6674,  59929,  65435,  65535,  0,  4,  255,  7976,  55784,  65150,
 65518,  65531,  65535,  0,  4,  8,  582,  10726,  53465,  64949,
 65518,  65535,  0,  29,  339,  3006,  17555,  49517,  62956,  65200,
 65497,  65531,  65535,  0,  2,  33,  138,  565,  2324,  7670,
 22089,  45966,  58949,  63479,  64966,  65380,  65518,  65535,  0,  65535,
 0,  65535,  0,  2,  65533,  65535,  0,  46,  65514,  65535,
 0,  414,  65091,  65535,  0,  540,  64911,  65535,  0,  419,
 65162,  65535,  0,  976,  64790,  65535,  0,  2977,  62495,  65531,
 65535,  0,  4,  3852,  61034,  65527,  65535,  0,  4,  29,
 6021,  60243,  65468,  65535,  0,  84,  6711,  58066,  65418,  65535,
 0,  13,  281,  9550,  54917,  65125,  65506,  65535,  0,  2,
 63,  984,  12108,  52644,  64342,  65435,  65527,  65535,  0,  29,
 251,  2014,  14871,  47553,  62881,  65229,  65518,  65535,  0,  13,
 142,  749,  4220,  18497,  45200,  60913,  64823,  65426,  65527,  65535,
 0,  13,  71,  264,  1176,  3789,  10500,  24480,  43488,  56324,
 62315,  64493,  65242,  65464,  65514,  65522,  65531,  65535,  0,  4,
 13,  38,  109,  205,  448,  850,  1708,  3429,  6276,  11371,
 19221,  29734,  40955,  49391,  55411,  59460,  62102,  63793,  64656,  65150,
 65401,  65485,  65522,  65531,  65535,  0,  65535,  0,  2,  65533,
 65535,  0,  1160,  65476,  65535,  0,  2,  6640,  64763,  65533,
 65535,  0,  2,  38,  9923,  61009,  65527,  65535,  0,  2,
 4949,  63092,  65533,  65535,  0,  2,  3090,  63398,  65533,  65535,
 0,  2,  2520,  58744,  65510,  65535,  0,  2,  13,  544,
 8784,  51403,  65148,  65533,  65535,  0,  2,  25,  1017,  10412,
 43550,  63651,  65489,  65527,  65535,  0,  2,  4,  29,  783,
 13377,  52462,  64524,  65495,  65533,  65535,  0,  2,  4,  6,
 100,  1817,  18451,  52590,  63559,  65376,  65531,  65535,  0,  2,
 4,  6,  46,  385,  2562,  11225,  37416,  60488,  65026,  65487,
 65529,  65533,  65535,  0,  2,  4,  6,  8,  10,  12,
 42,  222,  971,  5221,  19811,  45048,  60312,  64486,  65294,  65474,
 65525,  65529,  65533,  65535,  0,  2,  4,  8,  71,  167,
 666,  2533,  7875,  19622,  38082,  54359,  62108,  64633,  65290,  65495,
 65529,  65533,  65535,  0,  2,  4,  6,  8,  10,  13,
 109,  586,  1930,  4949,  11600,  22641,  36125,  48312,  56899,  61495,
 63927,  64932,  65389,  65489,  65518,  65531,  65533,  65535,  0,  4,
 6,  8,  67,  209,  712,  1838,  4195,  8432,  14432,  22834,
 31723,  40523,  48139,  53929,  57865,  60657,  62403,  63584,  64363,  64907,
 65167,  65372,  65472,  65514,  65535,  0,  2,  4,  13,  25,
 42,  46,  50,  75,  113,  147,  281,  448,  657,  909,
 1185,  1591,  1976,  2600,  3676,  5317,  7398,  9914,  12941,  16169,
 19477,  22885,  26464,  29851,  33360,  37228,  41139,  44802,  48654,  52058,
 55181,  57676,  59581,  61022,  62190,  63107,  63676,  64199,  64547,  64924,
 65158,  65313,  65430,  65481,  65518,  65535,  0,  65535,  0,  65535,
 0,  65535,  0,  65535,  0,  65533,  65535,  0,  65535,  0,
 65535,  0,  65535,  0,  65533,  65535,  0,  2,  65535,  0,
 2,  65533,  65535,  0,  2,  65533,  65535,  0,  2,  65533,
 65535,  0,  2,  4,  65533,  65535,  0,  2,  65533,  65535,
 0,  2,  4,  65531,  65533,  65535,  0,  2,  4,  65531,
 65533,  65535,  0,  2,  4,  6,  65524,  65533,  65535,  0,
 65535,  0,  65535,  0,  65535,  0,  65535,  0,  65535,  0,
 65535,  0,  65535,  0,  65535,  0,  65533,  65535,  0,  65533,
 65535,  0,  2,  65533,  65535,  0,  2,  65533,  65535,  0,
 2,  65533,  65535,  0,  2,  4,  65532,  65535,  0,  6,
 65523,  65535,  0,  2,  15,  65530,  65533,  65535,  0,  2,
 35,  65493,  65531,  65533,  65535,  0,  2,  4,  158,  65382,
 65531,  65533,  65535,  0,  65535,  0,  65535,  0,  65535,  0,
 65535,  0,  65535,  0,  65535,  0,  2,  65535,  0,  2,
 65533,  65535,  0,  2,  65533,  65535,  0,  2,  65533,  65535,
 0,  2,  65533,  65535,  0,  9,  65512,  65535,  0,  2,
 12,  65529,  65535,  0,  2,  73,  65434,  65533,  65535,  0,
 2,  240,  65343,  65533,  65535,  0,  2,  476,  65017,  65531,
 65533,  65535,  0,  2,  4,  1046,  64686,  65531,  65533,  65535,
 0,  2,  4,  6,  8,  1870,  63898,  65529,  65531,  65533,
 65535,  0,  65535,  0,  65535,  0,  65535,  0,  65533,  65535,
 0,  2,  65533,  65535,  0,  2,  65533,  65535,  0,  2,
 65532,  65535,  0,  6,  65533,  65535,  0,  6,  65523,  65535,
 0,  2,  65532,  65535,  0,  137,  65439,  65535,  0,  576,
 64899,  65533,  65535,  0,  2,  289,  65299,  65533,  65535,  0,
 2,  4,  6,  880,  64134,  65531,  65533,  65535,  0,  2,
 4,  1853,  63347,  65533,  65535,  0,  2,  6,  2516,  61762,
 65529,  65531,  65533,  65535,  0,  2,  4,  9,  3980,  61380,
 65503,  65529,  65531,  65533,  65535,  0,  2,  4,  6,  8,
 10,  12,  61,  6393,  59859,  65466,  65527,  65529,  65531,  65533,
 65535,  0,  65535,  0,  65535,  0,  65535,  0,  2,  65532,
 65535,  0,  3,  65529,  65535,  0,  2,  65529,  65535,  0,
 61,  65453,  65535,  0,  234,  65313,  65535,  0,  503,  65138,
 65535,  0,  155,  65402,  65533,  65535,  0,  2,  1058,  64554,
 65533,  65535,  0,  2,  4,  3138,  62109,  65531,  65533,  65535,
 0,  2,  4,  2031,  63339,  65531,  65533,  65535,  0,  2,
 4,  6,  9,  4155,  60778,  65523,  65529,  65531,  65533,  65535,
 0,  2,  4,  41,  6189,  59269,  65490,  65531,  65533,  65535,
 0,  2,  4,  6,  210,  8789,  57043,  65400,  65528,  65531,
 65533,  65535,  0,  2,  4,  6,  8,  26,  453,  10086,
 55499,  64948,  65483,  65524,  65527,  65529,  65531,  65533,  65535,  0,
 2,  4,  6,  8,  10,  12,  14,  16,  18,  20,
 114,  1014,  11202,  52670,  64226,  65356,  65503,  65514,  65523,  65525,
 65527,  65529,  65531,  65533,  65535,  0,  65533,  65535,  0,  15,
 65301,  65535,  0,  152,  64807,  65535,  0,  2,  3328,  63308,
 65535,  0,  2,  4050,  59730,  65533,  65535,  0,  2,  164,
 10564,  61894,  65529,  65535,  0,  15,  6712,  59831,  65076,  65532,
 65535,  0,  32,  7712,  57449,  65459,  65535,  0,  2,  210,
 7849,  53110,  65021,  65523,  65535,  0,  2,  12,  1081,  13883,
 48262,  62870,  65477,  65535,  0,  2,  88,  847,  6145,  37852,
 62012,  65454,  65533,  65535,  0,  9,  47,  207,  1823,  14522,
 45521,  61069,  64891,  65481,  65528,  65531,  65533,  65535,  0,  2,
 9,  488,  2881,  12758,  38703,  58412,  64420,  65410,  65533,  65535,
 0,  2,  4,  6,  61,  333,  1891,  6486,  19720,  43188,
 57547,  62472,  64796,  65421,  65497,  65523,  65529,  65531,  65533,  65535,
 0,  2,  4,  6,  8,  10,  12,  29,  117,  447,
 1528,  6138,  21242,  43133,  56495,  62432,  64746,  65362,  65500,  65529,
 65531,  65533,  65535,  0,  2,  18,  105,  301,  760,  1490,
 3472,  7568,  15002,  26424,  40330,  53029,  60048,  62964,  64274,  64890,
 65337,  65445,  65489,  65513,  65527,  65530,  65533,  65535,  0,  2,
 4,  6,  41,  102,  409,  853,  2031,  4316,  7302,  11328,
 16869,  24825,  34926,  43481,  50877,  56126,  59874,  62103,  63281,  63857,
 64166,  64675,  65382,  65522,  65531,  65533,  65535,  0,  2,  4,
 6,  8,  10,  12,  14,  16,  18,  29,  38,  53,
 58,  96,  181,  503,  1183,  2849,  5590,  8600,  11379,  13942,
 16478,  19453,  22638,  26039,  29411,  32921,  37596,  41433,  44998,  48560,
 51979,  55106,  57666,  59892,  61485,  62616,  63484,  64018,  64375,  64685,
 64924,  65076,  65278,  65395,  65471,  65509,  65529,  65535,  0,  65535,
 0,  65535,  0,  65535,  0,  65535,  0,  65535,  0,  65535,
 0,  65535,  0,  65535,  0,  2,  65533,  65535,  0,  2,
 65533,  65535,  0,  2,  65533,  65535,  0,  2,  65533,  65535,
 0,  2,  65533,  65535,  0,  2,  65533,  65535,  0,  7,
 65519,  65535,  0,  2,  14,  65491,  65533,  65535,  0,  2,
 81,  65427,  65531,  65533,  65535,  0,  2,  4,  312,  65293,
 65528,  65533,  65535,  0,  65535,  0,  65535,  0,  65535,  0,
 65535,  0,  65535,  0,  65535,  0,  65535,  0,  65535,  0,
 2,  65533,  65535,  0,  2,  65533,  65535,  0,  2,  65533,
 65535,  0,  5,  65523,  65535,  0,  2,  65533,  65535,  0,
 7,  65526,  65535,  0,  46,  65464,  65533,  65535,  0,  2,
 120,  65309,  65533,  65535,  0,  2,  5,  362,  65097,  65533,
 65535,  0,  2,  18,  1164,  64785,  65528,  65531,  65533,  65535,
 0,  65535,  0,  65535,  0,  65535,  0,  65533,  65535,  0,
 65535,  0,  65533,  65535,  0,  2,  65533,  65535,  0,  2,
 65533,  65535,  0,  2,  65533,  65535,  0,  2,  65530,  65535,
 0,  2,  65523,  65535,  0,  69,  65477,  65535,  0,  141,
 65459,  65535,  0,  194,  65325,  65533,  65535,  0,  2,  543,
 64912,  65533,  65535,  0,  5,  1270,  64301,  65529,  65531,  65533,
 65535,  0,  2,  4,  12,  2055,  63538,  65508,  65531,  65533,
 65535,  0,  2,  7,  102,  3775,  61970,  65429,  65526,  65528,
 65533,  65535,  0,  65535,  0,  65535,  0,  65535,  0,  2,
 65533,  65535,  0,  2,  65535,  0,  9,  65533,  65535,  0,
 25,  65512,  65535,  0,  2,  65533,  65535,  0,  44,  65480,
 65535,  0,  48,  65475,  65535,  0,  162,  65373,  65535,  0,
 637,  64806,  65533,  65535,  0,  2,  935,  64445,  65533,  65535,
 0,  2,  4,  1662,  64083,  65533,  65535,  0,  2,  12,
 3036,  62469,  65521,  65533,  65535,  0,  2,  120,  5405,  60468,
 65469,  65531,  65533,  65535,  0,  2,  4,  18,  254,  6663,
 58999,  65272,  65528,  65533,  65535,  0,  2,  4,  9,  12,
 67,  591,  8981,  56781,  64564,  65365,  65508,  65524,  65526,  65529,
 65531,  65533,  65535,  0,  65535,  0,  65535,  0,  2,  65533,
 65535,  0,  9,  65526,  65535,  0,  14,  65503,  65535,  0,
 127,  65390,  65535,  0,  517,  64990,  65535,  0,  178,  65330,
 65535,  0,  2,  1055,  64533,  65533,  65535,  0,  2,  1558,
 63942,  65533,  65535,  0,  2,  2205,  63173,  65533,  65535,  0,
 25,  4493,  60862,  65505,  65533,  65535,  0,  2,  48,  5890,
 59442,  65482,  65533,  65535,  0,  2,  4,  127,  7532,  58191,
 65394,  65533,  65535,  0,  2,  5,  32,  550,  10388,  54924,
 65046,  65510,  65531,  65533,  65535,  0,  2,  4,  30,  150,
 1685,  14340,  51375,  63619,  65288,  65503,  65528,  65533,  65535,  0,
 2,  4,  6,  8,  28,  97,  473,  2692,  15407,  50020,
 62880,  65064,  65445,  65508,  65531,  65533,  65535,  0,  2,  4,
 12,  32,  79,  150,  372,  907,  2184,  5868,  18207,  45431,
 59856,  64031,  65096,  65401,  65481,  65507,  65521,  65523,  65525,  65527,
 65529,  65531,  65533,  65535,  0,  65533,  65535,  0,  182,  65491,
 65535,  0,  877,  64286,  65535,  0,  9,  2708,  63612,  65533,
 65535,  0,  2,  6038,  59532,  65535,  0,  2,  92,  5500,
 60539,  65533,  65535,  0,  268,  8908,  56512,  65385,  65535,  0,
 129,  13110,  52742,  65036,  65535,  0,  2,  806,  14003,  51929,
 64732,  65523,  65535,  0,  7,  92,  2667,  18159,  47678,  62610,
 65355,  65535,  0,  32,  1836,  19676,  48237,  61677,  64960,  65526,
 65535,  0,  21,  159,  967,  5668,  22782,  44709,  58317,  64020,
 65406,  65528,  65535,  0,  7,  162,  1838,  8328,  23929,  43014,
 56394,  63374,  65216,  65484,  65521,  65535,  0,  2,  4,  6,
 28,  268,  1120,  3613,  10688,  24185,  40989,  54917,  61684,  64510,
 65403,  65530,  65535,  0,  2,  16,  44,  139,  492,  1739,
 5313,  13558,  26766,  41566,  52446,  58937,  62815,  64480,  65201,  65454,
 65524,  65533,  65535,  0,  7,  25,  76,  263,  612,  1466,
 3325,  6832,  12366,  20152,  29466,  39255,  47360,  53506,  57740,  60726,
 62845,  64131,  64882,  65260,  65459,  65521,  65528,  65530,  65535,  0,
 2,  4,  14,  48,  136,  312,  653,  1240,  2369,  4327,
 7028,  10759,  15449,  21235,  28027,  35386,  42938,  49562,  54990,  59119,
 62086,  63916,  64863,  65249,  65445,  65493,  65523,  65535,  0,  2,
 4,  6,  8,  10,  12,  21,  83,  208,  409,  723,
 1152,  1868,  2951,  4463,  6460,  8979,  11831,  15195,  18863,  22657,
 26762,  30881,  34963,  39098,  43054,  47069,  50620,  53871,  56821,  59386,
 61340,  62670,  63512,  64023,  64429,  64750,  64944,  65126,  65279,  65366,
 65413,  65445,  65473,  65505,  65510,  65521,  65528,  65530,  65535};

/* pointers to cdf tables for quantizer indices */
const WebRtc_UWord16 *WebRtcIsac_kQKltCdfPtrGain[3][12] = {
{WebRtcIsac_kQKltCdfGain +0 +0, WebRtcIsac_kQKltCdfGain +0 +8, WebRtcIsac_kQKltCdfGain +0 +22, WebRtcIsac_kQKltCdfGain +0 +32, WebRtcIsac_kQKltCdfGain +0 +48, WebRtcIsac_kQKltCdfGain +0 +60, WebRtcIsac_kQKltCdfGain +0 +81, WebRtcIsac_kQKltCdfGain +0 +95, WebRtcIsac_kQKltCdfGain +0 +128, WebRtcIsac_kQKltCdfGain +0 +152,
WebRtcIsac_kQKltCdfGain +0 +210, WebRtcIsac_kQKltCdfGain +0 +264},
{WebRtcIsac_kQKltCdfGain +404 +0, WebRtcIsac_kQKltCdfGain +404 +8, WebRtcIsac_kQKltCdfGain +404 +21, WebRtcIsac_kQKltCdfGain +404 +30, WebRtcIsac_kQKltCdfGain +404 +46, WebRtcIsac_kQKltCdfGain +404 +58, WebRtcIsac_kQKltCdfGain +404 +79, WebRtcIsac_kQKltCdfGain +404 +93, WebRtcIsac_kQKltCdfGain +404 +125, WebRtcIsac_kQKltCdfGain +404 +149,
WebRtcIsac_kQKltCdfGain +404 +207, WebRtcIsac_kQKltCdfGain +404 +260},
{WebRtcIsac_kQKltCdfGain +803 +0, WebRtcIsac_kQKltCdfGain +803 +8, WebRtcIsac_kQKltCdfGain +803 +22, WebRtcIsac_kQKltCdfGain +803 +31, WebRtcIsac_kQKltCdfGain +803 +48, WebRtcIsac_kQKltCdfGain +803 +60, WebRtcIsac_kQKltCdfGain +803 +81, WebRtcIsac_kQKltCdfGain +803 +96, WebRtcIsac_kQKltCdfGain +803 +129, WebRtcIsac_kQKltCdfGain +803 +154,
WebRtcIsac_kQKltCdfGain +803 +212, WebRtcIsac_kQKltCdfGain +803 +268}};

const WebRtc_UWord16 *WebRtcIsac_kQKltCdfPtrShape[3][108] = {
{WebRtcIsac_kQKltCdfShape +0 +0, WebRtcIsac_kQKltCdfShape +0 +2, WebRtcIsac_kQKltCdfShape +0 +4, WebRtcIsac_kQKltCdfShape +0 +6, WebRtcIsac_kQKltCdfShape +0 +8, WebRtcIsac_kQKltCdfShape +0 +10, WebRtcIsac_kQKltCdfShape +0 +12, WebRtcIsac_kQKltCdfShape +0 +14, WebRtcIsac_kQKltCdfShape +0 +16, WebRtcIsac_kQKltCdfShape +0 +18,
WebRtcIsac_kQKltCdfShape +0 +21, WebRtcIsac_kQKltCdfShape +0 +25, WebRtcIsac_kQKltCdfShape +0 +29, WebRtcIsac_kQKltCdfShape +0 +33, WebRtcIsac_kQKltCdfShape +0 +37, WebRtcIsac_kQKltCdfShape +0 +43, WebRtcIsac_kQKltCdfShape +0 +49, WebRtcIsac_kQKltCdfShape +0 +56, WebRtcIsac_kQKltCdfShape +0 +64, WebRtcIsac_kQKltCdfShape +0 +66,
WebRtcIsac_kQKltCdfShape +0 +68, WebRtcIsac_kQKltCdfShape +0 +70, WebRtcIsac_kQKltCdfShape +0 +72, WebRtcIsac_kQKltCdfShape +0 +75, WebRtcIsac_kQKltCdfShape +0 +77, WebRtcIsac_kQKltCdfShape +0 +79, WebRtcIsac_kQKltCdfShape +0 +81, WebRtcIsac_kQKltCdfShape +0 +83, WebRtcIsac_kQKltCdfShape +0 +86, WebRtcIsac_kQKltCdfShape +0 +90,
WebRtcIsac_kQKltCdfShape +0 +94, WebRtcIsac_kQKltCdfShape +0 +98, WebRtcIsac_kQKltCdfShape +0 +102, WebRtcIsac_kQKltCdfShape +0 +107, WebRtcIsac_kQKltCdfShape +0 +113, WebRtcIsac_kQKltCdfShape +0 +120, WebRtcIsac_kQKltCdfShape +0 +129, WebRtcIsac_kQKltCdfShape +0 +131, WebRtcIsac_kQKltCdfShape +0 +133, WebRtcIsac_kQKltCdfShape +0 +135,
WebRtcIsac_kQKltCdfShape +0 +137, WebRtcIsac_kQKltCdfShape +0 +141, WebRtcIsac_kQKltCdfShape +0 +143, WebRtcIsac_kQKltCdfShape +0 +147, WebRtcIsac_kQKltCdfShape +0 +151, WebRtcIsac_kQKltCdfShape +0 +155, WebRtcIsac_kQKltCdfShape +0 +159, WebRtcIsac_kQKltCdfShape +0 +164, WebRtcIsac_kQKltCdfShape +0 +168, WebRtcIsac_kQKltCdfShape +0 +172,
WebRtcIsac_kQKltCdfShape +0 +178, WebRtcIsac_kQKltCdfShape +0 +184, WebRtcIsac_kQKltCdfShape +0 +192, WebRtcIsac_kQKltCdfShape +0 +200, WebRtcIsac_kQKltCdfShape +0 +211, WebRtcIsac_kQKltCdfShape +0 +213, WebRtcIsac_kQKltCdfShape +0 +215, WebRtcIsac_kQKltCdfShape +0 +217, WebRtcIsac_kQKltCdfShape +0 +219, WebRtcIsac_kQKltCdfShape +0 +223,
WebRtcIsac_kQKltCdfShape +0 +227, WebRtcIsac_kQKltCdfShape +0 +231, WebRtcIsac_kQKltCdfShape +0 +235, WebRtcIsac_kQKltCdfShape +0 +239, WebRtcIsac_kQKltCdfShape +0 +243, WebRtcIsac_kQKltCdfShape +0 +248, WebRtcIsac_kQKltCdfShape +0 +252, WebRtcIsac_kQKltCdfShape +0 +258, WebRtcIsac_kQKltCdfShape +0 +264, WebRtcIsac_kQKltCdfShape +0 +273,
WebRtcIsac_kQKltCdfShape +0 +282, WebRtcIsac_kQKltCdfShape +0 +293, WebRtcIsac_kQKltCdfShape +0 +308, WebRtcIsac_kQKltCdfShape +0 +310, WebRtcIsac_kQKltCdfShape +0 +312, WebRtcIsac_kQKltCdfShape +0 +316, WebRtcIsac_kQKltCdfShape +0 +320, WebRtcIsac_kQKltCdfShape +0 +324, WebRtcIsac_kQKltCdfShape +0 +328, WebRtcIsac_kQKltCdfShape +0 +332,
WebRtcIsac_kQKltCdfShape +0 +336, WebRtcIsac_kQKltCdfShape +0 +341, WebRtcIsac_kQKltCdfShape +0 +347, WebRtcIsac_kQKltCdfShape +0 +354, WebRtcIsac_kQKltCdfShape +0 +360, WebRtcIsac_kQKltCdfShape +0 +368, WebRtcIsac_kQKltCdfShape +0 +378, WebRtcIsac_kQKltCdfShape +0 +388, WebRtcIsac_kQKltCdfShape +0 +400, WebRtcIsac_kQKltCdfShape +0 +418,
WebRtcIsac_kQKltCdfShape +0 +445, WebRtcIsac_kQKltCdfShape +0 +447, WebRtcIsac_kQKltCdfShape +0 +451, WebRtcIsac_kQKltCdfShape +0 +455, WebRtcIsac_kQKltCdfShape +0 +461, WebRtcIsac_kQKltCdfShape +0 +468, WebRtcIsac_kQKltCdfShape +0 +474, WebRtcIsac_kQKltCdfShape +0 +480, WebRtcIsac_kQKltCdfShape +0 +486, WebRtcIsac_kQKltCdfShape +0 +495,
WebRtcIsac_kQKltCdfShape +0 +505, WebRtcIsac_kQKltCdfShape +0 +516, WebRtcIsac_kQKltCdfShape +0 +528, WebRtcIsac_kQKltCdfShape +0 +543, WebRtcIsac_kQKltCdfShape +0 +564, WebRtcIsac_kQKltCdfShape +0 +583, WebRtcIsac_kQKltCdfShape +0 +608, WebRtcIsac_kQKltCdfShape +0 +635},
{WebRtcIsac_kQKltCdfShape +686 +0, WebRtcIsac_kQKltCdfShape +686 +2, WebRtcIsac_kQKltCdfShape +686 +4, WebRtcIsac_kQKltCdfShape +686 +6, WebRtcIsac_kQKltCdfShape +686 +8, WebRtcIsac_kQKltCdfShape +686 +11, WebRtcIsac_kQKltCdfShape +686 +13, WebRtcIsac_kQKltCdfShape +686 +15, WebRtcIsac_kQKltCdfShape +686 +17, WebRtcIsac_kQKltCdfShape +686 +20,
WebRtcIsac_kQKltCdfShape +686 +23, WebRtcIsac_kQKltCdfShape +686 +27, WebRtcIsac_kQKltCdfShape +686 +31, WebRtcIsac_kQKltCdfShape +686 +35, WebRtcIsac_kQKltCdfShape +686 +40, WebRtcIsac_kQKltCdfShape +686 +44, WebRtcIsac_kQKltCdfShape +686 +50, WebRtcIsac_kQKltCdfShape +686 +56, WebRtcIsac_kQKltCdfShape +686 +63, WebRtcIsac_kQKltCdfShape +686 +65,
WebRtcIsac_kQKltCdfShape +686 +67, WebRtcIsac_kQKltCdfShape +686 +69, WebRtcIsac_kQKltCdfShape +686 +71, WebRtcIsac_kQKltCdfShape +686 +73, WebRtcIsac_kQKltCdfShape +686 +75, WebRtcIsac_kQKltCdfShape +686 +77, WebRtcIsac_kQKltCdfShape +686 +79, WebRtcIsac_kQKltCdfShape +686 +82, WebRtcIsac_kQKltCdfShape +686 +85, WebRtcIsac_kQKltCdfShape +686 +89,
WebRtcIsac_kQKltCdfShape +686 +93, WebRtcIsac_kQKltCdfShape +686 +97, WebRtcIsac_kQKltCdfShape +686 +102, WebRtcIsac_kQKltCdfShape +686 +106, WebRtcIsac_kQKltCdfShape +686 +112, WebRtcIsac_kQKltCdfShape +686 +119, WebRtcIsac_kQKltCdfShape +686 +127, WebRtcIsac_kQKltCdfShape +686 +129, WebRtcIsac_kQKltCdfShape +686 +131, WebRtcIsac_kQKltCdfShape +686 +133,
WebRtcIsac_kQKltCdfShape +686 +135, WebRtcIsac_kQKltCdfShape +686 +137, WebRtcIsac_kQKltCdfShape +686 +139, WebRtcIsac_kQKltCdfShape +686 +142, WebRtcIsac_kQKltCdfShape +686 +146, WebRtcIsac_kQKltCdfShape +686 +150, WebRtcIsac_kQKltCdfShape +686 +154, WebRtcIsac_kQKltCdfShape +686 +158, WebRtcIsac_kQKltCdfShape +686 +162, WebRtcIsac_kQKltCdfShape +686 +167,
WebRtcIsac_kQKltCdfShape +686 +173, WebRtcIsac_kQKltCdfShape +686 +179, WebRtcIsac_kQKltCdfShape +686 +186, WebRtcIsac_kQKltCdfShape +686 +194, WebRtcIsac_kQKltCdfShape +686 +205, WebRtcIsac_kQKltCdfShape +686 +207, WebRtcIsac_kQKltCdfShape +686 +209, WebRtcIsac_kQKltCdfShape +686 +211, WebRtcIsac_kQKltCdfShape +686 +214, WebRtcIsac_kQKltCdfShape +686 +218,
WebRtcIsac_kQKltCdfShape +686 +222, WebRtcIsac_kQKltCdfShape +686 +226, WebRtcIsac_kQKltCdfShape +686 +230, WebRtcIsac_kQKltCdfShape +686 +234, WebRtcIsac_kQKltCdfShape +686 +238, WebRtcIsac_kQKltCdfShape +686 +242, WebRtcIsac_kQKltCdfShape +686 +247, WebRtcIsac_kQKltCdfShape +686 +253, WebRtcIsac_kQKltCdfShape +686 +262, WebRtcIsac_kQKltCdfShape +686 +269,
WebRtcIsac_kQKltCdfShape +686 +278, WebRtcIsac_kQKltCdfShape +686 +289, WebRtcIsac_kQKltCdfShape +686 +305, WebRtcIsac_kQKltCdfShape +686 +307, WebRtcIsac_kQKltCdfShape +686 +309, WebRtcIsac_kQKltCdfShape +686 +311, WebRtcIsac_kQKltCdfShape +686 +315, WebRtcIsac_kQKltCdfShape +686 +319, WebRtcIsac_kQKltCdfShape +686 +323, WebRtcIsac_kQKltCdfShape +686 +327,
WebRtcIsac_kQKltCdfShape +686 +331, WebRtcIsac_kQKltCdfShape +686 +335, WebRtcIsac_kQKltCdfShape +686 +340, WebRtcIsac_kQKltCdfShape +686 +346, WebRtcIsac_kQKltCdfShape +686 +354, WebRtcIsac_kQKltCdfShape +686 +362, WebRtcIsac_kQKltCdfShape +686 +374, WebRtcIsac_kQKltCdfShape +686 +384, WebRtcIsac_kQKltCdfShape +686 +396, WebRtcIsac_kQKltCdfShape +686 +413,
WebRtcIsac_kQKltCdfShape +686 +439, WebRtcIsac_kQKltCdfShape +686 +442, WebRtcIsac_kQKltCdfShape +686 +446, WebRtcIsac_kQKltCdfShape +686 +450, WebRtcIsac_kQKltCdfShape +686 +455, WebRtcIsac_kQKltCdfShape +686 +461, WebRtcIsac_kQKltCdfShape +686 +468, WebRtcIsac_kQKltCdfShape +686 +475, WebRtcIsac_kQKltCdfShape +686 +481, WebRtcIsac_kQKltCdfShape +686 +489,
WebRtcIsac_kQKltCdfShape +686 +498, WebRtcIsac_kQKltCdfShape +686 +508, WebRtcIsac_kQKltCdfShape +686 +522, WebRtcIsac_kQKltCdfShape +686 +534, WebRtcIsac_kQKltCdfShape +686 +554, WebRtcIsac_kQKltCdfShape +686 +577, WebRtcIsac_kQKltCdfShape +686 +602, WebRtcIsac_kQKltCdfShape +686 +631},
{WebRtcIsac_kQKltCdfShape +1368 +0, WebRtcIsac_kQKltCdfShape +1368 +2, WebRtcIsac_kQKltCdfShape +1368 +4, WebRtcIsac_kQKltCdfShape +1368 +6, WebRtcIsac_kQKltCdfShape +1368 +8, WebRtcIsac_kQKltCdfShape +1368 +10, WebRtcIsac_kQKltCdfShape +1368 +12, WebRtcIsac_kQKltCdfShape +1368 +14, WebRtcIsac_kQKltCdfShape +1368 +16, WebRtcIsac_kQKltCdfShape +1368 +20,
WebRtcIsac_kQKltCdfShape +1368 +24, WebRtcIsac_kQKltCdfShape +1368 +28, WebRtcIsac_kQKltCdfShape +1368 +32, WebRtcIsac_kQKltCdfShape +1368 +36, WebRtcIsac_kQKltCdfShape +1368 +40, WebRtcIsac_kQKltCdfShape +1368 +44, WebRtcIsac_kQKltCdfShape +1368 +50, WebRtcIsac_kQKltCdfShape +1368 +57, WebRtcIsac_kQKltCdfShape +1368 +65, WebRtcIsac_kQKltCdfShape +1368 +67,
WebRtcIsac_kQKltCdfShape +1368 +69, WebRtcIsac_kQKltCdfShape +1368 +71, WebRtcIsac_kQKltCdfShape +1368 +73, WebRtcIsac_kQKltCdfShape +1368 +75, WebRtcIsac_kQKltCdfShape +1368 +77, WebRtcIsac_kQKltCdfShape +1368 +79, WebRtcIsac_kQKltCdfShape +1368 +81, WebRtcIsac_kQKltCdfShape +1368 +85, WebRtcIsac_kQKltCdfShape +1368 +89, WebRtcIsac_kQKltCdfShape +1368 +93,
WebRtcIsac_kQKltCdfShape +1368 +97, WebRtcIsac_kQKltCdfShape +1368 +101, WebRtcIsac_kQKltCdfShape +1368 +105, WebRtcIsac_kQKltCdfShape +1368 +110, WebRtcIsac_kQKltCdfShape +1368 +116, WebRtcIsac_kQKltCdfShape +1368 +123, WebRtcIsac_kQKltCdfShape +1368 +132, WebRtcIsac_kQKltCdfShape +1368 +134, WebRtcIsac_kQKltCdfShape +1368 +136, WebRtcIsac_kQKltCdfShape +1368 +138,
WebRtcIsac_kQKltCdfShape +1368 +141, WebRtcIsac_kQKltCdfShape +1368 +143, WebRtcIsac_kQKltCdfShape +1368 +146, WebRtcIsac_kQKltCdfShape +1368 +150, WebRtcIsac_kQKltCdfShape +1368 +154, WebRtcIsac_kQKltCdfShape +1368 +158, WebRtcIsac_kQKltCdfShape +1368 +162, WebRtcIsac_kQKltCdfShape +1368 +166, WebRtcIsac_kQKltCdfShape +1368 +170, WebRtcIsac_kQKltCdfShape +1368 +174,
WebRtcIsac_kQKltCdfShape +1368 +179, WebRtcIsac_kQKltCdfShape +1368 +185, WebRtcIsac_kQKltCdfShape +1368 +193, WebRtcIsac_kQKltCdfShape +1368 +203, WebRtcIsac_kQKltCdfShape +1368 +214, WebRtcIsac_kQKltCdfShape +1368 +216, WebRtcIsac_kQKltCdfShape +1368 +218, WebRtcIsac_kQKltCdfShape +1368 +220, WebRtcIsac_kQKltCdfShape +1368 +224, WebRtcIsac_kQKltCdfShape +1368 +227,
WebRtcIsac_kQKltCdfShape +1368 +231, WebRtcIsac_kQKltCdfShape +1368 +235, WebRtcIsac_kQKltCdfShape +1368 +239, WebRtcIsac_kQKltCdfShape +1368 +243, WebRtcIsac_kQKltCdfShape +1368 +247, WebRtcIsac_kQKltCdfShape +1368 +251, WebRtcIsac_kQKltCdfShape +1368 +256, WebRtcIsac_kQKltCdfShape +1368 +262, WebRtcIsac_kQKltCdfShape +1368 +269, WebRtcIsac_kQKltCdfShape +1368 +277,
WebRtcIsac_kQKltCdfShape +1368 +286, WebRtcIsac_kQKltCdfShape +1368 +297, WebRtcIsac_kQKltCdfShape +1368 +315, WebRtcIsac_kQKltCdfShape +1368 +317, WebRtcIsac_kQKltCdfShape +1368 +319, WebRtcIsac_kQKltCdfShape +1368 +323, WebRtcIsac_kQKltCdfShape +1368 +327, WebRtcIsac_kQKltCdfShape +1368 +331, WebRtcIsac_kQKltCdfShape +1368 +335, WebRtcIsac_kQKltCdfShape +1368 +339,
WebRtcIsac_kQKltCdfShape +1368 +343, WebRtcIsac_kQKltCdfShape +1368 +349, WebRtcIsac_kQKltCdfShape +1368 +355, WebRtcIsac_kQKltCdfShape +1368 +361, WebRtcIsac_kQKltCdfShape +1368 +368, WebRtcIsac_kQKltCdfShape +1368 +376, WebRtcIsac_kQKltCdfShape +1368 +385, WebRtcIsac_kQKltCdfShape +1368 +397, WebRtcIsac_kQKltCdfShape +1368 +411, WebRtcIsac_kQKltCdfShape +1368 +429,
WebRtcIsac_kQKltCdfShape +1368 +456, WebRtcIsac_kQKltCdfShape +1368 +459, WebRtcIsac_kQKltCdfShape +1368 +463, WebRtcIsac_kQKltCdfShape +1368 +467, WebRtcIsac_kQKltCdfShape +1368 +473, WebRtcIsac_kQKltCdfShape +1368 +478, WebRtcIsac_kQKltCdfShape +1368 +485, WebRtcIsac_kQKltCdfShape +1368 +491, WebRtcIsac_kQKltCdfShape +1368 +497, WebRtcIsac_kQKltCdfShape +1368 +505,
WebRtcIsac_kQKltCdfShape +1368 +514, WebRtcIsac_kQKltCdfShape +1368 +523, WebRtcIsac_kQKltCdfShape +1368 +535, WebRtcIsac_kQKltCdfShape +1368 +548, WebRtcIsac_kQKltCdfShape +1368 +565, WebRtcIsac_kQKltCdfShape +1368 +585, WebRtcIsac_kQKltCdfShape +1368 +611, WebRtcIsac_kQKltCdfShape +1368 +640}};

/* code length for all coefficients using different models */
const double WebRtcIsac_kQKltCodeLenGain[392] = {
 12.29956028,  7.83007500,  4.25642781,  0.17489215,  4.27591254,  7.66908312,  10.47643804, 11.91253716, 9.03421572,  8.57373525,
 6.73555740,   5.41409855,  3.65237863,  0.42623449,  3.22418399,  5.68145719,  7.14201900,  8.20558413,  9.34178852,  13.00000000,
 13.00000000,  9.47643804,  6.71459778,  3.55472644,  0.28457419,  3.70652835,  7.41128536,  11.60768258, 14.00000000, 12.29956028,
 9.29956028,   8.02845645,  6.54878889,  5.07667251,  2.87749552,  0.65310542,  3.11316029,  4.87911416,  5.89540125,  6.76398581,
 7.70537925,   9.67807191,  11.14201900, 14.00000000, 14.00000000, 12.29956028, 9.69621925,  7.70537925,  5.49915812,  2.67441345,
 0.63381441,   2.74999773,  5.76877882,  8.41503750,  10.75207249, 14.00000000, 9.60768258,  8.85025288,  8.09913319,  7.09010692,
 6.36337538,   5.46667027,  4.51618422,  2.64189829,  1.21843537,  2.43823474,  3.89409149,  4.99718498,  6.00989604,  6.78325414,
 7.39637366,   8.76159526,  10.60768258, 11.67807191, 12.29956028, 9.54056838,  7.95560588,  5.63040265,  3.81264793,  2.18521728,
 1.33727600,   2.37909290,  3.94981123,  5.52426657,  7.32051990,  8.84012866,  11.35614381, 13.00000000, 12.29956028, 11.35614381,
 11.35614381,  10.24511250, 9.12963528,  8.80032766,  7.97763219,  7.83007500,  7.09913319,  6.68711704,  6.41879942,  5.74379131,
 5.25096862,   4.43061904,  3.54492969,  2.72664147,  2.16306204,  2.71142226,  3.34357514,  4.07444556,  4.95151313,  5.68145719,
 6.12041675,   6.55085135,  7.00282052,  7.55705650,  8.44541115,  9.41503750,  10.91253716, 11.60768258, 14.00000000, 14.00000000,
 13.00000000,  11.60768258, 10.47643804, 8.80032766,  7.38161450,  6.52426657,  5.47447919,  4.53749773,  3.92719747,  3.41058292,
 2.88495635,   2.79344346,  2.85805254,  3.18261657,  3.57216340,  4.08225499,  4.74438125,  5.51215997,  6.30477171,  7.15450995,
 8.28575448,   9.69621925,  11.60768258, 13.00000000, 13.67807191, 15.00000000, 15.00000000, 14.00000000, 12.41503750, 11.29956028,
 12.41503750,  11.60768258, 10.11735695, 9.47643804,  9.12963528,  9.41503750,  8.23181568,  7.97763219,  7.82507432,  7.50814690,
 7.33466408,   6.99157138,  6.95834085,  6.80524315,  6.47447919,  6.35614381,  6.02128954,  5.71459778,  5.58109327,  5.05821876,
 4.94539568,   4.59220115,  4.27591254,  4.01522554,  3.89376424,  3.83760867,  3.73321346,  3.74674342,  3.90493270,  4.18942837,
 4.33599724,   4.42446075,  4.81760565,  5.07667251,  5.54570071,  5.95697272,  6.46667027,  6.91253716,  7.33466408,  7.82507432,
 8.05163277,   9.12963528,  9.02272008,  9.77118131,  9.60768258,  10.11735695, 12.00000000, 12.83007500, 15.00000000, 15.00000000,
 14.00000000,  15.00000000, 11.75207249, 12.29956028, 10.95560588, 9.93391081,  9.02272008,  8.00564656,  7.82507432,  7.28919357,
 6.77599833,   6.56745810,  6.19910010,  6.23347109,  5.67694524,  5.41879942,  4.96039548,  4.88170777,  4.60768258,  4.52883287,
 4.28876323,   4.17583679,  4.21332197,  4.14474217,  4.16119001,  4.12809476,  4.18501706,  4.28489599,  4.35299136,  4.60286019,
 4.63040265,   4.81017544,  5.00989604,  5.33822190,  5.43489792,  5.84644797,  6.13272126,  6.75444729,  7.36337538,  7.96108101,
 8.54056838,   9.28575448,  9.12963528,  9.47643804,  10.75207249, 12.29956028, 12.41503750, 11.14201900, 12.83007500, 15.00000000,
 15.00000000,  15.00000000, 15.00000000, 15.00000000, 15.00000000, 14.00000000, 15.00000000, 15.00000000, 15.00000000, 15.00000000,
 13.67807191,  12.41503750, 11.91253716, 11.60768258, 12.29956028, 13.00000000, 12.29956028, 10.95560588, 10.60768258, 9.77118131,
 10.02272008,  10.11735695, 10.14201900, 10.75207249, 10.75207249, 9.69621925,  9.47643804,  9.75207249,  8.72387559,  8.47643804,
 8.68711704,   8.40754296,  8.20558413,  8.26529038,  7.84518189,  7.89147554,  7.64685317,  7.41128536,  7.33466408,  7.42635281,
 7.24845594,   7.11430363,  7.07518750,  7.07518750,  6.70537925,  6.64906082,  6.73555740,  6.62931259,  6.50015411,  6.26190774,
 6.36337538,   6.19264508,  5.95151313,  6.08860801,  5.91253716,  5.83007500,  5.68145719,  5.67244736,  5.82632286,  6.00282052,
 5.65348627,   5.74970158,  5.87846648,  5.69052365,  5.64464890,  5.58531476,  5.81512466,  5.57688409,  5.87329553,  5.62170514,
 5.74851759,   5.81017544,  5.64464890,  5.76398581,  5.60339522,  5.69507833,  5.84139031,  5.68711704,  5.73908047,  5.84139031,
 5.71459778,   5.96245305,  5.82632286,  5.89540125,  6.08860801,  6.12041675,  6.13272126,  6.30477171,  6.24177679,  6.28232358,
 6.29091619,   6.53239445,  6.81512466,  6.72620440,  6.65792533,  6.84518189,  7.10215454,  7.44157929,  7.57793523,  7.59485854,
 7.66460965,   8.05163277,  8.00564656,  8.43775758,  8.10518224,  8.28575448,  8.77118131,  8.23181568,  8.29264087,  8.20558413,
 8.34894831,   8.89147554,  8.40754296,  8.61629571,  8.64244800,  8.61629571,  8.93391081,  8.50814690,  9.02272008,  8.68711704,
 8.65127185,   9.41503750,  9.11735695,  9.85025288,  10.24511250, 10.60768258, 10.47643804, 11.60768258, 11.35614381, 12.29956028,
 15.00000000,  15.00000000, 12.29956028, 13.00000000, 15.00000000, 15.00000000, 15.00000000, 15.00000000, 14.00000000, 12.83007500,
 15.00000000,  15.00000000};

const double WebRtcIsac_kQKltCodeLenShape[578] = {
 0.00002201,  0.00002201,  0.00002201,  0.00002201,  0.00002201,  0.00002201,  0.00002201,  0.00002201,  0.00002201,  14.00000000,
 0.00011007,  13.00000000,  0.00066056,  11.60768258,  11.14201900,  0.00185034,  10.24511250,  9.08113676,  0.00480700,  9.41503750,
 8.09913319,  0.01084946,  8.02845645,  13.00000000,  6.40941295,  0.02926496,  6.95560588,  13.00000000,  13.00000000,  6.21864029,
 0.03861814,  6.30477171,  12.29956028,  11.14201900,  4.66964328,  0.12158980,  4.62604734,  10.91253716,  14.00000000,  11.35614381,
 8.76159526,  3.89671219,  0.21179147,  3.99472634,  8.02272008,  13.00000000,  0.00002201,  0.00002201,  0.00002201,  0.00002201,
 14.00000000,  0.00011007,  0.00002201,  0.00002201,  0.00002201,  0.00002201,  14.00000000,  0.00011007,  10.95560588,  0.00147568,
 10.95560588,  10.24511250,  0.00240150,  10.24511250,  8.02845645,  0.01056115,  8.17982104,  6.74497143,  0.02381629,  7.15137706,
 5.68598330,  0.05650076,  5.72970467,  13.00000000,  14.00000000,  5.18221688,  0.07697435,  5.37611851,  11.91253716,  9.54056838,
 3.92853764,  0.22143514,  3.76428491,  9.28575448,  14.00000000,  11.35614381,  7.37794818,  3.30585980,  0.37001735,  3.18521728,
 6.88886433,  11.91253716,  14.00000000,  0.00002201,  0.00002201,  0.00002201,  0.00002201,  14.00000000,  0.00019814,  14.00000000,
 0.00002201,  13.00000000,  0.00028621,  14.00000000,  14.00000000,  0.00028621,  13.00000000,  11.91253716,  0.00094690,  11.35614381,
 10.60768258,  0.00213692,  10.24511250,  8.37794818,  0.00863317,  8.43775758,  14.00000000,  7.41128536,  0.01698415,  7.42635281,
 6.02702021,  0.04514485,  6.01558154,  13.00000000,  5.05090284,  0.09207659,  4.98877274,  15.00000000,  10.75207249,  4.41081703,
 0.15733047,  4.17424617,  11.60768258,  14.00000000,  15.00000000,  10.06926266,  3.74320161,  0.23091117,  3.81141115,  10.02272008,
 11.91253716,  6.90196792,  2.92703003,  0.46874039,  2.93846004,  7.26190774,  11.60768258,  13.00000000,  10.21864029,  7.95560588,
 5.19345038,  2.40520888,  0.77554605,  2.56628417,  5.41409855,  8.81017544,  12.29956028,  0.00002201,  0.00002201,  0.00002201,
 0.00002201,  11.91253716,  0.00068259,  12.29956028,  10.11735695,  0.00233535,  10.47643804,  10.35614381,  0.00140957,  12.29956028,
 10.24511250,  0.00222511,  10.47643804,  7.72387559,  0.01475842,  7.52426657,  6.73555740,  0.02924249,  6.55085135,  14.00000000,
 5.45021533,  0.06930886,  5.38345116,  4.55913083,  0.11289841,  4.92853764,  11.60768258,  4.07148162,  0.19798859,  3.87200568,
 13.00000000,  9.60768258,  3.31393725,  0.29937064,  3.57321111,  9.35614381,  14.00000000,  8.02845645,  3.08542800,  0.45503557,
 2.80678268,  7.47643804,  12.29956028,  14.00000000,  14.00000000,  14.00000000,  6.83509307,  2.69166097,  0.61673447,  2.51266238,
 6.84771516,  11.91253716,  11.14201900,  7.72387559,  4.61899789,  2.17136763,  1.03592993,  2.28586183,  4.86814304,  7.78568088,
 10.91253716,  14.00000000,  15.00000000,  11.04580369,  9.28575448,  7.26190774,  5.21946023,  3.61575588,  2.18431651,  1.45666604,
 2.33566383,  3.85470467,  5.46181107,  7.30651304,  8.89147554,  11.91253716,  0.00002201,  0.00002201,  15.00000000,  0.00011007,
 15.00000000,  10.47643804,  0.00149771,  11.60768258,  7.30651304,  0.01903486,  7.20558413,  6.92318440,  0.02587674,  6.71459778,
 7.28919357,  0.01756340,  7.45696818,  6.06926266,  0.03841465,  6.45890338,  4.46035649,  0.13896157,  4.43204392,  14.00000000,
 14.00000000,  4.09010692,  0.19672654,  3.86653665,  13.00000000,  14.00000000,  11.35614381,  3.45117809,  0.27340929,  3.64878468,
 9.93391081,  9.60768258,  3.30585980,  0.35178287,  3.15607895,  9.12963528,  12.29956028,  7.93391081,  2.82180202,  0.53064436,
 2.68258739,  7.42635281,  11.14201900,  15.00000000,  10.06926266,  6.15294265,  2.55861197,  0.69308389,  2.48602573,  5.90592231,
 9.47643804,  13.00000000,  11.14201900,  8.20558413,  5.21618324,  2.34973357,  1.00379135,  2.09611815,  4.80278331,  7.82507432,
 11.91253716,  12.29956028,  8.98877274,  6.75444729,  4.23886435,  2.19859476,  1.29528579,  2.06032897,  4.06704711,  6.76398581,
 9.34178852,  13.00000000,  12.29956028,  10.14201900,  8.40754296,  6.16710999,  4.64850859,  3.28768796,  2.22892326,  1.78568088,
 2.35209193,  3.45141888,  4.91121176,  6.45117809,  8.20558413,  10.35614381,  13.00000000,  12.83007500,  14.00000000,  14.00000000,
 12.83007500,  11.35614381,  9.85025288,  9.41503750,  8.07518750,  7.34894831,  6.25516616,  5.25096862,  4.52477322,  3.68513357,
 3.06152306,  2.64011320,  2.54608637,  2.95765662,  3.44445223,  4.01665007,  4.63258525,  5.27633906,  6.24678325,  7.05163277,
 8.02845645,  9.60768258,  10.79054663,  12.83007500,  14.00000000,  0.00002201,  15.00000000,  0.00011007,  15.00000000,  5.82009091,
 0.02710994,  10.11735695,  15.00000000,  3.30346709,  0.17317845,  6.41128536,  15.00000000,  15.00000000,  10.83007500,  2.72897475,
 0.35935964,  3.85853144,  13.00000000,  15.00000000,  3.72766182,  0.17268211,  4.74674342,  15.00000000,  15.00000000,  4.40754296,
 0.11993823,  4.93997965,  15.00000000,  15.00000000,  4.70193743,  0.22110152,  3.27591254,  11.35614381,  15.00000000,  12.54056838,
 6.94743195,  2.99157138,  0.62079088,  2.25338071,  7.41128536,  15.00000000,  15.00000000,  11.47643804,  6.04580369,  2.80232255,
 0.98380109,  1.70502034,  5.15607895,  10.75207249,  13.00000000,  15.00000000,  15.00000000,  11.35614381,  6.44157929,  2.37955105,
 0.74567258,  2.44181848,  6.07667251,  10.75207249,  15.00000000,  15.00000000,  15.00000000,  15.00000000,  9.44541115,  5.25432568,
 1.97815248,  0.94086682,  2.57885561,  5.17265730,  8.72387559,  14.00000000,  15.00000000,  15.00000000,  15.00000000,  10.67807191,
 7.59485854,  4.91187431,  2.91934900,  1.32321648,  1.50614455,  3.85215911,  7.15137706,  10.60768258,  14.00000000,  15.00000000,
 15.00000000,  15.00000000,  15.00000000,  15.00000000,  15.00000000,  15.00000000,  11.09310940,  8.50814690,  6.45117809,  3.94675287,
 2.16730774,  1.37674720,  2.10215454,  3.97278511,  6.34178852,  8.50814690,  10.32757466,  14.00000000,  14.00000000,  15.00000000,
 15.00000000,  15.00000000,  14.00000000,  10.02272008,  9.41503750,  7.03710399,  5.13349379,  3.61683574,  2.47999526,  1.82788507,
 2.00945280,  3.08020557,  4.69793233,  6.64025044,  8.32051990,  10.91253716,  14.00000000,  15.00000000,  15.00000000,  15.00000000,
 15.00000000,  15.00000000,  15.00000000,  14.41503750,  9.41503750,  7.10215454,  5.60768258,  4.44014496,  3.30064444,  2.56941678,
 2.28103909,  2.42694459,  2.93206152,  3.83383692,  4.75207249,  6.02702021,  7.16394964,  9.35614381,  11.14201900,  12.29956028,
 15.00000000,  15.00000000,  14.00000000,  15.00000000,  15.00000000,  10.11735695,  8.85025288,  7.02558541,  5.86300889,  4.79726396,
 3.95117259,  3.44925321,  2.96348293,  2.88219459,  2.89671219,  3.10518224,  3.50065237,  4.05748549,  4.55291677,  5.23016216,
 5.79420675,  6.39452048,  6.91253716,  7.97763219,  8.32051990,  9.35614381,  10.60768258,  11.60768258,  15.00000000,  15.00000000,
 12.83007500,  12.41503750,  11.91253716,  14.00000000,  14.00000000,  11.35614381,  10.75207249,  10.91253716,  8.93391081,  8.61629571,
 8.29264087,  8.02272008,  7.89147554,  7.33466408,  7.41128536,  6.71459778,  5.92853764,  5.31964048,  4.97693875,  4.70308379,
 4.43632704,  4.34357514,  4.30825648,  4.26529038,  4.19465917,  4.27420773,  4.22315577,  4.08262792,  4.06667818,  4.16119001,
 4.08860801,  4.26698468,  4.39128315,  4.71517590,  5.10442472,  5.50714538,  5.81017544,  6.15922208};

/* left KLT transforms */
const double WebRtcIsac_kKltT1Gain[3][4] = {
{-0.79742827,  0.60341375,  0.60341375,  0.79742827},
{-0.81372390,  0.58125159,  0.58125159,  0.81372390},
{-0.71832547,  0.69570721,  0.69570721,  0.71832547}};

const double WebRtcIsac_kKltT1Shape[3][324] = {
{ 0.00159597,  0.00049320,  0.00513821,  0.00021066,  0.01338581, -0.00422367, -0.00272072,  0.00935107,  0.02047622,  0.02691189,
 0.00478236,  0.03969702,  0.00886698,  0.04877604, -0.10898362, -0.05930891, -0.03415047,  0.98889721,  0.00293558, -0.00035282,
 0.01156321, -0.00195341, -0.00937631,  0.01052213, -0.02551163,  0.01644059,  0.03189927,  0.07754773, -0.08742313, -0.03026338,
 0.05136248, -0.14395974,  0.17725040,  0.22664856,  0.93380230,  0.07076411,  0.00557890, -0.00222834,  0.01377569,  0.01466808,
 0.02847361, -0.00603178,  0.02382480, -0.01210452,  0.03797267, -0.02371480,  0.11260335, -0.07366682,  0.00453436, -0.04136941,
-0.07912843, -0.95031418,  0.25295337, -0.05302216, -0.00617554, -0.00044040, -0.00653778,  0.01097838,  0.01529174,  0.01374431,
-0.00748512, -0.00020034,  0.02432713,  0.11101570, -0.08556891,  0.09282249, -0.01029446,  0.67556443, -0.67454300,  0.06910063,
 0.20866865, -0.10318050,  0.00932175,  0.00524058,  0.00803610, -0.00594676, -0.01082578,  0.01069906,  0.00546768,  0.01565291,
 0.06816200,  0.10201227,  0.16812734,  0.22984074,  0.58213170, -0.54138651, -0.51379962,  0.06847390, -0.01920037, -0.04592324,
-0.00467394,  0.00328858,  0.00377424, -0.00987448,  0.08222096, -0.00377301,  0.04551941, -0.02592517,  0.16317082,  0.13077530,
 0.22702921, -0.31215289, -0.69645962, -0.38047101, -0.39339411,  0.11124777,  0.02508035, -0.00708074,  0.00400344,  0.00040331,
 0.01142402,  0.01725406,  0.01635170,  0.14285366,  0.03949233, -0.05905676,  0.05877154, -0.17497577, -0.32479440,  0.80754464,
-0.38085603, -0.17055430, -0.03168622, -0.07531451,  0.02942002, -0.02148095, -0.00754114, -0.00322372,  0.00567812, -0.01701521,
-0.12358320,  0.11473564,  0.09070136,  0.06533068, -0.22560802,  0.19209022,  0.81605094,  0.36592275, -0.09919829,  0.16667122,
 0.16300725,  0.04803807,  0.06739263, -0.00156752, -0.01685302, -0.00905240, -0.02297836, -0.00469939,  0.06310613, -0.16391930,
 0.10919511,  0.12529293,  0.85581322, -0.32145522,  0.24539076,  0.07181839,  0.07289591,  0.14066759,  0.10406711,  0.05815518,
 0.01072680, -0.00759339,  0.00053486, -0.00044865,  0.03407361,  0.01645348,  0.08758579,  0.27722240,  0.53665485, -0.74853376,
-0.01118192, -0.19805430,  0.06130619, -0.09675299,  0.08978480,  0.03405255, -0.00706867,  0.05102045,  0.03250746,  0.01849966,
-0.01216314, -0.01184187, -0.01579288,  0.00114807,  0.11376166,  0.88342114, -0.36425379,  0.13863190,  0.12524180, -0.13553892,
 0.04715856, -0.12341103,  0.04531568,  0.01899360, -0.00206897,  0.00567768, -0.01444163,  0.00411946, -0.00855896,  0.00381663,
-0.01664861, -0.05534280,  0.21328278,  0.20161162,  0.72360394,  0.59130708, -0.08043791,  0.08757349, -0.13893918, -0.05147377,
 0.02680690, -0.01144070,  0.00625162, -0.00634215, -0.01248947, -0.00329455, -0.00609625, -0.00136305, -0.05097048, -0.01029851,
 0.25065384, -0.16856837, -0.07123372,  0.15992623, -0.39487617, -0.79972301,  0.18118185, -0.04826639, -0.01805578, -0.02927253,
-0.16400618,  0.07472763,  0.10376449,  0.01705406,  0.01065801, -0.01500498,  0.02039914,  0.37776349, -0.84484186,  0.10434286,
 0.15616990,  0.13474456, -0.00906238, -0.25238368, -0.03820885, -0.10650905, -0.03880833, -0.03660028, -0.09640894,  0.00583314,
 0.01922097,  0.01489911, -0.02431117, -0.09372217,  0.39404721, -0.84786223, -0.31277121,  0.03193850,  0.01974060,  0.01887901,
 0.00337911, -0.11359599, -0.02792521, -0.03220184, -0.01533311,  0.00015962, -0.04225043, -0.00933965,  0.00675311,  0.00206060,
 0.15926771,  0.40199829, -0.80792558, -0.35591604, -0.17169764,  0.02830436,  0.02459982, -0.03438589,  0.00718705, -0.01798329,
-0.01594508, -0.00702430, -0.00952419, -0.00962701, -0.01307212, -0.01749740,  0.01299602,  0.00587270, -0.36103108, -0.82039266,
-0.43092844, -0.08500097, -0.04361674, -0.00333482,  0.01250434, -0.02538295, -0.00921797,  0.01645071, -0.01400872,  0.00317607,
 0.00003277, -0.01617646, -0.00616863, -0.00882661,  0.00466157,  0.00353237,  0.91803104, -0.39503305, -0.02048964,  0.00060125,
 0.01980634,  0.00300109,  0.00313880,  0.00657337,  0.00715163,  0.00000261,  0.00854276, -0.00154825, -0.00516128,  0.00909527,
 0.00095609,  0.00701196, -0.00221867, -0.00156741},
{-0.00469582, -0.00020403, -0.00587134,  0.00185153, -0.02256479, -0.01185761, -0.02891481, -0.00493792, -0.00182344,  0.00285962,
 0.01558059, -0.02185140,  0.04639438, -0.04357142,  0.12718613, -0.06756136,  0.05542227,  0.98480184, -0.00374376, -0.00236433,
-0.00607169, -0.00303290, -0.00127243, -0.01794845,  0.00620033, -0.00732704, -0.02837749, -0.00107164,  0.04820548,  0.00713300,
 0.09784244, -0.16806261, -0.04563341, -0.33406041,  0.91554083, -0.08139655, -0.00415851, -0.00538193, -0.00731198, -0.00534534,
-0.00623075, -0.02016943, -0.05480133, -0.03172290, -0.03879603,  0.01518441,  0.09591688,  0.02238470,  0.08126640,  0.08236821,
-0.24802119,  0.89516402,  0.32029647,  0.07188887, -0.00220366,  0.00344025, -0.00277284,  0.00358963, -0.08668007, -0.02205910,
-0.05289669, -0.03535201, -0.01188017, -0.06456872, -0.09321006, -0.00009617, -0.15804070,  0.24632041,  0.90166119,  0.19250690,
 0.17264619, -0.09699155, -0.00567329, -0.00897700, -0.01442565, -0.01939390,  0.03702127, -0.02999862, -0.04385696, -0.05232394,
-0.03339177,  0.03905964, -0.00281424, -0.29213275,  0.02892968,  0.90257613, -0.21546058, -0.18070946,  0.09014567,  0.04117230,
-0.01029696, -0.00329116, -0.03354346,  0.02937079,  0.01274208, -0.01260649, -0.03505571, -0.01020645,  0.03787209,  0.12132165,
-0.20826840,  0.81556933, -0.43874351,  0.21518682, -0.14564290, -0.05210031,  0.07124563,  0.06127983, -0.00457321,  0.01740496,
 0.04185176,  0.00128036, -0.05033693, -0.01890046,  0.06221734,  0.10280078, -0.03738531,  0.04830209, -0.08408293, -0.46409009,
-0.83936263, -0.14817619, -0.13135927,  0.04563506,  0.08340661,  0.04040200,  0.00044396, -0.01365972,  0.01228951,  0.01078273,
 0.09205406, -0.03791500,  0.07135889,  0.08158339,  0.06298278, -0.22875755, -0.92917558, -0.11248260,  0.17801883, -0.03971674,
-0.07491915,  0.06477287,  0.04635713,  0.01856159,  0.00130895, -0.01991604,  0.02358176, -0.09376056,  0.02782280, -0.04691559,
 0.13749249,  0.31383132,  0.92274602,  0.04727419,  0.09765196, -0.02108945,  0.00626005,  0.05193322,  0.02009133,  0.03094066,
 0.04573470,  0.00451733,  0.00240169, -0.00982355, -0.03546208, -0.14156875, -0.02480689,  0.22997442,  0.09778317,  0.88834235,
-0.32797611, -0.00079977,  0.04917079,  0.06977359,  0.06451185,  0.07816204,  0.03119314,  0.01136506,  0.01062006,  0.00632783,
 0.03241828, -0.03318847, -0.01350502, -0.30055361,  0.07265375,  0.17308022,  0.88795796, -0.23231020, -0.08932700,  0.11759604,
 0.00590705,  0.03525351,  0.00840466,  0.04389942,  0.04387629,  0.04003275,  0.01772966,  0.02709780, -0.02393282,  0.02766178,
 0.00342983, -0.33882220,  0.76612668,  0.44061716, -0.28414784, -0.09364014,  0.03694060,  0.01124120,  0.01130268, -0.02869682,
-0.07428963, -0.03504754,  0.05874942,  0.01196795,  0.02003875,  0.00787152, -0.01605561,  0.04501257, -0.06959958, -0.13015784,
-0.05738065,  0.04681625,  0.06668700, -0.04492094,  0.02927765, -0.94404277,  0.19243952,  0.09504337, -0.12540826,  0.05394317,
-0.07972638, -0.02145188,  0.00136427,  0.01964678,  0.06667373,  0.06204535,  0.17302394,  0.22005905,  0.58329964, -0.68440447,
 0.19628796,  0.15718011, -0.12481840, -0.08222507,  0.11780870,  0.03798206, -0.01818866,  0.00892766,  0.05582263,  0.01126832,
-0.00973589,  0.00697442, -0.09937902,  0.06621185, -0.19452202, -0.80004569, -0.13946094, -0.48990700, -0.17595191, -0.00798873,
-0.06121856,  0.08768040, -0.04507631,  0.00448896,  0.01153941, -0.04711652, -0.01050749, -0.01660047, -0.03007159, -0.01468906,
 0.12848053,  0.13859838,  0.93863771, -0.22250065, -0.14841278,  0.04666032, -0.06344813, -0.01915105, -0.01840150, -0.02389410,
-0.01245496,  0.05023402,  0.02125840,  0.02467318, -0.01893022, -0.00889647,  0.00551817,  0.00481915, -0.40626968, -0.89028236,
 0.18261687, -0.03852330,  0.02621926, -0.05420122, -0.01704117, -0.00072893, -0.02694170, -0.04335124,  0.02256467,  0.00642301,
-0.01619484, -0.00871160,  0.00400065, -0.00488820, -0.00752173, -0.00170603,  0.89554989, -0.41825934, -0.08725803, -0.09051404,
-0.00916236, -0.02959065, -0.07268075, -0.00816626, -0.00314215, -0.01941078, -0.00036782, -0.00188655, -0.02107724, -0.00771657,
-0.00448194, -0.00387517,  0.00082998,  0.00202471},
{ 0.00167296, -0.00647772, -0.00604394,  0.01490810, -0.00837664,  0.00246438,  0.02082153,  0.01216715,  0.01001396, -0.02850860,
-0.01187868, -0.00113289,  0.04140237, -0.11084998,  0.16102260,  0.20084170, -0.28969446, -0.91312256,  0.00087788, -0.00136895,
 0.00004622,  0.00578894,  0.00524119, -0.00044550,  0.00948906, -0.00396910, -0.03312197, -0.00075487,  0.00987494, -0.02088734,
 0.09835550, -0.20080342,  0.13687782, -0.16111863, -0.90089988,  0.30312999,  0.00248784, -0.00975419, -0.01617200,  0.00699371,
-0.02151635, -0.01625774, -0.01262800,  0.02588781, -0.05620764, -0.13651454,  0.04242442, -0.02615307,  0.20497288, -0.20422909,
 0.14184406,  0.89712919,  0.01758042,  0.25447787, -0.00207668, -0.00260329,  0.00724812, -0.01007749,  0.00806242, -0.03089729,
-0.01161934, -0.00618676, -0.10327342, -0.10160272,  0.11919283,  0.20781533,  0.11564869, -0.19072476,  0.86402008, -0.24650846,
 0.24684161,  0.04775750,  0.00486888, -0.01735569, -0.01868000, -0.01870386, -0.03243262, -0.05883701, -0.03433371,  0.10441236,
-0.22831067, -0.22837988,  0.15082544, -0.21313767,  0.13215611, -0.78096079, -0.32270595, -0.21307018,  0.17339271, -0.05435742,
-0.00940813,  0.00272520,  0.00542917, -0.05232991, -0.01280809, -0.10773627, -0.17626479,  0.03719285, -0.26297104, -0.21780618,
 0.21406665,  0.15202177,  0.75911044,  0.38627481, -0.16504189, -0.10242997, -0.02394939, -0.06018959,  0.00994733, -0.02617197,
-0.01543723, -0.10320051, -0.03010481, -0.19098072, -0.06893233,  0.12253174, -0.25556092, -0.31989059,  0.09542655,  0.72712041,
-0.43108921, -0.01568072, -0.16532685,  0.06646835, -0.08885408, -0.00050364, -0.01791050,  0.00245405,  0.00204794, -0.17948691,
-0.05193881, -0.16329387, -0.13676259,  0.01214133, -0.30994612, -0.00687734,  0.63254090, -0.47180795, -0.35409214,  0.23658315,
 0.11170294,  0.05229887, -0.06107035, -0.01094212,  0.01523854, -0.01608284, -0.03739206, -0.23864328, -0.03958494, -0.19305719,
-0.26019058,  0.24108257, -0.55933566,  0.40623396, -0.53367968, -0.08930957, -0.00599383, -0.00050845,  0.06960811,  0.02664961,
 0.01464197, -0.00486781, -0.01905736,  0.01437578,  0.02379930, -0.26639588,  0.05208876, -0.43525002, -0.63009424,  0.05251889,
 0.56732782, -0.06731164, -0.03705909, -0.03253946,  0.00950673, -0.07941760,  0.02388267, -0.01258409, -0.00343524,  0.00148711,
-0.00362107,  0.03981813, -0.07235214, -0.46180041, -0.05595288, -0.55699317,  0.61935853, -0.25379716,  0.06796783,  0.01039267,
-0.06329171, -0.02143024,  0.09406929, -0.00799203, -0.01419805, -0.00603024,  0.01313145,  0.00091161, -0.00212107, -0.02405340,
 0.07146405, -0.76695326, -0.14841817,  0.60372663, -0.01478424,  0.06522462,  0.08580016, -0.05817981,  0.02438942,  0.04840904,
 0.02934363, -0.02239678, -0.00582247, -0.00091312, -0.00394148, -0.00285276, -0.03435745,  0.05277435,  0.17882781, -0.06194164,
 0.27321118,  0.01840179, -0.10188148, -0.33168524, -0.03491221,  0.67351789,  0.37017376,  0.32083717,  0.09737800, -0.20998084,
-0.10725041,  0.06379186,  0.02169903, -0.02031584,  0.05623799, -0.18300962, -0.17337803,  0.08915172, -0.53835537, -0.08547263,
 0.15163321,  0.56732906,  0.21878115,  0.37274266,  0.26206918,  0.13443927,  0.09178695, -0.03276324, -0.01131664, -0.00236369,
 0.00772568,  0.01008805, -0.17122615,  0.15301569,  0.40135484, -0.06058913,  0.56405128, -0.05176853,  0.24544337,  0.62448073,
 0.07265009, -0.01198695,  0.05151774, -0.03678498,  0.01886154,  0.03724094,  0.01393667,  0.00758055, -0.00254297,  0.00537118,
 0.24169707, -0.41735970, -0.67564355, -0.09270478,  0.53106033,  0.06214579,  0.02574404,  0.09943837,  0.03032542,  0.02194476,
 0.06369772, -0.00133741,  0.01301113,  0.01508494,  0.00036111, -0.00278870,  0.00139205,  0.00015792, -0.43347887,  0.69923146,
-0.55406563, -0.01102231,  0.01347767,  0.07012139, -0.02530164,  0.06803192,  0.01177196,  0.04374491,  0.04073027,  0.04037438,
 0.00167330, -0.01807065, -0.00425562,  0.00149653, -0.00035119, -0.00172888,  0.84785495,  0.52289580,  0.01067734, -0.00859194,
 0.01685964,  0.00481442,  0.00434738,  0.07592695,  0.01419942,  0.01005336,  0.03316937,  0.00360465,  0.00435039,  0.00029122,
 0.00171268,  0.00198919, -0.00046889, -0.00094176}};

/* right KLT transforms */
const double WebRtcIsac_kKltT2Gain[3][36] = {
{ 0.14572837, -0.45446306,  0.61990621, -0.52197033,  0.32145074, -0.11026900, -0.20698282,  0.48962182, -0.27127933, -0.33627476,
 0.65094037, -0.32715751,  0.40262573, -0.47844405, -0.33876075,  0.44130653,  0.37383966, -0.39964662, -0.51730480,  0.06611973,
 0.49030187,  0.47512886, -0.02141226, -0.51129451, -0.58578569, -0.39132064, -0.13187771,  0.15649421,  0.40735596,  0.54396897,
 0.40381276,  0.40904942,  0.41179766,  0.41167576,  0.40840251,  0.40468132},
{-0.11368135,  0.34815515, -0.56434996,  0.61130763, -0.39970336,  0.11795708,  0.28514257, -0.58879243,  0.32775812,  0.27024886,
-0.56251299,  0.27411037,  0.42649186, -0.44080232, -0.36408215,  0.35932457,  0.43592895, -0.41484213, -0.49813030, -0.00012592,
 0.49865688,  0.47634953,  0.01094246, -0.52552726, -0.56154082, -0.41110686, -0.14170764,  0.15946614,  0.40818082,  0.55094554,
 0.40051601,  0.41084781,  0.41567800,  0.41450700,  0.40871872,  0.39891823},
{-0.10719481,  0.34796287, -0.54573957,  0.59521001, -0.43943367,  0.14907223,  0.26554957, -0.59549939,  0.36760692,  0.26040652,
-0.55268701,  0.25778784,  0.38994096, -0.45282773, -0.37975656,  0.40213055,  0.43052647, -0.38937904, -0.52698359,  0.02788094,
 0.48284286,  0.47792474,  0.02557759, -0.50922240, -0.57699826, -0.39476779, -0.14708238,  0.12742149,  0.37835245,  0.57464021,
 0.39408127,  0.40327462,  0.40993655,  0.41419345,  0.41506301,  0.41253853}};

const double WebRtcIsac_kKltT2Shape[3][36] = {
{ 0.13427386, -0.35132558,  0.52506528, -0.59419077,  0.45075085, -0.16312057,  0.29857439, -0.58660147,  0.34265431,  0.20879510,
-0.56063262,  0.30238345,  0.43308283, -0.41186999, -0.35288681,  0.42768996,  0.36094634, -0.45284910, -0.47116680,  0.02893449,
 0.54326135,  0.45249040, -0.06264420, -0.52283830,  0.57137758,  0.44298139,  0.12617554, -0.20819946, -0.42324603, -0.48876443,
 0.39597050,  0.40713935,  0.41389880,  0.41512486,  0.41130400,  0.40575001},
{ 0.16540737, -0.43379435,  0.58165221, -0.55154773,  0.35734028, -0.11935912,  0.29434254, -0.55954817,  0.23549804,  0.33087258,
-0.58848503,  0.29835834,  0.45464789, -0.38316155, -0.41689708,  0.35607296,  0.41260747, -0.41910198, -0.48633899, -0.04144955,
 0.47824583,  0.51050942,  0.01000345, -0.52184032,  0.53488229,  0.42641051,  0.17049774, -0.15849613, -0.43229355, -0.53945045,
 0.39582002,  0.41033103,  0.41788713,  0.41688080,  0.41081697,  0.39719658},
{ 0.13386268, -0.37919915,  0.54989123, -0.57663572,  0.42402636, -0.15362720,  0.29641577, -0.58806770,  0.31381040,  0.26524954,
-0.56271012,  0.28431868,  0.42699898, -0.41058922, -0.40408270,  0.39215865,  0.40788513, -0.40699735, -0.49846482, -0.01521208,
 0.48756040,  0.49479418, -0.00347672, -0.51841384,  0.55513106,  0.41683793,  0.15131217, -0.15613621, -0.41029341, -0.54996461,
 0.39402116,  0.40965305,  0.41862791,  0.41730770,  0.41089648,  0.39837262}};

/* means of log gains and LAR coefficients*/
const double WebRtcIsac_kLpcMeansGain[3][12] = {
{-6.86881911, -5.35075273, -6.86792680, -5.36200897, -6.86401538, -5.36921533, -6.86802969, -5.36893966, -6.86538097, -5.36315063,
-6.85535304, -5.35155315},
{-6.12914600, -4.78070092, -6.12971780, -4.78382183, -6.12858525, -4.79362198, -6.12926491, -4.79017481, -6.12102401, -4.78346122,
-6.11441152, -4.78019228},
{-5.67273484, -3.73876311, -5.65246094, -3.71407895, -5.61716443, -3.68814580, -5.58804560, -3.66334094, -5.54189577, -3.63845640,
-5.49293185, -3.61760203}};

const double WebRtcIsac_kLpcMeansShape[3][108] = {
{-0.91232981,  0.26258634, -0.33716701,  0.08477430, -0.03378426,  0.14423909,  0.07036185,  0.06155019,  0.01490385,  0.04138740,
 0.01427317,  0.01288970,  0.83872106,  0.25750199,  0.07988929, -0.01957923,  0.00831390,  0.01770300, -0.90957164,  0.25732216,
-0.33385344,  0.08735740, -0.03715332,  0.14584917,  0.06998990,  0.06131968,  0.01504379,  0.04067339,  0.01428039,  0.01406460,
 0.83846243,  0.26169862,  0.08109025, -0.01767055,  0.00970539,  0.01954310, -0.90490803,  0.24656405, -0.33578607,  0.08843286,
-0.03749139,  0.14443959,  0.07214669,  0.06170993,  0.01449947,  0.04134309,  0.01314762,  0.01413471,  0.83895203,  0.26748062,
 0.08197507, -0.01781298,  0.00885967,  0.01922394, -0.90922472,  0.24495889, -0.33921540,  0.08877169, -0.03581332,  0.14199172,
 0.07444032,  0.06185940,  0.01502054,  0.04185113,  0.01276579,  0.01355457,  0.83645358,  0.26631720,  0.08119697, -0.01835449,
 0.00788512,  0.01846446, -0.90482253,  0.24658310, -0.34019734,  0.08281090, -0.03486038,  0.14359248,  0.07401336,  0.06001471,
 0.01528421,  0.04254560,  0.01321472,  0.01240799,  0.83857127,  0.26281654,  0.08174380, -0.02099842,  0.00755176,  0.01699448,
-0.90132307,  0.25174308, -0.33838268,  0.07883863, -0.02877906,  0.14105407,  0.07220290,  0.06000352,  0.01684879,  0.04226844,
 0.01331331,  0.01269244,  0.83832138,  0.25467485,  0.08118028, -0.02120528,  0.00747832,  0.01567212},
{-1.11639718,  0.35377266,  0.00798929,  0.20165280,  0.07656104,  0.10629964,  0.04894160,  0.10955305, -0.01806405,  0.05082282,
 0.01730794,  0.01345957,  0.73717782,  0.05952284,  0.03176204,  0.08195122,  0.01253148,  0.02253385, -1.12053537,  0.35523538,
 0.00859646,  0.20007706,  0.07715852,  0.10754596,  0.05165976,  0.10927703, -0.01554395,  0.05178866,  0.01752534,  0.01343468,
 0.73489046,  0.06395167,  0.03287798,  0.07972374,  0.01293550,  0.02300929, -1.11772179,  0.35457623,  0.01205524,  0.19926481,
 0.08000866,  0.10817921,  0.05052481,  0.11016167, -0.01552091,  0.05155510,  0.01787163,  0.01343778,  0.73142568,  0.06840830,
 0.03316828,  0.07902608,  0.01525042,  0.02178127, -1.12120164,  0.36405233,  0.00630305,  0.19799738,  0.07829690,  0.10727588,
 0.04017317,  0.10437949, -0.01844109,  0.05021700,  0.01561726,  0.01226571,  0.73438044,  0.06947982,  0.03396317,  0.07858683,
 0.01367105,  0.02041955, -1.12146187,  0.35952226,  0.00340090,  0.19700813,  0.07938222,  0.10904137,  0.03921216,  0.10531403,
-0.01833415,  0.04956231,  0.01399539,  0.01323582,  0.74378099,  0.07059589,  0.03367692,  0.08151462,  0.01182040,  0.02075577,
-1.11245254,  0.35234230,  0.00687490,  0.20204252,  0.07813186,  0.11081259,  0.04634665,  0.11073238, -0.01637954,  0.05104577,
 0.01675122,  0.01448696,  0.74013627,  0.06239059,  0.03129412,  0.08207461,  0.01249475,  0.02189238},
{-1.27118948,  0.35834331, -0.33499347,  0.13524073,  0.04829079,  0.19542773,  0.05273835,  0.04157974, -0.01755227,  0.01513442,
 0.00386630,  0.02199463,  1.14439142,  0.21903073,  0.14750213,  0.12743356,  0.08463334,  0.06839691, -1.28367777,  0.35556287,
-0.33809405,  0.13627881,  0.04939309,  0.19642571,  0.05354373,  0.04099247, -0.01787481,  0.01472425,  0.00391474,  0.02150716,
 1.14739079,  0.21840872,  0.14643624,  0.12724347,  0.08390642,  0.06811938, -1.29007667,  0.35159558, -0.34154267,  0.13295849,
 0.04883602,  0.19587595,  0.05452759,  0.04174703, -0.01782110,  0.01388270,  0.00374754,  0.02138105,  1.14333767,  0.21690116,
 0.14544599,  0.12606728,  0.08314168,  0.06771389, -1.29856471,  0.35239315, -0.34238732,  0.13277553,  0.04722712,  0.19233156,
 0.05366901,  0.04328110, -0.01657749,  0.01444736,  0.00438108,  0.02102563,  1.13548397,  0.21537812,  0.14357377,  0.12525845,
 0.08230994,  0.06722511, -1.30663540,  0.34366563, -0.34205544,  0.12861679,  0.04655851,  0.18864359,  0.05351285,  0.04358693,
-0.01604498,  0.01431907,  0.00395326,  0.02082299,  1.12207794,  0.21167325,  0.14212491,  0.12418671,  0.08155467,  0.06639789,
-1.31011673,  0.33686271, -0.34379843,  0.12169569,  0.04480323,  0.18637557,  0.05374078,  0.04260827, -0.01588226,  0.01378294,
 0.00396009,  0.02112406,  1.10466984,  0.20905894,  0.14107033,  0.12303074,  0.08047136,  0.06588031}};

