////////////////////////////////////////////////////////////////////////////////
// sudokuki - C++ graphical sudoku game                                       //
// Copyright (C) 2007-2009 Sylvain Vedrenne                                   //
//                                                                            //
// This program is free software; you can redistribute it and/or              //
// modify it under the terms of the GNU General Public License                //
// as published by the Free Software Foundation; either version 2             //
// of the License, or (at your option) any later version.                     //
//                                                                            //
// This program is distributed in the hope that it will be useful,            //
// but WITHOUT ANY WARRANTY; without even the implied warranty of             //
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the              //
// GNU General Public License for more details.                               //
//                                                                            //
// You should have received a copy of the GNU General Public License along    //
// with this program; if not, write to the Free Software Foundation, Inc.,    //
// 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.              //
////////////////////////////////////////////////////////////////////////////////
#ifndef _HH_GRID_TOOL_HH_
#define _HH_GRID_TOOL_HH_

#include <iostream>
#include <assert.h>
#include <map>
using namespace std;

class grid_tool {

public:
	grid_tool() {
//		printf("[%s/%s]%s\n", __FILE__, __func__, "");
		m_number_of_filled_cells = 0;
	};
	virtual ~grid_tool() {
//		printf("[%s/%s]%s\n", __FILE__, __func__, "");
	};

	virtual void init( const string grid_str );
	virtual int get_cell_value( int, int ) = 0;

	virtual std::map<int, int> get_current_grid_values() = 0;

	unsigned int get_number_of_filled_cells() { return m_number_of_filled_cells; }
protected:
	// 82 grids * 9 lines  * 9 cols  * (12 shorts/cell)
	// nb_grids * nb_lines * nb_cols *  nb_flags
	short m_pmem[82 * 9*9 * 12   *10];
	short* m_pcur_grid; // location of current grid
	unsigned int m_number_of_filled_cells;

private:
	int fill_1st_grid( const string grid_str );
};

#endif //_HH_GRID_TOOL_HH_
