/*
 * dbg_traces.h
 *
 *  Created on: 31 mars 2009
 *      Author: gnu_sylvano
 */

#ifndef _H_DBGM_TRACES_H_
#define _H_DBGM_TRACES_H_

#ifdef DBGM_TRACES
#if (DBGM_TRACES != 0 && DBGM_TRACES != 1)
# error "DBGM_TRACES must be set to 0 or 1 (0: no traces, 1: traces activated)"
#endif
#else
# error "DBGM_TRACES must be defined"
#endif


# define _DBGM(...) ;
# define _DBGF(...) ;
# define F_DBGM(MSG) printf("[%s/%s]%s\n", __FILE__, __func__, ""MSG)
# define F_DBGF(P, ...) printf("[%s/%s]"P"\n", __FILE__, __func__, __VA_ARGS__ )
#if DBGM_TRACES
# define DBGM(MSG) F_DBGM(MSG)
# define DBGF(P, ...) F_DBGF(P, __VA_ARGS__)
#else
# define DBGM(...) ;
# define DBGF(...) ;
#endif

#endif /* _H_DBGM_TRACES_H_ */
