/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.midiport.fluidsynth;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.player.base.MidiOutputPort;
import org.herac.tuxguitar.player.base.MidiOutputPortProvider;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.MidiOutputPortImpl;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.MidiOutputPortSettings;
import org.herac.tuxguitar.player.impl.midiport.fluidsynth.MidiSynth;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGExpressionResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MidiOutputPortProviderImpl
implements MidiOutputPortProvider {
    private TGContext context;
    private MidiSynth synth;
    private MidiOutputPortSettings settings;

    public MidiOutputPortProviderImpl(TGContext context) {
        this.context = context;
    }

    public List<MidiOutputPort> listPorts() throws MidiPlayerException {
        try {
            ArrayList<MidiOutputPort> ports = new ArrayList<MidiOutputPort>();
            for (String path : this.getSettings().getSoundfonts()) {
                File soundfont = new File(TGExpressionResolver.getInstance((TGContext)this.context).resolve(path));
                if (!soundfont.exists() || soundfont.isDirectory()) continue;
                ports.add((MidiOutputPort)new MidiOutputPortImpl(this.getSynth(), soundfont));
            }
            return ports;
        }
        catch (Throwable throwable) {
            throw new MidiPlayerException(throwable.getMessage(), throwable);
        }
    }

    public void closeAll() throws MidiPlayerException {
        try {
            if (this.synth != null && this.synth.isInitialized()) {
                this.synth.finalize();
                this.synth = null;
            }
        }
        catch (Throwable throwable) {
            throw new MidiPlayerException(throwable.getMessage(), throwable);
        }
    }

    public MidiSynth getSynth() {
        if (this.synth == null || !this.synth.isInitialized()) {
            this.synth = new MidiSynth();
            this.getSettings().apply();
        }
        return this.synth;
    }

    public MidiOutputPortSettings getSettings() {
        if (this.settings == null) {
            this.settings = new MidiOutputPortSettings(this);
        }
        return this.settings;
    }

    public TGContext getContext() {
        return this.context;
    }
}

