/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.toolbar.main;

import org.herac.tuxguitar.app.view.toolbar.main.TGMainToolBar;
import org.herac.tuxguitar.app.view.toolbar.main.TGMainToolBarSection;
import org.herac.tuxguitar.graphics.control.TGLayout;
import org.herac.tuxguitar.graphics.control.TGLayoutHorizontal;
import org.herac.tuxguitar.graphics.control.TGLayoutVertical;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.menu.UIMenuActionItem;
import org.herac.tuxguitar.ui.toolbar.UIToolMenuItem;

public class TGMainToolBarSectionLayout
extends TGMainToolBarSection {
    private UIToolMenuItem menuItem;
    private UIMenuActionItem pageLayout;
    private UIMenuActionItem linearLayout;
    private UIMenuActionItem multitrack;
    private UIMenuActionItem scoreEnabled;
    private UIMenuActionItem compact;

    public TGMainToolBarSectionLayout(TGMainToolBar toolBar) {
        super(toolBar);
    }

    public void createSection() {
        this.menuItem = this.getToolBar().getControl().createMenuItem();
        this.pageLayout = this.menuItem.getMenu().createActionItem();
        this.pageLayout.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-set-page"));
        this.linearLayout = this.menuItem.getMenu().createActionItem();
        this.linearLayout.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-set-linear"));
        this.multitrack = this.menuItem.getMenu().createActionItem();
        this.multitrack.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-set-multitrack"));
        this.scoreEnabled = this.menuItem.getMenu().createActionItem();
        this.scoreEnabled.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-set-score-enabled"));
        this.compact = this.menuItem.getMenu().createActionItem();
        this.compact.addSelectionListener((UISelectionListener)this.createActionProcessor("action.view.layout-set-compact"));
        this.loadIcons();
        this.loadProperties();
    }

    public void loadProperties() {
        TGLayout layout = this.getTablature().getViewLayout();
        int style = layout.getStyle();
        this.menuItem.setToolTipText(this.getText("view.layout"));
        this.pageLayout.setText(this.getText("view.layout.page", layout instanceof TGLayoutVertical));
        this.linearLayout.setText(this.getText("view.layout.linear", layout instanceof TGLayoutHorizontal));
        this.multitrack.setText(this.getText("view.layout.multitrack", (style & 2) != 0));
        this.scoreEnabled.setText(this.getText("view.layout.score-enabled", (style & 4) != 0));
        this.compact.setText(this.getText("view.layout.compact", (style & 1) != 0));
    }

    public void loadIcons() {
        this.menuItem.setImage(this.getIconManager().getLayoutScore());
        this.pageLayout.setImage(this.getIconManager().getLayoutPage());
        this.linearLayout.setImage(this.getIconManager().getLayoutLinear());
        this.multitrack.setImage(this.getIconManager().getLayoutMultitrack());
        this.scoreEnabled.setImage(this.getIconManager().getLayoutScore());
        this.compact.setImage(this.getIconManager().getLayoutCompact());
    }

    public void updateItems() {
        TGLayout layout = this.getTablature().getViewLayout();
        int style = layout.getStyle();
        this.pageLayout.setText(this.getText("view.layout.page", layout instanceof TGLayoutVertical));
        this.linearLayout.setText(this.getText("view.layout.linear", layout instanceof TGLayoutHorizontal));
        this.multitrack.setText(this.getText("view.layout.multitrack", (style & 2) != 0));
        this.scoreEnabled.setText(this.getText("view.layout.score-enabled", (style & 4) != 0));
        this.compact.setText(this.getText("view.layout.compact", (style & 1) != 0));
        this.compact.setEnabled((style & 2) == 0 || this.getSong().countTracks() == 1);
    }
}

