/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.chord;

import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.util.TGMusicKeyUtils;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordCreatorListener;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordCreatorUtil;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordDatabase;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordDialog;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordSettingsDialog;
import org.herac.tuxguitar.app.view.dialog.chord.TGChordSettingsHandler;
import org.herac.tuxguitar.song.models.TGChord;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UICursor;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UICheckBox;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIDropDownSelect;
import org.herac.tuxguitar.ui.widget.UILabel;
import org.herac.tuxguitar.ui.widget.UIListBoxSelect;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UISelectItem;
import org.herac.tuxguitar.ui.widget.UISeparator;
import org.herac.tuxguitar.ui.widget.UIToggleButton;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.TGException;
import org.herac.tuxguitar.util.TGSynchronizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGChordSelector {
    public static final String[][] KEY_NAMES = new String[][]{TGMusicKeyUtils.getSharpKeyNames("chord"), TGMusicKeyUtils.getFlatKeyNames("chord")};
    private TGChordDialog dialog;
    private int[] tuning;
    private UIPanel control;
    private UIListBoxSelect<Integer> tonicList;
    private UIListBoxSelect<Integer> chordList;
    private UIListBoxSelect<Integer> alterationList;
    private UIToggleButton sharpButton;
    private UIToggleButton flatButton;
    private UIDropDownSelect<Integer> bassCombo;
    private UICheckBox addCheck;
    private UIListBoxSelect<Integer> plusMinusList;
    private UIListBoxSelect<Integer> _5List;
    private UIListBoxSelect<Integer> _9List;
    private UIListBoxSelect<Integer> _11List;
    private boolean refresh;

    public TGChordSelector(TGChordDialog dialog, UIContainer parent, int[] tuning) {
        this.dialog = dialog;
        this.tuning = tuning;
        this.refresh = true;
        this.createControl(parent);
    }

    public void createControl(UIContainer parent) {
        UIFactory uiFactory = this.dialog.getUIFactory();
        UITableLayout uiLayout = new UITableLayout();
        this.control = uiFactory.createPanel(parent, true);
        this.control.setLayout((UILayout)uiLayout);
        UITableLayout tonicLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel tonicComposite = uiFactory.createPanel((UIContainer)this.control, false);
        tonicComposite.setLayout((UILayout)tonicLayout);
        uiLayout.set((UIControl)tonicComposite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.tonicList = uiFactory.createListBoxSelect((UIContainer)tonicComposite);
        tonicLayout.set(this.tonicList, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttonsComposite = uiFactory.createPanel((UIContainer)tonicComposite, false);
        buttonsComposite.setLayout((UILayout)buttonsLayout);
        tonicLayout.set((UIControl)buttonsComposite, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(false));
        this.sharpButton = uiFactory.createToggleButton((UIContainer)buttonsComposite);
        this.sharpButton.setText("#");
        buttonsLayout.set((UIControl)this.sharpButton, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        buttonsLayout.set((UIControl)this.sharpButton, "packed_width", (Object)Float.valueOf(28.0f));
        buttonsLayout.set((UIControl)this.sharpButton, "packed_height", (Object)Float.valueOf(28.0f));
        this.flatButton = uiFactory.createToggleButton((UIContainer)buttonsComposite);
        this.flatButton.setText("b");
        buttonsLayout.set((UIControl)this.flatButton, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(false), Boolean.valueOf(false));
        buttonsLayout.set((UIControl)this.flatButton, "packed_width", (Object)Float.valueOf(28.0f));
        buttonsLayout.set((UIControl)this.flatButton, "packed_height", (Object)Float.valueOf(28.0f));
        this.chordList = uiFactory.createListBoxSelect((UIContainer)this.control);
        uiLayout.set(this.chordList, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UISeparator separator = uiFactory.createHorizontalSeparator((UIContainer)tonicComposite);
        tonicLayout.set((UIControl)separator, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(true));
        UIButton customizeButton = uiFactory.createButton((UIContainer)tonicComposite);
        customizeButton.setText(TuxGuitar.getProperty("settings"));
        tonicLayout.set((UIControl)customizeButton, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(false));
        customizeButton.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGChordSettingsDialog settingsDialog = new TGChordSettingsDialog(TGChordSelector.this.dialog.getContext().getContext());
                settingsDialog.open(TGChordSelector.this.dialog.getWindow(), new TGChordSettingsHandler(){

                    public void onSettingsUpdated() {
                        TGSynchronizer.getInstance((TGContext)TGChordSelector.this.getDialog().getContext().getContext()).executeLater(new Runnable(){

                            public void run() throws TGException {
                                TGChordSelector.this.showChord();
                                TGChordSelector.this.getChordList().redraw();
                            }
                        });
                    }
                });
            }
        });
        this.initChordWidgets();
        this.insertTonicNames(true);
        for (int i = 0; i < TGChordDatabase.length(); ++i) {
            this.chordList.addItem(new UISelectItem(TGChordDatabase.get(i).getName(), (Object)i));
        }
        this.chordList.setSelectedValue((Object)0);
        String[] alterationNames = this.getAlterationNames();
        for (int i = 0; i < alterationNames.length; ++i) {
            this.alterationList.addItem(new UISelectItem(alterationNames[i], (Object)i));
        }
        this.alterationList.setSelectedValue((Object)0);
        String[] plusMinus = this.getPlusMinus("");
        for (int i = 0; i < plusMinus.length; ++i) {
            this.plusMinusList.addItem(new UISelectItem(plusMinus[i], (Object)i));
        }
        this.plusMinusList.setSelectedValue((Object)0);
        String[] plus5Minus = this.getPlusMinus("/5");
        for (int i = 0; i < plus5Minus.length; ++i) {
            this._5List.addItem(new UISelectItem(plus5Minus[i], (Object)i));
        }
        this._5List.setSelectedValue((Object)0);
        String[] plus9Minus = this.getPlusMinus("/9");
        for (int i = 0; i < plus9Minus.length; ++i) {
            this._9List.addItem(new UISelectItem(plus9Minus[i], (Object)i));
        }
        this._9List.setSelectedValue((Object)0);
        String[] plus11Minus = this.getPlusMinus("/11");
        for (int i = 0; i < plus11Minus.length; ++i) {
            this._11List.addItem(new UISelectItem(plus11Minus[i], (Object)i));
        }
        this._11List.setSelectedValue((Object)0);
        this.tonicList.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                if (TGChordSelector.this.getRefresh() && TGChordSelector.this.getDialog().getEditor() != null && TGChordSelector.this.getDialog().getList() != null) {
                    TGChordSelector.this.getBassCombo().setSelectedValue(TGChordSelector.this.getTonicList().getSelectedValue());
                    TGChordSelector.this.showChord();
                }
            }
        });
        this.bassCombo.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                if (TGChordSelector.this.getRefresh() && TGChordSelector.this.getDialog().getEditor() != null && TGChordSelector.this.getDialog().getList() != null) {
                    TGChordSelector.this.showChord();
                }
            }
        });
        this.chordList.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                if (TGChordSelector.this.getDialog().getEditor() != null && TGChordSelector.this.getDialog().getList() != null) {
                    TGChordSelector.this.adjustWidgetAvailability();
                    if (TGChordSelector.this.getRefresh()) {
                        TGChordSelector.this.showChord();
                    }
                }
            }
        });
        this.alterationList.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                if (TGChordSelector.this.getDialog().getEditor() != null && TGChordSelector.this.getDialog().getList() != null) {
                    TGChordSelector.this.adjustWidgetAvailability();
                    if (TGChordSelector.this.getRefresh()) {
                        TGChordSelector.this.showChord();
                    }
                }
            }
        });
        this.addCheck.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                if (TGChordSelector.this.getDialog().getEditor() != null && TGChordSelector.this.getDialog().getList() != null) {
                    TGChordSelector.this.adjustWidgetAvailability();
                    if (TGChordSelector.this.getRefresh()) {
                        TGChordSelector.this.showChord();
                    }
                }
            }
        });
        this._5List.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                if (TGChordSelector.this.getDialog().getEditor() != null && TGChordSelector.this.getDialog().getList() != null && TGChordSelector.this.getRefresh()) {
                    TGChordSelector.this.showChord();
                }
            }
        });
        this._9List.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                if (TGChordSelector.this.getDialog().getEditor() != null && TGChordSelector.this.getDialog().getList() != null && TGChordSelector.this.getRefresh()) {
                    TGChordSelector.this.showChord();
                }
            }
        });
        this._11List.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                if (TGChordSelector.this.getDialog().getEditor() != null && TGChordSelector.this.getDialog().getList() != null && TGChordSelector.this.getRefresh()) {
                    TGChordSelector.this.showChord();
                }
            }
        });
        this.plusMinusList.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                if (TGChordSelector.this.getDialog().getEditor() != null && TGChordSelector.this.getDialog().getList() != null && TGChordSelector.this.getRefresh()) {
                    TGChordSelector.this.showChord();
                }
            }
        });
        this.sharpButton.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGChordSelector.this.insertTonicNames(true);
            }
        });
        this.flatButton.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                TGChordSelector.this.insertTonicNames(false);
            }
        });
        this.adjustWidgetAvailability();
    }

    protected void initChordWidgets() {
        UIFactory uiFactory = this.dialog.getUIFactory();
        UITableLayout alterationLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel alterationComposite = uiFactory.createPanel((UIContainer)this.control, false);
        alterationComposite.setLayout((UILayout)alterationLayout);
        UITableLayout controlLayout = (UITableLayout)this.control.getLayout();
        controlLayout.set((UIControl)alterationComposite, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout aboveLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel aboveComposite = uiFactory.createPanel((UIContainer)alterationComposite, false);
        aboveComposite.setLayout((UILayout)aboveLayout);
        alterationLayout.set((UIControl)aboveComposite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout firstLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel firstComposite = uiFactory.createPanel((UIContainer)aboveComposite, false);
        firstComposite.setLayout((UILayout)firstLayout);
        aboveLayout.set((UIControl)firstComposite, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.alterationList = uiFactory.createListBoxSelect((UIContainer)firstComposite);
        firstLayout.set(this.alterationList, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this.plusMinusList = uiFactory.createListBoxSelect((UIContainer)firstComposite);
        firstLayout.set(this.plusMinusList, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout secondLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel secondComposite = uiFactory.createPanel((UIContainer)aboveComposite, false);
        secondComposite.setLayout((UILayout)secondLayout);
        aboveLayout.set((UIControl)secondComposite, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this._5List = uiFactory.createListBoxSelect((UIContainer)secondComposite);
        secondLayout.set(this._5List, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this._9List = uiFactory.createListBoxSelect((UIContainer)secondComposite);
        secondLayout.set(this._9List, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        this._11List = uiFactory.createListBoxSelect((UIContainer)secondComposite);
        secondLayout.set(this._11List, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        UITableLayout bassLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel bassComposite = uiFactory.createPanel((UIContainer)alterationComposite, false);
        bassComposite.setLayout((UILayout)bassLayout);
        alterationLayout.set((UIControl)bassComposite, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(true));
        this.addCheck = uiFactory.createCheckBox((UIContainer)bassComposite);
        this.addCheck.setText("add");
        bassLayout.set((UIControl)this.addCheck, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(true));
        UISeparator separator = uiFactory.createHorizontalSeparator((UIContainer)bassComposite);
        bassLayout.set((UIControl)separator, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(true));
        UILabel bText = uiFactory.createLabel((UIContainer)bassComposite);
        bText.setText(TuxGuitar.getProperty("chord.bass"));
        bassLayout.set((UIControl)bText, Integer.valueOf(3), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(false));
        this.bassCombo = uiFactory.createDropDownSelect((UIContainer)bassComposite);
        bassLayout.set(this.bassCombo, Integer.valueOf(4), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_BOTTOM, Boolean.valueOf(true), Boolean.valueOf(false));
    }

    protected void insertTonicNames(boolean sharp) {
        String[] names = KEY_NAMES[sharp ? 0 : 1];
        this.flatButton.setSelected(!sharp);
        this.sharpButton.setSelected(sharp);
        int indexL = this.toInt((Integer)this.tonicList.getSelectedValue(), 0);
        int indexC = this.toInt((Integer)this.bassCombo.getSelectedValue(), 0);
        this.tonicList.removeItems();
        this.bassCombo.removeItems();
        for (int i = 0; i < names.length; ++i) {
            this.tonicList.addItem(new UISelectItem(names[i], (Object)i));
            this.bassCombo.addItem(new UISelectItem(names[i], (Object)i));
        }
        this.tonicList.setSelectedValue((Object)indexL);
        this.bassCombo.setSelectedValue((Object)indexC);
    }

    private String[] getPlusMinus(String text) {
        String[] names = new String[]{" ", text + "+", text + "-"};
        return names;
    }

    private String[] getAlterationNames() {
        String[] names = new String[]{" ", "9", "11", "13"};
        return names;
    }

    protected void showChord() {
        this.loadCursor(UICursor.WAIT);
        TGChordCreatorListener listener = new TGChordCreatorListener(){

            @Override
            public void notifyChords(final TGChordCreatorUtil instance, final List<TGChord> chords) {
                TGSynchronizer.getInstance((TGContext)TGChordSelector.this.getDialog().getContext().getContext()).executeLater(new Runnable(){

                    public void run() {
                        if (instance.isValidProcess() && !TGChordSelector.this.getDialog().isDisposed()) {
                            TGChordSelector.this.getDialog().getList().setChords(chords);
                            TGChordSelector.this.loadCursor(UICursor.NORMAL);
                        }
                    }
                });
            }
        };
        TGChordCreatorUtil.getChords(listener, this.tuning, this.toInt((Integer)this.chordList.getSelectedValue()), this.toInt((Integer)this.alterationList.getSelectedValue()), this.toInt((Integer)this.plusMinusList.getSelectedValue()), this.addCheck.isSelected(), this.toInt((Integer)this._5List.getSelectedValue()), this.toInt((Integer)this._9List.getSelectedValue()), this.toInt((Integer)this._11List.getSelectedValue()), this.toInt((Integer)this.bassCombo.getSelectedValue()), this.toInt((Integer)this.tonicList.getSelectedValue()), this.sharpButton.isSelected());
    }

    protected void updateWidget(UIListBoxSelect<Integer> widget, boolean enabled) {
        widget.setEnabled(enabled);
        if (!enabled) {
            widget.setSelectedValue((Object)0);
        }
    }

    protected void updateWidget(UICheckBox widget, boolean enabled) {
        widget.setEnabled(enabled);
        if (!enabled) {
            widget.setSelected(false);
        }
    }

    public void adjustWidgets(int tonic, int chordBasic, int alteration, int bass, int plusMinus, int addBoolean, int index5, int index9, int index11) {
        this.setRefresh(false);
        this.tonicList.setSelectedValue((Object)tonic);
        this.alterationList.setSelectedValue((Object)alteration);
        this.bassCombo.setSelectedValue((Object)bass);
        this.plusMinusList.setSelectedValue((Object)plusMinus);
        this.addCheck.setSelected(addBoolean != 0);
        this._5List.setSelectedValue((Object)index5);
        this._9List.setSelectedValue((Object)index9);
        this._11List.setSelectedValue((Object)index11);
        this.chordList.setSelectedValue((Object)chordBasic);
        this.adjustWidgetAvailability();
        this.setRefresh(true);
        this.showChord();
    }

    protected void adjustWidgetAvailability() {
        String chordName;
        Integer chordIndex = (Integer)this.getChordList().getSelectedValue();
        String string = chordName = chordIndex != null ? TGChordDatabase.get(chordIndex).getName() : null;
        if (chordName != null && (chordName.equals("dim") || chordName.equals("dim7") || chordName.equals("aug") || chordName.equals("5"))) {
            this.updateWidget(this.getAlterationList(), false);
            this.updateWidget(this.getAddCheck(), false);
            this.updateWidget(this.get_9List(), false);
            this.updateWidget(this.get_11List(), false);
            this.updateWidget(this.getPlusMinusList(), false);
            if (!chordName.equals("5")) {
                this.updateWidget(this.get_5List(), false);
            } else {
                this.updateWidget(this.get_5List(), true);
            }
        } else {
            this.updateWidget(this.getAlterationList(), true);
            this.updateWidget(this.get_5List(), true);
        }
        if (this.alterationList.isEnabled()) {
            int currentIndex = this.toInt((Integer)this.alterationList.getSelectedValue());
            this.updateWidget(this.plusMinusList, currentIndex > 0);
            this.updateWidget(this.addCheck, currentIndex > 0);
            this.updateWidget(this._9List, currentIndex >= 2 && !this.addCheck.isSelected());
            this.updateWidget(this._11List, currentIndex >= 3 && !this.addCheck.isSelected());
        }
    }

    public int toInt(Integer integer) {
        return this.toInt(integer, -1);
    }

    public int toInt(Integer integer, int nullValue) {
        return integer != null ? integer : nullValue;
    }

    public void loadCursor(UICursor cursor) {
        this.dialog.loadCursor(cursor);
    }

    public boolean getRefresh() {
        return this.refresh;
    }

    public void setRefresh(boolean refresh) {
        this.refresh = refresh;
    }

    public void setTuning(int[] tuning) {
        this.tuning = tuning;
    }

    public int[] getTuning() {
        return this.tuning;
    }

    public TGChordDialog getDialog() {
        return this.dialog;
    }

    public UIPanel getControl() {
        return this.control;
    }

    public UIListBoxSelect<Integer> getTonicList() {
        return this.tonicList;
    }

    public UIListBoxSelect<Integer> getChordList() {
        return this.chordList;
    }

    public UIListBoxSelect<Integer> getAlterationList() {
        return this.alterationList;
    }

    public UIToggleButton getSharpButton() {
        return this.sharpButton;
    }

    public UIToggleButton getFlatButton() {
        return this.flatButton;
    }

    public UIDropDownSelect<Integer> getBassCombo() {
        return this.bassCombo;
    }

    public UICheckBox getAddCheck() {
        return this.addCheck;
    }

    public UIListBoxSelect<Integer> getPlusMinusList() {
        return this.plusMinusList;
    }

    public UIListBoxSelect<Integer> get_5List() {
        return this._5List;
    }

    public UIListBoxSelect<Integer> get_9List() {
        return this._9List;
    }

    public UIListBoxSelect<Integer> get_11List() {
        return this._11List;
    }
}

