/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.midi.synth;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.midi.synth.TGProgram;
import org.herac.tuxguitar.midi.synth.TGSynthChannel;
import org.herac.tuxguitar.midi.synth.TGSynthSettings;
import org.herac.tuxguitar.midi.synth.TGSynthThread;
import org.herac.tuxguitar.player.base.MidiChannel;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.base.MidiSynthesizer;
import org.herac.tuxguitar.util.TGContext;

public class TGSynthesizer
implements MidiSynthesizer {
    public static final int BANKS_LENGTH = 129;
    public static final int PROGRAMS_LENGTH = 128;
    private TGContext context;
    private List<TGSynthChannel> channels;
    private TGProgram[][] programs;
    private TGSynthThread synthesizerThread;
    private TGSynthSettings settings;

    public TGSynthesizer(TGContext context) {
        this.context = context;
        this.settings = new TGSynthSettings(this.context);
        this.synthesizerThread = new TGSynthThread(this);
        this.channels = new ArrayList<TGSynthChannel>();
        this.programs = new TGProgram[129][128];
        for (int b = 0; b < 129; ++b) {
            for (int p = 0; p < 128; ++p) {
                this.programs[b][p] = new TGProgram();
            }
        }
    }

    public boolean isOpen() {
        return this.synthesizerThread.isRunning();
    }

    public void open() throws MidiPlayerException {
        this.settings.loadPrograms(this);
        this.synthesizerThread.start();
    }

    public void close() throws MidiPlayerException {
        if (this.isOpen()) {
            this.synthesizerThread.stop();
            this.closeChannels();
        }
    }

    public MidiChannel openChannel(int channelId) throws MidiPlayerException {
        TGSynthChannel vstChannel = new TGSynthChannel(this, channelId);
        this.channels.add(vstChannel);
        return vstChannel;
    }

    public void closeChannel(MidiChannel midiChannel) throws MidiPlayerException {
        TGSynthChannel tgChannel = (TGSynthChannel)midiChannel;
        tgChannel.closeProcessor();
        this.channels.remove(tgChannel);
    }

    public boolean isChannelOpen(MidiChannel midiChannel) throws MidiPlayerException {
        return true;
    }

    public void closeChannels() throws MidiPlayerException {
        while (this.countChannels() > 0) {
            this.closeChannel(this.getChannel(0));
        }
    }

    public TGSynthChannel getChannel(int index) {
        if (index >= 0 && index < this.countChannels()) {
            return this.channels.get(index);
        }
        return null;
    }

    public TGSynthChannel getChannelById(int channelId) {
        for (TGSynthChannel channel : this.channels) {
            if (channel.getId() != channelId) continue;
            return channel;
        }
        return null;
    }

    public int countChannels() {
        return this.channels.size();
    }

    public TGProgram getProgram(int bank, int program) {
        if (bank >= 0 && bank < this.programs.length && program >= 0 && program < this.programs[bank].length) {
            return this.programs[bank][program];
        }
        return null;
    }

    public TGSynthSettings getSettings() {
        return this.settings;
    }

    public TGContext getContext() {
        return this.context;
    }
}

