/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.tools.custom.tuner;

import craigl.spectrumanalyzer.FFT;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.TargetDataLine;
import org.herac.tuxguitar.app.tools.custom.tuner.TGTunerListener;
import org.herac.tuxguitar.app.tools.custom.tuner.TGTunerQueue;
import org.herac.tuxguitar.app.tools.custom.tuner.TGTunerSettings;

public class TGTuner
extends Thread {
    protected TGTunerListener mainWindow = null;
    protected boolean canceled;
    protected boolean paused;
    protected TGTunerSettings settings;
    protected TargetDataLine dataLine;
    protected TGTunerQueue queue;
    protected FFT fft;
    protected double[] ar;
    protected double[] ai;
    protected byte[] data;
    protected double rate;
    protected double maximumFrequency;
    protected double minimumFrequency;

    TGTuner(TGTunerListener mainWindow) {
        this.mainWindow = mainWindow;
        this.canceled = false;
        this.paused = false;
        this.queue = new TGTunerQueue();
        try {
            this.settings = TGTunerSettings.loadTuxGuitarSettings();
            this.dataLine = TGTunerSettings.getDataLine(this.settings);
        }
        catch (Exception ex) {
            this.mainWindow.fireException(ex);
        }
        this.setWantedRange();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int cycles = 0;
        long timePassed = 0L;
        if (this.dataLine != null) {
            this.openDataLine();
        }
        while (!this.canceled) {
            if (this.dataLine != null && !this.paused && this.dataLine.isOpen()) {
                TGTuner tGTuner = this;
                synchronized (tGTuner) {
                    int i;
                    this.dataLine.read(this.data, 0, this.settings.getBufferSize());
                    for (i = 0; i < this.settings.getBufferSize(); ++i) {
                        this.ar[i] = this.data[i];
                        this.ai[i] = 0.0;
                    }
                    for (i = this.settings.getBufferSize(); i < this.settings.getFFTSize(); ++i) {
                        this.ar[i] = 0.0;
                        this.ai[i] = 0.0;
                    }
                    ++cycles;
                    long startTime = System.currentTimeMillis();
                    if (this.fft != null) {
                        this.fft.doFFT(this.ar, this.ai, false);
                    }
                    timePassed += System.currentTimeMillis() - startTime;
                    double frequency = -1.0;
                    double maxAmplitude = this.settings.getThreshold();
                    int i2 = (int)Math.round(this.minimumFrequency / this.rate);
                    while ((long)i2 < Math.round(this.maximumFrequency / this.rate)) {
                        double curFreq = (double)i2 * this.rate;
                        double power = Math.sqrt(Math.pow(this.ar[i2], 2.0) + Math.pow(this.ai[i2], 2.0));
                        if (power > maxAmplitude) {
                            maxAmplitude = power;
                            frequency = curFreq;
                        }
                        ++i2;
                    }
                    this.queue.add(frequency);
                    this.mainWindow.fireFrequency(this.queue.getFreqApproximation());
                    this.dataLine.flush();
                }
            }
            try {
                Thread.sleep(this.settings.getWaitPeriod());
            }
            catch (InterruptedException interruptedException) {}
        }
        this.closeDataLine();
        System.out.println(" Average FFT time: " + (double)timePassed / (double)cycles);
    }

    protected void computeFFTParams() {
        if (this.settings != null) {
            int number = this.settings.getFFTSize();
            int log = 0;
            for (int i = 0; i < 20; ++i) {
                if ((number /= 2) < 1) {
                    this.fft = new FFT(log);
                    break;
                }
                ++log;
            }
            this.data = new byte[this.settings.getBufferSize()];
            this.ar = new double[this.settings.getFFTSize()];
            this.ai = new double[this.settings.getFFTSize()];
            this.rate = (double)this.settings.getSampleRate() / (double)this.settings.getFFTSize();
        }
    }

    public void setCanceled(boolean canceled) {
        this.canceled = canceled;
    }

    public void pause() {
        this.paused = true;
    }

    public void resumeFromPause() {
        this.paused = false;
        this.queue.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSettings(TGTunerSettings settings) {
        this.closeDataLine();
        TGTuner tGTuner = this;
        synchronized (tGTuner) {
            this.settings = settings;
            try {
                this.dataLine = TGTunerSettings.getDataLine(settings);
            }
            catch (Exception ex) {
                this.mainWindow.fireException(ex);
            }
        }
        this.openDataLine();
    }

    public TGTunerSettings getSettings() {
        return this.settings;
    }

    public void setWantedNote(int note) {
        this.minimumFrequency = this.getNoteFrequency(note - 3);
        this.maximumFrequency = this.getNoteFrequency(note + 3);
    }

    public void setWantedRange() {
        int[] tuning = this.mainWindow.getTuning();
        this.maximumFrequency = this.getNoteFrequency(tuning[0] + 3);
        this.minimumFrequency = this.getNoteFrequency(tuning[tuning.length - 1] - 3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDataLine() {
        if (this.dataLine != null) {
            TGTuner tGTuner = this;
            synchronized (tGTuner) {
                this.computeFFTParams();
                try {
                    this.dataLine.open();
                    this.dataLine.start();
                }
                catch (LineUnavailableException e) {
                    System.out.println("------- TGTuner: openDataLine() exception -------");
                    e.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeDataLine() {
        TGTuner tGTuner = this;
        synchronized (tGTuner) {
            if (this.dataLine != null) {
                this.dataLine.stop();
                this.dataLine.close();
            }
        }
    }

    public double getNoteFrequency(int midiNote) {
        return 110.0 * Math.pow(2.0, (double)(midiNote - 45) / 12.0);
    }

    public static void computeFFT(int sign, int n, double[] ar, double[] ai) {
        int i;
        double scale = 2.0 / (double)n;
        int j = 0;
        for (i = 0; i < n; ++i) {
            int m;
            if (j >= i) {
                double tempr = ar[j] * scale;
                double tempi = ai[j] * scale;
                ar[j] = ar[i] * scale;
                ai[j] = ai[i] * scale;
                ar[i] = tempr;
                ai[i] = tempi;
            }
            for (m = n / 2; m >= 1 && j >= m; j -= m, m /= 2) {
            }
            j += m;
        }
        int mmax = 1;
        int istep = 2 * mmax;
        while (mmax < n) {
            double delta = (double)sign * Math.PI / (double)mmax;
            for (int m = 0; m < mmax; ++m) {
                double w = (double)m * delta;
                double wr = Math.cos(w);
                double wi = Math.sin(w);
                for (i = m; i < n; i += istep) {
                    j = i + mmax;
                    double tr = wr * ar[j] - wi * ai[j];
                    double ti = wr * ai[j] + wi * ar[j];
                    ar[j] = ar[i] - tr;
                    ai[j] = ai[i] - ti;
                    int n2 = i;
                    ar[n2] = ar[n2] + tr;
                    int n3 = i;
                    ai[n3] = ai[n3] + ti;
                }
            }
            mmax = istep;
            mmax = istep;
            istep = 2 * mmax;
        }
    }

    static class TGTunerException
    extends Exception {
        private static final long serialVersionUID = -1860514279319403845L;

        public TGTunerException(String string) {
            super(string);
        }
    }
}

