/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.cocoa.NSAttributedString;
import org.eclipse.swt.internal.cocoa.NSObject;
import org.eclipse.swt.internal.cocoa.NSRect;
import org.eclipse.swt.internal.cocoa.NSSize;
import org.eclipse.swt.internal.cocoa.NSString;
import org.eclipse.swt.internal.cocoa.NSTableColumn;
import org.eclipse.swt.internal.cocoa.NSTableView;
import org.eclipse.swt.internal.cocoa.NSTextFieldCell;
import org.eclipse.swt.internal.cocoa.OS;
import org.eclipse.swt.internal.cocoa.objc_super;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;

public class TableItem
extends Item {
    Table parent;
    String[] strings;
    Image[] images;
    boolean checked;
    boolean grayed;
    boolean cached;
    Color foreground;
    Color background;
    Color[] cellForeground;
    Color[] cellBackground;
    Font font;
    Font[] cellFont;
    int width = -1;

    public TableItem(Table table, int n) {
        this(table, n, TableItem.checkNull(table).getItemCount(), true);
    }

    public TableItem(Table table, int n, int n2) {
        this(table, n, n2, true);
    }

    TableItem(Table table, int n, int n2, boolean bl) {
        super(table, n);
        this.parent = table;
        if (bl) {
            table.createItem(this, n2);
        }
    }

    static Table checkNull(Table table) {
        if (table == null) {
            SWT.error(4);
        }
        return table;
    }

    int calculateWidth(int n, GC gC, boolean bl) {
        Object object;
        String string;
        if (n == 0 && this.width != -1) {
            return this.width;
        }
        Font font = null;
        if (this.cellFont != null) {
            font = this.cellFont[n];
        }
        if (font == null) {
            font = this.font;
        }
        if (font == null) {
            font = this.parent.font;
        }
        if (font == null) {
            font = this.parent.defaultFont();
        }
        String string2 = n == 0 ? this.text : (string = this.strings == null ? "" : this.strings[n]);
        Image image = n == 0 ? this.image : (this.images == null ? null : this.images[n]);
        NSTextFieldCell nSTextFieldCell = this.parent.dataCell;
        if (font.extraTraits != 0) {
            object = this.parent.createString(string, font, null, 0, false, true, false);
            nSTextFieldCell.setAttributedStringValue((NSAttributedString)object);
            ((NSObject)object).release();
        } else {
            nSTextFieldCell.setFont(font.handle);
            object = (NSString)new NSString().alloc();
            object = ((NSString)object).initWithString(string != null ? string : "");
            nSTextFieldCell.setTitle((NSString)object);
            ((NSObject)object).release();
        }
        object = new objc_super();
        ((objc_super)object).receiver = nSTextFieldCell.id;
        ((objc_super)object).super_class = OS.objc_msgSend(nSTextFieldCell.id, OS.sel_superclass);
        NSSize nSSize = new NSSize();
        OS.objc_msgSendSuper_stret(nSSize, (objc_super)object, OS.sel_cellSize);
        if (image != null) {
            nSSize.width += (double)(this.parent.imageBounds.width + 3);
        }
        int n2 = (int)Math.ceil(nSSize.width);
        boolean bl2 = true;
        if ((this.parent.style & 0x10000000) != 0) {
            bl2 = this.cached;
        }
        if (bl2 && this.parent.hooks(41)) {
            gC.setFont(font);
            Event event = new Event();
            event.item = this;
            event.index = n;
            event.gc = gC;
            NSTableView nSTableView = (NSTableView)this.parent.view;
            int n3 = (int)nSTableView.rowHeight();
            event.width = n2;
            event.height = n3;
            if (bl && ((this.parent.style & 0x8000) == 0 || this.parent.hasFocus())) {
                event.detail |= 2;
            }
            this.parent.sendEvent(41, event);
            if (n3 < event.height) {
                nSTableView.setRowHeight(event.height);
                nSTableView.setNeedsDisplay(true);
            }
            n2 = event.width;
        }
        if (n == 0) {
            this.width = n2;
        }
        return n2;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void clear() {
        this.text = "";
        this.image = null;
        this.strings = null;
        this.images = null;
        this.cached = false;
        this.grayed = false;
        this.checked = false;
        this.background = null;
        this.foreground = null;
        this.cellBackground = null;
        this.cellForeground = null;
        this.font = null;
        this.cellFont = null;
        this.width = -1;
    }

    NSObject createString(int n) {
        String string = n == 0 ? this.text : (this.strings == null ? "" : this.strings[n]);
        return NSString.stringWith(string != null ? string : "");
    }

    @Override
    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Color getBackground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.background != null ? this.background : this.parent.getBackground();
    }

    public Color getBackground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (0 > n || n > n2 - 1) {
            return this.getBackground();
        }
        if (this.cellBackground == null || this.cellBackground[n] == null) {
            return this.getBackground();
        }
        return this.cellBackground[n];
    }

    public Rectangle getBounds() {
        Object object;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        NSTableView nSTableView = (NSTableView)this.parent.view;
        int n = this.parent.indexOf(this);
        NSTableColumn nSTableColumn = this.parent.columnCount == 0 ? this.parent.firstColumn : this.parent.columns[0].nsColumn;
        int n2 = this.parent.indexOf(nSTableColumn);
        NSRect nSRect = nSTableView.frameOfCellAtColumn(n2, n);
        if (this.image != null) {
            nSRect.x += (double)(this.parent.imageBounds.width + 3);
        }
        Font font = null;
        if (this.cellFont != null) {
            font = this.cellFont[n2];
        }
        if (font == null) {
            font = this.font;
        }
        if (font == null) {
            font = this.parent.font;
        }
        if (font == null) {
            font = this.parent.defaultFont();
        }
        NSTextFieldCell nSTextFieldCell = this.parent.dataCell;
        nSTextFieldCell.setImage(null);
        if (font.extraTraits != 0) {
            object = this.parent.createString(this.text, font, null, 0, false, true, false);
            nSTextFieldCell.setAttributedStringValue((NSAttributedString)object);
            ((NSObject)object).release();
        } else {
            nSTextFieldCell.setFont(font.handle);
            object = (NSString)new NSString().alloc();
            object = ((NSString)object).initWithString(this.text);
            nSTextFieldCell.setTitle((NSString)object);
            ((NSObject)object).release();
        }
        object = new objc_super();
        ((objc_super)object).receiver = nSTextFieldCell.id;
        ((objc_super)object).super_class = OS.objc_msgSend(nSTextFieldCell.id, OS.sel_superclass);
        NSSize nSSize = new NSSize();
        OS.objc_msgSendSuper_stret(nSSize, (objc_super)object, OS.sel_cellSize);
        NSRect nSRect2 = nSTableView.rectOfColumn(n2);
        nSSize.width = Math.min(nSSize.width, nSRect2.width - (nSRect.x - nSRect2.x));
        return new Rectangle((int)nSRect.x, (int)nSRect.y, (int)Math.ceil(nSSize.width), (int)Math.ceil(nSRect.height));
    }

    public Rectangle getBounds(int n) {
        Object object;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (0 > n || n >= Math.max(1, this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        NSTableView nSTableView = (NSTableView)this.parent.view;
        if (this.parent.columnCount == 0) {
            n = (this.parent.style & 0x20) != 0 ? 1 : 0;
        } else {
            object = this.parent.getColumn(n);
            n = this.parent.indexOf(((TableColumn)object).nsColumn);
        }
        object = nSTableView.frameOfCellAtColumn(n, this.parent.indexOf(this));
        return new Rectangle((int)((NSRect)object).x, (int)((NSRect)object).y, (int)((NSRect)object).width, (int)((NSRect)object).height);
    }

    public boolean getChecked() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.checked;
    }

    public Font getFont() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.font != null ? this.font : this.parent.getFont();
    }

    public Font getFont(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (0 > n || n > n2 - 1) {
            return this.getFont();
        }
        if (this.cellFont == null || this.cellFont[n] == null) {
            return this.getFont();
        }
        return this.cellFont[n];
    }

    public Color getForeground() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return this.foreground != null ? this.foreground : this.parent.getForeground();
    }

    public Color getForeground(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (0 > n || n > n2 - 1) {
            return this.getForeground();
        }
        if (this.cellForeground == null || this.cellForeground[n] == null) {
            return this.getForeground();
        }
        return this.cellForeground[n];
    }

    public boolean getGrayed() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if ((this.parent.style & 0x20) == 0) {
            return false;
        }
        return this.grayed;
    }

    @Override
    public Image getImage() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return super.getImage();
    }

    public Image getImage(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (n == 0) {
            return this.getImage();
        }
        if (this.images != null && 0 <= n && n < this.images.length) {
            return this.images[n];
        }
        return null;
    }

    public Rectangle getImageBounds(int n) {
        Object object;
        Image image;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (0 > n || n >= Math.max(1, this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        NSTableView nSTableView = (NSTableView)this.parent.view;
        Image image2 = n == 0 ? this.image : (image = this.images != null ? this.images[n] : null);
        if (this.parent.columnCount == 0) {
            n = (this.parent.style & 0x20) != 0 ? 1 : 0;
        } else {
            object = this.parent.getColumn(n);
            n = this.parent.indexOf(((TableColumn)object).nsColumn);
        }
        object = nSTableView.frameOfCellAtColumn(n, this.parent.indexOf(this));
        ((NSRect)object).x += 3.0;
        ((NSRect)object).width = image != null ? (double)this.parent.imageBounds.width : 0.0;
        return new Rectangle((int)((NSRect)object).x, (int)((NSRect)object).y, (int)((NSRect)object).width, (int)((NSRect)object).height);
    }

    public int getImageIndent() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return 0;
    }

    @Override
    String getNameText() {
        if ((this.parent.style & 0x10000000) != 0 && !this.cached) {
            return "*virtual*";
        }
        return super.getNameText();
    }

    public Table getParent() {
        this.checkWidget();
        return this.parent;
    }

    @Override
    public String getText() {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        return super.getText();
    }

    public String getText(int n) {
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (n == 0) {
            return this.getText();
        }
        if (this.strings != null && 0 <= n && n < this.strings.length) {
            String string = this.strings[n];
            return string != null ? string : "";
        }
        return "";
    }

    public Rectangle getTextBounds(int n) {
        Object object;
        Image image;
        this.checkWidget();
        if (!this.parent.checkData(this)) {
            this.error(24);
        }
        if (0 > n || n >= Math.max(1, this.parent.columnCount)) {
            return new Rectangle(0, 0, 0, 0);
        }
        NSTableView nSTableView = (NSTableView)this.parent.view;
        Image image2 = n == 0 ? this.image : (image = this.images != null ? this.images[n] : null);
        if (this.parent.columnCount == 0) {
            n = (this.parent.style & 0x20) != 0 ? 1 : 0;
        } else {
            object = this.parent.getColumn(n);
            n = this.parent.indexOf(((TableColumn)object).nsColumn);
        }
        object = nSTableView.frameOfCellAtColumn(n, this.parent.indexOf(this));
        ((NSRect)object).x += 2.0;
        ((NSRect)object).width -= 2.0;
        if (image != null) {
            int n2 = this.parent.imageBounds.width + 3;
            ((NSRect)object).x += (double)n2;
            ((NSRect)object).width -= (double)n2;
        }
        return new Rectangle((int)((NSRect)object).x, (int)((NSRect)object).y, (int)((NSRect)object).width, (int)((NSRect)object).height);
    }

    @Override
    boolean isDrawing() {
        return this.getDrawing() && this.parent.isDrawing();
    }

    void redraw(int n) {
        if (this.parent.currentItem == this || !this.isDrawing()) {
            return;
        }
        NSTableView nSTableView = (NSTableView)this.parent.view;
        NSRect nSRect = null;
        if (n == -1 || this.parent.hooks(41) || this.parent.hooks(40) || this.parent.hooks(42)) {
            nSRect = nSTableView.rectOfRow(this.parent.indexOf(this));
        } else {
            int n2;
            if (this.parent.columnCount == 0) {
                n2 = (this.parent.style & 0x20) != 0 ? 1 : 0;
            } else if (0 <= n && n < this.parent.columnCount) {
                n2 = this.parent.indexOf(this.parent.columns[n].nsColumn);
            } else {
                return;
            }
            nSRect = nSTableView.frameOfCellAtColumn(n2, this.parent.indexOf(this));
        }
        nSTableView.setNeedsDisplayInRect(nSRect);
    }

    @Override
    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    @Override
    void releaseParent() {
        super.releaseParent();
    }

    @Override
    void releaseWidget() {
        super.releaseWidget();
        this.strings = null;
        this.images = null;
        this.foreground = null;
        this.background = null;
        this.font = null;
        this.cellForeground = null;
        this.cellBackground = null;
        this.cellFont = null;
    }

    public void setBackground(Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if ((color2 = this.background) == color) {
            return;
        }
        this.background = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(-1);
    }

    public void setBackground(int n, Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (0 > n || n > n2 - 1) {
            return;
        }
        if (this.cellBackground == null) {
            if (color == null) {
                return;
            }
            this.cellBackground = new Color[n2];
        }
        if ((color2 = this.cellBackground[n]) == color) {
            return;
        }
        this.cellBackground[n] = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(n);
    }

    public void setChecked(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.checked == bl) {
            return;
        }
        this.checked = bl;
        this.cached = true;
        this.redraw(-1);
    }

    public void setFont(Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        if ((font2 = this.font) == font) {
            return;
        }
        this.font = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        this.width = -1;
        this.cached = true;
        this.redraw(-1);
    }

    public void setFont(int n, Font font) {
        Font font2;
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (0 > n || n > n2 - 1) {
            return;
        }
        if (this.cellFont == null) {
            if (font == null) {
                return;
            }
            this.cellFont = new Font[n2];
        }
        if ((font2 = this.cellFont[n]) == font) {
            return;
        }
        this.cellFont[n] = font;
        if (font2 != null && font2.equals(font)) {
            return;
        }
        this.width = -1;
        this.cached = true;
        this.redraw(n);
    }

    public void setForeground(Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        if ((color2 = this.foreground) == color) {
            return;
        }
        this.foreground = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(-1);
    }

    public void setForeground(int n, Color color) {
        Color color2;
        this.checkWidget();
        if (color != null && color.isDisposed()) {
            this.error(5);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (0 > n || n > n2 - 1) {
            return;
        }
        if (this.cellForeground == null) {
            if (color == null) {
                return;
            }
            this.cellForeground = new Color[n2];
        }
        if ((color2 = this.cellForeground[n]) == color) {
            return;
        }
        this.cellForeground[n] = color;
        if (color2 != null && color2.equals(color)) {
            return;
        }
        this.cached = true;
        this.redraw(n);
    }

    public void setGrayed(boolean bl) {
        this.checkWidget();
        if ((this.parent.style & 0x20) == 0) {
            return;
        }
        if (this.grayed == bl) {
            return;
        }
        this.grayed = bl;
        this.cached = true;
        this.redraw(-1);
    }

    public void setImage(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(4);
        }
        for (int i = 0; i < imageArray.length; ++i) {
            this.setImage(i, imageArray[i]);
        }
    }

    public void setImage(int n, Image image) {
        int n2;
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        if ((n2 = this.parent.indexOf(this)) == -1) {
            return;
        }
        if (this.parent.imageBounds == null && image != null) {
            this.parent.setItemHeight(image, null, false);
        }
        if (n == 0) {
            if (image != null && image.type == 1 && image.equals(this.image)) {
                return;
            }
            this.width = -1;
            super.setImage(image);
        }
        int n3 = Math.max(1, this.parent.columnCount);
        if (0 <= n && n < n3) {
            if (this.images == null) {
                this.images = new Image[n3];
            }
            if (image != null && image.type == 1 && image.equals(this.images[n])) {
                return;
            }
            this.images[n] = image;
        }
        this.cached = true;
        if (n == 0) {
            this.parent.setScrollWidth(this);
        }
        this.redraw(n);
    }

    @Override
    public void setImage(Image image) {
        this.checkWidget();
        this.setImage(0, image);
    }

    @Deprecated
    public void setImageIndent(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        this.cached = true;
    }

    public void setText(String[] stringArray) {
        this.checkWidget();
        if (stringArray == null) {
            this.error(4);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            if (string == null) continue;
            this.setText(i, string);
        }
    }

    public void setText(int n, String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (n == 0) {
            if (string.equals(this.text)) {
                return;
            }
            this.width = -1;
            super.setText(string);
        }
        int n2 = Math.max(1, this.parent.columnCount);
        if (0 <= n && n < n2) {
            if (this.strings == null) {
                this.strings = new String[n2];
            }
            if (string.equals(this.strings[n])) {
                return;
            }
            this.strings[n] = string;
        }
        this.cached = true;
        if (n == 0) {
            this.parent.setScrollWidth(this);
        }
        this.redraw(n);
    }

    @Override
    public void setText(String string) {
        this.checkWidget();
        this.setText(0, string);
    }
}

