/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ExpandListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandItem;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ScrollBar;
import org.eclipse.swt.widgets.TypedListener;

public class ExpandBar
extends Composite {
    ExpandItem[] items = new ExpandItem[4];
    int itemCount;
    ExpandItem focusItem;
    int spacing;
    int yCurrentScroll;
    Font font;
    Color foreground;
    Listener listener = event -> {
        switch (event.type) {
            case 12: {
                this.onDispose(event);
                break;
            }
            case 3: {
                this.onMouseDown(event);
                break;
            }
            case 4: {
                this.onMouseUp(event);
                break;
            }
            case 9: {
                this.onPaint(event);
                break;
            }
            case 11: {
                this.onResize();
                break;
            }
            case 1: {
                this.onKeyDown(event);
                break;
            }
            case 15: {
                this.onFocus();
                break;
            }
            case 16: {
                this.onFocus();
                break;
            }
            case 31: {
                this.onTraverse(event);
            }
        }
    };
    boolean inDispose;

    public ExpandBar(Composite composite, int n) {
        super(composite, ExpandBar.checkStyle(n));
        this.addListener(12, this.listener);
        this.addListener(3, this.listener);
        this.addListener(4, this.listener);
        this.addListener(9, this.listener);
        this.addListener(11, this.listener);
        this.addListener(1, this.listener);
        this.addListener(15, this.listener);
        this.addListener(16, this.listener);
        this.addListener(31, this.listener);
        ScrollBar scrollBar = this.getVerticalBar();
        if (scrollBar != null) {
            scrollBar.addListener(13, event -> this.onScroll(event));
        }
    }

    public void addExpandListener(ExpandListener expandListener) {
        this.checkWidget();
        if (expandListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(expandListener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    static int checkStyle(int n) {
        return n & 0xFFFFFEFF;
    }

    @Override
    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    @Override
    public Point computeSize(int n, int n2, boolean bl) {
        Object object;
        this.checkWidget();
        int n3 = 0;
        int n4 = 0;
        if ((n == -1 || n2 == -1) && this.itemCount > 0) {
            n3 += this.spacing;
            object = new GC(this);
            for (int i = 0; i < this.itemCount; ++i) {
                ExpandItem expandItem = this.items[i];
                n3 += expandItem.getHeaderHeight();
                if (expandItem.expanded) {
                    n3 += expandItem.height;
                }
                n3 += this.spacing;
                n4 = Math.max(n4, expandItem.getPreferredWidth((GC)object));
            }
            ((Resource)object).dispose();
        }
        if (n4 == 0) {
            n4 = 64;
        }
        if (n3 == 0) {
            n3 = 64;
        }
        if (n != -1) {
            n4 = n;
        }
        if (n2 != -1) {
            n3 = n2;
        }
        object = this.computeTrim(0, 0, n4, n3);
        return new Point(((Rectangle)object).width, ((Rectangle)object).height);
    }

    void createItem(ExpandItem expandItem, int n, int n2) {
        if (0 > n2 || n2 > this.itemCount) {
            this.error(6);
        }
        if (this.itemCount == this.items.length) {
            ExpandItem[] expandItemArray = new ExpandItem[this.itemCount + 4];
            System.arraycopy(this.items, 0, expandItemArray, 0, this.items.length);
            this.items = expandItemArray;
        }
        System.arraycopy(this.items, n2, this.items, n2 + 1, this.itemCount - n2);
        this.items[n2] = expandItem;
        ++this.itemCount;
        if (this.focusItem == null) {
            this.focusItem = expandItem;
        }
        expandItem.width = Math.max(0, this.getClientArea().width - this.spacing * 2);
        this.layoutItems(n2, true);
    }

    void destroyItem(ExpandItem expandItem) {
        int n;
        if (this.inDispose) {
            return;
        }
        for (n = 0; n < this.itemCount && this.items[n] != expandItem; ++n) {
        }
        if (n == this.itemCount) {
            return;
        }
        if (expandItem == this.focusItem) {
            int n2;
            int n3 = n2 = n > 0 ? n - 1 : 1;
            if (n2 < this.itemCount) {
                this.focusItem = this.items[n2];
                this.focusItem.redraw();
            } else {
                this.focusItem = null;
            }
        }
        System.arraycopy(this.items, n + 1, this.items, n, --this.itemCount - n);
        this.items[this.itemCount] = null;
        expandItem.redraw();
        this.layoutItems(n, true);
    }

    int getBandHeight() {
        if (this.font == null) {
            return 24;
        }
        GC gC = new GC(this);
        FontMetrics fontMetrics = gC.getFontMetrics();
        gC.dispose();
        return Math.max(24, fontMetrics.getHeight());
    }

    @Override
    public Color getForeground() {
        this.checkWidget();
        if (this.foreground == null) {
            Display display = this.getDisplay();
            return display.getSystemColor(30);
        }
        return this.foreground;
    }

    public ExpandItem getItem(int n) {
        this.checkWidget();
        if (0 > n || n >= this.itemCount) {
            this.error(6);
        }
        return this.items[n];
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public ExpandItem[] getItems() {
        this.checkWidget();
        ExpandItem[] expandItemArray = new ExpandItem[this.itemCount];
        System.arraycopy(this.items, 0, expandItemArray, 0, this.itemCount);
        return expandItemArray;
    }

    public int getSpacing() {
        this.checkWidget();
        return this.spacing;
    }

    public int indexOf(ExpandItem expandItem) {
        this.checkWidget();
        if (expandItem == null) {
            this.error(4);
        }
        for (int i = 0; i < this.itemCount; ++i) {
            if (this.items[i] != expandItem) continue;
            return i;
        }
        return -1;
    }

    void layoutItems(int n, boolean bl) {
        if (n < this.itemCount) {
            ExpandItem expandItem;
            int n2;
            int n3 = this.spacing - this.yCurrentScroll;
            for (n2 = 0; n2 < n; ++n2) {
                expandItem = this.items[n2];
                if (expandItem.expanded) {
                    n3 += expandItem.height;
                }
                n3 += expandItem.getHeaderHeight() + this.spacing;
            }
            for (n2 = n; n2 < this.itemCount; ++n2) {
                expandItem = this.items[n2];
                expandItem.setBounds(this.spacing, n3, 0, 0, true, false);
                if (expandItem.expanded) {
                    n3 += expandItem.height;
                }
                n3 += expandItem.getHeaderHeight() + this.spacing;
            }
        }
        if (bl) {
            this.setScrollbar();
        }
    }

    public void removeExpandListener(ExpandListener expandListener) {
        this.checkWidget();
        if (expandListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, expandListener);
        this.eventTable.unhook(18, expandListener);
    }

    @Override
    void reskinChildren(int n) {
        if (this.items != null) {
            for (int i = 0; i < this.items.length; ++i) {
                ExpandItem expandItem = this.items[i];
                if (expandItem == null) continue;
                expandItem.reskin(n);
            }
        }
        super.reskinChildren(n);
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.font = font;
        this.layoutItems(0, true);
    }

    @Override
    public void setForeground(Color color) {
        super.setForeground(color);
        this.foreground = color;
    }

    void setScrollbar() {
        if (this.itemCount == 0) {
            return;
        }
        ScrollBar scrollBar = this.getVerticalBar();
        if (scrollBar == null) {
            return;
        }
        int n = this.getClientArea().height;
        ExpandItem expandItem = this.items[this.itemCount - 1];
        int n2 = expandItem.y + this.getBandHeight() + this.spacing;
        if (expandItem.expanded) {
            n2 += expandItem.height;
        }
        if (this.yCurrentScroll > 0 && n > n2) {
            this.yCurrentScroll = Math.max(0, this.yCurrentScroll + n2 - n);
            this.layoutItems(0, false);
        }
        int n3 = Math.min(this.yCurrentScroll, n2 += this.yCurrentScroll);
        int n4 = scrollBar.getIncrement();
        int n5 = scrollBar.getPageIncrement();
        scrollBar.setValues(n3, 0, n2, n, n4, n5);
        scrollBar.setVisible(n2 > n);
    }

    public void setSpacing(int n) {
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (n == this.spacing) {
            return;
        }
        this.spacing = n;
        int n2 = Math.max(0, this.getClientArea().width - n * 2);
        for (int i = 0; i < this.itemCount; ++i) {
            ExpandItem expandItem = this.items[i];
            if (expandItem.width == n2) continue;
            expandItem.setBounds(0, 0, n2, expandItem.height, false, true);
        }
        this.layoutItems(0, true);
        this.redraw();
    }

    void showItem(ExpandItem expandItem) {
        Control control = expandItem.control;
        if (control != null && !control.isDisposed()) {
            control.setVisible(expandItem.expanded);
        }
        expandItem.redraw();
        int n = this.indexOf(expandItem);
        this.layoutItems(n + 1, true);
    }

    void onDispose(Event event) {
        this.removeListener(12, this.listener);
        this.notifyListeners(12, event);
        event.type = 0;
        this.inDispose = true;
        for (int i = 0; i < this.itemCount; ++i) {
            this.items[i].dispose();
        }
        this.items = null;
        this.font = null;
        this.foreground = null;
        this.focusItem = null;
    }

    void onFocus() {
        if (this.focusItem != null) {
            this.focusItem.redraw();
        }
    }

    void onKeyDown(Event event) {
        if (this.focusItem == null) {
            return;
        }
        switch (event.keyCode) {
            case 13: 
            case 32: {
                Event event2 = new Event();
                event2.item = this.focusItem;
                this.sendEvent(this.focusItem.expanded ? 18 : 17, event2);
                this.focusItem.expanded = !this.focusItem.expanded;
                this.showItem(this.focusItem);
                break;
            }
            case 0x1000001: {
                int n = this.indexOf(this.focusItem);
                if (n <= 0) break;
                this.focusItem.redraw();
                this.focusItem = this.items[n - 1];
                this.focusItem.redraw();
                break;
            }
            case 0x1000002: {
                int n = this.indexOf(this.focusItem);
                if (n >= this.itemCount - 1) break;
                this.focusItem.redraw();
                this.focusItem = this.items[n + 1];
                this.focusItem.redraw();
                break;
            }
        }
    }

    void onMouseDown(Event event) {
        if (event.button != 1) {
            return;
        }
        int n = event.x;
        int n2 = event.y;
        for (int i = 0; i < this.itemCount; ++i) {
            boolean bl;
            ExpandItem expandItem = this.items[i];
            boolean bl2 = bl = expandItem.x <= n && n < expandItem.x + expandItem.width && expandItem.y <= n2 && n2 < expandItem.y + this.getBandHeight();
            if (!bl || expandItem == this.focusItem) continue;
            this.focusItem.redraw();
            this.focusItem = expandItem;
            this.focusItem.redraw();
            this.forceFocus();
            break;
        }
    }

    void onMouseUp(Event event) {
        boolean bl;
        if (event.button != 1) {
            return;
        }
        if (this.focusItem == null) {
            return;
        }
        int n = event.x;
        int n2 = event.y;
        boolean bl2 = bl = this.focusItem.x <= n && n < this.focusItem.x + this.focusItem.width && this.focusItem.y <= n2 && n2 < this.focusItem.y + this.getBandHeight();
        if (bl) {
            Event event2 = new Event();
            event2.item = this.focusItem;
            this.notifyListeners(this.focusItem.expanded ? 18 : 17, event2);
            this.focusItem.expanded = !this.focusItem.expanded;
            this.showItem(this.focusItem);
        }
    }

    void onPaint(Event event) {
        boolean bl = this.isFocusControl();
        for (int i = 0; i < this.itemCount; ++i) {
            ExpandItem expandItem = this.items[i];
            expandItem.drawItem(event.gc, bl && expandItem == this.focusItem);
        }
    }

    void onResize() {
        Rectangle rectangle = this.getClientArea();
        int n = Math.max(0, rectangle.width - this.spacing * 2);
        for (int i = 0; i < this.itemCount; ++i) {
            ExpandItem expandItem = this.items[i];
            expandItem.setBounds(0, 0, n, expandItem.height, false, true);
        }
        this.setScrollbar();
    }

    void onScroll(Event event) {
        ScrollBar scrollBar = this.getVerticalBar();
        if (scrollBar != null) {
            this.yCurrentScroll = scrollBar.getSelection();
            this.layoutItems(0, false);
        }
    }

    void onTraverse(Event event) {
        switch (event.detail) {
            case 8: 
            case 16: {
                event.doit = true;
            }
        }
    }
}

