/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.cocoa.menu;

import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.cocoa.NSApplication;
import org.eclipse.swt.internal.cocoa.NSMenu;
import org.eclipse.swt.internal.cocoa.NSMenuItem;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.herac.tuxguitar.cocoa.TGCocoa;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.util.TGContext;

public class MacMenu {
    private static final long kAboutMenuItem = 0L;
    private static final long kPreferencesMenuItem = 2L;
    private static long sel_preferencesMenuItemSelected_ = TGCocoa.sel_registerName("preferencesMenuItemSelected:");
    private static long sel_aboutMenuItemSelected_ = TGCocoa.sel_registerName("aboutMenuItemSelected:");
    private boolean enabled;
    private TGContext context;

    public MacMenu(TGContext context) {
        this.context = context;
    }

    public void init() throws Throwable {
        NSApplication app;
        NSMenu mainMenu;
        Callback callback;
        long callbackProc;
        long cls = TGCocoa.objc_lookUpClass("SWTApplicationDelegate");
        if (cls != 0L && (callbackProc = TGCocoa.getCallbackAddress(callback = TGCocoa.newCallback(this, "callbackProc64", "callbackProc32", 3))) != 0L) {
            TGCocoa.class_addMethod(cls, sel_preferencesMenuItemSelected_, callbackProc, "@:@");
            TGCocoa.class_addMethod(cls, sel_aboutMenuItemSelected_, callbackProc, "@:@");
        }
        if (TGCocoa.getMenuNumberOfItems(mainMenu = (app = NSApplication.sharedApplication()).mainMenu()) > 0L) {
            NSMenuItem menuItem;
            NSMenuItem appMenuItem = TGCocoa.getMenuItemAtIndex(mainMenu, 0L);
            NSMenu appMenu = appMenuItem.submenu();
            long itemCount = TGCocoa.getMenuNumberOfItems(appMenu);
            if (itemCount > 2L) {
                menuItem = TGCocoa.getMenuItemAtIndex(appMenu, 2L);
                menuItem.setEnabled(true);
                TGCocoa.setControlAction(menuItem, sel_preferencesMenuItemSelected_);
            }
            if (itemCount > 0L) {
                menuItem = TGCocoa.getMenuItemAtIndex(appMenu, 0L);
                menuItem.setEnabled(true);
                TGCocoa.setControlAction(menuItem, sel_aboutMenuItemSelected_);
            }
        }
        Display.getCurrent().addListener(21, new Listener(){

            public void handleEvent(Event event) {
                MacMenu.this.handleQuitCommand();
                event.doit = false;
            }
        });
    }

    public long callbackProc(long id, long sel, long arg0) {
        if (this.isEnabled()) {
            if (sel == sel_preferencesMenuItemSelected_) {
                return this.handlePreferencesCommand();
            }
            if (sel == sel_aboutMenuItemSelected_) {
                return this.handleAboutCommand();
            }
        }
        return 0L;
    }

    public long callbackProc64(long id, long sel, long arg0) {
        return this.callbackProc(id, sel, arg0);
    }

    public int callbackProc32(int id, int sel, int arg0) {
        return (int)this.callbackProc(id, sel, arg0);
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public long handleQuitCommand() {
        this.executeAction("action.file.exit");
        return 0L;
    }

    public long handleAboutCommand() {
        this.executeAction("action.gui.open-about-dialog");
        return 0L;
    }

    public long handlePreferencesCommand() {
        this.executeAction("action.gui.open-settings-editor");
        return 0L;
    }

    private void executeAction(String actionId) {
        new TGActionProcessor(this.context, actionId).process();
    }
}

