/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.view.dialog.plugin;

import java.util.ArrayList;
import java.util.List;
import org.herac.tuxguitar.app.TuxGuitar;
import org.herac.tuxguitar.app.action.impl.view.TGOpenViewAction;
import org.herac.tuxguitar.app.system.plugins.TGPluginSettingsManager;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.app.view.controller.TGViewContext;
import org.herac.tuxguitar.app.view.dialog.plugin.TGPluginInfoDialog;
import org.herac.tuxguitar.app.view.dialog.plugin.TGPluginInfoDialogController;
import org.herac.tuxguitar.app.view.dialog.plugin.TGPluginSettingsDialogController;
import org.herac.tuxguitar.app.view.util.TGDialogUtil;
import org.herac.tuxguitar.editor.action.TGActionProcessor;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.event.UICheckTableSelectionEvent;
import org.herac.tuxguitar.ui.event.UICheckTableSelectionListener;
import org.herac.tuxguitar.ui.event.UISelectionEvent;
import org.herac.tuxguitar.ui.event.UISelectionListener;
import org.herac.tuxguitar.ui.layout.UILayout;
import org.herac.tuxguitar.ui.layout.UITableLayout;
import org.herac.tuxguitar.ui.resource.UICursor;
import org.herac.tuxguitar.ui.widget.UIButton;
import org.herac.tuxguitar.ui.widget.UICheckTable;
import org.herac.tuxguitar.ui.widget.UIContainer;
import org.herac.tuxguitar.ui.widget.UIControl;
import org.herac.tuxguitar.ui.widget.UIPanel;
import org.herac.tuxguitar.ui.widget.UITableItem;
import org.herac.tuxguitar.ui.widget.UIWindow;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.plugin.TGPlugin;
import org.herac.tuxguitar.util.plugin.TGPluginInfo;
import org.herac.tuxguitar.util.plugin.TGPluginManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGPluginListDialog {
    private static final float TABLE_WIDTH = 400.0f;
    private static final float TABLE_HEIGHT = 300.0f;

    public void show(final TGViewContext context) {
        UIFactory uiFactory = TGApplication.getInstance(context.getContext()).getFactory();
        UIWindow uiParent = (UIWindow)context.getAttribute("parent");
        UITableLayout dialogLayout = new UITableLayout();
        final UIWindow dialog = uiFactory.createWindow(uiParent, true, false);
        dialog.setLayout((UILayout)dialogLayout);
        dialog.setText(TuxGuitar.getProperty("plugins"));
        final UICheckTable table = uiFactory.createCheckTable((UIContainer)dialog, true);
        table.setColumns(2);
        table.setColumnName(0, TuxGuitar.getProperty("plugin.column.enabled"));
        table.setColumnName(1, TuxGuitar.getProperty("plugin.column.name"));
        dialogLayout.set((UIControl)table, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        dialogLayout.set((UIControl)table, "packed_width", (Object)Float.valueOf(400.0f));
        dialogLayout.set((UIControl)table, "packed_height", (Object)Float.valueOf(300.0f));
        for (String moduleId : this.getModuleIds()) {
            TGPluginInfo pluginInfo = new TGPluginInfo(context.getContext(), moduleId);
            String pluginName = pluginInfo.getName();
            if (pluginName == null) {
                pluginName = moduleId;
            }
            UITableItem item = new UITableItem((Object)moduleId);
            item.setText(1, pluginName != null ? pluginName : "Undefined Plugin");
            table.addItem(item);
            table.setCheckedItem(item, TuxGuitar.getInstance().getPluginManager().isEnabled(moduleId));
        }
        UITableLayout buttonsLayout = new UITableLayout(Float.valueOf(0.0f));
        UIPanel buttons = uiFactory.createPanel((UIContainer)dialog, false);
        buttons.setLayout((UILayout)buttonsLayout);
        dialogLayout.set((UIControl)buttons, Integer.valueOf(2), Integer.valueOf(1), UITableLayout.ALIGN_RIGHT, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true));
        final UIButton buttonSetup = uiFactory.createButton((UIContainer)buttons);
        buttonSetup.setText(TuxGuitar.getProperty("configure"));
        buttonSetup.setEnabled(false);
        buttonSetup.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                String moduleId = (String)table.getSelectedValue();
                if (moduleId != null && TGPluginListDialog.this.isConfigurable(moduleId)) {
                    TGPluginListDialog.this.configure(context.getContext(), dialog, moduleId);
                }
            }
        });
        buttonsLayout.set((UIControl)buttonSetup, Integer.valueOf(1), Integer.valueOf(1), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        final UIButton buttonInfo = uiFactory.createButton((UIContainer)buttons);
        buttonInfo.setText(TuxGuitar.getProperty("info"));
        buttonInfo.setDefaultButton();
        buttonInfo.setEnabled(false);
        buttonInfo.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                String moduleId = (String)table.getSelectedValue();
                if (moduleId != null) {
                    TGPluginListDialog.this.showInfo(context.getContext(), dialog, moduleId);
                }
            }
        });
        buttonsLayout.set((UIControl)buttonInfo, Integer.valueOf(1), Integer.valueOf(2), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        UIButton buttonClose = uiFactory.createButton((UIContainer)buttons);
        buttonClose.setText(TuxGuitar.getProperty("close"));
        buttonClose.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                dialog.dispose();
            }
        });
        buttonsLayout.set((UIControl)buttonClose, Integer.valueOf(1), Integer.valueOf(3), UITableLayout.ALIGN_FILL, UITableLayout.ALIGN_FILL, Boolean.valueOf(true), Boolean.valueOf(true), Integer.valueOf(1), Integer.valueOf(1), Float.valueOf(80.0f), Float.valueOf(25.0f), null);
        buttonsLayout.set((UIControl)buttonClose, "margin_right", (Object)Float.valueOf(0.0f));
        table.addSelectionListener(new UISelectionListener(){

            public void onSelect(UISelectionEvent event) {
                String moduleId = (String)table.getSelectedValue();
                buttonInfo.setEnabled(moduleId != null);
                buttonSetup.setEnabled(moduleId != null && TGPluginListDialog.this.isConfigurable(moduleId));
            }
        });
        table.addCheckSelectionListener((UICheckTableSelectionListener)new UICheckTableSelectionListener<String>(){

            public void onSelect(UICheckTableSelectionEvent<String> event) {
                if (event.getSelectedItem() != null) {
                    dialog.setCursor(UICursor.WAIT);
                    UITableItem item = event.getSelectedItem();
                    TGPluginManager.getInstance((TGContext)context.getContext()).updatePluginStatus((String)item.getValue(), table.isCheckedItem(item));
                    table.setSelectedItem(item);
                    dialog.setCursor(UICursor.NORMAL);
                }
            }
        });
        TGDialogUtil.openDialog(dialog, 5);
    }

    private List<String> getModuleIds() {
        ArrayList<String> moduleIds = new ArrayList<String>();
        for (TGPlugin plugin : TuxGuitar.getInstance().getPluginManager().getPlugins()) {
            if (moduleIds.contains(plugin.getModuleId())) continue;
            moduleIds.add(plugin.getModuleId());
        }
        return moduleIds;
    }

    private boolean isConfigurable(String moduleId) {
        return TGPluginSettingsManager.getInstance().containsPluginSettingsHandler(moduleId);
    }

    public void showInfo(TGContext context, UIWindow parent, String moduleId) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.gui.open-view");
        tgActionProcessor.setAttribute(TGOpenViewAction.ATTRIBUTE_CONTROLLER, (Object)new TGPluginInfoDialogController());
        tgActionProcessor.setAttribute("parent", (Object)parent);
        tgActionProcessor.setAttribute(TGPluginInfoDialog.ATTRIBUTE_MODULE_ID, (Object)moduleId);
        tgActionProcessor.process();
    }

    public void configure(TGContext context, UIWindow parent, String moduleId) {
        TGActionProcessor tgActionProcessor = new TGActionProcessor(context, "action.gui.open-view");
        tgActionProcessor.setAttribute(TGOpenViewAction.ATTRIBUTE_CONTROLLER, (Object)new TGPluginSettingsDialogController());
        tgActionProcessor.setAttribute("parent", (Object)parent);
        tgActionProcessor.setAttribute(TGPluginSettingsDialogController.ATTRIBUTE_MODULE_ID, (Object)moduleId);
        tgActionProcessor.process();
    }
}

