/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.app.util;

import org.herac.tuxguitar.app.system.config.TGConfigManager;
import org.herac.tuxguitar.app.system.icons.TGIconManager;
import org.herac.tuxguitar.app.ui.TGApplication;
import org.herac.tuxguitar.ui.UIFactory;
import org.herac.tuxguitar.ui.widget.UISplashWindow;
import org.herac.tuxguitar.util.TGContext;
import org.herac.tuxguitar.util.singleton.TGSingletonFactory;
import org.herac.tuxguitar.util.singleton.TGSingletonUtil;

public class TGSplash {
    private TGContext context;
    private UISplashWindow shell;

    private TGSplash(TGContext context) {
        this.context = context;
    }

    public void init() {
        if (TGConfigManager.getInstance(this.context).getBooleanValue("show.splash")) {
            TGIconManager iconManager = TGIconManager.getInstance(this.context);
            UIFactory uiFactory = TGApplication.getInstance(this.context).getFactory();
            this.shell = uiFactory.createSplashWindow();
            this.shell.setText("TuxGuitar");
            this.shell.setImage(iconManager.getAppIcon());
            this.shell.setSplashImage(iconManager.getAppSplash());
            this.shell.open();
        }
    }

    public void finish() {
        if (this.shell != null && !this.shell.isDisposed()) {
            this.shell.dispose();
        }
        this.context.removeAttribute(TGSplash.class.getName());
    }

    public static TGSplash getInstance(TGContext context) {
        return (TGSplash)TGSingletonUtil.getInstance((TGContext)context, (String)TGSplash.class.getName(), (TGSingletonFactory)new TGSingletonFactory<TGSplash>(){

            public TGSplash createInstance(TGContext context) {
                return new TGSplash(context);
            }
        });
    }
}

