/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.ascii;

import java.io.PrintStream;
import java.io.PrintWriter;

public class ASCIIOutputStream {
    private PrintWriter writer;
    private int x;
    private int y;

    public ASCIIOutputStream(PrintStream stream) {
        this.writer = new PrintWriter(stream);
    }

    public void drawNote(int fret) {
        this.movePoint(this.getPosX() + (fret >= 10 ? 2 : 1), this.getPosY());
        this.writer.print(fret);
    }

    public void drawStringSegments(int count) {
        this.movePoint(this.getPosX() + count, this.getPosY());
        for (int i = 0; i < count; ++i) {
            this.writer.print("-");
        }
    }

    public void drawTuneSegment(String tune, int maxLength) {
        for (int i = tune.length(); i < maxLength; ++i) {
            this.drawSpace();
        }
        this.movePoint(this.getPosX() + tune.length(), this.getPosY());
        this.writer.print(tune);
    }

    public void drawBarSegment() {
        this.movePoint(this.getPosX() + 1, this.getPosY());
        this.writer.print("|");
    }

    public void nextLine() {
        this.movePoint(0, this.getPosY() + 1);
        this.writer.println("");
    }

    public void drawStringLine(String s) {
        this.movePoint(0, this.getPosY() + 1);
        this.writer.println(s);
    }

    public void drawSpace() {
        this.movePoint(this.getPosX() + 1, this.getPosY());
        this.writer.print(" ");
    }

    private void movePoint(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public int getPosX() {
        return this.x;
    }

    public int getPosY() {
        return this.y;
    }

    public void flush() {
        this.writer.flush();
    }

    public void close() {
        this.writer.close();
    }
}

