/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.mozilla;

import org.eclipse.swt.SWTError;
import org.eclipse.swt.internal.mozilla.IIDStore;
import org.eclipse.swt.internal.mozilla.MozillaVersion;
import org.eclipse.swt.internal.mozilla.XPCOM;
import org.eclipse.swt.internal.mozilla.nsID;
import org.eclipse.swt.internal.mozilla.nsIInterfaceInfo;
import org.eclipse.swt.internal.mozilla.nsIInterfaceInfoManager;
import org.eclipse.swt.internal.mozilla.nsIServiceManager;

public class nsISupports {
    static final boolean IsSolaris;
    static final int FIRST_METHOD_ID;
    static final int LAST_METHOD_ID;
    public static final String NS_ISUPPORTS_IID_STR = "00000000-0000-0000-c000-000000000046";
    int address;

    protected static boolean IsXULRunner10() {
        return MozillaVersion.CheckVersion(5, true);
    }

    protected static boolean IsXULRunner24() {
        return MozillaVersion.CheckVersion(6, true);
    }

    protected static boolean IsXULRunner31() {
        return MozillaVersion.CheckVersion(7, true);
    }

    protected static boolean IsXULRVersionOrLater(int n) {
        return MozillaVersion.CheckVersion(n, false);
    }

    private static byte[] toByteArray(String string) {
        byte[] byArray = new byte[string.length() + 1];
        int n = string.length();
        while (n-- > 0) {
            byArray[n] = (byte)string.charAt(n);
        }
        return byArray;
    }

    protected int getGetterIndex(String string) {
        return this.getMethodIndex(string);
    }

    protected int getSetterIndex(String string) {
        return this.getMethodIndex(string) + 1;
    }

    protected String getClassName() {
        return this.getClass().getSimpleName();
    }

    protected int getMethodIndex(String string) {
        int[] nArray = new int[]{0};
        int n = XPCOM.NS_GetServiceManager(nArray);
        if (n != 0) {
            throw new SWTError(n);
        }
        nsIServiceManager nsIServiceManager2 = new nsIServiceManager(nArray[0]);
        nArray[0] = 0;
        n = nsIServiceManager2.GetServiceByContractID(nsISupports.toByteArray("@mozilla.org/xpti/interfaceinfomanager-service;1"), IIDStore.GetIID(nsIInterfaceInfoManager.class), nArray);
        nsIServiceManager2.Release();
        if (n != 0) {
            throw new SWTError(n);
        }
        nsIInterfaceInfoManager nsIInterfaceInfoManager2 = new nsIInterfaceInfoManager(nArray[0]);
        nArray[0] = 0;
        n = nsIInterfaceInfoManager2.GetInfoForName(nsISupports.toByteArray(this.getClassName()), nArray);
        nsIInterfaceInfoManager2.Release();
        if (n != 0) {
            throw new SWTError(n);
        }
        nsIInterfaceInfo nsIInterfaceInfo2 = new nsIInterfaceInfo(nArray[0]);
        int[] nArray2 = new int[1];
        int[] nArray3 = new int[1];
        n = nsIInterfaceInfo2.GetMethodInfoForName(nsISupports.toByteArray(string), nArray2, nArray3);
        nsIInterfaceInfo2.Release();
        if (n != 0) {
            throw new SWTError(n);
        }
        return nArray2[0];
    }

    public nsISupports(int n) {
        this.address = n;
    }

    public int getAddress() {
        return this.address;
    }

    public int QueryInterface(nsID nsID2, int[] nArray) {
        return XPCOM.VtblCall(FIRST_METHOD_ID, this.getAddress(), nsID2, nArray);
    }

    public int AddRef() {
        return XPCOM.VtblCall(FIRST_METHOD_ID + 1, this.getAddress());
    }

    public int Release() {
        return XPCOM.VtblCall(FIRST_METHOD_ID + 2, this.getAddress());
    }

    static {
        String string = System.getProperty("os.name").toLowerCase();
        IsSolaris = string.startsWith("sunos") || string.startsWith("solaris");
        FIRST_METHOD_ID = IsSolaris ? 2 : 0;
        LAST_METHOD_ID = FIRST_METHOD_ID + 2;
        IIDStore.RegisterIID(nsISupports.class, 0, new nsID(NS_ISUPPORTS_IID_STR));
    }
}

