/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.jack.sequencer;

public class JackEvent {
    public static final int ALL_TRACKS = -1;
    public static final int MIDI_SYSTEM_EVENT = 1;
    public static final int MIDI_EVENT_NOTEON = 2;
    public static final int MIDI_EVENT_NOTEOFF = 3;
    public static final int MIDI_EVENT_PROGRAM_CHANGE = 4;
    public static final int MIDI_EVENT_CONTROL_CHANGE = 5;
    public static final int MIDI_EVENT_PITCH_BEND = 6;
    private long tick;
    private int type;
    private int track;
    private byte[] data;

    public JackEvent(long tick, int type, byte[] data) {
        this(tick, type, -1, data);
    }

    public JackEvent(long tick, int type, int track, byte[] data) {
        this.tick = tick;
        this.type = type;
        this.track = track;
        this.data = data;
    }

    public long getTick() {
        return this.tick;
    }

    public int getType() {
        return this.type;
    }

    public int getTrack() {
        return this.track;
    }

    public byte[] getData() {
        return this.data;
    }

    public static JackEvent systemReset(long tick) {
        return new JackEvent(tick, 1, -1, null);
    }

    public static JackEvent noteOn(long tick, int track, int channel, int key, int velocity, int voice, boolean bendMode) {
        return new JackEvent(tick, 2, track, new byte[]{(byte)channel, (byte)key, (byte)velocity, (byte)voice, (byte)(bendMode ? 1 : 0)});
    }

    public static JackEvent noteOff(long tick, int track, int channel, int key, int velocity, int voice, boolean bendMode) {
        return new JackEvent(tick, 3, track, new byte[]{(byte)channel, (byte)key, (byte)velocity, (byte)voice, (byte)(bendMode ? 1 : 0)});
    }

    public static JackEvent pitchBend(long tick, int track, int channel, int value, int voice, boolean bendMode) {
        return new JackEvent(tick, 6, track, new byte[]{(byte)channel, (byte)value, (byte)voice, (byte)(bendMode ? 1 : 0)});
    }

    public static JackEvent controlChange(long tick, int track, int channel, int controller, int value) {
        return new JackEvent(tick, 5, track, new byte[]{(byte)channel, (byte)controller, (byte)value});
    }

    public static JackEvent programChange(long tick, int track, int channel, int value) {
        return new JackEvent(tick, 4, track, new byte[]{(byte)channel, (byte)value});
    }

    public static JackEvent tempoInUSQ(long tick, int usq) {
        return new JackEvent(tick, 1, new byte[]{81, (byte)(usq & 0xFF), (byte)(usq >> 8 & 0xFF), (byte)(usq >> 16 & 0xFF)});
    }
}

