/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.midi.synth;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.herac.tuxguitar.midi.synth.TGAudioBuffer;
import org.herac.tuxguitar.midi.synth.TGAudioProcessor;
import org.herac.tuxguitar.midi.synth.TGAudioProcessorFactory;
import org.herac.tuxguitar.midi.synth.TGAudioProcessorFactoryCallback;
import org.herac.tuxguitar.midi.synth.TGMidiProcessor;
import org.herac.tuxguitar.midi.synth.TGMidiProcessorFactory;
import org.herac.tuxguitar.midi.synth.TGProgram;
import org.herac.tuxguitar.midi.synth.TGProgramElement;
import org.herac.tuxguitar.midi.synth.TGSynthManager;
import org.herac.tuxguitar.util.TGContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TGSynthChannelProcessor {
    private TGAudioBuffer buffer = new TGAudioBuffer();
    private TGMidiProcessor processor;
    private List<TGAudioProcessor> outputs = new ArrayList<TGAudioProcessor>();
    private Map<TGProgramElement, TGAudioProcessor> processorMap = new HashMap<TGProgramElement, TGAudioProcessor>();
    private Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open(final TGContext context, final TGProgram program) {
        Object object = this.lock;
        synchronized (object) {
            this.processor = null;
            this.outputs.clear();
            this.closeOrphanProcessors(program);
            this.openReceiver(context, program.getReceiver(), new TGAudioProcessorFactoryCallback<TGMidiProcessor>(){

                @Override
                public void onCreate(TGMidiProcessor processor) {
                    TGSynthChannelProcessor.this.setMidiProcessor(program.getReceiver(), processor);
                    TGSynthChannelProcessor.this.openOutputs(context, program);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openReceiver(TGContext context, TGProgramElement receiver, TGAudioProcessorFactoryCallback<TGMidiProcessor> callback) {
        Object object = this.lock;
        synchronized (object) {
            TGMidiProcessor mappedProcessor = (TGMidiProcessor)this.getAudioProcessor(receiver);
            if (mappedProcessor != null && mappedProcessor.isOpen()) {
                callback.onCreate(mappedProcessor);
            } else {
                TGSynthManager synthManager = TGSynthManager.getInstance(context);
                TGMidiProcessorFactory factory = synthManager.findMidiProcessorFactory(receiver.getType());
                if (factory != null) {
                    factory.createProcessor(callback);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openOutputs(TGContext context, TGProgram program) {
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < program.countOutputs(); ++i) {
                this.openOutput(context, program.getOutput(i));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openOutput(TGContext context, final TGProgramElement output) {
        Object object = this.lock;
        synchronized (object) {
            this.openOutput(context, output, new TGAudioProcessorFactoryCallback<TGAudioProcessor>(){

                @Override
                public void onCreate(TGAudioProcessor processor) {
                    TGSynthChannelProcessor.this.addOutputProcessor(output, processor);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openOutput(TGContext context, TGProgramElement output, TGAudioProcessorFactoryCallback<TGAudioProcessor> callback) {
        Object object = this.lock;
        synchronized (object) {
            TGAudioProcessor mappedProcessor = this.getAudioProcessor(output);
            if (mappedProcessor != null && mappedProcessor.isOpen()) {
                callback.onCreate(mappedProcessor);
            } else {
                TGSynthManager synthManager = TGSynthManager.getInstance(context);
                TGAudioProcessorFactory factory = synthManager.findAudioProcessorFactory(output.getType());
                if (factory != null) {
                    factory.createProcessor(callback);
                }
            }
        }
    }

    public void setMidiProcessor(TGProgramElement element, TGMidiProcessor processor) {
        this.processor = processor;
        this.addProcessor(element, processor);
    }

    public void addOutputProcessor(TGProgramElement element, TGAudioProcessor processor) {
        this.addOutput(processor);
        this.addProcessor(element, processor);
    }

    public void addProcessor(TGProgramElement element, TGAudioProcessor processor) {
        this.processorMap.put(element, processor);
        this.restoreParameters(element, processor);
    }

    public void restoreParameters(TGProgramElement element, TGAudioProcessor processor) {
        if (element.getParameters() != null) {
            processor.restoreParameters(element.getParameters());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            this.closeOrphanProcessors(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOrphanProcessors(TGProgram program) {
        Object object = this.lock;
        synchronized (object) {
            HashMap<TGProgramElement, TGAudioProcessor> mappedProcessors = new HashMap<TGProgramElement, TGAudioProcessor>(this.processorMap);
            for (TGProgramElement element : mappedProcessors.keySet()) {
                if (!this.shouldCloseProcessor(program, element)) continue;
                this.closeProcessor(element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeProcessor(TGProgramElement element) {
        Object object = this.lock;
        synchronized (object) {
            TGAudioProcessor mappedProcessor = this.getAudioProcessor(element);
            if (mappedProcessor != null) {
                mappedProcessor.close();
                mappedProcessor.finalize();
                this.processorMap.remove(element);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldCloseProcessor(TGProgram program, TGProgramElement element) {
        Object object = this.lock;
        synchronized (object) {
            if (program != null) {
                if (program.getReceiver() != null && program.getReceiver().equals(element)) {
                    return false;
                }
                for (int i = 0; i < program.countOutputs(); ++i) {
                    if (!program.getOutput(i).equals(element)) continue;
                    return false;
                }
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TGAudioProcessor getAudioProcessor(TGProgramElement element) {
        Object object = this.lock;
        synchronized (object) {
            if (this.processorMap.containsKey(element)) {
                return this.processorMap.get(element);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TGMidiProcessor getProcessor() {
        Object object = this.lock;
        synchronized (object) {
            return this.processor;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutput(TGAudioProcessor effect) {
        Object object = this.lock;
        synchronized (object) {
            if (effect != null) {
                this.outputs.add(effect);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TGAudioProcessor getOutput(int index) {
        Object object = this.lock;
        synchronized (object) {
            if (index >= 0 && index < this.outputs.size()) {
                return this.outputs.get(index);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int countOutputs() {
        Object object = this.lock;
        synchronized (object) {
            return this.outputs.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fillBuffer(TGAudioBuffer buffer) {
        Object object = this.lock;
        synchronized (object) {
            if (this.processor != null && this.processor.isOpen()) {
                this.buffer.clear();
                this.processor.fillBuffer(this.buffer);
                for (int i = 0; i < this.countOutputs(); ++i) {
                    this.getOutput(i).fillBuffer(this.buffer);
                }
                buffer.mix(this.buffer);
            }
        }
    }
}

